/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.IPatchList;
import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchList;

public class PatchListImpl
extends IPatchList
implements PatchList {
    protected static final long serialVersionUID = -5459272452524020673L;
    protected String text;

    public PatchListImpl() {
        this("");
        this.text = "";
    }

    public PatchListImpl(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public boolean hasAnyErrors() {
        int n = 0;
        while (n < this.patchlist.size()) {
            if (((IPatch)this.patchlist.elementAt(n)).hasError()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Patch getPatchAt(int n) throws NoSuchPatchException {
        if (n >= this.patchlist.size()) {
            throw new NoSuchPatchException("");
        }
        return (Patch)this.patchlist.elementAt(n);
    }

    public Patch getPatchByPatchID(PatchID patchID) throws NoSuchPatchException {
        IPatch iPatch = this.getIPatchByID(patchID);
        if (iPatch == null) {
            throw new NoSuchPatchException("");
        }
        return iPatch;
    }

    public boolean hasErrorAt(int n) throws NoSuchPatchException {
        IPatch iPatch = (IPatch)this.getPatchAt(n);
        if (iPatch == null) {
            throw new NoSuchPatchException("");
        }
        return iPatch.hasError();
    }

    public String getErrorAt(int n) throws NoSuchPatchException {
        IPatch iPatch = (IPatch)this.getPatchAt(n);
        if (iPatch == null) {
            throw new NoSuchPatchException("");
        }
        return iPatch.getError();
    }

    public void setErrorAt(int n, String string) {
        IPatch iPatch = null;
        try {
            iPatch = (IPatch)this.getPatchAt(n);
            iPatch.setError(string);
        }
        catch (NoSuchPatchException noSuchPatchException) {}
    }

    public void setSelectionStatus(int n, boolean bl) throws NoSuchPatchException {
        IPatch iPatch = (IPatch)this.getPatchAt(n);
        if (iPatch == null) {
            throw new NoSuchPatchException("");
        }
        iPatch.setSelectionStatus(bl);
    }

    public boolean getSelectionStatus(int n) throws NoSuchPatchException {
        IPatch iPatch = (IPatch)this.getPatchAt(n);
        if (iPatch == null) {
            throw new NoSuchPatchException("");
        }
        return iPatch.getSelectionStatus();
    }

    public void addAndSelectIPatch(IPatch iPatch) {
        this.patchlist.addElement(iPatch);
        try {
            this.setSelectionStatus(this.patchlist.indexOf(iPatch), true);
        }
        catch (NoSuchPatchException noSuchPatchException) {}
    }

    public PatchImpl getPatchImplAt(int n) {
        if (n >= this.patchlist.size()) {
            return null;
        }
        return (PatchImpl)this.patchlist.elementAt(n);
    }

    public PatchListImpl getCopy() {
        PatchListImpl patchListImpl;
        try {
            patchListImpl = (PatchListImpl)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            patchListImpl = null;
        }
        return patchListImpl;
    }

    public boolean equals(PatchList patchList) {
        boolean bl = true;
        int n = 0;
        while (n < this.patchlist.size()) {
            String string = null;
            String string2 = null;
            try {
                string = this.getErrorAt(n);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                // empty catch block
            }
            try {
                string2 = patchList.getErrorAt(n);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                // empty catch block
            }
            if (string == null && string2 != null || string != null && string2 == null) {
                bl = false;
                break;
            }
            if (string != null && string2 != null && string.compareTo(string2) != 0) {
                bl = false;
                break;
            }
            Patch patch = null;
            Patch patch2 = null;
            try {
                patch = this.getPatchAt(n);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                // empty catch block
            }
            try {
                patch2 = patchList.getPatchAt(n);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                // empty catch block
            }
            if (patch == null && patch2 != null || patch != null && patch2 == null) {
                bl = false;
                break;
            }
            if (patch != null && patch2 != null && !patch.equals(patch2)) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }
}

