/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.util.LocalizedMessages;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;

public class PatchProperties
implements Serializable {
    public static final String SUN_TARGET_FORMAT = "sun";
    public static final String STANDARD_TYPE = "standard";
    public static final String SINGLEUSER_TYPE = "singleuser";
    public static final String REBOOTAFTER_TYPE = "rebootafter";
    public static final String RECONFIGAFTER_TYPE = "reconfigafter";
    public static final String REBOOTIMMEDIATE_TYPE = "rebootimmediate";
    public static final String RECONFIGIMMEDIATE_TYPE = "reconfigimmediate";
    public static final String INTERACTIVE_TYPE = "interactive";
    public static final String NONSTANDARD_TYPE = "nonstandard";
    public static final String CLIENTROOT_TYPE = "clientroot";
    public static final String CLIENTUSR_TYPE = "clientusr";
    public static final String NONCONTRACT_TYPE = "noncontract";
    public static final String POINTPATCH_TYPE = "pointpatch";
    public static final String DISCONTINUED_TYPE = "discontinued";
    public static final String OBSOLETE_TYPE = "obsolete";
    private boolean clientusr;
    private boolean clientroot;
    private boolean discontinued;
    private boolean interactive = false;
    private boolean nonstandard = false;
    private boolean singleuser = false;
    private boolean pointpatch = false;
    private boolean obsolete;
    private boolean noncontract;
    private boolean rebootafter;
    private boolean rebootimmediate;
    private boolean reconfigafter;
    private boolean reconfigimmediate;
    private boolean others = false;
    private String otherProperties = "";
    private String targetformat = "sun";

    public PatchProperties(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.compareTo(DISCONTINUED_TYPE) == 0) {
                this.discontinued = true;
                continue;
            }
            if (string2.compareTo(CLIENTROOT_TYPE) == 0) {
                this.clientroot = true;
                continue;
            }
            if (string2.compareTo(CLIENTUSR_TYPE) == 0) {
                this.clientusr = true;
                continue;
            }
            if (string2.compareTo(INTERACTIVE_TYPE) == 0) {
                this.interactive = true;
                continue;
            }
            if (string2.compareTo(NONSTANDARD_TYPE) == 0) {
                this.nonstandard = true;
                continue;
            }
            if (string2.compareTo(SINGLEUSER_TYPE) == 0) {
                this.singleuser = true;
                continue;
            }
            if (string2.compareTo(POINTPATCH_TYPE) == 0) {
                this.pointpatch = true;
                continue;
            }
            if (string2.compareTo(OBSOLETE_TYPE) == 0) {
                this.obsolete = true;
                continue;
            }
            if (string2.compareTo(NONCONTRACT_TYPE) == 0) {
                this.noncontract = true;
                continue;
            }
            if (string2.compareTo(REBOOTAFTER_TYPE) == 0) {
                this.rebootafter = true;
                continue;
            }
            if (string2.compareTo(REBOOTIMMEDIATE_TYPE) == 0) {
                this.rebootimmediate = true;
                continue;
            }
            if (string2.compareTo(RECONFIGAFTER_TYPE) == 0) {
                this.reconfigafter = true;
                continue;
            }
            if (string2.compareTo(RECONFIGIMMEDIATE_TYPE) == 0) {
                this.reconfigimmediate = true;
                continue;
            }
            if (string2.toLowerCase().indexOf("targetformat=") != -1) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2.toLowerCase(), "=");
                String string3 = SUN_TARGET_FORMAT;
                while (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                }
                this.targetformat = string3;
                continue;
            }
            this.others = true;
            this.otherProperties = this.otherProperties + " " + string2;
        }
        this.otherProperties = this.otherProperties.trim();
    }

    public boolean isDiscontinued() {
        return this.discontinued;
    }

    public boolean isClientroot() {
        return this.clientroot;
    }

    public boolean isClientusr() {
        return this.clientusr;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean isNonstandard() {
        return this.nonstandard;
    }

    public boolean isSingleuser() {
        return this.singleuser;
    }

    public boolean isPointpatch() {
        return this.pointpatch;
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public boolean isNoncontract() {
        return this.noncontract;
    }

    public boolean isRebootafter() {
        return this.rebootafter;
    }

    public boolean isRebootimmediate() {
        return this.rebootimmediate;
    }

    public boolean isReconfigafter() {
        return this.reconfigafter;
    }

    public boolean isReconfigimmediate() {
        return this.reconfigimmediate;
    }

    public boolean isStandard() {
        return !this.isPointpatch() && !this.isObsolete() && !this.isDiscontinued() && !this.isNonstandard() && !this.isInteractive() && !this.isSingleuser() && !this.isRebootafter() && !this.isRebootimmediate() && !this.isReconfigafter() && !this.isReconfigimmediate();
    }

    public boolean hasOthers() {
        return this.others;
    }

    public String getOthers() {
        return this.otherProperties;
    }

    public String getTargetFormat() {
        return this.targetformat;
    }

    public boolean equals(PatchProperties patchProperties) {
        if (this.clientroot != patchProperties.isClientroot()) {
            return false;
        }
        if (this.clientusr != patchProperties.isClientusr()) {
            return false;
        }
        if (this.interactive != patchProperties.isInteractive()) {
            return false;
        }
        if (this.nonstandard != patchProperties.isNonstandard()) {
            return false;
        }
        if (this.singleuser != patchProperties.isSingleuser()) {
            return false;
        }
        if (this.pointpatch != patchProperties.isPointpatch()) {
            return false;
        }
        if (this.obsolete != patchProperties.isObsolete()) {
            return false;
        }
        if (this.noncontract != patchProperties.isNoncontract()) {
            return false;
        }
        if (this.rebootafter != patchProperties.isRebootafter()) {
            return false;
        }
        if (this.rebootimmediate != patchProperties.isRebootimmediate()) {
            return false;
        }
        if (this.reconfigafter != patchProperties.isReconfigafter()) {
            return false;
        }
        if (this.reconfigimmediate != patchProperties.isReconfigimmediate()) {
            return false;
        }
        if (this.discontinued != patchProperties.isDiscontinued()) {
            return false;
        }
        if (this.others != patchProperties.hasOthers()) {
            return false;
        }
        if (!this.targetformat.equals(patchProperties.getTargetFormat())) {
            return false;
        }
        if (this.otherProperties != null && patchProperties.getOthers() != null) {
            String string = this.otherProperties.trim();
            String string2 = patchProperties.getOthers().trim();
            if (string != "" && string2 != "" ? !PatchInfoImpl.isStringListEqual(this.otherProperties, patchProperties.getOthers()) : string.compareTo(string2) != 0) {
                return false;
            }
        }
        return true;
    }

    public Vector getAllTypes() {
        Vector<String> vector = new Vector<String>();
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        LocalizedMessages localizedMessages = new LocalizedMessages(patchProProperties.getLocale());
        if (this.isStandard() && !vector.contains(localizedMessages.getMessage("patch_properties.standard", STANDARD_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.standard", STANDARD_TYPE));
        }
        if (this.isNonstandard() && !vector.contains(localizedMessages.getMessage("patch_properties.nonstandard", NONSTANDARD_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.nonstandard", NONSTANDARD_TYPE));
        }
        if (this.isInteractive() && !vector.contains(localizedMessages.getMessage("patch_properties.interactive", INTERACTIVE_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.interactive", INTERACTIVE_TYPE));
        }
        if (this.isSingleuser() && !vector.contains(localizedMessages.getMessage("patch_properties.singleuser", SINGLEUSER_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.singleuser", SINGLEUSER_TYPE));
        }
        if (this.isRebootafter() && !vector.contains(localizedMessages.getMessage("patch_properties.rebootafter", REBOOTAFTER_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.rebootafter", REBOOTAFTER_TYPE));
        }
        if (this.isRebootimmediate() && !vector.contains(localizedMessages.getMessage("patch_properties.rebootimmediate", REBOOTIMMEDIATE_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.rebootimmediate", REBOOTIMMEDIATE_TYPE));
        }
        if (this.isReconfigafter() && !vector.contains(localizedMessages.getMessage("patch_properties.reconfigafter", RECONFIGAFTER_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.reconfigafter", RECONFIGAFTER_TYPE));
        }
        if (this.isReconfigimmediate() && !vector.contains(localizedMessages.getMessage("patch_properties.reconfigimmediate", RECONFIGIMMEDIATE_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.reconfigimmediate", RECONFIGIMMEDIATE_TYPE));
        }
        if (this.isNoncontract() && !vector.contains(localizedMessages.getMessage("patch_properties.noncontract", NONCONTRACT_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.noncontract", NONCONTRACT_TYPE));
        }
        if (this.isClientusr() && !vector.contains(localizedMessages.getMessage("patch_properties.clientusr", CLIENTUSR_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.clientusr", CLIENTUSR_TYPE));
        }
        if (this.isClientroot() && !vector.contains(localizedMessages.getMessage("patch_properties.clientroot", CLIENTROOT_TYPE))) {
            vector.addElement(localizedMessages.getMessage("patch_properties.clientroot", CLIENTROOT_TYPE));
        }
        return vector;
    }
}

