/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.host.SessionData;
import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.DownloadPatchEvent;
import com.sun.patchpro.model.DownloadPatchListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.util.BundleDownloader;
import com.sun.patchpro.util.LocalizedMessages;
import com.sun.patchpro.util.Percentage;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class GroupPatchDownloader
implements DownloadPatchListener {
    private int hostCount = 1;
    private int hostsRemaining = 1;
    private Percentage progress = new Percentage(0);
    private PatchServerProxy patchServerProxy;
    private BundleDownloader bundleDownloader;
    private Vector listeners;
    private PatchProLog log;
    private PatchProProperties properties;
    private LocalizedMessages msgcat;
    private boolean cancel = false;
    private ReadOnlyHost targetHost;
    private PatchProModel model;

    public GroupPatchDownloader(PatchProModel patchProModel, ReadOnlyHost readOnlyHost) {
        this.properties = readOnlyHost.getSessionData().getProperties();
        this.log = PatchProLog.getInstance();
        this.listeners = new Vector();
        this.targetHost = readOnlyHost;
        this.model = patchProModel;
        this.msgcat = new LocalizedMessages(this.properties.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void downloadPatches() throws Exception {
        Object object;
        boolean bl = true;
        this.hostCount = this.hostsRemaining = this.targetHost.getAssociateCount() + 1;
        this.log.println(this, 7, "There are " + this.hostCount + " hosts.");
        SessionData sessionData = this.targetHost.getSessionData();
        PatchProProperties patchProProperties = sessionData.getProperties();
        PatchList patchList = sessionData.getPatchesRequired();
        bl = patchProProperties.getProperty("patchpro.patch.download.authenticate", "true").equals("true");
        String string = sessionData.getLatestDownloadDestination().getPath();
        this.log.println(this, 7, "Current patch list is " + patchList);
        PatchServerProxy patchServerProxy = this.patchServerProxy = new PatchServerProxy(patchProProperties);
        this.bundleDownloader = null;
        try {
            this.patchServerProxy.addDownloadPatchListener(this);
            this.log.println(this, 7, "Calling patchServerProxy.downloadPatches(" + patchList + ", " + string + ", " + sessionData + ")");
            this.patchServerProxy.downloadPatches(patchList, string, sessionData);
        }
        catch (DownloadPatchException downloadPatchException) {
            this.log.printStackTrace(this, 2, downloadPatchException);
            sessionData.setPatchesUnavailable(patchList, this.msgcat.getMessage("PsUnavailablePatch", "This patch could not be found"));
            this.model.setPatchProFailure(downloadPatchException);
        }
        catch (NotSupportedException notSupportedException) {
            this.log.printStackTrace(this, 2, notSupportedException);
            sessionData.setPatchesUnavailable(patchList, this.msgcat.getMessage("PsUnavailablePatch", "This patch could not be found"));
            this.model.setPatchProFailure(notSupportedException);
        }
        finally {
            this.patchServerProxy.removeDownloadPatchListener(this);
            object = (String)this.patchServerProxy.getDownloadDestination();
            File file = new File((String)object);
            sessionData.setLatestDownloadDestination(file);
        }
        Collection collection = patchServerProxy.getPatchProExceptions();
        if (collection != null) {
            sessionData.setPatchProExceptions(collection);
        }
        Enumeration enumeration = this.targetHost.getAssociates();
        while (enumeration.hasMoreElements()) {
            object = (ReadOnlyHost)enumeration.nextElement();
            collection = null;
            sessionData = object.getSessionData();
            patchProProperties = sessionData.getProperties();
            patchList = sessionData.getPatchesRequired();
            bl = patchProProperties.getProperty("patchpro.patch.download.authenticate", "true").equals("true");
            string = patchProProperties.getProperty("patchpro.download.directory", "/var/sadm/spool");
            patchServerProxy = this.patchServerProxy = new PatchServerProxy(patchProProperties);
            this.bundleDownloader = null;
            try {
                this.patchServerProxy.addDownloadPatchListener(this);
                this.log.println(this, 7, "Hosts remaining: " + this.hostsRemaining);
                this.log.println(this, 7, "Calling patchServerProxy.downloadPatches(" + patchList + ", " + string + ", " + sessionData + ")");
                this.patchServerProxy.downloadPatches(patchList, string, sessionData);
            }
            catch (DownloadPatchException downloadPatchException) {
                this.log.printStackTrace(this, 2, downloadPatchException);
                sessionData.setPatchesUnavailable(patchList, this.msgcat.getMessage("PsUnavailablePatch", "This patch could not be found"));
                this.model.setPatchProFailure(downloadPatchException);
            }
            catch (NotSupportedException notSupportedException) {
                this.log.printStackTrace(this, 2, notSupportedException);
                sessionData.setPatchesUnavailable(patchList, this.msgcat.getMessage("PsUnavailablePatch", "This patch could not be found"));
                this.model.setPatchProFailure(notSupportedException);
            }
            finally {
                this.patchServerProxy.removeDownloadPatchListener(this);
                String string2 = (String)this.patchServerProxy.getDownloadDestination();
                File file = new File(string2);
                sessionData.setLatestDownloadDestination(file);
            }
            collection = patchServerProxy.getPatchProExceptions();
            if (collection == null) continue;
            sessionData.setPatchProExceptions(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        GroupPatchDownloader groupPatchDownloader = this;
        synchronized (groupPatchDownloader) {
            this.cancel = true;
        }
    }

    public Percentage getStatus() {
        return this.progress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.addElement(downloadPatchListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadPatchListener(DownloadPatchListener downloadPatchListener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.removeElement(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadPatchProgress(DownloadPatchEvent downloadPatchEvent) {
        int n = downloadPatchEvent == null ? 100 : (this.patchServerProxy != null ? 100 : (this.bundleDownloader != null ? ((BundleDownloader)downloadPatchEvent.getSource()).getStatus().getPercentage() : 100));
        Percentage percentage = this.progress;
        synchronized (percentage) {
            this.progress = new Percentage((int)(((double)(this.hostCount - this.hostsRemaining) * 100.0 + (double)n) / (double)this.hostCount));
        }
        System.out.println(this.progress);
        this.dispatchProgressEvent(new DownloadPatchEvent(this));
    }

    public void downloadPatchDone(DownloadPatchEvent downloadPatchEvent) {
        if (--this.hostsRemaining == 0) {
            this.dispatchDoneEvent(new DownloadPatchEvent(this));
        }
    }

    public void downloadPatchFailed(DownloadPatchEvent downloadPatchEvent) {
        this.dispatchFailedEvent(downloadPatchEvent);
    }

    private void dispatchProgressEvent(DownloadPatchEvent downloadPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchProgress(downloadPatchEvent);
        }
    }

    private void dispatchDoneEvent(DownloadPatchEvent downloadPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchDone(downloadPatchEvent);
        }
    }

    private void dispatchFailedEvent(DownloadPatchEvent downloadPatchEvent) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            DownloadPatchListener downloadPatchListener = (DownloadPatchListener)enumeration.nextElement();
            downloadPatchListener.downloadPatchFailed(downloadPatchEvent);
        }
    }
}

