/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.server;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.patch.IPatch;
import com.sun.patchpro.patch.MalformedPatchException;
import com.sun.patchpro.patch.PatchBundleInfo;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.patch.PatchInfoImpl;
import com.sun.patchpro.patch.PatchListImpl;
import com.sun.patchpro.patch.PatchProperties;
import com.sun.patchpro.patch.SecurePatchListImpl;
import com.sun.patchpro.server.DownloadPatchException;
import com.sun.patchpro.server.NotSupportedException;
import com.sun.patchpro.server.PatchServerProxy;
import com.sun.patchpro.server.PatchServerProxyException;
import com.sun.patchpro.server.PatchServerServletProperties;
import com.sun.patchpro.server.ServletLog;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class PatchProServerServlet
extends HttpServlet
implements SingleThreadModel {
    protected static final String VERSION_2_0 = "2.0";
    protected static final String VERSION_2_1 = "2.1";
    public static final String DEFAULT_REQUESTED_DB_NAME = "patchprodb";
    public static final String DEFAULT_REQUESTED_DETECTORS_NAME = "pprodetectors";
    protected String protocolVersion = "";
    protected PatchProLog log;
    protected PatchServerServletProperties properties;
    protected PatchServerProxy patchServerProxy;
    public static final int SUCCESS = 0;
    public static final int DUPLICATE_PARAMETER = 4;
    public static final int INVALID_PARAMETER = 8;
    public static final int INVALID_REQUEST = 16;
    public static final int MISSING_PARAMETER = 32;
    public static final int MISSING_VALUE = 36;
    public static final int IO_EXCEPTION = 48;
    public static final int EXCEPTION = 64;
    public static final int MALFORMED_PATCH_EXCEPTION = 100;
    public static final int DOWNLOADPATCH_EXCEPTION = 110;
    public static final int NOT_SUPPORTED_EXCEPTION = 120;
    public static final int PATCHBUNDLE_INFO_UNAVAILABLE = 130;
    public static final int EXPIRED_CERTIFICATE = 200;
    public static final int GOOD_CERTIFICATE = 201;
    public static final int DOWNLOADPATCHDB_EXCEPTION = 300;
    public static final int DOWNLOAD_REALIZATION_EXCEPTION = 400;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doPost(httpServletRequest, httpServletResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        block70: {
            try {
                String string;
                Object object;
                String[] stringArray;
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 0);
                httpServletResponse.setStatus(200);
                String[] stringArray2 = httpServletRequest.getParameterValues("version");
                if (stringArray2 == null || stringArray2.length == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray2[0].compareTo(VERSION_2_0) == 0) {
                    this.protocolVersion = VERSION_2_0;
                } else if (stringArray2[0].compareTo(VERSION_2_1) == 0) {
                    this.protocolVersion = VERSION_2_1;
                } else {
                    this.log.println((Object)this, 3, "Invalid request: Invalid version specified.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                String string2 = null;
                String string3 = null;
                String string4 = httpServletRequest.getHeader("Authorization");
                if (string4 != null && string4.toLowerCase().startsWith("basic ")) {
                    stringArray = string4.substring(6).trim();
                    object = new BASE64Decoder();
                    string = new String(object.decodeBuffer((String)stringArray));
                    int n = string.indexOf(":");
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                    this.log.println((Object)this, 7, "UserID from Auth header" + string2);
                }
                this.log.println((Object)this, 6, "Protocol version: " + this.protocolVersion);
                stringArray = httpServletRequest.getParameterValues("action");
                if (stringArray == null || stringArray.length > 1) {
                    this.log.println((Object)this, 3, "Invalid request: Either the \"action\" parameter was not specified or multiple \"action\" parameters were detected.");
                    httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                    httpServletResponse.sendError(400);
                    return;
                }
                if (stringArray[0].compareTo("patchDownload") == 0) {
                    String[] stringArray3;
                    String[] stringArray4;
                    object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("patchId") || string.equals("user") || string.equals("passwd") || string.equals("text") || string.equals("maxSize") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: Unknown parameter \"" + string + "\" was detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = "";
                    if (this.protocolVersion.compareTo(VERSION_2_0) == 0) {
                        String[] stringArray5 = httpServletRequest.getParameterValues("user");
                        stringArray4 = httpServletRequest.getParameterValues("passwd");
                        if (stringArray5 != null) {
                            if (stringArray5.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"user\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray5[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"user\" parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string2 = stringArray5[0];
                        }
                        if (stringArray4 != null) {
                            if (stringArray4.length > 1) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"passwd\" parameters were  detected.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            if (stringArray4[0].equals("")) {
                                this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"passwd\"  parameter.");
                                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                                httpServletResponse.sendError(400);
                                return;
                            }
                            string3 = stringArray4[0];
                        }
                    }
                    if (this.protocolVersion.compareTo(VERSION_2_0) != 0 && (stringArray4 = httpServletRequest.getParameterValues("maxSize")) != null && stringArray4.length > 0) {
                        this.log.println((Object)this, 7, "maxSize specified: " + stringArray4[0]);
                    }
                    if ((stringArray3 = httpServletRequest.getParameterValues("text")) != null) {
                        if (stringArray3.length > 1) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Multiple \"text\" parameters were detected.");
                            httpServletResponse.sendError(400);
                            return;
                        }
                        if (stringArray3[0].equals("")) {
                            this.log.println((Object)this, 3, "Invalid  \"patchDownload\" request: Value was not specified for the specified \"text\" parameter.");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        string = stringArray3[0];
                    }
                    if ((stringArray4 = httpServletRequest.getParameterValues("patchId")) == null || string2 != null && string3 == null || string2 == null && string3 != null) {
                        this.log.println((Object)this, 3, "Invalid \"patchDownload\" request: A required \"patchID\", \"user\" and/or \"passwd\" parameter was not specified");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    PatchListImpl patchListImpl = null;
                    patchListImpl = string2 != null ? new SecurePatchListImpl(string2, string3, string) : new PatchListImpl(string);
                    PatchInfoImpl patchInfoImpl = new PatchInfoImpl();
                    patchInfoImpl.setObsolesces("");
                    patchInfoImpl.setRequires("");
                    patchInfoImpl.setOS("");
                    patchInfoImpl.setProperties(new PatchProperties(""));
                    int n = 0;
                    while (n < stringArray4.length) {
                        try {
                            patchListImpl.addIPatch(new IPatch(new PatchImpl(patchInfoImpl, new PatchID(stringArray4[n]))));
                            patchListImpl.setSelectionStatus(n, true);
                        }
                        catch (MalformedPatchException malformedPatchException) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Exception: " + malformedPatchException);
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 100);
                            httpServletResponse.sendError(500);
                            return;
                        }
                        ++n;
                    }
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    httpServletResponse.setContentType("application/octet-stream");
                    PatchBundleInfo[] patchBundleInfoArray = this.patchServerProxy.getDownloadedPatchBundlesInfo(patchListImpl);
                    this.log.println((Object)this, 7, "patchList.size: " + patchListImpl.size());
                    if (patchBundleInfoArray == null) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot access patch bundle information.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 130);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    int n2 = 200;
                    String string5 = "";
                    String string6 = "";
                    int n3 = 0;
                    while (n3 < patchBundleInfoArray.length) {
                        long l = patchBundleInfoArray[n3].getPatchBundleSize();
                        if (l < 0L) {
                            if (!string6.equals("")) {
                                string6 = string6 + "|";
                            }
                            String string7 = patchBundleInfoArray[n3].getPatchBundleName();
                            string6 = string6 + string7.substring(0, string7.indexOf(".")) + "&" + Long.toString(-l);
                            n2 = 206;
                        } else {
                            if (!string5.equals("")) {
                                string5 = string5 + "|";
                            }
                            string5 = string5 + patchBundleInfoArray[n3].getPatchBundleName() + "&" + Long.toString(l);
                        }
                        ++n3;
                    }
                    this.log.println((Object)this, 7, "patchFiles: " + string5);
                    this.log.println((Object)this, 7, "rejects: " + string6);
                    httpServletResponse.setHeader("patchFiles", string5);
                    if (this.protocolVersion.compareTo(VERSION_2_1) == 0 && string6.compareTo("") != 0) {
                        httpServletResponse.setHeader("rejects", string6);
                    }
                    httpServletResponse.setStatus(n2);
                    try {
                        this.patchServerProxy.downloadPatches(patchListImpl, servletOutputStream);
                    }
                    catch (DownloadPatchException downloadPatchException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. Cannot download patch bundle.");
                        this.log.printStackTrace((Object)this, 3, downloadPatchException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 110);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (NotSupportedException notSupportedException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. \"patchDownload\" request is not supported.");
                        this.log.printStackTrace((Object)this, 3, notSupportedException);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 120);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    catch (Exception exception) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"patchDownload\" request. ");
                        this.log.printStackTrace((Object)this, 3, exception);
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                        httpServletResponse.sendError(500);
                        return;
                    }
                    this.log.println((Object)this, 7, "PatchProServerServlet.patchDownload done. Status: " + n2);
                    break block70;
                }
                if (stringArray[0].compareTo("isCertificateRevoked") == 0) {
                    this.log.println((Object)this, 7, "Received a isCertificateRevoked request.");
                    object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("serialNumber") || string.equals("version")) continue;
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Unknown parameter \"" + string + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = null;
                    String[] stringArray6 = httpServletRequest.getParameterValues("serialNumber");
                    if (stringArray6 == null) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: The required \"serialNumber\" parameter was not specified.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 32);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray6[0].equals("")) {
                        this.log.println((Object)this, 3, "Invalid  \"isCertificateRevoked\" request: Value was not specified for thespecified \"serialNumber\" parameter.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 36);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    if (stringArray6.length > 1) {
                        this.log.println((Object)this, 3, "Invalid \"isCertificateRevoked\" request: Multiple \"serialNumber\" parameters are not allowed.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 4);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = stringArray6[0];
                    if (this.patchServerProxy.isCertificateRevoked(string)) {
                        this.log.println((Object)this, 6, "Certificate has been revoked for " + string);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 200);
                    } else {
                        this.log.println((Object)this, 6, "This certificate is good: " + string);
                        httpServletResponse.setIntHeader("patchproServiceCompletionCode", 201);
                    }
                    return;
                }
                if (stringArray[0].compareTo("downloadPatchDB") == 0) {
                    FileInputStream fileInputStream;
                    object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("name")) continue;
                        this.log.println((Object)this, 3, "Invalid \"downloadPatchDB\" request: Unknown parameter \"" + string + "\" detected.");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    string = httpServletRequest.getParameter("name");
                    if (string == null) {
                        string = DEFAULT_REQUESTED_DB_NAME;
                    }
                    this.log.println((Object)this, 7, "Requested Database Name: " + string);
                    httpServletResponse.setContentType("application/octet-stream");
                    ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                    try {
                        fileInputStream = new FileInputStream(this.patchServerProxy.downloadPatchDB(string));
                    }
                    catch (PatchProException patchProException) {
                        this.log.println((Object)this, 3, "Problem detected while servicing \"downloadPatchDB\" request. " + patchProException.getMessage());
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 300);
                        if (patchProException.getTargetException() instanceof FileNotFoundException) {
                            httpServletResponse.setStatus(404);
                            httpServletResponse.sendError(404);
                        } else {
                            this.log.printStackTrace((Object)this, 3, patchProException);
                            httpServletResponse.setStatus(500);
                            httpServletResponse.sendError(500);
                        }
                        return;
                    }
                    try {
                        this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                        Object var25_40 = null;
                    }
                    catch (Throwable throwable) {
                        Object var25_42 = null;
                        ((InputStream)fileInputStream).close();
                        throw throwable;
                    }
                    ((InputStream)fileInputStream).close();
                    {
                        break block70;
                        catch (IOException iOException) {
                            this.log.println((Object)this, 3, "downloadPatchDB - IOException while copying:  " + iOException.getMessage());
                            Object var25_41 = null;
                            ((InputStream)fileInputStream).close();
                            break block70;
                        }
                    }
                }
                if (stringArray[0].compareTo("downloadRealizationDetectors") == 0) {
                    block71: {
                        FileInputStream fileInputStream;
                        object = httpServletRequest.getParameterNames();
                        while (object.hasMoreElements()) {
                            string = (String)object.nextElement();
                            if (string.equals("action") || string.equals("version") || string.equals("name")) continue;
                            this.log.println((Object)this, 3, "Invalid \"downloadRealizationDetectors\" request: Unknown parameter \"" + string + "\" detected");
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                            httpServletResponse.sendError(400);
                            return;
                        }
                        string = httpServletRequest.getParameter("name");
                        if (string == null) {
                            string = DEFAULT_REQUESTED_DETECTORS_NAME;
                        }
                        this.log.println((Object)this, 7, "Requested Detector Name: " + string);
                        httpServletResponse.setContentType("application/octet-stream");
                        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                        try {
                            fileInputStream = new FileInputStream(this.patchServerProxy.downloadRealizationDetectors(string));
                        }
                        catch (PatchProException patchProException) {
                            this.log.println((Object)this, 3, "Problem detected while servicing \"downloadRealizationDetectors\" request. " + patchProException.getMessage());
                            httpServletResponse.setIntHeader("PatchProServletCompletionCode", 400);
                            if (patchProException.getTargetException() instanceof FileNotFoundException) {
                                httpServletResponse.setStatus(404);
                                httpServletResponse.sendError(404);
                            } else {
                                this.log.printStackTrace((Object)this, 3, patchProException);
                                httpServletResponse.setStatus(500);
                                httpServletResponse.sendError(500);
                            }
                            return;
                        }
                        try {
                            this.copyStream((OutputStream)servletOutputStream, fileInputStream);
                            Object var27_44 = null;
                        }
                        catch (Throwable throwable) {
                            Object var27_46 = null;
                            ((InputStream)fileInputStream).close();
                            throw throwable;
                        }
                        ((InputStream)fileInputStream).close();
                        {
                            break block71;
                            catch (IOException iOException) {
                                this.log.println((Object)this, 3, "downloadRealizationDetectors - IOException while copying:  " + iOException.getMessage());
                                Object var27_45 = null;
                                ((InputStream)fileInputStream).close();
                            }
                        }
                    }
                    this.log.println((Object)this, 7, "PatchProServerServlet.downloadRealizationDetectors done.");
                    break block70;
                }
                if (stringArray[0].compareTo("getDocumentation") == 0) {
                    this.log.println((Object)this, 7, "Received a getDocumentation request.");
                    object = httpServletRequest.getParameterNames();
                    while (object.hasMoreElements()) {
                        string = (String)object.nextElement();
                        if (string.equals("action") || string.equals("version") || string.equals("patchId")) continue;
                        this.log.println((Object)this, 3, "Invalid \"getDocumentation\" request: Unknown parameter \"" + string + "\" detected");
                        httpServletResponse.setIntHeader("PatchProServletCompletionCode", 8);
                        httpServletResponse.sendError(400);
                        return;
                    }
                    break block70;
                }
                this.log.println((Object)this, 3, "Unknown \"action\" request was specified.");
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 16);
                httpServletResponse.sendError(400);
                return;
            }
            catch (IOException iOException) {
                this.log.printStackTrace((Object)this, 3, iOException);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 48);
                httpServletResponse.setStatus(500);
                throw new ServletException(iOException.toString());
            }
            catch (Exception exception) {
                this.log.printStackTrace((Object)this, 3, exception);
                httpServletResponse.setIntHeader("PatchProServletCompletionCode", 64);
                httpServletResponse.setStatus(500);
                throw new ServletException(exception.toString());
            }
        }
    }

    private void copyStream(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[102400];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
    }

    public synchronized void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.log = PatchProLog.getInstance();
        this.log.setLogger(new ServletLog(servletConfig.getServletContext()));
        this.properties = new PatchServerServletProperties(servletConfig);
        try {
            this.patchServerProxy = new PatchServerProxy(this.properties);
        }
        catch (PatchServerProxyException patchServerProxyException) {
        }
        catch (PatchProException patchProException) {
            // empty catch block
        }
        if (this.properties.getProperty("patchpro.debug", "false").equals("true")) {
            this.log.println((Object)this, 7, "PatchProServerServlet: patchsvr.source.0.url is " + this.properties.getProperty("patchsvr.source.0.url"));
        }
    }

    public void destroy() {
        this.log.println((Object)this, 7, "PatchProServerServlet: destroy...");
        this.log = null;
        this.properties = null;
    }
}

