/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.util;

import com.sun.patchpro.log.PatchProLog;
import com.sun.patchpro.util.JarFileHandlerFailedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class SunOSJarFileHandler {
    private static final String[] EXECUTABLES = new String[]{"prepatch", "prePatch", "postpatch", "prebackout", "postbackout", "installpatch", "backoutpatch", "download32", "download64", "download", "install", "install_patch", "t3.sh", "t4.sh"};
    private static final String[] NONPRIV_READABLES = new String[]{"checkinstall", "request", "patch_checkinstall"};
    private static final String[] NOT_CONTENT = new String[]{"META-INF/", ".file_attributes.SunOS", ".file_attributes.linux"};
    PatchProLog log;
    private Runtime runtime = Runtime.getRuntime();
    private Process process = null;

    public SunOSJarFileHandler() {
        this.log = PatchProLog.getInstance();
    }

    public void extract(String string, String string2, String string3) throws JarFileHandlerFailedException {
        block40: {
            JarFile jarFile = null;
            File file = new File(string + "/" + string3);
            if (!file.exists()) {
                throw new JarFileHandlerFailedException("The specified jar file does not exist.");
            }
            File file2 = new File(string2);
            if (!file2.exists()) {
                file2.mkdir();
            }
            this.log.println(this, 7, "Unjar'ing: " + string + "/" + string3);
            try {
                File file3 = new File("/usr/bin/unzip");
                if (file3.exists()) {
                    try {
                        try {
                            String string4 = "/usr/bin/unzip -qq -o -d " + string2 + " " + string + "/" + string3;
                            StringTokenizer stringTokenizer = new StringTokenizer(string4);
                            String[] stringArray = new String[stringTokenizer.countTokens()];
                            int n = 0;
                            while (n < stringArray.length) {
                                stringArray[n] = stringTokenizer.nextToken();
                                ++n;
                            }
                            InputStream inputStream = null;
                            InputStream inputStream2 = null;
                            this.process = this.runtime.exec(stringArray);
                            this.process.waitFor();
                            inputStream = this.process.getInputStream();
                            inputStream2 = this.process.getErrorStream();
                            if (inputStream != null) {
                                inputStream.close();
                            }
                            if (inputStream2 != null) {
                                inputStream2.close();
                            }
                            if (this.process.exitValue() != 0) {
                                this.log.println(this, 3, "Unable to unzip the " + string + "/" + string3 + ". Completion code: " + this.process.exitValue());
                                throw new JarFileHandlerFailedException("Unable to unzip the " + string + "/" + string3 + ". Completion code: " + this.process.exitValue());
                            }
                            try {
                                jarFile = new JarFile(string + "/" + string3, false);
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                this.log.printStackTrace(this, 3, fileNotFoundException);
                                throw new JarFileHandlerFailedException("The specified jar file does not exist.");
                            }
                            catch (IOException iOException) {
                                this.log.printStackTrace(this, 3, iOException);
                                throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
                            }
                            Enumeration<JarEntry> enumeration = jarFile.entries();
                            while (enumeration.hasMoreElements()) {
                                JarEntry jarEntry = enumeration.nextElement();
                                String string5 = jarEntry.getName();
                                if (!this.isContent(string5)) continue;
                                String string6 = string2 + "/" + string5;
                                try {
                                    if (this.isExecutable(string5)) {
                                        this.setExecutable(string6);
                                    }
                                    if (!this.isNonprivReadable(string5)) continue;
                                    this.setReadable(string6);
                                }
                                catch (Exception exception) {
                                    this.log.printStackTrace(this, 3, exception);
                                    throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
                                }
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            this.log.printStackTrace(this, 2, interruptedException);
                            throw new JarFileHandlerFailedException(interruptedException.getMessage());
                        }
                        catch (Exception exception) {
                            this.log.printStackTrace(this, 2, exception);
                            throw new JarFileHandlerFailedException(exception.getMessage());
                        }
                        Object var21_37 = null;
                        if (this.process != null) {
                            this.process.destroy();
                        }
                        break block40;
                    }
                    catch (Throwable throwable) {
                        Object var21_38 = null;
                        if (this.process != null) {
                            this.process.destroy();
                        }
                        throw throwable;
                    }
                }
                byte[] byArray = new byte[8192];
                try {
                    jarFile = new JarFile(string + "/" + string3, false);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.log.printStackTrace(this, 3, fileNotFoundException);
                    throw new JarFileHandlerFailedException("The specified jar file does not exist.");
                }
                catch (IOException iOException) {
                    this.log.printStackTrace(this, 3, iOException);
                    throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
                }
                InputStream inputStream = null;
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    File file4;
                    File file5;
                    JarEntry jarEntry = enumeration.nextElement();
                    String string7 = jarEntry.getName();
                    if (this.isContent(string7)) {
                        String string8 = string2 + "/" + string7;
                        try {
                            file5 = new File(string8);
                            file4 = file5.getParentFile();
                            if (file4 != null && !file4.exists()) {
                                this.mkUsableDirs(file4);
                            }
                            if (!file5.exists()) {
                                if (jarEntry.isDirectory()) {
                                    this.mkUsableDirs(file5);
                                    continue;
                                }
                                file5.createNewFile();
                            }
                            FileOutputStream fileOutputStream = new FileOutputStream(string8);
                            inputStream = jarFile.getInputStream(jarEntry);
                            int n = 0;
                            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            inputStream.close();
                            fileOutputStream.close();
                            if (this.isExecutable(string7)) {
                                this.setExecutable(string8);
                            }
                            if (this.isNonprivReadable(string7)) {
                                this.setReadable(string8);
                            }
                        }
                        catch (IOException iOException) {
                            this.log.printStackTrace(this, 3, iOException);
                            throw new JarFileHandlerFailedException("The unjar process terminated with an error.");
                        }
                    }
                    file4 = null;
                    file5 = null;
                }
            }
            catch (Exception exception) {
                this.log.printStackTrace(this, 3, exception);
                throw new JarFileHandlerFailedException(exception.getMessage());
            }
            finally {
                if (this.runtime != null) {
                    this.runtime.gc();
                    this.runtime = null;
                }
            }
        }
    }

    private boolean isExecutable(String string) {
        boolean bl = false;
        String string2 = this.getFileName(string);
        if (string.indexOf("/") == string.lastIndexOf("/")) {
            int n = 0;
            while (n < EXECUTABLES.length) {
                if (string2.equals(EXECUTABLES[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private boolean isNonprivReadable(String string) {
        boolean bl = false;
        String string2 = this.getFileName(string);
        int n = 0;
        while (n < NONPRIV_READABLES.length) {
            if (string2.equals(NONPRIV_READABLES[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean isContent(String string) {
        boolean bl = true;
        int n = 0;
        while (n < NOT_CONTENT.length) {
            if (string.indexOf(NOT_CONTENT[n]) == 0) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecutable(String string) {
        block11: {
            Process process = null;
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                block10: {
                    try {
                        process = this.runtime.exec("/usr/bin/chmod a+x,ug+r " + string);
                        process.waitFor();
                        inputStream = process.getInputStream();
                        inputStream2 = process.getErrorStream();
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (inputStream2 == null) break block10;
                        inputStream2.close();
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.println(this, 3, "chmod of " + string + " interrupted.");
                        Object var8_6 = null;
                        if (process != null) {
                            process.destroy();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 3, "Unable to chmod " + string);
                        Object var8_7 = null;
                        if (process != null) {
                            process.destroy();
                        }
                    }
                }
                Object var8_5 = null;
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setReadable(String string) {
        block11: {
            Process process = null;
            InputStream inputStream = null;
            InputStream inputStream2 = null;
            try {
                block10: {
                    try {
                        process = this.runtime.exec("/usr/bin/chmod a+r " + string);
                        process.waitFor();
                        inputStream = process.getInputStream();
                        inputStream2 = process.getErrorStream();
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        if (inputStream2 == null) break block10;
                        inputStream2.close();
                    }
                    catch (InterruptedException interruptedException) {
                        this.log.println(this, 3, "chmod of " + string + " interrupted.");
                        Object var8_6 = null;
                        if (process != null) {
                            process.destroy();
                        }
                        break block11;
                    }
                    catch (IOException iOException) {
                        this.log.println(this, 3, "Unable to chmod " + string);
                        Object var8_7 = null;
                        if (process != null) {
                            process.destroy();
                        }
                    }
                }
                Object var8_5 = null;
                if (process != null) {
                    process.destroy();
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (process != null) {
                    process.destroy();
                }
                throw throwable;
            }
        }
    }

    private String getFileName(String string) {
        int n = string.lastIndexOf("/") + 1;
        return string.substring(n);
    }

    private void mkUsableDirs(File file) {
        File file2 = new File(file.getPath());
        Vector<File> vector = new Vector<File>();
        while (!file2.exists()) {
            vector.add(file2);
            file2 = file2.getParentFile();
        }
        int n = vector.size() - 1;
        while (n >= 0) {
            File file3 = (File)vector.elementAt(n);
            file3.mkdir();
            this.setExecutable(file3.getPath());
            --n;
        }
    }
}

