/*
 * Copyright (c) 2001 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_CHERRYSTONE_H
#define	_CHERRYSTONE_H

#pragma ident	"@(#)cherrystone.h	1.1	01/04/24 SMI"

#ifdef	__cplusplus
extern "C" {
#endif

#define	CHERRYSTONE_MAX_CPUS	4

/*
 *   Slot SlotID   Agent ID
 *   ---- ------  --------
 *    0     0  <==>  0
 *    0     1  <==>  2
 *    1     0  <==>  1
 *    1     1  <==>  3
 *    4[*]  -  <==>  8 (Schizo0)
 *    5[*]  -  <==>  9 (Schizo1)
 *
 *    [*] Fake slot numbers used for prtdiag bookkeeping
 */
#define	CHERRYSTONE_GETSLOT(AID)	(((AID&0xc)>>1)|(AID&1))
#define	CHERRYSTONE_GETSLOT_LABEL(AID)	('A' + CHERRYSTONE_GETSLOT(AID))
#define	CHERRYSTONE_GETSID(AID)		((AID&2)>>1)
#define	CHERRYSTONE_GETAID(SLOT, SID)	(((SLOT&2)<<1)|(SLOT&1)|((SID)<<1))

#ifdef	__cplusplus
}
#endif

#endif /* _CHERRYSTONE_H */
