/*
 * Copyright (c) 2000 by Sun Microsystems, Inc.
 * All rights reserved.
 */

#ifndef	_LIBSYSEVENT_H
#define	_LIBSYSEVENT_H

#pragma ident	"@(#)libsysevent.h	1.2	00/10/10 SMI"

#include <stdio.h>
#include <thread.h>
#include <stddef.h>
#include <synch.h>
#include <sys/types.h>
#include <sys/sysevent.h>

#ifdef	__cplusplus
extern "C" {
#endif

/* sysevent loadable module ops structure and related defines */
#define	SE_MAX_RETRY_LIMIT	3
#define	SE_RETRY_TIME		1 /* seconds */
#define	SE_NO_RETRY		1
#define	SE_MAJOR_VERSION	0
#define	SE_MINOR_VERSION	0

struct slm_mod_ops {
	int	major_version;
	int	minor_version;
	int	retry_limit;
	int	(*deliver_event)();
};

/* sysevent opaque subscriber handle and related data structures */

#define	DOOR_NAME_SIZE	64

typedef struct door_cookie {
	int	(*door_func)(sysevent_t *);
} door_cookie_t;

typedef struct sysevent_handle {
	int		bound;		/* Channel bind status */
	int		result;		/* post event result */
	int		service_door;	/* Server-side door */
	int		service_fd;	/* Client-side file descriptor */
	door_cookie_t	*cookie;	/* door cookie */
	char		*door_name;	/* producer-consumer comm door */
	mutex_t		lock;		/* lock to protect access */
} sysevent_handle_t;

/* libsysevent interfaces */
int sysevent_post_event(char *class, char *subclass, char *vendor,
	char *pub_name, nvlist_t *attr_list, sysevent_id_t *eid);
sysevent_t *sysevent_dup(sysevent_t *ev);
void sysevent_free(sysevent_t *ev);
int sysevent_get_attr_list(sysevent_t *ev, nvlist_t **nvlist);
int sysevent_lookup_attr(sysevent_t *ev, char *name, int datatype,
	sysevent_value_t *se_value);
sysevent_attr_t *sysevent_attr_next(sysevent_t *ev, sysevent_attr_t *attr);
char *sysevent_attr_name(sysevent_attr_t *attr);
int sysevent_attr_value(sysevent_attr_t *attr, sysevent_value_t *se_value);
int sysevent_get_class(sysevent_t *ev);
char *sysevent_get_class_name(sysevent_t *ev);
int sysevent_get_subclass(sysevent_t *ev);
char *sysevent_get_subclass_name(sysevent_t *ev);
char *sysevent_get_pub(sysevent_t *ev);
char *sysevent_get_vendor_name(sysevent_t *ev);
char *sysevent_get_pub_name(sysevent_t *ev);
void sysevent_get_pid(sysevent_t *ev, pid_t *pid);
uint64_t sysevent_get_seq(sysevent_t *ev);
void sysevent_get_time(sysevent_t *ev, hrtime_t *etime);
size_t sysevent_get_size(sysevent_t *ev);

/* devfsadm private interfaces */
sysevent_t *sysevent_alloc_event(char *class, char *subclass, char *vendor,
	char *pub_name, nvlist_t *attr_list);
int sysevent_send_event(sysevent_handle_t *sysevent_hdl, sysevent_t *ev);
sysevent_handle_t *sysevent_open_channel(char *endpoint);
int sysevent_close_channel(sysevent_handle_t *sysevent_hdl);
int sysevent_bind_channel(sysevent_handle_t *se_handle,
	int (*callback)(sysevent_t *ev));
void sysevent_unbind_channel(sysevent_handle_t *se_handle);

/* Debug interfaces */
void se_print(FILE *fp, sysevent_t *);

#ifdef	__cplusplus
}
#endif

#endif	/* _LIBSYSEVENT_H */
