
import java.rmi.*;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.PasswordCredential;
import java.util.*;
import java.util.Enumeration;

/** 
 * This example displays a list of log records.
 */

public class ReadLog {
    public static void main(String args[]) throws CIMException {

	if (args.length != 3) {
	    System.out.println("Usage: ReadLog host username password"); 
	    System.exit(1);
	}
	CIMClient cc = null;
	CIMObjectPath cop = null;
	CIMObjectPath serviceObjPath = null;
	Vector inVec = new Vector();
	Vector outVec = new Vector();
	try {
	    CIMNameSpace cns = new CIMNameSpace(args[0]);
	    UserPrincipal up = new UserPrincipal(args[1]);
	    PasswordCredential pc = new PasswordCredential(args[2]);
	    cc = new CIMClient(cns, up, pc);

	    cop = new CIMObjectPath("Solaris_LogRecord");
	    serviceObjPath = new CIMObjectPath("Solaris_LogService");
	    Enumeration e = cc.enumInstances(cop, true);
	    for (; e.hasMoreElements(); ) {
	        System.out.println("---------------------------------");
		CIMObjectPath op = (CIMObjectPath)e.nextElement();
		CIMInstance ci = cc.getInstance(op, false);
		System.out.println("Record ID : " + 
    (((Long)ci.getProperty("RecordID").getValue().getValue()).longValue()));
		System.out.println("Log filename : " + 
    ((String)ci.getProperty("FileName").getValue().getValue())); 
		int categ = 
    (((Integer)ci.getProperty("category").getValue().getValue()).intValue());
		if (categ == 0)
		    System.out.println("Category : Application Log");
		else if (categ == 1)
		    System.out.println("Category : Security Log");
		else if (categ == 2)
		    System.out.println("Category : System Log");
		int severity = 
    (((Integer)ci.getProperty("severity").getValue().getValue()).intValue());
		if (severity == 0)
		    System.out.println("Severity : Informational");
		else if (severity == 1)
		    System.out.println("Severity : Warning Log!");
		else if (severity == 2)
		    System.out.println("Severity : Error!!");
		System.out.println("Log Record written by :" + 
    ((String)ci.getProperty("AppName").getValue().getValue()));
		System.out.println("User : " + 
    ((String)ci.getProperty("UserName").getValue().getValue()));
		System.out.println("Client Machine : " + 
    ((String)ci.getProperty("ClientMachineName").getValue().getValue()));
		System.out.println("Server Machine : " + 
    ((String)ci.getProperty("ServerMachineName").getValue().getValue()));
		System.out.println("Summary Message : " + 
    ((String)ci.getProperty("SummaryMessage").getValue().getValue()));
		System.out.println("Detailed Message : " + 
    ((String)ci.getProperty("DetailedMessage").getValue().getValue()));
		System.out.println("Additional data : " + 
    ((String)ci.getProperty("data").getValue().getValue()));
		boolean syslogflag =
((Boolean)ci.getProperty("syslogflag").getValue().getValue()).booleanValue();
		if (syslogflag == true) {
		    System.out.println("Record was written to syslog as well");
		} else {
		    System.out.println("Record was not written to syslog");
		}
		System.out.println("---------------------------------");
	    }
	}
	catch (Exception e) {
	    System.out.println("Exception: "+e);
	    e.printStackTrace();
	}

	try {
	    Enumeration enu = cc.enumInstances(serviceObjPath, true);
	    if (enu != null) {
	        for (; enu.hasMoreElements(); ) {
		    CIMObjectPath op = (CIMObjectPath)enu.nextElement();
		    CIMValue cv = cc.invokeMethod(op, "getCurrentLogFileName",
						  inVec, outVec);
		    String fileName =
		      (String)((CIMValue)outVec.elementAt(0)).getValue();
		    System.out.println("Current Log Filename = " + fileName);
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}

	// close session.
	if (cc != null) {
	    cc.close();
	}
    }
}
