#
# Configuration for mod_perl and Apache::...
#
package Apache::MyConfig;

%Setup = (
'APACHE_HEADER_INSTALL' => 1,
'APACHE_PREFIX' => '',
'APACHE_SRC' => '',
'APACI_ARGS' => '',
'APXS' => '',
'Apache_Src' => '',
'DO_HTTPD' => 0,
'NO_HTTPD' => 1,
'PERL_ACCESS' => 0,
'PERL_AUTHEN' => 0,
'PERL_AUTHZ' => 0,
'PERL_CHILD_EXIT' => 0,
'PERL_CHILD_INIT' => 0,
'PERL_CLEANUP' => 0,
'PERL_CONNECTION_API' => 1,
'PERL_DEBUG' => '',
'PERL_DIRECTIVE_HANDLERS' => 0,
'PERL_DISPATCH' => 0,
'PERL_FILE_API' => 0,
'PERL_FIXUP' => 0,
'PERL_HANDLER' => 1,
'PERL_HEADER_PARSER' => 0,
'PERL_INIT' => 0,
'PERL_LOG' => 0,
'PERL_LOG_API' => 0,
'PERL_METHOD_HANDLERS' => 0,
'PERL_POST_READ_REQUEST' => 0,
'PERL_RESTART' => 0,
'PERL_SECTIONS' => 0,
'PERL_SERVER_API' => 1,
'PERL_SSI' => 0,
'PERL_STACKED_HANDLERS' => 0,
'PERL_STATIC_EXTS' => '',
'PERL_TABLE_API' => 0,
'PERL_TRACE' => 0,
'PERL_TRANS' => 0,
'PERL_TYPE' => 0,
'PERL_URI_API' => 0,
'PERL_USELARGEFILES' => 1,
'PERL_UTIL_API' => 0,
'PREP_HTTPD' => 0,
'SSL_BASE' => '',
'USE_APACI' => 0,
'USE_APXS' => 0
);
1;

__END__

=head1 NAME

Apache::MyConfig - build options access

=head1 SYNOPSIS

 use Apache::MyConfig;
 die unless $Apache::MyConfig::Setup{PERL_FILE_API};

=head1 DESCRIPTION

B<Apache::MyConfig> module provides access to the various hooks
and features set when mod_perl is built.  This circumvents the
need to set up a live server just to find out if a certain callback
hook is available.

Itterate through %Apache::MyConfig::Setup to get obtain build
information then see Appendix B of the Eagle book for more detail
on each key.

