#ifndef lint
static	char sccsid[] = "@(#)cubes.c 1.1 92/07/30 Copyr 1985 Sun Micro";
#endif

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*
 * cubes.c: 6 faces of the doubling cube in two orientations each
 *          (facing human or computer side), plus a 64 face turned
 *          so it faces neither side
 */

#include <pixrect/pixrect_hs.h>

static short die2up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x07C0, 0x0003, 0xC000, 0x0FE0, 0x0003, 0xC000, 0x1870,
	0x0003, 0xC000, 0x1030, 0x0003, 0xC000, 0x0030, 0x0003, 0xC000,
	0x0030, 0x0003, 0xC000, 0x0030, 0x0003, 0xC000, 0x0060, 0x0003,
	0xC000, 0x00C0, 0x0003, 0xC000, 0x0180, 0x0003, 0xC000, 0x0300,
	0x0003, 0xC000, 0x0600, 0x0003, 0xC000, 0x0C08, 0x0003, 0xC000,
	0x1FF8, 0x0003, 0xC000, 0x1FF8, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die2up_pr, 48, 48, 1, die2up_data);

static short die2dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x1FF8, 0x0003, 0xC000, 0x1FF8,
	0x0003, 0xC000, 0x1030, 0x0003, 0xC000, 0x0060, 0x0003, 0xC000,
	0x00C0, 0x0003, 0xC000, 0x0180, 0x0003, 0xC000, 0x0300, 0x0003,
	0xC000, 0x0600, 0x0003, 0xC000, 0x0C00, 0x0003, 0xC000, 0x0C00,
	0x0003, 0xC000, 0x0C00, 0x0003, 0xC000, 0x0C08, 0x0003, 0xC000,
	0x0E18, 0x0003, 0xC000, 0x07F0, 0x0003, 0xC000, 0x03E0, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die2dn_pr, 48, 48, 1, die2dn_data);

static short die4up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0060, 0x0003, 0xC000, 0x00E0, 0x0003, 0xC000, 0x00E0,
	0x0003, 0xC000, 0x0160, 0x0003, 0xC000, 0x0160, 0x0003, 0xC000,
	0x0260, 0x0003, 0xC000, 0x0260, 0x0003, 0xC000, 0x0460, 0x0003,
	0xC000, 0x0460, 0x0003, 0xC000, 0x0860, 0x0003, 0xC000, 0x0FF8,
	0x0003, 0xC000, 0x1FF8, 0x0003, 0xC000, 0x0060, 0x0003, 0xC000,
	0x0060, 0x0003, 0xC000, 0x0060, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die4up_pr, 48, 48, 1, die4up_data);

static short die4dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0600, 0x0003, 0xC000, 0x0600,
	0x0003, 0xC000, 0x0600, 0x0003, 0xC000, 0x1FF8, 0x0003, 0xC000,
	0x1FF0, 0x0003, 0xC000, 0x0610, 0x0003, 0xC000, 0x0620, 0x0003,
	0xC000, 0x0620, 0x0003, 0xC000, 0x0640, 0x0003, 0xC000, 0x0640,
	0x0003, 0xC000, 0x0680, 0x0003, 0xC000, 0x0680, 0x0003, 0xC000,
	0x0700, 0x0003, 0xC000, 0x0700, 0x0003, 0xC000, 0x0600, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die4dn_pr, 48, 48, 1, die4dn_data);

static short die8up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x03C0, 0x0003, 0xC000, 0x0460, 0x0003, 0xC000, 0x0C30,
	0x0003, 0xC000, 0x0C30, 0x0003, 0xC000, 0x0C30, 0x0003, 0xC000,
	0x0620, 0x0003, 0xC000, 0x0340, 0x0003, 0xC000, 0x0180, 0x0003,
	0xC000, 0x02C0, 0x0003, 0xC000, 0x0460, 0x0003, 0xC000, 0x0C30,
	0x0003, 0xC000, 0x0C30, 0x0003, 0xC000, 0x0C30, 0x0003, 0xC000,
	0x0620, 0x0003, 0xC000, 0x03C0, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die8up_pr, 48, 48, 1, die8up_data);

static short die8dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x03C0, 0x0003, 0xC000, 0x0460,
	0x0003, 0xC000, 0x0C30, 0x0003, 0xC000, 0x0C30, 0x0003, 0xC000,
	0x0C30, 0x0003, 0xC000, 0x0620, 0x0003, 0xC000, 0x0340, 0x0003,
	0xC000, 0x0180, 0x0003, 0xC000, 0x02C0, 0x0003, 0xC000, 0x0460,
	0x0003, 0xC000, 0x0C30, 0x0003, 0xC000, 0x0C30, 0x0003, 0xC000,
	0x0C30, 0x0003, 0xC000, 0x0620, 0x0003, 0xC000, 0x03C0, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die8dn_pr, 48, 48, 1, die8dn_data);

static short die16up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x2007, 0x0003, 0xC000, 0x600C, 0x0003, 0xC000, 0xE018,
	0x0003, 0xC001, 0xE030, 0x0003, 0xC003, 0x6030, 0x0003, 0xC000,
	0x6060, 0x0003, 0xC000, 0x6067, 0x8003, 0xC000, 0x606F, 0xC003,
	0xC000, 0x6070, 0xE003, 0xC000, 0x6060, 0x6003, 0xC000, 0x6060,
	0x6003, 0xC000, 0x6060, 0x6003, 0xC000, 0x6070, 0x4003, 0xC000,
	0x603F, 0x8003, 0xC003, 0xFC1F, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die16up_pr, 48, 48, 1, die16up_data);

static short die16dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0xF83F, 0xC003, 0xC001, 0xFC06,
	0x0003, 0xC002, 0x0E06, 0x0003, 0xC006, 0x0606, 0x0003, 0xC006,
	0x0606, 0x0003, 0xC006, 0x0606, 0x0003, 0xC007, 0x0E06, 0x0003,
	0xC003, 0xF606, 0x0003, 0xC001, 0xE606, 0x0003, 0xC000, 0x0606,
	0x0003, 0xC000, 0x0C06, 0xC003, 0xC000, 0x0C07, 0x8003, 0xC000,
	0x1807, 0x0003, 0xC000, 0x3006, 0x0003, 0xC000, 0xE004, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die16dn_pr, 48, 48, 1, die16dn_data);

static short die32up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0xF81F, 0x0003, 0xC001, 0xFC3F, 0x8003, 0xC002, 0x0E61,
	0xC003, 0xC004, 0x0640, 0xC003, 0xC000, 0x0600, 0xC003, 0xC000,
	0x0E00, 0xC003, 0xC000, 0x7C00, 0xC003, 0xC000, 0xFC01, 0x8003,
	0xC000, 0x0E03, 0x0003, 0xC000, 0x0606, 0x0003, 0xC000, 0x060C,
	0x0003, 0xC004, 0x0618, 0x0003, 0xC006, 0x0430, 0x2003, 0xC003,
	0xF87F, 0xE003, 0xC001, 0xF07F, 0xE003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die32up_pr, 48, 48, 1, die32up_data);

static short die32dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC007, 0xFE0F, 0x8003, 0xC007, 0xFE1F,
	0xC003, 0xC004, 0x0C20, 0x6003, 0xC000, 0x1860, 0x2003, 0xC000,
	0x3060, 0x0003, 0xC000, 0x6060, 0x0003, 0xC000, 0xC070, 0x0003,
	0xC001, 0x803F, 0x0003, 0xC003, 0x003E, 0x0003, 0xC003, 0x0070,
	0x0003, 0xC003, 0x0060, 0x0003, 0xC003, 0x0260, 0x2003, 0xC003,
	0x8670, 0x4003, 0xC001, 0xFC3F, 0x8003, 0xC000, 0xF81F, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die32dn_pr, 48, 48, 1, die32dn_data);

static short die64up_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x7001, 0x8003, 0xC000, 0xC003, 0x8003, 0xC001, 0x8003,
	0x8003, 0xC003, 0x0005, 0x8003, 0xC003, 0x0005, 0x8003, 0xC006,
	0x0009, 0x8003, 0xC006, 0x7809, 0x8003, 0xC006, 0xFC11, 0x8003,
	0xC007, 0x0E11, 0x8003, 0xC006, 0x0621, 0x8003, 0xC006, 0x063F,
	0xE003, 0xC006, 0x067F, 0xE003, 0xC007, 0x0401, 0x8003, 0xC003,
	0xF801, 0x8003, 0xC001, 0xF001, 0x8003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die64up_pr, 48, 48, 1, die64up_data);

static short die64dn_data[144] = {
	0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC001, 0x800F, 0x8003, 0xC001, 0x801F,
	0xC003, 0xC001, 0x8020, 0xE003, 0xC007, 0xFE60, 0x6003, 0xC007,
	0xFC60, 0x6003, 0xC001, 0x8460, 0x6003, 0xC001, 0x8870, 0xE003,
	0xC001, 0x883F, 0x6003, 0xC001, 0x901E, 0x6003, 0xC001, 0x9000,
	0x6003, 0xC001, 0xA000, 0xC003, 0xC001, 0xA000, 0xC003, 0xC001,
	0xC001, 0x8003, 0xC001, 0xC003, 0x0003, 0xC001, 0x800E, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003,
	0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000,
	0x0003, 0xC000, 0x0000, 0x0003, 0xC000, 0x0000, 0x0003, 0xC000,
	0x0000, 0x0003, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF
};

mpr_static(die64dn_pr, 48, 48, 1, die64dn_data);

struct pixrect *dblecubes[6][2] = {
	&die2up_pr,	&die2dn_pr,
	&die4up_pr,	&die4dn_pr,
	&die8up_pr,	&die8dn_pr,
	&die16up_pr,	&die16dn_pr,
	&die32up_pr,	&die32dn_pr,
	&die64up_pr,	&die64dn_pr
};
