/*	@(#)clock.h 1.1 92/07/30 SMI	*/

#ifndef	_sun4m_clock_h
#define	_sun4m_clock_h

#include <machine/devaddr.h>

/*
 * Copyright (c) 1988 by Sun Microsystems, Inc.
 */

#ifndef LOCORE

struct count14 {
	u_int	timer_msw;	/* also limit14 */
	u_int	timer_lsw;	/* also counter14 */
	u_int	lim14_noreset;
	u_int	control;
	u_char	filler[0x1000 - 0x10];
};

struct counterregs {
	struct	count14	cpu[4];
	u_int	limit10;
	u_int	counter10;
	u_int	lim10_noreset;
	u_int	filler;
	u_int	config;
};
#define	COUNTER	((struct counterregs *)(COUNTER_ADDR))
#endif !LOCORE

#define	CTR_LIMIT_BIT		0x80000000	/* limit bit mask */
#define	CTR_USEC_MASK		0x7FFFFC00	/* counter/limit microsecond mask */
#define	CTR_USEC_SHIFT		10		/* counter/limit microsecond shift */

/*
 * Timer Configuration defines
 */
#define	TMR0_CONFIG		0x1		/* CPU 0 timer configuration */
#define	TMR1_CONFIG		0x2		/* CPU 1 timer configuration */
#define	TMR2_CONFIG		0x4		/* CPU 2 timer configuration */
#define	TMR3_CONFIG		0x8		/* CPU 3 timer configuration */
#define TMRALL_CONFIG		0xF		/* All configurations */

/*
 * Definitions for the Mostek 48T02 clock chip. We use this chip as
 * our TOD clock. Clock interrupts are generated by a separate timer
 * circuit.
 */

#define	SECDAY	((unsigned)(24*60*60))		/* seconds per day */
#define	SECYR	((unsigned)(365*SECDAY))	/* seconds per common year */

/*
 * The 48T02 uses year % 4 to figure out if
 * we have a leap year, we do the same here.
 */
#define	SECYEAR(yr)	((((unsigned)(yr) % 4) == 0)? SECYR + SECDAY : SECYR)

/*
 * The year register counts from 0 to 99.
 * Unix time is the number of seconds
 * since the year YRREF.  The 2 digit year
 * value stored in the chip represents the
 * the number of years beyond YRBASE.
 * Note that YRBASE must be < YRREF and
 * (YRBASE % 4) == 0 to do leap years correct.
 * Note that we can only keep time up to the year 2068.
 */
#define	YRREF		70	/* 1970 - where UNIX time begins */
#define	YRBASE		68	/* 1968 - what year 0 in chip represents */

#ifndef LOCORE
struct mostek48T02 {
	u_char	clk_ctrl;	/* ctrl register */
	u_char	clk_sec;	/* counter - seconds 0-59 */
	u_char	clk_min;	/* counter - minutes 0-59 */
	u_char	clk_hour;	/* counter - hours 0-23 */
	u_char	clk_weekday;	/* counter - weekday 1-7 */
	u_char	clk_day;	/* counter - day 1-31 */
	u_char	clk_month;	/* counter - month 1-12 */
	u_char	clk_year;	/* counter - year 0-99 */
};
#define	CLOCK ((struct mostek48T02 *)(V_CLK1ADDR))
#endif !LOCORE

/*
 * Bit masks for various operations and register limits.
 */
#define	CLK_CTRL_WRITE		0x80
#define	CLK_CTRL_READ		0x40
#define	CLK_CTRL_SIGN		0x20

#define	CLK_STOP		0x80
#define	CLK_KICK		0x80
#define	CLK_FREQT		0x40

#define	CLK_MONTH_MASK		0x1f
#define	CLK_DAY_MASK		0x3f
#define	CLK_WEEKDAY_MASK	0x07
#define	CLK_HOUR_MASK		0x3f
#define	CLK_MIN_MASK		0x7f
#define	CLK_SEC_MASK		0x7f

#endif	/* !_sun4m_clock_h */
