/*	@(#)video_mat.h 1.1 94/10/31 SMI	*/

/*
 * Copyright (c) 1989 by Sun Microsystems, Inc.
 */

/*
 * This file includes the matrices, defines and macros used 
 * for the various file dumps available.
 * 8 bit colour, 8 bit luma(Y), 1 bit dithered,
 * Postscript and Encapsulated Postscript.
 */

#ifndef video_mat_DEFINED
#define video_mat_DEFINED

/*
 * Bit shifting on the 32 bit pixel to get red, green, blue
 * values
 */
#define RED(v)		((v) & 0xFF)
#define GREEN(v)	(((v)>>8) & 0xFF)
#define BLUE(v)		(((v)>>16) & 0xFF)

/*
 * Defines and macros for 24 to 8 bit colour dithering
 */
#define MAX_SCAN_WIDTH	640	/* Width of a video image */
#define	CMAP_SIZE	252	/* Actual size of the colour map */
#define RED_I		0	/* Colour array index values */
#define GREEN_I		1
#define BLUE_I		2

#define ABS(n) ( (n) < 0 ? (-1)*(n) : (n))
#define VALUE(c,index) (thresh_table[(c)][(index)])
#define INDEX(c,value) (reduction_table[(c)][(value)])

/*
 * This set of tables converts RGB into Luma using
 * the standard RGB to Y weights.
 * 0.3R 0.59G 0.11B. 
 * This is quicker than multiplys
 */
static unsigned int lumar[] = {
	    0,   77,  153,  230,  306,  383,  459,  536,
	  612,  689,  765,  842,  919,  995, 1072, 1148,
	 1225, 1301, 1378, 1454, 1531, 1607, 1684, 1761,
	 1837, 1914, 1990, 2067, 2143, 2220, 2296, 2373,
	 2449, 2526, 2602, 2679, 2756, 2832, 2909, 2985,
	 3062, 3138, 3215, 3291, 3368, 3444, 3521, 3598,
	 3674, 3751, 3827, 3904, 3980, 4057, 4133, 4210,
	 4286, 4363, 4440, 4516, 4593, 4669, 4746, 4822,
	 4899, 4975, 5052, 5128, 5205, 5282, 5358, 5435,
	 5511, 5588, 5664, 5741, 5817, 5894, 5970, 6047,
	 6124, 6200, 6277, 6353, 6430, 6506, 6583, 6659,
	 6736, 6812, 6889, 6966, 7042, 7119, 7195, 7272,
	 7348, 7425, 7501, 7578, 7654, 7731, 7807, 7884,
	 7961, 8037, 8114, 8190, 8267, 8343, 8420, 8496,
	 8573, 8649, 8726, 8803, 8879, 8956, 9032, 9109,
	 9185, 9262, 9338, 9415, 9491, 9568, 9645, 9721,
	 9798, 9874, 9951,10027,10104,10180,10257,10333,
	10410,10487,10563,10640,10716,10793,10869,10946,
	11022,11099,11175,11252,11329,11405,11482,11558,
	11635,11711,11788,11864,11941,12017,12094,12170,
	12247,12324,12400,12477,12553,12630,12706,12783,
	12859,12936,13012,13089,13166,13242,13319,13395,
	13472,13548,13625,13701,13778,13854,13931,14008,
	14084,14161,14237,14314,14390,14467,14543,14620,
	14696,14773,14850,14926,15003,15079,15156,15232,
	15309,15385,15462,15538,15615,15692,15768,15845,
	15921,15998,16074,16151,16227,16304,16380,16457,
	16534,16610,16687,16763,16840,16916,16993,17069,
	17146,17222,17299,17375,17452,17529,17605,17682,
	17758,17835,17911,17988,18064,18141,18217,18294,
	18371,18447,18524,18600,18677,18753,18830,18906,
	18983,19059,19136,19213,19289,19366,19442,19519,} ;

static unsigned int lumag[] = {
	    0,  150,  301,  451,  601,  751,  902, 1052,
	 1202, 1352, 1503, 1653, 1803, 1954, 2104, 2254,
	 2404, 2555, 2705, 2855, 3005, 3156, 3306, 3456,
	 3607, 3757, 3907, 4057, 4208, 4358, 4508, 4658,
	 4809, 4959, 5109, 5260, 5410, 5560, 5710, 5861,
	 6011, 6161, 6311, 6462, 6612, 6762, 6913, 7063,
	 7213, 7363, 7514, 7664, 7814, 7964, 8115, 8265,
	 8415, 8566, 8716, 8866, 9016, 9167, 9317, 9467,
	 9617, 9768, 9918,10068,10218,10369,10519,10669,
	10820,10970,11120,11270,11421,11571,11721,11871,
	12022,12172,12322,12473,12623,12773,12923,13074,
	13224,13374,13524,13675,13825,13975,14126,14276,
	14426,14576,14727,14877,15027,15177,15328,15478,
	15628,15779,15929,16079,16229,16380,16530,16680,
	16830,16981,17131,17281,17432,17582,17732,17882,
	18033,18183,18333,18483,18634,18784,18934,19085,
	19235,19385,19535,19686,19836,19986,20136,20287,
	20437,20587,20738,20888,21038,21188,21339,21489,
	21639,21789,21940,22090,22240,22391,22541,22691,
	22841,22992,23142,23292,23442,23593,23743,23893,
	24044,24194,24344,24494,24645,24795,24945,25095,
	25246,25396,25546,25697,25847,25997,26147,26298,
	26448,26598,26748,26899,27049,27199,27350,27500,
	27650,27800,27951,28101,28251,28401,28552,28702,
	28852,29002,29153,29303,29453,29604,29754,29904,
	30054,30205,30355,30505,30655,30806,30956,31106,
	31257,31407,31557,31707,31858,32008,32158,32308,
	32459,32609,32759,32910,33060,33210,33360,33511,
	33661,33811,33961,34112,34262,34412,34563,34713,
	34863,35013,35164,35314,35464,35614,35765,35915,
	36065,36216,36366,36516,36666,36817,36967,37117,
	37267,37418,37568,37718,37869,38019,38169,38319,} ;

static unsigned int lumab[] = {
	    0,   29,   58,   88,  117,  146,  175,  204,
	  233,  263,  292,  321,  350,  379,  409,  438,
	  467,  496,  525,  554,  584,  613,  642,  671,
	  700,  730,  759,  788,  817,  846,  876,  905,
	  934,  963,  992, 1021, 1051, 1080, 1109, 1138,
	 1167, 1197, 1226, 1255, 1284, 1313, 1342, 1372,
	 1401, 1430, 1459, 1488, 1518, 1547, 1576, 1605,
	 1634, 1663, 1693, 1722, 1751, 1780, 1809, 1839,
	 1868, 1897, 1926, 1955, 1985, 2014, 2043, 2072,
	 2101, 2130, 2160, 2189, 2218, 2247, 2276, 2306,
	 2335, 2364, 2393, 2422, 2451, 2481, 2510, 2539,
	 2568, 2597, 2627, 2656, 2685, 2714, 2743, 2772,
	 2802, 2831, 2860, 2889, 2918, 2948, 2977, 3006,
	 3035, 3064, 3094, 3123, 3152, 3181, 3210, 3239,
	 3269, 3298, 3327, 3356, 3385, 3415, 3444, 3473,
	 3502, 3531, 3560, 3590, 3619, 3648, 3677, 3706,
	 3736, 3765, 3794, 3823, 3852, 3881, 3911, 3940,
	 3969, 3998, 4027, 4057, 4086, 4115, 4144, 4173,
	 4202, 4232, 4261, 4290, 4319, 4348, 4378, 4407,
	 4436, 4465, 4494, 4524, 4553, 4582, 4611, 4640,
	 4669, 4699, 4728, 4757, 4786, 4815, 4845, 4874,
	 4903, 4932, 4961, 4990, 5020, 5049, 5078, 5107,
	 5136, 5166, 5195, 5224, 5253, 5282, 5311, 5341,
	 5370, 5399, 5428, 5457, 5487, 5516, 5545, 5574,
	 5603, 5633, 5662, 5691, 5720, 5749, 5778, 5808,
	 5837, 5866, 5895, 5924, 5954, 5983, 6012, 6041,
	 6070, 6099, 6129, 6158, 6187, 6216, 6245, 6275,
	 6304, 6333, 6362, 6391, 6420, 6450, 6479, 6508,
	 6537, 6566, 6596, 6625, 6654, 6683, 6712, 6742,
	 6771, 6800, 6829, 6858, 6887, 6917, 6946, 6975,
	 7004, 7033, 7063, 7092, 7121, 7150, 7179, 7208,
	 7238, 7267, 7296, 7325, 7354, 7384, 7413, 7442,} ;

/*
 * 255 has been changed to 254 in this table so that all-white 
 * values will appear all-white in the output 
 */
static unsigned char dither_mat[16][16] = {
	{  0,192, 48,240, 12,204, 60,252,  3,195, 51,243, 15,207, 63,254},
	{128, 64,176,112,140, 76,188,124,131, 67,179,115,143, 79,191,127},
	{ 32,224, 16,208, 44,236, 28,220, 35,227, 19,211, 47,239, 31,223},
	{160, 96,144, 80,172,108,156, 92,163, 99,147, 83,175,111,159, 95},
	{  8,200, 56,248,  4,196, 52,244, 11,203, 59,251,  7,199, 55,247},
	{136, 72,184,120,132, 68,180,116,139, 75,187,123,135, 71,183,119},
	{ 40,232, 24,216, 36,228, 20,212, 43,235, 27,219, 39,231, 23,215},
	{168,104,152, 88,164,100,148, 84,171,107,155, 91,167,103,151, 87},
	{  2,194, 50,242, 14,206, 62,254,  1,193, 49,241, 13,205, 61,253},
	{130, 66,178,114,142, 78,190,126,129, 65,177,113,141, 77,189,125},
	{ 34,226, 18,210, 46,238, 30,222, 33,225, 17,209, 45,237, 29,221},
	{162, 98,146, 82,174,110,158, 94,161, 97,145, 81,173,109,157, 93},
	{ 10,202, 58,250,  6,198, 54,246,  9,201, 57,249,  5,197, 53,245},
	{138, 74,186,122,134, 70,182,118,137, 73,185,121,133, 69,181,117},
	{ 42,234, 26,218, 38,230, 22,214, 41,233, 25,217, 37,229, 21,213},
	{170,106,154, 90,166,102,150, 86,169,105,153, 89,165,101,149, 85}} ;


/*
 * Tables  for 24 to 8 bit colour dithering
 */

/*
 * Threshold table determines where a particular colour
 * lies. Table assumes that min value = 0, max value = 255
 * Error isn't really optimised statistically for the picture.
 * It is however optimal for evenly distributed points over
 * the entire pictures range of colours.
 *
 * The zeroes at the end of the green and blue arrays are padding.
 */
static int thresh_table[3][8] = {
	0, 43, 85, 128, 170, 213, 255, 255,
	0, 51, 102, 153, 204, 255, 255, 0,
	0, 51, 102, 153, 204, 255, 255, 0 };

/*
 * Determines the thresh table position to use for each
 * colour
 */
static int reduction_table[3][256] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 
	5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 

	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
	3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
	4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5 };

/*
 * Red part of the 8 bit image colour map
 */
static unsigned char red_cmap[CMAP_SIZE] = {
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 85, 
	85, 85, 85, 85, 85, 85, 85, 85, 85, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 
	170, 170, 170, 170, 170, 170, 170, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 213, 
	213, 213, 213, 213, 213, 213, 213, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255  };

/*
 * Green part of the 8 bit image colour map
 */
static unsigned char green_cmap[CMAP_SIZE] = {
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255, 
	0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 51, 51, 102, 102, 102, 102, 
	102, 102, 153, 153, 153, 153, 153, 153, 204, 204, 204, 204, 
	204, 204, 255, 255, 255, 255, 255, 255 };

/*
 * Blue part of the 8 bit image colour map
 */
static unsigned char blue_cmap[CMAP_SIZE] = { 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255, 
	0, 51, 102, 153, 204, 255  };

#endif not video_mat_DEFINED
