
#ifndef lint
static char sccs_id[]="@(#)e2h.c 1.1 10/31/94 Copyr 1990 Sun Micro";
#endif

#include <stdio.h>
#include <sys/types.h>     /* common types header file */
#include <hk_public.h>     /* DIAG_ESCAPE magic # */
#include <filehdr.h>  /* file header */
#include <n10aouth.h> /* i860 a.out file header */
#include <scnhdr.h>   /* section headers */

main (argc, argv)
int argc;
char **argv;

{
   char *valloc();
   unsigned int chksum();

   FILE *src_file;
   FILE *dst_file;
   struct filehdr hc;
   N10AOUTHDR aouthdr;
   struct scnhdr ts, ds, abs, bss;
   int abs_flg;
   int i;
   int j;
   int trap=1;
   unsigned int *buf;
   unsigned int chk;

    src_file = stdin;
    dst_file = stdout;

    /* process the arguments */
    if (argc == 2 && !strcmp(argv[1], "-n")) {
	trap = 0;
    }

    /* read the file header */
 
    if (fread(&hc,1,sizeof(struct filehdr),src_file) != FILHSZ) {
        fprintf(stderr, "%s: Unable to read i860 file header.\n", argv[0]);
        exit(-1);
    }
 
    /* make sure the magic number of the file is i860 */
 
    if (hc.f_magic != 0515) {
        fprintf(stderr, "%s: i860 file header magic # incorrect (%o).\n", argv[0], hc.f_magic);
        exit(-1);
    }
 
    /* make sure we have a text, data and bss header */
 
    if (hc.f_nscns < 3) {
        fprintf(stderr, "%s: this i860 file does not have a text, data and bss header.\n", argv[0]);
        exit(-1);
    }
 
    /* read the i860 a.out header */
 
    if (fread(&aouthdr,1,sizeof(N10AOUTHDR),src_file) != sizeof(N10AOUTHDR)) {
        fprintf(stderr, "%s: Unable to read i860 a.out header.\n", argv[0]);
        exit(-1);
    }
 
    /* read the i860 text header */
 
    if (fread(&ts,1,SCNHSZ,src_file) != SCNHSZ) {
        fprintf(stderr, "%s: Unable to read i860 text header.\n", argv[0]);
        exit(-1);
    }
 
    /* read the i860 data header */
 
    if (fread(&ds,1,SCNHSZ,src_file) != SCNHSZ) {
        fprintf(stderr, "%s: Unable to read i860 data header.\n", argv[0]);
        exit(-1);
    }
 
    /* read the i860 bss header */
 
    if (fread(&bss,1,SCNHSZ,src_file) != SCNHSZ) {
        fprintf(stderr, "%s: Unable to read i860 bss header.\n", argv[0]);
        exit(-1);
    }
 
    fseek(src_file,ts.s_scnptr,0);	/* seek to start of program section */
    buf = (unsigned int *)valloc(ts.s_size); /* grab a buffer for the data */
    if (fread(buf,1,ts.s_size,src_file) != ts.s_size) {
        fprintf(stderr, "%s: '%s' section ends prematurely.\n", argv[0],ts.s_name);
        free(buf);
        exit(-1);
    }
    fclose(src_file);

    chk = chksum(buf, ts.s_size/sizeof(int));

    fprintf(dst_file, "\n; This file is generated by %s.\n\n", sccs_id);
    fprintf(dst_file, "	diag_escape	#%#08X	;Length = %d words.\n", ts.s_size/sizeof(int)+2, ts.s_size/sizeof(int)+2);
    fprintf(dst_file, "\n;HK_ESC_I860_MAGIC #\n");
    fprintf(dst_file, "	.word		%#08X\n", HK_ESC_I860_MAGIC);
    fprintf(dst_file, "\n;I860 instructions follow\n");
    for (i = 0 ; i < ts.s_size/sizeof(int) ; i++) {
	fprintf(dst_file, "	.word		%#08X\n", *buf++);
    }

    fprintf(dst_file, "\n;Checksum from MAGIC # to here:\n");
    fprintf(dst_file, "        .word           %#08X\n", chk);

    if (trap) {
	fprintf(dst_file, "\n;Exit \n");
	fprintf(dst_file, "        trap	0\n\n");
    } else {
	fprintf(dst_file, "\n;End of diag_escape instruction \n");
    }


   exit(0);
}


/**********************************************************************/
static unsigned int
chksum(ptr, len)
/**********************************************************************/
unsigned int *ptr;
int len;

{

    unsigned int oldsum;
    unsigned int sum = 0;

    while (len--) {
	oldsum = sum;
	sum += *ptr++;
	if (sum < oldsum) {
	    sum++;
	}
    }

    return sum;
}
