#ifndef lint
static	char sccsid[] = "@(#)ir_map.c 1.1 94/10/31 Copyr 1986 Sun Micro";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */

# include "ir_c.h"

/* from code.c */

extern int	 getlab();
extern PCC_NODE *pcc_fvar();

/* from local.c */

extern char	*exname(/*name*/);

/* from pftn.c */

extern int	 tsize(/*tword,dimoff,sizoff*/);
extern int	 talign(/*tword,sizoff*/);

/* from pcc_symbol.c */

extern char	*pcc_sname(/*sym*/);
extern int	 pcc_sclass(/*sym*/);
extern int	 pcc_ssize(/*sym*/);
extern int	 pcc_salign(/*sym*/);
extern int	 pcc_soffset(/*sym*/);
extern int	 pcc_slevel(/*sym*/);
extern LIST	*pcc_symrefs(/*sym*/);
extern void	 pcc_setsymrefs(/*sym, listp*/);
extern int	 pcc_svarno(/*sym*/);
extern void      pcc_setvarno(/*sym,varno*/);
extern int	 pcc_unknown_control_flow(/*sym*/);
extern int	 pcc_makes_regs_inconsistent(/*sym*/);
extern void	 pcc_set_no_reg(/*sym*/);
extern int	 pcc_no_reg(/*sym*/);

/* from local.c */

extern PCC_NODE *p1tmpalloc(/*p*/);
extern PCC_NODE *pcc_tcopy(/*p*/);
extern PCC_NODE *build_tn();

/* from common.c */

extern void	 pcc_tfree(/*p*/);

/* from ir_alloc */

extern BLOCK	*new_block(/*s, labelno, is_entry, is_global*/);
extern IR_NODE	*new_triple(/*op,arg1,arg2,type*/);
extern LIST	*new_list();
extern void	recycle_list(/*listnode*/);

/* from ir_misc */

extern TYPE	inttype, ptrtype, uinttype;
extern IR_NODE *heap_leaf;
extern IR_NODE *ir_fcon(/*dval,type*/);
extern IR_NODE *ir_icon(/*i,type*/);
extern IR_NODE *ir_auto_var(/*name,segoffset,seglen,segalign,offset,type*/);
extern IR_NODE *ir_param_var(/*name, offset, type*/);
extern IR_NODE *ir_reg_var(/*name, regno, type*/);
extern IR_NODE *ir_static_var(/*name, labelno, offset, type*/);
extern IR_NODE *ir_extern_var(/*name, offset, type*/);
extern IR_NODE *ir_funcname(/*name, type*/);
extern IR_NODE *ir_addrcon(/*np, offset, type*/);
extern void    ir_pass(/*s*/);
extern void    ir_labeldef(/*lab*/);
extern void    ir_branch(/*n*/);
extern void    ir_mkpoint(/*np, type*/);
extern void    ir_mkoverlap(/*leaf1, leaf2*/);
extern void    ir_mkneighbor(/*leaf1, leaf2*/);
extern IR_NODE *ileaf(/*i*/);
extern IR_NODE *cleaf(/*s*/);
extern int ir_cost(/*np*/);
extern BOOLEAN non_volatile(/*np*/);

/* from ir_map_expr */

extern IR_NODE *ir_map_expr(/*p, cookie*/);

/* export */

TYPE	ir_type(/*p*/);
IR_NODE	*ir_leaf(/*p, cookie*/);
IR_NODE	*ir_addrof(/*p*/);
IR_NODE	*ir_assign(/*p, cookie*/);
IR_NODE	*ir_starg(/*p, cookie*/);
IR_NODE	*ir_stasg(/*p, cookie*/);
IR_NODE	*ir_incr(/*p, ir_opno, cookie*/);
IR_NODE	*ir_asgop(/*p, ir_opno, cookie*/);
IR_NODE	*ir_gencall(/*p, cookie*/);
IR_NODE *ir_fval(/*p, cookie*/);
void	ir_cbranch(/*p, true_lab, false_lab*/);
void	ir_switch(/*p, swtab, n*/);
void	ir_bbeg(/*autosize, regvar, fregvar*/);
void	ir_exit(/*ftype,fsize,falign,retlab*/);
void	ir_mkalias(/*sym*/);
void	ir_map_aliases(/*sym*/);
void	ir_bitfield(/*p*/);

/* forward */

static void ir_mksymref(/*np, sym*/);
static TYPE ir_param_type(/*sym*/);
static IR_NODE *ir_symbol(/*sym, offset, tword, cookie*/);
static IR_NODE *ir_genargs(/*p*/);

static IR_NODE *fval_node = NULL;

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * make an IR type with info from a PCC node
 */
TYPE
ir_type(p)
    register PCC_NODE *p;
{
    TYPE t;
    int size, align;

    if (p->in.type == PCC_TVOID || PCC_ISFTN(p->in.type)) {
	/* size, alignment undefined */
	ir_set_type(t, p->in.type, 0, 0);
    } else if (p->in.type == IR_BITFIELD) {
	/* IR_BITFIELD type is generated by flattening a PCC_FLD op */
	ir_set_type(t, p->in.type, p->fn.bfwidth, p->fn.bfoffset);
    } else {
	size = tsize(p->in.type, p->fn.cdim, p->fn.csiz)/SZCHAR;
	align = talign(p->in.type, p->fn.csiz)/SZCHAR;
	ir_set_type(t, p->in.type, size, align);
    }
    return t;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * compute aliasing info for each leaf that refers to this
 * symbol.  This consists of assigning variable id #'s from
 * the symbol table to all aliased leaf nodes on the symbol's
 * reference list, and computing overlap lists for all leaf
 * nodes that overlap.  Note that:
 *
 * 1. PCC symbols with classes other than MOU (member-of-union)
 *    are guaranteed not to overlap.
 *
 * 2. Only symbols with real storage classes (i.e., the outermost
 *    enclosing struct/union variables) are passed in PCC tree nodes.
 *
 * Thus, overlapping memory operands can always be associated
 * with a unique symbol; static overlaps with other symbols will
 * not occur.  Overlapping memory operands can be generated by type
 * punning (e.g., casts on the left hand side of an assignment), but
 * the operands are still associated with a unique symbol.
 */

void
ir_map_aliases(sym)
    register struct pcc_symtab *sym;
{
    LIST *p, *q;
    LEAF *leaf1, *leaf2;
    OFFSZ lb1, lb2, ub1, ub2;
    OFFSZ bfoff1, bfoff2;
    int bfsz1, bfsz2;
    OFFSZ lub, glb;
    int varno;
    int aliased;
    int no_reg;

    varno = pcc_svarno(sym);
    no_reg = pcc_no_reg(sym);
    for (p = pcc_symrefs(sym); p != NULL; p = p->next) {
	/*
	 * If a symbol may be affected by indirect memory
	 * accesses, assign its var id # to all operands
	 * that reference it
         */
	leaf1 = (LEAF*)p->datap;
	if (varno > 0) {
	    leaf1->elvarno = varno;
	    ir_mkoverlap(heap_leaf, leaf1);
	}
	/*
	 * Pass along the "cannot reside in a register" attribute
	 */
	leaf1->no_reg = (BOOLEAN)no_reg;
	/*
	 * extract leaf1's bit field attributes, if any
	 */
	if (leaf1->type.tword == IR_BITFIELD) {
	    bfoff1 = leaf1->type.align; /* bit offset from base address */
	    bfsz1 = leaf1->type.size;	/* size of field, in bits */
	} else {
	    bfoff1 = 0;			     /* bit offset is zero */
	    bfsz1 = leaf1->type.size*SZCHAR; /* convert from bytes to bits */
	}
	/*
	 * compute static overlap lists
	 */
	for (q = pcc_symrefs(sym); q != NULL; q = q->next) {
	    leaf2 = (LEAF*)q->datap;
	    if (q != p && leaf1 != leaf2) {
		/*
		 * extract leaf2's bit field attributes, if any
		 */
		if (leaf2->type.tword == IR_BITFIELD) {
		    bfoff2 = leaf2->type.align; /* bit field offset */
		    bfsz2 = leaf2->type.size;	/* size of field, in bits */
		} else {
		    bfoff2 = 0;				/* bit offset is 0 */
		    bfsz2 = leaf2->type.size*SZCHAR;	/* bytes => bits */
		}
		/* lower and upper bounds of leaf 1 */
		lb1 = (leaf1->val.addr.offset*SZCHAR) + bfoff1;
		ub1 = lb1 + bfsz1;
		/* lower and upper bounds of leaf 2 */
		lb2 = (leaf2->val.addr.offset*SZCHAR) + bfoff2;
		ub2 = lb2 + bfsz2;
		/* least upper and greatest lower bounds */
		lub = (ub1 < ub2 ? ub1 : ub2);
		glb = (lb1 > lb2 ? lb1 : lb2);
		if (glb < lub) {
		    /* add leaf2 to leaf1's overlap list */
		    ir_mkoverlap(leaf1, leaf2);
		} else {
		    /* add leaf2 to leaf1's list of neighbors */
		    ir_mkneighbor(leaf1, leaf2);
		}
	    }
	}
    }
    /*
     * recycle the symbol's reference list.
     */
    for (p = pcc_symrefs(sym); p != NULL; p = q) {
	q = p->next;
	recycle_list(p);
    }
    pcc_setsymrefs(sym, NULL);
    pcc_setvarno(sym, 0);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * add a leaf to the list of leaf nodes referring
 * to a given symbol.  Assume symbol is a variable name.
 */
static void
ir_mksymref(np, sym)
    IR_NODE *np;
    struct pcc_symtab *sym;
{
    LIST *listp;
    listp = new_list();
    listp->next = pcc_symrefs(sym);
    listp->datap = (union list_u*)np;
    pcc_setsymrefs(sym, listp);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Mark a symbol as belonging to the set of names that may
 * be affected by pointer indirection.  The symbol is assigned
 * a variable id number, which will later be assigned to all of
 * the leaf nodes that reference it.  In this way, members of the
 * same structure or union will get the same variable id number.
 */
void
ir_mkalias(sym)
    struct pcc_symtab *sym;
{
    if (pcc_svarno(sym) == 0) {
	pcc_setvarno(sym, naliases++);
    }
}

/*
 * construct an IR TYPE for a symbol of class PARAM;
 * the details are dependent on system/architecture
 * calling conventions.
 */
static TYPE
ir_param_type(sym)
    struct pcc_symtab *sym;
{
    TYPE param_type;
    TWORD stype;
    /*
     * Construct a type descriptor for the parameter,
     * based on information from the symbol table.  Note
     * that structure parameters on sparc are really
     * structure pointer parameters!
     */
    stype = pcc_stype(sym);
#if TARGET == SPARC
    if (stype == PCC_STRTY || stype == PCC_UNIONTY) {
	stype = PCC_INCREF(stype);
	ir_set_type(param_type, stype, SZPOINT/SZCHAR, ALPOINT/SZCHAR);
    } else {
	ir_set_type(param_type, stype, pcc_ssize(sym)/SZCHAR,
	    pcc_salign(sym)/SZCHAR);
    }
#else
    ir_set_type(param_type, stype, pcc_ssize(sym)/SZCHAR,
	pcc_salign(sym)/SZCHAR);
#endif
    return param_type;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * make a leaf for a symbol table entry + offset
 */
static IR_NODE*
ir_symbol(sym, offset, t, cookie)
    struct pcc_symtab *sym;
    OFFSZ offset;
    TYPE t;
    COOKIE cookie;
{
    int class;
    int level;
    int labelno;
    int regno;
    char *name;
    IR_NODE  *np;
    BOOLEAN must_conv;	/* true if PCONV must be generated before returning */
    TYPE newtype;	/* type of PCONV triple */
    PCC_TWORD stype;	/* type from symbol, with enums mapped to ints */
    OFFSZ symoff;
    OFFSZ symlen;
    int symalign;

    name = pcc_sname(sym);
    class = pcc_sclass(sym);
    stype = pcc_stype(sym);
    newtype = t;
#   if TARGET == SPARC
	if ( class == PCC_PARAM ) {
	    TYPE param_type;	/* parameter type, from symbol table */
	    /*
	     * generate a VAR leaf node with the parameter's true type,
	     * in order to guarantee that parameter storage will be
	     * initialized properly from i-registers.  For example,
	     * given "foo(trouble) double trouble;" the expression
	     * "bar((char*)&trouble)" will generate a leaf of type CHAR,
	     * and if we don't generate a leaf of type DOUBLE here,
	     * the storage will not be initialized.
	     */
	    param_type = ir_param_type(sym);
	    np = ir_param_var(name, offset + pcc_soffset(sym)/SZCHAR,
		param_type);
	    ir_mksymref(np, sym);
	    ir_mkpoint(np,param_type);
	}
#   endif
    if (stype != t.tword && cookie != FOR_ASSIGN) {
	/*
	 * We are fudging the type of something, and we are also
	 * not on the left hand side of an assignment.  Take note,
	 * use the true type, and fix the type up by generating an
	 * IR_PCONV triple.
	 *
	 * The purpose of this contortion is to avoid unnecessary
	 * overlap relations, which inhibit register allocation.
	 */
	if ( (PCC_ISPTR(stype) || PCC_ISINTEGRAL(stype))
	  && (PCC_ISPTR(t.tword) || PCC_ISINTEGRAL(t.tword))
	  && t.size == pcc_ssize(sym)/SZCHAR ) {
	    must_conv = TRUE;
	    t.tword = stype;
	} else {
	    must_conv = FALSE;
	}
    } else {
	/*
	 * If the types don't match, -- a new (overlapping)
	 * leaf will be created
	 */
	must_conv = FALSE;
    }
    switch(class) {
    case PCC_REGISTER:
	regno = pcc_soffset(sym);
	np = ir_reg_var(name, regno, t); /* offset is reg # */
	ir_mksymref(np, sym);
	ir_mkpoint(np,t);
	break;

    case PCC_PARAM:
	offset += pcc_soffset(sym)/SZCHAR;
	np = ir_param_var(name, offset, t);
	ir_mksymref(np, sym);
	ir_mkpoint(np,t);
	break;

    case PCC_AUTO:
	symoff = pcc_soffset(sym)/SZCHAR;
	symlen = pcc_ssize(sym)/SZCHAR;
	symalign = pcc_salign(sym)/SZCHAR;
	np = ir_auto_var(name, symoff, symlen, symalign, offset, t);
	ir_mksymref(np, sym);
	ir_mkpoint(np,t);
	break;

    case PCC_ULABEL:
    case PCC_LABEL:
    case PCC_STATIC:
    case PCC_USTATIC:
	name = exname(name);
	level = pcc_slevel(sym);
	if (level <= 1) {
	    /* visible outside this routine */
	    np = ir_extern_var(name, offset, t);
	    ir_mkalias(sym);
	} else {
	    /*
	     * local to current routine, no external name;
	     * we still have to treat it as an external, due
	     * to the possibility of recursion
	     */
	    labelno = pcc_soffset(sym);
	    np = ir_static_var(name, labelno, offset, t);
	}
	ir_mksymref(np, sym);
	ir_mkpoint(np,t);
	break;

    case PCC_EXTERN:
    case PCC_EXTDEF:
	name = exname(name);
	np = ir_extern_var(name, offset, t);
	ir_mkalias(sym);
	ir_mksymref(np, sym);
	ir_mkpoint(np,t);
	break;

    default:
	printf("class = %d \n",class);
	cerror("ir_symbol: unknown class");
    }
    /*
     * generate a pointer=>pointer conversion.  On
     * most machines, this is a no-op.
     */
    if (must_conv) {
	np = new_triple(IR_PCONV, np, NULL, newtype);
    }
    return np;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * make sure all the arguments go into the leaf table (for TRE use)
 * called by bfcode().
 * for sparc, must_store_arg is changed to be TRUE in ir_param_var
 * if the argument is acturally referenced in the code.
 */
ir_argument(sym)
	struct pcc_symtab *sym;
{
	LEAF *np;
	TYPE param_type;
	TWORD stype;

	param_type = ir_param_type(sym);
	np = (LEAF *)ir_symbol(sym, 0, param_type, FOR_VALUE);
#if TARGET == SPARC
	np->must_store_arg = FALSE;
#endif
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * map a PCC leaf node to an IR leaf node.
 */
IR_NODE *
ir_leaf(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    IR_NODE *np;
    struct pcc_symtab *sym;
    TYPE t, ptr_t, true_t;
    PCC_TWORD tword;

    t = ir_type(p);
    switch(p->tn.op) {
    case PCC_REG:
	/* register var */
	if (cookie == FOR_ADDRESS) {
	    goto cannot_address;
	}
	np = ir_reg_var(regname(p->tn.rval), p->tn.rval, t);
	break;

    case PCC_FCON:
	/* floating point constant */
	if (cookie == FOR_ADDRESS) {
	    goto cannot_address;
	}
	np = ir_fcon(p->fpn.dval, t);
	break;

    case PCC_NAME:
	/*
	 * check for names with no symbol table entry; these
	 * may have been generated for references to strings
	 * (e.g., "12345"[0])
	 */
	if (cookie == FOR_ADDRESS) {
	    p->tn.op = PCC_ICON;
	    p->tn.type = PCC_INCREF(p->tn.type);
	    return ir_leaf(p, FOR_VALUE);
	}
	if (p->tn.rval < 0) {
	    /* rval is -(label number), no symbol table entry  */
	    np = ir_static_var("", -p->tn.rval, p->tn.lval, t);
	} else {
	    sym = PCC_STP(p->tn.rval);
	    if (sym == NULL) {
		cerror("NAME with no symbol table entry");
		/*NOTREACHED*/
	    }
	    np = ir_symbol(sym, p->tn.lval, t, cookie);
	}
	break;

    case PCC_ICON:
	/*
	 * We have 3 cases to deal with here: anonymous address
	 * constants, which are identified by a negative label
	 * number and are generated for expressions involving strings;
	 * named address constants, and anonymous integral constants.
	 */
	if (cookie == FOR_ADDRESS) {
	    goto cannot_address;
	}
	if (p->tn.rval < 0) {
	    /* rval is -(label number), no symbol table entry, no aliasing */
	    ptr_t = t;
	    p->tn.type = PCC_DECREF(p->tn.type);
	    t = ir_type(p);	/* recompute type */
	    np = ir_static_var("", -p->tn.rval, 0, t);
	    np = ir_addrcon(np, p->tn.lval, ptr_t);
	} else {
	    sym = PCC_STP(p->tn.rval);
	    if (sym == NULL){
		/* no-name constant */
		np = ir_icon(p->tn.lval, t);
	    } else {
		/*
		 * named address constant.  Note that in general, the type
		 * from the expression tree will be different from that of
		 * the symbol table.  We want to generate an ADDR_CONST of
		 * type PTR (typeof(sym)), then convert to the type inherited
		 * from the expression tree.
		 */
		tword = pcc_stype(sym);
		ptr_t = ptrtype;
		ptr_t.tword = PCC_INCREF(tword);
		if (PCC_ISFTN(tword)) {
		    /* map function names as CONST_LEAF nodes */
		    np = ir_funcname(exname(pcc_sname(sym)), ptr_t);
		    if (pcc_unknown_control_flow(sym)) {
			np->leaf.unknown_control_flow = IR_TRUE;
		    }
		    if (pcc_makes_regs_inconsistent(sym)) {
			np->leaf.makes_regs_inconsistent = IR_TRUE;
		    }
		    if (p->tn.lval != 0) {
			/* dss bullshit */
			np = new_triple(IR_PLUS, np, ileaf(p->tn.lval), ptr_t);
		    }
		} else {
		    /* map other names as ADDR_CONST_LEAF nodes */
		    ir_set_type(true_t, tword, pcc_ssize(sym)/SZCHAR,
			pcc_salign(sym)/SZCHAR);
		    /* use FOR_ASSIGN to guarantee addressability */
		    np = ir_symbol(sym, 0, true_t, FOR_ASSIGN);
		    np = ir_addrcon(np, p->tn.lval, ptr_t);
		    ir_mkalias(sym);
		    /* this name cannot reside in a register */
		    pcc_set_no_reg(sym);
		}
		/* convert to expression type */
		if (!same_irtype(ptr_t, t)) {
		    np = new_triple(IR_PCONV, np, NULL, t);
		}
	    }
	}
	break;

    cannot_address:
	cerror("ir_leaf: cannot take address of op %s", pcc_opname(p->in.op));
	/*NOTREACHED*/

    default:
	cerror("ir_leaf: illegal leaf node, op = '%s'", pcc_opname(p->in.op));
	/*NOTREACHED*/
    }
    pcc_tfree(p);
    return np;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * create a leaf node for a temp copy of p
 */
IR_NODE *
ir_temp(p)
    PCC_NODE *p;
{
    PCC_NODE *tmp;
    IR_NODE *np;

    tmp = p1tmpalloc(p);
    np = ir_leaf(tmp, FOR_VALUE);
    pcc_tfree(tmp);
    return np;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * the result of a bitfield assignment, if any,
 * must be truncated to the field width.  The
 * width is described by the field type t.
 */
IR_NODE *
ir_truncfield(ir_result, t)
    IR_NODE *ir_result;
    TYPE t;
{
    IR_NODE *ir_tmp;
    unsigned mask;
 
    mask = bitmask(t.size);
    if (ir_result->operand.tag == ISLEAF
      && ir_result->leaf.class == CONST_LEAF) {
	/* chop at compile time */
	mask &= ir_result->leaf.val.const.c.i;
	ir_result = ir_icon(mask, uinttype);
    } else {
	/* chop at run time */
	ir_tmp = ir_icon(mask, uinttype);
	ir_result = new_triple(IR_AND, ir_result, ir_tmp, uinttype);
    }
    return ir_result;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * map an assignment operator.  If cookie == FOR_VALUE, a
 * temp is generated, assigned the value of the rhs,
 * and returned as the value of the expression.  Otherwise,
 * NULL is returned.
 */
IR_NODE *
ir_assign(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    IR_NODE *ir_lp, *ir_rp, *ir_tmp, *ir_result;
    IR_OP ir_opno;
    PCC_NODE *lp, *rp, *tmp;
    TYPE t;
    COOKIE lcookie;
    int op;
    int opty;

    lp = p->in.left;
    if (lp->in.op == PCC_FLD) {
	ir_bitfield(lp);
    }
    t = ir_type(lp);
    op = lp->in.op;
    opty = pcc_optype(op);
    rp = p->in.right;
    /*
     * select the operator to compile the assignment.
     * lcookie says how we want the lhs evaluated.
     */
    if (opty == PCC_LTYPE) {
	ir_opno = IR_ASSIGN;
	lcookie = FOR_ASSIGN;
    } else if (op == PCC_UNARY_MUL) {
	ir_opno = IR_ISTORE;
	lcookie = FOR_ADDRESS;
    } else {
	cerror("cannot assign to lhs");
    }
    /*
     * evaluate lhs, rhs; if a value must be returned,
     * try to use one of the operands as the result.
     * If you do this, make sure the operand is not
     * volatile.
     */
    tmp = pcc_tcopy(rp);	/* in case we need temporary */
    ir_lp = ir_map_expr( lp, lcookie );
    ir_rp = ir_map_expr( rp, FOR_VALUE );
    if (t.tword != IR_BITFIELD && !same_irtype(t, ir_rp->operand.type)) {
	ir_rp = new_triple(IR_CONV, ir_rp, NULL, t);
    }
    if (cookie == FOR_VALUE) {
	if ( ir_opno == IR_ASSIGN && non_volatile(ir_lp) ) {
	    /*
	     * direct assignment to simple lhs
	     */
	    if ( non_volatile(ir_rp) ) {
		/*
		 * one of {lhs,rhs} can be used as the result
		 */
		(void) new_triple(ir_opno, ir_lp, ir_rp, t);
		ir_result = ( ir_cost(ir_rp) < ir_cost(ir_lp) ? ir_rp : ir_lp );
	    } else {
		/*
		 * use lhs as the result
		 */
		(void) new_triple(ir_opno, ir_lp, ir_rp, t);
		ir_result = ir_lp;
	    }
	} else if ( non_volatile(ir_rp) ) {
	    /*
	     * use rhs as the result
	     */
	    (void) new_triple(ir_opno, ir_lp, ir_rp, t);
	    ir_result = ir_rp;
	} else {
	    /*
	     * both sides are either complicated or volatile; store
	     * value of rhs into temp and return it
	     */
	    ir_tmp = ir_temp(tmp);
	    (void) new_triple(IR_ASSIGN, ir_tmp, ir_rp, ir_tmp->operand.type);
	    (void) new_triple(ir_opno, ir_lp, ir_tmp, t);
	    ir_result = ir_tmp;
	}
	if (t.tword == IR_BITFIELD) {
	    /* truncate result to field width */
	    ir_result = ir_truncfield(ir_result, t);
	}
    } else {
	/*
	 * no value requested, none returned
	 */
	(void) new_triple(ir_opno, ir_lp, ir_rp, t);
	ir_result = NULL;
    }
    pcc_tfree(tmp);
    pcc_freenode(p);
    return ir_result;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Map a structure assignment operator.  This is similar to
 * ir_assign, except that operands of STASG are lvalues rather
 * than rvalues.  Nevertheless, they are still translated to
 * IR using IR_ASSIGN and IR_IFETCH/IR_STORE.  
 * 
 * If cookie == FOR_VALUE, the (pointer) value of the lhs or rhs
 * (whichever is cheaper) is returned as the value of the expression.
 * If necessary, a temporary is allocated, assigned, and returned as
 * the result.
 *
 * If cookie != FOR_VALUE, the result is NULL.
 */
IR_NODE *
ir_stasg(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    IR_NODE *ir_lp, *ir_rp, *ir_tmp, *ir_result;
    PCC_NODE *lp, *rp;
    TYPE t;
    COOKIE lcookie;

    lp = p->in.left;
    rp = p->in.right;
    /*
     * if a value must be returned, try to use
     * one of the (pointer) operands as the result
     */
    ir_tmp = NULL;
    ir_result = NULL;
    if (cookie == FOR_VALUE) {
	if (pcc_optype(lp->in.op) == PCC_LTYPE) {
	    /*
	     * use lhs as the result
	     */
	    ir_result = ir_map_expr(pcc_tcopy(lp), FOR_VALUE);
	} else if (pcc_optype(rp->in.op) == PCC_LTYPE) {
	    /*
	     * use rhs as the result
	     */
	    ir_result = ir_map_expr(pcc_tcopy(rp), FOR_VALUE);
	} else {
	    /*
	     * both sides are complicated; allocate a temporary,
	     * in which we will subsequently store a pointer to the
	     * lhs.
	     */
	    ir_result = ir_tmp = ir_temp(lp);
	}
    }
    /*
     * evaluate the rhs first
     */
    p->in.type = PCC_DECREF(p->in.type);
    t = ir_type(p);
    if (rp->in.op == PCC_ICON && PCC_STP(rp->tn.rval) != NULL) {
	rp->in.op = PCC_NAME;
	rp->in.type = PCC_DECREF(rp->in.type);
	ir_rp = ir_map_expr(rp, FOR_VALUE);
    } else {
	ir_rp = ir_map_expr(rp, FOR_VALUE);
	if (PCC_ISPTR(ir_rp->operand.type.tword)) {
	    ir_rp = new_triple(IR_IFETCH, ir_rp, NULL, t);
	}
    }
    /*
     * evaluate the lhs, saving a copy of it if necessary;
     * then generate an ASSIGN or an ISTORE as appropriate
     */
    if (lp->in.op == PCC_ICON && PCC_STP(lp->tn.rval) != NULL) {
	lp->in.op = PCC_NAME;
	lp->in.type = PCC_DECREF(lp->in.type);
	ir_lp = ir_leaf(lp, FOR_ASSIGN);
	(void) new_triple(IR_ASSIGN, ir_lp, ir_rp, t);
    } else {
	ir_lp = ir_map_expr(lp, FOR_VALUE);
	if (ir_tmp != NULL) {
	    (void)new_triple(IR_ASSIGN, ir_tmp, ir_lp, ir_tmp->leaf.type);
	    ir_lp = ir_tmp;
	}
	(void) new_triple(IR_ISTORE, ir_lp, ir_rp, t);
    }
    pcc_freenode(p);
    return ir_result;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Map a structured argument.  This is a special case,
 * because STARG has implied indirection, like UNARY_MUL,
 * but a STARG over an ICON will not have been reduced to
 * a NAME by earlier phases.
 */
IR_NODE	*
ir_starg(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    PCC_NODE *lp;
    IR_NODE *ir_lp;

    if (cookie != FOR_VALUE) {
	cerror("ir_starg: illegal STARG");
    }
    lp = p->in.left;
    if (lp->in.op == PCC_ICON && PCC_STP(lp->tn.rval) != NULL) {
	/* map the STARG(ICON) combination as a NAME */
	lp->in.op = PCC_NAME;
	lp->in.type = PCC_DECREF(lp->in.type);
	pcc_freenode(p);
	return ir_map_expr(lp, FOR_VALUE);
    }
    /* map all other STARG(...) combinations as U*(...) */
    p->in.op = PCC_UNARY_MUL;
    return ir_map_expr(p, FOR_VALUE);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * return a function result.  In PCC, this is a PCC_FORCE operator,
 * whose operand is an lvalue (in the case of a structured result)
 * or an rvalue (in the other cases).
 *
 * The straightforward approach would be to generate an IR_FVAL triple
 * here and branch to the exit block, but this makes a temp reg live
 * across basic blocks, which is bad news if someone inserts code in
 * the exit block.
 *
 * The solution used here is to assign the function result to a
 * hidden variable, and delay loading the function result register
 * until the exit block is reached.
 *
 * Note that if a structure is to be returned, we do NOT want to
 * allocate a structured temporary for the result.  So we leave
 * the result type as PTR STRTY, and dereference it once, on exit.
 */
IR_NODE *
ir_fval(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    IR_NODE *lp, *rp;

    lp = ir_map_expr(pcc_fvar(), FOR_ASSIGN);
    rp = ir_map_expr(p->in.left, FOR_VALUE);
    fval_node = lp;
    /* make sure operand type agrees with function type */
    if (!same_irtype(lp->operand.type, rp->operand.type)) {
	rp = new_triple(IR_CONV, rp, NULL, lp->operand.type);
    }
    (void)new_triple(IR_ASSIGN, lp, rp, lp->operand.type);
    return (cookie == FOR_VALUE ? lp : NULL);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Map a binary operator with assignment.  The function
 * result is determined by "cookie", as in ir_assign().
 * This routine is more complicated because the lhs is
 * referenced twice, but expensive address calculations
 * (particularly those containing side effects) must
 * be evaluated only once.
 */
IR_NODE *
ir_asgop(p, ir_opno, cookie)
    PCC_NODE *p;
    IR_OP ir_opno;
    COOKIE cookie;
{
    TYPE t,ltype;
    IR_NODE *ir_lp, *ir_rp, *ir_tmp, *ir_dest, *ir_result;
    PCC_NODE *lp, *lcopy;
    IR_OP store_op;	/* ASSIGN, ISTORE, BFDEP */
    int hard_lhs;	/* =1 if the lvalue must be evaluated into a temp */

    /*
     * to set up, look at the immediate lhs; that tells us which
     * IR operator we will eventually use.  Then if necessary, probe
     * downward until we hit the subtree that represents the lvalue.
     */
    lp = p->in.left;
    if (lp->in.op == PCC_FLD) {
	ir_bitfield(lp);
    }
    t = ir_type(lp);
    if (lp->in.op == PCC_UNARY_MUL) {
	/* indirect assignment */
	store_op = IR_ISTORE;
	lp = lp->in.left;
    } else {
	/* direct assignment */
	store_op = IR_ASSIGN;
    }
    /*
     * make a wild guess as to whether or not to
     * evaluate the lvalue into a temporary
     */
    if (lp->in.op == PCC_PLUS
      && pcc_optype(lp->in.right->in.op) ==  PCC_LTYPE
      && pcc_optype(lp->in.left->in.op) ==  PCC_LTYPE) {
	hard_lhs = 0;
    } else {
	hard_lhs = (pcc_optype(lp->in.op) !=  PCC_LTYPE);
    }
    /*
     * If the lhs is complicated, evaluate its address into a
     * temp, and use the temp to get at the value of the lhs.
     * In the simpler case, just evaluate the lhs twice.
     */
    if (hard_lhs) {
	ir_tmp = ir_temp(lp);
	ltype = ir_type(lp);
	ir_lp = ir_map_expr( lp, FOR_VALUE );
	(void)new_triple(IR_ASSIGN, ir_tmp, ir_lp, ltype);
	ir_dest = ir_tmp;				/* address of lhs */
	ir_lp = new_triple(IR_IFETCH, ir_tmp, NULL, t); /* value of lhs */
    } else {
	lcopy = pcc_tcopy(p->in.left);
	if (store_op == IR_ASSIGN) {
	    ir_dest = ir_leaf(lp, FOR_ASSIGN);		/* lhs is leaf */
	} else {
	    ir_dest = ir_map_expr(lp, FOR_VALUE);	/* lhs is leaf+leaf */
	}
	ir_lp = ir_map_expr(lcopy, FOR_VALUE);		/* value of lhs */
    }
    /*
     * evaluate the binary operator, and if it is required that
     * we return a value for this assignment, grope around for
     * something to return.  This may involve another temp.
     */
    if (cookie == FOR_VALUE) {
	if (ir_cost(ir_lp) <= COST_SIMPLE) {
	    /*
	     * lhs is simple; use as is
	     */
	    ir_rp = ir_map_expr(p->in.right, FOR_VALUE);
	    ir_rp = new_triple(ir_opno, ir_lp, ir_rp, t);
	    (void)new_triple(store_op, ir_dest, ir_rp, t);
	    ir_result = ir_lp;
	} else {
	    /*
	     * lhs is complicated; store value of (lhs op rhs) into
	     * temp and use that instead.
	     */
	    ir_tmp = ir_temp(p);
	    ir_rp = ir_map_expr(p->in.right, FOR_VALUE);
	    ir_rp = new_triple(ir_opno, ir_lp, ir_rp, t);
	    (void)new_triple(IR_ASSIGN, ir_tmp, ir_rp, t);
	    (void)new_triple(store_op, ir_dest, ir_tmp, t);
	    ir_result = ir_tmp;
	}
	if (t.tword == IR_BITFIELD) {
	    /* truncate result to field width */
	    ir_result = ir_truncfield(ir_result, t);
	}
    } else {
	/*
	 * no value requested, none returned
	 */
	ir_rp = ir_map_expr(p->in.right, FOR_VALUE);	/* value of rhs */
	ir_rp = new_triple(ir_opno, ir_lp, ir_rp, t);
	(void)new_triple(store_op, ir_dest, ir_rp, t);
	ir_result = NULL;
    }
    pcc_tfree(p);
    return ir_result;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Compile a post-increment/decrement operator.
 * Note that some postincrements with simple operands
 * are handled by ir_compile(), which attempts to pull
 * the operators out and evaluate them for effect
 * after the end of the statement.
 */

IR_NODE *
ir_incr(p, ir_opno, cookie)
    PCC_NODE *p;
    IR_OP ir_opno;
    COOKIE cookie;
{
    TYPE t, ltype;
    PCC_NODE *lp, *lcopy, *rcopy;
    IR_NODE *ir_lp, *ir_rp, *ir_tmp;

    /*
     * if no value is required, compile as an ASG op.
     */
    if (cookie == FOR_EFFECT) {
	(void)ir_asgop(p, ir_opno, cookie);
	return NULL;
    }
    /*
     * for simple x, rewrite (x++) as (tmp=x,(x+=1),tmp)
     */
    lp = p->in.left;
    if (pcc_optype(lp->in.op) == PCC_LTYPE) {
	ltype = ir_type(lp);
	lcopy = pcc_tcopy(lp);
	ir_tmp = ir_temp(lp);
	ir_lp = ir_map_expr(lcopy, FOR_VALUE);
	(void)new_triple(IR_ASSIGN, ir_tmp, ir_lp, ltype);
	if (ir_cost(ir_lp) <= COST_SIMPLE) {
	    /* x += rhs */
	    (void)ir_asgop(p, ir_opno, cookie);
	} else {
	    /* x = tmp + rhs */
	    ir_lp = ir_leaf(lp, FOR_ASSIGN);
	    ir_rp = ir_map_expr(p->in.right, FOR_VALUE);
	    ir_rp = new_triple(ir_opno, ir_tmp, ir_rp, ltype);
	    (void)new_triple(IR_ASSIGN, ir_lp, ir_rp, ltype);
	    pcc_freenode(p);
	}
	return ir_tmp;
    }
    /*
     * bit field operands: if the field is a simple variable,
     * rewrite as (tmp=FLD(x), FLD(x)=tmp+1, tmp).  Otherwise,
     * rewrite as (addr=(...), tmp=FLD(*addr), FLD(*addr)=tmp+1, tmp)
     */
    if (lp->in.op == PCC_FLD) {
	ltype = ir_type(lp);
	ir_tmp = ir_temp(lp);
	if (pcc_optype(lp->in.left->in.op) == PCC_LTYPE) {
	    /*
	     * tmp = FLD(x)
	     */
	    lcopy = pcc_tcopy(lp);
	    ir_lp = ir_map_expr(lcopy, FOR_VALUE);
	    (void)new_triple(IR_ASSIGN, ir_tmp, ir_lp, ltype);
	    /*
	     * FLD(x) = tmp + 1
	     */
	    ir_bitfield(lp);
	    ir_lp = ir_leaf(lp, FOR_ASSIGN);
	    ir_rp = ir_leaf(p->in.right, FOR_VALUE);
	    ir_rp = new_triple(ir_opno, ir_tmp, ir_rp, ltype);
	    (void)new_triple(IR_ASSIGN, ir_lp, ir_rp, ltype);
	} else {
	    /*
	     * complex: rewrite (*(...))++ as
	     * (addr=(...), val=FLD(*addr), FLD(*addr)=val+1, val)
	     */
	    PCC_NODE *llp;
	    IR_NODE *ir_addr;
	    TYPE addr_type, field_type;
	    /*
	     * addr = (...)
	     */
	    llp = lp->in.left;
	    if (llp->in.op != PCC_UNARY_MUL) {
		cerror("ir_incr: expected U*");
	    }
	    ir_addr = ir_temp(llp->in.left);
	    addr_type = ir_type(llp->in.left);
	    ir_rp = ir_map_expr(llp->in.left, FOR_VALUE);
	    (void)new_triple(IR_ASSIGN, ir_addr, ir_rp, addr_type);
	    pcc_freenode(llp);
	    /*
	     * val = FLD(*addr)
	     */ 
	    ir_bitfield(lp);
	    field_type = ir_type(lp);
	    ir_rp = new_triple(IR_IFETCH, ir_addr, NULL, field_type);
	    ir_rp = new_triple(IR_CONV, ir_rp, NULL, ltype);
	    (void)new_triple(IR_ASSIGN, ir_tmp, ir_rp, ltype);
	    /*
	     * FLD(*addr) = val+1
	     */
	    ir_rp = ir_leaf(p->in.right, FOR_VALUE);
	    ir_rp = new_triple(ir_opno, ir_tmp, ir_rp, ltype);
	    (void)new_triple(IR_ISTORE, ir_addr, ir_rp, field_type);
	}
	pcc_freenode(p);
	return ir_tmp;
    }
    /*
     * rewrite (x++) as ((x+=1)-1).  (bletch)
     */
    t = ir_type(p);
    rcopy = pcc_tcopy(p->in.right);
    ir_lp = ir_asgop(p, ir_opno, FOR_VALUE);
    ir_rp = ir_leaf(rcopy, FOR_VALUE);
    ir_opno = (ir_opno == IR_PLUS? IR_MINUS: IR_PLUS);
    return new_triple(ir_opno, ir_lp, ir_rp, t);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Compile conditional branching constructs.
 * These will branch to true_lab or false_lab, according
 * to the boolean value of the expression (p).  Label < 0
 * means fall through, i.e., define the label before returning.
 */
void
ir_cbranch(p, true_lab, false_lab)
    PCC_NODE *p;
    int true_lab;
    int false_lab;
{
    IR_NODE *cond, *true_dest, *false_dest;
    int t_lab,f_lab,lab;

    switch(p->in.op) {

    case PCC_ANDAND:
	f_lab = (false_lab < 0 ? getlab() : false_lab);
	ir_cbranch(p->in.left, LABFALLTHRU, f_lab);
	ir_cbranch(p->in.right, true_lab, false_lab);
	if (false_lab < 0) ir_labeldef( f_lab );
	pcc_freenode(p);
	break;

    case PCC_OROR:
	t_lab = (true_lab < 0 ? getlab() : true_lab);
	ir_cbranch(p->in.left, t_lab, LABFALLTHRU);
	ir_cbranch(p->in.right, true_lab, false_lab);
	if (true_lab < 0) ir_labeldef(t_lab);
	pcc_tfree(p);
	break;

    case PCC_NOT:
	ir_cbranch(p->in.left, false_lab, true_lab);
	pcc_freenode(p);
	break;

    case PCC_COMOP:
	ir_map_expr( p->in.left, FOR_EFFECT );
	ir_cbranch( p->in.right, true_lab, false_lab);
	pcc_freenode(p);
	return;

    case PCC_QUEST:
	f_lab = false_lab < 0 ? getlab() : false_lab;
	t_lab = true_lab < 0 ? getlab() : true_lab;
	ir_cbranch( p->in.left, LABFALLTHRU, lab = getlab() );
	ir_cbranch( p->in.right->in.left, t_lab, f_lab );
	ir_labeldef( lab );
	ir_cbranch( p->in.right->in.right, true_lab, false_lab );
	pcc_freenode(p->in.right);
	if( true_lab < 0 ) ir_labeldef( t_lab);
	if( false_lab < 0 ) ir_labeldef( f_lab );
	pcc_freenode(p);
	break;

    case PCC_ICON:
	if( p->tn.lval || PCC_STP(p->tn.rval) || p->tn.rval < 0 ){
	    /* addresses of C objects are never 0 */
	    if( true_lab>=0 ) ir_branch( true_lab );
	} else if( false_lab>=0 ) {
	    ir_branch( false_lab );
	}
	pcc_freenode(p);
	break;

    case PCC_FCON:
	if( p->fpn.dval != 0.0 ) {
	    if( true_lab>=0 ) ir_branch( true_lab );
	} else if( false_lab>=0 ) {
	    ir_branch( false_lab );
	}
	pcc_freenode(p);
	break;

    default:
	cond = ir_map_expr(p, FOR_VALUE);
	t_lab = (true_lab < 0 ? getlab() : true_lab);
	f_lab = (false_lab < 0 ? getlab() : false_lab);
	true_dest = new_triple(IR_LABELREF, ileaf(t_lab), ileaf(1), inttype);
	false_dest = new_triple(IR_LABELREF, ileaf(f_lab), ileaf(0), inttype);
	TAPPEND((TRIPLE*)true_dest, (TRIPLE*)false_dest);
	(void)new_triple(IR_CBRANCH, cond, true_dest,  inttype);
	if (true_lab < 0) ir_labeldef( t_lab );
	if (false_lab < 0) ir_labeldef( f_lab );
	break;
    }
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * evaluate a PCC argument list, and return a list of
 * IR_PARAM triples linked in left-to-right evaluation order.
 */
static IR_NODE *
ir_genargs(p)
    PCC_NODE *p;
{
    TYPE argtype;
    IR_NODE *ir_arglist, *ir_argp;

    if (p->in.op == PCC_CM) {
	ir_arglist = ir_genargs(p->in.left);
	argtype = ir_type(p->in.right);
	ir_argp = ir_map_expr(p->in.right, FOR_VALUE);
	pcc_freenode(p);
	ir_argp = new_triple(IR_PARAM, ir_argp, NULL, argtype);
	TAPPEND((TRIPLE*)ir_arglist, (TRIPLE*)ir_argp);
	return ir_arglist;
    } else {
	argtype = ir_type(p);
	ir_argp = ir_map_expr(p, FOR_VALUE);
	return new_triple(IR_PARAM, ir_argp, NULL, argtype);
    }
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * procedure and function calls.  If cookie== FOR_VALUE,
 * assume the call is to be treated as function call returning
 * a value.  Otherwise assume no value is returned.
 */
IR_NODE *
ir_gencall(p, cookie)
    PCC_NODE *p;
    COOKIE cookie;
{
    int op;
    IR_NODE *ir_argp, *ir_arglist;
    IR_NODE *ir_callnode;
    IR_NODE *ir_dest;
    IR_NODE *ir_result;
    TYPE fncalltype;
    PCC_NODE *lp;
    TWORD tword;
    int size, align;

    /*
     * generate argument list.
     */
    op = p->in.op;
    if (pcc_optype(op) == PCC_BITYPE) {
	ir_arglist = ir_genargs(p->in.right);
    } else {
	ir_arglist = NULL;
    }
    /*
     * For a structured call, we must get the type, size, and
     * alignment from the description of the called function,
     * prior to evaluating the lhs.
     */
    if (op == PCC_STCALL || op == PCC_UNARY_STCALL) {
	lp = p->in.left;
	tword = lp->in.type;
	if (!PCC_ISPTR(tword) || !PCC_ISFTN(PCC_DECREF(tword))) {
	    cerror("ir_gencall: expected PTR FTN t, got 0x%x", tword);
	}
	tword = PCC_DECREF(PCC_DECREF(lp->in.type)); /* PTR FTN t => t */
	size = tsize(tword, lp->fn.cdim, lp->fn.csiz)/SZCHAR;
	align = talign(tword, lp->fn.csiz)/SZCHAR;
	ir_set_type(fncalltype, tword, size, align);
    } else {
	fncalltype = ir_type(p);
    }
    /*
     * generate an FCALL or SCALL according to
     * whether or not a value is required.  
     */
    ir_dest = ir_map_expr(p->in.left, FOR_VALUE);
    if (cookie == FOR_VALUE) {
	/* generate function call */
	ir_callnode = new_triple(IR_FCALL, ir_dest, ir_arglist, fncalltype);
	ir_result = ir_callnode;
    } else {
	ir_callnode = new_triple(IR_SCALL, ir_dest, ir_arglist, fncalltype);
	ir_result = NULL;
    }
    if (op == PCC_STCALL || op == PCC_UNARY_STCALL) {
	/*
	 * structure valued function call.  We must represent the
	 * type of the function as PTR STRTY, because of the way
	 * return statements are compiled (we don't want to create
	 * a structured temporary for the function result).  Having
	 * committed this travesty, we then must fudge the type,
	 * in order to save the structure alignment and size info for
	 * reconstructing the STCALL tree at code generation time.
	 *
	 * This makes me sick.
	 */
	ir_callnode->triple.is_stcall = IR_TRUE;
	ir_callnode->triple.type.tword = PCC_INCREF(fncalltype.tword);
    }
    /*
     * patch each IR_PARAM triple to refer back to the call triple.
     * This is a hack to help the optimizer associate the side effects
     * of a call with the variables referenced in the parameter list.
     */
    TFOR((TRIPLE*)ir_argp, (TRIPLE*)ir_arglist) {
	ir_argp->triple.right = ir_callnode;
    }
    pcc_freenode(p);
    return ir_result;
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * Generate IR for a switch statement.  p is the switch selector
 * expression, whose type is assumed to be INT.
 *
 * swtab[] is an array of structures, each consisting of a constant
 * value and a label.  The first label is the label of the default case
 * (a fall-through in C).  The first constant value is always ignored.
 * 
 * n is the number of cases, including the default case. 
 */
void
ir_switch(p, swtab, n)
    PCC_NODE *p;
    struct pcc_sw swtab[];
    int n;
{
    IR_NODE *expr, *casep, *caselist;
    int i;
    int skiplab;

    skiplab = getlab();
    if (swtab[0].slab < 0) {
	/* no default clause; default is to fall through */
	swtab[0].slab = skiplab;
    }
    swtab[0].sval = 0;
    expr = ir_map_expr(p, FOR_VALUE);
    caselist = NULL;
    for (i = 0; i < n; i++) {
	casep = new_triple(IR_LABELREF,
	    ileaf(swtab[i].slab), ileaf(swtab[i].sval), inttype);
	TAPPEND((TRIPLE*)caselist, (TRIPLE*)casep);
    }
    /* trick here: since the list is circular, caselist->tnext */
    /* wraps around to the beginning of the case list          */
    (void)new_triple(IR_SWITCH, expr, caselist->triple.tnext, inttype);
    ir_labeldef(skiplab);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * beginning of block; update automatic storage
 * and register allocation info.  This corresponds
 * to the FLBRAC operator of /lib/f1, but the info
 * actually only needs to be up to date when the
 * current procedure is written to the IR file.
 *
 * (This is language-dependent, because some compilers
 * have to reserve a fixed portion of activation records)
 */
/*ARGSUSED*/
void
ir_bbeg(autosize, regmask, fregmask)
    OFFSZ autosize;
    int regmask;
    int fregmask;
{
    autosize /= SZCHAR;			/* bits => bytes */
    hdr.regmask = regmask;
#   if TARGET == SPARC
	hdr.fregmask = fregmask;
#   endif
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * define the exit block.  The exit block consists of
 * a single branch to a sentinel label (which is not
 * associated with any actual block).  There must be
 * exactly one exit block per procedure.
 */
void
ir_exit(ftype, fsize, falign, ret_label)
    PCC_TWORD ftype;
    OFFSZ fsize;
    int falign;
    int ret_label;
{
    TYPE t;
    IR_NODE *np, *rp;
    PCC_NODE *p;

    if (ret_label == 0) {
	cerror("ir_exit: no return label");
    }
    ir_branch(ret_label);
    (void)new_block(NULL, ret_label, FALSE, FALSE);
    /*
     * deal with function results, if any
     */
    if (fval_node != NULL) {
	switch(ftype) {
	case PCC_TVOID:
	    break;
	case PCC_STRTY:
	case PCC_UNIONTY:
	    /*
	     * structured function result; node returned by pcc_fvar()
	     * is assumed to contain the address of the struct to be
	     * returned, and we must dereference it explicitly to get
	     * correct use/def info.
	     */
	    np = ir_map_expr(pcc_fvar(), FOR_VALUE);
	    ir_set_type(t, ftype, fsize, falign);
	    np = new_triple(IR_IFETCH, np, NULL, t);
	    (void)new_triple(IR_FVAL, np, NULL, t);
	    break;
	default:
	    /*
	     * normal function result; fvar contains a copy.
	     */
	    np = ir_map_expr(pcc_fvar(), FOR_VALUE);
	    (void)new_triple(IR_FVAL, np, NULL, np->operand.type);
	}
    } else if ( PCC_ISPTR(hdr.proc_type.tword)
      || PCC_ISINTEGRAL(hdr.proc_type.tword) ) {
	/*
	 * falling off the end of an integral valued function without
	 * returning anything; result is undefined, so we may treat
	 * the function as void.  This allows peephole optimizers
	 * to kill computations that may reach the exit block but
	 * are otherwise unused.
	 */
	hdr.proc_type.tword = PCC_TVOID;
    }
    fval_node = NULL;
    ir_branch(EXIT_LABELNO);
}

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * PCC bit field operators arrive in an inconvenient form for
 * IR mapping.  We prefer to store the <offset:width> attributes
 * with leaf nodes or with storage access triples.  So we stash
 * these attributes in the FLD node's operand node and delete
 * the FLD node altogether. The field attributes can then be
 * considered part of the IR type.
 */
void
ir_bitfield(p)
    PCC_NODE *p;
{
    int bfwidth;
    int bfoffset;
    PCC_TWORD t;
    PCC_NODE *q;

    if (p->in.op != PCC_FLD) {
	cerror("cannot flatten");
    }
    t = p->in.type;
    bfwidth = PCC_UPKFSZ(p->tn.rval);
    bfoffset = PCC_UPKFOFF(p->tn.rval);
    q = p->in.left;
    *p = *q;
    p->in.type = IR_BITFIELD;
    p->fn.bfwidth = bfwidth;
    p->fn.bfoffset = bfoffset;
    pcc_freenode(q);
}
