#ifndef lint
static	char sccsid[] = "@(#)table.c	1.1	94/10/31 Copyr 1986 Sun Micro";
#endif

/*
 * Copyright (c) 1986 by Sun Microsystems, Inc.
 */


# include "cpass2.h"

# define ANYSIGNED TPOINT|TINT|TLONG|TSHORT|TCHAR
# define ANYUSIGNED TUNSIGNED|TULONG|TUSHORT|TUCHAR
# define ANYFIXED ANYSIGNED|ANYUSIGNED
# define TWORDSZ TINT|TUNSIGNED|TPOINT|TLONG|TULONG
# define TSCALAR TCHAR|TUCHAR|TSHORT|TUSHORT|TINT|TUNSIGNED|TPOINT

# define DOUBLEADDR SSOREG

struct optab table[] = {

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
			    /* ASSIGNMENTS */

/*
 * special-case constant assignment
 */

ASSIGN,	INAREG|INTAREG|FOREFF,
	MEMADDR,	TSCALAR|TFLOAT,
	SZERO,		TANY,
		0,	RLEFT|RRIGHT,
		"	stZLb	%g0,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SSNAME,		TSCALAR|TFLOAT,
	SZERO,		TANY,
		0,	RLEFT|RRIGHT,
		"	stZLb	%g0,[%ad CL]\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SNAME,		TSCALAR|TFLOAT,
	SZERO,		TANY,
		NAREG,	RLEFT|RRIGHT,
		"	sethi	%hi(CL),A1\n	stZLb	%g0,[A1+%lo(CL)]\n",

/*
 * assignment from registers or constant to registers
 */
 
ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	ANYSIGNED,
	SSOURCE,	TCHAR,
		0,	RLEFT|RRIGHT,
		"	mov	CR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	ANYUSIGNED,
	SSOURCE,	TUCHAR,
		0,	RLEFT|RRIGHT,
		"	mov	CR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	(ANYSIGNED)&~TCHAR,
	SSOURCE,	TSHORT,
		0,	RLEFT|RRIGHT,
		"	mov	CR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	(ANYUSIGNED)&~TUCHAR,
	SSOURCE,	TUSHORT,
		0,	RLEFT|RRIGHT,
		"	mov	CR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SICON,		TSCALAR,
		0,	RLEFT|RRIGHT,
		"	mov	CR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SAREG|STAREG,	TSCALAR,
		0,	RLEFT|RRIGHT,
		"ZtZRkZLK",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	fmovs	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	fmovd	AR,AL\n",

/*
 * assignment from registers to memory 
 */
ASSIGN,	INAREG|INTAREG|FOREFF,
	MEMADDR,	TSCALAR|TFLOAT,
	SAREG|STAREG,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	stZLb	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SSNAME,		TSCALAR|TFLOAT,
	SAREG|STAREG,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	stZLb	AR,[%ad CL]\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SNAME,		TSCALAR|TFLOAT,
	SAREG|STAREG,	TSCALAR|TFLOAT,
		NAREG,	RLEFT|RRIGHT,
		"	sethi	%hi(CL),A1\n	stZLb	AR,[A1+%lo(CL)]\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	MEMADDR,	TWORDSZ|TFLOAT,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	st	AR,AL\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SSNAME,		TWORDSZ|TFLOAT,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	st	AR,[%ad CL]\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SNAME,		TWORDSZ|TFLOAT,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
		NAREG,	RLEFT|RRIGHT,
		"	sethi	%hi(CL),A1\n	st	AR,[A1+%lo(CL)]\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SDOUBLEO,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
"	std	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SDOUBLEO,	TDOUBLE,
	SAREGPAIR,	TDOUBLE,
		0,	RLEFT|RRIGHT,
"	std	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	DOUBLEADDR,	TDOUBLE,
	SAREG|STAREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	st2	AR,AL\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	DOUBLEADDR,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	st2	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SDOUBLE,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	sethi	%hi(CL),A1\n\
	std	AR,[A1+%lo(CL)]\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SDOUBLE,	TDOUBLE,
	SAREGPAIR,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	sethi	%hi(CL),A1\n\
	std	AR,[A1+%lo(CL)]\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SSNAME,		TDOUBLE,
	SAREG|STAREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	st2	AR,[%ad CL]\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SSNAME,		TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	st2	AR,[%ad CL]\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SNAME,		TDOUBLE,
	SAREG|STAREG,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	set	CL,A1\n\
	st2	AR,[A1]\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SNAME,		TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	set	CL,A1\n\
	st2	AR,[A1]\n",

/*
 * assignment from memory to registers
 */
ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR|TFLOAT,
	MEMADDR,	TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	ldZB	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR|TFLOAT,
	SSNAME,		TSCALAR|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	ldZB	[%ad CR],AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR|TFLOAT,
	SNAME,		TSCALAR|TFLOAT,
		NAREG,	RLEFT|RRIGHT,
		"	sethi	%hi(CR),A1\n	ldZB	[A1+%lo(CR)],AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
	MEMADDR,	TWORDSZ|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	ld	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
	SSNAME,		TWORDSZ|TFLOAT,
		0,	RLEFT|RRIGHT,
		"	ld	[%ad CR],AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
	SNAME,		TWORDSZ|TFLOAT,
		NAREG,	RLEFT|RRIGHT,
		"	sethi	%hi(CR),A1\n	ld	[A1+%lo(CR)],AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREGPAIR,	TDOUBLE,
	SDOUBLEO,	TDOUBLE,
		0,	RLEFT|RRIGHT,
"	ldd	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SDOUBLEO,	TDOUBLE,
		0,	RLEFT|RRIGHT,
"	ldd	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TDOUBLE,
	DOUBLEADDR,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	ld2	AR,AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	DOUBLEADDR,	TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	ld2	AR,AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TDOUBLE,
	SSNAME,		TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	ld2	[%ad CR],AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SSNAME,		TDOUBLE,
		0,	RLEFT|RRIGHT,
		"	ld2	[%ad CR],AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREGPAIR,	TDOUBLE,
	SDOUBLE,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	sethi	%hi(CR),A1\n\
	ldd	[A1+%lo(CR)],AL\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SDOUBLE,	TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	sethi	%hi(CR),A1\n\
	ldd	[A1+%lo(CR)],AL\n",

ASSIGN,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TDOUBLE,
	SNAME,		TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
		"	set	CL,A1\n	st2	AR,[A1]\n",

ASSIGN,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SNAME,		TDOUBLE,
		NAREG,	RLEFT|RRIGHT,
"	set	CR,A1\n\
	ld2	[A1],AL\n",

/*
 * moving things from integer registers to floating registers
 * and vice versa
 */

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SAREG|STAREG,	TFLOAT|TWORDSZ,
	SBREG,		TFLOAT|TWORDSZ,
		NTEMP,	RLEFT|RRIGHT,
		"	st	AR,A1\n	ld	A1,AL\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SAREG|STAREG,	TDOUBLE,
	SBREG,		TDOUBLE,
		(2*NTEMP),RLEFT|RRIGHT,
		"	std	AR,A1\n	ld2	A1,AL\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TFLOAT|TWORDSZ,
	SAREG,		TFLOAT|TWORDSZ,
		NTEMP,	RLEFT|RRIGHT,
		"	st	AR,A1\n	ld	A1,AL\n",

ASSIGN,	INAREG|INTAREG|INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TDOUBLE,
	SAREG,		TDOUBLE,
		(2*NTEMP),RLEFT|RRIGHT,
		"	st2	AR,A1\n	ldd	A1,AL\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * assignment to bit field
 */

ASSIGN, INAREG|INTAREG|FOREFF,
	SFLD8_16,		TANY,
	SAREG|STAREG,		TANY,
		NAREG|NASR,	RESC1,
	"	stZLb	AR,AL\nFZLtZRkZ1K",

ASSIGN, INAREG|INTAREG|FOREFF,
	SFLD8_16,		TANY,
	SZERO,		TANY,
		0,	RRIGHT,
	"	stZLb	%g0,AL\n",

ASSIGN, INAREG|INTAREG|FOREFF,
	SFLD,   	TANY,
	SAREG|STAREG,	 	TANY,
		3*NAREG,   RESC1,
		"ZF",		/* that's right, do it all by hand, again */

ASSIGN, INAREG|INTAREG|FOREFF,
	SFLD,		TANY,
	SZERO,		TANY,
		2*NAREG,	RRIGHT,
		"ZF",		/* that's right, do it all by hand, again */

ASSIGN, INAREG|INTAREG|FOREFF,
	SFLD,		TANY,
	SONES,		TANY,
		2*NAREG,	RRIGHT,
		"ZF",		/* that's right, do it all by hand, again */

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


/* put this here so UNARY MUL nodes match OPLTYPE when appropriate */
UNARY MUL,	INAREG|INTAREG,
	SAREG,	TSCALAR,
	SANY,	TANY,
		NAREG|NASR,	RESC1,
		"	ldZB	[AL],A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#ifdef FORT
GOTO,	FOREFF,
	SAREG|STAREG,	TANY,
	SANY,		TANY,
		0,	RNOP,
		"	jmp	CL\n	nop\n",
#endif

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * evaluate a name without purpose
 */
 
OPLTYPE,	FOREFF,
	SANY,		TANY,
	SANY,		TANY,
		0,	RNULL,
		"",

/*
 * tests to set condition codes
 */

OPLTYPE,	FORCC,
	SANY,		TANY,
	SAREG|STAREG,	TSCALAR,
		0,	RESCC,
		"	tst	AR\n",

OPLTYPE,	FORCC,
	SANY,		TANY,
	SZERO,		TANY,
		0,	RESCC,
		"	tst	%g0\n",

OPLTYPE,	FORCC,
	SANY,		TANY,
	SBREG|STBREG,	TFLOAT,
		NAREG|NBREG,	RESFCC,
		"Zf",

OPLTYPE,	FORCC,
	SANY,		TANY,
	SBREG|STBREG,	TDOUBLE,
		NAREG|NBREG|NBPAIR,	RESFCC,
		"Zf",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * special-case loads, constant integral operands
 */
OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY,
	SICON,		TSCALAR,
		NAREG,	RESC1,
		"	mov	CR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY,
	SXCON,		TSCALAR,
		NAREG,	RESC1,
		"	mov	%ad CR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY,
	SCON,		TSCALAR,
		NAREG,	RESC1,
		"	set	CR,A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * load scalar into temp d-register
 */
OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	MEMADDR, 	TSCALAR|TFLOAT,
		NAREG|NASR,	RESC1,
		"	ldZB	AR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SDOUBLEO, 	TDOUBLE,
		NAREG|NAPAIR|NASR,	RESC1,
		"	ldd	AR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	DOUBLEADDR, 	TDOUBLE,
		NAREG|NAPAIRO|NASR,	RESC1,
		"	ld2	AR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SSNAME,		TSCALAR|TFLOAT,
		NAREG|NASR,	RESC1,
		"	ldZB	[%ad CR],A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SSNAME,		TDOUBLE,
		NAREG|NAPAIRO,	RESC1,
		"	ld2	[%ad CR],A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SAREG|STAREG,	TSCALAR|TFLOAT,
		NAREG,	RESC1,
		"	mov	AR,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SNAME,		TSCALAR|TFLOAT,
		NAREG,	RESC1,
		"	sethi	%hi(CR),A1\n	ldZB	[A1+%lo(CR)],A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SDOUBLE,	TDOUBLE,
		NAREG|NAPAIR,	RESC1,
		"	sethi	%hi(CR),A1\n	ldd	[A1+%lo(CR)],A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SNAME,		TDOUBLE,
		NAREG|NAPAIRO,	RESC1,
		"	set	CL,U1\n	ld2	[U1],A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	MEMADDR,	TWORDSZ|TFLOAT,
		NBREG,	RESC1,
		"	ld	AR,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SNAME, 		TWORDSZ|TFLOAT,
		NAREG+NBREG,	RESC2,
		"	sethi	%hi(CR),A1\n	ld	[A1+%lo(CR)],A2\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SSNAME,	 	TWORDSZ|TFLOAT,
		NBREG,	RESC1,
		"	ld	[%ad CR],A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SBREG|STBREG,	TWORDSZ|TFLOAT,
		NBREG,	RESC1,
		"	fmovs	AR,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SFCON,		TFLOAT,
		NAREG|NBREG,	RESC2,
		"	sethi	%hi(CR),A1\n	ld	[A1+%lo(CR)],A2\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SFCON,		TDOUBLE,
		NAREG|NBREG|NBPAIR,	RESC2,
		"	sethi	%hi(CR),A1\n	ldd	[A1+%lo(CR)],A2\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY&~TSTRUCT,
	SDOUBLEO, 	TDOUBLE,
		NAREG|NAPAIR|NASR,	RESC1,
		"	ldd	AR,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SDOUBLEO, 	TDOUBLE,
		NBREG|NBPAIR,	RESC1,
		"	ldd	AR,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	DOUBLEADDR, 	TDOUBLE,
		NBREG|NBPAIR,	RESC1,
		"	ld2	AR,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SSNAME,	 	TDOUBLE,
		NBREG|NBPAIR,	RESC1,
		"	ld2	[%ad CR],A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SDOUBLE, 	TDOUBLE,
		NAREG|NBREG|NBPAIR,	RESC2,
"	sethi	%hi(CR),A1\n\
	ldd	[A1+%lo(CR)],A2\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SNAME, 		TDOUBLE,
		NAREG|NBREG|NBPAIR,	RESC2,
"	set	CR,A1\n\
	ld2	[A1],A2\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY&~TSTRUCT,
	SBREG|STBREG,	TDOUBLE,
		NBREG|NBPAIR,	RESC1,
		"	fmovd	AR,A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


/*
 * stores into temp stack locations
 */
OPLTYPE,	INTEMP,
	SANY,		TANY,
	SAREG,		TSCALAR,
		NTEMP,	RESC1,
		"	stZb	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,		TANY,
	SBREG,		TSCALAR|TFLOAT,
		NTEMP,	RESC1,
		"	st	AR,A1\n",

OPLTYPE,	INTEMP,
	SANY,		TANY,
	SBREG,		TDOUBLE,
		2*NTEMP,	RESC1,
		"	std	AR,A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * moving things from integer registers to floating registers
 * and vice versa
 */

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY,
	SBREG,		TFLOAT|TWORDSZ,
		NAREG|NTEMP,	RESC1,
		"	st	AL,A2\n	ld	A2,A1\n",

OPLTYPE,	INAREG|INTAREG,
	SANY,		TANY,
	SBREG,		TDOUBLE,
		(NAREG|NAPAIRO)|(2*NTEMP),RESC1,
		"	std	AL,A2\n	ld2	A2,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY,
	SAREG,		TFLOAT|TWORDSZ,
		NBREG|NTEMP,	RESC1,
		"	st	AL,A2\n	ld	A2,A1\n",

OPLTYPE,	INBREG|INTBREG,
	SANY,		TANY,
	SAREG,		TDOUBLE,
		(NBREG|NBPAIR)|(2*NTEMP),RESC1,
		"	st2	AL,A2\n	ldd	A2,A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


/*
 * compare operands, for flow control
 */

OPLOG,	FORCC,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		0,	RESCC,
		"	cmp	AL,CR\nZI",

EQ,	FORCC,
	SBREG|STBREG,	TFLOAT,
	SBREG|STBREG,	TFLOAT,
		0,	RESFCC,
		"	fcmps	AL,AR\n	nop\nZH",

EQ,	FORCC,
	SBREG|STBREG,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RESFCC,
		"	fcmpd	AL,AR\n	nop\nZH",

NE,	FORCC,
	SBREG|STBREG,	TFLOAT,
	SBREG|STBREG,	TFLOAT,
		0,	RESFCC,
		"	fcmps	AL,AR\n	nop\nZH",

NE,	FORCC,
	SBREG|STBREG,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RESFCC,
		"	fcmpd	AL,AR\n	nop\nZH",

OPLOG,	FORCC,
	SBREG|STBREG,	TFLOAT,
	SBREG|STBREG,	TFLOAT,
		0,	RESFCC,
		"	fcmpes	AL,AR\n	nop\nZH",

OPLOG,	FORCC,
	SBREG|STBREG,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		0,	RESFCC,
		"	fcmped	AL,AR\n	nop\nZH",

/*
 * convert integer condition codes into boolean result
 */
CCODES,	INAREG|INTAREG,
	SANY,		TANY,
	SANY,		TANY,
		NAREG,	RESC1,
		"	mov	1,A1\nZN",

/*
 * convert floating-point condition codes into boolean result
 */
FCCODES,	INAREG|INTAREG,
	SANY,		TANY,
	SANY,		TANY,
		NAREG,	RESC1,
		"	mov	1,A1\nZN",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * negate scalar in temp register
 */
UNARY MINUS,	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SANY,		TANY,
		NAREG|NASL,	RESC1,
		"	subZC	%g0,AL,A1\nZtZv",

UNARY MINUS,	INBREG|INTBREG,
	SBREG|STBREG,	TFLOAT,
	SANY,		TANY,
		NBREG|NBSL,	RESC1,
		"	fnegs	AL,A1\n",

UNARY MINUS,	INTBREG|INTAREG,
	STBREG,		TDOUBLE,
	SANY,		TANY,
		0,	RLEFT,
		"	fnegd	AL,AL\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * one's complement into temp d-register
 */
COMPL,	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SANY,		TANY,
		NAREG|NASL,	RESC1,
		"	xor	AL,-1,A1\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * increment/decrement operators
 */

INCR,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SICON,		TSCALAR,
		NAREG,	RESC1,
		"F	add	AL,%g0,A1\n	addZC	AL,CR,AL\nZLtZvZLkZLK",

INCR,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCON,		TSCALAR,
		2*NAREG,	RESC1,
		"F	add	AL,%g0,A1\n	set	CR,A2\n	addZC	AL,A2,AL\nZLtZvZLkZLK",

DECR,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SICON,		TSCALAR,
		NAREG,	RESC1,
		"F	add	AL,%g0,A1\n	subZC	AL,CR,AL\nZLtZvZLkZLK",

DECR,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCON,		TSCALAR,
		2*NAREG,	RESC1,
		"F	add	AL,%g0,A1\n	set	CR,A2\n	subZC	AL,A2,AL\nZLtZvZLkZLK",


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

ASG OPSIMP, 	INAREG|INTAREG|FORCC,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT|RESCC,
		"	OIZc	AL,CR,AL\nZLtZLkZLK",

ASG PLUS, 	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT,
		"	OIZC	AL,CR,AL\nZLtZvZLkZLK",

ASG MINUS, 	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT,
		"	OIZC	AL,CR,AL\nZLtZvZLkZLK",


ASG RS, 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TINT|TSHORT|TCHAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT,
		"	sra	AL,CR,AL\n",

ASG LS, 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TINT|TSHORT|TCHAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT,
		"	sll	AL,CR,AL\nZLtZLkZLK",

ASG OPSHFT, 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TPOINT|TUNSIGNED|TUSHORT|TUCHAR,
	SSOURCE,	TSCALAR,
		0,	RLEFT,
		"	OIl	AL,CR,AL\nZLtZLkZLK",

ASG OPSIMP, 	INAREG|INTAREG|FORCC|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCOMPLR,	TSCALAR,
		0,	RLEFT|RESCC,
		"	ZnZc	AL,ZRu,AL\nZLtZLkZLK",

OPSIMP, 	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL|NASR,	RESC1,
		"	OIZc	AL,CR,A1\nZtZ1kZ1K",

OPSIMP, 	FORCC,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		0,	RESCC,
		"	OIZc	AL,CR,%g0\n",

PLUS, 	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL|NASR,	RESC1,
		"	OIZC	AL,CR,A1\nZtZvZ1kZ1K",

MINUS, 	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL|NASR,	RESC1,
		"	OIZC	AL,CR,A1\nZtZvZ1kZ1K",

RS,	 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TINT|TSHORT|TCHAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL,	RESC1,
		"	sra	AL,CR,A1\nZtZ1kZ1K",

LS,	 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TINT|TSHORT|TCHAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL,	RESC1,
		"	sll	AL,CR,A1\nZtZ1kZ1K",

OPSHFT, 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TPOINT|TUNSIGNED|TUSHORT|TUCHAR,
	SSOURCE,	TSCALAR,
		NAREG|NASL,	RESC1,
		"	OIl	AL,CR,A1\nZtZ1kZ1K",

OPSIMP, 	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCOMPLR,	TSCALAR,
		NAREG|NASL|NASR,	RESC1,
		"	Zn	AL,ZRu,A1\nZtZ1kZ1K",

OPSIMP, 	FORCC,
	SAREG|STAREG,	TSCALAR,
	SCOMPLR,	TSCALAR,
		0,	RESCC,
		"	ZnZc	AL,ZRu,%g0\n",

ASG MUL,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCON,		TSCALAR,
		NAREG,	RLEFT,
		"ZmZLtZLkZLK",

ASG DIV,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCON,		TSCALAR,
		NAREG,	RLEFT,
		"ZdZLtZLkZLK",

ASG MOD,	INAREG|INTAREG|FOREFF,
	SAREG|STAREG,	TSCALAR,
	SCON,		TSCALAR,
		NAREG,	RLEFT,
		"ZrZLtZLkZLK",
/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

ASG OPFLOAT, 	INBREG|INAREG|INTBREG|INTAREG,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
		0,	RLEFT,
		"	OFZ.	AL,AR,AL\n",

OPFLOAT, 	INBREG|INTBREG|INAREG|INTAREG,
	SBREG|STBREG,	TFLOAT,
	SBREG|STBREG,	TFLOAT,
		NBREG|NBSL,	RESC1,
		"	OFZ.	AL,AR,A1\n",

OPFLOAT, 	INBREG|INTBREG|INAREG|INTAREG,
	SBREG|STBREG,	TDOUBLE,
	SBREG|STBREG,	TDOUBLE,
		NBREG|NBPAIR|NBSL,	RESC1,
		"	OFZ.	AL,AR,A1\n",

FABS,	INBREG|INTBREG,
	STBREG,	TFLOAT,
	SANY,	TANY,
		0,	RLEFT,
		"	fabss	AL,AL\n",

FABS,	INBREG|INTBREG,
	STBREG,	TDOUBLE,
	SANY,	TANY,
		0,	RLEFT,
		"	fabsd	AL,AL\n",

FABS,	INAREG|INTAREG|FOREFF,
	STAREG,	TFLOAT|TDOUBLE,
	SANY,	TANY,
		0,	RLEFT,
		"	sll	AR,1,AR\n	srl	AR,1,AR\n",

FSQR,	INBREG|INTBREG,
	SBREG|STBREG,	TFLOAT,
	SANY,	TANY,
		NBREG|NBSL,	RESC1,
		"	fmulZ.	AL,AL,A1\n",

FSQR,	INBREG|INTBREG,
	SBREG|STBREG,	TDOUBLE,
	SANY,	TANY,
		NBREG|NBPAIR|NBSL,	RESC1,
		"	fmulZ.	AL,AL,A1\n",

#ifdef FSQRT_OP
FSQRT,	INBREG|INTBREG,
	SBREG|STBREG,	TFLOAT,
	SANY,	TANY,
		NBREG|NBSL,	RESC1,
		"	fsqrts	AL,A1\n",

FSQRT,	INBREG|INTBREG,
	SBREG|STBREG,	TDOUBLE,
	SANY,	TANY,
		NBREG|NBPAIR|NBSL,	RESC1,
		"	fsqrtd	AL,A1\n",
#endif

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

UNARY CALL,	INTAREG|FOREFF,
	SCON,		TANY,
	SANY,		TSCALAR,
		NAREG|NASL,	RESC1, /* should be register o0 */
		"	call	CL,Za\n	nop\n",

UNARY CALL,	INTAREG|FOREFF,
	SAREG|STAREG,	TANY,
	SANY,		TSCALAR,
		NAREG|NASL,	RESC1, /* should be register o0 */
		"	call	AL,Za\n	nop\n",

UNARY CALL,	INTAREG|FOREFF,
	SCON,		TANY,
	SANY,		TFLOAT,
		NBREG|NBSL,	RESC1, /* should be register f0 */
		"	call	CL,Za\n	nop\n",

UNARY CALL,	INTAREG|FOREFF,
	SCON,		TANY,
	SANY,		TDOUBLE,
		NBREG|NBPAIR|NBSL,	RESC1, /* should be reg pair f0-f1 */
		"	call	CL,Za\n	nop\n",

UNARY CALL,	INTAREG|FOREFF,
	SAREG|STAREG,	TANY,
	SANY,		TFLOAT,
		NBREG|NBSL,	RESC1, /* should be register f0 */
		"	call	AL,Za\n	nop\n",

UNARY CALL,	INTAREG|FOREFF,
	SAREG|STAREG,	TANY,
	SANY,		TDOUBLE,
		NBREG|NBPAIR|NBSL,	RESC1, /* should be register f0 */
		"	call	AL,Za\n	nop\n",

UNARY STCALL,	INTAREG|FOREFF,
	SCON,		TANY,
	SANY,		TANY,
		NAREG|NASL,	RESC1, /* should be register o0 */
		"	call	CL,Za\n	nop\n	unimp	J&0xfff\n",

UNARY STCALL,	INTAREG|FOREFF,
	SAREG|STAREG,	TANY,
	SANY,		TANY,
		NAREG|NASL,	RESC1, /* should be register o0 */
		"	call	AL,Za\n	nop\n	unimp	J&0xfff\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

CHK,	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SANY,		TANY,
		NAREG,	RLEFT,
		"ZV",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * conversions, from and to integer types
 */
SCONV,	INAREG,
	SAREG,		TSCALAR,
	SANY,		TWORDSZ,
		0,	RLEFT,
		"",

SCONV,	INAREG|INTAREG,
	SAREG|STAREG,	TSCALAR,
	SANY,		TSCALAR,
		NAREG|NASL,	RESC1,
		"ZtZLkZ1K",

/*
 * conversions amoung floating-point types
 */
SCONV,	INBREG|INTBREG|INAREG|INTAREG,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
	SANY,		TFLOAT,
		NBREG|NBSL,	RESC1,
		"	fZL.toZ.	AL,A1\n",

SCONV,	INBREG|INTBREG|INAREG|INTAREG,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
	SANY,		TDOUBLE,
		NBREG|NBPAIR|NBSL,	RESC1,
		"	fZL.toZ.	AL,A1\n",

/*
 * conversions from floating to integral and vice versa
 */
SCONV,	INBREG|INTBREG,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
	SANY,		TINT,	/* this is a crock */
		NBREG|NBSL,	RESC1,
		"	fZL.toi	AL,A1\n",

SCONV,	INAREG|INTAREG|FOREFF,
	SBREG|STBREG,	TFLOAT|TDOUBLE,
	SANY,		TSCALAR,
		NAREG|NBREG|NBSL|NTEMP,	RESC1,
		"	fZL.toi	AL,A2\n	st	A2,A3\n	ld	A3,A1\nZtZ1kZ1K",

SCONV,	INBREG|INTBREG,
	SBREG|STBREG,	TINT,
	SANY,		TFLOAT,
		NBREG|NBSL,	RESC1,
		"	fitoZ.	AL,A1\n",

SCONV,	INBREG|INTBREG,
	SBREG|STBREG,	TINT,
	SANY,		TDOUBLE,
		NBREG|NBPAIR|NBSL,	RESC1,
		"	fitoZ.	AL,A1\n",

SCONV,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TUNSIGNED,
	SANY,		TFLOAT,
		NAREG|(2*NBREG),	RESC2,
		"Zf",

SCONV,	INBREG|INTBREG|FOREFF,
	SBREG|STBREG,	TUNSIGNED,
	SANY,		TDOUBLE,
		NAREG|(2*NBREG)|NBPAIR,	RESC2,
		"Zf",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


/*
 * structure assignments
 */

STASG,	FOREFF|INAREG|INTAREG,
	SAREG|STAREG,	TPOINT,
	STAREG,		TPOINT,
		NAREG*2|NAPAIR,		RLEFT,
		"ZS",

STASG,	FOREFF|INAREG|INTAREG,
	SAREG|STAREG,	TPOINT,
	STAREG,		TPOINT,
		2*NAREG,		RLEFT,
		"Zs",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

/*
 * initializations - constants only
 */
INIT,	FOREFF,
	SCON,		TANY,
	SANY,		TINT|TLONG|TUNSIGNED|TULONG|TPOINT,
		0,	RNOP,
		"	.word	CL\n",

INIT,	FOREFF,
	SCON,		TANY,
	SANY,		TSHORT|TUSHORT,
		0,	RNOP,
		"	.half	CL\n",

INIT,	FOREFF,
	SCON,		TANY,
	SANY,		TCHAR|TUCHAR,
		0,	RNOP,
		"	.byte	CL\n",

INIT,	FOREFF,
	SCON,		TANY,
	SANY,		TFLOAT,
		0,	RNOP,
		"	.word	C.\n",

INIT,	FOREFF,
	SCON,		TANY,
	SANY,		TDOUBLE,
		0,	RNOP,
		"	.word	C.\n",

/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

	/* Default actions for hard trees ... */

# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,""

UNARY MUL, DF( UNARY MUL ),

INCR, DF(INCR),

DECR, DF(INCR),

ASSIGN, DF(ASSIGN),

STASG, DF(STASG),

OPLEAF, FORREW,
	SDOUBLEO,	TDOUBLE,
	SANY,		TANY,
	NAREG|NASR|NASL,	NAME,
	"ZD",

OPLEAF, DF(NAME),

OPLOG,	FORCC,
	SANY,	TANY,
	SANY,	TANY,
		REWRITE,	BITYPE,
		"",

OPLOG,	DF(NOT),
/* OPLOG,	DF(BITYPE),*/
COMOP, DF(COMOP),
INIT, DF(INIT),
FLD, DF(FLD),
GOTO,DF(GOTO),
SCONV, DF(SCONV),
OPUNARY, DF(UNARY MINUS),
ASG OPANY, DF(ASG PLUS),
OPANY, DF(BITYPE),
FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	FREE,	"help; I'm in trouble\n" };
