#
# @(#)cdimage.mk 1.1 94/10/31 SMI
#

#
# make file for creating SunOS cdrom image
#
#
# PRE-REQUISITIES:
#	Archive the tarfiles and stundist images generated by various build
#		machines and export the partitions using release tool
#		"save_cd_depends".  Each set of archives is usually
#		identified by the RELEASE file in $build_machine:\
#		/proto/usr/sys/conf.commmon
#	Create /usr/src/sundist/$(RELEASE) for each set of releases to
#		be included in CD.  eg:  if 4.1 and PSR_A are to be
#		released together, you need 2 $(RELEASE) files, one
#		named RELEASE (for 4.1) the other PSR_RELEASE (PSR_A)
#	Compile	'cd_tar' and toc_xlat utils (built from usr.etc/suninstall)
#		and install to /usr/etc/install (NOT GOOD!!)
#
# DELIVERABLES:
#	(1) tar directory structure containing the tar files, 
#	    TOC and miniroot for all architectures.  This is done 
#	    by merging the archived tarfiles using 'cd_tar'.
#	(2) cdrom_part_$(ARCH) copied from archives which are
#	    in the cdrom bootable list (sun4, sun4c)
#	(3) cdrom image for SunOS installation. This image will have a
#	    sun disk label on the first 512 bytes. The tar files 
#	    directory is put into a ISO-9660 file format in partition a. 
#	    The architecture specific bootable image will be in b, c, ... 
#	    
#
#
# Note: partition assignments are defined in Makefile.common_cd
#
include Makefile.common_cd

MAKEFILE=	cdimage.mk
ECHO	=       /bin/echo
DATE	=	/bin/date
TOP_VERS=	gen         #Include major release only (eg: 4.1)
#TOP_VERS=	psr         #Add platform release to major (eg: 4.1 + PSR_A)
#TOP_VERS=	psr_a       #Add platform release to major (eg: 4.1 + PSR_A)
#TOP_VERS=	psr_b       #Add platform release to major (eg: 4.1 + PSR_A)
#TOP_VERS=	4c		#4c 4.1.1 only
HOST=		app14       #diskfarm exporting archived images
WORKDIR=	/usr/src/sundist
TARDIR=		tarfiles
DISTDIR=	sundist
PATCHDIR=	patches
SUNUPGRADEDIR=	sunupgrade
SUNUPGRADE_PROTO_DIR= proto_sunupgrade
ARCH_REAL=	$(ARCH)
RELEASE_FILE=	$(WORKDIR)/RELEASE   #Identifies archives to mount
RELEASE=	`cat $(RELEASE_FILE)`
ARCHIVES=	$(HOST):/usr/cdrom_$(RELEASE)
ARCHIVE_MNT=	/cdrom/$(RELEASE)
TARPATH=	$(ARCHIVE_MNT)/$(TARDIR)/$(ARCH_REAL)
DISTPATH=	$(ARCHIVE_MNT)/$(DISTDIR)/$(ARCH_REAL)
PATCH_PATH=	$(ARCHIVE_MNT)/$(PATCHDIR)
SUNUPGRADE_PATH= /$(SUNUPGRADE_PROTO_DIR)
ARCHS_gen=	sun4c sun4 sun4m			#4.1.2
#ARCHS_gen=	sun4 sun4c sun3x sun3			#4.1
#ARCHS_gen=	sun4c sun4 sun3x sun3 sun4m		#4.1.1
#ARCHS_gen=	sun4 sun3x sun3			#4.1
#ARCHS_psr_a=	$(ARCHS_gen) sun4psr_a			#4.1 + PSR_A
#ARCHS_psr_b=	$(ARCHS_psr_a) sun4c
#ARCHS_4c=	sun4c
ARCHS=		$(ARCHS_$(TOP_VERS))
CDROM_DEST=	$(WORKDIR)/cdromdist
TARFILE_LOC=	/cdrom_tarfiles
CDROM_DEST_TARFILES=$(TARFILE_LOC)/tar-files
CDIMAGE=	$(CDROM_DEST)/cdimage
XDRTOC_FILE=	$(CDROM_DEST)/XDRTOC
COPYRIGHT=	$(WORKDIR)/Copyright
PARTNUM=	$(WORKDIR)/part_num_cdrom
EXABYTE_HOST=	app14
EXABYTE=	/dev/rst0

#
# definitions for the ISO label
#
SYSID=		"$(CDLABEL_RELEASE)"
VOLID=		"Volume 1"
VOLSETID=	"SunOS"
PUBID=		"Sun Microsystems, Inc."
PREPID=		"Sun Microsystems, Inc."
APPLID=		"$(CDLABEL_RELEASE)"
COPYFILE=	"_copyright"

#We edit the release name to conform to ISO specs for file names
#
BASE_RELEASE=	`cat $(WORKDIR)/RELEASE | sed -e 's/\./_/g'`
#PSR_RELEASE_A=	`cat $(WORKDIR)/PSR_RELEASE_A | sed -e 's/\./_/g'| tr A-Z a-z`
#PSR_RELEASE_B=	`cat $(WORKDIR)/PSR_RELEASE_B | sed -e 's/\./_/g'| tr A-Z a-z`

#
#Assume that only one set of patches will be used
#
CDROM_DEST_PATCHES=$(CDROM_DEST_TARFILES)/patches/sunos_$(BASE_RELEASE)

#sunupgrade
CDROM_DEST_SUNUPGRADE=$(CDROM_DEST_TARFILES)/sunupgrade

#
#This macro is used to replace two 4.1 modules with that of PSR_A.
#
#USE_TOP_VERS=	export/exec/sun4_sunos_$(BASE_RELEASE)/install \
#		export/exec/sun4_sunos_$(BASE_RELEASE)/user_diag

#
#There are two copies of manpages, both taken from PSR_A.
#It is a kludge to work around a suninstall bug.
#
MANPATH=	$(CDROM_DEST_TARFILES)/export/share
		

#
# list of supported architecture for installation (tar files)
#

#
# fairly static names
# Assumption about tape: 120 Meg per tape (1/2", 6250 bpi, 2400 ft tapes)
# TAPESZ in 8k blocks
# tape device=/dev/rmt8 for 6250 bpi tapes
# 

TAPE=/dev/rmt8
TAPESZ=15360

#
# number of bootable images.
#
NUM_ARCHS_gen=5
NUM_ARCHS_psr_a=5
NUM_ARCHS_psr_b=5
NUM_ARCHS_4c=2
NUM_ARCHS=$(NUM_ARCHS_$(TOP_VERS))

# architecture specific bootable images

PART_ARCHS_gen=sun4c.part sun4.part sun4m.part
PART_ARCHS_psr_a=$(PART_ARCHS_gen) sun4psr_a.part
PART_ARCHS_psr_b=$(PART_ARCHS_psr_a) sun4c.part 
PART_ARCHS_4c=sun4c.part
PART_ARCHS=$(PART_ARCHS_$(TOP_VERS))

CDTAR_gen=CDTAR_sun4c CDTAR_sun4 CDTAR_sun4m
CDTAR_psr_a=$(CDTAR_gen) CDTAR_sun4psr_a
CDTAR_psr_b=CDTAR_sun4c $(CDTAR_psr_a)
CDTAR_4c=CDTAR_sun4c
CDTAR_ALL=$(CDTAR_$(TOP_VERS))
#

# utils 
#cd_tar - utility to combine tarfiles of different architecture into
#                one directory structure, eliminating duplicate files.
#	mkcdproto - utility to create the cdrom ISO 9660 file system. Has an
#		    option to create a special image for SunOS booting - to
#		    write a label, reserve space for bootable image.
# 	installpart - install bootable image into the cdimage.
#	labelit - utility to label the ISO 9660 portion of cdrom image.
#
CD_TAR=/usr/etc/install/cd_tar
MKCDPROTO=bin/mkcdproto
INSTALLPART=bin/installpart
LABELIT=bin/labelit

all: $(CDTAR_ALL) IMAGE

CDTAR_sun3:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun3 copy
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

CDTAR_sun4:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4 copy
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

CDTAR_sun3x:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun3x copy
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

CDTAR_sun4c:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4c copy
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

CDTAR_sun4m:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4m copy
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

CDTAR_sun4psr_a: 
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4psr_a \
	RELEASE_FILE=$(WORKDIR)/PSR_RELEASE_A \
	ARCH_REAL=sun4 copy 
	@${ECHO} "$@ done on" `${DATE}` > $@ 
	@cat $@

#CDTAR_sun4psr_b: REPLACE_TARFILES
#CDTAR_sun4c:
#	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4c \
#	RELEASE_FILE=$(WORKDIR)/PSR_RELEASE_B copy
#	@${ECHO} "$@ done on" `${DATE}` > $@ 
#	@cat $@

# dependency XXX

image:	IMAGE 

IMAGE:	$(CDTAR_ALL) patches sunupgrade_target
	rm -f $(CDIMAGE)
	# create the copyright file on the ISO partition
	# note: the same copyright file will be created for each ufs 
	#       partition, see cdrom.mk
	rm -f ${CDROM_DEST_TARFILES}/_copyright ;\
	${ECHO} ${CDLABEL_RELEASE} >> ${CDROM_DEST_TARFILES}/_copyright ;\
	${ECHO} ${CDLABEL_ARCH} >> ${CDROM_DEST_TARFILES}/_copyright ;\
	${ECHO} ${CDLABEL_MEDIA} >> ${CDROM_DEST_TARFILES}/_copyright ;\
	cat ${PARTNUM} >> ${CDROM_DEST_TARFILES}/_copyright ;\
	cat ${COPYRIGHT} >> ${CDROM_DEST_TARFILES}/_copyright ;
	# run mkcdproto
	$(MKCDPROTO) -B $(NUM_ARCHS) $(CDROM_DEST_TARFILES) $(CDIMAGE)
	# install partitions
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) TOP_VERS=$(TOP_VERS) \
	installparts
	# label (according to the ISO spec) the cdrom image 
	$(LABELIT) sysid=${SYSID} volid=${VOLID} volsetid=${VOLSETID} \
	      pubid=${PUBID} prepid=${PREPID} applid=${APPLID} \
		copyfile=${COPYFILE} ${CDIMAGE}
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@
	${ECHO} "Next Step:  make disk (or tape)"
#
# install partition images onto CD-ROM image
#
installparts: INSTALLPARTS

INSTALLPARTS: $(PART_ARCHS)
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@

sun3.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun3 \
	TOP_VERS=$(TOP_VERS) installpart

sun4.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4 \
	TOP_VERS=$(TOP_VERS) installpart

sun3x.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun3x \
	TOP_VERS=$(TOP_VERS) installpart

#sun4c.part:
#	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4c \
#	TOP_VERS=$(TOP_VERS) installpart

sun4psr_a.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4psr_a \
	TOP_VERS=$(TOP_VERS) installpart

sun4c.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4c \
	TOP_VERS=$(TOP_VERS) installpart

sun4m.part:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) ARCH=sun4m \
	TOP_VERS=$(TOP_VERS) installpart

installpart: 
	$(INSTALLPART) $(CDIMAGE) $(PART_$(TOP_VERS).$(ARCH)) \
	$(CDROM_DEST)/cdrom_part_$(ARCH)

	
#patches:
#	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) \
#	RELEASE_FILE=$(WORKDIR)/PSR_RELEASE_B PATCHES

patches:
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) \
	RELEASE_FILE=$(WORKDIR)/RELEASE PATCHES


PATCHES:
	rm -rf $(CDROM_DEST_PATCHES)
	mkdir -p $(CDROM_DEST_PATCHES)
	@set -x; if mount | egrep "$(ARCHIVE_MNT) " > /dev/null; \
	then \
		$(ECHO) "$(ARCHIVE_MNT): already mounted"; \
	else \
		if mount -o ro $(ARCHIVES) $(ARCHIVE_MNT); \
		then \
			$(ECHO) "mounted $(ARCHIVES) on $(ARCHIVE_MNT) OK"; \
		else \
			$(ECHO) "ERROR: mount of $(ARCHIVES) on $(ARCHIVE_MNT) FAILED"; \
			false; \
		fi; \
	fi ; \
	cd $(PATCH_PATH); \
	for dir in * ; \
	do \
		cd $${dir}; \
		${ECHO} -n "creating tar file for the $${dir} patches..."; \
		patchname=`echo $${dir} | tr A-Z a-z | sed -e 's/+/plus/g' \
			   -e 's/\./_/g'` ;\
		tar cf $(CDROM_DEST_PATCHES)/patch_$${patchname} .; \
		${ECHO} "created $(CDROM_DEST_PATCHES)/patch_$${patchname}" ;\
		cd ..; \
	done;	
	cp cdpatch.README ${CDROM_DEST_PATCHES}/_readme
	@${ECHO} "$@ done on" `${DATE}` > $@
	@cat $@
	umount ${ARCHIVE_MNT}

#sunupgrade
sunupgrade_target: ${CDROM_DEST_TARFILES}
	$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) \
	RELEASE_FILE=$(WORKDIR)/RELEASE SUNUPGRADE

SUNUPGRADE:
	rm -rf $(CDROM_DEST_SUNUPGRADE)
	mkdir -p $(CDROM_DEST_SUNUPGRADE)
	${ECHO} -n "copying files from ${SUNUPGRADE_PATH} ..."
	cd $(SUNUPGRADE_PATH); \
	cp -r . $(CDROM_DEST_SUNUPGRADE)
	${ECHO} "copied from ${SUNUPGRADE_PATH} to $(CDROM_DEST_SUNUPGRADE)"
	${ECHO} "$@ done on" `${DATE}` > $@
	cat $@

#
# dump the created cdrom image onto 1/2" tape to be sent to CD-ROM 
# manufacturers
#

exabyte:
	@echo "Please mount exabyte tape on $(EXABYTE_HOST):$(EXABYTE), type <return> when ready";
	read ans ;
	@echo "Rewinding Exabyte tape $(EXABYTE_HOST):$(EXABTYE)"
	rsh $(EXABYTE_HOST) "mt -f $(EXABYTE) rew"
	@echo "dd: copying $(CDIMAGE) to $(EXABYTE_HOST):$(EXABYTE)";
	dd if=$(CDIMAGE) | rsh $(EXABYTE_HOST) "dd of=$(EXABYTE) obs=8k"
	rsh $(EXABYTE_HOST) "mt -f $(EXABYTE) offline"

tapes:
	sz=` ls -l $(CDIMAGE) | ( read perm nlk own size junk; echo $$size ) `; \
	sz=` expr '(' $${sz} + 8191 ')' / 8192 ` ; \
	skip=0; \
	while [ $${sz} -gt 0 ]; do \
		if [ $${sz} -ge $(TAPESZ) ]; then \
			sz=`expr $${sz} - $(TAPESZ)`; \
			tsz=$(TAPESZ); \
		else \
			tsz=$${sz}; \
			sz=0; \
		fi ;\
		while true; do \
			$(MAKE) -$(MAKEFLAGS) -f $(MAKEFILE) newtape; \
			echo "dd: copying image $(CDIMAGE) to tape $(TAPE). ";\
			echo "    skip = $${skip}, count = $${tsz}" ;\
			echo "";\
			dd if=$(CDIMAGE) bs=8k skip=$${skip} of=$(TAPE) count=$${tsz}; \
			if [ $$? -ne 0 ]; then\
				echo "";\
				echo "ERROR: dd failed!"; \
				echo "";\
			else \
				break; \
			fi ;\
		done; \
		skip=`expr $${skip} + $${tsz}`; \
	done;

newtape:
	while true; do \
		${ECHO} "Please mount a tape on $(TAPE), type <return> when ready"; \
		read ans ;\
		if [ `mt -f $(TAPE) rewind` ]; then \
			${ECHO} "" ;\
			${ECHO} "rewind failed, please fix the tape!" ;\
			${ECHO} "" ;\
		else \
			break; \
		fi; \
	done;


# for internal testing
disk:
	# ask for a disk drive?
	echo "Dumping cdrom image on to hard disk." ;\
	defaultdev="/dev/rsd4a" ;\
	echo; \
	echo -n "Enter the raw device name for the disk drive [/dev/rsd4a] " ;\
	read diskdevice ;\
	if [ "$${diskdevice}" = "" ]; then \
		diskdevice=$${defaultdev} ; \
	fi ;\
	# check if it's mounted \
	diskdev=` expr "$${diskdevice}" : '/dev/r\(.*\)[a-h]' ` ;\
	if mount | grep $${diskdev} > /dev/null; \
	then \
		echo ; \
		echo "$${diskdev} is mounted. Please un-mount it first." ;\
		echo "Aborted" ;\
		false; \
	fi; \
	# dd $(CDIMAGE) to the drive \
	echo ;\
	echo "$${diskdevice} is chosen. ";\
	echo "Warning - this will wipe out the disk including the label.";\
	echo -n "Do you want to start dumping [y/n] ";\
	read ans ;\
	if [ "$${ans}" != "y" ]; then \
		echo "Aborted";\
		false; \
	fi ;\
	echo "dd'ing cdrom image onto $${diskdevice} ..." ;\
	dd if=${CDIMAGE} of=$${diskdevice} bs=32k

#
# ARCH is kvm arch
#

copy: $(RELEASE_FILE) $(ARCHIVE_MNT) $(CDROM_DEST_TARFILES)
	# do and test tarfile mount
	@set -x; if mount | egrep $(ARCHIVE_MNT) > /dev/null; \
	then \
		$(ECHO) "$(ARCHIVE_MNT): already mounted"; \
	else \
		if mount -o ro $(ARCHIVES) $(ARCHIVE_MNT); \
		then \
			$(ECHO) "mounted $(ARCHIVES) on $(ARCHIVE_MNT) OK"; \
		else \
			$(ECHO) "ERROR: mount of $(ARCHIVES) on $(ARCHIVE_MNT) FAILED"; \
			false; \
		fi; \
	fi 
	@set -x; if [ -d $(CDROM_DEST) ]; then \
		true; \
	else \
		${ECHO} "creating directory $(CDROM_DEST)"; \
		mkdir $(CDROM_DEST); \
	fi;
	# copy the $(ARCH_REAL)_cdrom.xdr file into XDRTOC 
	# in the current directory
	cp $(DISTPATH)/$(ARCH_REAL)_cdrom.xdr $(XDRTOC_FILE)

	#???DOES this clean the directory first???
	# copy the stuff into the directory tree
	$(CD_TAR) $(TARPATH) $(CDROM_DEST_TARFILES) \
	$(XDRTOC_FILE) $(DISTPATH)/miniroot.$(ARCH_REAL)

	# remove the XDRTOC file
	rm -f $(XDRTOC_FILE)
	
	# snarf the cdrom boot partition
	cp $(DISTPATH)/cdrom_part_$(ARCH_REAL) $(CDROM_DEST)/cdrom_part_$(ARCH)
	# unmount the distribution
	umount $(ARCHIVE_MNT)


$(ARCHIVE_MNT): 
	@set -x; if [ -d $(ARCHIVE_MNT) ]; then \
		true; \
	else \
		${ECHO} "creating directory $(ARCHIVE_MNT)"; \
		mkdir $(ARCHIVE_MNT); \
	fi;

$(CDROM_DEST_TARFILES):
	@set -x; if [ -d $(CDROM_DEST_TARFILES) ]; then \
		true; \
	fi
	@ ${ECHO} "creating directory $(CDROM_DEST_TARFILES)";
	mkdir $(CDROM_DEST_TARFILES)

$(RELEASE_FILE):
	@set -x; if [ -f $(RELEASE_FILE) ]; then \
		true; \
	else \
		${ECHO} "ERROR: $(RELEASE_FILE) not found! "; \
		${ECHO} "Create it using ~sys/conf.common/RELEASE for this build."; \
		exit 1; \
	fi;

#REPLACE_TARFILES:
#	@${ECHO} "Replacing $(USE_TOP_VERS) with $(ARCH)."
#	cd $(CDROM_DEST_TARFILES); rm -f $(USE_TOP_VERS)

clean:
	rm -rf $(CDTAR_ALL) PATCHES SUNUPGRADE \
	IMAGE INSTALLPARTS XDRTOC_FILE \
	$(CDROM_DEST_TARFILES) \
	$(CDROM_DEST)/cdrom_part_* \
	rm -f $(CDIMAGE)
