/*	@(#)vuid_state.h 1.1 94/10/31 SMI	*/

/*
 * Copyright (c) 1985 by Sun Microsystems, Inc.
 */

/*
 * This file describes a virtual user input device (vuid) state
 * maintainence package (see ../sundev/vuid_event.h for a description
 * of what vuid is).  This header file defines the interface that a
 * client of this package sees.  This package is used to maintain the
 * state of all the events generated by an arbitrary number of physical
 * devices which are all producing Firm_events.
 */

#ifndef _sundev_vuid_state_h
#define _sundev_vuid_state_h

typedef	caddr_t Vuid_state;
#define VUID_STATE_NULL ((Vuid_state)0)

void	vuid_set_value();	/* (Vuid_state *state, Firm_event *event)
				   Don't call in critical section or
				   at interrupt level*/
int	vuid_get_value();	/* (Vuid_state state, u_short id) */
void	vuid_destroy_state();	/* (Vuid_state state) Don't call in critical
				   section or at interrupt level */
Vuid_state vuid_copy_state();	/* (Vuid_state state) Don't call in critical
				   section or at interrupt level */

#endif /*!_sundev_vuid_state_h*/
