#ifndef lint
static	char sccsid[] = "@(#)mkbootconf.c 1.1 94/10/31 SMI";
#endif

/*
 * Build a boot configuration file.
 */
#include <stdio.h>
#include <ctype.h>

#include "config.h"

FILE *initfile();

bootconf()
{
	FILE *fp;
	register struct file_list *fl;
	char namebuf[128];

	for (fl = conf_list; fl != 0; fl = fl->f_next) {
		if (fl->f_type != SYSTEMSPEC)
			continue;
		sprintf(namebuf, "conf%s.c", fl->f_fn);
		fp = initfile(namebuf);
		doconf(fp, fl->f_root, "rootfs");
		doconf(fp, fl->f_swap, "swapfile");
		doconf(fp, fl->f_dump, "dumpfile");
		fclose(fp);
	}
}

FILE *
initfile(name)
	char *name;
{
	FILE *fp;
	char *pathname;

	pathname = path(name);
	fp = fopen(pathname, "w");
	if (fp == NULL) {
		perror(pathname);
		exit(1);
	}
	fprintf(fp,
		"/* Boot configuration. This file generated by config(8) */\n\n");
	fprintf(fp, "#include <sys/bootconf.h>\n");
	return (fp);
}

doconf(fp, fl, name)
	FILE *fp;
	struct file_list *fl;
	char *name;
{
	fprintf(fp, "\nstruct bootobj %s = {\n", name);
	if (fl) {
		fprintf(fp, "\t{ \"");
		if (fl->f_fstype) {
			fprintf(fp, "%s", fl->f_fstype);
		}
		fprintf(fp, "\",\t\"");
		if (fl->f_fn) {
			fprintf(fp, "%s", fl->f_fn);
		}
		fprintf(fp, "\",\t0, %d, (struct vnode *)0 },\n", fl->f_size);
	} else {
		fprintf(fp, "\t{ \"\",\t\"\",\t0, 0, (struct vnode *)0 },\n");
	}
	fprintf(fp, "};\n");
}
