#ifndef lint
static	char sccsid[] = "@(#)pf_makedef.c 1.1 94/10/31 SMI";
#endif

/*
 * Copyright 1986-1989 Sun Microsystems, Inc.
 */

/*
 * Program to generate the source file for the
 * module which holds built in pixrect font data.
 */

#include <stdio.h>
#include <strings.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <vfont.h>

#define MAX_FONTS	  16
#define MAX_PATHLEN	1024

extern char	*malloc();

extern int	 strcmp();

static char	*font_names[MAX_FONTS],
		*default_font_name,
		*font_dir = "../fixedwidthfonts/";

static int	 default_font_number,
		 font_count;

static int	 init_font_file(),
		 load_font_names();

static void	 emit_char_bits(),
		 init_file(),
		 process_1_char(),
		 process_1_font(),
		 terminate_file(),
		 terminate_font();


main()
{
    int		 i;

#   ifdef GALL_DEFAULT
	font_names[0] = "gallant.r.19";
	font_count = 1;
#   else
#   ifdef SCRN_DEFAULT
	font_names[0] = "screen.r.11";
	font_count = 1;
#   else
	load_font_names();
#   endif
#   endif

    if (font_count <= 0) {
	(void) fprintf(stderr,
		"At least 1 font must be named in resident_fonts.\n");
	exit(1);
    }
    default_font_name = font_names[0];
    init_file();
    for (i = 0; i < font_count; i++) {
	process_1_font(font_names[i]);
    }
    terminate_file();
    exit(0);
}

static void
init_file()
{
    struct tm		*buf;
    time_t		 clock, time();

    if (time(&clock) == -1) {
	perror("pf_make_defdata(time)");
	exit(1);
    }
    buf = localtime(&clock);
    (void) printf("\
#ifndef lint\n\
static char sccsid[] = \"@(#)pf_defdata.c 1.0 %02d/%02d/%02d SMI\";\n\
#endif\n\
\n\
/*\n\
 * Copyright %04d by Sun Microsystems, Inc.\n\
 */\n\
\n\
/*\n\
 * Memory resident font definitions.\n\
 *\n\
 * This file was machine-generated by running pf_makedef.\n\
 */\n\
\n\
#include <sys/types.h>\n\
#include <pixrect/pixrect.h>\n\
#include <pixrect/pixfont.h>\n\
#include <pixrect/memvar.h>\n\
\n\
#ifdef SHLIB\n\
\n\
/*\n\
 * Dummy version for shared library.\n\
 */\n\
\n\
char *\n\
pf_bltindefname()\n\
{\n\
	return \"/usr/lib/fonts/fixedwidthfonts/screen.r.14\";\n\
}\n\
\n\
Pixfont *\n\
pf_bltindef()\n\
{\n\
	return pf_open(pf_bltindefname());\n\
}\n\
\n\
Pixfont *\n\
pf_resident(name)\n\
	char *name;\n\
{\n\
	return name ? 0 : pf_bltindef();\n\
}\n\
\n\
#else SHLIB\n\
\n\
#define	pcpr(name, w, h, image) \\\n\
	static struct mpr_data CAT(name,_data) = \\\n\
	{mpr_linebytes(w,1), (short *)(image), {0, 0}, 0, \
		(w) <= 16 ? MP_FONT : 0}; \\\n\
	static Pixrect name = {&mem_ops, w, h, 1, (caddr_t)&CAT(name,_data)}\n\
\n\
\n",
	buf->tm_year, buf->tm_mon, buf->tm_mday,
	buf->tm_year+1900, buf->tm_year+1900);
}

static int
load_font_names()
{
    int                   len;
    char                  line[MAX_PATHLEN], *linep;

    while (gets(line)) {
	if ((len = strlen(line)) == 0)
	    continue;
	switch (line[0]) {
	  case '/':
	    if (line[1] == '*')
		continue;
	    else
		goto error;
	  case '#':
	    if ((linep = index(line, '"')) == (char *) 0)
		goto error;
	    len = strlen(++linep);
	    if ((font_dir = malloc((unsigned) len)) == (char *) 0) {
		(void) fprintf(stderr, "malloc failed (out of swap space?)\n");
		perror("load_font_names");
		exit(1);
	    }
	    bcopy(linep, font_dir, --len);
	    font_dir[len] = '\0';
	    continue;

	  case '"':
	    if ((linep = malloc((unsigned) --len)) == (char *) 0) {
		(void) fprintf(stderr, "malloc failed (out of swap space?)\n");
		perror("load_font_names");
		exit(1);
	    }
	    bcopy(line + 1, linep, --len);
	    linep[len] = '\0';
	    font_names[font_count++] = linep;
	    continue;
error:
	  default:
	    (void) fprintf(stderr, "\
unrecognized line ignored in font list:\n\
    %s\n\
Should be either #define FONT_DIR \"<pathname>\" or \"<font-filename>\"\n",
		    line);
	}
    }
}

static void
process_1_font(font_name)
    char                 *font_name;
{
    char                  pix_chars[10240],
			 *pc_bufp = pix_chars;
    FILE                 *font_file;
    struct header         header;
    struct dispatch       dispatch[NUM_DISPATCH];
    int                   font_x, font_y;
    int                   current_char;
    static int            current_font;

    if (!init_font_file(font_name, &font_file, &header,
			dispatch, &font_x, &font_y)) {
	(void) fprintf(stderr, "could not process font %s; aborting\n", 
		font_name);
	exit(2);
    }
    *pc_bufp = '\0';
    for (current_char = 0; current_char < NUM_DISPATCH; current_char++) {
	process_1_char(font_file, &pc_bufp, dispatch + current_char,
		       current_font, current_char);
    }
    terminate_font(font_file, font_name, pix_chars,
		   current_font, font_x, font_y);
    current_font++;
    return;
}

static int
init_font_file(name, file, header, dispatch, font_x, font_y)
    char                 *name;
    FILE                **file;
    struct header        *header;
    struct dispatch	 *dispatch;
    int			 *font_x, *font_y;
{
    char                  font_path[MAX_PATHLEN * 2];
    struct stat           stat_buf;
    char *sprintf();

    (void) strcpy(font_path, font_dir);
    (void) strcat(font_path, name);
    if ((*file = fopen(font_path, "r")) == (FILE *) NULL) {
	perror("make_defdata (fopen)");
	return 0;
    }

    if (fread((char *) header, sizeof *header, 1, *file) != 1) {
	perror("make_defdata (fread)");
	goto bad_file;
    }
    if (header->magic != VFONT_MAGIC) {
	(void) fprintf(stderr, "make_defdata (bad magic number)\n");
	goto bad_file;
    }
    if (fread((char *) dispatch, sizeof(struct dispatch) * NUM_DISPATCH, 1, 
    	*file) != 1) {
	perror("make_defdata (fread)");
	goto bad_file;
    }
    if (fstat(fileno(*file), &stat_buf) == -1)
    	perror("make_defdata (fstat)");
    if (stat_buf.st_size != sizeof(struct header) +
			    sizeof(struct dispatch) * NUM_DISPATCH +
			    header->size) {
	perror("make_defdata (stat size)");
	goto bad_file;
    }
    *font_x = dispatch['a'].nbytes ?
		dispatch['a'].width : header->maxx;
    if (*font_x <= 0 ||  *font_x>= 1024) {
	(void) fprintf(stderr, "make_defdata (invalid font width)\n");
	goto bad_file;
    }
    *font_y = dispatch['A'].nbytes ?
		(dispatch['A'].up*3)/2 : header->maxy;
    if (*font_y <= 0 || *font_y >= 1024) {
	(void) fprintf(stderr, "make_defdata (invalid font height)\n");
	goto bad_file;
    }
    (void) printf("\f/*	Data for font %s	*/\n\n", name);
    return 1;

bad_file:
    (void) fclose(*file);
    return 0;
}

static void
process_1_char(file, pc_bufp, v_char, font_no, char_no)
    FILE                 *file;
    char                **pc_bufp;
    struct dispatch      *v_char;
    int                   font_no, char_no;
{
    register int          x_bits, x_words, y_lines;
    char                  data_name[16], mpr_name[16];

    if (v_char->nbytes > 0) {
	(void) sprintf(data_name, "f%02d_c%03d_", font_no, char_no);
	(void) strcpy(mpr_name, data_name);
	(void) strcat(data_name, "image");
	(void) strcat(mpr_name, "pr");
	x_bits = v_char->left + v_char->right;
	x_words = (x_bits + 15) >> 4;
	y_lines = v_char->up + v_char->down;
	(void) printf("static short %s[%d] = {\n\t", data_name,
 		x_words * y_lines);
	emit_char_bits(file, v_char, x_bits, x_words, y_lines);
	(void) printf("};\n");
	(void) printf("pcpr(%s, %d, %d, %s);\n",
	       mpr_name, x_bits, y_lines, data_name);
	(void) sprintf(*pc_bufp, "\t{ &%s, {%d, %d}, {%d, %d} },\n",
		mpr_name, -v_char->left, -v_char->up, v_char->width, 0);
    } else {
	(void) strcat(*pc_bufp, "\t{ 0, {0, 0}, {0, 0} },\n");
    }
    *pc_bufp += strlen(*pc_bufp);
}

#define FONT_BASE	(sizeof(struct header) +  \
			 sizeof(struct dispatch) * NUM_DISPATCH)
static void
emit_char_bits(file, v_char, x_bits, x_words, y_lines)
    FILE                 *file;
    struct dispatch      *v_char;
    int                   x_bits, x_words, y_lines;
{
    char                  buffer[256];
    register u_short     *wordp;
    int                   word_count = 0, x_bytes, x, y;

    if (fseek(file, (long) (FONT_BASE+v_char->addr), 0) == -1) {
	perror("pf_make_resident: fseek");
	exit(3);
    }
    x_bytes = (x_bits + 7) >> 3;
    for (y = 0; y < y_lines; y++) {
	if (fread(buffer, 1, x_bytes, file) < x_bytes) {
	    perror("pf_make_resident: fread");
	    exit(3);
	}
	if (x_bytes % 2)
	    buffer[x_bytes] = 0;
	wordp = (u_short *) buffer;
	for (x = 0; x < x_words; x++) {
	    (void) printf("0x%04x,", *wordp++);
	    if ((word_count++ % 8) == 7)
		(void) printf("\n\t");
	    else
		(void) printf(" ");
	}
    }
}


static void
terminate_font(file, name, pc_buf, font, width, height)
    FILE                 *file;
    char                 *name, *pc_buf;
    int			  font, width, height;
{
    (void) printf("static Pixfont f%02d = {\n    {%d, %d},\n    {",
	    font, width, height);
    (void) printf(pc_buf);
    (void) printf("    }\n};\n");
    if (strcmp(name, default_font_name) == 0)
	default_font_number = font;
    (void) fclose(file);
}


static void
terminate_file()
{
    int	i;

    (void) printf("\f/*	end of data for specific fonts	*/\n\n");

    (void) printf("\
struct font_pair {\n\
	char		*font_name;\n\
	Pixfont	*font;\n\
};\n\
\n\
static struct font_pair	font_table[%d] = {\n",
	font_count);

    for (i=0; i < font_count; i++)
	(void) printf("\t{ \"%s\", &f%02d },\n", font_names[i], i);

    (void) printf("\
};\n\
\n\
static struct font_pair	default_font = {\n\
	\"%s\", &f%02d\n\
};\n",
	default_font_name, default_font_number);

    (void) printf("static int	font_count = %d;\n\n", font_count);

    (void) printf("\
Pixfont *\n\
pf_bltindef()\n{    return default_font.font;\n}\n\
\n\
char *\n\
pf_bltindefname()\n{    return default_font.font_name;\n}\n\
\n\
Pixfont *\npf_resident(name)\n\
    char		*name;\n\
{   struct font_pair	*ptr;\n\
    if (name == (char *) 0)\n\
	return default_font.font;\n\
    for (ptr=font_table+font_count; ptr>font_table;) {\n\
	if (strcmp(name, (--ptr)->font_name) == 0)\n\
	    return ptr->font;\n\
    }\n\
    return (Pixfont *) 0;\n\
}\n\
\n\
#endif SHLIB\n\
");
}
