#!/bin/sh

#variables
xorg_log="/var/log/Xorg.0.log"
PKGPWD=`pwd`
arch=""
dist=""
ubuntu=""
cmd_sudo=""
test -e /usr/bin/sudo && cmd_sudo="sudo"

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
  echo "The architecture is x86_64"
  arch="x86_64"
else
  echo "The architecture is x86"
  arch="x86"
fi

#check the exist of xorg_log
test ! -e $xorg_log &&  echo "Can't find proper X Window Version, Please update driver manually!!" && exit 1

#check vermagic beta
if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.16.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_4"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.15.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_3"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.14.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_2"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.13.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.12.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.11.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77_2"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.10.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.9.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.8.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.6"
    dist="xorg76_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.7.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.6"
    dist="xorg76"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.6.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.5"
    dist="xorg75_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.5.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.5"
    dist="xorg75"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.4.99.9" $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.4"
    dist="xorg74"
  fi
fi

#check vermagic
if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.17." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_4"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.16." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_3"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.15." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_2"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.14." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.13." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.8"
    dist="xorg78"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.12." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77_2"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.11." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.10." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.7"
    dist="xorg77"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.9." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.6"
    dist="xorg76_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.8." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.6"
    dist="xorg76"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.7." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.5"
    dist="xorg75_1"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.6." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.5"
    dist="xorg75"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.5." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.4"
    dist="xorg74"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.4." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.3"
    dist="xorg73"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X.Org X Server 1.3." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.2"
    dist="xorg72"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 1.3." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.2"
    dist="xorg72"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 7.2." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.2"
    dist="xorg72"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 7.1." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.1"
    dist="xorg71"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 7.0." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 7.0"
    dist="xorg7"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 6.9." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 6.9"
    dist="xorg69"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 6.8." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 6.8"
    dist="xorg68"
  fi
fi

if [ "$dist" = "" ]; then
  XORG_VER=`grep -F "X Window System Version 6.7." $xorg_log`
  if [ "$XORG_VER" != "" ]; then
    echo "X Window is Xorg 6.7"
    dist="xorg67"
  fi
fi

if [ "$dist" = "" ]; then
  echo "Can't find proper X Window Version, Please update driver manually!!"
  exit 1
fi

#check for ubuntu
ubuntu=`grep "ubuntu" $xorg_log`
if [ "$ubuntu" != "" ]; then
  echo "Ubuntu Distribution"
  test -d /usr/share/xserver-xorg/pci && $cmd_sudo cp ast.ids /usr/share/xserver-xorg/pci
fi

#driver update
test -d $PKGPWD/$arch/$dist || exit 1

cd $PKGPWD/$arch/$dist
./update.sh

cd $PKGPWD


