/******************************************************************************

  Copyright (c) 2013-2014, Intel Corporation 
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are met:
  
   1. Redistributions of source code must retain the above copyright notice, 
      this list of conditions and the following disclaimer.
  
   2. Redistributions in binary form must reproduce the above copyright 
      notice, this list of conditions and the following disclaimer in the 
      documentation and/or other materials provided with the distribution.
  
   3. Neither the name of the Intel Corporation nor the names of its 
      contributors may be used to endorse or promote products derived from 
      this software without specific prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE 
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
  POSSIBILITY OF SUCH DAMAGE.

******************************************************************************/
/*$FreeBSD$*/

#ifndef _I40E_REGISTER_X710_INT_H_
#define _I40E_REGISTER_X710_INT_H_

/* PF - Admin Queue */

#define I40E_GL_ARQLEN                 0x000802C0 /* Reset: EMPR */
#define I40E_GL_ARQLEN_ARQLEN_SHIFT    0
#define I40E_GL_ARQLEN_ARQLEN_MASK     I40E_MASK(0x3FF, I40E_GL_ARQLEN_ARQLEN_SHIFT)
#define I40E_GL_ARQLEN_ARQVFE_SHIFT    28
#define I40E_GL_ARQLEN_ARQVFE_MASK     I40E_MASK(0x1, I40E_GL_ARQLEN_ARQVFE_SHIFT)
#define I40E_GL_ARQLEN_ARQOVFL_SHIFT   29
#define I40E_GL_ARQLEN_ARQOVFL_MASK    I40E_MASK(0x1, I40E_GL_ARQLEN_ARQOVFL_SHIFT)
#define I40E_GL_ARQLEN_ARQCRIT_SHIFT   30
#define I40E_GL_ARQLEN_ARQCRIT_MASK    I40E_MASK(0x1, I40E_GL_ARQLEN_ARQCRIT_SHIFT)
#define I40E_GL_ARQLEN_ARQENABLE_SHIFT 31
#define I40E_GL_ARQLEN_ARQENABLE_MASK  I40E_MASK(0x1, I40E_GL_ARQLEN_ARQENABLE_SHIFT)

/* PF - Analyzer Registers */

#define I40E_GL_RCU_PRS_L2TAG(_i)             (0x0026CFC0 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_RCU_PRS_L2TAG_MAX_INDEX       7
#define I40E_GL_RCU_PRS_L2TAG_LENGTH_SHIFT    0
#define I40E_GL_RCU_PRS_L2TAG_LENGTH_MASK     I40E_MASK(0x7F, I40E_GL_RCU_PRS_L2TAG_LENGTH_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_HAS_UP_SHIFT    7
#define I40E_GL_RCU_PRS_L2TAG_HAS_UP_MASK     I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_HAS_UP_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_ISVLAN_SHIFT    9
#define I40E_GL_RCU_PRS_L2TAG_ISVLAN_MASK     I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_ISVLAN_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_INNERUP_SHIFT   10
#define I40E_GL_RCU_PRS_L2TAG_INNERUP_MASK    I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_INNERUP_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_OUTERUP_SHIFT   11
#define I40E_GL_RCU_PRS_L2TAG_OUTERUP_MASK    I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_OUTERUP_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_LONG_SHIFT      12
#define I40E_GL_RCU_PRS_L2TAG_LONG_MASK       I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_LONG_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_ISSIA_SHIFT     13
#define I40E_GL_RCU_PRS_L2TAG_ISSIA_MASK      I40E_MASK(0x1, I40E_GL_RCU_PRS_L2TAG_ISSIA_SHIFT)
#define I40E_GL_RCU_PRS_L2TAG_ETHERTYPE_SHIFT 16
#define I40E_GL_RCU_PRS_L2TAG_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GL_RCU_PRS_L2TAG_ETHERTYPE_SHIFT)

#define I40E_GL_SWT_L2TAG0(_i)        (0x00044278 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_L2TAG0_MAX_INDEX  7
#define I40E_GL_SWT_L2TAG0_DATA_SHIFT 0
#define I40E_GL_SWT_L2TAG0_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_L2TAG0_DATA_SHIFT)

#define I40E_GL_SWT_L2TAG1(_i)        (0x00044298 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_L2TAG1_MAX_INDEX  7
#define I40E_GL_SWT_L2TAG1_DATA_SHIFT 0
#define I40E_GL_SWT_L2TAG1_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_L2TAG1_DATA_SHIFT)

#define I40E_GL_SWT_L2TAGCTRL(_i)             (0x001C0A70 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_L2TAGCTRL_MAX_INDEX       7
#define I40E_GL_SWT_L2TAGCTRL_LENGTH_SHIFT    0
#define I40E_GL_SWT_L2TAGCTRL_LENGTH_MASK     I40E_MASK(0x7F, I40E_GL_SWT_L2TAGCTRL_LENGTH_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_HAS_UP_SHIFT    7
#define I40E_GL_SWT_L2TAGCTRL_HAS_UP_MASK     I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_HAS_UP_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_ISVLAN_SHIFT    9
#define I40E_GL_SWT_L2TAGCTRL_ISVLAN_MASK     I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_ISVLAN_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_INNERUP_SHIFT   10
#define I40E_GL_SWT_L2TAGCTRL_INNERUP_MASK    I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_INNERUP_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_OUTERUP_SHIFT   11
#define I40E_GL_SWT_L2TAGCTRL_OUTERUP_MASK    I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_OUTERUP_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_LONG_SHIFT      12
#define I40E_GL_SWT_L2TAGCTRL_LONG_MASK       I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_LONG_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_ISSIA_SHIFT     13
#define I40E_GL_SWT_L2TAGCTRL_ISSIA_MASK      I40E_MASK(0x1, I40E_GL_SWT_L2TAGCTRL_ISSIA_SHIFT)
#define I40E_GL_SWT_L2TAGCTRL_ETHERTYPE_SHIFT 16
#define I40E_GL_SWT_L2TAGCTRL_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GL_SWT_L2TAGCTRL_ETHERTYPE_SHIFT)

#define I40E_GL_SWT_L2TAGRXEB(_i)          (0x00051000 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_L2TAGRXEB_MAX_INDEX    7
#define I40E_GL_SWT_L2TAGRXEB_OFFSET_SHIFT 0
#define I40E_GL_SWT_L2TAGRXEB_OFFSET_MASK  I40E_MASK(0xFF, I40E_GL_SWT_L2TAGRXEB_OFFSET_SHIFT)
#define I40E_GL_SWT_L2TAGRXEB_LENGTH_SHIFT 8
#define I40E_GL_SWT_L2TAGRXEB_LENGTH_MASK  I40E_MASK(0x3, I40E_GL_SWT_L2TAGRXEB_LENGTH_SHIFT)

#define I40E_GL_SWT_L2TAGTXIB(_i)          (0x000442B8 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_L2TAGTXIB_MAX_INDEX    7
#define I40E_GL_SWT_L2TAGTXIB_OFFSET_SHIFT 0
#define I40E_GL_SWT_L2TAGTXIB_OFFSET_MASK  I40E_MASK(0xFF, I40E_GL_SWT_L2TAGTXIB_OFFSET_SHIFT)
#define I40E_GL_SWT_L2TAGTXIB_LENGTH_SHIFT 8
#define I40E_GL_SWT_L2TAGTXIB_LENGTH_MASK  I40E_MASK(0x3, I40E_GL_SWT_L2TAGTXIB_LENGTH_SHIFT)

#define I40E_GLANL_L2ULP(_i)             (0x001C0A2C + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLANL_L2ULP_MAX_INDEX       15
#define I40E_GLANL_L2ULP_ETHERTYPE_SHIFT 0
#define I40E_GLANL_L2ULP_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GLANL_L2ULP_ETHERTYPE_SHIFT)
#define I40E_GLANL_L2ULP_ENABLE_SHIFT    31
#define I40E_GLANL_L2ULP_ENABLE_MASK     I40E_MASK(0x1, I40E_GLANL_L2ULP_ENABLE_SHIFT)

#define I40E_GLANL_PRE_LY2                  0x001C0A20 /* Reset: CORER */
#define I40E_GLANL_PRE_LY2_PRE_LY2_L2_SHIFT 0
#define I40E_GLANL_PRE_LY2_PRE_LY2_L2_MASK  I40E_MASK(0xFFFF, I40E_GLANL_PRE_LY2_PRE_LY2_L2_SHIFT)

#define I40E_GLPPRS_INDIRECT_ADDRESS            0x001C0A90 /* Reset: CORER */
#define I40E_GLPPRS_INDIRECT_ADDRESS_ADDR_SHIFT 0
#define I40E_GLPPRS_INDIRECT_ADDRESS_ADDR_MASK  I40E_MASK(0xFFFF, I40E_GLPPRS_INDIRECT_ADDRESS_ADDR_SHIFT)

#define I40E_GLPPRS_INDIRECT_DATA(_i)        (0x001C0A94 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPPRS_INDIRECT_DATA_MAX_INDEX  3
#define I40E_GLPPRS_INDIRECT_DATA_DATA_SHIFT 0
#define I40E_GLPPRS_INDIRECT_DATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPPRS_INDIRECT_DATA_DATA_SHIFT)

#define I40E_GLRDPU_L2TAGCTRL(_i)             (0x00051020 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GLRDPU_L2TAGCTRL_MAX_INDEX       7
#define I40E_GLRDPU_L2TAGCTRL_LENGTH_SHIFT    0
#define I40E_GLRDPU_L2TAGCTRL_LENGTH_MASK     I40E_MASK(0x7F, I40E_GLRDPU_L2TAGCTRL_LENGTH_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_HAS_UP_SHIFT    7
#define I40E_GLRDPU_L2TAGCTRL_HAS_UP_MASK     I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_HAS_UP_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_ISVLAN_SHIFT    9
#define I40E_GLRDPU_L2TAGCTRL_ISVLAN_MASK     I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_ISVLAN_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_INNERUP_SHIFT   10
#define I40E_GLRDPU_L2TAGCTRL_INNERUP_MASK    I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_INNERUP_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_OUTERUP_SHIFT   11
#define I40E_GLRDPU_L2TAGCTRL_OUTERUP_MASK    I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_OUTERUP_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_LONG_SHIFT      12
#define I40E_GLRDPU_L2TAGCTRL_LONG_MASK       I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_LONG_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_ISSIA_SHIFT     13
#define I40E_GLRDPU_L2TAGCTRL_ISSIA_MASK      I40E_MASK(0x1, I40E_GLRDPU_L2TAGCTRL_ISSIA_SHIFT)
#define I40E_GLRDPU_L2TAGCTRL_ETHERTYPE_SHIFT 16
#define I40E_GLRDPU_L2TAGCTRL_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GLRDPU_L2TAGCTRL_ETHERTYPE_SHIFT)

#define I40E_GLTDPU_L2TAGCTRL(_i)             (0x00044204 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GLTDPU_L2TAGCTRL_MAX_INDEX       7
#define I40E_GLTDPU_L2TAGCTRL_LENGTH_SHIFT    0
#define I40E_GLTDPU_L2TAGCTRL_LENGTH_MASK     I40E_MASK(0x7F, I40E_GLTDPU_L2TAGCTRL_LENGTH_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_HAS_UP_SHIFT    7
#define I40E_GLTDPU_L2TAGCTRL_HAS_UP_MASK     I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_HAS_UP_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_ISVLAN_SHIFT    9
#define I40E_GLTDPU_L2TAGCTRL_ISVLAN_MASK     I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_ISVLAN_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_INNERUP_SHIFT   10
#define I40E_GLTDPU_L2TAGCTRL_INNERUP_MASK    I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_INNERUP_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_OUTERUP_SHIFT   11
#define I40E_GLTDPU_L2TAGCTRL_OUTERUP_MASK    I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_OUTERUP_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_LONG_SHIFT      12
#define I40E_GLTDPU_L2TAGCTRL_LONG_MASK       I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_LONG_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_ISSIA_SHIFT     13
#define I40E_GLTDPU_L2TAGCTRL_ISSIA_MASK      I40E_MASK(0x1, I40E_GLTDPU_L2TAGCTRL_ISSIA_SHIFT)
#define I40E_GLTDPU_L2TAGCTRL_ETHERTYPE_SHIFT 16
#define I40E_GLTDPU_L2TAGCTRL_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GLTDPU_L2TAGCTRL_ETHERTYPE_SHIFT)

#define I40E_GLTDPU_L2ULP(_i)             (0x00044224 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLTDPU_L2ULP_MAX_INDEX       15
#define I40E_GLTDPU_L2ULP_ETHERTYPE_SHIFT 0
#define I40E_GLTDPU_L2ULP_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_GLTDPU_L2ULP_ETHERTYPE_SHIFT)
#define I40E_GLTDPU_L2ULP_ENABLE_SHIFT    31
#define I40E_GLTDPU_L2ULP_ENABLE_MASK     I40E_MASK(0x1, I40E_GLTDPU_L2ULP_ENABLE_SHIFT)

#define I40E_GLTDPU_PRE_LY2                  0x00044200 /* Reset: CORER */
#define I40E_GLTDPU_PRE_LY2_PRE_LY2_L2_SHIFT 0
#define I40E_GLTDPU_PRE_LY2_PRE_LY2_L2_MASK  I40E_MASK(0xFFFF, I40E_GLTDPU_PRE_LY2_PRE_LY2_L2_SHIFT)

#define I40E_PRT_PPRSL2TAGSEN              0x00087080 /* Reset: CORER */
#define I40E_PRT_PPRSL2TAGSEN_ENABLE_SHIFT 0
#define I40E_PRT_PPRSL2TAGSEN_ENABLE_MASK  I40E_MASK(0xFF, I40E_PRT_PPRSL2TAGSEN_ENABLE_SHIFT)

#define I40E_PRT_TDPUL2TAGSEN              0x00044140 /* Reset: CORER */
#define I40E_PRT_TDPUL2TAGSEN_ENABLE_SHIFT 0
#define I40E_PRT_TDPUL2TAGSEN_ENABLE_MASK  I40E_MASK(0xFF, I40E_PRT_TDPUL2TAGSEN_ENABLE_SHIFT)

#define I40E_PRTPPRS_INDIRECT_ADDRESS            0x00084320 /* Reset: CORER */
#define I40E_PRTPPRS_INDIRECT_ADDRESS_ADDR_SHIFT 0
#define I40E_PRTPPRS_INDIRECT_ADDRESS_ADDR_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_INDIRECT_ADDRESS_ADDR_SHIFT)

#define I40E_PRTPPRS_INDIRECT_DATA(_i)        (0x00084340 + ((_i) * 32)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_PRTPPRS_INDIRECT_DATA_MAX_INDEX  3
#define I40E_PRTPPRS_INDIRECT_DATA_DATA_SHIFT 0
#define I40E_PRTPPRS_INDIRECT_DATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTPPRS_INDIRECT_DATA_DATA_SHIFT)

#define I40E_PRTPPRS_L2TAGCTRL(_i)             (0x00084020 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTPPRS_L2TAGCTRL_MAX_INDEX       7
#define I40E_PRTPPRS_L2TAGCTRL_LENGTH_SHIFT    0
#define I40E_PRTPPRS_L2TAGCTRL_LENGTH_MASK     I40E_MASK(0x7F, I40E_PRTPPRS_L2TAGCTRL_LENGTH_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_HAS_UP_SHIFT    7
#define I40E_PRTPPRS_L2TAGCTRL_HAS_UP_MASK     I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_HAS_UP_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_ISVLAN_SHIFT    9
#define I40E_PRTPPRS_L2TAGCTRL_ISVLAN_MASK     I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_ISVLAN_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_INNERUP_SHIFT   10
#define I40E_PRTPPRS_L2TAGCTRL_INNERUP_MASK    I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_INNERUP_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_OUTERUP_SHIFT   11
#define I40E_PRTPPRS_L2TAGCTRL_OUTERUP_MASK    I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_OUTERUP_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_LONG_SHIFT      12
#define I40E_PRTPPRS_L2TAGCTRL_LONG_MASK       I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_LONG_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_ISSIA_SHIFT     13
#define I40E_PRTPPRS_L2TAGCTRL_ISSIA_MASK      I40E_MASK(0x1, I40E_PRTPPRS_L2TAGCTRL_ISSIA_SHIFT)
#define I40E_PRTPPRS_L2TAGCTRL_ETHERTYPE_SHIFT 16
#define I40E_PRTPPRS_L2TAGCTRL_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_L2TAGCTRL_ETHERTYPE_SHIFT)

#define I40E_PRTPPRS_L2ULP(_i)             (0x00084120 + ((_i) * 32)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_PRTPPRS_L2ULP_MAX_INDEX       15
#define I40E_PRTPPRS_L2ULP_ETHERTYPE_SHIFT 0
#define I40E_PRTPPRS_L2ULP_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_L2ULP_ETHERTYPE_SHIFT)
#define I40E_PRTPPRS_L2ULP_ENABLE_SHIFT    31
#define I40E_PRTPPRS_L2ULP_ENABLE_MASK     I40E_MASK(0x1, I40E_PRTPPRS_L2ULP_ENABLE_SHIFT)

#define I40E_PRTPPRS_PRE_LY2                  0x00084000 /* Reset: CORER */
#define I40E_PRTPPRS_PRE_LY2_PRE_LY2_L2_SHIFT 0
#define I40E_PRTPPRS_PRE_LY2_PRE_LY2_L2_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_PRE_LY2_PRE_LY2_L2_SHIFT)

#define I40E_PRTPPRS_SIATH(_i)             (0x00085900 + ((_i) * 32)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_PRTPPRS_SIATH_MAX_INDEX       15
#define I40E_PRTPPRS_SIATH_ETHERTYPE_SHIFT 0
#define I40E_PRTPPRS_SIATH_ETHERTYPE_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_SIATH_ETHERTYPE_SHIFT)
#define I40E_PRTPPRS_SIATH_VLAN_ID_SHIFT   16
#define I40E_PRTPPRS_SIATH_VLAN_ID_MASK    I40E_MASK(0xFFF, I40E_PRTPPRS_SIATH_VLAN_ID_SHIFT)
#define I40E_PRTPPRS_SIATH_VALID_SHIFT     31
#define I40E_PRTPPRS_SIATH_VALID_MASK      I40E_MASK(0x1, I40E_PRTPPRS_SIATH_VALID_SHIFT)

#define I40E_PRTPPRS_SIATL(_i)                (0x00085700 + ((_i) * 32)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_PRTPPRS_SIATL_MAX_INDEX          15
#define I40E_PRTPPRS_SIATL_GRE_PROTOCOL_SHIFT 0
#define I40E_PRTPPRS_SIATL_GRE_PROTOCOL_MASK  I40E_MASK(0xFFFF, I40E_PRTPPRS_SIATL_GRE_PROTOCOL_SHIFT)
#define I40E_PRTPPRS_SIATL_GRE_FLAG_SHIFT     16
#define I40E_PRTPPRS_SIATL_GRE_FLAG_MASK      I40E_MASK(0x1, I40E_PRTPPRS_SIATL_GRE_FLAG_SHIFT)
#define I40E_PRTPPRS_SIATL_NIBBLE_FLAG_SHIFT  17
#define I40E_PRTPPRS_SIATL_NIBBLE_FLAG_MASK   I40E_MASK(0x1, I40E_PRTPPRS_SIATL_NIBBLE_FLAG_SHIFT)
#define I40E_PRTPPRS_SIATL_SKIP_OFFSET_SHIFT  18
#define I40E_PRTPPRS_SIATL_SKIP_OFFSET_MASK   I40E_MASK(0x3F, I40E_PRTPPRS_SIATL_SKIP_OFFSET_SHIFT)

/* PF - CM Registers */

#define I40E_GLCM_LANCLSADDR                0x0010C444 /* Reset: CORER */
#define I40E_GLCM_LANCLSADDR_CLS_ADDR_SHIFT 0
#define I40E_GLCM_LANCLSADDR_CLS_ADDR_MASK  I40E_MASK(0x1FF, I40E_GLCM_LANCLSADDR_CLS_ADDR_SHIFT)

#define I40E_GLCM_LANCLSDATAHI                   0x0010C44C /* Reset: CORER */
#define I40E_GLCM_LANCLSDATAHI_CLS_DATA_HI_SHIFT 0
#define I40E_GLCM_LANCLSDATAHI_CLS_DATA_HI_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANCLSDATAHI_CLS_DATA_HI_SHIFT)

#define I40E_GLCM_LANCLSDATALO                   0x0010C448 /* Reset: CORER */
#define I40E_GLCM_LANCLSDATALO_CLS_DATA_LO_SHIFT 0
#define I40E_GLCM_LANCLSDATALO_CLS_DATA_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANCLSDATALO_CLS_DATA_LO_SHIFT)

#define I40E_GLCM_LANCONFIG                            0x0010C430 /* Reset: CORER */
#define I40E_GLCM_LANCONFIG_GLOBAL_LOCK_MODE_SHIFT     1
#define I40E_GLCM_LANCONFIG_GLOBAL_LOCK_MODE_MASK      I40E_MASK(0x1, I40E_GLCM_LANCONFIG_GLOBAL_LOCK_MODE_SHIFT)
#define I40E_GLCM_LANCONFIG_DISABLE_PACKET_COUNT_SHIFT 2
#define I40E_GLCM_LANCONFIG_DISABLE_PACKET_COUNT_MASK  I40E_MASK(0x1, I40E_GLCM_LANCONFIG_DISABLE_PACKET_COUNT_SHIFT)
#define I40E_GLCM_LANCONFIG_DISABLE_RESCHEDULE_SHIFT   3
#define I40E_GLCM_LANCONFIG_DISABLE_RESCHEDULE_MASK    I40E_MASK(0x1, I40E_GLCM_LANCONFIG_DISABLE_RESCHEDULE_SHIFT)
#define I40E_GLCM_LANCONFIG_ENABLE_CRC_SHIFT           4
#define I40E_GLCM_LANCONFIG_ENABLE_CRC_MASK            I40E_MASK(0x1, I40E_GLCM_LANCONFIG_ENABLE_CRC_SHIFT)
#define I40E_GLCM_LANCONFIG_CACHE_DEPTH_SHIFT          5
#define I40E_GLCM_LANCONFIG_CACHE_DEPTH_MASK           I40E_MASK(0x7, I40E_GLCM_LANCONFIG_CACHE_DEPTH_SHIFT)
#define I40E_GLCM_LANCONFIG_MAXFCOE_SHIFT              8
#define I40E_GLCM_LANCONFIG_MAXFCOE_MASK               I40E_MASK(0x3, I40E_GLCM_LANCONFIG_MAXFCOE_SHIFT)
#define I40E_GLCM_LANCONFIG_DBG_DPSEL_SHIFT            12
#define I40E_GLCM_LANCONFIG_DBG_DPSEL_MASK             I40E_MASK(0x3, I40E_GLCM_LANCONFIG_DBG_DPSEL_SHIFT)
#define I40E_GLCM_LANCONFIG_DBG_DWSEL_SHIFT            14
#define I40E_GLCM_LANCONFIG_DBG_DWSEL_MASK             I40E_MASK(0x3, I40E_GLCM_LANCONFIG_DBG_DWSEL_SHIFT)
#define I40E_GLCM_LANCONFIG_DBG_WRSEL_SHIFT            16
#define I40E_GLCM_LANCONFIG_DBG_WRSEL_MASK             I40E_MASK(0x1, I40E_GLCM_LANCONFIG_DBG_WRSEL_SHIFT)
#define I40E_GLCM_LANCONFIG_DBGMUX_SEL_LO_SHIFT        20
#define I40E_GLCM_LANCONFIG_DBGMUX_SEL_LO_MASK         I40E_MASK(0xF, I40E_GLCM_LANCONFIG_DBGMUX_SEL_LO_SHIFT)
#define I40E_GLCM_LANCONFIG_DBGMUX_SEL_HI_SHIFT        24
#define I40E_GLCM_LANCONFIG_DBGMUX_SEL_HI_MASK         I40E_MASK(0xF, I40E_GLCM_LANCONFIG_DBGMUX_SEL_HI_SHIFT)
#define I40E_GLCM_LANCONFIG_DBGMUX_EN_SHIFT            28
#define I40E_GLCM_LANCONFIG_DBGMUX_EN_MASK             I40E_MASK(0x1, I40E_GLCM_LANCONFIG_DBGMUX_EN_SHIFT)

#define I40E_GLCM_LANCRDTHR                   0x0010C41C /* Reset: CORER */
#define I40E_GLCM_LANCRDTHR_CMLANCRDTHR_SHIFT 0
#define I40E_GLCM_LANCRDTHR_CMLANCRDTHR_MASK  I40E_MASK(0x3FFF, I40E_GLCM_LANCRDTHR_CMLANCRDTHR_SHIFT)
#define I40E_GLCM_LANCRDTHR_CMLANTCBTHR_SHIFT 16
#define I40E_GLCM_LANCRDTHR_CMLANTCBTHR_MASK  I40E_MASK(0x7F, I40E_GLCM_LANCRDTHR_CMLANTCBTHR_SHIFT)

#define I40E_GLCM_LANCTXDGCTL                  0x0010C410 /* Reset: CORER */
#define I40E_GLCM_LANCTXDGCTL_QUEUE_NUM_SHIFT  0
#define I40E_GLCM_LANCTXDGCTL_QUEUE_NUM_MASK   I40E_MASK(0xFFF, I40E_GLCM_LANCTXDGCTL_QUEUE_NUM_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_SUB_LINE_SHIFT   12
#define I40E_GLCM_LANCTXDGCTL_SUB_LINE_MASK    I40E_MASK(0x7, I40E_GLCM_LANCTXDGCTL_SUB_LINE_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_QUEUE_TYPE_SHIFT 15
#define I40E_GLCM_LANCTXDGCTL_QUEUE_TYPE_MASK  I40E_MASK(0x3, I40E_GLCM_LANCTXDGCTL_QUEUE_TYPE_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_OP_CODE_SHIFT    17
#define I40E_GLCM_LANCTXDGCTL_OP_CODE_MASK     I40E_MASK(0x3, I40E_GLCM_LANCTXDGCTL_OP_CODE_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_PKTCNT_SHIFT     19
#define I40E_GLCM_LANCTXDGCTL_PKTCNT_MASK      I40E_MASK(0x3, I40E_GLCM_LANCTXDGCTL_PKTCNT_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_INVALIDATE_SHIFT 21
#define I40E_GLCM_LANCTXDGCTL_INVALIDATE_MASK  I40E_MASK(0x1, I40E_GLCM_LANCTXDGCTL_INVALIDATE_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_WRITEBACK_SHIFT  22
#define I40E_GLCM_LANCTXDGCTL_WRITEBACK_MASK   I40E_MASK(0x1, I40E_GLCM_LANCTXDGCTL_WRITEBACK_SHIFT)
#define I40E_GLCM_LANCTXDGCTL_ALLOCATE_SHIFT   23
#define I40E_GLCM_LANCTXDGCTL_ALLOCATE_MASK    I40E_MASK(0x1, I40E_GLCM_LANCTXDGCTL_ALLOCATE_SHIFT)

#define I40E_GLCM_LANCTXDGDATA(_i)        (0x0010C400 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLCM_LANCTXDGDATA_MAX_INDEX  3
#define I40E_GLCM_LANCTXDGDATA_DATA_SHIFT 0
#define I40E_GLCM_LANCTXDGDATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANCTXDGDATA_DATA_SHIFT)

#define I40E_GLCM_LANCTXDGFN                  0x0010C418 /* Reset: CORER */
#define I40E_GLCM_LANCTXDGFN_PF_NUM_SHIFT     0
#define I40E_GLCM_LANCTXDGFN_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLCM_LANCTXDGFN_PF_NUM_SHIFT)
#define I40E_GLCM_LANCTXDGFN_VM_VF_NUM_SHIFT  4
#define I40E_GLCM_LANCTXDGFN_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLCM_LANCTXDGFN_VM_VF_NUM_SHIFT)
#define I40E_GLCM_LANCTXDGFN_VM_VF_TYPE_SHIFT 16
#define I40E_GLCM_LANCTXDGFN_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLCM_LANCTXDGFN_VM_VF_TYPE_SHIFT)

#define I40E_GLCM_LANCTXDGSTAT                0x0010C414 /* Reset: CORER */
#define I40E_GLCM_LANCTXDGSTAT_CTX_DONE_SHIFT 0
#define I40E_GLCM_LANCTXDGSTAT_CTX_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LANCTXDGSTAT_CTX_DONE_SHIFT)
#define I40E_GLCM_LANCTXDGSTAT_CTX_MISS_SHIFT 1
#define I40E_GLCM_LANCTXDGSTAT_CTX_MISS_MASK  I40E_MASK(0x1, I40E_GLCM_LANCTXDGSTAT_CTX_MISS_SHIFT)

#define I40E_GLCM_LANDATAREQHI                      0x0010C478 /* Reset: CORER */
#define I40E_GLCM_LANDATAREQHI_CMLANDATAREQHI_SHIFT 0
#define I40E_GLCM_LANDATAREQHI_CMLANDATAREQHI_MASK  I40E_MASK(0xFFFFFF, I40E_GLCM_LANDATAREQHI_CMLANDATAREQHI_SHIFT)

#define I40E_GLCM_LANDATAREQLOW                       0x0010C474 /* Reset: CORER */
#define I40E_GLCM_LANDATAREQLOW_CMLANDATAREQLOW_SHIFT 0
#define I40E_GLCM_LANDATAREQLOW_CMLANDATAREQLOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANDATAREQLOW_CMLANDATAREQLOW_SHIFT)

#define I40E_GLCM_LANDATASTALLHI                        0x0010C480 /* Reset: CORER */
#define I40E_GLCM_LANDATASTALLHI_CMLANDATASTALLHI_SHIFT 0
#define I40E_GLCM_LANDATASTALLHI_CMLANDATASTALLHI_MASK  I40E_MASK(0xFFFFFF, I40E_GLCM_LANDATASTALLHI_CMLANDATASTALLHI_SHIFT)

#define I40E_GLCM_LANDATASTALLLO                         0x0010C47C /* Reset: CORER */
#define I40E_GLCM_LANDATASTALLLO_CMLANDATASTALLLOW_SHIFT 0
#define I40E_GLCM_LANDATASTALLLO_CMLANDATASTALLLOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANDATASTALLLO_CMLANDATASTALLLOW_SHIFT)

#define I40E_GLCM_LANLOCKTBLADDR                    0x0010C458 /* Reset: CORER */
#define I40E_GLCM_LANLOCKTBLADDR_LOCKTBL_ADDR_SHIFT 0
#define I40E_GLCM_LANLOCKTBLADDR_LOCKTBL_ADDR_MASK  I40E_MASK(0xF, I40E_GLCM_LANLOCKTBLADDR_LOCKTBL_ADDR_SHIFT)

#define I40E_GLCM_LANLOCKTBLDATAHI                 0x0010C460 /* Reset: CORER */
#define I40E_GLCM_LANLOCKTBLDATAHI_LOCKSEL_SHIFT   0
#define I40E_GLCM_LANLOCKTBLDATAHI_LOCKSEL_MASK    I40E_MASK(0xFF, I40E_GLCM_LANLOCKTBLDATAHI_LOCKSEL_SHIFT)
#define I40E_GLCM_LANLOCKTBLDATAHI_GPLOCKSEL_SHIFT 8
#define I40E_GLCM_LANLOCKTBLDATAHI_GPLOCKSEL_MASK  I40E_MASK(0xF, I40E_GLCM_LANLOCKTBLDATAHI_GPLOCKSEL_SHIFT)

#define I40E_GLCM_LANLOCKTBLDATALO                  0x0010C45C /* Reset: CORER */
#define I40E_GLCM_LANLOCKTBLDATALO_QNUM_SHIFT       0
#define I40E_GLCM_LANLOCKTBLDATALO_QNUM_MASK        I40E_MASK(0xFFF, I40E_GLCM_LANLOCKTBLDATALO_QNUM_SHIFT)
#define I40E_GLCM_LANLOCKTBLDATALO_PF_NUM_SHIFT     12
#define I40E_GLCM_LANLOCKTBLDATALO_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLCM_LANLOCKTBLDATALO_PF_NUM_SHIFT)
#define I40E_GLCM_LANLOCKTBLDATALO_VM_VF_NUM_SHIFT  16
#define I40E_GLCM_LANLOCKTBLDATALO_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLCM_LANLOCKTBLDATALO_VM_VF_NUM_SHIFT)
#define I40E_GLCM_LANLOCKTBLDATALO_VM_VF_TYPE_SHIFT 25
#define I40E_GLCM_LANLOCKTBLDATALO_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLCM_LANLOCKTBLDATALO_VM_VF_TYPE_SHIFT)

#define I40E_GLCM_LANMISSREQHI                      0x0010C488 /* Reset: CORER */
#define I40E_GLCM_LANMISSREQHI_CMLANMISSREQHI_SHIFT 0
#define I40E_GLCM_LANMISSREQHI_CMLANMISSREQHI_MASK  I40E_MASK(0xFFFFFF, I40E_GLCM_LANMISSREQHI_CMLANMISSREQHI_SHIFT)

#define I40E_GLCM_LANMISSREQLO                       0x0010C484 /* Reset: CORER */
#define I40E_GLCM_LANMISSREQLO_CMLANMISSREQLOW_SHIFT 0
#define I40E_GLCM_LANMISSREQLO_CMLANMISSREQLOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANMISSREQLO_CMLANMISSREQLOW_SHIFT)

#define I40E_GLCM_LANPKTCNTADDR                   0x0010C450 /* Reset: CORER */
#define I40E_GLCM_LANPKTCNTADDR_PKTCNT_ADDR_SHIFT 0
#define I40E_GLCM_LANPKTCNTADDR_PKTCNT_ADDR_MASK  I40E_MASK(0x1FF, I40E_GLCM_LANPKTCNTADDR_PKTCNT_ADDR_SHIFT)

#define I40E_GLCM_LANPKTCNTDATA               0x0010C454 /* Reset: CORER */
#define I40E_GLCM_LANPKTCNTDATA_DONE_SHIFT    0
#define I40E_GLCM_LANPKTCNTDATA_DONE_MASK     I40E_MASK(0x1, I40E_GLCM_LANPKTCNTDATA_DONE_SHIFT)
#define I40E_GLCM_LANPKTCNTDATA_PKTCNT_SHIFT  1
#define I40E_GLCM_LANPKTCNTDATA_PKTCNT_MASK   I40E_MASK(0x7FF, I40E_GLCM_LANPKTCNTDATA_PKTCNT_SHIFT)
#define I40E_GLCM_LANPKTCNTDATA_RLSTATE_SHIFT 12
#define I40E_GLCM_LANPKTCNTDATA_RLSTATE_MASK  I40E_MASK(0x3, I40E_GLCM_LANPKTCNTDATA_RLSTATE_SHIFT)

#define I40E_GLCM_LANRLADDR               0x0010C43C /* Reset: CORER */
#define I40E_GLCM_LANRLADDR_RL_ADDR_SHIFT 0
#define I40E_GLCM_LANRLADDR_RL_ADDR_MASK  I40E_MASK(0xFFF, I40E_GLCM_LANRLADDR_RL_ADDR_SHIFT)

#define I40E_GLCM_LANRLDATA               0x0010C440 /* Reset: CORER */
#define I40E_GLCM_LANRLDATA_RL_DATA_SHIFT 0
#define I40E_GLCM_LANRLDATA_RL_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANRLDATA_RL_DATA_SHIFT)

#define I40E_GLCM_LANRLQUERY(_i)           (0x0010C420 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLCM_LANRLQUERY_MAX_INDEX     1
#define I40E_GLCM_LANRLQUERY_RLINDEX_SHIFT 0
#define I40E_GLCM_LANRLQUERY_RLINDEX_MASK  I40E_MASK(0x3FF, I40E_GLCM_LANRLQUERY_RLINDEX_SHIFT)

#define I40E_GLCM_LANRLSTAT(_i)              (0x0010C428 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLCM_LANRLSTAT_MAX_INDEX        1
#define I40E_GLCM_LANRLSTAT_QUERY_DONE_SHIFT 0
#define I40E_GLCM_LANRLSTAT_QUERY_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LANRLSTAT_QUERY_DONE_SHIFT)
#define I40E_GLCM_LANRLSTAT_RL_EMPTY_SHIFT   1
#define I40E_GLCM_LANRLSTAT_RL_EMPTY_MASK    I40E_MASK(0x1, I40E_GLCM_LANRLSTAT_RL_EMPTY_SHIFT)

#define I40E_GLCM_LANSNOOPREQHI                       0x0010C468 /* Reset: CORER */
#define I40E_GLCM_LANSNOOPREQHI_CMLANSNOOPREQHI_SHIFT 0
#define I40E_GLCM_LANSNOOPREQHI_CMLANSNOOPREQHI_MASK  I40E_MASK(0xFFFFFF, I40E_GLCM_LANSNOOPREQHI_CMLANSNOOPREQHI_SHIFT)

#define I40E_GLCM_LANSNOOPREQLO                        0x0010C464 /* Reset: CORER */
#define I40E_GLCM_LANSNOOPREQLO_CMLANSNOOPREQLOW_SHIFT 0
#define I40E_GLCM_LANSNOOPREQLO_CMLANSNOOPREQLOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANSNOOPREQLO_CMLANSNOOPREQLOW_SHIFT)

#define I40E_GLCM_LANSNOOPSTALLHI                         0x0010C470 /* Reset: CORER */
#define I40E_GLCM_LANSNOOPSTALLHI_CMLANSNOOPSTALLHI_SHIFT 0
#define I40E_GLCM_LANSNOOPSTALLHI_CMLANSNOOPSTALLHI_MASK  I40E_MASK(0xFFFFFF, I40E_GLCM_LANSNOOPSTALLHI_CMLANSNOOPSTALLHI_SHIFT)

#define I40E_GLCM_LANSNOOPSTALLLO                          0x0010C46C /* Reset: CORER */
#define I40E_GLCM_LANSNOOPSTALLLO_CMLANSNOOPSTALLLOW_SHIFT 0
#define I40E_GLCM_LANSNOOPSTALLLO_CMLANSNOOPSTALLLOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLCM_LANSNOOPSTALLLO_CMLANSNOOPSTALLLOW_SHIFT)

/* PF - DCB Registers  */

#define I40E_GLDCB_PACER                 0x000A2210 /* Reset: CORER */
#define I40E_GLDCB_PACER_PACER_VAL_SHIFT 0
#define I40E_GLDCB_PACER_PACER_VAL_MASK  I40E_MASK(0x3FFFFFF, I40E_GLDCB_PACER_PACER_VAL_SHIFT)
#define I40E_GLDCB_PACER_PACER_EN_SHIFT  31
#define I40E_GLDCB_PACER_PACER_EN_MASK   I40E_MASK(0x1, I40E_GLDCB_PACER_PACER_EN_SHIFT)

#define I40E_GLDCB_PCI_DATA                   0x000A0150 /* Reset: CORER */
#define I40E_GLDCB_PCI_DATA_PCI_DATA_BC_SHIFT 0
#define I40E_GLDCB_PCI_DATA_PCI_DATA_BC_MASK  I40E_MASK(0xFFFFF, I40E_GLDCB_PCI_DATA_PCI_DATA_BC_SHIFT)

#define I40E_GLDCB_RLLPC                 0x0005105C /* Reset: CORER */
#define I40E_GLDCB_RLLPC_LLMAXPCNT_SHIFT 0
#define I40E_GLDCB_RLLPC_LLMAXPCNT_MASK  I40E_MASK(0xFFFF, I40E_GLDCB_RLLPC_LLMAXPCNT_SHIFT)
#define I40E_GLDCB_RLLPC_BMAXPCNT_SHIFT  16
#define I40E_GLDCB_RLLPC_BMAXPCNT_MASK   I40E_MASK(0xFFFF, I40E_GLDCB_RLLPC_BMAXPCNT_SHIFT)

#define I40E_GLDCB_RLLPSB             0x00051054 /* Reset: CORER */
#define I40E_GLDCB_RLLPSB_BPCNT_SHIFT 0
#define I40E_GLDCB_RLLPSB_BPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_GLDCB_RLLPSB_BPCNT_SHIFT)

#define I40E_GLDCB_RLLPSLL              0x00051058 /* Reset: CORER */
#define I40E_GLDCB_RLLPSLL_LLPCNT_SHIFT 0
#define I40E_GLDCB_RLLPSLL_LLPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_GLDCB_RLLPSLL_LLPCNT_SHIFT)

#define I40E_GLDCB_RMPMC                       0x00122610 /* Reset: CORER */
#define I40E_GLDCB_RMPMC_RSPM_SHIFT            0
#define I40E_GLDCB_RMPMC_RSPM_MASK             I40E_MASK(0x3F, I40E_GLDCB_RMPMC_RSPM_SHIFT)
#define I40E_GLDCB_RMPMC_MIQ_NODROP_MODE_SHIFT 6
#define I40E_GLDCB_RMPMC_MIQ_NODROP_MODE_MASK  I40E_MASK(0x1F, I40E_GLDCB_RMPMC_MIQ_NODROP_MODE_SHIFT)
#define I40E_GLDCB_RMPMC_RPM_DIS_SHIFT         31
#define I40E_GLDCB_RMPMC_RPM_DIS_MASK          I40E_MASK(0x1, I40E_GLDCB_RMPMC_RPM_DIS_SHIFT)

#define I40E_GLDCB_RMPMS            0x00122614 /* Reset: CORER */
#define I40E_GLDCB_RMPMS_RMPM_SHIFT 0
#define I40E_GLDCB_RMPMS_RMPM_MASK  I40E_MASK(0xFFFF, I40E_GLDCB_RMPMS_RMPM_SHIFT)

#define I40E_GLDCB_RPRRD0                   0x00122608 /* Reset: CORER */
#define I40E_GLDCB_RPRRD0_BWSHARE_40G_SHIFT 0
#define I40E_GLDCB_RPRRD0_BWSHARE_40G_MASK  I40E_MASK(0x3FF, I40E_GLDCB_RPRRD0_BWSHARE_40G_SHIFT)
#define I40E_GLDCB_RPRRD0_BWSHARE_10G_SHIFT 16
#define I40E_GLDCB_RPRRD0_BWSHARE_10G_MASK  I40E_MASK(0x3FF, I40E_GLDCB_RPRRD0_BWSHARE_10G_SHIFT)

#define I40E_GLDCB_RPRRD1                    0x0012260C /* Reset: CORER */
#define I40E_GLDCB_RPRRD1_BWSHARE_1G_SHIFT   0
#define I40E_GLDCB_RPRRD1_BWSHARE_1G_MASK    I40E_MASK(0x3FF, I40E_GLDCB_RPRRD1_BWSHARE_1G_SHIFT)
#define I40E_GLDCB_RPRRD1_BWSHARE_100M_SHIFT 16
#define I40E_GLDCB_RPRRD1_BWSHARE_100M_MASK  I40E_MASK(0x3FF, I40E_GLDCB_RPRRD1_BWSHARE_100M_SHIFT)

#define I40E_GLDCB_RSPMC                   0x00122604 /* Reset: CORER */
#define I40E_GLDCB_RSPMC_RSPM_SHIFT        0
#define I40E_GLDCB_RSPMC_RSPM_MASK         I40E_MASK(0xFF, I40E_GLDCB_RSPMC_RSPM_SHIFT)
#define I40E_GLDCB_RSPMC_RPM_MODE_SHIFT    8
#define I40E_GLDCB_RSPMC_RPM_MODE_MASK     I40E_MASK(0x3, I40E_GLDCB_RSPMC_RPM_MODE_SHIFT)
#define I40E_GLDCB_RSPMC_PRR_MAX_EXP_SHIFT 10
#define I40E_GLDCB_RSPMC_PRR_MAX_EXP_MASK  I40E_MASK(0xF, I40E_GLDCB_RSPMC_PRR_MAX_EXP_SHIFT)
#define I40E_GLDCB_RSPMC_PFCTIMER_SHIFT    14
#define I40E_GLDCB_RSPMC_PFCTIMER_MASK     I40E_MASK(0x3FFF, I40E_GLDCB_RSPMC_PFCTIMER_SHIFT)
#define I40E_GLDCB_RSPMC_RPM_DIS_SHIFT     31
#define I40E_GLDCB_RSPMC_RPM_DIS_MASK      I40E_MASK(0x1, I40E_GLDCB_RSPMC_RPM_DIS_SHIFT)

#define I40E_GLDCB_RSPMS            0x00122600 /* Reset: CORER */
#define I40E_GLDCB_RSPMS_RSPM_SHIFT 0
#define I40E_GLDCB_RSPMS_RSPM_MASK  I40E_MASK(0x3FFFF, I40E_GLDCB_RSPMS_RSPM_SHIFT)

#define I40E_GLDCB_TFPFCI                 0x00098080 /* Reset: CORER */
#define I40E_GLDCB_TFPFCI_IGNORE_FC_SHIFT 0
#define I40E_GLDCB_TFPFCI_IGNORE_FC_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLDCB_TFPFCI_IGNORE_FC_SHIFT)

#define I40E_GLDCB_TGENC_TLPM                         0x000A01C0 /* Reset: CORER */
#define I40E_GLDCB_TGENC_TLPM_ALLOFFTH_SHIFT          0
#define I40E_GLDCB_TGENC_TLPM_ALLOFFTH_MASK           I40E_MASK(0xFF, I40E_GLDCB_TGENC_TLPM_ALLOFFTH_SHIFT)
#define I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_SHIFT    8
#define I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_MASK     I40E_MASK(0xFF, I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_SHIFT)
#define I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_EN_SHIFT 29
#define I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_EN_MASK  I40E_MASK(0x1, I40E_GLDCB_TGENC_TLPM_SHARED_TDATATH_EN_SHIFT)
#define I40E_GLDCB_TGENC_TLPM_TFPM_DIS_SHIFT          30
#define I40E_GLDCB_TGENC_TLPM_TFPM_DIS_MASK           I40E_MASK(0x1, I40E_GLDCB_TGENC_TLPM_TFPM_DIS_SHIFT)
#define I40E_GLDCB_TGENC_TLPM_FWLB_MODE_SHIFT         31
#define I40E_GLDCB_TGENC_TLPM_FWLB_MODE_MASK          I40E_MASK(0x1, I40E_GLDCB_TGENC_TLPM_FWLB_MODE_SHIFT)

#define I40E_GLDCB_TGENC_TUPM                 0x000A2200 /* Reset: CORER */
#define I40E_GLDCB_TGENC_TUPM_ALLOFFTH_SHIFT  0
#define I40E_GLDCB_TGENC_TUPM_ALLOFFTH_MASK   I40E_MASK(0x1FFF, I40E_GLDCB_TGENC_TUPM_ALLOFFTH_SHIFT)
#define I40E_GLDCB_TGENC_TUPM_TCPM_DIS_SHIFT  30
#define I40E_GLDCB_TGENC_TUPM_TCPM_DIS_MASK   I40E_MASK(0x1, I40E_GLDCB_TGENC_TUPM_TCPM_DIS_SHIFT)
#define I40E_GLDCB_TGENC_TUPM_CWLB_MODE_SHIFT 31
#define I40E_GLDCB_TGENC_TUPM_CWLB_MODE_MASK  I40E_MASK(0x1, I40E_GLDCB_TGENC_TUPM_CWLB_MODE_SHIFT)

#define I40E_PRTDCB_FCAH             0x001E24C0 /* Reset: GLOBR */
#define I40E_PRTDCB_FCAH_PFCAH_SHIFT 0
#define I40E_PRTDCB_FCAH_PFCAH_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_FCAH_PFCAH_SHIFT)

#define I40E_PRTDCB_FCAL             0x001E24A0 /* Reset: GLOBR */
#define I40E_PRTDCB_FCAL_PFCAL_SHIFT 0
#define I40E_PRTDCB_FCAL_PFCAL_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTDCB_FCAL_PFCAL_SHIFT)

#define I40E_PRTDCB_RETSTCS(_i)           (0x001222A0 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTDCB_RETSTCS_MAX_INDEX     7
#define I40E_PRTDCB_RETSTCS_CREDITS_SHIFT 0
#define I40E_PRTDCB_RETSTCS_CREDITS_MASK  I40E_MASK(0x1FFFFFFF, I40E_PRTDCB_RETSTCS_CREDITS_SHIFT)

#define I40E_PRTDCB_RLANPMS               0x001223C0 /* Reset: CORER */
#define I40E_PRTDCB_RLANPMS_LANRPPM_SHIFT 0
#define I40E_PRTDCB_RLANPMS_LANRPPM_MASK  I40E_MASK(0x3FFFF, I40E_PRTDCB_RLANPMS_LANRPPM_SHIFT)

#define I40E_PRTDCB_RPFCTOP                 0x001E2480 /* Reset: GLOBR */
#define I40E_PRTDCB_RPFCTOP_PFCTYPE_SHIFT   0
#define I40E_PRTDCB_RPFCTOP_PFCTYPE_MASK    I40E_MASK(0xFFFF, I40E_PRTDCB_RPFCTOP_PFCTYPE_SHIFT)
#define I40E_PRTDCB_RPFCTOP_PFCOPCODE_SHIFT 16
#define I40E_PRTDCB_RPFCTOP_PFCOPCODE_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_RPFCTOP_PFCOPCODE_SHIFT)

#define I40E_PRTDCB_RPRRC               0x00122100 /* Reset: CORER */
#define I40E_PRTDCB_RPRRC_BWSHARE_SHIFT 0
#define I40E_PRTDCB_RPRRC_BWSHARE_MASK  I40E_MASK(0x3FF, I40E_PRTDCB_RPRRC_BWSHARE_SHIFT)

#define I40E_PRTDCB_RPRRS               0x00122120 /* Reset: CORER */
#define I40E_PRTDCB_RPRRS_CREDITS_SHIFT 0
#define I40E_PRTDCB_RPRRS_CREDITS_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTDCB_RPRRS_CREDITS_SHIFT)

#define I40E_PRTDCB_RRDMAPMS                0x00122160 /* Reset: CORER */
#define I40E_PRTDCB_RRDMAPMS_RDMARPPM_SHIFT 0
#define I40E_PRTDCB_RRDMAPMS_RDMARPPM_MASK  I40E_MASK(0x3FFFF, I40E_PRTDCB_RRDMAPMS_RDMARPPM_SHIFT)

#define I40E_PRTDCB_RUP_PPRS                0x000844C0 /* Reset: CORER */
#define I40E_PRTDCB_RUP_PPRS_NOVLANUP_SHIFT 0
#define I40E_PRTDCB_RUP_PPRS_NOVLANUP_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP_PPRS_NOVLANUP_SHIFT)

#define I40E_PRTDCB_RUP_TDPU                0x00044120 /* Reset: CORER */
#define I40E_PRTDCB_RUP_TDPU_NOVLANUP_SHIFT 0
#define I40E_PRTDCB_RUP_TDPU_NOVLANUP_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP_TDPU_NOVLANUP_SHIFT)

#define I40E_PRTDCB_RUP2TC_RCB             0x00122280 /* Reset: CORER */
#define I40E_PRTDCB_RUP2TC_RCB_UP0TC_SHIFT 0
#define I40E_PRTDCB_RUP2TC_RCB_UP0TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP0TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP1TC_SHIFT 3
#define I40E_PRTDCB_RUP2TC_RCB_UP1TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP1TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP2TC_SHIFT 6
#define I40E_PRTDCB_RUP2TC_RCB_UP2TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP2TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP3TC_SHIFT 9
#define I40E_PRTDCB_RUP2TC_RCB_UP3TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP3TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP4TC_SHIFT 12
#define I40E_PRTDCB_RUP2TC_RCB_UP4TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP4TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP5TC_SHIFT 15
#define I40E_PRTDCB_RUP2TC_RCB_UP5TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP5TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP6TC_SHIFT 18
#define I40E_PRTDCB_RUP2TC_RCB_UP6TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP6TC_SHIFT)
#define I40E_PRTDCB_RUP2TC_RCB_UP7TC_SHIFT 21
#define I40E_PRTDCB_RUP2TC_RCB_UP7TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_RUP2TC_RCB_UP7TC_SHIFT)

#define I40E_PRTDCB_RUPTQ(_i)          (0x00122400 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTDCB_RUPTQ_MAX_INDEX    7
#define I40E_PRTDCB_RUPTQ_RXQNUM_SHIFT 0
#define I40E_PRTDCB_RUPTQ_RXQNUM_MASK  I40E_MASK(0x3FFF, I40E_PRTDCB_RUPTQ_RXQNUM_SHIFT)

#define I40E_PRTDCB_RUPTS(_i)            (0x00122500 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTDCB_RUPTS_MAX_INDEX      7
#define I40E_PRTDCB_RUPTS_PFCTIMER_SHIFT 0
#define I40E_PRTDCB_RUPTS_PFCTIMER_MASK  I40E_MASK(0x3FFF, I40E_PRTDCB_RUPTS_PFCTIMER_SHIFT)

#define I40E_PRTDCB_TC2PFC_RCB              0x00122140 /* Reset: CORER */
#define I40E_PRTDCB_TC2PFC_RCB_TC2PFC_SHIFT 0
#define I40E_PRTDCB_TC2PFC_RCB_TC2PFC_MASK  I40E_MASK(0xFF, I40E_PRTDCB_TC2PFC_RCB_TC2PFC_SHIFT)

#define I40E_PRTDCB_TCLLPC                 0x000AE000 /* Reset: CORER */
#define I40E_PRTDCB_TCLLPC_LLMAXPCNT_SHIFT 0
#define I40E_PRTDCB_TCLLPC_LLMAXPCNT_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_TCLLPC_LLMAXPCNT_SHIFT)
#define I40E_PRTDCB_TCLLPC_BMAXPCNT_SHIFT  16
#define I40E_PRTDCB_TCLLPC_BMAXPCNT_MASK   I40E_MASK(0xFFFF, I40E_PRTDCB_TCLLPC_BMAXPCNT_SHIFT)

#define I40E_PRTDCB_TCLLPSB             0x000AE020 /* Reset: CORER */
#define I40E_PRTDCB_TCLLPSB_BPCNT_SHIFT 0
#define I40E_PRTDCB_TCLLPSB_BPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_PRTDCB_TCLLPSB_BPCNT_SHIFT)

#define I40E_PRTDCB_TCLLPSLL              0x000AE040 /* Reset: CORER */
#define I40E_PRTDCB_TCLLPSLL_LLPCNT_SHIFT 0
#define I40E_PRTDCB_TCLLPSLL_LLPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_PRTDCB_TCLLPSLL_LLPCNT_SHIFT)

#define I40E_PRTDCB_TCPFCPC                 0x000A21C0 /* Reset: CORER */
#define I40E_PRTDCB_TCPFCPC_PORTOFFTH_SHIFT 0
#define I40E_PRTDCB_TCPFCPC_PORTOFFTH_MASK  I40E_MASK(0x1FFF, I40E_PRTDCB_TCPFCPC_PORTOFFTH_SHIFT)

#define I40E_PRTDCB_TCPFCTCC                    0x000A21E0 /* Reset: CORER */
#define I40E_PRTDCB_TCPFCTCC_TCOFFTH_SHIFT      0
#define I40E_PRTDCB_TCPFCTCC_TCOFFTH_MASK       I40E_MASK(0x1FFF, I40E_PRTDCB_TCPFCTCC_TCOFFTH_SHIFT)
#define I40E_PRTDCB_TCPFCTCC_LL_PRI_TRESH_SHIFT 13
#define I40E_PRTDCB_TCPFCTCC_LL_PRI_TRESH_MASK  I40E_MASK(0x1FFF, I40E_PRTDCB_TCPFCTCC_LL_PRI_TRESH_SHIFT)
#define I40E_PRTDCB_TCPFCTCC_LL_PRI_EN_SHIFT    31
#define I40E_PRTDCB_TCPFCTCC_LL_PRI_EN_MASK     I40E_MASK(0x1, I40E_PRTDCB_TCPFCTCC_LL_PRI_EN_SHIFT)

#define I40E_PRTDCB_TCWSP              0x000A2160 /* Reset: CORER */
#define I40E_PRTDCB_TCWSP_WSPORT_SHIFT 0
#define I40E_PRTDCB_TCWSP_WSPORT_MASK  I40E_MASK(0xFFFFF, I40E_PRTDCB_TCWSP_WSPORT_SHIFT)

#define I40E_PRTDCB_TDPMS           0x000A0000 /* Reset: CORER */
#define I40E_PRTDCB_TDPMS_DPM_SHIFT 0
#define I40E_PRTDCB_TDPMS_DPM_MASK  I40E_MASK(0xFFFFF, I40E_PRTDCB_TDPMS_DPM_SHIFT)

#define I40E_PRTDCB_TDPUC                   0x00044100 /* Reset: CORER */
#define I40E_PRTDCB_TDPUC_MAX_TXFRAME_SHIFT 0
#define I40E_PRTDCB_TDPUC_MAX_TXFRAME_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_TDPUC_MAX_TXFRAME_SHIFT)
#define I40E_PRTDCB_TDPUC_MAL_LENGTH_SHIFT  16
#define I40E_PRTDCB_TDPUC_MAL_LENGTH_MASK   I40E_MASK(0x1, I40E_PRTDCB_TDPUC_MAL_LENGTH_SHIFT)
#define I40E_PRTDCB_TDPUC_MAL_CMD_SHIFT     17
#define I40E_PRTDCB_TDPUC_MAL_CMD_MASK      I40E_MASK(0x1, I40E_PRTDCB_TDPUC_MAL_CMD_SHIFT)
#define I40E_PRTDCB_TDPUC_TTL_DROP_SHIFT    18
#define I40E_PRTDCB_TDPUC_TTL_DROP_MASK     I40E_MASK(0x1, I40E_PRTDCB_TDPUC_TTL_DROP_SHIFT)
#define I40E_PRTDCB_TDPUC_UR_DROP_SHIFT     19
#define I40E_PRTDCB_TDPUC_UR_DROP_MASK      I40E_MASK(0x1, I40E_PRTDCB_TDPUC_UR_DROP_SHIFT)
#define I40E_PRTDCB_TDPUC_CLEAR_DROP_SHIFT  31
#define I40E_PRTDCB_TDPUC_CLEAR_DROP_MASK   I40E_MASK(0x1, I40E_PRTDCB_TDPUC_CLEAR_DROP_SHIFT)

#define I40E_PRTDCB_TFLLPC                 0x00098000 /* Reset: CORER */
#define I40E_PRTDCB_TFLLPC_LLMAXPCNT_SHIFT 0
#define I40E_PRTDCB_TFLLPC_LLMAXPCNT_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_TFLLPC_LLMAXPCNT_SHIFT)
#define I40E_PRTDCB_TFLLPC_BMAXPCNT_SHIFT  16
#define I40E_PRTDCB_TFLLPC_BMAXPCNT_MASK   I40E_MASK(0xFFFF, I40E_PRTDCB_TFLLPC_BMAXPCNT_SHIFT)

#define I40E_PRTDCB_TFLLPSB             0x00098020 /* Reset: CORER */
#define I40E_PRTDCB_TFLLPSB_BPCNT_SHIFT 0
#define I40E_PRTDCB_TFLLPSB_BPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_PRTDCB_TFLLPSB_BPCNT_SHIFT)

#define I40E_PRTDCB_TFLLPSLL              0x00098040 /* Reset: CORER */
#define I40E_PRTDCB_TFLLPSLL_LLPCNT_SHIFT 0
#define I40E_PRTDCB_TFLLPSLL_LLPCNT_MASK  I40E_MASK(0x3FFFFFF, I40E_PRTDCB_TFLLPSLL_LLPCNT_SHIFT)

#define I40E_PRTDCB_TFPFCC                 0x000A01A0 /* Reset: CORER */
#define I40E_PRTDCB_TFPFCC_PORTOFFTH_SHIFT 0
#define I40E_PRTDCB_TFPFCC_PORTOFFTH_MASK  I40E_MASK(0xFF, I40E_PRTDCB_TFPFCC_PORTOFFTH_SHIFT)
#define I40E_PRTDCB_TFPFCC_TCOFFTH_SHIFT   8
#define I40E_PRTDCB_TFPFCC_TCOFFTH_MASK    I40E_MASK(0xFF, I40E_PRTDCB_TFPFCC_TCOFFTH_SHIFT)

#define I40E_PRTDCB_TFWSP              0x000A0140 /* Reset: CORER */
#define I40E_PRTDCB_TFWSP_WSPORT_SHIFT 0
#define I40E_PRTDCB_TFWSP_WSPORT_MASK  I40E_MASK(0xFFFFF, I40E_PRTDCB_TFWSP_WSPORT_SHIFT)

#define I40E_PRTDCB_TLANCPMS              0x000A2020 /* Reset: CORER */
#define I40E_PRTDCB_TLANCPMS_LANCPM_SHIFT 0
#define I40E_PRTDCB_TLANCPMS_LANCPM_MASK  I40E_MASK(0xFFFFF, I40E_PRTDCB_TLANCPMS_LANCPM_SHIFT)

#define I40E_PRTDCB_TLPMC              0x000A0160 /* Reset: CORER */
#define I40E_PRTDCB_TLPMC_TC2PFC_SHIFT 0
#define I40E_PRTDCB_TLPMC_TC2PFC_MASK  I40E_MASK(0xFF, I40E_PRTDCB_TLPMC_TC2PFC_SHIFT)

#define I40E_PRTDCB_TPFCTOP                 0x001E4540 /* Reset: GLOBR */
#define I40E_PRTDCB_TPFCTOP_PFCTYPE_SHIFT   0
#define I40E_PRTDCB_TPFCTOP_PFCTYPE_MASK    I40E_MASK(0xFFFF, I40E_PRTDCB_TPFCTOP_PFCTYPE_SHIFT)
#define I40E_PRTDCB_TPFCTOP_PFCOPCODE_SHIFT 16
#define I40E_PRTDCB_TPFCTOP_PFCOPCODE_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_TPFCTOP_PFCOPCODE_SHIFT)

#define I40E_PRTDCB_TRDMACPMS               0x000A2000 /* Reset: CORER */
#define I40E_PRTDCB_TRDMACPMS_RDMACPM_SHIFT 0
#define I40E_PRTDCB_TRDMACPMS_RDMACPM_MASK  I40E_MASK(0xFFFFF, I40E_PRTDCB_TRDMACPMS_RDMACPM_SHIFT)

#define I40E_PRTDCB_TUP2TC             0x001E4620 /* Reset: GLOBR */
#define I40E_PRTDCB_TUP2TC_UP0TC_SHIFT 0
#define I40E_PRTDCB_TUP2TC_UP0TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP0TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP1TC_SHIFT 3
#define I40E_PRTDCB_TUP2TC_UP1TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP1TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP2TC_SHIFT 6
#define I40E_PRTDCB_TUP2TC_UP2TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP2TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP3TC_SHIFT 9
#define I40E_PRTDCB_TUP2TC_UP3TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP3TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP4TC_SHIFT 12
#define I40E_PRTDCB_TUP2TC_UP4TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP4TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP5TC_SHIFT 15
#define I40E_PRTDCB_TUP2TC_UP5TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP5TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP6TC_SHIFT 18
#define I40E_PRTDCB_TUP2TC_UP6TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP6TC_SHIFT)
#define I40E_PRTDCB_TUP2TC_UP7TC_SHIFT 21
#define I40E_PRTDCB_TUP2TC_UP7TC_MASK  I40E_MASK(0x7, I40E_PRTDCB_TUP2TC_UP7TC_SHIFT)

#define I40E_PRTDCB_TUPMC              0x000A2140 /* Reset: CORER */
#define I40E_PRTDCB_TUPMC_TC2PFC_SHIFT 0
#define I40E_PRTDCB_TUPMC_TC2PFC_MASK  I40E_MASK(0xFF, I40E_PRTDCB_TUPMC_TC2PFC_SHIFT)

/* PF - FCoE Registers  */

#define I40E_GLFCOE_ENA                0x001C0A28 /* Reset: CORER */
#define I40E_GLFCOE_ENA_FCOE_ENA_SHIFT 0
#define I40E_GLFCOE_ENA_FCOE_ENA_MASK  I40E_MASK(0x1, I40E_GLFCOE_ENA_FCOE_ENA_SHIFT)

#define I40E_GLFCOE_ENA_TDPU                0x000442E4 /* Reset: CORER */
#define I40E_GLFCOE_ENA_TDPU_FCOE_ENA_SHIFT 0
#define I40E_GLFCOE_ENA_TDPU_FCOE_ENA_MASK  I40E_MASK(0x1, I40E_GLFCOE_ENA_TDPU_FCOE_ENA_SHIFT)

#define I40E_GLFCOE_ENA_TLAN                0x000E6484 /* Reset: CORER */
#define I40E_GLFCOE_ENA_TLAN_FCOE_ENA_SHIFT 0
#define I40E_GLFCOE_ENA_TLAN_FCOE_ENA_MASK  I40E_MASK(0x1, I40E_GLFCOE_ENA_TLAN_FCOE_ENA_SHIFT)

#define I40E_GLFCOE_RLANCTL                0x0012A508 /* Reset: CORER */
#define I40E_GLFCOE_RLANCTL_FRSTDDPH_SHIFT 1
#define I40E_GLFCOE_RLANCTL_FRSTDDPH_MASK  I40E_MASK(0x1, I40E_GLFCOE_RLANCTL_FRSTDDPH_SHIFT)
#define I40E_GLFCOE_RLANCTL_ALLH_SHIFT     3
#define I40E_GLFCOE_RLANCTL_ALLH_MASK      I40E_MASK(0x1, I40E_GLFCOE_RLANCTL_ALLH_SHIFT)

#define I40E_GLFCOE_RSOF              0x00269B9C /* Reset: CORER */
#define I40E_GLFCOE_RSOF_SOF_I2_SHIFT 0
#define I40E_GLFCOE_RSOF_SOF_I2_MASK  I40E_MASK(0xFF, I40E_GLFCOE_RSOF_SOF_I2_SHIFT)
#define I40E_GLFCOE_RSOF_SOF_I3_SHIFT 8
#define I40E_GLFCOE_RSOF_SOF_I3_MASK  I40E_MASK(0xFF, I40E_GLFCOE_RSOF_SOF_I3_SHIFT)
#define I40E_GLFCOE_RSOF_SOF_N2_SHIFT 16
#define I40E_GLFCOE_RSOF_SOF_N2_MASK  I40E_MASK(0xFF, I40E_GLFCOE_RSOF_SOF_N2_SHIFT)
#define I40E_GLFCOE_RSOF_SOF_N3_SHIFT 24
#define I40E_GLFCOE_RSOF_SOF_N3_MASK  I40E_MASK(0xFF, I40E_GLFCOE_RSOF_SOF_N3_SHIFT)

#define I40E_GLFCOE_TEOF              0x000442EC /* Reset: CORER */
#define I40E_GLFCOE_TEOF_EOF_N_SHIFT  0
#define I40E_GLFCOE_TEOF_EOF_N_MASK   I40E_MASK(0xFF, I40E_GLFCOE_TEOF_EOF_N_SHIFT)
#define I40E_GLFCOE_TEOF_EOF_T_SHIFT  8
#define I40E_GLFCOE_TEOF_EOF_T_MASK   I40E_MASK(0xFF, I40E_GLFCOE_TEOF_EOF_T_SHIFT)
#define I40E_GLFCOE_TEOF_EOF_NI_SHIFT 16
#define I40E_GLFCOE_TEOF_EOF_NI_MASK  I40E_MASK(0xFF, I40E_GLFCOE_TEOF_EOF_NI_SHIFT)
#define I40E_GLFCOE_TEOF_EOF_A_SHIFT  24
#define I40E_GLFCOE_TEOF_EOF_A_MASK   I40E_MASK(0xFF, I40E_GLFCOE_TEOF_EOF_A_SHIFT)

#define I40E_GLFCOE_TSOF              0x000442E8 /* Reset: CORER */
#define I40E_GLFCOE_TSOF_SOF_I2_SHIFT 0
#define I40E_GLFCOE_TSOF_SOF_I2_MASK  I40E_MASK(0xFF, I40E_GLFCOE_TSOF_SOF_I2_SHIFT)
#define I40E_GLFCOE_TSOF_SOF_I3_SHIFT 8
#define I40E_GLFCOE_TSOF_SOF_I3_MASK  I40E_MASK(0xFF, I40E_GLFCOE_TSOF_SOF_I3_SHIFT)
#define I40E_GLFCOE_TSOF_SOF_N2_SHIFT 16
#define I40E_GLFCOE_TSOF_SOF_N2_MASK  I40E_MASK(0xFF, I40E_GLFCOE_TSOF_SOF_N2_SHIFT)
#define I40E_GLFCOE_TSOF_SOF_N3_SHIFT 24
#define I40E_GLFCOE_TSOF_SOF_N3_MASK  I40E_MASK(0xFF, I40E_GLFCOE_TSOF_SOF_N3_SHIFT)

#define I40E_PRTFCOE_REOF              0x000856A0 /* Reset: CORER */
#define I40E_PRTFCOE_REOF_EOF_N_SHIFT  0
#define I40E_PRTFCOE_REOF_EOF_N_MASK   I40E_MASK(0xFF, I40E_PRTFCOE_REOF_EOF_N_SHIFT)
#define I40E_PRTFCOE_REOF_EOF_T_SHIFT  8
#define I40E_PRTFCOE_REOF_EOF_T_MASK   I40E_MASK(0xFF, I40E_PRTFCOE_REOF_EOF_T_SHIFT)
#define I40E_PRTFCOE_REOF_EOF_NI_SHIFT 16
#define I40E_PRTFCOE_REOF_EOF_NI_MASK  I40E_MASK(0xFF, I40E_PRTFCOE_REOF_EOF_NI_SHIFT)
#define I40E_PRTFCOE_REOF_EOF_A_SHIFT  24
#define I40E_PRTFCOE_REOF_EOF_A_MASK   I40E_MASK(0xFF, I40E_PRTFCOE_REOF_EOF_A_SHIFT)

/* PF - General Registers  */

#define I40E_ECC_ENA               0x00092630 /* Reset: CORER */
#define I40E_ECC_ENA_ECC_ENA_SHIFT 0
#define I40E_ECC_ENA_ECC_ENA_MASK  I40E_MASK(0x1, I40E_ECC_ENA_ECC_ENA_SHIFT)

#define I40E_GLGEN_CSR_DEBUG_C                     0x00078E8C /* Reset: POR */
#define I40E_GLGEN_CSR_DEBUG_C_CSR_ACCESS_EN_SHIFT 0
#define I40E_GLGEN_CSR_DEBUG_C_CSR_ACCESS_EN_MASK  I40E_MASK(0x1, I40E_GLGEN_CSR_DEBUG_C_CSR_ACCESS_EN_SHIFT)
#define I40E_GLGEN_CSR_DEBUG_C_CSR_ADDR_PROT_SHIFT 1
#define I40E_GLGEN_CSR_DEBUG_C_CSR_ADDR_PROT_MASK  I40E_MASK(0x1, I40E_GLGEN_CSR_DEBUG_C_CSR_ADDR_PROT_SHIFT)

#define I40E_GLGEN_CSR_DEBUG_F                   0x000B6138 /* Reset: POR */
#define I40E_GLGEN_CSR_DEBUG_F_CSR_PROT_EN_SHIFT 0
#define I40E_GLGEN_CSR_DEBUG_F_CSR_PROT_EN_MASK  I40E_MASK(0x1, I40E_GLGEN_CSR_DEBUG_F_CSR_PROT_EN_SHIFT)

#define I40E_GLGEN_DUAL40                     0x001C0A6C /* Reset: CORER */
#define I40E_GLGEN_DUAL40_DUAL_40G_MODE_SHIFT 0
#define I40E_GLGEN_DUAL40_DUAL_40G_MODE_MASK  I40E_MASK(0x1, I40E_GLGEN_DUAL40_DUAL_40G_MODE_SHIFT)

#define I40E_GLGEN_DUAL40_RPB                     0x000AC7E0 /* Reset: CORER */
#define I40E_GLGEN_DUAL40_RPB_DUAL_40G_MODE_SHIFT 0
#define I40E_GLGEN_DUAL40_RPB_DUAL_40G_MODE_MASK  I40E_MASK(0x1, I40E_GLGEN_DUAL40_RPB_DUAL_40G_MODE_SHIFT)

#define I40E_GLGEN_DUAL40_TLPM                     0x000A01C4 /* Reset: CORER */
#define I40E_GLGEN_DUAL40_TLPM_DUAL_40G_MODE_SHIFT 0
#define I40E_GLGEN_DUAL40_TLPM_DUAL_40G_MODE_MASK  I40E_MASK(0x1, I40E_GLGEN_DUAL40_TLPM_DUAL_40G_MODE_SHIFT)

#define I40E_GLGEN_DUAL40_TUPM                     0x000A2204 /* Reset: CORER */
#define I40E_GLGEN_DUAL40_TUPM_DUAL_40G_MODE_SHIFT 0
#define I40E_GLGEN_DUAL40_TUPM_DUAL_40G_MODE_MASK  I40E_MASK(0x1, I40E_GLGEN_DUAL40_TUPM_DUAL_40G_MODE_SHIFT)

#define I40E_GLGEN_FWHWRCTRL                       0x00092610 /* Reset: CORER */
#define I40E_GLGEN_FWHWRCTRL_PF_ENA_RST_DONE_SHIFT 0
#define I40E_GLGEN_FWHWRCTRL_PF_ENA_RST_DONE_MASK  I40E_MASK(0x1, I40E_GLGEN_FWHWRCTRL_PF_ENA_RST_DONE_SHIFT)
#define I40E_GLGEN_FWHWRCTRL_VF_ENA_RST_DONE_SHIFT 1
#define I40E_GLGEN_FWHWRCTRL_VF_ENA_RST_DONE_MASK  I40E_MASK(0x1, I40E_GLGEN_FWHWRCTRL_VF_ENA_RST_DONE_SHIFT)
#define I40E_GLGEN_FWHWRCTRL_VM_ENA_RST_DONE_SHIFT 2
#define I40E_GLGEN_FWHWRCTRL_VM_ENA_RST_DONE_MASK  I40E_MASK(0x1, I40E_GLGEN_FWHWRCTRL_VM_ENA_RST_DONE_SHIFT)
#define I40E_GLGEN_FWHWRCTRL_PE_CPL_EN_SHIFT       31
#define I40E_GLGEN_FWHWRCTRL_PE_CPL_EN_MASK        I40E_MASK(0x1, I40E_GLGEN_FWHWRCTRL_PE_CPL_EN_SHIFT)

#define I40E_GLGEN_IMRTRIG              0x000B8194 /* Reset: CORER */
#define I40E_GLGEN_IMRTRIG_CORER_SHIFT  0
#define I40E_GLGEN_IMRTRIG_CORER_MASK   I40E_MASK(0x1, I40E_GLGEN_IMRTRIG_CORER_SHIFT)
#define I40E_GLGEN_IMRTRIG_GLOBR_SHIFT  1
#define I40E_GLGEN_IMRTRIG_GLOBR_MASK   I40E_MASK(0x1, I40E_GLGEN_IMRTRIG_GLOBR_SHIFT)
#define I40E_GLGEN_IMRTRIG_EMPFWR_SHIFT 2
#define I40E_GLGEN_IMRTRIG_EMPFWR_MASK  I40E_MASK(0x1, I40E_GLGEN_IMRTRIG_EMPFWR_SHIFT)

#define I40E_GLGEN_MISC_CONFIG                              0x000B81A4 /* Reset: POR */
#define I40E_GLGEN_MISC_CONFIG_SINGLE_10G_PORT_SELECT_SHIFT 0
#define I40E_GLGEN_MISC_CONFIG_SINGLE_10G_PORT_SELECT_MASK  I40E_MASK(0x1, I40E_GLGEN_MISC_CONFIG_SINGLE_10G_PORT_SELECT_SHIFT)

#define I40E_GLGEN_PCIFCNCNT_CSR                0x00078E84 /* Reset: PCIR */
#define I40E_GLGEN_PCIFCNCNT_CSR_PCIPFCNT_SHIFT 0
#define I40E_GLGEN_PCIFCNCNT_CSR_PCIPFCNT_MASK  I40E_MASK(0x1F, I40E_GLGEN_PCIFCNCNT_CSR_PCIPFCNT_SHIFT)
#define I40E_GLGEN_PCIFCNCNT_CSR_PCIVFCNT_SHIFT 16
#define I40E_GLGEN_PCIFCNCNT_CSR_PCIVFCNT_MASK  I40E_MASK(0xFF, I40E_GLGEN_PCIFCNCNT_CSR_PCIVFCNT_SHIFT)

#define I40E_GLGEN_PCIFCNCNT_INT                0x0003F840 /* Reset: CORER */
#define I40E_GLGEN_PCIFCNCNT_INT_PCIPFCNT_SHIFT 0
#define I40E_GLGEN_PCIFCNCNT_INT_PCIPFCNT_MASK  I40E_MASK(0x1F, I40E_GLGEN_PCIFCNCNT_INT_PCIPFCNT_SHIFT)
#define I40E_GLGEN_PCIFCNCNT_INT_PCIVFCNT_SHIFT 16
#define I40E_GLGEN_PCIFCNCNT_INT_PCIVFCNT_MASK  I40E_MASK(0xFF, I40E_GLGEN_PCIFCNCNT_INT_PCIVFCNT_SHIFT)

#define I40E_GLGEN_PE_ENA                      0x000B81A0 /* Reset: POR */
#define I40E_GLGEN_PE_ENA_PE_ENA_SHIFT         0
#define I40E_GLGEN_PE_ENA_PE_ENA_MASK          I40E_MASK(0x1, I40E_GLGEN_PE_ENA_PE_ENA_SHIFT)
#define I40E_GLGEN_PE_ENA_PE_CLK_SRC_SEL_SHIFT 1
#define I40E_GLGEN_PE_ENA_PE_CLK_SRC_SEL_MASK  I40E_MASK(0x3, I40E_GLGEN_PE_ENA_PE_CLK_SRC_SEL_SHIFT)

#define I40E_GLGEN_PF_ACC_TO                 0x00078E88 /* Reset: POR */
#define I40E_GLGEN_PF_ACC_TO_PF_ACC_TO_SHIFT 0
#define I40E_GLGEN_PF_ACC_TO_PF_ACC_TO_MASK  I40E_MASK(0xFFFF, I40E_GLGEN_PF_ACC_TO_PF_ACC_TO_SHIFT)

#define I40E_GLGEN_RSTSTAT_REQ                 0x00092620 /* Reset: CORER */
#define I40E_GLGEN_RSTSTAT_REQ_RST_INDEX_SHIFT 0
#define I40E_GLGEN_RSTSTAT_REQ_RST_INDEX_MASK  I40E_MASK(0x1FF, I40E_GLGEN_RSTSTAT_REQ_RST_INDEX_SHIFT)
#define I40E_GLGEN_RSTSTAT_REQ_RST_TYPE_SHIFT  16
#define I40E_GLGEN_RSTSTAT_REQ_RST_TYPE_MASK   I40E_MASK(0x3, I40E_GLGEN_RSTSTAT_REQ_RST_TYPE_SHIFT)

#define I40E_GLGEN_RSTSTATUS                   0x00092624 /* Reset: CORER */
#define I40E_GLGEN_RSTSTATUS_TDPU_CNT_SHIFT    0
#define I40E_GLGEN_RSTSTATUS_TDPU_CNT_MASK     I40E_MASK(0x1F, I40E_GLGEN_RSTSTATUS_TDPU_CNT_SHIFT)
#define I40E_GLGEN_RSTSTATUS_RDPU_CNT_SHIFT    8
#define I40E_GLGEN_RSTSTATUS_RDPU_CNT_MASK     I40E_MASK(0x1F, I40E_GLGEN_RSTSTATUS_RDPU_CNT_SHIFT)
#define I40E_GLGEN_RSTSTATUS_TLAN_CNT_SHIFT    16
#define I40E_GLGEN_RSTSTATUS_TLAN_CNT_MASK     I40E_MASK(0xF, I40E_GLGEN_RSTSTATUS_TLAN_CNT_SHIFT)
#define I40E_GLGEN_RSTSTATUS_RCU_DONE_SHIFT    20
#define I40E_GLGEN_RSTSTATUS_RCU_DONE_MASK     I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_RCU_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_PMAT_DONE_SHIFT   21
#define I40E_GLGEN_RSTSTATUS_PMAT_DONE_MASK    I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_PMAT_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_PE_DONE_SHIFT     22
#define I40E_GLGEN_RSTSTATUS_PE_DONE_MASK      I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_PE_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_CM_PE_DONE_SHIFT  23
#define I40E_GLGEN_RSTSTATUS_CM_PE_DONE_MASK   I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_CM_PE_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_INT_DONE_SHIFT    24
#define I40E_GLGEN_RSTSTATUS_INT_DONE_MASK     I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_INT_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_PEOC_DONE_SHIFT   25
#define I40E_GLGEN_RSTSTATUS_PEOC_DONE_MASK    I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_PEOC_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_PBLOC_DONE_SHIFT  26
#define I40E_GLGEN_RSTSTATUS_PBLOC_DONE_MASK   I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_PBLOC_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_FOC_DONE_SHIFT    27
#define I40E_GLGEN_RSTSTATUS_FOC_DONE_MASK     I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_FOC_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_CM_LAN_DONE_SHIFT 28
#define I40E_GLGEN_RSTSTATUS_CM_LAN_DONE_MASK  I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_CM_LAN_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_FW_DONE_SHIFT     29
#define I40E_GLGEN_RSTSTATUS_FW_DONE_MASK      I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_FW_DONE_SHIFT)
#define I40E_GLGEN_RSTSTATUS_PE_ENA_SHIFT      30
#define I40E_GLGEN_RSTSTATUS_PE_ENA_MASK       I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_PE_ENA_SHIFT)
#define I40E_GLGEN_RSTSTATUS_HW_DONE_SHIFT     31
#define I40E_GLGEN_RSTSTATUS_HW_DONE_MASK      I40E_MASK(0x1, I40E_GLGEN_RSTSTATUS_HW_DONE_SHIFT)

#define I40E_GLMNG_WD_ENA                     0x000B8198 /* Reset: POR */
#define I40E_GLMNG_WD_ENA_FW_RST_WD_ENA_SHIFT 0
#define I40E_GLMNG_WD_ENA_FW_RST_WD_ENA_MASK  I40E_MASK(0x1, I40E_GLMNG_WD_ENA_FW_RST_WD_ENA_SHIFT)
#define I40E_GLMNG_WD_ENA_ECC_RST_ENA_SHIFT   1
#define I40E_GLMNG_WD_ENA_ECC_RST_ENA_MASK    I40E_MASK(0x1, I40E_GLMNG_WD_ENA_ECC_RST_ENA_SHIFT)

#define I40E_GLPHY_ANA_ADD               0x000BA008 /* Reset: POR */
#define I40E_GLPHY_ANA_ADD_ADDRESS_SHIFT 0
#define I40E_GLPHY_ANA_ADD_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLPHY_ANA_ADD_ADDRESS_SHIFT)
#define I40E_GLPHY_ANA_ADD_BYTE_EN_SHIFT 28
#define I40E_GLPHY_ANA_ADD_BYTE_EN_MASK  I40E_MASK(0xF, I40E_GLPHY_ANA_ADD_BYTE_EN_SHIFT)

#define I40E_GLPHY_ANA_DATA            0x000BA00C /* Reset: POR */
#define I40E_GLPHY_ANA_DATA_DATA_SHIFT 0
#define I40E_GLPHY_ANA_DATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPHY_ANA_DATA_DATA_SHIFT)

#define I40E_PFGEN_FWHWRSTAT                        0x00092480 /* Reset: CORER */
#define I40E_PFGEN_FWHWRSTAT_FW_RST_DONE_SHIFT      0
#define I40E_PFGEN_FWHWRSTAT_FW_RST_DONE_MASK       I40E_MASK(0x1, I40E_PFGEN_FWHWRSTAT_FW_RST_DONE_SHIFT)
#define I40E_PFGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT 31
#define I40E_PFGEN_FWHWRSTAT_HW_ONLY_RST_DONE_MASK  I40E_MASK(0x1, I40E_PFGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT)

#define I40E_PFGEN_PORTNUM_CAR                0x000B8000 /* Reset: POR */
#define I40E_PFGEN_PORTNUM_CAR_PORT_NUM_SHIFT 0
#define I40E_PFGEN_PORTNUM_CAR_PORT_NUM_MASK  I40E_MASK(0x3, I40E_PFGEN_PORTNUM_CAR_PORT_NUM_SHIFT)

#define I40E_PFGEN_PORTNUM_CSR                0x00078D00 /* Reset: CORER */
#define I40E_PFGEN_PORTNUM_CSR_PORT_NUM_SHIFT 0
#define I40E_PFGEN_PORTNUM_CSR_PORT_NUM_MASK  I40E_MASK(0x3, I40E_PFGEN_PORTNUM_CSR_PORT_NUM_SHIFT)

#define I40E_PFGEN_PORTNUM_PM                0x0006B800 /* Reset: CORER */
#define I40E_PFGEN_PORTNUM_PM_PORT_NUM_SHIFT 0
#define I40E_PFGEN_PORTNUM_PM_PORT_NUM_MASK  I40E_MASK(0x3, I40E_PFGEN_PORTNUM_PM_PORT_NUM_SHIFT)

#define I40E_PFGEN_PORTNUM_RCB                0x00122000 /* Reset: CORER */
#define I40E_PFGEN_PORTNUM_RCB_PORT_NUM_SHIFT 0
#define I40E_PFGEN_PORTNUM_RCB_PORT_NUM_MASK  I40E_MASK(0x3, I40E_PFGEN_PORTNUM_RCB_PORT_NUM_SHIFT)

#define I40E_PFGEN_PORTNUM_TSCD                0x000B2240 /* Reset: CORER */
#define I40E_PFGEN_PORTNUM_TSCD_PORT_NUM_SHIFT 0
#define I40E_PFGEN_PORTNUM_TSCD_PORT_NUM_MASK  I40E_MASK(0x3, I40E_PFGEN_PORTNUM_TSCD_PORT_NUM_SHIFT)

#define I40E_VPGEN_FWHWRSTAT(_VF)                   (0x00092000 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPGEN_FWHWRSTAT_MAX_INDEX              127
#define I40E_VPGEN_FWHWRSTAT_FW_RST_DONE_SHIFT      0
#define I40E_VPGEN_FWHWRSTAT_FW_RST_DONE_MASK       I40E_MASK(0x1, I40E_VPGEN_FWHWRSTAT_FW_RST_DONE_SHIFT)
#define I40E_VPGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT 31
#define I40E_VPGEN_FWHWRSTAT_HW_ONLY_RST_DONE_MASK  I40E_MASK(0x1, I40E_VPGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT)

#define I40E_VSIGEN_FWHWRSTAT(_VSI)                  (0x00091000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: CORER */
#define I40E_VSIGEN_FWHWRSTAT_MAX_INDEX              383
#define I40E_VSIGEN_FWHWRSTAT_FW_RST_DONE_SHIFT      0
#define I40E_VSIGEN_FWHWRSTAT_FW_RST_DONE_MASK       I40E_MASK(0x1, I40E_VSIGEN_FWHWRSTAT_FW_RST_DONE_SHIFT)
#define I40E_VSIGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT 31
#define I40E_VSIGEN_FWHWRSTAT_HW_ONLY_RST_DONE_MASK  I40E_MASK(0x1, I40E_VSIGEN_FWHWRSTAT_HW_ONLY_RST_DONE_SHIFT)

/* PF - HMC Registers */

#define I40E_GLFOC_CECC_ERR                         0x000AA0D4 /* Reset: POR */
#define I40E_GLFOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT 0
#define I40E_GLFOC_CECC_ERR_UNCOR_ECC_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLFOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT)
#define I40E_GLFOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT   16
#define I40E_GLFOC_CECC_ERR_COR_ECC_ERR_CNT_MASK    I40E_MASK(0xFFF, I40E_GLFOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT)

#define I40E_GLFOC_ECC_CTL                           0x000AA0CC /* Reset: POR */
#define I40E_GLFOC_ECC_CTL_HOST_ECC_EN_SHIFT         0
#define I40E_GLFOC_ECC_CTL_HOST_ECC_EN_MASK          I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_HOST_ECC_EN_SHIFT)
#define I40E_GLFOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT   1
#define I40E_GLFOC_ECC_CTL_HOST_ECC_MASK_INT_MASK    I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT)
#define I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT    2
#define I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT1_MASK     I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT)
#define I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT    3
#define I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT2_MASK     I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT)
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_EN_SHIFT       4
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_CLIENT_ECC_EN_SHIFT)
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT 5
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_MASK_INT_MASK  I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT)
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT  6
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT1_MASK   I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT)
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT  7
#define I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT2_MASK   I40E_MASK(0x1, I40E_GLFOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT)

#define I40E_GLFOC_ERRDATA0                  0x000AA0C0 /* Reset: POR */
#define I40E_GLFOC_ERRDATA0_ERROR_CODE_SHIFT 0
#define I40E_GLFOC_ERRDATA0_ERROR_CODE_MASK  I40E_MASK(0x3F, I40E_GLFOC_ERRDATA0_ERROR_CODE_SHIFT)
#define I40E_GLFOC_ERRDATA0_OBJ_TYPE_SHIFT   8
#define I40E_GLFOC_ERRDATA0_OBJ_TYPE_MASK    I40E_MASK(0x1F, I40E_GLFOC_ERRDATA0_OBJ_TYPE_SHIFT)
#define I40E_GLFOC_ERRDATA0_VM_VF_TYPE_SHIFT 13
#define I40E_GLFOC_ERRDATA0_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLFOC_ERRDATA0_VM_VF_TYPE_SHIFT)
#define I40E_GLFOC_ERRDATA0_VM_VF_NUM_SHIFT  15
#define I40E_GLFOC_ERRDATA0_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLFOC_ERRDATA0_VM_VF_NUM_SHIFT)
#define I40E_GLFOC_ERRDATA0_PF_NUM_SHIFT     24
#define I40E_GLFOC_ERRDATA0_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLFOC_ERRDATA0_PF_NUM_SHIFT)

#define I40E_GLFOC_ERRDATA1                 0x000AA0C4 /* Reset: POR */
#define I40E_GLFOC_ERRDATA1_OBJ_INDEX_SHIFT 0
#define I40E_GLFOC_ERRDATA1_OBJ_INDEX_MASK  I40E_MASK(0xFFFFFFF, I40E_GLFOC_ERRDATA1_OBJ_INDEX_SHIFT)

#define I40E_GLFOC_ERRDATA2              0x000AA0C8 /* Reset: POR */
#define I40E_GLFOC_ERRDATA2_LENGTH_SHIFT 0
#define I40E_GLFOC_ERRDATA2_LENGTH_MASK  I40E_MASK(0x7F, I40E_GLFOC_ERRDATA2_LENGTH_SHIFT)
#define I40E_GLFOC_ERRDATA2_OFFSET_SHIFT 7
#define I40E_GLFOC_ERRDATA2_OFFSET_MASK  I40E_MASK(0x1FFF, I40E_GLFOC_ERRDATA2_OFFSET_SHIFT)
#define I40E_GLFOC_ERRDATA2_OPTYPE_SHIFT 20
#define I40E_GLFOC_ERRDATA2_OPTYPE_MASK  I40E_MASK(0x7, I40E_GLFOC_ERRDATA2_OPTYPE_SHIFT)
#define I40E_GLFOC_ERRDATA2_TAG_SHIFT    23
#define I40E_GLFOC_ERRDATA2_TAG_MASK     I40E_MASK(0x1FF, I40E_GLFOC_ERRDATA2_TAG_SHIFT)

#define I40E_GLFOC_ERRINFO                   0x000AA0BC /* Reset: POR */
#define I40E_GLFOC_ERRINFO_ERROR_VALID_SHIFT 0
#define I40E_GLFOC_ERRINFO_ERROR_VALID_MASK  I40E_MASK(0x1, I40E_GLFOC_ERRINFO_ERROR_VALID_SHIFT)
#define I40E_GLFOC_ERRINFO_ERROR_CNT_SHIFT   8
#define I40E_GLFOC_ERRINFO_ERROR_CNT_MASK    I40E_MASK(0xFF, I40E_GLFOC_ERRINFO_ERROR_CNT_SHIFT)

#define I40E_GLFOC_FCOEHTE_OBJOFST                       0x000AA050 /* Reset: CORER */
#define I40E_GLFOC_FCOEHTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLFOC_FCOEHTE_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLFOC_FCOEHTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLFOC_HECC_ERR                         0x000AA0D0 /* Reset: POR */
#define I40E_GLFOC_HECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT 0
#define I40E_GLFOC_HECC_ERR_UNCOR_ECC_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLFOC_HECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT)
#define I40E_GLFOC_HECC_ERR_COR_ECC_ERR_CNT_SHIFT   16
#define I40E_GLFOC_HECC_ERR_COR_ECC_ERR_CNT_MASK    I40E_MASK(0xFFF, I40E_GLFOC_HECC_ERR_COR_ECC_ERR_CNT_SHIFT)

#define I40E_GLFOC_LAN32BRSV_OBJOFST                       0x000AA058 /* Reset: CORER */
#define I40E_GLFOC_LAN32BRSV_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLFOC_LAN32BRSV_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLFOC_LAN32BRSV_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLFOC_LAN64BRSV0_OBJOFST                       0x000AA05C /* Reset: CORER */
#define I40E_GLFOC_LAN64BRSV0_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLFOC_LAN64BRSV0_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLFOC_LAN64BRSV0_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLFOC_LAN64BRSV1_OBJOFST                       0x000AA060 /* Reset: CORER */
#define I40E_GLFOC_LAN64BRSV1_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLFOC_LAN64BRSV1_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLFOC_LAN64BRSV1_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLFOC_QUADHTE_OBJOFST                       0x000AA054 /* Reset: CORER */
#define I40E_GLFOC_QUADHTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLFOC_QUADHTE_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLFOC_QUADHTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLFOC_STAT_CTL                   0x000AA008 /* Reset: CORER */
#define I40E_GLFOC_STAT_CTL_OBJECT_TYPE_SHIFT 0
#define I40E_GLFOC_STAT_CTL_OBJECT_TYPE_MASK  I40E_MASK(0x1F, I40E_GLFOC_STAT_CTL_OBJECT_TYPE_SHIFT)

#define I40E_GLFOC_STAT_OBJ_CNT                    0x000AA00C /* Reset: CORER */
#define I40E_GLFOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT 0
#define I40E_GLFOC_STAT_OBJ_CNT_OBJECT_COUNT_MASK  I40E_MASK(0x3FFF, I40E_GLFOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT)

#define I40E_GLFOC_STAT_RD_DATA_IDLE_HI              0x000AA034 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_RD_DATA_IDLE_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_RD_DATA_IDLE_LO              0x000AA030 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_RD_DATA_IDLE_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_RD_DATA_XFER_HI              0x000AA03C /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_RD_DATA_XFER_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_RD_DATA_XFER_LO              0x000AA038 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_RD_DATA_XFER_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_RD_HIT_HI              0x000AA014 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_HIT_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_RD_HIT_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_RD_HIT_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_RD_HIT_LO              0x000AA010 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_HIT_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_RD_HIT_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_RD_HIT_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_RD_MISS_HI              0x000AA01C /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_MISS_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_RD_MISS_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_RD_MISS_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_RD_MISS_LO              0x000AA018 /* Reset: CORER */
#define I40E_GLFOC_STAT_RD_MISS_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_RD_MISS_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_RD_MISS_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_WR_DATA_IDLE_HI              0x000AA044 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_DATA_IDLE_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_WR_DATA_IDLE_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_WR_DATA_IDLE_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_WR_DATA_IDLE_LO              0x000AA040 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_DATA_IDLE_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_WR_DATA_IDLE_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_WR_DATA_IDLE_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_WR_DATA_XFER_HI              0x000AA04C /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_DATA_XFER_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_WR_DATA_XFER_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_WR_DATA_XFER_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_WR_DATA_XFER_LO              0x000AA048 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_DATA_XFER_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_WR_DATA_XFER_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_WR_DATA_XFER_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_WR_HIT_HI              0x000AA024 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_HIT_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_WR_HIT_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_WR_HIT_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_WR_HIT_LO              0x000AA020 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_HIT_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_WR_HIT_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_WR_HIT_LO_CNT_LO_SHIFT)

#define I40E_GLFOC_STAT_WR_MISS_HI              0x000AA02C /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_MISS_HI_CNT_HI_SHIFT 0
#define I40E_GLFOC_STAT_WR_MISS_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLFOC_STAT_WR_MISS_HI_CNT_HI_SHIFT)

#define I40E_GLFOC_STAT_WR_MISS_LO              0x000AA028 /* Reset: CORER */
#define I40E_GLFOC_STAT_WR_MISS_LO_CNT_LO_SHIFT 0
#define I40E_GLFOC_STAT_WR_MISS_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLFOC_STAT_WR_MISS_LO_CNT_LO_SHIFT)

#define I40E_GLHMC_EMPOBJCACHECTL0                      0x000C20dc /* Reset: CORER */
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_PF_NUM_SHIFT     0
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLHMC_EMPOBJCACHECTL0_OBJ_PF_NUM_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_TYPE_SHIFT       8
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_TYPE_MASK        I40E_MASK(0x1F, I40E_GLHMC_EMPOBJCACHECTL0_OBJ_TYPE_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_SHIFT            13
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_MASK             I40E_MASK(0x7, I40E_GLHMC_EMPOBJCACHECTL0_CMD_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_NUM_SHIFT  16
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_NUM_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_TYPE_SHIFT 27
#define I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLHMC_EMPOBJCACHECTL0_OBJ_VM_VF_TYPE_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_FAILED_SHIFT     30
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_FAILED_MASK      I40E_MASK(0x1, I40E_GLHMC_EMPOBJCACHECTL0_CMD_FAILED_SHIFT)
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_DONE_SHIFT       31
#define I40E_GLHMC_EMPOBJCACHECTL0_CMD_DONE_MASK        I40E_MASK(0x1, I40E_GLHMC_EMPOBJCACHECTL0_CMD_DONE_SHIFT)

#define I40E_GLHMC_EMPOBJCACHECTL1                 0x000C20e0 /* Reset: CORER */
#define I40E_GLHMC_EMPOBJCACHECTL1_OBJ_INDEX_SHIFT 0
#define I40E_GLHMC_EMPOBJCACHECTL1_OBJ_INDEX_MASK  I40E_MASK(0xFFFFFFF, I40E_GLHMC_EMPOBJCACHECTL1_OBJ_INDEX_SHIFT)

#define I40E_GLHMC_FWPDINV               0x000C207c /* Reset: CORER */
#define I40E_GLHMC_FWPDINV_PMSDIDX_SHIFT 0
#define I40E_GLHMC_FWPDINV_PMSDIDX_MASK  I40E_MASK(0xFFF, I40E_GLHMC_FWPDINV_PMSDIDX_SHIFT)
#define I40E_GLHMC_FWPDINV_PMPDIDX_SHIFT 16
#define I40E_GLHMC_FWPDINV_PMPDIDX_MASK  I40E_MASK(0x1FF, I40E_GLHMC_FWPDINV_PMPDIDX_SHIFT)

#define I40E_GLHMC_FWSDCMD                0x000C2070 /* Reset: CORER */
#define I40E_GLHMC_FWSDCMD_PMSDIDX_SHIFT  0
#define I40E_GLHMC_FWSDCMD_PMSDIDX_MASK   I40E_MASK(0xFFF, I40E_GLHMC_FWSDCMD_PMSDIDX_SHIFT)
#define I40E_GLHMC_FWSDCMD_PF_SHIFT       16
#define I40E_GLHMC_FWSDCMD_PF_MASK        I40E_MASK(0xF, I40E_GLHMC_FWSDCMD_PF_SHIFT)
#define I40E_GLHMC_FWSDCMD_VF_SHIFT       20
#define I40E_GLHMC_FWSDCMD_VF_MASK        I40E_MASK(0x1FF, I40E_GLHMC_FWSDCMD_VF_SHIFT)
#define I40E_GLHMC_FWSDCMD_PMF_TYPE_SHIFT 29
#define I40E_GLHMC_FWSDCMD_PMF_TYPE_MASK  I40E_MASK(0x3, I40E_GLHMC_FWSDCMD_PMF_TYPE_SHIFT)
#define I40E_GLHMC_FWSDCMD_PMSDWR_SHIFT   31
#define I40E_GLHMC_FWSDCMD_PMSDWR_MASK    I40E_MASK(0x1, I40E_GLHMC_FWSDCMD_PMSDWR_SHIFT)

#define I40E_GLHMC_FWSDDATAHIGH                    0x000C2078 /* Reset: CORER */
#define I40E_GLHMC_FWSDDATAHIGH_PMSDDATAHIGH_SHIFT 0
#define I40E_GLHMC_FWSDDATAHIGH_PMSDDATAHIGH_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLHMC_FWSDDATAHIGH_PMSDDATAHIGH_SHIFT)

#define I40E_GLHMC_FWSDDATALOW                   0x000C2074 /* Reset: CORER */
#define I40E_GLHMC_FWSDDATALOW_PMSDVALID_SHIFT   0
#define I40E_GLHMC_FWSDDATALOW_PMSDVALID_MASK    I40E_MASK(0x1, I40E_GLHMC_FWSDDATALOW_PMSDVALID_SHIFT)
#define I40E_GLHMC_FWSDDATALOW_PMSDTYPE_SHIFT    1
#define I40E_GLHMC_FWSDDATALOW_PMSDTYPE_MASK     I40E_MASK(0x1, I40E_GLHMC_FWSDDATALOW_PMSDTYPE_SHIFT)
#define I40E_GLHMC_FWSDDATALOW_PMSDBPCOUNT_SHIFT 2
#define I40E_GLHMC_FWSDDATALOW_PMSDBPCOUNT_MASK  I40E_MASK(0x3FF, I40E_GLHMC_FWSDDATALOW_PMSDBPCOUNT_SHIFT)
#define I40E_GLHMC_FWSDDATALOW_PMSDDATALOW_SHIFT 12
#define I40E_GLHMC_FWSDDATALOW_PMSDDATALOW_MASK  I40E_MASK(0xFFFFF, I40E_GLHMC_FWSDDATALOW_PMSDDATALOW_SHIFT)

#define I40E_GLHMC_LAN32BRSVDBASE(_i)                     (0x000C6a00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN32BRSVDBASE_MAX_INDEX               15
#define I40E_GLHMC_LAN32BRSVDBASE_FPMLAN32BRSVDBASE_SHIFT 0
#define I40E_GLHMC_LAN32BRSVDBASE_FPMLAN32BRSVDBASE_MASK  I40E_MASK(0xFFFFFF, I40E_GLHMC_LAN32BRSVDBASE_FPMLAN32BRSVDBASE_SHIFT)

#define I40E_GLHMC_LAN32BRSVDCNT(_i)                    (0x000C6b00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN32BRSVDCNT_MAX_INDEX              15
#define I40E_GLHMC_LAN32BRSVDCNT_FPMLAN32BRSVDCNT_SHIFT 0
#define I40E_GLHMC_LAN32BRSVDCNT_FPMLAN32BRSVDCNT_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN32BRSVDCNT_FPMLAN32BRSVDCNT_SHIFT)

#define I40E_GLHMC_LAN32BRSVDMAX                       0x000C209C /* Reset: CORER */
#define I40E_GLHMC_LAN32BRSVDMAX_PMLAN32BRSVDMAX_SHIFT 0
#define I40E_GLHMC_LAN32BRSVDMAX_PMLAN32BRSVDMAX_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN32BRSVDMAX_PMLAN32BRSVDMAX_SHIFT)

#define I40E_GLHMC_LAN32BRSVDOBJSZ                         0x000C2098 /* Reset: CORER */
#define I40E_GLHMC_LAN32BRSVDOBJSZ_PMLAN32BRSVDOBJSZ_SHIFT 0
#define I40E_GLHMC_LAN32BRSVDOBJSZ_PMLAN32BRSVDOBJSZ_MASK  I40E_MASK(0xF, I40E_GLHMC_LAN32BRSVDOBJSZ_PMLAN32BRSVDOBJSZ_SHIFT)

#define I40E_GLHMC_LAN64BRSVD0BASE(_i)                      (0x000C6c00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD0BASE_MAX_INDEX                15
#define I40E_GLHMC_LAN64BRSVD0BASE_FPMLAN64BRSVD0BASE_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD0BASE_FPMLAN64BRSVD0BASE_MASK  I40E_MASK(0xFFFFFF, I40E_GLHMC_LAN64BRSVD0BASE_FPMLAN64BRSVD0BASE_SHIFT)

#define I40E_GLHMC_LAN64BRSVD0CNT(_i)                     (0x000C6d00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD0CNT_MAX_INDEX               15
#define I40E_GLHMC_LAN64BRSVD0CNT_FPMLAN64BRSVD0CNT_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD0CNT_FPMLAN64BRSVD0CNT_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN64BRSVD0CNT_FPMLAN64BRSVD0CNT_SHIFT)

#define I40E_GLHMC_LAN64BRSVD0MAX                        0x000C20a4 /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD0MAX_PMLAN64BRSVD0MAX_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD0MAX_PMLAN64BRSVD0MAX_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN64BRSVD0MAX_PMLAN64BRSVD0MAX_SHIFT)

#define I40E_GLHMC_LAN64BRSVD0OBJSZ                          0x000C20a0 /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD0OBJSZ_PMLAN64BRSVD0OBJSZ_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD0OBJSZ_PMLAN64BRSVD0OBJSZ_MASK  I40E_MASK(0xF, I40E_GLHMC_LAN64BRSVD0OBJSZ_PMLAN64BRSVD0OBJSZ_SHIFT)

#define I40E_GLHMC_LAN64BRSVD1BASE(_i)                      (0x000C6e00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD1BASE_MAX_INDEX                15
#define I40E_GLHMC_LAN64BRSVD1BASE_FPMLAN64BRSVD1BASE_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD1BASE_FPMLAN64BRSVD1BASE_MASK  I40E_MASK(0xFFFFFF, I40E_GLHMC_LAN64BRSVD1BASE_FPMLAN64BRSVD1BASE_SHIFT)

#define I40E_GLHMC_LAN64BRSVD1CNT(_i)                     (0x000C6f00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD1CNT_MAX_INDEX               15
#define I40E_GLHMC_LAN64BRSVD1CNT_FPMLAN64BRSVD1CNT_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD1CNT_FPMLAN64BRSVD1CNT_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN64BRSVD1CNT_FPMLAN64BRSVD1CNT_SHIFT)

#define I40E_GLHMC_LAN64BRSVD1MAX                        0x000C20ac /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD1MAX_PMLAN64BRSVD1MAX_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD1MAX_PMLAN64BRSVD1MAX_MASK  I40E_MASK(0x1FFFFFFF, I40E_GLHMC_LAN64BRSVD1MAX_PMLAN64BRSVD1MAX_SHIFT)

#define I40E_GLHMC_LAN64BRSVD1OBJSZ                          0x000C20a8 /* Reset: CORER */
#define I40E_GLHMC_LAN64BRSVD1OBJSZ_PMLAN64BRSVD1OBJSZ_SHIFT 0
#define I40E_GLHMC_LAN64BRSVD1OBJSZ_PMLAN64BRSVD1OBJSZ_MASK  I40E_MASK(0xF, I40E_GLHMC_LAN64BRSVD1OBJSZ_PMLAN64BRSVD1OBJSZ_SHIFT)

#define I40E_GLHMC_OBJECTCACHECTL0(_i)                  (0x000C0900 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_OBJECTCACHECTL0_MAX_INDEX            15
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_PF_NUM_SHIFT     0
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLHMC_OBJECTCACHECTL0_OBJ_PF_NUM_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_TYPE_SHIFT       8
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_TYPE_MASK        I40E_MASK(0x1F, I40E_GLHMC_OBJECTCACHECTL0_OBJ_TYPE_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_SHIFT            13
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_MASK             I40E_MASK(0x7, I40E_GLHMC_OBJECTCACHECTL0_CMD_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_NUM_SHIFT  16
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_NUM_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_TYPE_SHIFT 27
#define I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLHMC_OBJECTCACHECTL0_OBJ_VM_VF_TYPE_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_FAILED_SHIFT     30
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_FAILED_MASK      I40E_MASK(0x1, I40E_GLHMC_OBJECTCACHECTL0_CMD_FAILED_SHIFT)
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_DONE_SHIFT       31
#define I40E_GLHMC_OBJECTCACHECTL0_CMD_DONE_MASK        I40E_MASK(0x1, I40E_GLHMC_OBJECTCACHECTL0_CMD_DONE_SHIFT)

#define I40E_GLHMC_OBJECTCACHECTL1(_i)             (0x000C0a00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_OBJECTCACHECTL1_MAX_INDEX       15
#define I40E_GLHMC_OBJECTCACHECTL1_OBJ_INDEX_SHIFT 0
#define I40E_GLHMC_OBJECTCACHECTL1_OBJ_INDEX_MASK  I40E_MASK(0xFFFFFFF, I40E_GLHMC_OBJECTCACHECTL1_OBJ_INDEX_SHIFT)

#define I40E_GLHMC_PMATCFG                     0x000C2000 /* Reset: CORER */
#define I40E_GLHMC_PMATCFG_CM_PE_WEIGHT_SHIFT  0
#define I40E_GLHMC_PMATCFG_CM_PE_WEIGHT_MASK   I40E_MASK(0x1, I40E_GLHMC_PMATCFG_CM_PE_WEIGHT_SHIFT)
#define I40E_GLHMC_PMATCFG_CM_LAN_WEIGHT_SHIFT 1
#define I40E_GLHMC_PMATCFG_CM_LAN_WEIGHT_MASK  I40E_MASK(0x1, I40E_GLHMC_PMATCFG_CM_LAN_WEIGHT_SHIFT)

#define I40E_GLHMC_PMFTABLE(_i)                        (0x000C0b00 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLHMC_PMFTABLE_MAX_INDEX                  15
#define I40E_GLHMC_PMFTABLE_PM_FCN_TBL_ENTRY_VLD_SHIFT 31
#define I40E_GLHMC_PMFTABLE_PM_FCN_TBL_ENTRY_VLD_MASK  I40E_MASK(0x1, I40E_GLHMC_PMFTABLE_PM_FCN_TBL_ENTRY_VLD_SHIFT)

#define I40E_GLPBLOC_CACHE_CTRL                     0x000A8000 /* Reset: CORER */
#define I40E_GLPBLOC_CACHE_CTRL_SCALE_FACTOR_SHIFT  0
#define I40E_GLPBLOC_CACHE_CTRL_SCALE_FACTOR_MASK   I40E_MASK(0x3, I40E_GLPBLOC_CACHE_CTRL_SCALE_FACTOR_SHIFT)
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_EN_SHIFT     4
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_EN_MASK      I40E_MASK(0x1, I40E_GLPBLOC_CACHE_CTRL_DBGMUX_EN_SHIFT)
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_LO_SHIFT 8
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_LO_MASK  I40E_MASK(0x1F, I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_LO_SHIFT)
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_HI_SHIFT 16
#define I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_HI_MASK  I40E_MASK(0x1F, I40E_GLPBLOC_CACHE_CTRL_DBGMUX_SEL_HI_SHIFT)

#define I40E_GLPBLOC_CECC_ERR                         0x000A80B4 /* Reset: POR */
#define I40E_GLPBLOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT 0
#define I40E_GLPBLOC_CECC_ERR_UNCOR_ECC_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLPBLOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT)
#define I40E_GLPBLOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT   16
#define I40E_GLPBLOC_CECC_ERR_COR_ECC_ERR_CNT_MASK    I40E_MASK(0xFFF, I40E_GLPBLOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT)

#define I40E_GLPBLOC_ECC_CTL                           0x000A80AC /* Reset: POR */
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_EN_SHIFT         0
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_EN_MASK          I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_HOST_ECC_EN_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT   1
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_MASK_INT_MASK    I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT    2
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT1_MASK     I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT    3
#define I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT2_MASK     I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_EN_SHIFT       4
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_EN_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT 5
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_MASK_INT_MASK  I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT  6
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT1_MASK   I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT)
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT  7
#define I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT2_MASK   I40E_MASK(0x1, I40E_GLPBLOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT)

#define I40E_GLPBLOC_ERRDATA0                  0x000A80A0 /* Reset: POR */
#define I40E_GLPBLOC_ERRDATA0_ERROR_CODE_SHIFT 0
#define I40E_GLPBLOC_ERRDATA0_ERROR_CODE_MASK  I40E_MASK(0x3F, I40E_GLPBLOC_ERRDATA0_ERROR_CODE_SHIFT)
#define I40E_GLPBLOC_ERRDATA0_OBJ_TYPE_SHIFT   8
#define I40E_GLPBLOC_ERRDATA0_OBJ_TYPE_MASK    I40E_MASK(0x1F, I40E_GLPBLOC_ERRDATA0_OBJ_TYPE_SHIFT)
#define I40E_GLPBLOC_ERRDATA0_VM_VF_TYPE_SHIFT 13
#define I40E_GLPBLOC_ERRDATA0_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLPBLOC_ERRDATA0_VM_VF_TYPE_SHIFT)
#define I40E_GLPBLOC_ERRDATA0_VM_VF_NUM_SHIFT  15
#define I40E_GLPBLOC_ERRDATA0_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLPBLOC_ERRDATA0_VM_VF_NUM_SHIFT)
#define I40E_GLPBLOC_ERRDATA0_PF_NUM_SHIFT     24
#define I40E_GLPBLOC_ERRDATA0_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLPBLOC_ERRDATA0_PF_NUM_SHIFT)

#define I40E_GLPBLOC_ERRDATA1                 0x000A80A4 /* Reset: POR */
#define I40E_GLPBLOC_ERRDATA1_OBJ_INDEX_SHIFT 0
#define I40E_GLPBLOC_ERRDATA1_OBJ_INDEX_MASK  I40E_MASK(0xFFFFFFF, I40E_GLPBLOC_ERRDATA1_OBJ_INDEX_SHIFT)

#define I40E_GLPBLOC_ERRDATA2              0x000A80A8 /* Reset: POR */
#define I40E_GLPBLOC_ERRDATA2_LENGTH_SHIFT 0
#define I40E_GLPBLOC_ERRDATA2_LENGTH_MASK  I40E_MASK(0x7F, I40E_GLPBLOC_ERRDATA2_LENGTH_SHIFT)
#define I40E_GLPBLOC_ERRDATA2_OFFSET_SHIFT 7
#define I40E_GLPBLOC_ERRDATA2_OFFSET_MASK  I40E_MASK(0x1FFF, I40E_GLPBLOC_ERRDATA2_OFFSET_SHIFT)
#define I40E_GLPBLOC_ERRDATA2_OPTYPE_SHIFT 20
#define I40E_GLPBLOC_ERRDATA2_OPTYPE_MASK  I40E_MASK(0x7, I40E_GLPBLOC_ERRDATA2_OPTYPE_SHIFT)
#define I40E_GLPBLOC_ERRDATA2_TAG_SHIFT    23
#define I40E_GLPBLOC_ERRDATA2_TAG_MASK     I40E_MASK(0x1FF, I40E_GLPBLOC_ERRDATA2_TAG_SHIFT)

#define I40E_GLPBLOC_ERRINFO                   0x000A809C /* Reset: POR */
#define I40E_GLPBLOC_ERRINFO_ERROR_VALID_SHIFT 0
#define I40E_GLPBLOC_ERRINFO_ERROR_VALID_MASK  I40E_MASK(0x1, I40E_GLPBLOC_ERRINFO_ERROR_VALID_SHIFT)
#define I40E_GLPBLOC_ERRINFO_ERROR_CNT_SHIFT   8
#define I40E_GLPBLOC_ERRINFO_ERROR_CNT_MASK    I40E_MASK(0xFF, I40E_GLPBLOC_ERRINFO_ERROR_CNT_SHIFT)

#define I40E_GLPBLOC_HECC_ERR                         0x000A80B0 /* Reset: POR */
#define I40E_GLPBLOC_HECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT 0
#define I40E_GLPBLOC_HECC_ERR_UNCOR_ECC_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLPBLOC_HECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT)
#define I40E_GLPBLOC_HECC_ERR_COR_ECC_ERR_CNT_SHIFT   16
#define I40E_GLPBLOC_HECC_ERR_COR_ECC_ERR_CNT_MASK    I40E_MASK(0xFFF, I40E_GLPBLOC_HECC_ERR_COR_ECC_ERR_CNT_SHIFT)

#define I40E_GLPBLOC_MRTE_OBJOFST                       0x000A8050 /* Reset: CORER */
#define I40E_GLPBLOC_MRTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLPBLOC_MRTE_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLPBLOC_MRTE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLPBLOC_PBLE_OBJOFST                       0x000A804C /* Reset: CORER */
#define I40E_GLPBLOC_PBLE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT 0
#define I40E_GLPBLOC_PBLE_OBJOFST_OBJ_TYPE_OFFSET_MASK  I40E_MASK(0x3FF, I40E_GLPBLOC_PBLE_OBJOFST_OBJ_TYPE_OFFSET_SHIFT)

#define I40E_GLPBLOC_STAT_CTL                   0x000A8004 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_CTL_OBJECT_TYPE_SHIFT 0
#define I40E_GLPBLOC_STAT_CTL_OBJECT_TYPE_MASK  I40E_MASK(0x1F, I40E_GLPBLOC_STAT_CTL_OBJECT_TYPE_SHIFT)

#define I40E_GLPBLOC_STAT_OBJ_CNT                    0x000A8008 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT 0
#define I40E_GLPBLOC_STAT_OBJ_CNT_OBJECT_COUNT_MASK  I40E_MASK(0x3FFF, I40E_GLPBLOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT)

#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_HI              0x000A8030 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_LO              0x000A802C /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_DATA_IDLE_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_RD_DATA_XFER_HI              0x000A8038 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_DATA_XFER_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_RD_DATA_XFER_LO              0x000A8034 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_DATA_XFER_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_RD_HIT_HI              0x000A8010 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_HIT_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_HIT_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_RD_HIT_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_RD_HIT_LO              0x000A800C /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_HIT_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_HIT_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_RD_HIT_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_RD_MISS_HI              0x000A8018 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_MISS_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_MISS_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_RD_MISS_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_RD_MISS_LO              0x000A8014 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_RD_MISS_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_RD_MISS_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_RD_MISS_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_HI              0x000A8040 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_WR_DATA_IDLE_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_LO              0x000A803C /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_DATA_IDLE_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_WR_DATA_IDLE_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_WR_DATA_XFER_HI              0x000A8048 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_DATA_XFER_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_DATA_XFER_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_WR_DATA_XFER_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_WR_DATA_XFER_LO              0x000A8044 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_DATA_XFER_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_DATA_XFER_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_WR_DATA_XFER_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_WR_HIT_HI              0x000A8020 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_HIT_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_HIT_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_WR_HIT_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_WR_HIT_LO              0x000A801C /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_HIT_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_HIT_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_WR_HIT_LO_CNT_LO_SHIFT)

#define I40E_GLPBLOC_STAT_WR_MISS_HI              0x000A8028 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_MISS_HI_CNT_HI_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_MISS_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPBLOC_STAT_WR_MISS_HI_CNT_HI_SHIFT)

#define I40E_GLPBLOC_STAT_WR_MISS_LO              0x000A8024 /* Reset: CORER */
#define I40E_GLPBLOC_STAT_WR_MISS_LO_CNT_LO_SHIFT 0
#define I40E_GLPBLOC_STAT_WR_MISS_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPBLOC_STAT_WR_MISS_LO_CNT_LO_SHIFT)

#define I40E_GLPDOC_CACHE_CTRL                     0x000D0000 /* Reset: CORER */
#define I40E_GLPDOC_CACHE_CTRL_SCALE_FACTOR_SHIFT  0
#define I40E_GLPDOC_CACHE_CTRL_SCALE_FACTOR_MASK   I40E_MASK(0x3, I40E_GLPDOC_CACHE_CTRL_SCALE_FACTOR_SHIFT)
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_EN_SHIFT     4
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_EN_MASK      I40E_MASK(0x1, I40E_GLPDOC_CACHE_CTRL_DBGMUX_EN_SHIFT)
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_LO_SHIFT 8
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_LO_MASK  I40E_MASK(0x1F, I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_LO_SHIFT)
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_HI_SHIFT 16
#define I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_HI_MASK  I40E_MASK(0x1F, I40E_GLPDOC_CACHE_CTRL_DBGMUX_SEL_HI_SHIFT)

#define I40E_GLPDOC_CECC_ERR                         0x000D0080 /* Reset: POR */
#define I40E_GLPDOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT 0
#define I40E_GLPDOC_CECC_ERR_UNCOR_ECC_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLPDOC_CECC_ERR_UNCOR_ECC_ERR_CNT_SHIFT)
#define I40E_GLPDOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT   16
#define I40E_GLPDOC_CECC_ERR_COR_ECC_ERR_CNT_MASK    I40E_MASK(0xFFF, I40E_GLPDOC_CECC_ERR_COR_ECC_ERR_CNT_SHIFT)

#define I40E_GLPDOC_ECC_CTL                           0x000D007c /* Reset: POR */
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_EN_SHIFT         0
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_EN_MASK          I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_HOST_ECC_EN_SHIFT)
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT   1
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_MASK_INT_MASK    I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_HOST_ECC_MASK_INT_SHIFT)
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT    2
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT1_MASK     I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT1_SHIFT)
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT    3
#define I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT2_MASK     I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_HOST_ECC_INVERT2_SHIFT)
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_EN_SHIFT       4
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_CLIENT_ECC_EN_SHIFT)
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT 5
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_MASK_INT_MASK  I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_CLIENT_ECC_MASK_INT_SHIFT)
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT  6
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT1_MASK   I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT1_SHIFT)
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT  7
#define I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT2_MASK   I40E_MASK(0x1, I40E_GLPDOC_ECC_CTL_CLIENT_ECC_INVERT2_SHIFT)

#define I40E_GLPDOC_ERRDATA0                  0x000D0070 /* Reset: POR */
#define I40E_GLPDOC_ERRDATA0_ERROR_CODE_SHIFT 0
#define I40E_GLPDOC_ERRDATA0_ERROR_CODE_MASK  I40E_MASK(0x3F, I40E_GLPDOC_ERRDATA0_ERROR_CODE_SHIFT)
#define I40E_GLPDOC_ERRDATA0_OBJ_TYPE_SHIFT   8
#define I40E_GLPDOC_ERRDATA0_OBJ_TYPE_MASK    I40E_MASK(0x1F, I40E_GLPDOC_ERRDATA0_OBJ_TYPE_SHIFT)
#define I40E_GLPDOC_ERRDATA0_VM_VF_TYPE_SHIFT 13
#define I40E_GLPDOC_ERRDATA0_VM_VF_TYPE_MASK  I40E_MASK(0x3, I40E_GLPDOC_ERRDATA0_VM_VF_TYPE_SHIFT)
#define I40E_GLPDOC_ERRDATA0_VM_VF_NUM_SHIFT  15
#define I40E_GLPDOC_ERRDATA0_VM_VF_NUM_MASK   I40E_MASK(0x1FF, I40E_GLPDOC_ERRDATA0_VM_VF_NUM_SHIFT)
#define I40E_GLPDOC_ERRDATA0_PF_NUM_SHIFT     24
#define I40E_GLPDOC_ERRDATA0_PF_NUM_MASK      I40E_MASK(0xF, I40E_GLPDOC_ERRDATA0_PF_NUM_SHIFT)

#define I40E_GLPDOC_ERRDATA1                 0x000D0074 /* Reset: POR */
#define I40E_GLPDOC_ERRDATA1_OBJ_INDEX_SHIFT 0
#define I40E_GLPDOC_ERRDATA1_OBJ_INDEX_MASK  I40E_MASK(0xFFFFFFF, I40E_GLPDOC_ERRDATA1_OBJ_INDEX_SHIFT)

#define I40E_GLPDOC_ERRDATA2              0x000D0078 /* Reset: POR */
#define I40E_GLPDOC_ERRDATA2_LENGTH_SHIFT 0
#define I40E_GLPDOC_ERRDATA2_LENGTH_MASK  I40E_MASK(0x7F, I40E_GLPDOC_ERRDATA2_LENGTH_SHIFT)
#define I40E_GLPDOC_ERRDATA2_OFFSET_SHIFT 7
#define I40E_GLPDOC_ERRDATA2_OFFSET_MASK  I40E_MASK(0x1FFF, I40E_GLPDOC_ERRDATA2_OFFSET_SHIFT)
#define I40E_GLPDOC_ERRDATA2_OPTYPE_SHIFT 20
#define I40E_GLPDOC_ERRDATA2_OPTYPE_MASK  I40E_MASK(0x7, I40E_GLPDOC_ERRDATA2_OPTYPE_SHIFT)
#define I40E_GLPDOC_ERRDATA2_TAG_SHIFT    23
#define I40E_GLPDOC_ERRDATA2_TAG_MASK     I40E_MASK(0x1FF, I40E_GLPDOC_ERRDATA2_TAG_SHIFT)

#define I40E_GLPDOC_ERRINFO                   0x000D006C /* Reset: POR */
#define I40E_GLPDOC_ERRINFO_ERROR_VALID_SHIFT 0
#define I40E_GLPDOC_ERRINFO_ERROR_VALID_MASK  I40E_MASK(0x1, I40E_GLPDOC_ERRINFO_ERROR_VALID_SHIFT)
#define I40E_GLPDOC_ERRINFO_ERROR_CNT_SHIFT   8
#define I40E_GLPDOC_ERRINFO_ERROR_CNT_MASK    I40E_MASK(0xFF, I40E_GLPDOC_ERRINFO_ERROR_CNT_SHIFT)

#define I40E_GLPDOC_STAT_CTL                   0x000D0004 /* Reset: CORER */
#define I40E_GLPDOC_STAT_CTL_OBJECT_TYPE_SHIFT 0
#define I40E_GLPDOC_STAT_CTL_OBJECT_TYPE_MASK  I40E_MASK(0x1F, I40E_GLPDOC_STAT_CTL_OBJECT_TYPE_SHIFT)

#define I40E_GLPDOC_STAT_OBJ_CNT                    0x000D0008 /* Reset: CORER */
#define I40E_GLPDOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT 0
#define I40E_GLPDOC_STAT_OBJ_CNT_OBJECT_COUNT_MASK  I40E_MASK(0x3FFF, I40E_GLPDOC_STAT_OBJ_CNT_OBJECT_COUNT_SHIFT)

#define I40E_GLPDOC_STAT_RD_DATA_IDLE_HI              0x000D0020 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT 0
#define I40E_GLPDOC_STAT_RD_DATA_IDLE_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPDOC_STAT_RD_DATA_IDLE_HI_CNT_HI_SHIFT)

#define I40E_GLPDOC_STAT_RD_DATA_IDLE_LO              0x000D001C /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT 0
#define I40E_GLPDOC_STAT_RD_DATA_IDLE_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPDOC_STAT_RD_DATA_IDLE_LO_CNT_LO_SHIFT)

#define I40E_GLPDOC_STAT_RD_DATA_XFER_HI              0x000D0028 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT 0
#define I40E_GLPDOC_STAT_RD_DATA_XFER_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPDOC_STAT_RD_DATA_XFER_HI_CNT_HI_SHIFT)

#define I40E_GLPDOC_STAT_RD_DATA_XFER_LO              0x000D0024 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT 0
#define I40E_GLPDOC_STAT_RD_DATA_XFER_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPDOC_STAT_RD_DATA_XFER_LO_CNT_LO_SHIFT)

#define I40E_GLPDOC_STAT_RD_HIT_HI              0x000D0010 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_HIT_HI_CNT_HI_SHIFT 0
#define I40E_GLPDOC_STAT_RD_HIT_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPDOC_STAT_RD_HIT_HI_CNT_HI_SHIFT)

#define I40E_GLPDOC_STAT_RD_HIT_LO              0x000D000C /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_HIT_LO_CNT_LO_SHIFT 0
#define I40E_GLPDOC_STAT_RD_HIT_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPDOC_STAT_RD_HIT_LO_CNT_LO_SHIFT)

#define I40E_GLPDOC_STAT_RD_MISS_HI              0x000D0018 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_MISS_HI_CNT_HI_SHIFT 0
#define I40E_GLPDOC_STAT_RD_MISS_HI_CNT_HI_MASK  I40E_MASK(0xFFFFFF, I40E_GLPDOC_STAT_RD_MISS_HI_CNT_HI_SHIFT)

#define I40E_GLPDOC_STAT_RD_MISS_LO              0x000D0014 /* Reset: CORER */
#define I40E_GLPDOC_STAT_RD_MISS_LO_CNT_LO_SHIFT 0
#define I40E_GLPDOC_STAT_RD_MISS_LO_CNT_LO_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPDOC_STAT_RD_MISS_LO_CNT_LO_SHIFT)

/* PF - Intel Internal Registers */

#define I40E_DPU_IMEM_CFG                    0x00051064 /* Reset: POR */
#define I40E_DPU_IMEM_CFG_ECC_EN_SHIFT       0
#define I40E_DPU_IMEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_DPU_IMEM_CFG_ECC_EN_SHIFT)
#define I40E_DPU_IMEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_DPU_IMEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_DPU_IMEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_DPU_IMEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_DPU_IMEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_DPU_IMEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_DPU_IMEM_CFG_LS_FORCE_SHIFT     3
#define I40E_DPU_IMEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_DPU_IMEM_CFG_LS_FORCE_SHIFT)
#define I40E_DPU_IMEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_DPU_IMEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_DPU_IMEM_CFG_LS_BYPASS_SHIFT)
#define I40E_DPU_IMEM_CFG_MASK_INT_SHIFT     5
#define I40E_DPU_IMEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_DPU_IMEM_CFG_MASK_INT_SHIFT)
#define I40E_DPU_IMEM_CFG_FIX_CNT_SHIFT      8
#define I40E_DPU_IMEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_DPU_IMEM_CFG_FIX_CNT_SHIFT)
#define I40E_DPU_IMEM_CFG_ERR_CNT_SHIFT      9
#define I40E_DPU_IMEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_DPU_IMEM_CFG_ERR_CNT_SHIFT)
#define I40E_DPU_IMEM_CFG_RME_SHIFT          12
#define I40E_DPU_IMEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_DPU_IMEM_CFG_RME_SHIFT)
#define I40E_DPU_IMEM_CFG_RM_SHIFT           16
#define I40E_DPU_IMEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_DPU_IMEM_CFG_RM_SHIFT)

#define I40E_DPU_IMEM_STATUS                        0x00051068 /* Reset: POR */
#define I40E_DPU_IMEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_DPU_IMEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_DPU_IMEM_STATUS_ECC_ERR_SHIFT)
#define I40E_DPU_IMEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_DPU_IMEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_DPU_IMEM_STATUS_ECC_FIX_SHIFT)
#define I40E_DPU_IMEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_DPU_IMEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_DPU_IMEM_STATUS_INIT_DONE_SHIFT)
#define I40E_DPU_IMEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_DPU_IMEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_DPU_IMEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_DPU_RECIPE_ADDR_CFG                    0x0005106C /* Reset: POR */
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_EN_SHIFT       0
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_ECC_EN_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_LS_FORCE_SHIFT     3
#define I40E_DPU_RECIPE_ADDR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_LS_FORCE_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_LS_BYPASS_SHIFT    4
#define I40E_DPU_RECIPE_ADDR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_LS_BYPASS_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_MASK_INT_SHIFT     5
#define I40E_DPU_RECIPE_ADDR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_MASK_INT_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_FIX_CNT_SHIFT      8
#define I40E_DPU_RECIPE_ADDR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_FIX_CNT_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_ERR_CNT_SHIFT      9
#define I40E_DPU_RECIPE_ADDR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_ERR_CNT_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_RME_SHIFT          12
#define I40E_DPU_RECIPE_ADDR_CFG_RME_MASK           I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_CFG_RME_SHIFT)
#define I40E_DPU_RECIPE_ADDR_CFG_RM_SHIFT           16
#define I40E_DPU_RECIPE_ADDR_CFG_RM_MASK            I40E_MASK(0xF, I40E_DPU_RECIPE_ADDR_CFG_RM_SHIFT)

#define I40E_DPU_RECIPE_ADDR_STATUS                        0x00051070 /* Reset: POR */
#define I40E_DPU_RECIPE_ADDR_STATUS_ECC_ERR_SHIFT          0
#define I40E_DPU_RECIPE_ADDR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_STATUS_ECC_ERR_SHIFT)
#define I40E_DPU_RECIPE_ADDR_STATUS_ECC_FIX_SHIFT          1
#define I40E_DPU_RECIPE_ADDR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_STATUS_ECC_FIX_SHIFT)
#define I40E_DPU_RECIPE_ADDR_STATUS_INIT_DONE_SHIFT        2
#define I40E_DPU_RECIPE_ADDR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_STATUS_INIT_DONE_SHIFT)
#define I40E_DPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_DPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_DPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FLEEP_ECC_COR_ERR           0x000B6150 /* Reset: POR */
#define I40E_FLEEP_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_FLEEP_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FLEEP_ECC_COR_ERR_CNT_SHIFT)

#define I40E_FLEEP_ECC_UNCOR_ERR           0x000B614C /* Reset: POR */
#define I40E_FLEEP_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_FLEEP_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FLEEP_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_FLEEP_MEM_CFG                    0x000B6144 /* Reset: POR */
#define I40E_FLEEP_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FLEEP_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FLEEP_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FLEEP_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FLEEP_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FLEEP_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FLEEP_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FLEEP_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FLEEP_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FLEEP_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FLEEP_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FLEEP_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FLEEP_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FLEEP_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FLEEP_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FLEEP_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FLEEP_MEM_CFG_RME_SHIFT          12
#define I40E_FLEEP_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FLEEP_MEM_CFG_RME_SHIFT)
#define I40E_FLEEP_MEM_CFG_RM_SHIFT           16
#define I40E_FLEEP_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FLEEP_MEM_CFG_RM_SHIFT)

#define I40E_FLEEP_MEM_STATUS                        0x000B6148 /* Reset: POR */
#define I40E_FLEEP_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FLEEP_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FLEEP_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FLEEP_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FLEEP_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FLEEP_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FLEEP_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FLEEP_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FLEEP_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FLEEP_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FLEEP_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FLEEP_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FOC_CACHE_DBG_CTL              0x000AA0A4 /* Reset: CORER */
#define I40E_FOC_CACHE_DBG_CTL_ADR_SHIFT    0
#define I40E_FOC_CACHE_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_FOC_CACHE_DBG_CTL_ADR_SHIFT)
#define I40E_FOC_CACHE_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_FOC_CACHE_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_FOC_CACHE_DBG_CTL_DW_SEL_SHIFT)
#define I40E_FOC_CACHE_DBG_CTL_RD_EN_SHIFT  30
#define I40E_FOC_CACHE_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_FOC_CACHE_DBG_CTL_RD_EN_SHIFT)
#define I40E_FOC_CACHE_DBG_CTL_DONE_SHIFT   31
#define I40E_FOC_CACHE_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_FOC_CACHE_DBG_CTL_DONE_SHIFT)

#define I40E_FOC_CACHE_DBG_DATA             0x000AA0A8 /* Reset: CORER */
#define I40E_FOC_CACHE_DBG_DATA_RD_DW_SHIFT 0
#define I40E_FOC_CACHE_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_FOC_CACHE_DBG_DATA_RD_DW_SHIFT)

#define I40E_FOC_CACHE_MEM_CFG                    0x000AA064 /* Reset: POR */
#define I40E_FOC_CACHE_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FOC_CACHE_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FOC_CACHE_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FOC_CACHE_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FOC_CACHE_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FOC_CACHE_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FOC_CACHE_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_RME_SHIFT          12
#define I40E_FOC_CACHE_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FOC_CACHE_MEM_CFG_RME_SHIFT)
#define I40E_FOC_CACHE_MEM_CFG_RM_SHIFT           16
#define I40E_FOC_CACHE_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FOC_CACHE_MEM_CFG_RM_SHIFT)

#define I40E_FOC_CAHCE_MEM_STATUS                        0x000AA068 /* Reset: POR */
#define I40E_FOC_CAHCE_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FOC_CAHCE_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FOC_CAHCE_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FOC_CAHCE_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FOC_CAHCE_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FOC_CAHCE_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FOC_CAHCE_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FOC_CAHCE_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FOC_CAHCE_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FOC_CAHCE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FOC_CAHCE_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FOC_CAHCE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FOC_ECC_COR_ERR           0x000AA098 /* Reset: POR */
#define I40E_FOC_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_FOC_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FOC_ECC_COR_ERR_CNT_SHIFT)

#define I40E_FOC_ECC_UNCOR_ERR           0x000AA094 /* Reset: POR */
#define I40E_FOC_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_FOC_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FOC_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_FOC_EVICT_MEM_CFG                    0x000AA084 /* Reset: POR */
#define I40E_FOC_EVICT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FOC_EVICT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FOC_EVICT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FOC_EVICT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FOC_EVICT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FOC_EVICT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FOC_EVICT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_RME_SHIFT          12
#define I40E_FOC_EVICT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FOC_EVICT_MEM_CFG_RME_SHIFT)
#define I40E_FOC_EVICT_MEM_CFG_RM_SHIFT           16
#define I40E_FOC_EVICT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FOC_EVICT_MEM_CFG_RM_SHIFT)

#define I40E_FOC_EVICT_MEM_STATUS                        0x000AA088 /* Reset: POR */
#define I40E_FOC_EVICT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FOC_EVICT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FOC_EVICT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FOC_EVICT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FOC_EVICT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FOC_EVICT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FOC_EVICT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FOC_EVICT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FOC_EVICT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FOC_FD_DBG_CTL              0x000AA0B4 /* Reset: CORER */
#define I40E_FOC_FD_DBG_CTL_ADR_SHIFT    0
#define I40E_FOC_FD_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_FOC_FD_DBG_CTL_ADR_SHIFT)
#define I40E_FOC_FD_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_FOC_FD_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_FOC_FD_DBG_CTL_DW_SEL_SHIFT)
#define I40E_FOC_FD_DBG_CTL_RD_EN_SHIFT  30
#define I40E_FOC_FD_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_FOC_FD_DBG_CTL_RD_EN_SHIFT)
#define I40E_FOC_FD_DBG_CTL_DONE_SHIFT   31
#define I40E_FOC_FD_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_FOC_FD_DBG_CTL_DONE_SHIFT)

#define I40E_FOC_FD_DBG_DATA             0x000AA0B8 /* Reset: CORER */
#define I40E_FOC_FD_DBG_DATA_RD_DW_SHIFT 0
#define I40E_FOC_FD_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_FOC_FD_DBG_DATA_RD_DW_SHIFT)

#define I40E_FOC_FD_MEM_CFG                    0x000AA08C /* Reset: POR */
#define I40E_FOC_FD_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FOC_FD_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FOC_FD_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FOC_FD_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FOC_FD_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FOC_FD_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FOC_FD_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FOC_FD_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FOC_FD_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FOC_FD_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FOC_FD_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FOC_FD_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FOC_FD_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FOC_FD_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FOC_FD_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FOC_FD_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FOC_FD_MEM_CFG_RME_SHIFT          12
#define I40E_FOC_FD_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FOC_FD_MEM_CFG_RME_SHIFT)
#define I40E_FOC_FD_MEM_CFG_RM_SHIFT           16
#define I40E_FOC_FD_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FOC_FD_MEM_CFG_RM_SHIFT)

#define I40E_FOC_FD_MEM_STATUS                        0x000AA090 /* Reset: POR */
#define I40E_FOC_FD_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FOC_FD_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FOC_FD_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FOC_FD_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FOC_FD_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FOC_FD_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FOC_FD_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FOC_FD_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FOC_FD_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FOC_FD_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FOC_FD_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FOC_FD_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FOC_FILL_MEM_CFG                    0x000AA074 /* Reset: POR */
#define I40E_FOC_FILL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FOC_FILL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FOC_FILL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FOC_FILL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FOC_FILL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FOC_FILL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FOC_FILL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FOC_FILL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FOC_FILL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_RME_SHIFT          12
#define I40E_FOC_FILL_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FOC_FILL_MEM_CFG_RME_SHIFT)
#define I40E_FOC_FILL_MEM_CFG_RM_SHIFT           16
#define I40E_FOC_FILL_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FOC_FILL_MEM_CFG_RM_SHIFT)

#define I40E_FOC_FILL_MEM_STATUS                        0x000AA078 /* Reset: POR */
#define I40E_FOC_FILL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FOC_FILL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FOC_FILL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FOC_FILL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FOC_FILL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FOC_FILL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FOC_FILL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FOC_FILL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FOC_FILL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FOC_TAG_DBG_CTL              0x000AA09C /* Reset: CORER */
#define I40E_FOC_TAG_DBG_CTL_ADR_SHIFT    0
#define I40E_FOC_TAG_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_FOC_TAG_DBG_CTL_ADR_SHIFT)
#define I40E_FOC_TAG_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_FOC_TAG_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_FOC_TAG_DBG_CTL_DW_SEL_SHIFT)
#define I40E_FOC_TAG_DBG_CTL_RD_EN_SHIFT  30
#define I40E_FOC_TAG_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_FOC_TAG_DBG_CTL_RD_EN_SHIFT)
#define I40E_FOC_TAG_DBG_CTL_DONE_SHIFT   31
#define I40E_FOC_TAG_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_FOC_TAG_DBG_CTL_DONE_SHIFT)

#define I40E_FOC_TAG_DBG_DATA             0x000AA0A0 /* Reset: CORER */
#define I40E_FOC_TAG_DBG_DATA_RD_DW_SHIFT 0
#define I40E_FOC_TAG_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_FOC_TAG_DBG_DATA_RD_DW_SHIFT)

#define I40E_FOC_TAG_MEM_CFG                    0x000AA06C /* Reset: POR */
#define I40E_FOC_TAG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FOC_TAG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FOC_TAG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FOC_TAG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FOC_TAG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FOC_TAG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FOC_TAG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FOC_TAG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FOC_TAG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_RME_SHIFT          12
#define I40E_FOC_TAG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FOC_TAG_MEM_CFG_RME_SHIFT)
#define I40E_FOC_TAG_MEM_CFG_RM_SHIFT           16
#define I40E_FOC_TAG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FOC_TAG_MEM_CFG_RM_SHIFT)

#define I40E_FOC_TAG_MEM_STATUS                        0x000AA070 /* Reset: POR */
#define I40E_FOC_TAG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FOC_TAG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FOC_TAG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FOC_TAG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FOC_TAG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FOC_TAG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FOC_TAG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FOC_TAG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FOC_TAG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_FVL_STAT_ECC_COR_ERR           0x003800F4 /* Reset: POR */
#define I40E_FVL_STAT_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_FVL_STAT_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FVL_STAT_ECC_COR_ERR_CNT_SHIFT)

#define I40E_FVL_STAT_ECC_UNCOR_ERR           0x003800F0 /* Reset: POR */
#define I40E_FVL_STAT_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_FVL_STAT_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_FVL_STAT_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_FVL_STAT_MEM_CFG(_i)                (0x00380000 + ((_i) * 4)) /* _i=0...29 */ /* Reset: POR */
#define I40E_FVL_STAT_MEM_CFG_MAX_INDEX          29
#define I40E_FVL_STAT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_FVL_STAT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_FVL_STAT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_FVL_STAT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_FVL_STAT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_FVL_STAT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_FVL_STAT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_FVL_STAT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_FVL_STAT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_RME_SHIFT          12
#define I40E_FVL_STAT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_FVL_STAT_MEM_CFG_RME_SHIFT)
#define I40E_FVL_STAT_MEM_CFG_RM_SHIFT           16
#define I40E_FVL_STAT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_FVL_STAT_MEM_CFG_RM_SHIFT)

#define I40E_FVL_STAT_MEM_STATUS(_i)                    (0x00380078 + ((_i) * 4)) /* _i=0...29 */ /* Reset: POR */
#define I40E_FVL_STAT_MEM_STATUS_MAX_INDEX              29
#define I40E_FVL_STAT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_FVL_STAT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_FVL_STAT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_FVL_STAT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_FVL_STAT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_FVL_STAT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_FVL_STAT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_FVL_STAT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_FVL_STAT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_FVL_STAT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_FVL_STAT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_FVL_STAT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GL_CRITERRMODMASK0                    0x000B4020 /* Reset: CORER */
#define I40E_GL_CRITERRMODMASK0_MODULE_MASK0_SHIFT 1
#define I40E_GL_CRITERRMODMASK0_MODULE_MASK0_MASK  I40E_MASK(0x7FFFFFFF, I40E_GL_CRITERRMODMASK0_MODULE_MASK0_SHIFT)

#define I40E_GL_CRITERRMODMASK1                    0x000B4024 /* Reset: CORER */
#define I40E_GL_CRITERRMODMASK1_MODULE_MASK1_SHIFT 1
#define I40E_GL_CRITERRMODMASK1_MODULE_MASK1_MASK  I40E_MASK(0x7FFFFFFF, I40E_GL_CRITERRMODMASK1_MODULE_MASK1_SHIFT)

#define I40E_GL_CRITERRMODMASK2                    0x000B4028 /* Reset: CORER */
#define I40E_GL_CRITERRMODMASK2_MODULE_MASK2_SHIFT 1
#define I40E_GL_CRITERRMODMASK2_MODULE_MASK2_MASK  I40E_MASK(0x7FFFFFFF, I40E_GL_CRITERRMODMASK2_MODULE_MASK2_SHIFT)

#define I40E_GL_CRITERRMODMASK3                    0x000B402C /* Reset: CORER */
#define I40E_GL_CRITERRMODMASK3_MODULE_MASK3_SHIFT 1
#define I40E_GL_CRITERRMODMASK3_MODULE_MASK3_MASK  I40E_MASK(0x7FFFFFFF, I40E_GL_CRITERRMODMASK3_MODULE_MASK3_SHIFT)

#define I40E_GL_CRITERRTRGTMASK0                           0x000B4040 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_0_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK0_TRGT_MATCH_1_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK1                           0x000B4044 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_2_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK1_TRGT_MATCH_3_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK2                           0x000B4048 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_4_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK2_TRGT_MATCH_5_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK3                           0x000B404C /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_6_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK3_TRGT_MATCH_7_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK4                           0x000B4050 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_8_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK4_TRGT_MATCH_9_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK5                            0x000B4054 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_10_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK5_TRGT_MATCH_11_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK6                            0x000B4058 /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_12_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK6_TRGT_MATCH_13_MODULE_SHIFT)

#define I40E_GL_CRITERRTRGTMASK7                            0x000B405C /* Reset: CORER */
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_INST_SHIFT   0
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_TYPE_SHIFT   6
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_MODULE_SHIFT 8
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_14_MODULE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_INST_SHIFT   16
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_INST_MASK    I40E_MASK(0x3F, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_INST_SHIFT)
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_TYPE_SHIFT   22
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_TYPE_MASK    I40E_MASK(0x3, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_TYPE_SHIFT)
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_MODULE_SHIFT 24
#define I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_MODULE_MASK  I40E_MASK(0xFF, I40E_GL_CRITERRTRGTMASK7_TRGT_MATCH_15_MODULE_SHIFT)

#define I40E_GL_DBG_DATA                   0x0026998C /* Reset: CORER */
#define I40E_GL_DBG_DATA_GL_DBG_DATA_SHIFT 0
#define I40E_GL_DBG_DATA_GL_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_DBG_DATA_GL_DBG_DATA_SHIFT)

#define I40E_GL_DBGEMPR                0x00083108 /* Reset: EMPR */
#define I40E_GL_DBGEMPR_RSV_DATA_SHIFT 0
#define I40E_GL_DBGEMPR_RSV_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_DBGEMPR_RSV_DATA_SHIFT)

#define I40E_GL_DBGPOR                        0x00083104 /* Reset: POR */
#define I40E_GL_DBGPOR_ROM_EMPR_TRIGGER_SHIFT 0
#define I40E_GL_DBGPOR_ROM_EMPR_TRIGGER_MASK  I40E_MASK(0x1, I40E_GL_DBGPOR_ROM_EMPR_TRIGGER_SHIFT)
#define I40E_GL_DBGPOR_RSV_DATA_SHIFT         1
#define I40E_GL_DBGPOR_RSV_DATA_MASK          I40E_MASK(0x7FFFFFFF, I40E_GL_DBGPOR_RSV_DATA_SHIFT)

#define I40E_GL_DBGRST                      0x0008310C /* Reset: POR */
#define I40E_GL_DBGRST_PRST_RSV_DATA_SHIFT  0
#define I40E_GL_DBGRST_PRST_RSV_DATA_MASK   I40E_MASK(0xFF, I40E_GL_DBGRST_PRST_RSV_DATA_SHIFT)
#define I40E_GL_DBGRST_IBR_RSV_DATA_SHIFT   8
#define I40E_GL_DBGRST_IBR_RSV_DATA_MASK    I40E_MASK(0xFF, I40E_GL_DBGRST_IBR_RSV_DATA_SHIFT)
#define I40E_GL_DBGRST_GLBR_RSV_DATA_SHIFT  16
#define I40E_GL_DBGRST_GLBR_RSV_DATA_MASK   I40E_MASK(0xFF, I40E_GL_DBGRST_GLBR_RSV_DATA_SHIFT)
#define I40E_GL_DBGRST_CORER_RSV_DATA_SHIFT 24
#define I40E_GL_DBGRST_CORER_RSV_DATA_MASK  I40E_MASK(0xFF, I40E_GL_DBGRST_CORER_RSV_DATA_SHIFT)

#define I40E_GL_MDEF_TR_CFG                   0x00269A5C /* Reset: CORER */
#define I40E_GL_MDEF_TR_CFG_TCP_TR_IDX_SHIFT  0
#define I40E_GL_MDEF_TR_CFG_TCP_TR_IDX_MASK   I40E_MASK(0x3F, I40E_GL_MDEF_TR_CFG_TCP_TR_IDX_SHIFT)
#define I40E_GL_MDEF_TR_CFG_UDP_TR_IDX_SHIFT  6
#define I40E_GL_MDEF_TR_CFG_UDP_TR_IDX_MASK   I40E_MASK(0x3F, I40E_GL_MDEF_TR_CFG_UDP_TR_IDX_SHIFT)
#define I40E_GL_MDEF_TR_CFG_IPV4_TR_IDX_SHIFT 12
#define I40E_GL_MDEF_TR_CFG_IPV4_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MDEF_TR_CFG_IPV4_TR_IDX_SHIFT)
#define I40E_GL_MDEF_TR_CFG_IPV6_TR_IDX_SHIFT 18
#define I40E_GL_MDEF_TR_CFG_IPV6_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MDEF_TR_CFG_IPV6_TR_IDX_SHIFT)
#define I40E_GL_MDEF_TR_CFG_VLAN_TR_IDX_SHIFT 24
#define I40E_GL_MDEF_TR_CFG_VLAN_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MDEF_TR_CFG_VLAN_TR_IDX_SHIFT)

#define I40E_GL_MDEF_TR_EXT_CFG                    0x00269A64 /* Reset: CORER */
#define I40E_GL_MDEF_TR_EXT_CFG_FCTRL_TR_IDX_SHIFT 0
#define I40E_GL_MDEF_TR_EXT_CFG_FCTRL_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MDEF_TR_EXT_CFG_FCTRL_TR_IDX_SHIFT)

#define I40E_GL_MTG_HSH_CTL                 0x00269984 /* Reset: CORER */
#define I40E_GL_MTG_HSH_CTL_HASH_MODE_SHIFT 0
#define I40E_GL_MTG_HSH_CTL_HASH_MODE_MASK  I40E_MASK(0x3, I40E_GL_MTG_HSH_CTL_HASH_MODE_SHIFT)

#define I40E_GL_MTG_MAP                      0x0026994C /* Reset: CORER */
#define I40E_GL_MTG_MAP_ETAG_FV_IDX_SHIFT    0
#define I40E_GL_MTG_MAP_ETAG_FV_IDX_MASK     I40E_MASK(0x3F, I40E_GL_MTG_MAP_ETAG_FV_IDX_SHIFT)
#define I40E_GL_MTG_MAP_ETAG_TR_IDX_SHIFT    6
#define I40E_GL_MTG_MAP_ETAG_TR_IDX_MASK     I40E_MASK(0x3F, I40E_GL_MTG_MAP_ETAG_TR_IDX_SHIFT)
#define I40E_GL_MTG_MAP_SRC_TAG_FV_IDX_SHIFT 12
#define I40E_GL_MTG_MAP_SRC_TAG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MTG_MAP_SRC_TAG_FV_IDX_SHIFT)
#define I40E_GL_MTG_MAP_STAG_FV_IDX_SHIFT    18
#define I40E_GL_MTG_MAP_STAG_FV_IDX_MASK     I40E_MASK(0x3F, I40E_GL_MTG_MAP_STAG_FV_IDX_SHIFT)
#define I40E_GL_MTG_MAP_STAG_TR_IDX_SHIFT    24
#define I40E_GL_MTG_MAP_STAG_TR_IDX_MASK     I40E_MASK(0x3F, I40E_GL_MTG_MAP_STAG_TR_IDX_SHIFT)

#define I40E_GL_MTG_MAP_EXT                     0x00269954 /* Reset: CORER */
#define I40E_GL_MTG_MAP_EXT_O_VLAN_FV_IDX_SHIFT 0
#define I40E_GL_MTG_MAP_EXT_O_VLAN_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MTG_MAP_EXT_O_VLAN_FV_IDX_SHIFT)
#define I40E_GL_MTG_MAP_EXT_O_VLAN_TR_IDX_SHIFT 6
#define I40E_GL_MTG_MAP_EXT_O_VLAN_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_MTG_MAP_EXT_O_VLAN_TR_IDX_SHIFT)

#define I40E_GL_MTG_REP_FLU_CTL                0x00269964 /* Reset: CORER */
#define I40E_GL_MTG_REP_FLU_CTL_FLU_MODE_SHIFT 0
#define I40E_GL_MTG_REP_FLU_CTL_FLU_MODE_MASK  I40E_MASK(0xF, I40E_GL_MTG_REP_FLU_CTL_FLU_MODE_SHIFT)
#define I40E_GL_MTG_REP_FLU_CTL_FLU_OVTH_SHIFT 8
#define I40E_GL_MTG_REP_FLU_CTL_FLU_OVTH_MASK  I40E_MASK(0xFF, I40E_GL_MTG_REP_FLU_CTL_FLU_OVTH_SHIFT)

#define I40E_GL_MTG_REP_MFIFO_CTL                     0x0026999C /* Reset: CORER */
#define I40E_GL_MTG_REP_MFIFO_CTL_UP_STRICT_PR_SHIFT  0
#define I40E_GL_MTG_REP_MFIFO_CTL_UP_STRICT_PR_MASK   I40E_MASK(0xF, I40E_GL_MTG_REP_MFIFO_CTL_UP_STRICT_PR_SHIFT)
#define I40E_GL_MTG_REP_MFIFO_CTL_PRT_STRICT_PR_SHIFT 4
#define I40E_GL_MTG_REP_MFIFO_CTL_PRT_STRICT_PR_MASK  I40E_MASK(0x1, I40E_GL_MTG_REP_MFIFO_CTL_PRT_STRICT_PR_SHIFT)

#define I40E_GL_MTG_TBL_CTL                0x0026997C /* Reset: CORER */
#define I40E_GL_MTG_TBL_CTL_FLU_MODE_SHIFT 0
#define I40E_GL_MTG_TBL_CTL_FLU_MODE_MASK  I40E_MASK(0xF, I40E_GL_MTG_TBL_CTL_FLU_MODE_SHIFT)
#define I40E_GL_MTG_TBL_CTL_FLU_OVTH_SHIFT 8
#define I40E_GL_MTG_TBL_CTL_FLU_OVTH_MASK  I40E_MASK(0xFF, I40E_GL_MTG_TBL_CTL_FLU_OVTH_SHIFT)

#define I40E_GL_PRE_FLU_CTL(_i)            (0x00269240 + ((_i) * 4)) /* _i=0...9 */ /* Reset: CORER */
#define I40E_GL_PRE_FLU_CTL_MAX_INDEX      9
#define I40E_GL_PRE_FLU_CTL_FLU_MODE_SHIFT 0
#define I40E_GL_PRE_FLU_CTL_FLU_MODE_MASK  I40E_MASK(0xF, I40E_GL_PRE_FLU_CTL_FLU_MODE_SHIFT)
#define I40E_GL_PRE_FLU_CTL_FLU_OVTH_SHIFT 8
#define I40E_GL_PRE_FLU_CTL_FLU_OVTH_MASK  I40E_MASK(0xFF, I40E_GL_PRE_FLU_CTL_FLU_OVTH_SHIFT)

#define I40E_GL_PRE_HSH_KEY_D0                0x00269810 /* Reset: CORER */
#define I40E_GL_PRE_HSH_KEY_D0_HASH_KEY_SHIFT 0
#define I40E_GL_PRE_HSH_KEY_D0_HASH_KEY_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_HSH_KEY_D0_HASH_KEY_SHIFT)

#define I40E_GL_PRE_HSH_KEY_D1                0x00269814 /* Reset: CORER */
#define I40E_GL_PRE_HSH_KEY_D1_HASH_KEY_SHIFT 0
#define I40E_GL_PRE_HSH_KEY_D1_HASH_KEY_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_HSH_KEY_D1_HASH_KEY_SHIFT)

#define I40E_GL_PRE_HSH_KEY_D2                0x00269818 /* Reset: CORER */
#define I40E_GL_PRE_HSH_KEY_D2_HASH_KEY_SHIFT 0
#define I40E_GL_PRE_HSH_KEY_D2_HASH_KEY_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_HSH_KEY_D2_HASH_KEY_SHIFT)

#define I40E_GL_PRE_HSH_KEY_D3                0x0026981C /* Reset: CORER */
#define I40E_GL_PRE_HSH_KEY_D3_HASH_KEY_SHIFT 0
#define I40E_GL_PRE_HSH_KEY_D3_HASH_KEY_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_HSH_KEY_D3_HASH_KEY_SHIFT)

#define I40E_GL_PRE_MNG_ARP_FLD_CFG                         0x00269A94 /* Reset: CORER */
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_FV_IDX_SHIFT            0
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_FV_IDX_MASK             I40E_MASK(0x3F, I40E_GL_PRE_MNG_ARP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_TR_IDX_SHIFT            13
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_TR_IDX_MASK             I40E_MASK(0x3F, I40E_GL_PRE_MNG_ARP_FLD_CFG_TR_IDX_SHIFT)
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_ARP_TAR_IP_FV_IDX_SHIFT 24
#define I40E_GL_PRE_MNG_ARP_FLD_CFG_ARP_TAR_IP_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_ARP_FLD_CFG_ARP_TAR_IP_FV_IDX_SHIFT)

#define I40E_GL_PRE_MNG_ETH_FLD_CFG              0x00269ABC /* Reset: CORER */
#define I40E_GL_PRE_MNG_ETH_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_ETH_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_ETH_FLD_CFG_FV_IDX_SHIFT)

#define I40E_GL_PRE_MNG_ICMP_FLD_CFG              0x00269A9C /* Reset: CORER */
#define I40E_GL_PRE_MNG_ICMP_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_ICMP_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_ICMP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_ICMP_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_ICMP_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_ICMP_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_IP4_FLD_CFG              0x00269AB4 /* Reset: CORER */
#define I40E_GL_PRE_MNG_IP4_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_IP4_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_IP4_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_IP4_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_IP4_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_IP4_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_IP6_FLD_CFG              0x00269A7C /* Reset: CORER */
#define I40E_GL_PRE_MNG_IP6_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_IP6_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_IP6_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_IP6_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_IP6_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_IP6_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_MAC_FLD_CFG              0x00269A8C /* Reset: CORER */
#define I40E_GL_PRE_MNG_MAC_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_MAC_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_MAC_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_MAC_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_MAC_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_MAC_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_MLD_FLD_CFG              0x00269A6C /* Reset: CORER */
#define I40E_GL_PRE_MNG_MLD_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_MLD_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_MLD_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_MLD_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_MLD_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_MLD_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_TCPDP_FLD_CFG              0x00269A74 /* Reset: CORER */
#define I40E_GL_PRE_MNG_TCPDP_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_TCPDP_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_TCPDP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_TCPDP_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_TCPDP_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_TCPDP_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_TCPSP_FLD_CFG              0x00269AA4 /* Reset: CORER */
#define I40E_GL_PRE_MNG_TCPSP_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_TCPSP_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_TCPSP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_TCPSP_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_TCPSP_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_TCPSP_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_UDPDP_FLD_CFG              0x00269AAC /* Reset: CORER */
#define I40E_GL_PRE_MNG_UDPDP_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_UDPDP_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_UDPDP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_UDPDP_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_UDPDP_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_UDPDP_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_UDPSP_FLD_CFG              0x00269AC4 /* Reset: CORER */
#define I40E_GL_PRE_MNG_UDPSP_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_UDPSP_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_UDPSP_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_UDPSP_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_UDPSP_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_UDPSP_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_MNG_VLAN_FLD_CFG              0x00269A84 /* Reset: CORER */
#define I40E_GL_PRE_MNG_VLAN_FLD_CFG_FV_IDX_SHIFT 0
#define I40E_GL_PRE_MNG_VLAN_FLD_CFG_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_VLAN_FLD_CFG_FV_IDX_SHIFT)
#define I40E_GL_PRE_MNG_VLAN_FLD_CFG_TR_IDX_SHIFT 13
#define I40E_GL_PRE_MNG_VLAN_FLD_CFG_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_MNG_VLAN_FLD_CFG_TR_IDX_SHIFT)

#define I40E_GL_PRE_PRX_BIG_ENT_D2                 0x002699EC /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_ENT_D2_USE_PORT_SHIFT  7
#define I40E_GL_PRE_PRX_BIG_ENT_D2_USE_PORT_MASK   I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D2_USE_PORT_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D2_TR_EN_SHIFT     8
#define I40E_GL_PRE_PRX_BIG_ENT_D2_TR_EN_MASK      I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D2_TR_EN_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK0_SHIFT 16
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK0_MASK  I40E_MASK(0xF, I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK0_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK1_SHIFT 20
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK1_MASK  I40E_MASK(0xF, I40E_GL_PRE_PRX_BIG_ENT_D2_BYTE_MSK1_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BIT_MSK0_SHIFT  24
#define I40E_GL_PRE_PRX_BIG_ENT_D2_BIT_MSK0_MASK   I40E_MASK(0xFF, I40E_GL_PRE_PRX_BIG_ENT_D2_BIT_MSK0_SHIFT)

#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D0          0x00269A1C /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D0_H0_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D0_H0_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_BIG_HSH_KEY_D0_H0_SHIFT)

#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D2          0x00269A3C /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D2_H2_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D2_H2_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_BIG_HSH_KEY_D2_H2_SHIFT)

#define I40E_GL_PRE_PRX_FLU_CTL                0x00269974 /* Reset: CORER */
#define I40E_GL_PRE_PRX_FLU_CTL_FLU_MODE_SHIFT 0
#define I40E_GL_PRE_PRX_FLU_CTL_FLU_MODE_MASK  I40E_MASK(0xF, I40E_GL_PRE_PRX_FLU_CTL_FLU_MODE_SHIFT)
#define I40E_GL_PRE_PRX_FLU_CTL_FLU_OVTH_SHIFT 8
#define I40E_GL_PRE_PRX_FLU_CTL_FLU_OVTH_MASK  I40E_MASK(0xFF, I40E_GL_PRE_PRX_FLU_CTL_FLU_OVTH_SHIFT)

#define I40E_GL_PRE_PRX_GEN_CFG                     0x002699AC /* Reset: CORER */
#define I40E_GL_PRE_PRX_GEN_CFG_FILTER_ENABLE_SHIFT 0
#define I40E_GL_PRE_PRX_GEN_CFG_FILTER_ENABLE_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_GEN_CFG_FILTER_ENABLE_SHIFT)
#define I40E_GL_PRE_PRX_GEN_CFG_HASH_MODE_SHIFT     6
#define I40E_GL_PRE_PRX_GEN_CFG_HASH_MODE_MASK      I40E_MASK(0x3, I40E_GL_PRE_PRX_GEN_CFG_HASH_MODE_SHIFT)

#define I40E_GL_PRE_PRX_HSH_KEY_D1          0x00269A2C /* Reset: CORER */
#define I40E_GL_PRE_PRX_HSH_KEY_D1_H1_SHIFT 0
#define I40E_GL_PRE_PRX_HSH_KEY_D1_H1_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_HSH_KEY_D1_H1_SHIFT)

#define I40E_GL_PRE_PRX_HSH_KEY_D2          0x00269A44 /* Reset: CORER */
#define I40E_GL_PRE_PRX_HSH_KEY_D2_H2_SHIFT 0
#define I40E_GL_PRE_PRX_HSH_KEY_D2_H2_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_HSH_KEY_D2_H2_SHIFT)

#define I40E_GL_PRE_PRX_HSH_KEY_D3          0x00269A4C /* Reset: CORER */
#define I40E_GL_PRE_PRX_HSH_KEY_D3_H3_SHIFT 0
#define I40E_GL_PRE_PRX_HSH_KEY_D3_H3_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_HSH_KEY_D3_H3_SHIFT)

#define I40E_GL_PRE_RDMABM_FLD_CFG                     0x002699B4 /* Reset: CORER */
#define I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_FV_IDX_SHIFT 0
#define I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_FV_IDX_SHIFT)
#define I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_TR_IDX_SHIFT 6
#define I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_RDMABM_FLD_CFG_TCP_DP_TR_IDX_SHIFT)
#define I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_FV_IDX_SHIFT 16
#define I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_FV_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_FV_IDX_SHIFT)
#define I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_TR_IDX_SHIFT 22
#define I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_TR_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_RDMABM_FLD_CFG_UDP_DP_TR_IDX_SHIFT)

#define I40E_GL_PRE_TR_MAN(_i)               (0x00269F80 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_PRE_TR_MAN_MAX_INDEX         7
#define I40E_GL_PRE_TR_MAN_SRC_TR_IDX0_SHIFT 0
#define I40E_GL_PRE_TR_MAN_SRC_TR_IDX0_MASK  I40E_MASK(0x3F, I40E_GL_PRE_TR_MAN_SRC_TR_IDX0_SHIFT)
#define I40E_GL_PRE_TR_MAN_SRC_TR_IDX1_SHIFT 8
#define I40E_GL_PRE_TR_MAN_SRC_TR_IDX1_MASK  I40E_MASK(0x3F, I40E_GL_PRE_TR_MAN_SRC_TR_IDX1_SHIFT)
#define I40E_GL_PRE_TR_MAN_TR_MAN_OP_SHIFT   16
#define I40E_GL_PRE_TR_MAN_TR_MAN_OP_MASK    I40E_MASK(0x3, I40E_GL_PRE_TR_MAN_TR_MAN_OP_SHIFT)
#define I40E_GL_PRE_TR_MAN_TR_MAN_NEG_SHIFT  18
#define I40E_GL_PRE_TR_MAN_TR_MAN_NEG_MASK   I40E_MASK(0x1, I40E_GL_PRE_TR_MAN_TR_MAN_NEG_SHIFT)

#define I40E_GL_PRS_FRT(_i)            (0x00269750 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GL_PRS_FRT_MAX_INDEX      3
#define I40E_GL_PRS_FRT_FV_IDX_0_SHIFT 0
#define I40E_GL_PRS_FRT_FV_IDX_0_MASK  I40E_MASK(0x3FF, I40E_GL_PRS_FRT_FV_IDX_0_SHIFT)
#define I40E_GL_PRS_FRT_FV_IDX_1_SHIFT 16
#define I40E_GL_PRS_FRT_FV_IDX_1_MASK  I40E_MASK(0x3FF, I40E_GL_PRS_FRT_FV_IDX_1_SHIFT)

#define I40E_GL_PRS_L2LEN               0x0026996C /* Reset: CORER */
#define I40E_GL_PRS_L2LEN_MAC_LEN_SHIFT 8
#define I40E_GL_PRS_L2LEN_MAC_LEN_MASK  I40E_MASK(0xFF, I40E_GL_PRS_L2LEN_MAC_LEN_SHIFT)

#define I40E_GL_PRS_PL_THR                     0x00269FE4 /* Reset: CORER */
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P0_SHIFT 0
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P0_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PL_THR_PIPE_LIMIT_P0_SHIFT)
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P1_SHIFT 8
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P1_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PL_THR_PIPE_LIMIT_P1_SHIFT)
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P2_SHIFT 16
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P2_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PL_THR_PIPE_LIMIT_P2_SHIFT)
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P3_SHIFT 24
#define I40E_GL_PRS_PL_THR_PIPE_LIMIT_P3_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PL_THR_PIPE_LIMIT_P3_SHIFT)

#define I40E_GL_PRS_PM_PORT_THR                  0x00269FC4 /* Reset: CORER */
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_0_SHIFT 0
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_0_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_PORT_THR_THR_PORT_0_SHIFT)
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_1_SHIFT 8
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_1_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_PORT_THR_THR_PORT_1_SHIFT)
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_2_SHIFT 16
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_2_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_PORT_THR_THR_PORT_2_SHIFT)
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_3_SHIFT 24
#define I40E_GL_PRS_PM_PORT_THR_THR_PORT_3_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_PORT_THR_THR_PORT_3_SHIFT)

#define I40E_GL_PRS_PM_UP_THR                 0x00269FCC /* Reset: CORER */
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_0_SHIFT 0
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_0_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_UP_THR_UP_PORT_0_SHIFT)
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_1_SHIFT 8
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_1_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_UP_THR_UP_PORT_1_SHIFT)
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_2_SHIFT 16
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_2_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_UP_THR_UP_PORT_2_SHIFT)
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_3_SHIFT 24
#define I40E_GL_PRS_PM_UP_THR_UP_PORT_3_MASK  I40E_MASK(0xFF, I40E_GL_PRS_PM_UP_THR_UP_PORT_3_SHIFT)

#define I40E_GL_RXA_CFG                     0x00269944 /* Reset: CORER */
#define I40E_GL_RXA_CFG_UP_STRICT_PR_SHIFT  0
#define I40E_GL_RXA_CFG_UP_STRICT_PR_MASK   I40E_MASK(0xF, I40E_GL_RXA_CFG_UP_STRICT_PR_SHIFT)
#define I40E_GL_RXA_CFG_PRT_STRICT_PR_SHIFT 4
#define I40E_GL_RXA_CFG_PRT_STRICT_PR_MASK  I40E_MASK(0x1, I40E_GL_RXA_CFG_PRT_STRICT_PR_SHIFT)
#define I40E_GL_RXA_CFG_MIN_HDR_LEN_SHIFT   8
#define I40E_GL_RXA_CFG_MIN_HDR_LEN_MASK    I40E_MASK(0x7F, I40E_GL_RXA_CFG_MIN_HDR_LEN_SHIFT)
#define I40E_GL_RXA_CFG_MAX_HDR_LEN_SHIFT   15
#define I40E_GL_RXA_CFG_MAX_HDR_LEN_MASK    I40E_MASK(0x7F, I40E_GL_RXA_CFG_MAX_HDR_LEN_SHIFT)

#define I40E_GL_SWR_DP                 0x00269998 /* Reset: CORER */
#define I40E_GL_SWR_DP_DUAL_PORT_SHIFT 0
#define I40E_GL_SWR_DP_DUAL_PORT_MASK  I40E_MASK(0x1, I40E_GL_SWR_DP_DUAL_PORT_SHIFT)

#define I40E_GL_SWR_MAC_AS_FLU_ID(_i)               (0x00269BE8 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GL_SWR_MAC_AS_FLU_ID_MAX_INDEX         1
#define I40E_GL_SWR_MAC_AS_FLU_ID_FLU_INDEXES_SHIFT 0
#define I40E_GL_SWR_MAC_AS_FLU_ID_FLU_INDEXES_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_MAC_AS_FLU_ID_FLU_INDEXES_SHIFT)

#define I40E_GL_SWR_MIM_DBG_CTL                  0x00269FE8 /* Reset: CORER */
#define I40E_GL_SWR_MIM_DBG_CTL_ADDR_SHIFT       0
#define I40E_GL_SWR_MIM_DBG_CTL_ADDR_MASK        I40E_MASK(0x1FF, I40E_GL_SWR_MIM_DBG_CTL_ADDR_SHIFT)
#define I40E_GL_SWR_MIM_DBG_CTL_DW_SEL_SHIFT     16
#define I40E_GL_SWR_MIM_DBG_CTL_DW_SEL_MASK      I40E_MASK(0x3F, I40E_GL_SWR_MIM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_GL_SWR_MIM_DBG_CTL_TARGET_SEL_SHIFT 24
#define I40E_GL_SWR_MIM_DBG_CTL_TARGET_SEL_MASK  I40E_MASK(0x7, I40E_GL_SWR_MIM_DBG_CTL_TARGET_SEL_SHIFT)
#define I40E_GL_SWR_MIM_DBG_CTL_BLOCK_PRSR_SHIFT 31
#define I40E_GL_SWR_MIM_DBG_CTL_BLOCK_PRSR_MASK  I40E_MASK(0x1, I40E_GL_SWR_MIM_DBG_CTL_BLOCK_PRSR_SHIFT)

#define I40E_GL_SWR_MIM_DBG_STS                          0x00269FEC /* Reset: CORER */
#define I40E_GL_SWR_MIM_DBG_STS_GL_SWR_MIM_DBG_STS_SHIFT 0
#define I40E_GL_SWR_MIM_DBG_STS_GL_SWR_MIM_DBG_STS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_MIM_DBG_STS_GL_SWR_MIM_DBG_STS_SHIFT)

#define I40E_GL_SWR_PM_PORT_THR                  0x00269FB4 /* Reset: CORER */
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_0_SHIFT 0
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_0_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_PORT_THR_THR_PORT_0_SHIFT)
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_1_SHIFT 8
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_1_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_PORT_THR_THR_PORT_1_SHIFT)
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_2_SHIFT 16
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_2_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_PORT_THR_THR_PORT_2_SHIFT)
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_3_SHIFT 24
#define I40E_GL_SWR_PM_PORT_THR_THR_PORT_3_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_PORT_THR_THR_PORT_3_SHIFT)

#define I40E_GL_SWR_REP_FLU_CTL                0x0026995C /* Reset: CORER */
#define I40E_GL_SWR_REP_FLU_CTL_FLU_MODE_SHIFT 0
#define I40E_GL_SWR_REP_FLU_CTL_FLU_MODE_MASK  I40E_MASK(0xF, I40E_GL_SWR_REP_FLU_CTL_FLU_MODE_SHIFT)
#define I40E_GL_SWR_REP_FLU_CTL_FLU_OVTH_SHIFT 8
#define I40E_GL_SWR_REP_FLU_CTL_FLU_OVTH_MASK  I40E_MASK(0xFF, I40E_GL_SWR_REP_FLU_CTL_FLU_OVTH_SHIFT)

#define I40E_GL_SWR_REP_MFIFO_CTL                     0x00269994 /* Reset: CORER */
#define I40E_GL_SWR_REP_MFIFO_CTL_UP_STRICT_PR_SHIFT  0
#define I40E_GL_SWR_REP_MFIFO_CTL_UP_STRICT_PR_MASK   I40E_MASK(0xF, I40E_GL_SWR_REP_MFIFO_CTL_UP_STRICT_PR_SHIFT)
#define I40E_GL_SWR_REP_MFIFO_CTL_PRT_STRICT_PR_SHIFT 4
#define I40E_GL_SWR_REP_MFIFO_CTL_PRT_STRICT_PR_MASK  I40E_MASK(0x1, I40E_GL_SWR_REP_MFIFO_CTL_PRT_STRICT_PR_SHIFT)
#define I40E_GL_SWR_REP_MFIFO_CTL_SPARE27B_SHIFT      5
#define I40E_GL_SWR_REP_MFIFO_CTL_SPARE27B_MASK       I40E_MASK(0x7FFFFFF, I40E_GL_SWR_REP_MFIFO_CTL_SPARE27B_SHIFT)

#define I40E_GLCM_LAN_CACHE0_MEM_CFG                    0x0010C48C /* Reset: POR */
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_A_SHIFT        12
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_A_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_B_SHIFT        13
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_CFG_RME_B_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_A_SHIFT         16
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_A_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_B_SHIFT         20
#define I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_CACHE0_MEM_CFG_RM_B_SHIFT)

#define I40E_GLCM_LAN_CACHE0_MEM_STATUS                        0x0010C490 /* Reset: POR */
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_CACHE0_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE0_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_CACHE1_MEM_CFG                    0x0010C494 /* Reset: POR */
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_A_SHIFT        12
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_A_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_B_SHIFT        13
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_CFG_RME_B_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_A_SHIFT         16
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_A_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_B_SHIFT         20
#define I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_CACHE1_MEM_CFG_RM_B_SHIFT)

#define I40E_GLCM_LAN_CACHE1_MEM_STATUS                        0x0010C498 /* Reset: POR */
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_CACHE1_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_CACHE1_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_DBELL_MEM_CFG                    0x0010C49C /* Reset: POR */
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_DBELL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_DBELL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_DBELL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_DBELL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_DBELL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RME_A_SHIFT        12
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_RME_A_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RME_B_SHIFT        13
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_CFG_RME_B_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RM_A_SHIFT         16
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_DBELL_MEM_CFG_RM_A_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RM_B_SHIFT         20
#define I40E_GLCM_LAN_DBELL_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_DBELL_MEM_CFG_RM_B_SHIFT)

#define I40E_GLCM_LAN_DBELL_MEM_STATUS                        0x0010C4A0 /* Reset: POR */
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_DBELL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_DBELL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_ECC_COR_ERR           0x0010C4D0 /* Reset: POR */
#define I40E_GLCM_LAN_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_GLCM_LAN_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLCM_LAN_ECC_COR_ERR_CNT_SHIFT)

#define I40E_GLCM_LAN_ECC_UNCOR_ERR           0x0010C4CC /* Reset: POR */
#define I40E_GLCM_LAN_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_GLCM_LAN_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_GLCM_LAN_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG                    0x0010C4A4 /* Reset: POR */
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RME_SHIFT          12
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RME_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RM_SHIFT           16
#define I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_GLCM_LAN_EVICTBUF_MEM_CFG_RM_SHIFT)

#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS                        0x0010C4A8 /* Reset: POR */
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_EVICTBUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_FILLBUF_MEM_CFG                    0x0010C4AC /* Reset: POR */
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_RME_SHIFT          12
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_CFG_RME_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_RM_SHIFT           16
#define I40E_GLCM_LAN_FILLBUF_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_GLCM_LAN_FILLBUF_MEM_CFG_RM_SHIFT)

#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS                        0x0010C4B0 /* Reset: POR */
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_FILLBUF_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_FILLBUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_QTXCTL_MEM_CFG                    0x0010C4BC /* Reset: POR */
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_RME_SHIFT          12
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_CFG_RME_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_RM_SHIFT           16
#define I40E_GLCM_LAN_QTXCTL_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_GLCM_LAN_QTXCTL_MEM_CFG_RM_SHIFT)

#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS                        0x0010C4C0 /* Reset: POR */
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_QTXCTL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_QTXCTL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_RDYLIST_MEM_CFG                    0x0010C4B4 /* Reset: POR */
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_RME_SHIFT          12
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_CFG_RME_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_RM_SHIFT           16
#define I40E_GLCM_LAN_RDYLIST_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_GLCM_LAN_RDYLIST_MEM_CFG_RM_SHIFT)

#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS                        0x0010C4B8 /* Reset: POR */
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_RDYLIST_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_RDYLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLCM_LAN_TAILPTR_MEM_CFG                    0x0010C4C4 /* Reset: POR */
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_EN_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_MASK_INT_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_A_SHIFT        12
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_A_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_B_SHIFT        13
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_CFG_RME_B_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_A_SHIFT         16
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_A_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_B_SHIFT         20
#define I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_GLCM_LAN_TAILPTR_MEM_CFG_RM_B_SHIFT)

#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS                        0x0010C4C8 /* Reset: POR */
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_GLCM_LAN_TAILPTR_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_GLCM_LAN_TAILPTR_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_GLDFT_NCSI_PADS_CFG                       0x0009408C /* Reset: POR */
#define I40E_GLDFT_NCSI_PADS_CFG_GLNCSI_PADS_CFG_SHIFT 0
#define I40E_GLDFT_NCSI_PADS_CFG_GLNCSI_PADS_CFG_MASK  I40E_MASK(0x1, I40E_GLDFT_NCSI_PADS_CFG_GLNCSI_PADS_CFG_SHIFT)

#define I40E_GLDFT_TS_STAT                       0x00094080 /* Reset: POR */
#define I40E_GLDFT_TS_STAT_SBL_THERM_IND_SHIFT   0
#define I40E_GLDFT_TS_STAT_SBL_THERM_IND_MASK    I40E_MASK(0x7, I40E_GLDFT_TS_STAT_SBL_THERM_IND_SHIFT)
#define I40E_GLDFT_TS_STAT_SBT_THERM_VAL_SHIFT   3
#define I40E_GLDFT_TS_STAT_SBT_THERM_VAL_MASK    I40E_MASK(0x1FF, I40E_GLDFT_TS_STAT_SBT_THERM_VAL_SHIFT)
#define I40E_GLDFT_TS_STAT_SBT_THERM_VALID_SHIFT 31
#define I40E_GLDFT_TS_STAT_SBT_THERM_VALID_MASK  I40E_MASK(0x1, I40E_GLDFT_TS_STAT_SBT_THERM_VALID_SHIFT)

#define I40E_GLDFT_VISA_CTRL                    0x00094084 /* Reset: POR */
#define I40E_GLDFT_VISA_CTRL_VISA_INDEX_SHIFT   0
#define I40E_GLDFT_VISA_CTRL_VISA_INDEX_MASK    I40E_MASK(0x1F, I40E_GLDFT_VISA_CTRL_VISA_INDEX_SHIFT)
#define I40E_GLDFT_VISA_CTRL_VISA_UNIT_ID_SHIFT 5
#define I40E_GLDFT_VISA_CTRL_VISA_UNIT_ID_MASK  I40E_MASK(0x1FF, I40E_GLDFT_VISA_CTRL_VISA_UNIT_ID_SHIFT)
#define I40E_GLDFT_VISA_CTRL_VISA_OPCODE_SHIFT  31
#define I40E_GLDFT_VISA_CTRL_VISA_OPCODE_MASK   I40E_MASK(0x1, I40E_GLDFT_VISA_CTRL_VISA_OPCODE_SHIFT)

#define I40E_GLDFT_VISA_DATA                       0x00094088 /* Reset: POR */
#define I40E_GLDFT_VISA_DATA_GLDFT_VISA_DATA_SHIFT 0
#define I40E_GLDFT_VISA_DATA_GLDFT_VISA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLDFT_VISA_DATA_GLDFT_VISA_DATA_SHIFT)

#define I40E_GLDFT_VISA_DISABLE                             0x00094098 /* Reset: POR */
#define I40E_GLDFT_VISA_DISABLE_VISA_CUSTOMER_DISABLE_SHIFT 0
#define I40E_GLDFT_VISA_DISABLE_VISA_CUSTOMER_DISABLE_MASK  I40E_MASK(0x1, I40E_GLDFT_VISA_DISABLE_VISA_CUSTOMER_DISABLE_SHIFT)
#define I40E_GLDFT_VISA_DISABLE_VISA_ALL_DISABLE_SHIFT      1
#define I40E_GLDFT_VISA_DISABLE_VISA_ALL_DISABLE_MASK       I40E_MASK(0x1, I40E_GLDFT_VISA_DISABLE_VISA_ALL_DISABLE_SHIFT)

#define I40E_GLDFT_VISA_LANE_LSB                           0x00094090 /* Reset: POR */
#define I40E_GLDFT_VISA_LANE_LSB_GLDFT_VISA_LANE_LSB_SHIFT 0
#define I40E_GLDFT_VISA_LANE_LSB_GLDFT_VISA_LANE_LSB_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLDFT_VISA_LANE_LSB_GLDFT_VISA_LANE_LSB_SHIFT)

#define I40E_GLDFT_VISA_LANE_MSB                           0x00094094 /* Reset: POR */
#define I40E_GLDFT_VISA_LANE_MSB_GLDFT_VISA_LANE_MSB_SHIFT 0
#define I40E_GLDFT_VISA_LANE_MSB_GLDFT_VISA_LANE_MSB_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLDFT_VISA_LANE_MSB_GLDFT_VISA_LANE_MSB_SHIFT)

#define I40E_GLLAN_TCB_STAT               0x000AE0D0 /* Reset: CORER */
#define I40E_GLLAN_TCB_STAT_LL_STAT_SHIFT 0
#define I40E_GLLAN_TCB_STAT_LL_STAT_MASK  I40E_MASK(0xFFFF, I40E_GLLAN_TCB_STAT_LL_STAT_SHIFT)
#define I40E_GLLAN_TCB_STAT_RSV_SHIFT     16
#define I40E_GLLAN_TCB_STAT_RSV_MASK      I40E_MASK(0xFFFF, I40E_GLLAN_TCB_STAT_RSV_SHIFT)

#define I40E_GLPCI_CLKCTL                      0x000B819C /* Reset: POR */
#define I40E_GLPCI_CLKCTL_PCI_CLK_DYN_SHIFT    0
#define I40E_GLPCI_CLKCTL_PCI_CLK_DYN_MASK     I40E_MASK(0x1, I40E_GLPCI_CLKCTL_PCI_CLK_DYN_SHIFT)
#define I40E_GLPCI_CLKCTL_PCI_CLK_STABLE_SHIFT 1
#define I40E_GLPCI_CLKCTL_PCI_CLK_STABLE_MASK  I40E_MASK(0x1, I40E_GLPCI_CLKCTL_PCI_CLK_STABLE_SHIFT)

#define I40E_GLPCI_MCTP_CREDIT              0x000BE4EC /* Reset: PCIR */
#define I40E_GLPCI_MCTP_CREDIT_HEADER_SHIFT 0
#define I40E_GLPCI_MCTP_CREDIT_HEADER_MASK  I40E_MASK(0xFF, I40E_GLPCI_MCTP_CREDIT_HEADER_SHIFT)
#define I40E_GLPCI_MCTP_CREDIT_DATA_SHIFT   8
#define I40E_GLPCI_MCTP_CREDIT_DATA_MASK    I40E_MASK(0xFFF, I40E_GLPCI_MCTP_CREDIT_DATA_SHIFT)

#define I40E_GLPCI_MCTP_MASK_0                         0x000BE4C4 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_MASK_0_GLPCI_MCTP_MASK_0_SHIFT 0
#define I40E_GLPCI_MCTP_MASK_0_GLPCI_MCTP_MASK_0_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_MASK_0_GLPCI_MCTP_MASK_0_SHIFT)

#define I40E_GLPCI_MCTP_MASK_1                         0x000BE4C8 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_MASK_1_GLPCI_MCTP_MASK_1_SHIFT 0
#define I40E_GLPCI_MCTP_MASK_1_GLPCI_MCTP_MASK_1_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_MASK_1_GLPCI_MCTP_MASK_1_SHIFT)

#define I40E_GLPCI_MCTP_MASK_2                         0x000BE4CC /* Reset: PCIR */
#define I40E_GLPCI_MCTP_MASK_2_GLPCI_MCTP_MASK_2_SHIFT 0
#define I40E_GLPCI_MCTP_MASK_2_GLPCI_MCTP_MASK_2_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_MASK_2_GLPCI_MCTP_MASK_2_SHIFT)

#define I40E_GLPCI_MCTP_MASK_3                         0x000BE4D0 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_MASK_3_GLPCI_MCTP_MASK_3_SHIFT 0
#define I40E_GLPCI_MCTP_MASK_3_GLPCI_MCTP_MASK_3_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_MASK_3_GLPCI_MCTP_MASK_3_SHIFT)

#define I40E_GLPCI_MCTP_MAX_PAY                          0x000BE4E8 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_MAX_PAY_GLPCI_MCTP_MAX_PAY_SHIFT 0
#define I40E_GLPCI_MCTP_MAX_PAY_GLPCI_MCTP_MAX_PAY_MASK  I40E_MASK(0x7FF, I40E_GLPCI_MCTP_MAX_PAY_GLPCI_MCTP_MAX_PAY_SHIFT)

#define I40E_GLPCI_MCTP_VAL_0                        0x000BE4D4 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_VAL_0_GLPCI_MCTP_VAL_0_SHIFT 0
#define I40E_GLPCI_MCTP_VAL_0_GLPCI_MCTP_VAL_0_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_VAL_0_GLPCI_MCTP_VAL_0_SHIFT)

#define I40E_GLPCI_MCTP_VAL_1                        0x000BE4D8 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_VAL_1_GLPCI_MCTP_VAL_1_SHIFT 0
#define I40E_GLPCI_MCTP_VAL_1_GLPCI_MCTP_VAL_1_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_VAL_1_GLPCI_MCTP_VAL_1_SHIFT)

#define I40E_GLPCI_MCTP_VAL_2                        0x000BE4DC /* Reset: PCIR */
#define I40E_GLPCI_MCTP_VAL_2_GLPCI_MCTP_VAL_2_SHIFT 0
#define I40E_GLPCI_MCTP_VAL_2_GLPCI_MCTP_VAL_2_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_VAL_2_GLPCI_MCTP_VAL_2_SHIFT)

#define I40E_GLPCI_MCTP_VAL_3                        0x000BE4E0 /* Reset: PCIR */
#define I40E_GLPCI_MCTP_VAL_3_GLPCI_MCTP_VAL_3_SHIFT 0
#define I40E_GLPCI_MCTP_VAL_3_GLPCI_MCTP_VAL_3_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_MCTP_VAL_3_GLPCI_MCTP_VAL_3_SHIFT)

#define I40E_GLPCI_OSR_LIMIT                 0x000BE504 /* Reset: PCIR */
#define I40E_GLPCI_OSR_LIMIT_OSR_LIMIT_SHIFT 0
#define I40E_GLPCI_OSR_LIMIT_OSR_LIMIT_MASK  I40E_MASK(0xFF, I40E_GLPCI_OSR_LIMIT_OSR_LIMIT_SHIFT)

#define I40E_GLPCI_PHY_SPARE_IN                    0x000BE508 /* Reset: POR */
#define I40E_GLPCI_PHY_SPARE_IN_DIG_IN_SPARE_SHIFT 0
#define I40E_GLPCI_PHY_SPARE_IN_DIG_IN_SPARE_MASK  I40E_MASK(0x3FF, I40E_GLPCI_PHY_SPARE_IN_DIG_IN_SPARE_SHIFT)

#define I40E_GLPCI_PHY_SPARE_OUT                           0x000BE50C /* Reset: POR */
#define I40E_GLPCI_PHY_SPARE_OUT_TAMAR_DIG_OUT_SPARE_SHIFT 0
#define I40E_GLPCI_PHY_SPARE_OUT_TAMAR_DIG_OUT_SPARE_MASK  I40E_MASK(0x3FF, I40E_GLPCI_PHY_SPARE_OUT_TAMAR_DIG_OUT_SPARE_SHIFT)

#define I40E_GLPCI_SHUTDOWN_DIS                    0x000BE4F0 /* Reset: PCIR */
#define I40E_GLPCI_SHUTDOWN_DIS_SHUTDOWN_DIS_SHIFT 0
#define I40E_GLPCI_SHUTDOWN_DIS_SHUTDOWN_DIS_MASK  I40E_MASK(0x1, I40E_GLPCI_SHUTDOWN_DIS_SHUTDOWN_DIS_SHIFT)

#define I40E_GLPCI_SPARE1                               0x000BE510 /* Reset: POR */
#define I40E_GLPCI_SPARE1_WU_COMPLIANT_CB_SHIFT         0
#define I40E_GLPCI_SPARE1_WU_COMPLIANT_CB_MASK          I40E_MASK(0x1, I40E_GLPCI_SPARE1_WU_COMPLIANT_CB_SHIFT)
#define I40E_GLPCI_SPARE1_BYPASS_SIDEBAND_SHIFT         1
#define I40E_GLPCI_SPARE1_BYPASS_SIDEBAND_MASK          I40E_MASK(0x1, I40E_GLPCI_SPARE1_BYPASS_SIDEBAND_SHIFT)
#define I40E_GLPCI_SPARE1_PFR_EN_SHIFT                  2
#define I40E_GLPCI_SPARE1_PFR_EN_MASK                   I40E_MASK(0x1, I40E_GLPCI_SPARE1_PFR_EN_SHIFT)
#define I40E_GLPCI_SPARE1_DISABLE_DUMMY_COMP_0ING_SHIFT 3
#define I40E_GLPCI_SPARE1_DISABLE_DUMMY_COMP_0ING_MASK  I40E_MASK(0x1, I40E_GLPCI_SPARE1_DISABLE_DUMMY_COMP_0ING_SHIFT)
#define I40E_GLPCI_SPARE1_ROM_EMPR_TRIGGER_SHIFT        4
#define I40E_GLPCI_SPARE1_ROM_EMPR_TRIGGER_MASK         I40E_MASK(0x1, I40E_GLPCI_SPARE1_ROM_EMPR_TRIGGER_SHIFT)
#define I40E_GLPCI_SPARE1_DISABLE_PFR_ON_BME_SHIFT      5
#define I40E_GLPCI_SPARE1_DISABLE_PFR_ON_BME_MASK       I40E_MASK(0x1, I40E_GLPCI_SPARE1_DISABLE_PFR_ON_BME_SHIFT)
#define I40E_GLPCI_SPARE1_TAG_RELEASE_ON_ARRIVE_SHIFT   6
#define I40E_GLPCI_SPARE1_TAG_RELEASE_ON_ARRIVE_MASK    I40E_MASK(0x1, I40E_GLPCI_SPARE1_TAG_RELEASE_ON_ARRIVE_SHIFT)
#define I40E_GLPCI_SPARE1_IOSF_ARB_PIPEM_MODE_SHIFT     7
#define I40E_GLPCI_SPARE1_IOSF_ARB_PIPEM_MODE_MASK      I40E_MASK(0x1, I40E_GLPCI_SPARE1_IOSF_ARB_PIPEM_MODE_SHIFT)
#define I40E_GLPCI_SPARE1_PCIE_MAX_OS_DATA_SHIFT        8
#define I40E_GLPCI_SPARE1_PCIE_MAX_OS_DATA_MASK         I40E_MASK(0x1FFFF, I40E_GLPCI_SPARE1_PCIE_MAX_OS_DATA_SHIFT)
#define I40E_GLPCI_SPARE1_SPARE_SHIFT                   25
#define I40E_GLPCI_SPARE1_SPARE_MASK                    I40E_MASK(0x7F, I40E_GLPCI_SPARE1_SPARE_SHIFT)

#define I40E_GLPCI_SPARE2             0x000BE514 /* Reset: POR */
#define I40E_GLPCI_SPARE2_SPARE_SHIFT 0
#define I40E_GLPCI_SPARE2_SPARE_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_SPARE2_SPARE_SHIFT)

#define I40E_GLQF_ABORT_MASK(_i)                   (0x0026CCC8 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLQF_ABORT_MASK_MAX_INDEX             1
#define I40E_GLQF_ABORT_MASK_GLQF_ABORT_MASK_SHIFT 0
#define I40E_GLQF_ABORT_MASK_GLQF_ABORT_MASK_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_ABORT_MASK_GLQF_ABORT_MASK_SHIFT)

#define I40E_GLQF_L2_MAP(_i)               (0x0026CBF8 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLQF_L2_MAP_MAX_INDEX         1
#define I40E_GLQF_L2_MAP_GLQF_L2_MAP_SHIFT 0
#define I40E_GLQF_L2_MAP_GLQF_L2_MAP_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_L2_MAP_GLQF_L2_MAP_SHIFT)

#define I40E_GLQF_L3_MAP(_i)                (0x0026C700 + ((_i) * 4)) /* _i=0...63 */ /* Reset: CORER */
#define I40E_GLQF_L3_MAP_MAX_INDEX          63
#define I40E_GLQF_L3_MAP_TR_IDX_CODE_SHIFT  0
#define I40E_GLQF_L3_MAP_TR_IDX_CODE_MASK   I40E_MASK(0x3F, I40E_GLQF_L3_MAP_TR_IDX_CODE_SHIFT)
#define I40E_GLQF_L3_MAP_TR_OPCODE_SHIFT    6
#define I40E_GLQF_L3_MAP_TR_OPCODE_MASK     I40E_MASK(0x3, I40E_GLQF_L3_MAP_TR_OPCODE_SHIFT)
#define I40E_GLQF_L3_MAP_MIN_SKIP_GAP_SHIFT 8
#define I40E_GLQF_L3_MAP_MIN_SKIP_GAP_MASK  I40E_MASK(0x7F, I40E_GLQF_L3_MAP_MIN_SKIP_GAP_SHIFT)
#define I40E_GLQF_L3_MAP_MIN_SKIP_ENA_SHIFT 15
#define I40E_GLQF_L3_MAP_MIN_SKIP_ENA_MASK  I40E_MASK(0x1, I40E_GLQF_L3_MAP_MIN_SKIP_ENA_SHIFT)

#define I40E_GLQF_OPT_MAP                   0x0026CBDC /* Reset: CORER */
#define I40E_GLQF_OPT_MAP_FRAG_IDX_SHIFT    0
#define I40E_GLQF_OPT_MAP_FRAG_IDX_MASK     I40E_MASK(0x3F, I40E_GLQF_OPT_MAP_FRAG_IDX_SHIFT)
#define I40E_GLQF_OPT_MAP_IP_OPT_IDX_SHIFT  12
#define I40E_GLQF_OPT_MAP_IP_OPT_IDX_MASK   I40E_MASK(0x3F, I40E_GLQF_OPT_MAP_IP_OPT_IDX_SHIFT)
#define I40E_GLQF_OPT_MAP_TCP_OPT_IDX_SHIFT 18
#define I40E_GLQF_OPT_MAP_TCP_OPT_IDX_MASK  I40E_MASK(0x3F, I40E_GLQF_OPT_MAP_TCP_OPT_IDX_SHIFT)

#define I40E_GLRCB_DBG_CTL                0x00122620 /* Reset: CORER */
#define I40E_GLRCB_DBG_CTL_MEM_ADDR_SHIFT 0
#define I40E_GLRCB_DBG_CTL_MEM_ADDR_MASK  I40E_MASK(0xFFFF, I40E_GLRCB_DBG_CTL_MEM_ADDR_SHIFT)
#define I40E_GLRCB_DBG_CTL_MEM_SEL_SHIFT  16
#define I40E_GLRCB_DBG_CTL_MEM_SEL_MASK   I40E_MASK(0x1F, I40E_GLRCB_DBG_CTL_MEM_SEL_SHIFT)

#define I40E_GLRCB_DBG_DATA0                0x00122628 /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA0_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA0_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA0_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_DATA1                0x0012262C /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA1_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA1_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA1_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_DATA2                0x00122630 /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA2_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA2_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA2_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_DATA3                0x00122634 /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA3_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA3_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA3_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_DATA4                0x00122638 /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA4_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA4_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA4_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_DATA5                0x0012263C /* Reset: CORER */
#define I40E_GLRCB_DBG_DATA5_DBG_DATA_SHIFT 0
#define I40E_GLRCB_DBG_DATA5_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCB_DBG_DATA5_DBG_DATA_SHIFT)

#define I40E_GLRCB_DBG_FEAT                0x0012266C /* Reset: CORER */
#define I40E_GLRCB_DBG_FEAT_SET_DROP_SHIFT 0
#define I40E_GLRCB_DBG_FEAT_SET_DROP_MASK  I40E_MASK(0xF, I40E_GLRCB_DBG_FEAT_SET_DROP_SHIFT)

#define I40E_GLRCB_DBG_RD_STOP           0x00122640 /* Reset: CORER */
#define I40E_GLRCB_DBG_RD_STOP_ENA_SHIFT 0
#define I40E_GLRCB_DBG_RD_STOP_ENA_MASK  I40E_MASK(0x1, I40E_GLRCB_DBG_RD_STOP_ENA_SHIFT)

#define I40E_GLRCB_LL_BP_CFG                0x0012261C /* Reset: CORER */
#define I40E_GLRCB_LL_BP_CFG_MIN_THRS_SHIFT 0
#define I40E_GLRCB_LL_BP_CFG_MIN_THRS_MASK  I40E_MASK(0xFFFF, I40E_GLRCB_LL_BP_CFG_MIN_THRS_SHIFT)
#define I40E_GLRCB_LL_BP_CFG_MAX_THRS_SHIFT 16
#define I40E_GLRCB_LL_BP_CFG_MAX_THRS_MASK  I40E_MASK(0xFFFF, I40E_GLRCB_LL_BP_CFG_MAX_THRS_SHIFT)

#define I40E_GLRCB_TO_1MS_TICK_CFG                    0x00122624 /* Reset: CORER */
#define I40E_GLRCB_TO_1MS_TICK_CFG_UC_DIV_RATIO_SHIFT 0
#define I40E_GLRCB_TO_1MS_TICK_CFG_UC_DIV_RATIO_MASK  I40E_MASK(0xFFFFF, I40E_GLRCB_TO_1MS_TICK_CFG_UC_DIV_RATIO_SHIFT)

#define I40E_GLRLAN_COMPLETION_FIFO_CTL                  0x0012A574 /* Reset: CORER */
#define I40E_GLRLAN_COMPLETION_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_COMPLETION_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_COMPLETION_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DATA_FLUSH_REQ_FIFO_CTL                  0x0012A58C /* Reset: CORER */
#define I40E_GLRLAN_DATA_FLUSH_REQ_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_DATA_FLUSH_REQ_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_DATA_FLUSH_REQ_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DBG_CTL                0x0012A594 /* Reset: CORER */
#define I40E_GLRLAN_DBG_CTL_MEM_ADDR_SHIFT 0
#define I40E_GLRLAN_DBG_CTL_MEM_ADDR_MASK  I40E_MASK(0xFFFF, I40E_GLRLAN_DBG_CTL_MEM_ADDR_SHIFT)
#define I40E_GLRLAN_DBG_CTL_MEM_SEL_SHIFT  16
#define I40E_GLRLAN_DBG_CTL_MEM_SEL_MASK   I40E_MASK(0x1F, I40E_GLRLAN_DBG_CTL_MEM_SEL_SHIFT)

#define I40E_GLRLAN_DBG_DATA0                0x0012A598 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA0_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA0_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA0_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA1                0x0012A59C /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA1_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA1_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA1_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA2                0x0012A5A0 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA2_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA2_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA2_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA3                0x0012A5A4 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA3_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA3_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA3_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA4                0x0012A5A8 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA4_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA4_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA4_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA5                0x0012A5AC /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA5_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA5_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA5_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA6                0x0012A5B0 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA6_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA6_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA6_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DBG_DATA7                0x0012A5B4 /* Reset: CORER */
#define I40E_GLRLAN_DBG_DATA7_DBG_DATA_SHIFT 0
#define I40E_GLRLAN_DBG_DATA7_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DBG_DATA7_DBG_DATA_SHIFT)

#define I40E_GLRLAN_DIX_WB_FIFO_CTL                  0x0012A590 /* Reset: CORER */
#define I40E_GLRLAN_DIX_WB_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_DIX_WB_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_DIX_WB_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DSCR_FETCH_FIFO_CTL                  0x0012A584 /* Reset: CORER */
#define I40E_GLRLAN_DSCR_FETCH_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_DSCR_FETCH_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_DSCR_FETCH_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DSCR_REQ_FIFO_CTL                  0x0012A554 /* Reset: CORER */
#define I40E_GLRLAN_DSCR_REQ_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_DSCR_REQ_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_DSCR_REQ_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DSCR_WR_REQ_FIFO_CTL                  0x0012A57C /* Reset: CORER */
#define I40E_GLRLAN_DSCR_WR_REQ_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_DSCR_WR_REQ_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_DSCR_WR_REQ_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_DUMMY_CNTX_0(_i)              (0x0012A5BC + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLRLAN_DUMMY_CNTX_0_MAX_INDEX        3
#define I40E_GLRLAN_DUMMY_CNTX_0_DUMMY_CNTX_SHIFT 0
#define I40E_GLRLAN_DUMMY_CNTX_0_DUMMY_CNTX_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DUMMY_CNTX_0_DUMMY_CNTX_SHIFT)

#define I40E_GLRLAN_DUMMY_CNTX_1(_i)              (0x0012A5CC + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLRLAN_DUMMY_CNTX_1_MAX_INDEX        3
#define I40E_GLRLAN_DUMMY_CNTX_1_DUMMY_CNTX_SHIFT 0
#define I40E_GLRLAN_DUMMY_CNTX_1_DUMMY_CNTX_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_DUMMY_CNTX_1_DUMMY_CNTX_SHIFT)

#define I40E_GLRLAN_DUMMY_CNTX_ENA                      0x0012A5DC /* Reset: CORER */
#define I40E_GLRLAN_DUMMY_CNTX_ENA_DUMMY_CNTX_ENA_SHIFT 0
#define I40E_GLRLAN_DUMMY_CNTX_ENA_DUMMY_CNTX_ENA_MASK  I40E_MASK(0x1, I40E_GLRLAN_DUMMY_CNTX_ENA_DUMMY_CNTX_ENA_SHIFT)

#define I40E_GLRLAN_ITR_NOTIFICATION_FIFO_CTL                  0x0012A578 /* Reset: CORER */
#define I40E_GLRLAN_ITR_NOTIFICATION_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_ITR_NOTIFICATION_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_ITR_NOTIFICATION_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_ITR_WR_DONE_FIFO_CTL                  0x0012A580 /* Reset: CORER */
#define I40E_GLRLAN_ITR_WR_DONE_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_ITR_WR_DONE_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_ITR_WR_DONE_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_PIM_REQ_FIFO_CTL                  0x0012A570 /* Reset: CORER */
#define I40E_GLRLAN_PIM_REQ_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_PIM_REQ_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_PIM_REQ_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_QCNTX_DATA_WB_FIFO_CTL                  0x0012A568 /* Reset: CORER */
#define I40E_GLRLAN_QCNTX_DATA_WB_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_QCNTX_DATA_WB_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_QCNTX_DATA_WB_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_QCNTX_MT2L_WB_FIFO_CTL                  0x0012A56C /* Reset: CORER */
#define I40E_GLRLAN_QCNTX_MT2L_WB_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_QCNTX_MT2L_WB_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_QCNTX_MT2L_WB_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_QCNTX_NUM_WB_FIFO_CTL                  0x0012A564 /* Reset: CORER */
#define I40E_GLRLAN_QCNTX_NUM_WB_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_QCNTX_NUM_WB_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_QCNTX_NUM_WB_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_RDPU_ATTR_FIFO_CTL                  0x0012A55C /* Reset: CORER */
#define I40E_GLRLAN_RDPU_ATTR_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_RDPU_ATTR_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_RDPU_ATTR_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_RDPU_CMD_FIFO_CTL                  0x0012A558 /* Reset: CORER */
#define I40E_GLRLAN_RDPU_CMD_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_RDPU_CMD_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_RDPU_CMD_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_RDPU_WB_FIFO_CTL                  0x0012A560 /* Reset: CORER */
#define I40E_GLRLAN_RDPU_WB_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_RDPU_WB_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_RDPU_WB_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_REQ_INFO_FIFO_CTL                  0x0012A588 /* Reset: CORER */
#define I40E_GLRLAN_REQ_INFO_FIFO_CTL_BP_THRSHLD_SHIFT 0
#define I40E_GLRLAN_REQ_INFO_FIFO_CTL_BP_THRSHLD_MASK  I40E_MASK(0x3FF, I40E_GLRLAN_REQ_INFO_FIFO_CTL_BP_THRSHLD_SHIFT)

#define I40E_GLRLAN_SPARE                  0x0012A5B8 /* Reset: CORER */
#define I40E_GLRLAN_SPARE_SPARE_BITS_SHIFT 0
#define I40E_GLRLAN_SPARE_SPARE_BITS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRLAN_SPARE_SPARE_BITS_SHIFT)

#define I40E_GLTLAN_MAX_TCBCMD                      0x000E64D4 /* Reset: CORER */
#define I40E_GLTLAN_MAX_TCBCMD_MAX_TCBCMD_SHIFT     0
#define I40E_GLTLAN_MAX_TCBCMD_MAX_TCBCMD_MASK      I40E_MASK(0xF, I40E_GLTLAN_MAX_TCBCMD_MAX_TCBCMD_SHIFT)
#define I40E_GLTLAN_MAX_TCBCMD_RSVD1_SHIFT          8
#define I40E_GLTLAN_MAX_TCBCMD_RSVD1_MASK           I40E_MASK(0x3, I40E_GLTLAN_MAX_TCBCMD_RSVD1_SHIFT)
#define I40E_GLTLAN_MAX_TCBCMD_MULTPL_REQ_DIS_SHIFT 31
#define I40E_GLTLAN_MAX_TCBCMD_MULTPL_REQ_DIS_MASK  I40E_MASK(0x1, I40E_GLTLAN_MAX_TCBCMD_MULTPL_REQ_DIS_SHIFT)

#define I40E_ITR_CAUSE_MEM_0_CFG                    0x0003FC00 /* Reset: POR */
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_EN_SHIFT       0
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_ECC_EN_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_1_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_ECC_INVERT_2_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_LS_FORCE_SHIFT     3
#define I40E_ITR_CAUSE_MEM_0_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_LS_FORCE_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_LS_BYPASS_SHIFT    4
#define I40E_ITR_CAUSE_MEM_0_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_LS_BYPASS_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_MASK_INT_SHIFT     5
#define I40E_ITR_CAUSE_MEM_0_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_MASK_INT_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_FIX_CNT_SHIFT      8
#define I40E_ITR_CAUSE_MEM_0_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_FIX_CNT_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_ERR_CNT_SHIFT      9
#define I40E_ITR_CAUSE_MEM_0_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_ERR_CNT_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_RME_SHIFT          12
#define I40E_ITR_CAUSE_MEM_0_CFG_RME_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_CFG_RME_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_CFG_RM_SHIFT           16
#define I40E_ITR_CAUSE_MEM_0_CFG_RM_MASK            I40E_MASK(0xF, I40E_ITR_CAUSE_MEM_0_CFG_RM_SHIFT)

#define I40E_ITR_CAUSE_MEM_0_STATUS                        0x0003FC04 /* Reset: POR */
#define I40E_ITR_CAUSE_MEM_0_STATUS_ECC_ERR_SHIFT          0
#define I40E_ITR_CAUSE_MEM_0_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_STATUS_ECC_ERR_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_STATUS_ECC_FIX_SHIFT          1
#define I40E_ITR_CAUSE_MEM_0_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_STATUS_ECC_FIX_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_STATUS_INIT_DONE_SHIFT        2
#define I40E_ITR_CAUSE_MEM_0_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_STATUS_INIT_DONE_SHIFT)
#define I40E_ITR_CAUSE_MEM_0_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_ITR_CAUSE_MEM_0_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_0_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_ITR_CAUSE_MEM_1_CFG                    0x0003FC08 /* Reset: POR */
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_EN_SHIFT       0
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_ECC_EN_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_1_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_ECC_INVERT_2_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_LS_FORCE_SHIFT     3
#define I40E_ITR_CAUSE_MEM_1_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_LS_FORCE_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_LS_BYPASS_SHIFT    4
#define I40E_ITR_CAUSE_MEM_1_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_LS_BYPASS_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_MASK_INT_SHIFT     5
#define I40E_ITR_CAUSE_MEM_1_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_MASK_INT_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_FIX_CNT_SHIFT      8
#define I40E_ITR_CAUSE_MEM_1_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_FIX_CNT_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_ERR_CNT_SHIFT      9
#define I40E_ITR_CAUSE_MEM_1_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_ERR_CNT_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_RME_SHIFT          12
#define I40E_ITR_CAUSE_MEM_1_CFG_RME_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_CFG_RME_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_CFG_RM_SHIFT           16
#define I40E_ITR_CAUSE_MEM_1_CFG_RM_MASK            I40E_MASK(0xF, I40E_ITR_CAUSE_MEM_1_CFG_RM_SHIFT)

#define I40E_ITR_CAUSE_MEM_1_STATUS                        0x0003FC0C /* Reset: POR */
#define I40E_ITR_CAUSE_MEM_1_STATUS_ECC_ERR_SHIFT          0
#define I40E_ITR_CAUSE_MEM_1_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_STATUS_ECC_ERR_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_STATUS_ECC_FIX_SHIFT          1
#define I40E_ITR_CAUSE_MEM_1_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_STATUS_ECC_FIX_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_STATUS_INIT_DONE_SHIFT        2
#define I40E_ITR_CAUSE_MEM_1_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_STATUS_INIT_DONE_SHIFT)
#define I40E_ITR_CAUSE_MEM_1_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_ITR_CAUSE_MEM_1_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_ITR_CAUSE_MEM_1_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_ITR_ECC_COR_ERR           0x0003FC24 /* Reset: POR */
#define I40E_ITR_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_ITR_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_ITR_ECC_COR_ERR_CNT_SHIFT)

#define I40E_ITR_ECC_UNCOR_ERR           0x0003FC20 /* Reset: POR */
#define I40E_ITR_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_ITR_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_ITR_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_ITR_MSIX_MEM_0_CFG                    0x0003FC10 /* Reset: POR */
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_EN_SHIFT       0
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_ECC_EN_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_1_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_ECC_INVERT_2_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_LS_FORCE_SHIFT     3
#define I40E_ITR_MSIX_MEM_0_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_LS_FORCE_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_LS_BYPASS_SHIFT    4
#define I40E_ITR_MSIX_MEM_0_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_LS_BYPASS_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_MASK_INT_SHIFT     5
#define I40E_ITR_MSIX_MEM_0_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_MASK_INT_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_FIX_CNT_SHIFT      8
#define I40E_ITR_MSIX_MEM_0_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_FIX_CNT_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_ERR_CNT_SHIFT      9
#define I40E_ITR_MSIX_MEM_0_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_ERR_CNT_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_RME_SHIFT          12
#define I40E_ITR_MSIX_MEM_0_CFG_RME_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_CFG_RME_SHIFT)
#define I40E_ITR_MSIX_MEM_0_CFG_RM_SHIFT           16
#define I40E_ITR_MSIX_MEM_0_CFG_RM_MASK            I40E_MASK(0xF, I40E_ITR_MSIX_MEM_0_CFG_RM_SHIFT)

#define I40E_ITR_MSIX_MEM_0_STATUS                        0x0003FC14 /* Reset: POR */
#define I40E_ITR_MSIX_MEM_0_STATUS_ECC_ERR_SHIFT          0
#define I40E_ITR_MSIX_MEM_0_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_STATUS_ECC_ERR_SHIFT)
#define I40E_ITR_MSIX_MEM_0_STATUS_ECC_FIX_SHIFT          1
#define I40E_ITR_MSIX_MEM_0_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_STATUS_ECC_FIX_SHIFT)
#define I40E_ITR_MSIX_MEM_0_STATUS_INIT_DONE_SHIFT        2
#define I40E_ITR_MSIX_MEM_0_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_STATUS_INIT_DONE_SHIFT)
#define I40E_ITR_MSIX_MEM_0_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_ITR_MSIX_MEM_0_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_0_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_ITR_MSIX_MEM_1_CFG                    0x0003FC18 /* Reset: POR */
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_EN_SHIFT       0
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_ECC_EN_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_1_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_ECC_INVERT_2_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_LS_FORCE_SHIFT     3
#define I40E_ITR_MSIX_MEM_1_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_LS_FORCE_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_LS_BYPASS_SHIFT    4
#define I40E_ITR_MSIX_MEM_1_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_LS_BYPASS_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_MASK_INT_SHIFT     5
#define I40E_ITR_MSIX_MEM_1_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_MASK_INT_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_FIX_CNT_SHIFT      8
#define I40E_ITR_MSIX_MEM_1_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_FIX_CNT_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_ERR_CNT_SHIFT      9
#define I40E_ITR_MSIX_MEM_1_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_ERR_CNT_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_RME_SHIFT          12
#define I40E_ITR_MSIX_MEM_1_CFG_RME_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_CFG_RME_SHIFT)
#define I40E_ITR_MSIX_MEM_1_CFG_RM_SHIFT           16
#define I40E_ITR_MSIX_MEM_1_CFG_RM_MASK            I40E_MASK(0xF, I40E_ITR_MSIX_MEM_1_CFG_RM_SHIFT)

#define I40E_ITR_MSIX_MEM_1_STATUS                        0x0003FC1C /* Reset: POR */
#define I40E_ITR_MSIX_MEM_1_STATUS_ECC_ERR_SHIFT          0
#define I40E_ITR_MSIX_MEM_1_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_STATUS_ECC_ERR_SHIFT)
#define I40E_ITR_MSIX_MEM_1_STATUS_ECC_FIX_SHIFT          1
#define I40E_ITR_MSIX_MEM_1_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_STATUS_ECC_FIX_SHIFT)
#define I40E_ITR_MSIX_MEM_1_STATUS_INIT_DONE_SHIFT        2
#define I40E_ITR_MSIX_MEM_1_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_STATUS_INIT_DONE_SHIFT)
#define I40E_ITR_MSIX_MEM_1_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_ITR_MSIX_MEM_1_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_ITR_MSIX_MEM_1_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_ADMIN_Q_CFG                    0x0008304C /* Reset: POR */
#define I40E_MNG_ADMIN_Q_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_ADMIN_Q_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_ECC_EN_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_ADMIN_Q_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_ADMIN_Q_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_ADMIN_Q_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_MASK_INT_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_ADMIN_Q_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_ADMIN_Q_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_RME_SHIFT          12
#define I40E_MNG_ADMIN_Q_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_ADMIN_Q_CFG_RME_SHIFT)
#define I40E_MNG_ADMIN_Q_CFG_RM_SHIFT           16
#define I40E_MNG_ADMIN_Q_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_ADMIN_Q_CFG_RM_SHIFT)

#define I40E_MNG_ADMIN_Q_STATUS                        0x00083050 /* Reset: POR */
#define I40E_MNG_ADMIN_Q_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_ADMIN_Q_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_ADMIN_Q_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_ADMIN_Q_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_ADMIN_Q_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_ADMIN_Q_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_ADMIN_Q_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_ADMIN_Q_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_ADMIN_Q_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_ADMIN_Q_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_ADMIN_Q_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_ADMIN_Q_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_ALTERNATE_CFG                    0x000830A4 /* Reset: POR */
#define I40E_MNG_ALTERNATE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_ALTERNATE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_ALTERNATE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_ALTERNATE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_ALTERNATE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_ALTERNATE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_ALTERNATE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_ALTERNATE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_ALTERNATE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_RME_SHIFT          12
#define I40E_MNG_ALTERNATE_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_ALTERNATE_CFG_RME_SHIFT)
#define I40E_MNG_ALTERNATE_CFG_RM_SHIFT           16
#define I40E_MNG_ALTERNATE_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_ALTERNATE_CFG_RM_SHIFT)

#define I40E_MNG_ALTERNATE_STATUS                        0x000830A8 /* Reset: POR */
#define I40E_MNG_ALTERNATE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_ALTERNATE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_ALTERNATE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_ALTERNATE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_ALTERNATE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_ALTERNATE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_ALTERNATE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_ALTERNATE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_ALTERNATE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_ALTERNATE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_ALTERNATE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_ALTERNATE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_CODE_BANK_CFG                    0x00083054 /* Reset: POR */
#define I40E_MNG_CODE_BANK_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_CODE_BANK_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_ECC_EN_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_CODE_BANK_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_CODE_BANK_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_CODE_BANK_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_CODE_BANK_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_CODE_BANK_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_MASK_INT_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_CODE_BANK_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_CODE_BANK_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_RME_SHIFT          12
#define I40E_MNG_CODE_BANK_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_CODE_BANK_CFG_RME_SHIFT)
#define I40E_MNG_CODE_BANK_CFG_RM_SHIFT           16
#define I40E_MNG_CODE_BANK_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_CODE_BANK_CFG_RM_SHIFT)

#define I40E_MNG_CODE_BANK_STATUS                        0x00083058 /* Reset: POR */
#define I40E_MNG_CODE_BANK_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_CODE_BANK_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_CODE_BANK_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_CODE_BANK_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_CODE_BANK_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_CODE_BANK_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_CODE_BANK_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_CODE_BANK_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_CODE_BANK_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_CODE_BANK_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_CODE_BANK_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_CODE_BANK_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_ECC_COR_ERR           0x000830B8 /* Reset: POR */
#define I40E_MNG_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_MNG_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_MNG_ECC_COR_ERR_CNT_SHIFT)

#define I40E_MNG_ECC_UNCOR_ERR           0x000830B4 /* Reset: POR */
#define I40E_MNG_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_MNG_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_MNG_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_MNG_POPULATED_DATA_CFG                    0x00083064 /* Reset: POR */
#define I40E_MNG_POPULATED_DATA_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_POPULATED_DATA_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_ECC_EN_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_POPULATED_DATA_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_POPULATED_DATA_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_POPULATED_DATA_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_MASK_INT_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_POPULATED_DATA_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_POPULATED_DATA_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_RME_SHIFT          12
#define I40E_MNG_POPULATED_DATA_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_CFG_RME_SHIFT)
#define I40E_MNG_POPULATED_DATA_CFG_RM_SHIFT           16
#define I40E_MNG_POPULATED_DATA_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_POPULATED_DATA_CFG_RM_SHIFT)

#define I40E_MNG_POPULATED_DATA_STATUS                        0x00083068 /* Reset: POR */
#define I40E_MNG_POPULATED_DATA_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_POPULATED_DATA_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_POPULATED_DATA_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_POPULATED_DATA_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_POPULATED_DATA_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_POPULATED_DATA_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_POPULATED_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_POPULATED_DATA_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_POPULATED_DATA0_CFG                    0x0008305C /* Reset: POR */
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_ECC_EN_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_POPULATED_DATA0_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_POPULATED_DATA0_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_POPULATED_DATA0_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_MASK_INT_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_POPULATED_DATA0_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_POPULATED_DATA0_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_RME_SHIFT          12
#define I40E_MNG_POPULATED_DATA0_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_CFG_RME_SHIFT)
#define I40E_MNG_POPULATED_DATA0_CFG_RM_SHIFT           16
#define I40E_MNG_POPULATED_DATA0_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_POPULATED_DATA0_CFG_RM_SHIFT)

#define I40E_MNG_POPULATED_DATA0_STATUS                        0x00083060 /* Reset: POR */
#define I40E_MNG_POPULATED_DATA0_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_POPULATED_DATA0_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_POPULATED_DATA0_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_POPULATED_DATA0_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_POPULATED_DATA0_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_POPULATED_DATA0_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_POPULATED_DATA0_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_POPULATED_DATA0_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_POPULATED_DATA0_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_ROM_CFG                    0x000830AC /* Reset: POR */
#define I40E_MNG_ROM_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_ROM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_ROM_CFG_ECC_EN_SHIFT)
#define I40E_MNG_ROM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_ROM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_ROM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_ROM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_ROM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_ROM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_ROM_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_ROM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_ROM_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_ROM_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_ROM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_ROM_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_ROM_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_ROM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_ROM_CFG_MASK_INT_SHIFT)
#define I40E_MNG_ROM_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_ROM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ROM_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_ROM_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_ROM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_ROM_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_ROM_CFG_RME_SHIFT          12
#define I40E_MNG_ROM_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_ROM_CFG_RME_SHIFT)
#define I40E_MNG_ROM_CFG_RM_SHIFT           16
#define I40E_MNG_ROM_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_ROM_CFG_RM_SHIFT)

#define I40E_MNG_ROM_STATUS                        0x000830B0 /* Reset: POR */
#define I40E_MNG_ROM_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_ROM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_ROM_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_ROM_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_ROM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_ROM_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_ROM_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_ROM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_ROM_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_ROM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_ROM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_ROM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_RX_BANK_CFG                    0x0008306C /* Reset: POR */
#define I40E_MNG_RX_BANK_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_RX_BANK_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_ECC_EN_SHIFT)
#define I40E_MNG_RX_BANK_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_RX_BANK_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_RX_BANK_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_RX_BANK_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_RX_BANK_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_RX_BANK_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_RX_BANK_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_RX_BANK_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_RX_BANK_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_RX_BANK_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_MASK_INT_SHIFT)
#define I40E_MNG_RX_BANK_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_RX_BANK_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_RX_BANK_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_RX_BANK_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_RX_BANK_CFG_RME_SHIFT          12
#define I40E_MNG_RX_BANK_CFG_RME_MASK           I40E_MASK(0x1, I40E_MNG_RX_BANK_CFG_RME_SHIFT)
#define I40E_MNG_RX_BANK_CFG_RM_SHIFT           16
#define I40E_MNG_RX_BANK_CFG_RM_MASK            I40E_MASK(0xF, I40E_MNG_RX_BANK_CFG_RM_SHIFT)

#define I40E_MNG_RX_BANK_STATUS                        0x00083070 /* Reset: POR */
#define I40E_MNG_RX_BANK_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_RX_BANK_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_RX_BANK_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_RX_BANK_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_RX_BANK_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_RX_BANK_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_RX_BANK_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_RX_BANK_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_RX_BANK_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_RX_BANK_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_RX_BANK_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_RX_BANK_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_RXF_CFG                    0x00083074 /* Reset: POR */
#define I40E_MNG_RXF_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_RXF_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_RXF_CFG_ECC_EN_SHIFT)
#define I40E_MNG_RXF_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_RXF_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_RXF_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_RXF_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_RXF_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_RXF_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_RXF_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_RXF_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_RXF_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_RXF_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_RXF_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_RXF_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_RXF_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_RXF_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_RXF_CFG_MASK_INT_SHIFT)
#define I40E_MNG_RXF_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_RXF_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_RXF_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_RXF_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_RXF_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_RXF_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_RXF_CFG_RME_A_SHIFT        12
#define I40E_MNG_RXF_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_RXF_CFG_RME_A_SHIFT)
#define I40E_MNG_RXF_CFG_RME_B_SHIFT        13
#define I40E_MNG_RXF_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_RXF_CFG_RME_B_SHIFT)
#define I40E_MNG_RXF_CFG_RM_A_SHIFT         16
#define I40E_MNG_RXF_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_RXF_CFG_RM_A_SHIFT)
#define I40E_MNG_RXF_CFG_RM_B_SHIFT         20
#define I40E_MNG_RXF_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_RXF_CFG_RM_B_SHIFT)

#define I40E_MNG_RXF_STATUS                        0x00083078 /* Reset: POR */
#define I40E_MNG_RXF_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_RXF_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_RXF_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_RXF_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_RXF_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_RXF_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_RXF_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_RXF_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_RXF_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_RXF_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_RXF_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_RXF_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_TX0_GLUE_CFG                    0x0008307C /* Reset: POR */
#define I40E_MNG_TX0_GLUE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_TX0_GLUE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_TX0_GLUE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_TX0_GLUE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_TX0_GLUE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_TX0_GLUE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_TX0_GLUE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_RME_A_SHIFT        12
#define I40E_MNG_TX0_GLUE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_RME_A_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_RME_B_SHIFT        13
#define I40E_MNG_TX0_GLUE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_TX0_GLUE_CFG_RME_B_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_RM_A_SHIFT         16
#define I40E_MNG_TX0_GLUE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_TX0_GLUE_CFG_RM_A_SHIFT)
#define I40E_MNG_TX0_GLUE_CFG_RM_B_SHIFT         20
#define I40E_MNG_TX0_GLUE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_TX0_GLUE_CFG_RM_B_SHIFT)

#define I40E_MNG_TX0_GLUE_STATUS                        0x00083080 /* Reset: POR */
#define I40E_MNG_TX0_GLUE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_TX0_GLUE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_TX0_GLUE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_TX0_GLUE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_TX0_GLUE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_TX0_GLUE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_TX0_GLUE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_TX0_GLUE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_TX0_GLUE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_TX0_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_TX0_GLUE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_TX0_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_TX1_GLUE_CFG                    0x00083084 /* Reset: POR */
#define I40E_MNG_TX1_GLUE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_TX1_GLUE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_TX1_GLUE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_TX1_GLUE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_TX1_GLUE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_TX1_GLUE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_TX1_GLUE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_RME_A_SHIFT        12
#define I40E_MNG_TX1_GLUE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_RME_A_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_RME_B_SHIFT        13
#define I40E_MNG_TX1_GLUE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_TX1_GLUE_CFG_RME_B_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_RM_A_SHIFT         16
#define I40E_MNG_TX1_GLUE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_TX1_GLUE_CFG_RM_A_SHIFT)
#define I40E_MNG_TX1_GLUE_CFG_RM_B_SHIFT         20
#define I40E_MNG_TX1_GLUE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_TX1_GLUE_CFG_RM_B_SHIFT)

#define I40E_MNG_TX1_GLUE_STATUS                        0x00083088 /* Reset: POR */
#define I40E_MNG_TX1_GLUE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_TX1_GLUE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_TX1_GLUE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_TX1_GLUE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_TX1_GLUE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_TX1_GLUE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_TX1_GLUE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_TX1_GLUE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_TX1_GLUE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_TX1_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_TX1_GLUE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_TX1_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_TX2_GLUE_CFG                    0x0008308C /* Reset: POR */
#define I40E_MNG_TX2_GLUE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_TX2_GLUE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_TX2_GLUE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_TX2_GLUE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_TX2_GLUE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_TX2_GLUE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_TX2_GLUE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_RME_A_SHIFT        12
#define I40E_MNG_TX2_GLUE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_RME_A_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_RME_B_SHIFT        13
#define I40E_MNG_TX2_GLUE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_TX2_GLUE_CFG_RME_B_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_RM_A_SHIFT         16
#define I40E_MNG_TX2_GLUE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_TX2_GLUE_CFG_RM_A_SHIFT)
#define I40E_MNG_TX2_GLUE_CFG_RM_B_SHIFT         20
#define I40E_MNG_TX2_GLUE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_TX2_GLUE_CFG_RM_B_SHIFT)

#define I40E_MNG_TX2_GLUE_STATUS                        0x00083090 /* Reset: POR */
#define I40E_MNG_TX2_GLUE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_TX2_GLUE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_TX2_GLUE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_TX2_GLUE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_TX2_GLUE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_TX2_GLUE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_TX2_GLUE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_TX2_GLUE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_TX2_GLUE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_TX2_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_TX2_GLUE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_TX2_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_TX3_GLUE_CFG                    0x00083094 /* Reset: POR */
#define I40E_MNG_TX3_GLUE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_TX3_GLUE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_TX3_GLUE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_TX3_GLUE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_TX3_GLUE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_TX3_GLUE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_TX3_GLUE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_RME_A_SHIFT        12
#define I40E_MNG_TX3_GLUE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_RME_A_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_RME_B_SHIFT        13
#define I40E_MNG_TX3_GLUE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_TX3_GLUE_CFG_RME_B_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_RM_A_SHIFT         16
#define I40E_MNG_TX3_GLUE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_TX3_GLUE_CFG_RM_A_SHIFT)
#define I40E_MNG_TX3_GLUE_CFG_RM_B_SHIFT         20
#define I40E_MNG_TX3_GLUE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_TX3_GLUE_CFG_RM_B_SHIFT)

#define I40E_MNG_TX3_GLUE_STATUS                        0x00083098 /* Reset: POR */
#define I40E_MNG_TX3_GLUE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_TX3_GLUE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_TX3_GLUE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_TX3_GLUE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_TX3_GLUE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_TX3_GLUE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_TX3_GLUE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_TX3_GLUE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_TX3_GLUE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_TX3_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_TX3_GLUE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_TX3_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_MNG_TX4_GLUE_CFG                    0x0008309C /* Reset: POR */
#define I40E_MNG_TX4_GLUE_CFG_ECC_EN_SHIFT       0
#define I40E_MNG_TX4_GLUE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_ECC_EN_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_LS_FORCE_SHIFT     3
#define I40E_MNG_TX4_GLUE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_LS_FORCE_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_LS_BYPASS_SHIFT    4
#define I40E_MNG_TX4_GLUE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_LS_BYPASS_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_MASK_INT_SHIFT     5
#define I40E_MNG_TX4_GLUE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_MASK_INT_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_FIX_CNT_SHIFT      8
#define I40E_MNG_TX4_GLUE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_FIX_CNT_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_ERR_CNT_SHIFT      9
#define I40E_MNG_TX4_GLUE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_ERR_CNT_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_RME_A_SHIFT        12
#define I40E_MNG_TX4_GLUE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_RME_A_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_RME_B_SHIFT        13
#define I40E_MNG_TX4_GLUE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_MNG_TX4_GLUE_CFG_RME_B_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_RM_A_SHIFT         16
#define I40E_MNG_TX4_GLUE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_MNG_TX4_GLUE_CFG_RM_A_SHIFT)
#define I40E_MNG_TX4_GLUE_CFG_RM_B_SHIFT         20
#define I40E_MNG_TX4_GLUE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_MNG_TX4_GLUE_CFG_RM_B_SHIFT)

#define I40E_MNG_TX4_GLUE_STATUS                        0x000830A0 /* Reset: POR */
#define I40E_MNG_TX4_GLUE_STATUS_ECC_ERR_SHIFT          0
#define I40E_MNG_TX4_GLUE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_MNG_TX4_GLUE_STATUS_ECC_ERR_SHIFT)
#define I40E_MNG_TX4_GLUE_STATUS_ECC_FIX_SHIFT          1
#define I40E_MNG_TX4_GLUE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_MNG_TX4_GLUE_STATUS_ECC_FIX_SHIFT)
#define I40E_MNG_TX4_GLUE_STATUS_INIT_DONE_SHIFT        2
#define I40E_MNG_TX4_GLUE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_MNG_TX4_GLUE_STATUS_INIT_DONE_SHIFT)
#define I40E_MNG_TX4_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_MNG_TX4_GLUE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_MNG_TX4_GLUE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PBLOC_CACHE_DBG_CTL              0x000A808C /* Reset: CORER */
#define I40E_PBLOC_CACHE_DBG_CTL_ADR_SHIFT    0
#define I40E_PBLOC_CACHE_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PBLOC_CACHE_DBG_CTL_ADR_SHIFT)
#define I40E_PBLOC_CACHE_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PBLOC_CACHE_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PBLOC_CACHE_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PBLOC_CACHE_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PBLOC_CACHE_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PBLOC_CACHE_DBG_CTL_RD_EN_SHIFT)
#define I40E_PBLOC_CACHE_DBG_CTL_DONE_SHIFT   31
#define I40E_PBLOC_CACHE_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PBLOC_CACHE_DBG_CTL_DONE_SHIFT)

#define I40E_PBLOC_CACHE_DBG_DATA             0x000A8090 /* Reset: CORER */
#define I40E_PBLOC_CACHE_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PBLOC_CACHE_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PBLOC_CACHE_DBG_DATA_RD_DW_SHIFT)

#define I40E_PBLOC_CACHE_MEM_CFG                    0x000A8054 /* Reset: POR */
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PBLOC_CACHE_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PBLOC_CACHE_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PBLOC_CACHE_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PBLOC_CACHE_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PBLOC_CACHE_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_RME_SHIFT          12
#define I40E_PBLOC_CACHE_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_CFG_RME_SHIFT)
#define I40E_PBLOC_CACHE_MEM_CFG_RM_SHIFT           16
#define I40E_PBLOC_CACHE_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PBLOC_CACHE_MEM_CFG_RM_SHIFT)

#define I40E_PBLOC_CACHE_MEM_STATUS                        0x000A8058 /* Reset: POR */
#define I40E_PBLOC_CACHE_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PBLOC_CACHE_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PBLOC_CACHE_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PBLOC_CACHE_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PBLOC_CACHE_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PBLOC_CACHE_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PBLOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PBLOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PBLOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PBLOC_ECC_COR_ERR           0x000A8080 /* Reset: POR */
#define I40E_PBLOC_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_PBLOC_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PBLOC_ECC_COR_ERR_CNT_SHIFT)

#define I40E_PBLOC_ECC_UNCOR_ERR           0x000A807C /* Reset: POR */
#define I40E_PBLOC_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_PBLOC_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PBLOC_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_PBLOC_EVICT_MEM_CFG                    0x000A8074 /* Reset: POR */
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PBLOC_EVICT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PBLOC_EVICT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PBLOC_EVICT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PBLOC_EVICT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PBLOC_EVICT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_RME_A_SHIFT        12
#define I40E_PBLOC_EVICT_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_RME_A_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_RME_B_SHIFT        13
#define I40E_PBLOC_EVICT_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_CFG_RME_B_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_RM_A_SHIFT         16
#define I40E_PBLOC_EVICT_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PBLOC_EVICT_MEM_CFG_RM_A_SHIFT)
#define I40E_PBLOC_EVICT_MEM_CFG_RM_B_SHIFT         20
#define I40E_PBLOC_EVICT_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PBLOC_EVICT_MEM_CFG_RM_B_SHIFT)

#define I40E_PBLOC_EVICT_MEM_STATUS                        0x000A8078 /* Reset: POR */
#define I40E_PBLOC_EVICT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PBLOC_EVICT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PBLOC_EVICT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PBLOC_EVICT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PBLOC_EVICT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PBLOC_EVICT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PBLOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PBLOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PBLOC_EVICT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PBLOC_FILL_MEM_CFG                    0x000A8064 /* Reset: POR */
#define I40E_PBLOC_FILL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PBLOC_FILL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PBLOC_FILL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PBLOC_FILL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PBLOC_FILL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PBLOC_FILL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PBLOC_FILL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_RME_A_SHIFT        12
#define I40E_PBLOC_FILL_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_RME_A_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_RME_B_SHIFT        13
#define I40E_PBLOC_FILL_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_CFG_RME_B_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_RM_A_SHIFT         16
#define I40E_PBLOC_FILL_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PBLOC_FILL_MEM_CFG_RM_A_SHIFT)
#define I40E_PBLOC_FILL_MEM_CFG_RM_B_SHIFT         20
#define I40E_PBLOC_FILL_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PBLOC_FILL_MEM_CFG_RM_B_SHIFT)

#define I40E_PBLOC_FILL_MEM_STATUS                        0x000A8068 /* Reset: POR */
#define I40E_PBLOC_FILL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PBLOC_FILL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PBLOC_FILL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PBLOC_FILL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PBLOC_FILL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PBLOC_FILL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PBLOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PBLOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PBLOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PBLOC_PLIST_DBG_CTL              0x000A8094 /* Reset: CORER */
#define I40E_PBLOC_PLIST_DBG_CTL_ADR_SHIFT    0
#define I40E_PBLOC_PLIST_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PBLOC_PLIST_DBG_CTL_ADR_SHIFT)
#define I40E_PBLOC_PLIST_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PBLOC_PLIST_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PBLOC_PLIST_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PBLOC_PLIST_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PBLOC_PLIST_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PBLOC_PLIST_DBG_CTL_RD_EN_SHIFT)
#define I40E_PBLOC_PLIST_DBG_CTL_DONE_SHIFT   31
#define I40E_PBLOC_PLIST_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PBLOC_PLIST_DBG_CTL_DONE_SHIFT)

#define I40E_PBLOC_PLIST_DBG_DATA             0x000A8098 /* Reset: CORER */
#define I40E_PBLOC_PLIST_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PBLOC_PLIST_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PBLOC_PLIST_DBG_DATA_RD_DW_SHIFT)

#define I40E_PBLOC_PLIST_MEM_CFG                    0x000A806C /* Reset: POR */
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PBLOC_PLIST_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PBLOC_PLIST_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PBLOC_PLIST_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PBLOC_PLIST_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PBLOC_PLIST_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_RME_SHIFT          12
#define I40E_PBLOC_PLIST_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_CFG_RME_SHIFT)
#define I40E_PBLOC_PLIST_MEM_CFG_RM_SHIFT           16
#define I40E_PBLOC_PLIST_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PBLOC_PLIST_MEM_CFG_RM_SHIFT)

#define I40E_PBLOC_PLIST_MEM_STATUS                        0x000A8070 /* Reset: POR */
#define I40E_PBLOC_PLIST_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PBLOC_PLIST_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PBLOC_PLIST_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PBLOC_PLIST_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PBLOC_PLIST_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PBLOC_PLIST_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PBLOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PBLOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PBLOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PBLOC_TAG_DBG_CTL              0x000A8084 /* Reset: CORER */
#define I40E_PBLOC_TAG_DBG_CTL_ADR_SHIFT    0
#define I40E_PBLOC_TAG_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PBLOC_TAG_DBG_CTL_ADR_SHIFT)
#define I40E_PBLOC_TAG_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PBLOC_TAG_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PBLOC_TAG_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PBLOC_TAG_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PBLOC_TAG_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PBLOC_TAG_DBG_CTL_RD_EN_SHIFT)
#define I40E_PBLOC_TAG_DBG_CTL_DONE_SHIFT   31
#define I40E_PBLOC_TAG_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PBLOC_TAG_DBG_CTL_DONE_SHIFT)

#define I40E_PBLOC_TAG_DBG_DATA             0x000A8088 /* Reset: CORER */
#define I40E_PBLOC_TAG_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PBLOC_TAG_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PBLOC_TAG_DBG_DATA_RD_DW_SHIFT)

#define I40E_PBLOC_TAG_MEM_CFG                    0x000A805C /* Reset: POR */
#define I40E_PBLOC_TAG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PBLOC_TAG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PBLOC_TAG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PBLOC_TAG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PBLOC_TAG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PBLOC_TAG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PBLOC_TAG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_RME_SHIFT          12
#define I40E_PBLOC_TAG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_CFG_RME_SHIFT)
#define I40E_PBLOC_TAG_MEM_CFG_RM_SHIFT           16
#define I40E_PBLOC_TAG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PBLOC_TAG_MEM_CFG_RM_SHIFT)

#define I40E_PBLOC_TAG_MEM_STATUS                        0x000A8060 /* Reset: POR */
#define I40E_PBLOC_TAG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PBLOC_TAG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PBLOC_TAG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PBLOC_TAG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PBLOC_TAG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PBLOC_TAG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PBLOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PBLOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PBLOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_ECC_COR_ERR           0x0009D080 /* Reset: POR */
#define I40E_PCIE_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_PCIE_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PCIE_ECC_COR_ERR_CNT_SHIFT)

#define I40E_PCIE_ECC_UNCOR_ERR           0x0009D07C /* Reset: POR */
#define I40E_PCIE_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_PCIE_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PCIE_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_PCIE_IOSF_RX_DATA_CFG                    0x0009D010 /* Reset: POR */
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_IOSF_RX_DATA_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_IOSF_RX_DATA_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_IOSF_RX_DATA_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_IOSF_RX_DATA_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_IOSF_RX_DATA_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_RME_A_SHIFT        12
#define I40E_PCIE_IOSF_RX_DATA_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_RME_A_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_RME_B_SHIFT        13
#define I40E_PCIE_IOSF_RX_DATA_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_CFG_RME_B_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_RM_A_SHIFT         16
#define I40E_PCIE_IOSF_RX_DATA_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_RX_DATA_CFG_RM_A_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_CFG_RM_B_SHIFT         20
#define I40E_PCIE_IOSF_RX_DATA_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_RX_DATA_CFG_RM_B_SHIFT)

#define I40E_PCIE_IOSF_RX_DATA_STATUS                        0x0009D068 /* Reset: POR */
#define I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_IOSF_RX_DATA_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_IOSF_RX_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_IOSF_RX_DATA_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_IOSF_RX_HDR_CFG                    0x0009D028 /* Reset: POR */
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_IOSF_RX_HDR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_IOSF_RX_HDR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_IOSF_RX_HDR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_IOSF_RX_HDR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_IOSF_RX_HDR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_RME_A_SHIFT        12
#define I40E_PCIE_IOSF_RX_HDR_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_RME_A_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_RME_B_SHIFT        13
#define I40E_PCIE_IOSF_RX_HDR_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_CFG_RME_B_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_RM_A_SHIFT         16
#define I40E_PCIE_IOSF_RX_HDR_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_RX_HDR_CFG_RM_A_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_CFG_RM_B_SHIFT         20
#define I40E_PCIE_IOSF_RX_HDR_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_RX_HDR_CFG_RM_B_SHIFT)

#define I40E_PCIE_IOSF_RX_HDR_STATUS                        0x0009D05C /* Reset: POR */
#define I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_IOSF_RX_HDR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_IOSF_RX_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_IOSF_RX_HDR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_RX_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_IOSF_TX_DATA_CFG                    0x0009D020 /* Reset: POR */
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_IOSF_TX_DATA_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_IOSF_TX_DATA_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_IOSF_TX_DATA_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_IOSF_TX_DATA_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_IOSF_TX_DATA_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_RME_A_SHIFT        12
#define I40E_PCIE_IOSF_TX_DATA_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_RME_A_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_RME_B_SHIFT        13
#define I40E_PCIE_IOSF_TX_DATA_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_CFG_RME_B_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_RM_A_SHIFT         16
#define I40E_PCIE_IOSF_TX_DATA_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_TX_DATA_CFG_RM_A_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_CFG_RM_B_SHIFT         20
#define I40E_PCIE_IOSF_TX_DATA_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_TX_DATA_CFG_RM_B_SHIFT)

#define I40E_PCIE_IOSF_TX_DATA_STATUS                        0x0009D050 /* Reset: POR */
#define I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_IOSF_TX_DATA_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_IOSF_TX_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_IOSF_TX_DATA_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_IOSF_TX_HDR_CFG                    0x0009D034 /* Reset: POR */
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_IOSF_TX_HDR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_IOSF_TX_HDR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_IOSF_TX_HDR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_IOSF_TX_HDR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_IOSF_TX_HDR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_RME_A_SHIFT        12
#define I40E_PCIE_IOSF_TX_HDR_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_RME_A_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_RME_B_SHIFT        13
#define I40E_PCIE_IOSF_TX_HDR_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_CFG_RME_B_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_RM_A_SHIFT         16
#define I40E_PCIE_IOSF_TX_HDR_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_TX_HDR_CFG_RM_A_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_CFG_RM_B_SHIFT         20
#define I40E_PCIE_IOSF_TX_HDR_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_PCIE_IOSF_TX_HDR_CFG_RM_B_SHIFT)

#define I40E_PCIE_IOSF_TX_HDR_STATUS                        0x0009D03C /* Reset: POR */
#define I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_IOSF_TX_HDR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_IOSF_TX_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_IOSF_TX_HDR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_IOSF_TX_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_MCTP_DATA_CFG                    0x0009D01C /* Reset: POR */
#define I40E_PCIE_MCTP_DATA_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_MCTP_DATA_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_MCTP_DATA_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_MCTP_DATA_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_MCTP_DATA_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_MCTP_DATA_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_MCTP_DATA_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_RME_SHIFT          12
#define I40E_PCIE_MCTP_DATA_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_CFG_RME_SHIFT)
#define I40E_PCIE_MCTP_DATA_CFG_RM_SHIFT           16
#define I40E_PCIE_MCTP_DATA_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_MCTP_DATA_CFG_RM_SHIFT)

#define I40E_PCIE_MCTP_DATA_STATUS                        0x0009D04C /* Reset: POR */
#define I40E_PCIE_MCTP_DATA_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_MCTP_DATA_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_MCTP_DATA_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_MCTP_DATA_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_MCTP_DATA_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_MCTP_DATA_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_MCTP_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_MCTP_DATA_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_MCTP_HDR_CFG                    0x0009D004 /* Reset: POR */
#define I40E_PCIE_MCTP_HDR_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_MCTP_HDR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_MCTP_HDR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_MCTP_HDR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_MCTP_HDR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_MCTP_HDR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_MCTP_HDR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_RME_SHIFT          12
#define I40E_PCIE_MCTP_HDR_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_CFG_RME_SHIFT)
#define I40E_PCIE_MCTP_HDR_CFG_RM_SHIFT           16
#define I40E_PCIE_MCTP_HDR_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_MCTP_HDR_CFG_RM_SHIFT)

#define I40E_PCIE_MCTP_HDR_STATUS                        0x0009D040 /* Reset: POR */
#define I40E_PCIE_MCTP_HDR_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_MCTP_HDR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_MCTP_HDR_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_MCTP_HDR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_MCTP_HDR_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_MCTP_HDR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_MCTP_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_MCTP_HDR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_MCTP_HDR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_MSIX_VEC_CFG                    0x0009D030 /* Reset: POR */
#define I40E_PCIE_MSIX_VEC_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_MSIX_VEC_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_MSIX_VEC_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_MSIX_VEC_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_MSIX_VEC_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_MSIX_VEC_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_MSIX_VEC_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_RME_SHIFT          12
#define I40E_PCIE_MSIX_VEC_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_CFG_RME_SHIFT)
#define I40E_PCIE_MSIX_VEC_CFG_RM_SHIFT           16
#define I40E_PCIE_MSIX_VEC_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_MSIX_VEC_CFG_RM_SHIFT)

#define I40E_PCIE_MSIX_VEC_STATUS                        0x0009D060 /* Reset: POR */
#define I40E_PCIE_MSIX_VEC_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_MSIX_VEC_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_MSIX_VEC_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_MSIX_VEC_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_MSIX_VEC_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_MSIX_VEC_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_MSIX_VEC_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_MSIX_VEC_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_MSIX_VEC_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG                    0x0009D06C /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RME_SHIFT          12
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RME_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RM_SHIFT           16
#define I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_NPQ_CPL_LAN_DESC_CFG_RM_SHIFT)

#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS                        0x0009D074 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_LAN_DESC_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_NPQ_CPL_MNG_CFG                    0x0009D008 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_NPQ_CPL_MNG_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_NPQ_CPL_MNG_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_NPQ_CPL_MNG_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_NPQ_CPL_MNG_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_NPQ_CPL_MNG_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_RME_SHIFT          12
#define I40E_PCIE_NPQ_CPL_MNG_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_CFG_RME_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_CFG_RM_SHIFT           16
#define I40E_PCIE_NPQ_CPL_MNG_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_NPQ_CPL_MNG_CFG_RM_SHIFT)

#define I40E_PCIE_NPQ_CPL_MNG_STATUS                        0x0009D054 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_NPQ_CPL_MNG_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_MNG_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG                    0x0009D078 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RME_SHIFT          12
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RME_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RM_SHIFT           16
#define I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_NPQ_CPL_PE_DESC_CFG_RM_SHIFT)

#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS                        0x0009D070 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PE_DESC_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_NPQ_CPL_PMAT_CFG                    0x0009D000 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_RME_SHIFT          12
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_CFG_RME_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_RM_SHIFT           16
#define I40E_PCIE_NPQ_CPL_PMAT_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_NPQ_CPL_PMAT_CFG_RM_SHIFT)

#define I40E_PCIE_NPQ_CPL_PMAT_STATUS                        0x0009D048 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_NPQ_CPL_PMAT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_PMAT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_NPQ_CPL_TDPU_CFG                    0x0009D014 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_RME_SHIFT          12
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_CFG_RME_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_RM_SHIFT           16
#define I40E_PCIE_NPQ_CPL_TDPU_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_NPQ_CPL_TDPU_CFG_RM_SHIFT)

#define I40E_PCIE_NPQ_CPL_TDPU_STATUS                        0x0009D064 /* Reset: POR */
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_NPQ_CPL_TDPU_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_NPQ_CPL_TDPU_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_PQ_C125_CFG                    0x0009D018 /* Reset: POR */
#define I40E_PCIE_PQ_C125_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_PQ_C125_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_PQ_C125_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_PQ_C125_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_PQ_C125_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_PQ_C125_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_PQ_C125_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_PQ_C125_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_PQ_C125_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_RME_SHIFT          12
#define I40E_PCIE_PQ_C125_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C125_CFG_RME_SHIFT)
#define I40E_PCIE_PQ_C125_CFG_RM_SHIFT           16
#define I40E_PCIE_PQ_C125_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_PQ_C125_CFG_RM_SHIFT)

#define I40E_PCIE_PQ_C125_STATUS                        0x0009D038 /* Reset: POR */
#define I40E_PCIE_PQ_C125_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_PQ_C125_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C125_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_PQ_C125_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_PQ_C125_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C125_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_PQ_C125_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_PQ_C125_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_PQ_C125_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_PQ_C125_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_PQ_C125_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C125_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_PQ_C400_CFG                    0x0009D024 /* Reset: POR */
#define I40E_PCIE_PQ_C400_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_PQ_C400_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_PQ_C400_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_PQ_C400_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_PQ_C400_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_PQ_C400_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_PQ_C400_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_PQ_C400_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_PQ_C400_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_RME_SHIFT          12
#define I40E_PCIE_PQ_C400_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C400_CFG_RME_SHIFT)
#define I40E_PCIE_PQ_C400_CFG_RM_SHIFT           16
#define I40E_PCIE_PQ_C400_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_PQ_C400_CFG_RM_SHIFT)

#define I40E_PCIE_PQ_C400_STATUS                        0x0009D044 /* Reset: POR */
#define I40E_PCIE_PQ_C400_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_PQ_C400_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C400_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_PQ_C400_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_PQ_C400_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_PQ_C400_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_PQ_C400_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_PQ_C400_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_PQ_C400_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_PQ_C400_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_PQ_C400_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_PQ_C400_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PCIE_RETRY_BUF_CFG                    0x0009D02C /* Reset: POR */
#define I40E_PCIE_RETRY_BUF_CFG_ECC_EN_SHIFT       0
#define I40E_PCIE_RETRY_BUF_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_ECC_EN_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_LS_FORCE_SHIFT     3
#define I40E_PCIE_RETRY_BUF_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_LS_FORCE_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_LS_BYPASS_SHIFT    4
#define I40E_PCIE_RETRY_BUF_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_LS_BYPASS_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_MASK_INT_SHIFT     5
#define I40E_PCIE_RETRY_BUF_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_MASK_INT_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_FIX_CNT_SHIFT      8
#define I40E_PCIE_RETRY_BUF_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_FIX_CNT_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_ERR_CNT_SHIFT      9
#define I40E_PCIE_RETRY_BUF_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_ERR_CNT_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_RME_SHIFT          12
#define I40E_PCIE_RETRY_BUF_CFG_RME_MASK           I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_CFG_RME_SHIFT)
#define I40E_PCIE_RETRY_BUF_CFG_RM_SHIFT           16
#define I40E_PCIE_RETRY_BUF_CFG_RM_MASK            I40E_MASK(0xF, I40E_PCIE_RETRY_BUF_CFG_RM_SHIFT)

#define I40E_PCIE_RETRY_BUF_STATUS                        0x0009D058 /* Reset: POR */
#define I40E_PCIE_RETRY_BUF_STATUS_ECC_ERR_SHIFT          0
#define I40E_PCIE_RETRY_BUF_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_STATUS_ECC_ERR_SHIFT)
#define I40E_PCIE_RETRY_BUF_STATUS_ECC_FIX_SHIFT          1
#define I40E_PCIE_RETRY_BUF_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_STATUS_ECC_FIX_SHIFT)
#define I40E_PCIE_RETRY_BUF_STATUS_INIT_DONE_SHIFT        2
#define I40E_PCIE_RETRY_BUF_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_STATUS_INIT_DONE_SHIFT)
#define I40E_PCIE_RETRY_BUF_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PCIE_RETRY_BUF_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PCIE_RETRY_BUF_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PDOC_CACHE_DBG_CTL              0x000D005C /* Reset: CORER */
#define I40E_PDOC_CACHE_DBG_CTL_ADR_SHIFT    0
#define I40E_PDOC_CACHE_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PDOC_CACHE_DBG_CTL_ADR_SHIFT)
#define I40E_PDOC_CACHE_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PDOC_CACHE_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PDOC_CACHE_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PDOC_CACHE_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PDOC_CACHE_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PDOC_CACHE_DBG_CTL_RD_EN_SHIFT)
#define I40E_PDOC_CACHE_DBG_CTL_DONE_SHIFT   31
#define I40E_PDOC_CACHE_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PDOC_CACHE_DBG_CTL_DONE_SHIFT)

#define I40E_PDOC_CACHE_DBG_DATA             0x000D0060 /* Reset: CORER */
#define I40E_PDOC_CACHE_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PDOC_CACHE_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PDOC_CACHE_DBG_DATA_RD_DW_SHIFT)

#define I40E_PDOC_CACHE_MEM_CFG                    0x000D002C /* Reset: POR */
#define I40E_PDOC_CACHE_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PDOC_CACHE_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PDOC_CACHE_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PDOC_CACHE_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PDOC_CACHE_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PDOC_CACHE_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PDOC_CACHE_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_RME_SHIFT          12
#define I40E_PDOC_CACHE_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_CFG_RME_SHIFT)
#define I40E_PDOC_CACHE_MEM_CFG_RM_SHIFT           16
#define I40E_PDOC_CACHE_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PDOC_CACHE_MEM_CFG_RM_SHIFT)

#define I40E_PDOC_CACHE_MEM_STATUS                        0x000D0030 /* Reset: POR */
#define I40E_PDOC_CACHE_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PDOC_CACHE_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PDOC_CACHE_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PDOC_CACHE_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PDOC_CACHE_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PDOC_CACHE_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PDOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PDOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PDOC_CACHE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PDOC_ECC_COR_ERR_CNT           0x000D0050 /* Reset: POR */
#define I40E_PDOC_ECC_COR_ERR_CNT_CNT_SHIFT 0
#define I40E_PDOC_ECC_COR_ERR_CNT_CNT_MASK  I40E_MASK(0xFFF, I40E_PDOC_ECC_COR_ERR_CNT_CNT_SHIFT)

#define I40E_PDOC_ECC_UNCOR_ERR_CNT           0x000D004C /* Reset: POR */
#define I40E_PDOC_ECC_UNCOR_ERR_CNT_CNT_SHIFT 0
#define I40E_PDOC_ECC_UNCOR_ERR_CNT_CNT_MASK  I40E_MASK(0xFFF, I40E_PDOC_ECC_UNCOR_ERR_CNT_CNT_SHIFT)

#define I40E_PDOC_FILL_MEM_CFG                    0x000D003C /* Reset: POR */
#define I40E_PDOC_FILL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PDOC_FILL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PDOC_FILL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PDOC_FILL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PDOC_FILL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PDOC_FILL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PDOC_FILL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_RME_SHIFT          12
#define I40E_PDOC_FILL_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PDOC_FILL_MEM_CFG_RME_SHIFT)
#define I40E_PDOC_FILL_MEM_CFG_RM_SHIFT           16
#define I40E_PDOC_FILL_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PDOC_FILL_MEM_CFG_RM_SHIFT)

#define I40E_PDOC_FILL_MEM_STATUS                        0x000D0040 /* Reset: POR */
#define I40E_PDOC_FILL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PDOC_FILL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PDOC_FILL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PDOC_FILL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PDOC_FILL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PDOC_FILL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PDOC_FILL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PDOC_FILL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PDOC_FILL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PDOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PDOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PDOC_FILL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PDOC_PLIST_DBG_CTL              0x000D0064 /* Reset: CORER */
#define I40E_PDOC_PLIST_DBG_CTL_ADR_SHIFT    0
#define I40E_PDOC_PLIST_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PDOC_PLIST_DBG_CTL_ADR_SHIFT)
#define I40E_PDOC_PLIST_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PDOC_PLIST_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PDOC_PLIST_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PDOC_PLIST_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PDOC_PLIST_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PDOC_PLIST_DBG_CTL_RD_EN_SHIFT)
#define I40E_PDOC_PLIST_DBG_CTL_DONE_SHIFT   31
#define I40E_PDOC_PLIST_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PDOC_PLIST_DBG_CTL_DONE_SHIFT)

#define I40E_PDOC_PLIST_DBG_DATA             0x000D0068 /* Reset: CORER */
#define I40E_PDOC_PLIST_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PDOC_PLIST_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PDOC_PLIST_DBG_DATA_RD_DW_SHIFT)

#define I40E_PDOC_PLIST_MEM_CFG                    0x000D0044 /* Reset: POR */
#define I40E_PDOC_PLIST_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PDOC_PLIST_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PDOC_PLIST_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PDOC_PLIST_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PDOC_PLIST_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PDOC_PLIST_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PDOC_PLIST_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_RME_SHIFT          12
#define I40E_PDOC_PLIST_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_CFG_RME_SHIFT)
#define I40E_PDOC_PLIST_MEM_CFG_RM_SHIFT           16
#define I40E_PDOC_PLIST_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PDOC_PLIST_MEM_CFG_RM_SHIFT)

#define I40E_PDOC_PLIST_MEM_STATUS                        0x000D0048 /* Reset: POR */
#define I40E_PDOC_PLIST_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PDOC_PLIST_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PDOC_PLIST_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PDOC_PLIST_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PDOC_PLIST_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PDOC_PLIST_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PDOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PDOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PDOC_PLIST_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PDOC_TAG_DBG_CTL              0x000D0054 /* Reset: CORER */
#define I40E_PDOC_TAG_DBG_CTL_ADR_SHIFT    0
#define I40E_PDOC_TAG_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_PDOC_TAG_DBG_CTL_ADR_SHIFT)
#define I40E_PDOC_TAG_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_PDOC_TAG_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_PDOC_TAG_DBG_CTL_DW_SEL_SHIFT)
#define I40E_PDOC_TAG_DBG_CTL_RD_EN_SHIFT  30
#define I40E_PDOC_TAG_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_PDOC_TAG_DBG_CTL_RD_EN_SHIFT)
#define I40E_PDOC_TAG_DBG_CTL_DONE_SHIFT   31
#define I40E_PDOC_TAG_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_PDOC_TAG_DBG_CTL_DONE_SHIFT)

#define I40E_PDOC_TAG_DBG_DATA             0x000D0058 /* Reset: CORER */
#define I40E_PDOC_TAG_DBG_DATA_RD_DW_SHIFT 0
#define I40E_PDOC_TAG_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_PDOC_TAG_DBG_DATA_RD_DW_SHIFT)

#define I40E_PDOC_TAG_MEM_CFG                    0x000D0038 /* Reset: POR */
#define I40E_PDOC_TAG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PDOC_TAG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PDOC_TAG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PDOC_TAG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PDOC_TAG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PDOC_TAG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PDOC_TAG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_RME_SHIFT          12
#define I40E_PDOC_TAG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PDOC_TAG_MEM_CFG_RME_SHIFT)
#define I40E_PDOC_TAG_MEM_CFG_RM_SHIFT           16
#define I40E_PDOC_TAG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PDOC_TAG_MEM_CFG_RM_SHIFT)

#define I40E_PDOC_TAG_MEM_STATUS                        0x000D0034 /* Reset: POR */
#define I40E_PDOC_TAG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PDOC_TAG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PDOC_TAG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PDOC_TAG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PDOC_TAG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PDOC_TAG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PDOC_TAG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PDOC_TAG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PDOC_TAG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PDOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PDOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PDOC_TAG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PKT_INDICATIONS(_i)              (0x000AC920 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PKT_INDICATIONS_MAX_INDEX        7
#define I40E_PKT_INDICATIONS_START_CNT_SHIFT  0
#define I40E_PKT_INDICATIONS_START_CNT_MASK   I40E_MASK(0xFF, I40E_PKT_INDICATIONS_START_CNT_SHIFT)
#define I40E_PKT_INDICATIONS_END_CNT_SHIFT    8
#define I40E_PKT_INDICATIONS_END_CNT_MASK     I40E_MASK(0xFF, I40E_PKT_INDICATIONS_END_CNT_SHIFT)
#define I40E_PKT_INDICATIONS_STATUS_CNT_SHIFT 16
#define I40E_PKT_INDICATIONS_STATUS_CNT_MASK  I40E_MASK(0xFF, I40E_PKT_INDICATIONS_STATUS_CNT_SHIFT)
#define I40E_PKT_INDICATIONS_DROP_CNT_SHIFT   24
#define I40E_PKT_INDICATIONS_DROP_CNT_MASK    I40E_MASK(0xFF, I40E_PKT_INDICATIONS_DROP_CNT_SHIFT)

#define I40E_PMAT_ECC_COR_ERR           0x000C20CC /* Reset: POR */
#define I40E_PMAT_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_PMAT_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PMAT_ECC_COR_ERR_CNT_SHIFT)

#define I40E_PMAT_ECC_UNCOR_ERR_CNT           0x000C20C8 /* Reset: POR */
#define I40E_PMAT_ECC_UNCOR_ERR_CNT_CNT_SHIFT 0
#define I40E_PMAT_ECC_UNCOR_ERR_CNT_CNT_MASK  I40E_MASK(0xFFF, I40E_PMAT_ECC_UNCOR_ERR_CNT_CNT_SHIFT)

#define I40E_PMAT_OBJ_BASE_RAM_CFG                    0x000C20B8 /* Reset: POR */
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_EN_SHIFT       0
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_EN_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_LS_FORCE_SHIFT     3
#define I40E_PMAT_OBJ_BASE_RAM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_LS_FORCE_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PMAT_OBJ_BASE_RAM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_LS_BYPASS_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_MASK_INT_SHIFT     5
#define I40E_PMAT_OBJ_BASE_RAM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_MASK_INT_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_FIX_CNT_SHIFT      8
#define I40E_PMAT_OBJ_BASE_RAM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_FIX_CNT_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ERR_CNT_SHIFT      9
#define I40E_PMAT_OBJ_BASE_RAM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_ERR_CNT_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_RME_SHIFT          12
#define I40E_PMAT_OBJ_BASE_RAM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_CFG_RME_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_CFG_RM_SHIFT           16
#define I40E_PMAT_OBJ_BASE_RAM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PMAT_OBJ_BASE_RAM_CFG_RM_SHIFT)

#define I40E_PMAT_OBJ_BASE_RAM_STATUS                        0x000C20BC /* Reset: POR */
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_ERR_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_STATUS_ECC_FIX_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_STATUS_INIT_DONE_SHIFT)
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PMAT_OBJ_BASE_RAM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BASE_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PMAT_OBJ_BNDS_RAM_CFG                    0x000C20C0 /* Reset: POR */
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_EN_SHIFT       0
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_EN_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_FORCE_SHIFT     3
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_FORCE_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_LS_BYPASS_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_MASK_INT_SHIFT     5
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_MASK_INT_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_FIX_CNT_SHIFT      8
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_FIX_CNT_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ERR_CNT_SHIFT      9
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_ERR_CNT_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_RME_SHIFT          12
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_CFG_RME_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_RM_SHIFT           16
#define I40E_PMAT_OBJ_BNDS_RAM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PMAT_OBJ_BNDS_RAM_CFG_RM_SHIFT)

#define I40E_PMAT_OBJ_BNDS_RAM_STATUS                        0x000C20C4 /* Reset: POR */
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_ERR_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_STATUS_ECC_FIX_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_STATUS_INIT_DONE_SHIFT)
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PMAT_OBJ_BNDS_RAM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PMAT_OBJ_BNDS_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PMAT_ST_RAM_CFG                    0x000C20B0 /* Reset: POR */
#define I40E_PMAT_ST_RAM_CFG_ECC_EN_SHIFT       0
#define I40E_PMAT_ST_RAM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_ECC_EN_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PMAT_ST_RAM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PMAT_ST_RAM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_LS_FORCE_SHIFT     3
#define I40E_PMAT_ST_RAM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_LS_FORCE_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PMAT_ST_RAM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_LS_BYPASS_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_MASK_INT_SHIFT     5
#define I40E_PMAT_ST_RAM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_MASK_INT_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_FIX_CNT_SHIFT      8
#define I40E_PMAT_ST_RAM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_FIX_CNT_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_ERR_CNT_SHIFT      9
#define I40E_PMAT_ST_RAM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_ERR_CNT_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_RME_SHIFT          12
#define I40E_PMAT_ST_RAM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PMAT_ST_RAM_CFG_RME_SHIFT)
#define I40E_PMAT_ST_RAM_CFG_RM_SHIFT           16
#define I40E_PMAT_ST_RAM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PMAT_ST_RAM_CFG_RM_SHIFT)

#define I40E_PMAT_ST_RAM_STATUS                        0x000C20B4 /* Reset: POR */
#define I40E_PMAT_ST_RAM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PMAT_ST_RAM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PMAT_ST_RAM_STATUS_ECC_ERR_SHIFT)
#define I40E_PMAT_ST_RAM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PMAT_ST_RAM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PMAT_ST_RAM_STATUS_ECC_FIX_SHIFT)
#define I40E_PMAT_ST_RAM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PMAT_ST_RAM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PMAT_ST_RAM_STATUS_INIT_DONE_SHIFT)
#define I40E_PMAT_ST_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PMAT_ST_RAM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PMAT_ST_RAM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PORT_CMD_BUF_MEM_CFG                    0x000AE094 /* Reset: POR */
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PORT_CMD_BUF_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PORT_CMD_BUF_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PORT_CMD_BUF_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PORT_CMD_BUF_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PORT_CMD_BUF_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_RME_SHIFT          12
#define I40E_PORT_CMD_BUF_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_CFG_RME_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_CFG_RM_SHIFT           16
#define I40E_PORT_CMD_BUF_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PORT_CMD_BUF_MEM_CFG_RM_SHIFT)

#define I40E_PORT_CMD_BUF_MEM_STATUS                        0x000AE098 /* Reset: POR */
#define I40E_PORT_CMD_BUF_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PORT_CMD_BUF_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PORT_CMD_BUF_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PORT_CMD_BUF_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PORT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PORT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PORT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PORT_CMD_MNG_MEM_CFG                    0x000AE09C /* Reset: POR */
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_PORT_CMD_MNG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_PORT_CMD_MNG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_PORT_CMD_MNG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_PORT_CMD_MNG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_PORT_CMD_MNG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_RME_SHIFT          12
#define I40E_PORT_CMD_MNG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_CFG_RME_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_CFG_RM_SHIFT           16
#define I40E_PORT_CMD_MNG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_PORT_CMD_MNG_MEM_CFG_RM_SHIFT)

#define I40E_PORT_CMD_MNG_MEM_STATUS                        0x000AE0A0 /* Reset: POR */
#define I40E_PORT_CMD_MNG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_PORT_CMD_MNG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_PORT_CMD_MNG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_PORT_CMD_MNG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_PORT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PORT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PORT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PPRS_ECC_COR_ERR           0x00085BA0 /* Reset: POR */
#define I40E_PPRS_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_PPRS_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PPRS_ECC_COR_ERR_CNT_SHIFT)

#define I40E_PPRS_ECC_UNCOR_ERR           0x00085B80 /* Reset: POR */
#define I40E_PPRS_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_PPRS_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_PPRS_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_PPRS_PCKT_CFG                    0x00085B00 /* Reset: POR */
#define I40E_PPRS_PCKT_CFG_ECC_EN_SHIFT       0
#define I40E_PPRS_PCKT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_ECC_EN_SHIFT)
#define I40E_PPRS_PCKT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PPRS_PCKT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PPRS_PCKT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PPRS_PCKT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PPRS_PCKT_CFG_LS_FORCE_SHIFT     3
#define I40E_PPRS_PCKT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_LS_FORCE_SHIFT)
#define I40E_PPRS_PCKT_CFG_LS_BYPASS_SHIFT    4
#define I40E_PPRS_PCKT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_LS_BYPASS_SHIFT)
#define I40E_PPRS_PCKT_CFG_MASK_INT_SHIFT     5
#define I40E_PPRS_PCKT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_MASK_INT_SHIFT)
#define I40E_PPRS_PCKT_CFG_FIX_CNT_SHIFT      8
#define I40E_PPRS_PCKT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_FIX_CNT_SHIFT)
#define I40E_PPRS_PCKT_CFG_ERR_CNT_SHIFT      9
#define I40E_PPRS_PCKT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_ERR_CNT_SHIFT)
#define I40E_PPRS_PCKT_CFG_RME_SHIFT          12
#define I40E_PPRS_PCKT_CFG_RME_MASK           I40E_MASK(0x1, I40E_PPRS_PCKT_CFG_RME_SHIFT)
#define I40E_PPRS_PCKT_CFG_RM_SHIFT           16
#define I40E_PPRS_PCKT_CFG_RM_MASK            I40E_MASK(0xF, I40E_PPRS_PCKT_CFG_RM_SHIFT)

#define I40E_PPRS_PCKT_STATUS                        0x00085B20 /* Reset: POR */
#define I40E_PPRS_PCKT_STATUS_ECC_ERR_SHIFT          0
#define I40E_PPRS_PCKT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PPRS_PCKT_STATUS_ECC_ERR_SHIFT)
#define I40E_PPRS_PCKT_STATUS_ECC_FIX_SHIFT          1
#define I40E_PPRS_PCKT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PPRS_PCKT_STATUS_ECC_FIX_SHIFT)
#define I40E_PPRS_PCKT_STATUS_INIT_DONE_SHIFT        2
#define I40E_PPRS_PCKT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PPRS_PCKT_STATUS_INIT_DONE_SHIFT)
#define I40E_PPRS_PCKT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PPRS_PCKT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PPRS_PCKT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PPRS_RECIPE_CFG                    0x00085B40 /* Reset: POR */
#define I40E_PPRS_RECIPE_CFG_ECC_EN_SHIFT       0
#define I40E_PPRS_RECIPE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_ECC_EN_SHIFT)
#define I40E_PPRS_RECIPE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_PPRS_RECIPE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_PPRS_RECIPE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_PPRS_RECIPE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_PPRS_RECIPE_CFG_LS_FORCE_SHIFT     3
#define I40E_PPRS_RECIPE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_LS_FORCE_SHIFT)
#define I40E_PPRS_RECIPE_CFG_LS_BYPASS_SHIFT    4
#define I40E_PPRS_RECIPE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_LS_BYPASS_SHIFT)
#define I40E_PPRS_RECIPE_CFG_MASK_INT_SHIFT     5
#define I40E_PPRS_RECIPE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_MASK_INT_SHIFT)
#define I40E_PPRS_RECIPE_CFG_FIX_CNT_SHIFT      8
#define I40E_PPRS_RECIPE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_FIX_CNT_SHIFT)
#define I40E_PPRS_RECIPE_CFG_ERR_CNT_SHIFT      9
#define I40E_PPRS_RECIPE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_ERR_CNT_SHIFT)
#define I40E_PPRS_RECIPE_CFG_RME_SHIFT          12
#define I40E_PPRS_RECIPE_CFG_RME_MASK           I40E_MASK(0x1, I40E_PPRS_RECIPE_CFG_RME_SHIFT)
#define I40E_PPRS_RECIPE_CFG_RM_SHIFT           16
#define I40E_PPRS_RECIPE_CFG_RM_MASK            I40E_MASK(0xF, I40E_PPRS_RECIPE_CFG_RM_SHIFT)

#define I40E_PPRS_RECIPE_STATUS                        0x00085B60 /* Reset: POR */
#define I40E_PPRS_RECIPE_STATUS_ECC_ERR_SHIFT          0
#define I40E_PPRS_RECIPE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_PPRS_RECIPE_STATUS_ECC_ERR_SHIFT)
#define I40E_PPRS_RECIPE_STATUS_ECC_FIX_SHIFT          1
#define I40E_PPRS_RECIPE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_PPRS_RECIPE_STATUS_ECC_FIX_SHIFT)
#define I40E_PPRS_RECIPE_STATUS_INIT_DONE_SHIFT        2
#define I40E_PPRS_RECIPE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_PPRS_RECIPE_STATUS_INIT_DONE_SHIFT)
#define I40E_PPRS_RECIPE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_PPRS_RECIPE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_PPRS_RECIPE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_PRT_PPRS_CTRL                     0x00086000 /* Reset: CORER */
#define I40E_PRT_PPRS_CTRL_HDR_VLD_SEL_SHIFT   0
#define I40E_PRT_PPRS_CTRL_HDR_VLD_SEL_MASK    I40E_MASK(0x3, I40E_PRT_PPRS_CTRL_HDR_VLD_SEL_SHIFT)
#define I40E_PRT_PPRS_CTRL_STOP_ANA_DIS_SHIFT  2
#define I40E_PRT_PPRS_CTRL_STOP_ANA_DIS_MASK   I40E_MASK(0x1, I40E_PRT_PPRS_CTRL_STOP_ANA_DIS_SHIFT)
#define I40E_PRT_PPRS_CTRL_PRE_LY2_L2_EN_SHIFT 3
#define I40E_PRT_PPRS_CTRL_PRE_LY2_L2_EN_MASK  I40E_MASK(0x1, I40E_PRT_PPRS_CTRL_PRE_LY2_L2_EN_SHIFT)
#define I40E_PRT_PPRS_CTRL_PRE_LY2_L3_EN_SHIFT 4
#define I40E_PRT_PPRS_CTRL_PRE_LY2_L3_EN_MASK  I40E_MASK(0x1, I40E_PRT_PPRS_CTRL_PRE_LY2_L3_EN_SHIFT)
#define I40E_PRT_PPRS_CTRL_SPARE_27B_SHIFT     5
#define I40E_PRT_PPRS_CTRL_SPARE_27B_MASK      I40E_MASK(0x7FFFFFF, I40E_PRT_PPRS_CTRL_SPARE_27B_SHIFT)

#define I40E_PRT_PPRS_DEFUALT_RECIPE_PTR                          0x00086040 /* Reset: CORER */
#define I40E_PRT_PPRS_DEFUALT_RECIPE_PTR_DEFUALT_RECIPE_PTR_SHIFT 0
#define I40E_PRT_PPRS_DEFUALT_RECIPE_PTR_DEFUALT_RECIPE_PTR_MASK  I40E_MASK(0x3FFFFF, I40E_PRT_PPRS_DEFUALT_RECIPE_PTR_DEFUALT_RECIPE_PTR_SHIFT)

#define I40E_PRT_PPRS_DONE_CNT                    0x00087020 /* Reset: CORER */
#define I40E_PRT_PPRS_DONE_CNT_LY3_DONE_CNT_SHIFT 0
#define I40E_PRT_PPRS_DONE_CNT_LY3_DONE_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_DONE_CNT_LY3_DONE_CNT_SHIFT)
#define I40E_PRT_PPRS_DONE_CNT_LY2_DONE_CNT_SHIFT 16
#define I40E_PRT_PPRS_DONE_CNT_LY2_DONE_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_DONE_CNT_LY2_DONE_CNT_SHIFT)

#define I40E_PRT_PPRS_DROP_CNT                         0x00087000 /* Reset: CORER */
#define I40E_PRT_PPRS_DROP_CNT_PRT_PPRS_DROP_CNT_SHIFT 0
#define I40E_PRT_PPRS_DROP_CNT_PRT_PPRS_DROP_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_DROP_CNT_PRT_PPRS_DROP_CNT_SHIFT)

#define I40E_PRT_PPRS_HDR_VLD_PCTYPE_EN                         0x00086060 /* Reset: CORER */
#define I40E_PRT_PPRS_HDR_VLD_PCTYPE_EN_HDR_VLD_PCTYPE_EN_SHIFT 0
#define I40E_PRT_PPRS_HDR_VLD_PCTYPE_EN_HDR_VLD_PCTYPE_EN_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_HDR_VLD_PCTYPE_EN_HDR_VLD_PCTYPE_EN_SHIFT)

#define I40E_PRT_PPRS_NOT_PARSE_CNT                    0x00087040 /* Reset: CORER */
#define I40E_PRT_PPRS_NOT_PARSE_CNT_STOP_ANA_CNT_SHIFT 0
#define I40E_PRT_PPRS_NOT_PARSE_CNT_STOP_ANA_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_NOT_PARSE_CNT_STOP_ANA_CNT_SHIFT)
#define I40E_PRT_PPRS_NOT_PARSE_CNT_ABORT_CNT_SHIFT    16
#define I40E_PRT_PPRS_NOT_PARSE_CNT_ABORT_CNT_MASK     I40E_MASK(0xFFFF, I40E_PRT_PPRS_NOT_PARSE_CNT_ABORT_CNT_SHIFT)

#define I40E_PRT_PPRS_PERF_BUF                 0x00086020 /* Reset: CORER */
#define I40E_PRT_PPRS_PERF_BUF_HI_TRESH_SHIFT  0
#define I40E_PRT_PPRS_PERF_BUF_HI_TRESH_MASK   I40E_MASK(0x3F, I40E_PRT_PPRS_PERF_BUF_HI_TRESH_SHIFT)
#define I40E_PRT_PPRS_PERF_BUF_LOW_TRESH_SHIFT 16
#define I40E_PRT_PPRS_PERF_BUF_LOW_TRESH_MASK  I40E_MASK(0x3F, I40E_PRT_PPRS_PERF_BUF_LOW_TRESH_SHIFT)

#define I40E_PRT_PPRS_PKTS_CNT                  0x00087060 /* Reset: CORER */
#define I40E_PRT_PPRS_PKTS_CNT_RPB_IF_CNT_SHIFT 0
#define I40E_PRT_PPRS_PKTS_CNT_RPB_IF_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_PKTS_CNT_RPB_IF_CNT_SHIFT)
#define I40E_PRT_PPRS_PKTS_CNT_MAC_IF_CNT_SHIFT 16
#define I40E_PRT_PPRS_PKTS_CNT_MAC_IF_CNT_MASK  I40E_MASK(0xFFFF, I40E_PRT_PPRS_PKTS_CNT_MAC_IF_CNT_SHIFT)

#define I40E_PRT_SWR_PM_THR                 0x0026CD00 /* Reset: CORER */
#define I40E_PRT_SWR_PM_THR_THRESHOLD_SHIFT 0
#define I40E_PRT_SWR_PM_THR_THRESHOLD_MASK  I40E_MASK(0xFF, I40E_PRT_SWR_PM_THR_THRESHOLD_SHIFT)

#define I40E_RCB_CHUNK_DATA_CFG                    0x00122644 /* Reset: POR */
#define I40E_RCB_CHUNK_DATA_CFG_ECC_EN_SHIFT       0
#define I40E_RCB_CHUNK_DATA_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_ECC_EN_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_LS_FORCE_SHIFT     3
#define I40E_RCB_CHUNK_DATA_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_LS_FORCE_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCB_CHUNK_DATA_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_LS_BYPASS_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_MASK_INT_SHIFT     5
#define I40E_RCB_CHUNK_DATA_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_MASK_INT_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_FIX_CNT_SHIFT      8
#define I40E_RCB_CHUNK_DATA_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_FIX_CNT_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_ERR_CNT_SHIFT      9
#define I40E_RCB_CHUNK_DATA_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_ERR_CNT_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_RME_SHIFT          12
#define I40E_RCB_CHUNK_DATA_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_CFG_RME_SHIFT)
#define I40E_RCB_CHUNK_DATA_CFG_RM_SHIFT           16
#define I40E_RCB_CHUNK_DATA_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCB_CHUNK_DATA_CFG_RM_SHIFT)

#define I40E_RCB_CHUNK_DATA_STATUS                        0x00122648 /* Reset: POR */
#define I40E_RCB_CHUNK_DATA_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCB_CHUNK_DATA_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_STATUS_ECC_ERR_SHIFT)
#define I40E_RCB_CHUNK_DATA_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCB_CHUNK_DATA_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_STATUS_ECC_FIX_SHIFT)
#define I40E_RCB_CHUNK_DATA_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCB_CHUNK_DATA_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_STATUS_INIT_DONE_SHIFT)
#define I40E_RCB_CHUNK_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCB_CHUNK_DATA_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCB_CHUNK_DATA_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCB_ECC_COR_ERR           0x00122668 /* Reset: POR */
#define I40E_RCB_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RCB_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCB_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RCB_ECC_UNCOR_ERR           0x00122664 /* Reset: POR */
#define I40E_RCB_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RCB_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCB_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RCB_HEAD_CACHE_CFG                    0x0012264C /* Reset: POR */
#define I40E_RCB_HEAD_CACHE_CFG_ECC_EN_SHIFT       0
#define I40E_RCB_HEAD_CACHE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_ECC_EN_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_LS_FORCE_SHIFT     3
#define I40E_RCB_HEAD_CACHE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_LS_FORCE_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCB_HEAD_CACHE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_LS_BYPASS_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_MASK_INT_SHIFT     5
#define I40E_RCB_HEAD_CACHE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_MASK_INT_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_FIX_CNT_SHIFT      8
#define I40E_RCB_HEAD_CACHE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_FIX_CNT_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_ERR_CNT_SHIFT      9
#define I40E_RCB_HEAD_CACHE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_ERR_CNT_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_RME_SHIFT          12
#define I40E_RCB_HEAD_CACHE_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_CFG_RME_SHIFT)
#define I40E_RCB_HEAD_CACHE_CFG_RM_SHIFT           16
#define I40E_RCB_HEAD_CACHE_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCB_HEAD_CACHE_CFG_RM_SHIFT)

#define I40E_RCB_HEAD_CACHE_STATUS                        0x00122650 /* Reset: POR */
#define I40E_RCB_HEAD_CACHE_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCB_HEAD_CACHE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_STATUS_ECC_ERR_SHIFT)
#define I40E_RCB_HEAD_CACHE_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCB_HEAD_CACHE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_STATUS_ECC_FIX_SHIFT)
#define I40E_RCB_HEAD_CACHE_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCB_HEAD_CACHE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_STATUS_INIT_DONE_SHIFT)
#define I40E_RCB_HEAD_CACHE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCB_HEAD_CACHE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCB_HEAD_CACHE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCB_INPUT_FIFO_CFG                    0x0012265C /* Reset: POR */
#define I40E_RCB_INPUT_FIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RCB_INPUT_FIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_ECC_EN_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RCB_INPUT_FIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCB_INPUT_FIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RCB_INPUT_FIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_MASK_INT_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RCB_INPUT_FIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RCB_INPUT_FIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_RME_SHIFT          12
#define I40E_RCB_INPUT_FIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_CFG_RME_SHIFT)
#define I40E_RCB_INPUT_FIFO_CFG_RM_SHIFT           16
#define I40E_RCB_INPUT_FIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCB_INPUT_FIFO_CFG_RM_SHIFT)

#define I40E_RCB_INPUT_FIFO_STATUS                        0x00122660 /* Reset: POR */
#define I40E_RCB_INPUT_FIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCB_INPUT_FIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RCB_INPUT_FIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCB_INPUT_FIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RCB_INPUT_FIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCB_INPUT_FIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RCB_INPUT_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCB_INPUT_FIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCB_INPUT_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCB_LL_CFG                    0x00122654 /* Reset: POR */
#define I40E_RCB_LL_CFG_ECC_EN_SHIFT       0
#define I40E_RCB_LL_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCB_LL_CFG_ECC_EN_SHIFT)
#define I40E_RCB_LL_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCB_LL_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCB_LL_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCB_LL_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCB_LL_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCB_LL_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCB_LL_CFG_LS_FORCE_SHIFT     3
#define I40E_RCB_LL_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCB_LL_CFG_LS_FORCE_SHIFT)
#define I40E_RCB_LL_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCB_LL_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCB_LL_CFG_LS_BYPASS_SHIFT)
#define I40E_RCB_LL_CFG_MASK_INT_SHIFT     5
#define I40E_RCB_LL_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCB_LL_CFG_MASK_INT_SHIFT)
#define I40E_RCB_LL_CFG_FIX_CNT_SHIFT      8
#define I40E_RCB_LL_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCB_LL_CFG_FIX_CNT_SHIFT)
#define I40E_RCB_LL_CFG_ERR_CNT_SHIFT      9
#define I40E_RCB_LL_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCB_LL_CFG_ERR_CNT_SHIFT)
#define I40E_RCB_LL_CFG_RME_SHIFT          12
#define I40E_RCB_LL_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCB_LL_CFG_RME_SHIFT)
#define I40E_RCB_LL_CFG_RM_SHIFT           16
#define I40E_RCB_LL_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCB_LL_CFG_RM_SHIFT)

#define I40E_RCB_LL_STATUS                        0x00122658 /* Reset: POR */
#define I40E_RCB_LL_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCB_LL_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCB_LL_STATUS_ECC_ERR_SHIFT)
#define I40E_RCB_LL_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCB_LL_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCB_LL_STATUS_ECC_FIX_SHIFT)
#define I40E_RCB_LL_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCB_LL_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCB_LL_STATUS_INIT_DONE_SHIFT)
#define I40E_RCB_LL_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCB_LL_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCB_LL_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_DP_MTG_MFIFO_CFG                    0x00269B34 /* Reset: POR */
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_ECC_EN_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_DP_MTG_MFIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_DP_MTG_MFIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_DP_MTG_MFIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_MASK_INT_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_DP_MTG_MFIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_DP_MTG_MFIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_RME_SHIFT          12
#define I40E_RCU_DP_MTG_MFIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_CFG_RME_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_CFG_RM_SHIFT           16
#define I40E_RCU_DP_MTG_MFIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_DP_MTG_MFIFO_CFG_RM_SHIFT)

#define I40E_RCU_DP_MTG_MFIFO_STATUS                        0x00269B3C /* Reset: POR */
#define I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_DP_MTG_MFIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_DP_MTG_MFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_DP_MTG_MFIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_DP_MTG_MFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_DP_SWR_REP_MFIFO_CFG                    0x00269B44 /* Reset: POR */
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_EN_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_MASK_INT_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_RME_SHIFT          12
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_CFG_RME_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_RM_SHIFT           16
#define I40E_RCU_DP_SWR_REP_MFIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_DP_SWR_REP_MFIFO_CFG_RM_SHIFT)

#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS                        0x00269B4C /* Reset: POR */
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_DP_SWR_REP_MFIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_REP_MFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_DP_SWR_UP_STATUS_CFG                    0x00269AFC /* Reset: POR */
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_EN_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_MASK_INT_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_RME_SHIFT          12
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_CFG_RME_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_RM_SHIFT           16
#define I40E_RCU_DP_SWR_UP_STATUS_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_DP_SWR_UP_STATUS_CFG_RM_SHIFT)

#define I40E_RCU_DP_SWR_UP_STATUS_STATUS                        0x00269B0C /* Reset: POR */
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_DP_SWR_UP_STATUS_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_DP_SWR_UP_STATUS_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_DP_TFIFO_CFG                    0x0026CBD4 /* Reset: POR */
#define I40E_RCU_DP_TFIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_DP_TFIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_ECC_EN_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_DP_TFIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_DP_TFIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_DP_TFIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_MASK_INT_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_DP_TFIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_DP_TFIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_RME_SHIFT          12
#define I40E_RCU_DP_TFIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_DP_TFIFO_CFG_RME_SHIFT)
#define I40E_RCU_DP_TFIFO_CFG_RM_SHIFT           16
#define I40E_RCU_DP_TFIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_DP_TFIFO_CFG_RM_SHIFT)

#define I40E_RCU_DP_TFIFO_STATUS                        0x0026CBE4 /* Reset: POR */
#define I40E_RCU_DP_TFIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_DP_TFIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_DP_TFIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_DP_TFIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_DP_TFIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_DP_TFIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_DP_TFIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_DP_TFIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_DP_TFIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_DP_TFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_DP_TFIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_DP_TFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_FCOE_PCTYPE_OVR_CTL                                     0x0026CC28 /* Reset: CORER */
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_OVERRIDE_METHOD_SHIFT               0
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_OVERRIDE_METHOD_MASK                I40E_MASK(0xF, I40E_RCU_FCOE_PCTYPE_OVR_CTL_OVERRIDE_METHOD_SHIFT)
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_EXCHANGE_CONTEXT_IDX_SHIFT   4
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_EXCHANGE_CONTEXT_IDX_MASK    I40E_MASK(0x7, I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_EXCHANGE_CONTEXT_IDX_SHIFT)
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_EXCHANGE_CONTEXT_IDX_SHIFT 8
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_EXCHANGE_CONTEXT_IDX_MASK  I40E_MASK(0x7, I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_EXCHANGE_CONTEXT_IDX_SHIFT)
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_SEQUENCE_CONTEXT_IDX_SHIFT   12
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_SEQUENCE_CONTEXT_IDX_MASK    I40E_MASK(0x7, I40E_RCU_FCOE_PCTYPE_OVR_CTL_ACTIVE_SEQUENCE_CONTEXT_IDX_SHIFT)
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_SEQUENCE_CONTEXT_IDX_SHIFT 16
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_SEQUENCE_CONTEXT_IDX_MASK  I40E_MASK(0x7, I40E_RCU_FCOE_PCTYPE_OVR_CTL_INACTIVE_SEQUENCE_CONTEXT_IDX_SHIFT)
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_MANUAL_IDX_SHIFT                    20
#define I40E_RCU_FCOE_PCTYPE_OVR_CTL_MANUAL_IDX_MASK                     I40E_MASK(0x7, I40E_RCU_FCOE_PCTYPE_OVR_CTL_MANUAL_IDX_SHIFT)

#define I40E_RCU_FD_CNT_CFG                    0x0026CB04 /* Reset: POR */
#define I40E_RCU_FD_CNT_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_FD_CNT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_ECC_EN_SHIFT)
#define I40E_RCU_FD_CNT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_FD_CNT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_FD_CNT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_FD_CNT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_FD_CNT_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_FD_CNT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_FD_CNT_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_FD_CNT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_FD_CNT_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_FD_CNT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_MASK_INT_SHIFT)
#define I40E_RCU_FD_CNT_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_FD_CNT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_FD_CNT_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_FD_CNT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_FD_CNT_CFG_RME_SHIFT          12
#define I40E_RCU_FD_CNT_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_FD_CNT_CFG_RME_SHIFT)
#define I40E_RCU_FD_CNT_CFG_RM_SHIFT           16
#define I40E_RCU_FD_CNT_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_FD_CNT_CFG_RM_SHIFT)

#define I40E_RCU_FD_CNT_STATUS                        0x0026CB0C /* Reset: POR */
#define I40E_RCU_FD_CNT_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_FD_CNT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_FD_CNT_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_FD_CNT_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_FD_CNT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_FD_CNT_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_FD_CNT_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_FD_CNT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_FD_CNT_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_FD_CNT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_FD_CNT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_FD_CNT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_FD_FLU_LUT_CFG                    0x0026CB14 /* Reset: POR */
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_ECC_EN_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_FD_FLU_LUT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_FD_FLU_LUT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_FD_FLU_LUT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_MASK_INT_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_FD_FLU_LUT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_FD_FLU_LUT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_RME_SHIFT          12
#define I40E_RCU_FD_FLU_LUT_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_CFG_RME_SHIFT)
#define I40E_RCU_FD_FLU_LUT_CFG_RM_SHIFT           16
#define I40E_RCU_FD_FLU_LUT_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_FD_FLU_LUT_CFG_RM_SHIFT)

#define I40E_RCU_FD_FLU_LUT_STATUS                        0x0026CB1C /* Reset: POR */
#define I40E_RCU_FD_FLU_LUT_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_FD_FLU_LUT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_FD_FLU_LUT_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_FD_FLU_LUT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_FD_FLU_LUT_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_FD_FLU_LUT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_FD_FLU_LUT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_FD_FLU_LUT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_FD_FLU_LUT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_FOC_TAILS_CFG                    0x00269ADC /* Reset: POR */
#define I40E_RCU_FOC_TAILS_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_FOC_TAILS_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_ECC_EN_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_FOC_TAILS_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_FOC_TAILS_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_FOC_TAILS_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_MASK_INT_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_FOC_TAILS_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_FOC_TAILS_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_RME_SHIFT          12
#define I40E_RCU_FOC_TAILS_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_FOC_TAILS_CFG_RME_SHIFT)
#define I40E_RCU_FOC_TAILS_CFG_RM_SHIFT           16
#define I40E_RCU_FOC_TAILS_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_FOC_TAILS_CFG_RM_SHIFT)

#define I40E_RCU_FOC_TAILS_STATUS                        0x00269B2C /* Reset: POR */
#define I40E_RCU_FOC_TAILS_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_FOC_TAILS_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_FOC_TAILS_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_FOC_TAILS_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_FOC_TAILS_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_FOC_TAILS_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_FOC_TAILS_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_FOC_TAILS_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_FOC_TAILS_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_FOC_TAILS_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_FOC_TAILS_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_FOC_TAILS_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_PST_DBG_CTL                           0x0026CC24 /* Reset: CORER */
#define I40E_RCU_PST_DBG_CTL_IGNORE_FLR_SHIFT          0
#define I40E_RCU_PST_DBG_CTL_IGNORE_FLR_MASK           I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_FLR_SHIFT)
#define I40E_RCU_PST_DBG_CTL_IGNORE_VFLR_SHIFT         1
#define I40E_RCU_PST_DBG_CTL_IGNORE_VFLR_MASK          I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_VFLR_SHIFT)
#define I40E_RCU_PST_DBG_CTL_IGNORE_VMLR_SHIFT         2
#define I40E_RCU_PST_DBG_CTL_IGNORE_VMLR_MASK          I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_VMLR_SHIFT)
#define I40E_RCU_PST_DBG_CTL_USE_PCTYPE_FCOE_SHIFT     3
#define I40E_RCU_PST_DBG_CTL_USE_PCTYPE_FCOE_MASK      I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_USE_PCTYPE_FCOE_SHIFT)
#define I40E_RCU_PST_DBG_CTL_IGNORE_ETH_HIT_SHIFT      4
#define I40E_RCU_PST_DBG_CTL_IGNORE_ETH_HIT_MASK       I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_ETH_HIT_SHIFT)
#define I40E_RCU_PST_DBG_CTL_IGNORE_MAC_VLAN_HIT_SHIFT 5
#define I40E_RCU_PST_DBG_CTL_IGNORE_MAC_VLAN_HIT_MASK  I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_MAC_VLAN_HIT_SHIFT)
#define I40E_RCU_PST_DBG_CTL_IGNORE_SWR_DROP_SHIFT     6
#define I40E_RCU_PST_DBG_CTL_IGNORE_SWR_DROP_MASK      I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_IGNORE_SWR_DROP_SHIFT)
#define I40E_RCU_PST_DBG_CTL_HOLD_FLU_JOBS_SHIFT       7
#define I40E_RCU_PST_DBG_CTL_HOLD_FLU_JOBS_MASK        I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_HOLD_FLU_JOBS_SHIFT)
#define I40E_RCU_PST_DBG_CTL_FC_HASH_BASE_SHIFT        8
#define I40E_RCU_PST_DBG_CTL_FC_HASH_BASE_MASK         I40E_MASK(0xF, I40E_RCU_PST_DBG_CTL_FC_HASH_BASE_SHIFT)
#define I40E_RCU_PST_DBG_CTL_PE_HASH_BASE_SHIFT        12
#define I40E_RCU_PST_DBG_CTL_PE_HASH_BASE_MASK         I40E_MASK(0xF, I40E_RCU_PST_DBG_CTL_PE_HASH_BASE_SHIFT)
#define I40E_RCU_PST_DBG_CTL_FD_HASH_BASE_SHIFT        16
#define I40E_RCU_PST_DBG_CTL_FD_HASH_BASE_MASK         I40E_MASK(0xF, I40E_RCU_PST_DBG_CTL_FD_HASH_BASE_SHIFT)
#define I40E_RCU_PST_DBG_CTL_FOC_CNTX_LIMIT_BASE_SHIFT 20
#define I40E_RCU_PST_DBG_CTL_FOC_CNTX_LIMIT_BASE_MASK  I40E_MASK(0xF, I40E_RCU_PST_DBG_CTL_FOC_CNTX_LIMIT_BASE_SHIFT)
#define I40E_RCU_PST_DBG_CTL_ERR_COMP_DIS_SHIFT        24
#define I40E_RCU_PST_DBG_CTL_ERR_COMP_DIS_MASK         I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_ERR_COMP_DIS_SHIFT)
#define I40E_RCU_PST_DBG_CTL_REM_COMP_DIS_SHIFT        25
#define I40E_RCU_PST_DBG_CTL_REM_COMP_DIS_MASK         I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_REM_COMP_DIS_SHIFT)
#define I40E_RCU_PST_DBG_CTL_HOLD_PST_INPUT_SHIFT      28
#define I40E_RCU_PST_DBG_CTL_HOLD_PST_INPUT_MASK       I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_HOLD_PST_INPUT_SHIFT)
#define I40E_RCU_PST_DBG_CTL_INC_INPUT_CMD_SHIFT       29
#define I40E_RCU_PST_DBG_CTL_INC_INPUT_CMD_MASK        I40E_MASK(0x1, I40E_RCU_PST_DBG_CTL_INC_INPUT_CMD_SHIFT)

#define I40E_RCU_PST_DBG_DROP_CNT                         0x0026CBEC /* Reset: CORER */
#define I40E_RCU_PST_DBG_DROP_CNT_FD_DROP_CNT_SHIFT       0
#define I40E_RCU_PST_DBG_DROP_CNT_FD_DROP_CNT_MASK        I40E_MASK(0xFF, I40E_RCU_PST_DBG_DROP_CNT_FD_DROP_CNT_SHIFT)
#define I40E_RCU_PST_DBG_DROP_CNT_FLR_DROP_CNT_SHIFT      8
#define I40E_RCU_PST_DBG_DROP_CNT_FLR_DROP_CNT_MASK       I40E_MASK(0xFF, I40E_RCU_PST_DBG_DROP_CNT_FLR_DROP_CNT_SHIFT)
#define I40E_RCU_PST_DBG_DROP_CNT_PF_BOUND_DROP_CNT_SHIFT 16
#define I40E_RCU_PST_DBG_DROP_CNT_PF_BOUND_DROP_CNT_MASK  I40E_MASK(0xFF, I40E_RCU_PST_DBG_DROP_CNT_PF_BOUND_DROP_CNT_SHIFT)
#define I40E_RCU_PST_DBG_DROP_CNT_SWR_DROP_CNT_SHIFT      24
#define I40E_RCU_PST_DBG_DROP_CNT_SWR_DROP_CNT_MASK       I40E_MASK(0xFF, I40E_RCU_PST_DBG_DROP_CNT_SWR_DROP_CNT_SHIFT)

#define I40E_RCU_PST_DBG_FLU_STATE(_i)             (0x0026CB80 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_RCU_PST_DBG_FLU_STATE_MAX_INDEX       15
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_STATE_SHIFT 0
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_STATE_MASK  I40E_MASK(0x1F, I40E_RCU_PST_DBG_FLU_STATE_FLU_STATE_SHIFT)
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_HASH_SHIFT  5
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_HASH_MASK   I40E_MASK(0xFFFFF, I40E_RCU_PST_DBG_FLU_STATE_FLU_HASH_SHIFT)
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_OBJ_SHIFT   25
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_OBJ_MASK    I40E_MASK(0x7, I40E_RCU_PST_DBG_FLU_STATE_FLU_OBJ_SHIFT)
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_CMD_SHIFT   28
#define I40E_RCU_PST_DBG_FLU_STATE_FLU_CMD_MASK    I40E_MASK(0xF, I40E_RCU_PST_DBG_FLU_STATE_FLU_CMD_SHIFT)

#define I40E_RCU_PST_DBG_Q_SRC_CNT_0                     0x0026CC14 /* Reset: CORER */
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_CONF_FAIL_CNT_SHIFT 0
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_CONF_FAIL_CNT_MASK  I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_0_CONF_FAIL_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_QUAD_HIT_CNT_SHIFT  8
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_QUAD_HIT_CNT_MASK   I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_0_QUAD_HIT_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_ETH_HIT_CNT_SHIFT   16
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_ETH_HIT_CNT_MASK    I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_0_ETH_HIT_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_FCOE_CNT_SHIFT      24
#define I40E_RCU_PST_DBG_Q_SRC_CNT_0_FCOE_CNT_MASK       I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_0_FCOE_CNT_SHIFT)

#define I40E_RCU_PST_DBG_Q_SRC_CNT_1                    0x0026CC1C /* Reset: CORER */
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_FD_HIT_CNT_SHIFT   0
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_FD_HIT_CNT_MASK    I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_1_FD_HIT_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_MAC_VLAN_CNT_SHIFT 8
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_MAC_VLAN_CNT_MASK  I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_1_MAC_VLAN_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_RSS_CNT_SHIFT      16
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_RSS_CNT_MASK       I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_1_RSS_CNT_SHIFT)
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_DEFAULT_CNT_SHIFT  24
#define I40E_RCU_PST_DBG_Q_SRC_CNT_1_DEFAULT_CNT_MASK   I40E_MASK(0xFF, I40E_RCU_PST_DBG_Q_SRC_CNT_1_DEFAULT_CNT_SHIFT)

#define I40E_RCU_PST_DBG_STATUS_0                      0x0026CC04 /* Reset: CORER */
#define I40E_RCU_PST_DBG_STATUS_0_PST_FLR_STAT_SHIFT   0
#define I40E_RCU_PST_DBG_STATUS_0_PST_FLR_STAT_MASK    I40E_MASK(0xFFFF, I40E_RCU_PST_DBG_STATUS_0_PST_FLR_STAT_SHIFT)
#define I40E_RCU_PST_DBG_STATUS_0_INPUT_FIFO_OCC_SHIFT 16
#define I40E_RCU_PST_DBG_STATUS_0_INPUT_FIFO_OCC_MASK  I40E_MASK(0x3, I40E_RCU_PST_DBG_STATUS_0_INPUT_FIFO_OCC_SHIFT)

#define I40E_RCU_PST_DBG_STATUS_1                      0x0026CC0C /* Reset: CORER */
#define I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_START_SHIFT 0
#define I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_START_MASK  I40E_MASK(0xFFFF, I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_START_SHIFT)
#define I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_DONE_SHIFT  16
#define I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_DONE_MASK   I40E_MASK(0xFFFF, I40E_RCU_PST_DBG_STATUS_1_FLR_FLOW_DONE_SHIFT)

#define I40E_RCU_PST_ECC_COR_ERR           0x0026CBC4 /* Reset: POR */
#define I40E_RCU_PST_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RCU_PST_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCU_PST_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RCU_PST_ECC_UNCOR_ERR           0x0026CBCC /* Reset: POR */
#define I40E_RCU_PST_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RCU_PST_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCU_PST_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RCU_PST_FCOE_CNTX_CHK_EN                          0x0026CC08 /* Reset: CORER */
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FILTER_EN_SHIFT      0
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FILTER_EN_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FILTER_EN_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF2_CLASS_SHIFT     1
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF2_CLASS_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF2_CLASS_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF3_CLASS_SHIFT     2
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF3_CLASS_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_SOF3_CLASS_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_EOFA_EOFI_SHIFT      3
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_EOFA_EOFI_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_EOFA_EOFI_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FIRST_NO_SOFI_SHIFT  4
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FIRST_NO_SOFI_MASK   I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_FIRST_NO_SOFI_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_MID_SOFI_SHIFT       5
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_MID_SOFI_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_MID_SOFI_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NOT_NEW_SEQ_ID_SHIFT 6
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NOT_NEW_SEQ_ID_MASK  I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NOT_NEW_SEQ_ID_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_ID_SHIFT     7
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_ID_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_ID_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_CNT_SHIFT    8
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_CNT_MASK     I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_NEW_SEQ_CNT_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_DIFF_SEQ_CNT_SHIFT   9
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_DIFF_SEQ_CNT_MASK    I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_GEN_DIFF_SEQ_CNT_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SOF_CLASS_SHIFT      11
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SOF_CLASS_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SOF_CLASS_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_INITIATOR_SHIFT      12
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_INITIATOR_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_INITIATOR_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_PKT_SHIFT       13
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_PKT_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_PKT_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EOFT_SHIFT           14
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EOFT_MASK            I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EOFT_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_ID_SHIFT         15
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_ID_MASK          I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_ID_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EX_CNTX_SHIFT        16
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EX_CNTX_MASK         I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_EX_CNTX_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_CNTX_SHIFT       17
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_CNTX_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_CNTX_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_INITIATIVE_SHIFT 18
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_INITIATIVE_MASK  I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_SEQ_INITIATIVE_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_RLT_OFFSET_SHIFT     19
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_RLT_OFFSET_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_RLT_OFFSET_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_FIRST_SEQ_SHIFT      20
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_FIRST_SEQ_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_FIRST_SEQ_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_ABORT_SEQ_SHIFT      21
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_ABORT_SEQ_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_ABORT_SEQ_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_SEQ_SHIFT       22
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_SEQ_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_RSP_LAST_SEQ_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_NEW_SEQ_ID_SHIFT    23
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_NEW_SEQ_ID_MASK     I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_NEW_SEQ_ID_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_DIFF_SEQ_ID_SHIFT   24
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_DIFF_SEQ_ID_MASK    I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_DIFF_SEQ_ID_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFT_SHIFT          25
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFT_MASK           I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFT_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFN_SHIFT          26
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFN_MASK           I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EOFN_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EX_CNTX_SHIFT       27
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EX_CNTX_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_EX_CNTX_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_SEQ_CNTX_SHIFT      28
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_SEQ_CNTX_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_SEQ_CNTX_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_PARAM_SHIFT         29
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_PARAM_MASK          I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_PARAM_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_FIRST_SEQ_SHIFT     30
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_FIRST_SEQ_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_FIRST_SEQ_SHIFT)
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_ABORT_SEQ_SHIFT     31
#define I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_ABORT_SEQ_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_CNTX_CHK_EN_DATA_ABORT_SEQ_SHIFT)

#define I40E_RCU_PST_FCOE_PROT_CHK_EN                          0x0026CC10 /* Reset: CORER */
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_FCOE_VER_SHIFT           0
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_FCOE_VER_MASK            I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_FCOE_VER_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_SOF_VALUE_SHIFT          1
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_SOF_VALUE_MASK           I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_SOF_VALUE_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_EOF_VALUE_SHIFT          2
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_EOF_VALUE_MASK           I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_EOF_VALUE_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_END_SEQ_EOFT_SHIFT       3
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_END_SEQ_EOFT_MASK        I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_END_SEQ_EOFT_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_NO_END_SEQ_NO_EOFT_SHIFT 4
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_NO_END_SEQ_NO_EOFT_MASK  I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_NO_END_SEQ_NO_EOFT_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_OBSOLETE_FLAGS_SHIFT     5
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_OBSOLETE_FLAGS_MASK      I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_OBSOLETE_FLAGS_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_NOT_FCP_SHIFT            6
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_NOT_FCP_MASK             I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_NOT_FCP_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_CRC_ERROR_SHIFT          7
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_CRC_ERROR_MASK           I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_CRC_ERROR_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_PKT_SIZE_SHIFT           8
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_PKT_SIZE_MASK            I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_PKT_SIZE_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_SEQ_INIT_LAST_SHIFT      9
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_SEQ_INIT_LAST_MASK       I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_SEQ_INIT_LAST_SHIFT)
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_OPTIONAL_HEADERS_SHIFT   10
#define I40E_RCU_PST_FCOE_PROT_CHK_EN_OPTIONAL_HEADERS_MASK    I40E_MASK(0x1, I40E_RCU_PST_FCOE_PROT_CHK_EN_OPTIONAL_HEADERS_SHIFT)

#define I40E_RCU_PST_FOC_ACCESS_STATUS                     0x00270110 /* Reset: CORER */
#define I40E_RCU_PST_FOC_ACCESS_STATUS_WR_ACCESS_CNT_SHIFT 0
#define I40E_RCU_PST_FOC_ACCESS_STATUS_WR_ACCESS_CNT_MASK  I40E_MASK(0xFF, I40E_RCU_PST_FOC_ACCESS_STATUS_WR_ACCESS_CNT_SHIFT)
#define I40E_RCU_PST_FOC_ACCESS_STATUS_RD_ACCESS_CNT_SHIFT 8
#define I40E_RCU_PST_FOC_ACCESS_STATUS_RD_ACCESS_CNT_MASK  I40E_MASK(0xFF, I40E_RCU_PST_FOC_ACCESS_STATUS_RD_ACCESS_CNT_SHIFT)
#define I40E_RCU_PST_FOC_ACCESS_STATUS_ERR_CNT_SHIFT       16
#define I40E_RCU_PST_FOC_ACCESS_STATUS_ERR_CNT_MASK        I40E_MASK(0xFF, I40E_RCU_PST_FOC_ACCESS_STATUS_ERR_CNT_SHIFT)
#define I40E_RCU_PST_FOC_ACCESS_STATUS_LAST_ERR_CODE_SHIFT 24
#define I40E_RCU_PST_FOC_ACCESS_STATUS_LAST_ERR_CODE_MASK  I40E_MASK(0x7, I40E_RCU_PST_FOC_ACCESS_STATUS_LAST_ERR_CODE_SHIFT)

#define I40E_RCU_PST_INPUT_ACL_STATUS(_i)                            (0x00270100 + ((_i) * 4)) /* _i=0...2 */ /* Reset: CORER */
#define I40E_RCU_PST_INPUT_ACL_STATUS_MAX_INDEX                      2
#define I40E_RCU_PST_INPUT_ACL_STATUS_RCU_PST_INPUT_ACL_STATUS_SHIFT 0
#define I40E_RCU_PST_INPUT_ACL_STATUS_RCU_PST_INPUT_ACL_STATUS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_INPUT_ACL_STATUS_RCU_PST_INPUT_ACL_STATUS_SHIFT)

#define I40E_RCU_PST_INPUT_MTG_FIELDS(_i)                            (0x00270080 + ((_i) * 4)) /* _i=0...31 */ /* Reset: CORER */
#define I40E_RCU_PST_INPUT_MTG_FIELDS_MAX_INDEX                      31
#define I40E_RCU_PST_INPUT_MTG_FIELDS_RCU_PST_INPUT_MTG_FIELDS_SHIFT 0
#define I40E_RCU_PST_INPUT_MTG_FIELDS_RCU_PST_INPUT_MTG_FIELDS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_INPUT_MTG_FIELDS_RCU_PST_INPUT_MTG_FIELDS_SHIFT)

#define I40E_RCU_PST_INPUT_MTG_STATUS(_i)                            (0x00270060 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_RCU_PST_INPUT_MTG_STATUS_MAX_INDEX                      7
#define I40E_RCU_PST_INPUT_MTG_STATUS_RCU_PST_INPUT_MTG_STATUS_SHIFT 0
#define I40E_RCU_PST_INPUT_MTG_STATUS_RCU_PST_INPUT_MTG_STATUS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_INPUT_MTG_STATUS_RCU_PST_INPUT_MTG_STATUS_SHIFT)

#define I40E_RCU_PST_OUTFIFO_OCC(_i)            (0x0026CFE0 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_RCU_PST_OUTFIFO_OCC_MAX_INDEX      7
#define I40E_RCU_PST_OUTFIFO_OCC_UP_1_OCC_SHIFT 0
#define I40E_RCU_PST_OUTFIFO_OCC_UP_1_OCC_MASK  I40E_MASK(0xFF, I40E_RCU_PST_OUTFIFO_OCC_UP_1_OCC_SHIFT)
#define I40E_RCU_PST_OUTFIFO_OCC_UP_2_OCC_SHIFT 8
#define I40E_RCU_PST_OUTFIFO_OCC_UP_2_OCC_MASK  I40E_MASK(0xFF, I40E_RCU_PST_OUTFIFO_OCC_UP_2_OCC_SHIFT)
#define I40E_RCU_PST_OUTFIFO_OCC_UP_3_OCC_SHIFT 16
#define I40E_RCU_PST_OUTFIFO_OCC_UP_3_OCC_MASK  I40E_MASK(0xFF, I40E_RCU_PST_OUTFIFO_OCC_UP_3_OCC_SHIFT)
#define I40E_RCU_PST_OUTFIFO_OCC_UP_4_OCC_SHIFT 24
#define I40E_RCU_PST_OUTFIFO_OCC_UP_4_OCC_MASK  I40E_MASK(0xFF, I40E_RCU_PST_OUTFIFO_OCC_UP_4_OCC_SHIFT)

#define I40E_RCU_PST_RCB_ACL_STATUS(_i)                          (0x00270030 + ((_i) * 4)) /* _i=0...2 */ /* Reset: CORER */
#define I40E_RCU_PST_RCB_ACL_STATUS_MAX_INDEX                    2
#define I40E_RCU_PST_RCB_ACL_STATUS_RCU_PST_RCB_ACL_STATUS_SHIFT 0
#define I40E_RCU_PST_RCB_ACL_STATUS_RCU_PST_RCB_ACL_STATUS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_RCB_ACL_STATUS_RCU_PST_RCB_ACL_STATUS_SHIFT)

#define I40E_RCU_PST_RCB_FIFO_FIELDS(_i)                           (0x00270000 + ((_i) * 4)) /* _i=0...5 */ /* Reset: CORER */
#define I40E_RCU_PST_RCB_FIFO_FIELDS_MAX_INDEX                     5
#define I40E_RCU_PST_RCB_FIFO_FIELDS_RCU_PST_RCB_FIFO_FIELDS_SHIFT 0
#define I40E_RCU_PST_RCB_FIFO_FIELDS_RCU_PST_RCB_FIFO_FIELDS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_RCB_FIFO_FIELDS_RCU_PST_RCB_FIFO_FIELDS_SHIFT)

#define I40E_RCU_PST_RCB_FIFO_Q_STATUS(_i)                             (0x00270020 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_RCU_PST_RCB_FIFO_Q_STATUS_MAX_INDEX                       3
#define I40E_RCU_PST_RCB_FIFO_Q_STATUS_RCU_PST_RCB_FIFO_Q_STATUS_SHIFT 0
#define I40E_RCU_PST_RCB_FIFO_Q_STATUS_RCU_PST_RCB_FIFO_Q_STATUS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_RCB_FIFO_Q_STATUS_RCU_PST_RCB_FIFO_Q_STATUS_SHIFT)

#define I40E_RCU_PST_RCB_MTG_STATUS(_i)                          (0x00270040 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_RCU_PST_RCB_MTG_STATUS_MAX_INDEX                    7
#define I40E_RCU_PST_RCB_MTG_STATUS_RCU_PST_RCB_MTG_STATUS_SHIFT 0
#define I40E_RCU_PST_RCB_MTG_STATUS_RCU_PST_RCB_MTG_STATUS_MASK  I40E_MASK(0xFFFFFFFF, I40E_RCU_PST_RCB_MTG_STATUS_RCU_PST_RCB_MTG_STATUS_SHIFT)

#define I40E_RCU_PST_RCB_OUT_CTL                     0x0026CDA8 /* Reset: CORER */
#define I40E_RCU_PST_RCB_OUT_CTL_BLOCK_RCB_OUT_SHIFT 0
#define I40E_RCU_PST_RCB_OUT_CTL_BLOCK_RCB_OUT_MASK  I40E_MASK(0x1, I40E_RCU_PST_RCB_OUT_CTL_BLOCK_RCB_OUT_SHIFT)
#define I40E_RCU_PST_RCB_OUT_CTL_STEP_ONE_CMD_SHIFT  1
#define I40E_RCU_PST_RCB_OUT_CTL_STEP_ONE_CMD_MASK   I40E_MASK(0x1, I40E_RCU_PST_RCB_OUT_CTL_STEP_ONE_CMD_SHIFT)

#define I40E_RCU_PST_RCB_OUT_STAT                    0x0026CC18 /* Reset: CORER */
#define I40E_RCU_PST_RCB_OUT_STAT_RCB_FIFO_OCC_SHIFT 0
#define I40E_RCU_PST_RCB_OUT_STAT_RCB_FIFO_OCC_MASK  I40E_MASK(0xF, I40E_RCU_PST_RCB_OUT_STAT_RCB_FIFO_OCC_SHIFT)
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_IPLEN_SHIFT   8
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_IPLEN_MASK    I40E_MASK(0xFFFF, I40E_RCU_PST_RCB_OUT_STAT_NEXT_IPLEN_SHIFT)
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_TYPE_SHIFT    24
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_TYPE_MASK     I40E_MASK(0x7, I40E_RCU_PST_RCB_OUT_STAT_NEXT_TYPE_SHIFT)
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_CFG_ERR_SHIFT 28
#define I40E_RCU_PST_RCB_OUT_STAT_NEXT_CFG_ERR_MASK  I40E_MASK(0x1, I40E_RCU_PST_RCB_OUT_STAT_NEXT_CFG_ERR_SHIFT)
#define I40E_RCU_PST_RCB_OUT_STAT_RSV3_SHIFT         29
#define I40E_RCU_PST_RCB_OUT_STAT_RSV3_MASK          I40E_MASK(0x7, I40E_RCU_PST_RCB_OUT_STAT_RSV3_SHIFT)

#define I40E_RCU_PST_TFIFO_CFG                    0x00269B54 /* Reset: POR */
#define I40E_RCU_PST_TFIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_PST_TFIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_ECC_EN_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_PST_TFIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_PST_TFIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_PST_TFIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_MASK_INT_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_PST_TFIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_PST_TFIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_RME_SHIFT          12
#define I40E_RCU_PST_TFIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_PST_TFIFO_CFG_RME_SHIFT)
#define I40E_RCU_PST_TFIFO_CFG_RM_SHIFT           16
#define I40E_RCU_PST_TFIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_PST_TFIFO_CFG_RM_SHIFT)

#define I40E_RCU_PST_TFIFO_STATUS                        0x00269B5C /* Reset: POR */
#define I40E_RCU_PST_TFIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_PST_TFIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_PST_TFIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_PST_TFIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_PST_TFIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_PST_TFIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_PST_TFIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_PST_TFIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_PST_TFIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_PST_TFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_PST_TFIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_PST_TFIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP_BIG_FLU_CFG                    0x0026CDA4 /* Reset: POR */
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP_BIG_FLU_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP_BIG_FLU_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP_BIG_FLU_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP_BIG_FLU_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP_BIG_FLU_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_RME_SHIFT          12
#define I40E_RCU_SP_BIG_FLU_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_CFG_RME_SHIFT)
#define I40E_RCU_SP_BIG_FLU_CFG_RM_SHIFT           16
#define I40E_RCU_SP_BIG_FLU_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP_BIG_FLU_CFG_RM_SHIFT)

#define I40E_RCU_SP_BIG_FLU_STATUS                        0x0026CDAC /* Reset: POR */
#define I40E_RCU_SP_BIG_FLU_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP_BIG_FLU_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP_BIG_FLU_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP_BIG_FLU_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP_BIG_FLU_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP_BIG_FLU_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP_BIG_FLU_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP_BIG_FLU_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP_BIG_FLU_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG                    0x002698B4 /* Reset: POR */
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RME_SHIFT          12
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RME_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RM_SHIFT           16
#define I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP_MTG_VSI_CNTXT_CFG_RM_SHIFT)

#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS                        0x002698BC /* Reset: POR */
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP_MTG_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP_PST_CONFIG_CFG                    0x00269AD4 /* Reset: POR */
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP_PST_CONFIG_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP_PST_CONFIG_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP_PST_CONFIG_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP_PST_CONFIG_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP_PST_CONFIG_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_RME_SHIFT          12
#define I40E_RCU_SP_PST_CONFIG_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_CFG_RME_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_CFG_RM_SHIFT           16
#define I40E_RCU_SP_PST_CONFIG_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP_PST_CONFIG_CFG_RM_SHIFT)

#define I40E_RCU_SP_PST_CONFIG_STATUS                        0x00269B04 /* Reset: POR */
#define I40E_RCU_SP_PST_CONFIG_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP_PST_CONFIG_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP_PST_CONFIG_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP_PST_CONFIG_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP_PST_CONFIG_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP_PST_CONFIG_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_CONFIG_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP_PST_RSC_HASH_CFG                    0x00269AEC /* Reset: POR */
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP_PST_RSC_HASH_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP_PST_RSC_HASH_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP_PST_RSC_HASH_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP_PST_RSC_HASH_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP_PST_RSC_HASH_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_RME_SHIFT          12
#define I40E_RCU_SP_PST_RSC_HASH_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_CFG_RME_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_CFG_RM_SHIFT           16
#define I40E_RCU_SP_PST_RSC_HASH_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP_PST_RSC_HASH_CFG_RM_SHIFT)

#define I40E_RCU_SP_PST_RSC_HASH_STATUS                        0x00269B14 /* Reset: POR */
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP_PST_RSC_HASH_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP_PST_RSC_HASH_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG                    0x002698C4 /* Reset: POR */
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RME_SHIFT          12
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RME_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RM_SHIFT           16
#define I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP_SWR_VSI_CNTXT_CFG_RM_SHIFT)

#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS                        0x002698CC /* Reset: POR */
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP_SWR_VSI_CNTXT_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP16KB_CFG                    0x002698D4 /* Reset: POR */
#define I40E_RCU_SP16KB_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP16KB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP16KB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP16KB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP16KB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP16KB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP16KB_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP16KB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP16KB_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP16KB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP16KB_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP16KB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP16KB_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP16KB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP16KB_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP16KB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP16KB_CFG_RME_SHIFT          12
#define I40E_RCU_SP16KB_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_CFG_RME_SHIFT)
#define I40E_RCU_SP16KB_CFG_RM_SHIFT           16
#define I40E_RCU_SP16KB_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP16KB_CFG_RM_SHIFT)

#define I40E_RCU_SP16KB_REP_CFG                    0x00269AF4 /* Reset: POR */
#define I40E_RCU_SP16KB_REP_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP16KB_REP_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP16KB_REP_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP16KB_REP_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP16KB_REP_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP16KB_REP_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP16KB_REP_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_RME_SHIFT          12
#define I40E_RCU_SP16KB_REP_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_REP_CFG_RME_SHIFT)
#define I40E_RCU_SP16KB_REP_CFG_RM_SHIFT           16
#define I40E_RCU_SP16KB_REP_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP16KB_REP_CFG_RM_SHIFT)

#define I40E_RCU_SP16KB_REP_STATUS                        0x00269B24 /* Reset: POR */
#define I40E_RCU_SP16KB_REP_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP16KB_REP_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_REP_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP16KB_REP_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP16KB_REP_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_REP_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP16KB_REP_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP16KB_REP_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP16KB_REP_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP16KB_REP_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP16KB_REP_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_REP_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP16KB_STATUS                        0x002698DC /* Reset: POR */
#define I40E_RCU_SP16KB_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP16KB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP16KB_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP16KB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP16KB_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP16KB_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP16KB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP16KB_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP16KB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP16KB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP16KB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP1KB_CFG                    0x002698E4 /* Reset: POR */
#define I40E_RCU_SP1KB_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP1KB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP1KB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP1KB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP1KB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP1KB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP1KB_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP1KB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP1KB_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP1KB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP1KB_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP1KB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP1KB_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP1KB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP1KB_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP1KB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP1KB_CFG_RME_SHIFT          12
#define I40E_RCU_SP1KB_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP1KB_CFG_RME_SHIFT)
#define I40E_RCU_SP1KB_CFG_RM_SHIFT           16
#define I40E_RCU_SP1KB_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP1KB_CFG_RM_SHIFT)

#define I40E_RCU_SP1KB_STATUS                        0x002698EC /* Reset: POR */
#define I40E_RCU_SP1KB_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP1KB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP1KB_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP1KB_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP1KB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP1KB_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP1KB_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP1KB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP1KB_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP1KB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP1KB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP1KB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP256B_CFG                    0x002698F4 /* Reset: POR */
#define I40E_RCU_SP256B_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP256B_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP256B_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP256B_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP256B_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP256B_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP256B_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP256B_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP256B_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP256B_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP256B_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP256B_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP256B_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP256B_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP256B_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP256B_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP256B_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP256B_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP256B_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP256B_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP256B_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP256B_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP256B_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP256B_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP256B_CFG_RME_SHIFT          12
#define I40E_RCU_SP256B_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP256B_CFG_RME_SHIFT)
#define I40E_RCU_SP256B_CFG_RM_SHIFT           16
#define I40E_RCU_SP256B_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP256B_CFG_RM_SHIFT)

#define I40E_RCU_SP256B_STATUS                        0x002698FC /* Reset: POR */
#define I40E_RCU_SP256B_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP256B_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP256B_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP256B_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP256B_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP256B_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP256B_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP256B_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP256B_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP256B_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP256B_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP256B_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP2KB_CFG                    0x00269904 /* Reset: POR */
#define I40E_RCU_SP2KB_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP2KB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP2KB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP2KB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP2KB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP2KB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP2KB_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP2KB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP2KB_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP2KB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP2KB_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP2KB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP2KB_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP2KB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP2KB_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP2KB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP2KB_CFG_RME_SHIFT          12
#define I40E_RCU_SP2KB_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP2KB_CFG_RME_SHIFT)
#define I40E_RCU_SP2KB_CFG_RM_SHIFT           16
#define I40E_RCU_SP2KB_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP2KB_CFG_RM_SHIFT)

#define I40E_RCU_SP2KB_STATUS                        0x0026990C /* Reset: POR */
#define I40E_RCU_SP2KB_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP2KB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP2KB_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP2KB_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP2KB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP2KB_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP2KB_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP2KB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP2KB_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP2KB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP2KB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP2KB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP4KB_CFG                    0x00269914 /* Reset: POR */
#define I40E_RCU_SP4KB_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP4KB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP4KB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP4KB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP4KB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP4KB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP4KB_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP4KB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP4KB_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP4KB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP4KB_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP4KB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP4KB_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP4KB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP4KB_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP4KB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP4KB_CFG_RME_SHIFT          12
#define I40E_RCU_SP4KB_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP4KB_CFG_RME_SHIFT)
#define I40E_RCU_SP4KB_CFG_RM_SHIFT           16
#define I40E_RCU_SP4KB_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP4KB_CFG_RM_SHIFT)

#define I40E_RCU_SP4KB_STATUS                        0x0026991C /* Reset: POR */
#define I40E_RCU_SP4KB_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP4KB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP4KB_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP4KB_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP4KB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP4KB_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP4KB_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP4KB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP4KB_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP4KB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP4KB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP4KB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SP8KB_CFG                    0x00269924 /* Reset: POR */
#define I40E_RCU_SP8KB_CFG_ECC_EN_SHIFT       0
#define I40E_RCU_SP8KB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_ECC_EN_SHIFT)
#define I40E_RCU_SP8KB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RCU_SP8KB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RCU_SP8KB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RCU_SP8KB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RCU_SP8KB_CFG_LS_FORCE_SHIFT     3
#define I40E_RCU_SP8KB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_LS_FORCE_SHIFT)
#define I40E_RCU_SP8KB_CFG_LS_BYPASS_SHIFT    4
#define I40E_RCU_SP8KB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_LS_BYPASS_SHIFT)
#define I40E_RCU_SP8KB_CFG_MASK_INT_SHIFT     5
#define I40E_RCU_SP8KB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_MASK_INT_SHIFT)
#define I40E_RCU_SP8KB_CFG_FIX_CNT_SHIFT      8
#define I40E_RCU_SP8KB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_FIX_CNT_SHIFT)
#define I40E_RCU_SP8KB_CFG_ERR_CNT_SHIFT      9
#define I40E_RCU_SP8KB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_ERR_CNT_SHIFT)
#define I40E_RCU_SP8KB_CFG_RME_SHIFT          12
#define I40E_RCU_SP8KB_CFG_RME_MASK           I40E_MASK(0x1, I40E_RCU_SP8KB_CFG_RME_SHIFT)
#define I40E_RCU_SP8KB_CFG_RM_SHIFT           16
#define I40E_RCU_SP8KB_CFG_RM_MASK            I40E_MASK(0xF, I40E_RCU_SP8KB_CFG_RM_SHIFT)

#define I40E_RCU_SP8KB_STATUS                        0x0026992C /* Reset: POR */
#define I40E_RCU_SP8KB_STATUS_ECC_ERR_SHIFT          0
#define I40E_RCU_SP8KB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RCU_SP8KB_STATUS_ECC_ERR_SHIFT)
#define I40E_RCU_SP8KB_STATUS_ECC_FIX_SHIFT          1
#define I40E_RCU_SP8KB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RCU_SP8KB_STATUS_ECC_FIX_SHIFT)
#define I40E_RCU_SP8KB_STATUS_INIT_DONE_SHIFT        2
#define I40E_RCU_SP8KB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RCU_SP8KB_STATUS_INIT_DONE_SHIFT)
#define I40E_RCU_SP8KB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RCU_SP8KB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RCU_SP8KB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RCU_SWR_ECC_COR_ERR           0x00269934 /* Reset: POR */
#define I40E_RCU_SWR_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RCU_SWR_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCU_SWR_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RCU_SWR_ECC_UNCOR_ERR           0x0026993C /* Reset: POR */
#define I40E_RCU_SWR_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RCU_SWR_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RCU_SWR_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RDPU_ECC_COR_ERR           0x00051080 /* Reset: POR */
#define I40E_RDPU_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RDPU_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RDPU_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RDPU_ECC_UNCOR_ERR           0x0005107C /* Reset: POR */
#define I40E_RDPU_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RDPU_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RDPU_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RDPU_VSI_LY2_STRIP_CFG                    0x00051074 /* Reset: POR */
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_EN_SHIFT       0
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_EN_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_LS_FORCE_SHIFT     3
#define I40E_RDPU_VSI_LY2_STRIP_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_LS_FORCE_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_LS_BYPASS_SHIFT    4
#define I40E_RDPU_VSI_LY2_STRIP_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_LS_BYPASS_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_MASK_INT_SHIFT     5
#define I40E_RDPU_VSI_LY2_STRIP_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_MASK_INT_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_FIX_CNT_SHIFT      8
#define I40E_RDPU_VSI_LY2_STRIP_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_FIX_CNT_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ERR_CNT_SHIFT      9
#define I40E_RDPU_VSI_LY2_STRIP_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_ERR_CNT_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_RME_SHIFT          12
#define I40E_RDPU_VSI_LY2_STRIP_CFG_RME_MASK           I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_CFG_RME_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_CFG_RM_SHIFT           16
#define I40E_RDPU_VSI_LY2_STRIP_CFG_RM_MASK            I40E_MASK(0xF, I40E_RDPU_VSI_LY2_STRIP_CFG_RM_SHIFT)

#define I40E_RDPU_VSI_LY2_STRIP_STATUS                        0x00051078 /* Reset: POR */
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_ERR_SHIFT          0
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_ERR_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_FIX_SHIFT          1
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_STATUS_ECC_FIX_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_INIT_DONE_SHIFT        2
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_STATUS_INIT_DONE_SHIFT)
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RDPU_VSI_LY2_STRIP_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RDPU_VSI_LY2_STRIP_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_ATTR_FIFO_CFG                    0x0012A52C /* Reset: POR */
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_ATTR_FIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_ATTR_FIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_ATTR_FIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_ATTR_FIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_ATTR_FIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_RME_SHIFT          12
#define I40E_RLAN_ATTR_FIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_CFG_RME_SHIFT)
#define I40E_RLAN_ATTR_FIFO_CFG_RM_SHIFT           16
#define I40E_RLAN_ATTR_FIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_ATTR_FIFO_CFG_RM_SHIFT)

#define I40E_RLAN_ATTR_FIFO_STATUS                        0x0012A530 /* Reset: POR */
#define I40E_RLAN_ATTR_FIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_ATTR_FIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_ATTR_FIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_ATTR_FIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_ATTR_FIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_ATTR_FIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_ATTR_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_ATTR_FIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_ATTR_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_CCH_CFG                    0x0012A514 /* Reset: POR */
#define I40E_RLAN_CCH_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_CCH_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_CCH_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_CCH_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_CCH_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_CCH_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_CCH_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_CCH_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_CCH_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_CCH_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_CCH_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_CCH_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_CCH_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_CCH_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_CCH_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_CCH_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_CCH_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_CCH_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_CCH_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_CCH_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_CCH_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_CCH_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_CCH_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_CCH_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_CCH_CFG_RME_SHIFT          12
#define I40E_RLAN_CCH_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_CCH_CFG_RME_SHIFT)
#define I40E_RLAN_CCH_CFG_RM_SHIFT           16
#define I40E_RLAN_CCH_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_CCH_CFG_RM_SHIFT)

#define I40E_RLAN_CCH_STATUS                        0x0012A518 /* Reset: POR */
#define I40E_RLAN_CCH_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_CCH_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_CCH_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_CCH_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_CCH_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_CCH_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_CCH_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_CCH_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_CCH_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_CCH_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_CCH_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_CCH_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_CMD_FIFO_CFG                    0x0012A534 /* Reset: POR */
#define I40E_RLAN_CMD_FIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_CMD_FIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_CMD_FIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_CMD_FIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_CMD_FIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_CMD_FIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_CMD_FIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_RME_SHIFT          12
#define I40E_RLAN_CMD_FIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_CFG_RME_SHIFT)
#define I40E_RLAN_CMD_FIFO_CFG_RM_SHIFT           16
#define I40E_RLAN_CMD_FIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_CMD_FIFO_CFG_RM_SHIFT)

#define I40E_RLAN_CMD_FIFO_STATUS                        0x0012A538 /* Reset: POR */
#define I40E_RLAN_CMD_FIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_CMD_FIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_CMD_FIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_CMD_FIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_CMD_FIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_CMD_FIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_CMD_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_CMD_FIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_CMD_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_DCH_LINE_ATTR_CFG                    0x0012A51C /* Reset: POR */
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_DCH_LINE_ATTR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_DCH_LINE_ATTR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_DCH_LINE_ATTR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_DCH_LINE_ATTR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_DCH_LINE_ATTR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_RME_SHIFT          12
#define I40E_RLAN_DCH_LINE_ATTR_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_CFG_RME_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_CFG_RM_SHIFT           16
#define I40E_RLAN_DCH_LINE_ATTR_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_DCH_LINE_ATTR_CFG_RM_SHIFT)

#define I40E_RLAN_DCH_LINE_ATTR_STATUS                        0x0012A520 /* Reset: POR */
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_DCH_LINE_ATTR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_DCH_LINE_ATTR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_DSCR_CH_BNK_CFG                    0x0012A544 /* Reset: POR */
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_DSCR_CH_BNK_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_DSCR_CH_BNK_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_DSCR_CH_BNK_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_DSCR_CH_BNK_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_DSCR_CH_BNK_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_RME_SHIFT          12
#define I40E_RLAN_DSCR_CH_BNK_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_CFG_RME_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_CFG_RM_SHIFT           16
#define I40E_RLAN_DSCR_CH_BNK_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_DSCR_CH_BNK_CFG_RM_SHIFT)

#define I40E_RLAN_DSCR_CH_BNK_STATUS                        0x0012A548 /* Reset: POR */
#define I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_DSCR_CH_BNK_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_DSCR_CH_BNK_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_DSCR_CH_BNK_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_CH_BNK_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_DSCR_REQ_FIFO_CFG                    0x0012A524 /* Reset: POR */
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_RME_SHIFT          12
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_CFG_RME_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_RM_SHIFT           16
#define I40E_RLAN_DSCR_REQ_FIFO_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_DSCR_REQ_FIFO_CFG_RM_SHIFT)

#define I40E_RLAN_DSCR_REQ_FIFO_STATUS                        0x0012A528 /* Reset: POR */
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_DSCR_REQ_FIFO_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_DSCR_REQ_FIFO_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RLAN_ECC_COR_ERR           0x0012A550 /* Reset: POR */
#define I40E_RLAN_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RLAN_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RLAN_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RLAN_ECC_UNCOR_ERR           0x0012A54C /* Reset: POR */
#define I40E_RLAN_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RLAN_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RLAN_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RLAN_TAILS_CFG                    0x0012A53C /* Reset: POR */
#define I40E_RLAN_TAILS_CFG_ECC_EN_SHIFT       0
#define I40E_RLAN_TAILS_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_ECC_EN_SHIFT)
#define I40E_RLAN_TAILS_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RLAN_TAILS_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RLAN_TAILS_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RLAN_TAILS_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RLAN_TAILS_CFG_LS_FORCE_SHIFT     3
#define I40E_RLAN_TAILS_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_LS_FORCE_SHIFT)
#define I40E_RLAN_TAILS_CFG_LS_BYPASS_SHIFT    4
#define I40E_RLAN_TAILS_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_LS_BYPASS_SHIFT)
#define I40E_RLAN_TAILS_CFG_MASK_INT_SHIFT     5
#define I40E_RLAN_TAILS_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_MASK_INT_SHIFT)
#define I40E_RLAN_TAILS_CFG_FIX_CNT_SHIFT      8
#define I40E_RLAN_TAILS_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_FIX_CNT_SHIFT)
#define I40E_RLAN_TAILS_CFG_ERR_CNT_SHIFT      9
#define I40E_RLAN_TAILS_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_ERR_CNT_SHIFT)
#define I40E_RLAN_TAILS_CFG_RME_SHIFT          12
#define I40E_RLAN_TAILS_CFG_RME_MASK           I40E_MASK(0x1, I40E_RLAN_TAILS_CFG_RME_SHIFT)
#define I40E_RLAN_TAILS_CFG_RM_SHIFT           16
#define I40E_RLAN_TAILS_CFG_RM_MASK            I40E_MASK(0xF, I40E_RLAN_TAILS_CFG_RM_SHIFT)

#define I40E_RLAN_TAILS_STATUS                        0x0012A540 /* Reset: POR */
#define I40E_RLAN_TAILS_STATUS_ECC_ERR_SHIFT          0
#define I40E_RLAN_TAILS_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RLAN_TAILS_STATUS_ECC_ERR_SHIFT)
#define I40E_RLAN_TAILS_STATUS_ECC_FIX_SHIFT          1
#define I40E_RLAN_TAILS_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RLAN_TAILS_STATUS_ECC_FIX_SHIFT)
#define I40E_RLAN_TAILS_STATUS_INIT_DONE_SHIFT        2
#define I40E_RLAN_TAILS_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RLAN_TAILS_STATUS_INIT_DONE_SHIFT)
#define I40E_RLAN_TAILS_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RLAN_TAILS_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RLAN_TAILS_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_BACK_PRS_STAT                 0x000AC948 /* Reset: CORER */
#define I40E_RPB_BACK_PRS_STAT_PPRS_0_BP_SHIFT 0
#define I40E_RPB_BACK_PRS_STAT_PPRS_0_BP_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PPRS_0_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PPRS_1_BP_SHIFT 1
#define I40E_RPB_BACK_PRS_STAT_PPRS_1_BP_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PPRS_1_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PPRS_2_BP_SHIFT 2
#define I40E_RPB_BACK_PRS_STAT_PPRS_2_BP_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PPRS_2_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PPRS_3_BP_SHIFT 3
#define I40E_RPB_BACK_PRS_STAT_PPRS_3_BP_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PPRS_3_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_STATUS_BP_SHIFT 4
#define I40E_RPB_BACK_PRS_STAT_STATUS_BP_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_STATUS_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_RCU_BP_SHIFT    8
#define I40E_RPB_BACK_PRS_STAT_RCU_BP_MASK     I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_RCU_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PE0_BP_SHIFT    9
#define I40E_RPB_BACK_PRS_STAT_PE0_BP_MASK     I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PE0_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PE1_BP_SHIFT    10
#define I40E_RPB_BACK_PRS_STAT_PE1_BP_MASK     I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PE1_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_RDPU_BP_SHIFT   11
#define I40E_RPB_BACK_PRS_STAT_RDPU_BP_MASK    I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_RDPU_BP_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PORT_0_FC_SHIFT 12
#define I40E_RPB_BACK_PRS_STAT_PORT_0_FC_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PORT_0_FC_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PORT_1_FC_SHIFT 13
#define I40E_RPB_BACK_PRS_STAT_PORT_1_FC_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PORT_1_FC_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PORT_2_FC_SHIFT 14
#define I40E_RPB_BACK_PRS_STAT_PORT_2_FC_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PORT_2_FC_SHIFT)
#define I40E_RPB_BACK_PRS_STAT_PORT_3_FC_SHIFT 15
#define I40E_RPB_BACK_PRS_STAT_PORT_3_FC_MASK  I40E_MASK(0x1, I40E_RPB_BACK_PRS_STAT_PORT_3_FC_SHIFT)

#define I40E_RPB_CC_CNT_MEM_CFG                    0x000AC860 /* Reset: POR */
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_CC_CNT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_CC_CNT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_CC_CNT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_CC_CNT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_CC_CNT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_CC_CNT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_CFG_RME_SHIFT)
#define I40E_RPB_CC_CNT_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_CC_CNT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_CC_CNT_MEM_CFG_RM_SHIFT)

#define I40E_RPB_CC_CNT_MEM_STATUS                        0x000AC864 /* Reset: POR */
#define I40E_RPB_CC_CNT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_CC_CNT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_CC_CNT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_CC_CNT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_CC_CNT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_CC_CNT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_CC_CNT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_CC_CNT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_CC_CNT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_CC_MEM_CFG                    0x000AC890 /* Reset: POR */
#define I40E_RPB_CC_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_CC_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_CC_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_CC_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_CC_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_CC_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_CC_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_CC_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_CC_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_CC_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_CC_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_CC_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_CC_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_CC_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_CC_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_CC_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_CC_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_CC_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_CC_MEM_CFG_RME_SHIFT)
#define I40E_RPB_CC_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_CC_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_CC_MEM_CFG_RM_SHIFT)

#define I40E_RPB_CC_MEM_STATUS                        0x000AC894 /* Reset: POR */
#define I40E_RPB_CC_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_CC_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_CC_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_CC_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_CC_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_CC_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_CC_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_CC_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_CC_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_CC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_CC_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_CC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_CLID_MEM_CFG                    0x000AC870 /* Reset: POR */
#define I40E_RPB_CLID_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_CLID_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_CLID_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_CLID_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_CLID_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_CLID_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_CLID_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_CLID_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_CLID_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_CLID_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_CLID_MEM_CFG_RME_SHIFT)
#define I40E_RPB_CLID_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_CLID_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_CLID_MEM_CFG_RM_SHIFT)

#define I40E_RPB_CLID_MEM_STATUS                        0x000AC874 /* Reset: POR */
#define I40E_RPB_CLID_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_CLID_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_CLID_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_CLID_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_CLID_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_CLID_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_CLID_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_CLID_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_CLID_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_DATA_PIPE_MEM_CFG(_i)                (0x000AC898 + ((_i) * 4)) /* _i=0...7 */ /* Reset: POR */
#define I40E_RPB_DATA_PIPE_MEM_CFG_MAX_INDEX          7
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_DATA_PIPE_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_DATA_PIPE_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_DATA_PIPE_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_DATA_PIPE_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_DATA_PIPE_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_DATA_PIPE_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_CFG_RME_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_DATA_PIPE_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_DATA_PIPE_MEM_CFG_RM_SHIFT)

#define I40E_RPB_DATA_PIPE_MEM_STATUS(_i)                    (0x000AC8B8 + ((_i) * 4)) /* _i=0...7 */ /* Reset: POR */
#define I40E_RPB_DATA_PIPE_MEM_STATUS_MAX_INDEX              7
#define I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_DATA_PIPE_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_DATA_PIPE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_DATA_PIPE_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_DATA_PIPE_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_DBG_ACC_CNT                       0x000AC8E0 /* Reset: CORER */
#define I40E_RPB_DBG_ACC_CNT_RPB_DBG_ACC_CNT_SHIFT 0
#define I40E_RPB_DBG_ACC_CNT_RPB_DBG_ACC_CNT_MASK  I40E_MASK(0xFFFF, I40E_RPB_DBG_ACC_CNT_RPB_DBG_ACC_CNT_SHIFT)

#define I40E_RPB_DBG_ACC_CTL               0x000AC8E4 /* Reset: CORER */
#define I40E_RPB_DBG_ACC_CTL_ADDR_SHIFT    0
#define I40E_RPB_DBG_ACC_CTL_ADDR_MASK     I40E_MASK(0xFFFF, I40E_RPB_DBG_ACC_CTL_ADDR_SHIFT)
#define I40E_RPB_DBG_ACC_CTL_MEM_SEL_SHIFT 16
#define I40E_RPB_DBG_ACC_CTL_MEM_SEL_MASK  I40E_MASK(0xF, I40E_RPB_DBG_ACC_CTL_MEM_SEL_SHIFT)
#define I40E_RPB_DBG_ACC_CTL_EXECUTE_SHIFT 20
#define I40E_RPB_DBG_ACC_CTL_EXECUTE_MASK  I40E_MASK(0x1, I40E_RPB_DBG_ACC_CTL_EXECUTE_SHIFT)

#define I40E_RPB_DBG_ACC_DATA(_i)                     (0x000AC8EC + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_RPB_DBG_ACC_DATA_MAX_INDEX               7
#define I40E_RPB_DBG_ACC_DATA_RPB_DBG_READ_DATA_SHIFT 0
#define I40E_RPB_DBG_ACC_DATA_RPB_DBG_READ_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_RPB_DBG_ACC_DATA_RPB_DBG_READ_DATA_SHIFT)

#define I40E_RPB_DBG_ACC_STAT                0x000AC8E8 /* Reset: CORER */
#define I40E_RPB_DBG_ACC_STAT_READY_SHIFT    0
#define I40E_RPB_DBG_ACC_STAT_READY_MASK     I40E_MASK(0x1, I40E_RPB_DBG_ACC_STAT_READY_SHIFT)
#define I40E_RPB_DBG_ACC_STAT_BUSY_SHIFT     1
#define I40E_RPB_DBG_ACC_STAT_BUSY_MASK      I40E_MASK(0x1, I40E_RPB_DBG_ACC_STAT_BUSY_SHIFT)
#define I40E_RPB_DBG_ACC_STAT_ADDR_ERR_SHIFT 4
#define I40E_RPB_DBG_ACC_STAT_ADDR_ERR_MASK  I40E_MASK(0x1, I40E_RPB_DBG_ACC_STAT_ADDR_ERR_SHIFT)
#define I40E_RPB_DBG_ACC_STAT_SEL_ERR_SHIFT  5
#define I40E_RPB_DBG_ACC_STAT_SEL_ERR_MASK   I40E_MASK(0x1, I40E_RPB_DBG_ACC_STAT_SEL_ERR_SHIFT)
#define I40E_RPB_DBG_ACC_STAT_WD_ERR_SHIFT   6
#define I40E_RPB_DBG_ACC_STAT_WD_ERR_MASK    I40E_MASK(0x1, I40E_RPB_DBG_ACC_STAT_WD_ERR_SHIFT)

#define I40E_RPB_DBG_FEAT                         0x000AC940 /* Reset: CORER */
#define I40E_RPB_DBG_FEAT_DISABLE_REPORTS_SHIFT   0
#define I40E_RPB_DBG_FEAT_DISABLE_REPORTS_MASK    I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_REPORTS_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_RELEASE_SHIFT   1
#define I40E_RPB_DBG_FEAT_DISABLE_RELEASE_MASK    I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_RELEASE_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_CC_SHIFT        2
#define I40E_RPB_DBG_FEAT_DISABLE_CC_MASK         I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_CC_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_SHR_MODE_SHIFT  3
#define I40E_RPB_DBG_FEAT_DISABLE_SHR_MODE_MASK   I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_SHR_MODE_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_RCU_EGR_SHIFT   4
#define I40E_RPB_DBG_FEAT_DISABLE_RCU_EGR_MASK    I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_RCU_EGR_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_PE0_EGR_SHIFT   5
#define I40E_RPB_DBG_FEAT_DISABLE_PE0_EGR_MASK    I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_PE0_EGR_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_PE1_EGR_SHIFT   6
#define I40E_RPB_DBG_FEAT_DISABLE_PE1_EGR_MASK    I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_PE1_EGR_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_RDPU_EGR_SHIFT  7
#define I40E_RPB_DBG_FEAT_DISABLE_RDPU_EGR_MASK   I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_RDPU_EGR_SHIFT)
#define I40E_RPB_DBG_FEAT_FORCE_FC_PORT_SHIFT     8
#define I40E_RPB_DBG_FEAT_FORCE_FC_PORT_MASK      I40E_MASK(0xF, I40E_RPB_DBG_FEAT_FORCE_FC_PORT_SHIFT)
#define I40E_RPB_DBG_FEAT_FORCE_TPB_FC_PORT_SHIFT 12
#define I40E_RPB_DBG_FEAT_FORCE_TPB_FC_PORT_MASK  I40E_MASK(0xF, I40E_RPB_DBG_FEAT_FORCE_TPB_FC_PORT_SHIFT)
#define I40E_RPB_DBG_FEAT_FORCE_SHR_MODE_SHIFT    16
#define I40E_RPB_DBG_FEAT_FORCE_SHR_MODE_MASK     I40E_MASK(0x1, I40E_RPB_DBG_FEAT_FORCE_SHR_MODE_SHIFT)
#define I40E_RPB_DBG_FEAT_DISABLE_ECB_SYNC_SHIFT  17
#define I40E_RPB_DBG_FEAT_DISABLE_ECB_SYNC_MASK   I40E_MASK(0x1, I40E_RPB_DBG_FEAT_DISABLE_ECB_SYNC_SHIFT)
#define I40E_RPB_DBG_FEAT_LTR_CLK_GEN_VAL_SHIFT   20
#define I40E_RPB_DBG_FEAT_LTR_CLK_GEN_VAL_MASK    I40E_MASK(0xFFF, I40E_RPB_DBG_FEAT_LTR_CLK_GEN_VAL_SHIFT)

#define I40E_RPB_ECC_COR_ERR           0x000AC8DC /* Reset: POR */
#define I40E_RPB_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_RPB_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RPB_ECC_COR_ERR_CNT_SHIFT)

#define I40E_RPB_ECC_UNCOR_ERR           0x000AC8D8 /* Reset: POR */
#define I40E_RPB_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_RPB_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_RPB_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_RPB_EGR_CNT                0x000AC94C /* Reset: CORER */
#define I40E_RPB_EGR_CNT_RCU_REQ_SHIFT  0
#define I40E_RPB_EGR_CNT_RCU_REQ_MASK   I40E_MASK(0xFF, I40E_RPB_EGR_CNT_RCU_REQ_SHIFT)
#define I40E_RPB_EGR_CNT_PE_0_REQ_SHIFT 8
#define I40E_RPB_EGR_CNT_PE_0_REQ_MASK  I40E_MASK(0xFF, I40E_RPB_EGR_CNT_PE_0_REQ_SHIFT)
#define I40E_RPB_EGR_CNT_PE_1_REQ_SHIFT 16
#define I40E_RPB_EGR_CNT_PE_1_REQ_MASK  I40E_MASK(0xFF, I40E_RPB_EGR_CNT_PE_1_REQ_SHIFT)
#define I40E_RPB_EGR_CNT_RDPU_REQ_SHIFT 24
#define I40E_RPB_EGR_CNT_RDPU_REQ_MASK  I40E_MASK(0xFF, I40E_RPB_EGR_CNT_RDPU_REQ_SHIFT)

#define I40E_RPB_GEN_DBG_CNT                  0x000AC944 /* Reset: CORER */
#define I40E_RPB_GEN_DBG_CNT_FREE_CC_SHIFT    0
#define I40E_RPB_GEN_DBG_CNT_FREE_CC_MASK     I40E_MASK(0x1FF, I40E_RPB_GEN_DBG_CNT_FREE_CC_SHIFT)
#define I40E_RPB_GEN_DBG_CNT_FREE_CLIDS_SHIFT 16
#define I40E_RPB_GEN_DBG_CNT_FREE_CLIDS_MASK  I40E_MASK(0x3FFF, I40E_RPB_GEN_DBG_CNT_FREE_CLIDS_SHIFT)

#define I40E_RPB_PKT_MEM_CFG                    0x000AC868 /* Reset: POR */
#define I40E_RPB_PKT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_PKT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_PKT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_PKT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_PKT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_PKT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_PKT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_PKT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_PKT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_PKT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_PKT_MEM_CFG_RME_SHIFT)
#define I40E_RPB_PKT_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_PKT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_PKT_MEM_CFG_RM_SHIFT)

#define I40E_RPB_PKT_MEM_STATUS                        0x000AC86C /* Reset: POR */
#define I40E_RPB_PKT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_PKT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_PKT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_PKT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_PKT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_PKT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_PKT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_PKT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_PKT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_PPDB_MEM_CFG                    0x000AC878 /* Reset: POR */
#define I40E_RPB_PPDB_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_PPDB_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_PPDB_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_PPDB_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_PPDB_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_PPDB_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_PPDB_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_RME_A_SHIFT        12
#define I40E_RPB_PPDB_MEM_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_RME_A_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_RME_B_SHIFT        13
#define I40E_RPB_PPDB_MEM_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_RPB_PPDB_MEM_CFG_RME_B_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_RM_A_SHIFT         16
#define I40E_RPB_PPDB_MEM_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_RPB_PPDB_MEM_CFG_RM_A_SHIFT)
#define I40E_RPB_PPDB_MEM_CFG_RM_B_SHIFT         20
#define I40E_RPB_PPDB_MEM_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_RPB_PPDB_MEM_CFG_RM_B_SHIFT)

#define I40E_RPB_PPDB_MEM_STATUS                        0x000AC87C /* Reset: POR */
#define I40E_RPB_PPDB_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_PPDB_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_PPDB_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_PPDB_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_PPDB_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_PPDB_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_PPDB_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_PPDB_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_PPDB_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_PPDB_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_PPDB_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_PPDB_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_PPRS_ERR_CNT(_i)                 (0x000AC910 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_RPB_PPRS_ERR_CNT_MAX_INDEX           3
#define I40E_RPB_PPRS_ERR_CNT_PKT_SIZE_ERR_SHIFT  0
#define I40E_RPB_PPRS_ERR_CNT_PKT_SIZE_ERR_MASK   I40E_MASK(0xFF, I40E_RPB_PPRS_ERR_CNT_PKT_SIZE_ERR_SHIFT)
#define I40E_RPB_PPRS_ERR_CNT_VALID_BTW_PKT_SHIFT 8
#define I40E_RPB_PPRS_ERR_CNT_VALID_BTW_PKT_MASK  I40E_MASK(0xFF, I40E_RPB_PPRS_ERR_CNT_VALID_BTW_PKT_SHIFT)

#define I40E_RPB_REPORT_LL_MEM_CFG                    0x000AC880 /* Reset: POR */
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_REPORT_LL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_REPORT_LL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_REPORT_LL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_REPORT_LL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_REPORT_LL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_REPORT_LL_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_CFG_RME_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_REPORT_LL_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_REPORT_LL_MEM_CFG_RM_SHIFT)

#define I40E_RPB_REPORT_LL_MEM_STATUS                        0x000AC884 /* Reset: POR */
#define I40E_RPB_REPORT_LL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_REPORT_LL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_REPORT_LL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_REPORT_LL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_REPORT_MEM_CFG                    0x000AC888 /* Reset: POR */
#define I40E_RPB_REPORT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_RPB_REPORT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_RPB_REPORT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_RPB_REPORT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_RPB_REPORT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_RPB_REPORT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_RPB_REPORT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_RME_SHIFT          12
#define I40E_RPB_REPORT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_MEM_CFG_RME_SHIFT)
#define I40E_RPB_REPORT_MEM_CFG_RM_SHIFT           16
#define I40E_RPB_REPORT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_RPB_REPORT_MEM_CFG_RM_SHIFT)

#define I40E_RPB_REPORT_MEM_STATUS                        0x000AC88C /* Reset: POR */
#define I40E_RPB_REPORT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_RPB_REPORT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_RPB_REPORT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_RPB_REPORT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_RPB_REPORT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_RPB_REPORT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_RPB_REPORT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_RPB_REPORT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_RPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_RPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_RPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_RPB_RPT_CNT                   0x000AC950 /* Reset: CORER */
#define I40E_RPB_RPT_CNT_RPB_RPT_CNT_SHIFT 0
#define I40E_RPB_RPT_CNT_RPB_RPT_CNT_MASK  I40E_MASK(0xFFFF, I40E_RPB_RPT_CNT_RPB_RPT_CNT_SHIFT)

#define I40E_RPB_RPT_STAT                    0x000AC954 /* Reset: CORER */
#define I40E_RPB_RPT_STAT_RPB_RPT_STAT_SHIFT 0
#define I40E_RPB_RPT_STAT_RPB_RPT_STAT_MASK  I40E_MASK(0xFFFFFFFF, I40E_RPB_RPT_STAT_RPB_RPT_STAT_SHIFT)

#define I40E_RPB_SHR_MOD_CNT                       0x000AC90C /* Reset: CORER */
#define I40E_RPB_SHR_MOD_CNT_RPB_SHR_MOD_CNT_SHIFT 0
#define I40E_RPB_SHR_MOD_CNT_RPB_SHR_MOD_CNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_RPB_SHR_MOD_CNT_RPB_SHR_MOD_CNT_SHIFT)

#define I40E_TCB_ECC_COR_ERR           0x000AE0A8 /* Reset: POR */
#define I40E_TCB_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_TCB_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TCB_ECC_COR_ERR_CNT_SHIFT)

#define I40E_TCB_ECC_UNCOR_ERR           0x000AE0A4 /* Reset: POR */
#define I40E_TCB_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_TCB_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TCB_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_TCB_PORT_CMD_BUF_DBG_CTL              0x000AE0B4 /* Reset: CORER */
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_ADR_SHIFT    0
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TCB_PORT_CMD_BUF_DBG_CTL_ADR_SHIFT)
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TCB_PORT_CMD_BUF_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TCB_PORT_CMD_BUF_DBG_CTL_RD_EN_SHIFT)
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_DONE_SHIFT   31
#define I40E_TCB_PORT_CMD_BUF_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TCB_PORT_CMD_BUF_DBG_CTL_DONE_SHIFT)

#define I40E_TCB_PORT_CMD_BUF_DBG_DATA             0x000AE0CC /* Reset: CORER */
#define I40E_TCB_PORT_CMD_BUF_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TCB_PORT_CMD_BUF_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TCB_PORT_CMD_BUF_DBG_DATA_RD_DW_SHIFT)

#define I40E_TCB_PORT_CMD_MNG_DBG_CTL              0x000AE0B8 /* Reset: CORER */
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_ADR_SHIFT    0
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TCB_PORT_CMD_MNG_DBG_CTL_ADR_SHIFT)
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TCB_PORT_CMD_MNG_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TCB_PORT_CMD_MNG_DBG_CTL_RD_EN_SHIFT)
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_DONE_SHIFT   31
#define I40E_TCB_PORT_CMD_MNG_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TCB_PORT_CMD_MNG_DBG_CTL_DONE_SHIFT)

#define I40E_TCB_PORT_CMD_MNG_DBG_DATA             0x000AE0C0 /* Reset: CORER */
#define I40E_TCB_PORT_CMD_MNG_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TCB_PORT_CMD_MNG_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TCB_PORT_CMD_MNG_DBG_DATA_RD_DW_SHIFT)

#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL              0x000AE0BC /* Reset: CORER */
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_ADR_SHIFT    0
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TCB_WAIT_CMD_BUF_DBG_CTL_ADR_SHIFT)
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TCB_WAIT_CMD_BUF_DBG_CTL_RD_EN_SHIFT)
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DONE_SHIFT   31
#define I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TCB_WAIT_CMD_BUF_DBG_CTL_DONE_SHIFT)

#define I40E_TCB_WAIT_CMD_BUF_DBG_DATA             0x000AE0C4 /* Reset: CORER */
#define I40E_TCB_WAIT_CMD_BUF_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TCB_WAIT_CMD_BUF_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TCB_WAIT_CMD_BUF_DBG_DATA_RD_DW_SHIFT)

#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL              0x000AE0B0 /* Reset: CORER */
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_ADR_SHIFT    0
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TCB_WAIT_CMD_MNG_DBG_CTL_ADR_SHIFT)
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TCB_WAIT_CMD_MNG_DBG_CTL_RD_EN_SHIFT)
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DONE_SHIFT   31
#define I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TCB_WAIT_CMD_MNG_DBG_CTL_DONE_SHIFT)

#define I40E_TCB_WAIT_CMD_MNG_DBG_DATA             0x000AE0C8 /* Reset: CORER */
#define I40E_TCB_WAIT_CMD_MNG_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TCB_WAIT_CMD_MNG_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TCB_WAIT_CMD_MNG_DBG_DATA_RD_DW_SHIFT)

#define I40E_TDPU_CMD_MUX_MEM_CFG                    0x00044304 /* Reset: POR */
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_CMD_MUX_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_CMD_MUX_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_CMD_MUX_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_CMD_MUX_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_CMD_MUX_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_CMD_MUX_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_CMD_MUX_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_CMD_MUX_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_CMD_MUX_MEM_STATUS                        0x00044330 /* Reset: POR */
#define I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_CMD_MUX_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_CMD_MUX_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_CMD_MUX_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_CMD_MUX_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_DAC_MEM_CFG                    0x00044310 /* Reset: POR */
#define I40E_TDPU_DAC_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_DAC_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_DAC_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_DAC_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_DAC_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_DAC_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_DAC_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_DAC_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_DAC_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_DAC_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_DAC_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_DAC_MEM_STATUS                        0x00044328 /* Reset: POR */
#define I40E_TDPU_DAC_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_DAC_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_DAC_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_DAC_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_DAC_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_DAC_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_DAC_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_DAC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_DAC_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_DAC_MNG_MEM_CFG                    0x0004430C /* Reset: POR */
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_DAC_MNG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_DAC_MNG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_DAC_MNG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_DAC_MNG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_DAC_MNG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_DAC_MNG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_DAC_MNG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_DAC_MNG_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_DAC_MNG_MEM_STATUS                        0x0004432C /* Reset: POR */
#define I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_DAC_MNG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_DAC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_DAC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_DAC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_ECC_COR_ERR           0x0004433C /* Reset: POR */
#define I40E_TDPU_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_TDPU_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TDPU_ECC_COR_ERR_CNT_SHIFT)

#define I40E_TDPU_ECC_UNCOR_ERR           0x00044338 /* Reset: POR */
#define I40E_TDPU_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_TDPU_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TDPU_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_TDPU_IMEM_CFG                    0x000442F8 /* Reset: POR */
#define I40E_TDPU_IMEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_IMEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_IMEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_IMEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_IMEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_IMEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_IMEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_IMEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_IMEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_IMEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_IMEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_IMEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_IMEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_IMEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_IMEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_IMEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_IMEM_CFG_RME_SHIFT          12
#define I40E_TDPU_IMEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_IMEM_CFG_RME_SHIFT)
#define I40E_TDPU_IMEM_CFG_RM_SHIFT           16
#define I40E_TDPU_IMEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_IMEM_CFG_RM_SHIFT)

#define I40E_TDPU_IMEM_STATUS                        0x00044318 /* Reset: POR */
#define I40E_TDPU_IMEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_IMEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_IMEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_IMEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_IMEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_IMEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_IMEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_IMEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_IMEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_IMEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_IMEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_IMEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_RECIPE_ADDR_CFG                    0x000442FC /* Reset: POR */
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_RECIPE_ADDR_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_RECIPE_ADDR_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_RECIPE_ADDR_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_RECIPE_ADDR_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_RECIPE_ADDR_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_RME_SHIFT          12
#define I40E_TDPU_RECIPE_ADDR_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_CFG_RME_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_CFG_RM_SHIFT           16
#define I40E_TDPU_RECIPE_ADDR_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_RECIPE_ADDR_CFG_RM_SHIFT)

#define I40E_TDPU_RECIPE_ADDR_STATUS                        0x0004431C /* Reset: POR */
#define I40E_TDPU_RECIPE_ADDR_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_RECIPE_ADDR_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_RECIPE_ADDR_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_RECIPE_ADDR_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_RECIPE_ADDR_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_TDRD_MEM_CFG                    0x00044314 /* Reset: POR */
#define I40E_TDPU_TDRD_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_TDRD_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_TDRD_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_TDRD_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_TDRD_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_TDRD_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_TDRD_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_TDRD_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_TDRD_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_TDRD_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_TDRD_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_TDRD_MEM_STATUS                        0x00044324 /* Reset: POR */
#define I40E_TDPU_TDRD_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_TDRD_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_TDRD_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_TDRD_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_TDRD_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_TDRD_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_TDRD_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_TDRD_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_TDRD_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_TDWR_MEM_CFG                    0x00044308 /* Reset: POR */
#define I40E_TDPU_TDWR_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_TDWR_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_TDWR_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_TDWR_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_TDWR_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_TDWR_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_TDWR_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_TDWR_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_TDWR_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_TDWR_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_TDWR_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_TDWR_MEM_STATUS                        0x00044334 /* Reset: POR */
#define I40E_TDPU_TDWR_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_TDWR_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_TDWR_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_TDWR_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_TDWR_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_TDWR_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_TDWR_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_TDWR_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_TDWR_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG                    0x00044300 /* Reset: POR */
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RME_SHIFT          12
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RME_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RM_SHIFT           16
#define I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TDPU_VSI_LY2_INSERT_MEM_CFG_RM_SHIFT)

#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS                        0x00044320 /* Reset: POR */
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TDPU_VSI_LY2_INSERT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TLAN_DEC_MEM_CFG                    0x000E6490 /* Reset: POR */
#define I40E_TLAN_DEC_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TLAN_DEC_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TLAN_DEC_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TLAN_DEC_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TLAN_DEC_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TLAN_DEC_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TLAN_DEC_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_RME_SHIFT          12
#define I40E_TLAN_DEC_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MEM_CFG_RME_SHIFT)
#define I40E_TLAN_DEC_MEM_CFG_RM_SHIFT           16
#define I40E_TLAN_DEC_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TLAN_DEC_MEM_CFG_RM_SHIFT)

#define I40E_TLAN_DEC_MEM_STATUS                        0x000E6494 /* Reset: POR */
#define I40E_TLAN_DEC_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TLAN_DEC_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TLAN_DEC_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TLAN_DEC_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TLAN_DEC_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TLAN_DEC_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TLAN_DEC_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TLAN_DEC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TLAN_DEC_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TLAN_DEC_MNG_MEM_CFG                    0x000E64A0 /* Reset: POR */
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TLAN_DEC_MNG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TLAN_DEC_MNG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TLAN_DEC_MNG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TLAN_DEC_MNG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TLAN_DEC_MNG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_RME_SHIFT          12
#define I40E_TLAN_DEC_MNG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_CFG_RME_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_CFG_RM_SHIFT           16
#define I40E_TLAN_DEC_MNG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TLAN_DEC_MNG_MEM_CFG_RM_SHIFT)

#define I40E_TLAN_DEC_MNG_MEM_STATUS                        0x000E64A4 /* Reset: POR */
#define I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TLAN_DEC_MNG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TLAN_DEC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TLAN_DEC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TLAN_DEC_PTRS_MEM_CFG                    0x000E6498 /* Reset: POR */
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TLAN_DEC_PTRS_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TLAN_DEC_PTRS_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TLAN_DEC_PTRS_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TLAN_DEC_PTRS_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TLAN_DEC_PTRS_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_RME_SHIFT          12
#define I40E_TLAN_DEC_PTRS_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_CFG_RME_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_CFG_RM_SHIFT           16
#define I40E_TLAN_DEC_PTRS_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TLAN_DEC_PTRS_MEM_CFG_RM_SHIFT)

#define I40E_TLAN_DEC_PTRS_MEM_STATUS                        0x000E649C /* Reset: POR */
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TLAN_DEC_PTRS_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TLAN_DEC_PTRS_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TLAN_ECC_COR_ERR           0x000E64B4 /* Reset: POR */
#define I40E_TLAN_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_TLAN_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TLAN_ECC_COR_ERR_CNT_SHIFT)

#define I40E_TLAN_ECC_UNCOR_ERR           0x000E64B0 /* Reset: POR */
#define I40E_TLAN_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_TLAN_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TLAN_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_TLAN_HEAD_WB_CFG                    0x000E64A8 /* Reset: POR */
#define I40E_TLAN_HEAD_WB_CFG_ECC_EN_SHIFT       0
#define I40E_TLAN_HEAD_WB_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_ECC_EN_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_LS_FORCE_SHIFT     3
#define I40E_TLAN_HEAD_WB_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_LS_FORCE_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_LS_BYPASS_SHIFT    4
#define I40E_TLAN_HEAD_WB_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_LS_BYPASS_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_MASK_INT_SHIFT     5
#define I40E_TLAN_HEAD_WB_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_MASK_INT_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_FIX_CNT_SHIFT      8
#define I40E_TLAN_HEAD_WB_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_FIX_CNT_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_ERR_CNT_SHIFT      9
#define I40E_TLAN_HEAD_WB_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_ERR_CNT_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_RME_SHIFT          12
#define I40E_TLAN_HEAD_WB_CFG_RME_MASK           I40E_MASK(0x1, I40E_TLAN_HEAD_WB_CFG_RME_SHIFT)
#define I40E_TLAN_HEAD_WB_CFG_RM_SHIFT           16
#define I40E_TLAN_HEAD_WB_CFG_RM_MASK            I40E_MASK(0xF, I40E_TLAN_HEAD_WB_CFG_RM_SHIFT)

#define I40E_TLAN_HEAD_WB_STATUS                        0x000E64AC /* Reset: POR */
#define I40E_TLAN_HEAD_WB_STATUS_ECC_ERR_SHIFT          0
#define I40E_TLAN_HEAD_WB_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TLAN_HEAD_WB_STATUS_ECC_ERR_SHIFT)
#define I40E_TLAN_HEAD_WB_STATUS_ECC_FIX_SHIFT          1
#define I40E_TLAN_HEAD_WB_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TLAN_HEAD_WB_STATUS_ECC_FIX_SHIFT)
#define I40E_TLAN_HEAD_WB_STATUS_INIT_DONE_SHIFT        2
#define I40E_TLAN_HEAD_WB_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TLAN_HEAD_WB_STATUS_INIT_DONE_SHIFT)
#define I40E_TLAN_HEAD_WB_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TLAN_HEAD_WB_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TLAN_HEAD_WB_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TPB_CLID_MEM_CFG                    0x0009808C /* Reset: POR */
#define I40E_TPB_CLID_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TPB_CLID_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TPB_CLID_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TPB_CLID_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TPB_CLID_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TPB_CLID_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TPB_CLID_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TPB_CLID_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TPB_CLID_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_RME_SHIFT          12
#define I40E_TPB_CLID_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TPB_CLID_MEM_CFG_RME_SHIFT)
#define I40E_TPB_CLID_MEM_CFG_RM_SHIFT           16
#define I40E_TPB_CLID_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TPB_CLID_MEM_CFG_RM_SHIFT)

#define I40E_TPB_CLID_MEM_DBG_CTL              0x000980C8 /* Reset: CORER */
#define I40E_TPB_CLID_MEM_DBG_CTL_ADR_SHIFT    0
#define I40E_TPB_CLID_MEM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TPB_CLID_MEM_DBG_CTL_ADR_SHIFT)
#define I40E_TPB_CLID_MEM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TPB_CLID_MEM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TPB_CLID_MEM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TPB_CLID_MEM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TPB_CLID_MEM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TPB_CLID_MEM_DBG_CTL_RD_EN_SHIFT)
#define I40E_TPB_CLID_MEM_DBG_CTL_DONE_SHIFT   31
#define I40E_TPB_CLID_MEM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TPB_CLID_MEM_DBG_CTL_DONE_SHIFT)

#define I40E_TPB_CLID_MEM_DBG_DATA             0x000980D4 /* Reset: CORER */
#define I40E_TPB_CLID_MEM_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TPB_CLID_MEM_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_CLID_MEM_DBG_DATA_RD_DW_SHIFT)

#define I40E_TPB_CLID_MEM_STATUS                        0x00098090 /* Reset: POR */
#define I40E_TPB_CLID_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TPB_CLID_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TPB_CLID_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TPB_CLID_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TPB_CLID_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TPB_CLID_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TPB_CLID_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TPB_CLID_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TPB_CLID_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TPB_CLID_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TPB_DBG_FEAT                     0x00098084 /* Reset: CORER */
#define I40E_TPB_DBG_FEAT_DIS_MIB_SHIFT       0
#define I40E_TPB_DBG_FEAT_DIS_MIB_MASK        I40E_MASK(0xF, I40E_TPB_DBG_FEAT_DIS_MIB_SHIFT)
#define I40E_TPB_DBG_FEAT_FORCE_FC_IND_SHIFT  4
#define I40E_TPB_DBG_FEAT_FORCE_FC_IND_MASK   I40E_MASK(0xF, I40E_TPB_DBG_FEAT_FORCE_FC_IND_SHIFT)
#define I40E_TPB_DBG_FEAT_OBEY_FC_OVR_SHIFT   8
#define I40E_TPB_DBG_FEAT_OBEY_FC_OVR_MASK    I40E_MASK(0xF, I40E_TPB_DBG_FEAT_OBEY_FC_OVR_SHIFT)
#define I40E_TPB_DBG_FEAT_DIS_BURST_CTL_SHIFT 12
#define I40E_TPB_DBG_FEAT_DIS_BURST_CTL_MASK  I40E_MASK(0xF, I40E_TPB_DBG_FEAT_DIS_BURST_CTL_SHIFT)

#define I40E_TPB_ECC_COR_ERR           0x000980B8 /* Reset: POR */
#define I40E_TPB_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_TPB_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TPB_ECC_COR_ERR_CNT_SHIFT)

#define I40E_TPB_ECC_UNCOR_ERR           0x000980B4 /* Reset: POR */
#define I40E_TPB_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_TPB_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TPB_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_TPB_FC_OVR                  0x00098088 /* Reset: CORER */
#define I40E_TPB_FC_OVR_TPB_FC_OVR_SHIFT 0
#define I40E_TPB_FC_OVR_TPB_FC_OVR_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_FC_OVR_TPB_FC_OVR_SHIFT)

#define I40E_TPB_PKT_MEM_CFG                    0x00098094 /* Reset: POR */
#define I40E_TPB_PKT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TPB_PKT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TPB_PKT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TPB_PKT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TPB_PKT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TPB_PKT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TPB_PKT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TPB_PKT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TPB_PKT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_RME_SHIFT          12
#define I40E_TPB_PKT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TPB_PKT_MEM_CFG_RME_SHIFT)
#define I40E_TPB_PKT_MEM_CFG_RM_SHIFT           16
#define I40E_TPB_PKT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TPB_PKT_MEM_CFG_RM_SHIFT)

#define I40E_TPB_PKT_MEM_DBG_CTL              0x000980CC /* Reset: CORER */
#define I40E_TPB_PKT_MEM_DBG_CTL_ADR_SHIFT    0
#define I40E_TPB_PKT_MEM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TPB_PKT_MEM_DBG_CTL_ADR_SHIFT)
#define I40E_TPB_PKT_MEM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TPB_PKT_MEM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TPB_PKT_MEM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TPB_PKT_MEM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TPB_PKT_MEM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TPB_PKT_MEM_DBG_CTL_RD_EN_SHIFT)
#define I40E_TPB_PKT_MEM_DBG_CTL_DONE_SHIFT   31
#define I40E_TPB_PKT_MEM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TPB_PKT_MEM_DBG_CTL_DONE_SHIFT)

#define I40E_TPB_PKT_MEM_DBG_DATA             0x000980E0 /* Reset: CORER */
#define I40E_TPB_PKT_MEM_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TPB_PKT_MEM_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_PKT_MEM_DBG_DATA_RD_DW_SHIFT)

#define I40E_TPB_PKT_MEM_STATUS                        0x00098098 /* Reset: POR */
#define I40E_TPB_PKT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TPB_PKT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TPB_PKT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TPB_PKT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TPB_PKT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TPB_PKT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TPB_PKT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TPB_PKT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TPB_PKT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TPB_PKT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TPB_REPORT_LL_MEM_CFG                    0x0009809C /* Reset: POR */
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TPB_REPORT_LL_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TPB_REPORT_LL_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TPB_REPORT_LL_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TPB_REPORT_LL_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TPB_REPORT_LL_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_RME_SHIFT          12
#define I40E_TPB_REPORT_LL_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_CFG_RME_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_CFG_RM_SHIFT           16
#define I40E_TPB_REPORT_LL_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TPB_REPORT_LL_MEM_CFG_RM_SHIFT)

#define I40E_TPB_REPORT_LL_MEM_DBG_CTL              0x000980C0 /* Reset: CORER */
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_ADR_SHIFT    0
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TPB_REPORT_LL_MEM_DBG_CTL_ADR_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TPB_REPORT_LL_MEM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_DBG_CTL_RD_EN_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_DONE_SHIFT   31
#define I40E_TPB_REPORT_LL_MEM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_DBG_CTL_DONE_SHIFT)

#define I40E_TPB_REPORT_LL_MEM_DBG_DATA             0x000980D8 /* Reset: CORER */
#define I40E_TPB_REPORT_LL_MEM_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TPB_REPORT_LL_MEM_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_REPORT_LL_MEM_DBG_DATA_RD_DW_SHIFT)

#define I40E_TPB_REPORT_LL_MEM_STATUS                        0x000980A0 /* Reset: POR */
#define I40E_TPB_REPORT_LL_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TPB_REPORT_LL_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TPB_REPORT_LL_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TPB_REPORT_LL_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_LL_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TPB_REPORT_MEM_CFG                    0x000980A4 /* Reset: POR */
#define I40E_TPB_REPORT_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TPB_REPORT_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TPB_REPORT_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TPB_REPORT_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TPB_REPORT_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TPB_REPORT_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TPB_REPORT_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_RME_SHIFT          12
#define I40E_TPB_REPORT_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_MEM_CFG_RME_SHIFT)
#define I40E_TPB_REPORT_MEM_CFG_RM_SHIFT           16
#define I40E_TPB_REPORT_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TPB_REPORT_MEM_CFG_RM_SHIFT)

#define I40E_TPB_REPORT_MEM_DBG_CTL              0x000980C4 /* Reset: CORER */
#define I40E_TPB_REPORT_MEM_DBG_CTL_ADR_SHIFT    0
#define I40E_TPB_REPORT_MEM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TPB_REPORT_MEM_DBG_CTL_ADR_SHIFT)
#define I40E_TPB_REPORT_MEM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TPB_REPORT_MEM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TPB_REPORT_MEM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TPB_REPORT_MEM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TPB_REPORT_MEM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TPB_REPORT_MEM_DBG_CTL_RD_EN_SHIFT)
#define I40E_TPB_REPORT_MEM_DBG_CTL_DONE_SHIFT   31
#define I40E_TPB_REPORT_MEM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TPB_REPORT_MEM_DBG_CTL_DONE_SHIFT)

#define I40E_TPB_REPORT_MEM_DBG_DATA             0x000980DC /* Reset: CORER */
#define I40E_TPB_REPORT_MEM_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TPB_REPORT_MEM_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_REPORT_MEM_DBG_DATA_RD_DW_SHIFT)

#define I40E_TPB_REPORT_MEM_STATUS                        0x000980A8 /* Reset: POR */
#define I40E_TPB_REPORT_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TPB_REPORT_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TPB_REPORT_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TPB_REPORT_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TPB_REPORT_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TPB_REPORT_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TPB_REPORT_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TPB_REPORT_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TPB_REPORT_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TPB_RPB_BUFF_MEM_CFG                    0x000980AC /* Reset: POR */
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_ECC_EN_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_TPB_RPB_BUFF_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_TPB_RPB_BUFF_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_TPB_RPB_BUFF_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_MASK_INT_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_TPB_RPB_BUFF_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_TPB_RPB_BUFF_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_RME_SHIFT          12
#define I40E_TPB_RPB_BUFF_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_CFG_RME_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_CFG_RM_SHIFT           16
#define I40E_TPB_RPB_BUFF_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_TPB_RPB_BUFF_MEM_CFG_RM_SHIFT)

#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL              0x000980BC /* Reset: CORER */
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_ADR_SHIFT    0
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_TPB_RPB_BUFF_MEM_DBG_CTL_ADR_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_DBG_CTL_RD_EN_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DONE_SHIFT   31
#define I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_DBG_CTL_DONE_SHIFT)

#define I40E_TPB_RPB_BUFF_MEM_DBG_DATA             0x000980D0 /* Reset: CORER */
#define I40E_TPB_RPB_BUFF_MEM_DBG_DATA_RD_DW_SHIFT 0
#define I40E_TPB_RPB_BUFF_MEM_DBG_DATA_RD_DW_MASK  I40E_MASK(0xFFFFFFFF, I40E_TPB_RPB_BUFF_MEM_DBG_DATA_RD_DW_SHIFT)

#define I40E_TPB_RPB_BUFF_MEM_STATUS                        0x000980B0 /* Reset: POR */
#define I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_TPB_RPB_BUFF_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_TPB_RPB_BUFF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TPB_RPB_BUFF_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TPB_RPB_BUFF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_BRANCH_TABLE_CFG                    0x000B2218 /* Reset: POR */
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_BRANCH_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_BRANCH_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_BRANCH_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_BRANCH_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_BRANCH_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_RME_SHIFT          12
#define I40E_TSCD_BRANCH_TABLE_CFG_RME_MASK           I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_CFG_RME_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_CFG_RM_SHIFT           16
#define I40E_TSCD_BRANCH_TABLE_CFG_RM_MASK            I40E_MASK(0xF, I40E_TSCD_BRANCH_TABLE_CFG_RM_SHIFT)

#define I40E_TSCD_BRANCH_TABLE_STATUS                        0x000B2230 /* Reset: POR */
#define I40E_TSCD_BRANCH_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_BRANCH_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_BRANCH_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_BRANCH_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_BRANCH_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_BRANCH_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_BRANCH_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_BW_LIMIT_TABLE_CFG                    0x000B2204 /* Reset: POR */
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_A_SHIFT        12
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_A_MASK         I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_A_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_B_SHIFT        13
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_B_MASK         I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_CFG_RME_B_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_A_SHIFT         16
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_A_MASK          I40E_MASK(0xF, I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_A_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_B_SHIFT         20
#define I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_B_MASK          I40E_MASK(0xF, I40E_TSCD_BW_LIMIT_TABLE_CFG_RM_B_SHIFT)

#define I40E_TSCD_BW_LIMIT_TABLE_STATUS                        0x000B2228 /* Reset: POR */
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_ECC_COR_ERR           0x000B223c /* Reset: POR */
#define I40E_TSCD_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_TSCD_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TSCD_ECC_COR_ERR_CNT_SHIFT)

#define I40E_TSCD_ECC_UNCOR_ERR           0x000B2238 /* Reset: POR */
#define I40E_TSCD_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_TSCD_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_TSCD_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_TSCD_NEXT_NODE_TABLE_CFG                    0x000B220C /* Reset: POR */
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_RME_SHIFT          12
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_RME_MASK           I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_CFG_RME_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_RM_SHIFT           16
#define I40E_TSCD_NEXT_NODE_TABLE_CFG_RM_MASK            I40E_MASK(0xF, I40E_TSCD_NEXT_NODE_TABLE_CFG_RM_SHIFT)

#define I40E_TSCD_NEXT_NODE_TABLE_STATUS                        0x000B222c /* Reset: POR */
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_NEXT_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_NEXT_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_NODE_TABLE_CFG                    0x000B2210 /* Reset: POR */
#define I40E_TSCD_NODE_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_NODE_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_NODE_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_NODE_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_NODE_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_NODE_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_NODE_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_RME_SHIFT          12
#define I40E_TSCD_NODE_TABLE_CFG_RME_MASK           I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_CFG_RME_SHIFT)
#define I40E_TSCD_NODE_TABLE_CFG_RM_SHIFT           16
#define I40E_TSCD_NODE_TABLE_CFG_RM_MASK            I40E_MASK(0xF, I40E_TSCD_NODE_TABLE_CFG_RM_SHIFT)

#define I40E_TSCD_NODE_TABLE_STATUS                        0x000B2220 /* Reset: POR */
#define I40E_TSCD_NODE_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_NODE_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_NODE_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_NODE_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_NODE_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_NODE_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_NODE_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_RL_MAP_TABLE_CFG                    0x000B2214 /* Reset: POR */
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_RL_MAP_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_RL_MAP_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_RL_MAP_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_RL_MAP_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_RL_MAP_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_RME_SHIFT          12
#define I40E_TSCD_RL_MAP_TABLE_CFG_RME_MASK           I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_CFG_RME_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_CFG_RM_SHIFT           16
#define I40E_TSCD_RL_MAP_TABLE_CFG_RM_MASK            I40E_MASK(0xF, I40E_TSCD_RL_MAP_TABLE_CFG_RM_SHIFT)

#define I40E_TSCD_RL_MAP_TABLE_STATUS                        0x000B2224 /* Reset: POR */
#define I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_RL_MAP_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_RL_MAP_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_RL_MAP_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_RL_MAP_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG                    0x000B2200 /* Reset: POR */
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_EN_SHIFT       0
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_EN_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_1_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ECC_INVERT_2_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_FORCE_SHIFT     3
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_FORCE_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_BYPASS_SHIFT    4
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_LS_BYPASS_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_MASK_INT_SHIFT     5
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_MASK_INT_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_FIX_CNT_SHIFT      8
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_FIX_CNT_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ERR_CNT_SHIFT      9
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_ERR_CNT_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RME_SHIFT          12
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RME_MASK           I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RME_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RM_SHIFT           16
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RM_MASK            I40E_MASK(0xF, I40E_TSCD_SHARED_BW_LIMIT_TABLE_CFG_RM_SHIFT)

#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS                        0x000B2234 /* Reset: POR */
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_ERR_SHIFT          0
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_ERR_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_FIX_SHIFT          1
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_ECC_FIX_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_INIT_DONE_SHIFT        2
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_INIT_DONE_SHIFT)
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_TSCD_SHARED_BW_LIMIT_TABLE_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_TXDBG_GL_CNTRL                  0x000BC000 /* Reset: CORER */
#define I40E_TXDBG_GL_CNTRL_TXDBG_MODE_SHIFT 0
#define I40E_TXDBG_GL_CNTRL_TXDBG_MODE_MASK  I40E_MASK(0x7, I40E_TXDBG_GL_CNTRL_TXDBG_MODE_SHIFT)

#define I40E_TXDBG_RD_ENTITY              0x000BC004 /* Reset: CORER */
#define I40E_TXDBG_RD_ENTITY_RD_LOG_SHIFT 0
#define I40E_TXDBG_RD_ENTITY_RD_LOG_MASK  I40E_MASK(0xFFFFFFFF, I40E_TXDBG_RD_ENTITY_RD_LOG_SHIFT)

#define I40E_TXDBG_RD_ENTITY_CNTRL                     0x000BC008 /* Reset: CORER */
#define I40E_TXDBG_RD_ENTITY_CNTRL_RD_ENTITY_NUM_SHIFT 0
#define I40E_TXDBG_RD_ENTITY_CNTRL_RD_ENTITY_NUM_MASK  I40E_MASK(0xFFF, I40E_TXDBG_RD_ENTITY_CNTRL_RD_ENTITY_NUM_SHIFT)

#define I40E_TXUPDBG_ITR_CAUSE_CTL                      0x000E0018 /* Reset: CORER */
#define I40E_TXUPDBG_ITR_CAUSE_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_ITR_CAUSE_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_ITR_CAUSE_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_ITR_CAUSE_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_ITR_CAUSE_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_ITR_CAUSE_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_ITR_CAUSE_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_ITR_CAUSE_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_ITR_CAUSE_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_ITR_DONE_CTL                      0x000E0020 /* Reset: CORER */
#define I40E_TXUPDBG_ITR_DONE_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_ITR_DONE_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_ITR_DONE_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_ITR_DONE_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_ITR_DONE_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_ITR_DONE_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_ITR_DONE_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_ITR_DONE_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_ITR_DONE_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_ITR_EXP_CTL                      0x000E001C /* Reset: CORER */
#define I40E_TXUPDBG_ITR_EXP_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_ITR_EXP_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_ITR_EXP_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_ITR_EXP_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_ITR_EXP_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_ITR_EXP_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_ITR_EXP_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_ITR_EXP_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_ITR_EXP_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_MAC0IN_CTL                      0x000E2008 /* Reset: CORER */
#define I40E_TXUPDBG_MAC0IN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_MAC0IN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_MAC0IN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_MAC0IN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_MAC0IN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_MAC0IN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_MAC0IN_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_MAC0IN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_MAC0IN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_MAC1IN_CTL                      0x000E200C /* Reset: CORER */
#define I40E_TXUPDBG_MAC1IN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_MAC1IN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_MAC1IN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_MAC1IN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_MAC1IN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_MAC1IN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_MAC1IN_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_MAC1IN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_MAC1IN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_MAC2IN_CTL                      0x000E2010 /* Reset: CORER */
#define I40E_TXUPDBG_MAC2IN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_MAC2IN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_MAC2IN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_MAC2IN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_MAC2IN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_MAC2IN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_MAC2IN_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_MAC2IN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_MAC2IN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_MAC3IN_CTL                      0x000E2014 /* Reset: CORER */
#define I40E_TXUPDBG_MAC3IN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_MAC3IN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_MAC3IN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_MAC3IN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_MAC3IN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_MAC3IN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_MAC3IN_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_MAC3IN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_MAC3IN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_MSIX_CTL                      0x000BC00C /* Reset: CORER */
#define I40E_TXUPDBG_MSIX_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_MSIX_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_MSIX_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_MSIX_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_MSIX_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_MSIX_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_MSIX_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_MSIX_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_MSIX_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_Q_SCHED_CTL                      0x000E000C /* Reset: CORER */
#define I40E_TXUPDBG_Q_SCHED_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_Q_SCHED_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_Q_SCHED_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_Q_SCHED_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_Q_SCHED_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_Q_SCHED_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_Q_SCHED_CTL_FLOW_CHOOSER_SHIFT   13
#define I40E_TXUPDBG_Q_SCHED_CTL_FLOW_CHOOSER_MASK    I40E_MASK(0x3, I40E_TXUPDBG_Q_SCHED_CTL_FLOW_CHOOSER_SHIFT)
#define I40E_TXUPDBG_Q_SCHED_CTL_EVENT_ID_SHIFT       15
#define I40E_TXUPDBG_Q_SCHED_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_Q_SCHED_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_QG_SCHED_CTL                      0x000E0008 /* Reset: CORER */
#define I40E_TXUPDBG_QG_SCHED_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_QG_SCHED_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_QG_SCHED_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_QG_SCHED_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_QG_SCHED_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_QG_SCHED_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_QG_SCHED_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_QG_SCHED_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_QG_SCHED_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_TAIL_BUMP_CTL                      0x000E0000 /* Reset: CORER */
#define I40E_TXUPDBG_TAIL_BUMP_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_TAIL_BUMP_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_TAIL_BUMP_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_TAIL_BUMP_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_TAIL_BUMP_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_TAIL_BUMP_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_TAIL_BUMP_CTL_EVENT_ID_SHIFT       13
#define I40E_TXUPDBG_TAIL_BUMP_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_TAIL_BUMP_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_TCBIN_CTL                      0x000E0010 /* Reset: CORER */
#define I40E_TXUPDBG_TCBIN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_TCBIN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_TCBIN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_TCBIN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_TCBIN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_TCBIN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_TCBIN_CTL_FLOW_CHOOSER_SHIFT   13
#define I40E_TXUPDBG_TCBIN_CTL_FLOW_CHOOSER_MASK    I40E_MASK(0x3, I40E_TXUPDBG_TCBIN_CTL_FLOW_CHOOSER_SHIFT)
#define I40E_TXUPDBG_TCBIN_CTL_EVENT_ID_SHIFT       15
#define I40E_TXUPDBG_TCBIN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_TCBIN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_TDPUIN_CTL                      0x000E2000 /* Reset: CORER */
#define I40E_TXUPDBG_TDPUIN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_TDPUIN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_TDPUIN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_TDPUIN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_TDPUIN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_TDPUIN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_TDPUIN_CTL_FLOW_CHOOSER_SHIFT   13
#define I40E_TXUPDBG_TDPUIN_CTL_FLOW_CHOOSER_MASK    I40E_MASK(0x3, I40E_TXUPDBG_TDPUIN_CTL_FLOW_CHOOSER_SHIFT)
#define I40E_TXUPDBG_TDPUIN_CTL_EVENT_ID_SHIFT       15
#define I40E_TXUPDBG_TDPUIN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_TDPUIN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_TLAN2_CTL                      0x000E0014 /* Reset: CORER */
#define I40E_TXUPDBG_TLAN2_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_TLAN2_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_TLAN2_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_TLAN2_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_TLAN2_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_TLAN2_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_TLAN2_CTL_FLOW_CHOOSER_SHIFT   13
#define I40E_TXUPDBG_TLAN2_CTL_FLOW_CHOOSER_MASK    I40E_MASK(0x3, I40E_TXUPDBG_TLAN2_CTL_FLOW_CHOOSER_SHIFT)
#define I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_A_SHIFT     15
#define I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_A_MASK      I40E_MASK(0x7, I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_A_SHIFT)
#define I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_B_SHIFT     18
#define I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_B_MASK      I40E_MASK(0x7, I40E_TXUPDBG_TLAN2_CTL_EVENT_ID_B_SHIFT)

#define I40E_TXUPDBG_TPBIN_CTL                      0x000E2004 /* Reset: CORER */
#define I40E_TXUPDBG_TPBIN_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_TPBIN_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_TPBIN_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_TPBIN_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_TPBIN_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_TPBIN_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_TPBIN_CTL_FLOW_CHOOSER_SHIFT   13
#define I40E_TXUPDBG_TPBIN_CTL_FLOW_CHOOSER_MASK    I40E_MASK(0x3, I40E_TXUPDBG_TPBIN_CTL_FLOW_CHOOSER_SHIFT)
#define I40E_TXUPDBG_TPBIN_CTL_EVENT_ID_SHIFT       15
#define I40E_TXUPDBG_TPBIN_CTL_EVENT_ID_MASK        I40E_MASK(0x7, I40E_TXUPDBG_TPBIN_CTL_EVENT_ID_SHIFT)

#define I40E_TXUPDBG_WA_CTL                      0x000E0004 /* Reset: CORER */
#define I40E_TXUPDBG_WA_CTL_FILTER_FLOW_EN_SHIFT 0
#define I40E_TXUPDBG_WA_CTL_FILTER_FLOW_EN_MASK  I40E_MASK(0x1, I40E_TXUPDBG_WA_CTL_FILTER_FLOW_EN_SHIFT)
#define I40E_TXUPDBG_WA_CTL_FLOW_ID_SHIFT        1
#define I40E_TXUPDBG_WA_CTL_FLOW_ID_MASK         I40E_MASK(0xFFF, I40E_TXUPDBG_WA_CTL_FLOW_ID_SHIFT)
#define I40E_TXUPDBG_WA_CTL_EVENT_ID_A_SHIFT     13
#define I40E_TXUPDBG_WA_CTL_EVENT_ID_A_MASK      I40E_MASK(0x7, I40E_TXUPDBG_WA_CTL_EVENT_ID_A_SHIFT)
#define I40E_TXUPDBG_WA_CTL_EVENT_ID_B_SHIFT     16
#define I40E_TXUPDBG_WA_CTL_EVENT_ID_B_MASK      I40E_MASK(0x7, I40E_TXUPDBG_WA_CTL_EVENT_ID_B_SHIFT)

#define I40E_WAIT_CMD_BUF_MEM_CFG                    0x000AE088 /* Reset: POR */
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_ECC_EN_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_WAIT_CMD_BUF_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_WAIT_CMD_BUF_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_WAIT_CMD_BUF_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_MASK_INT_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_WAIT_CMD_BUF_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_WAIT_CMD_BUF_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_RME_SHIFT          12
#define I40E_WAIT_CMD_BUF_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_CFG_RME_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_CFG_RM_SHIFT           16
#define I40E_WAIT_CMD_BUF_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_WAIT_CMD_BUF_MEM_CFG_RM_SHIFT)

#define I40E_WAIT_CMD_BUF_MEM_STATUS                        0x000AE08C /* Reset: POR */
#define I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_WAIT_CMD_BUF_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_WAIT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_WAIT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_BUF_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_WAIT_CMD_MNG_MEM_CFG                    0x000AE084 /* Reset: POR */
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_ECC_EN_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_WAIT_CMD_MNG_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_WAIT_CMD_MNG_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_WAIT_CMD_MNG_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_MASK_INT_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_WAIT_CMD_MNG_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_WAIT_CMD_MNG_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_RME_SHIFT          12
#define I40E_WAIT_CMD_MNG_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_CFG_RME_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_CFG_RM_SHIFT           16
#define I40E_WAIT_CMD_MNG_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_WAIT_CMD_MNG_MEM_CFG_RM_SHIFT)

#define I40E_WAIT_CMD_MNG_MEM_STATUS                        0x000AE090 /* Reset: POR */
#define I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_ERR_SHIFT          0
#define I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_ERR_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_FIX_SHIFT          1
#define I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_STATUS_ECC_FIX_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_STATUS_INIT_DONE_SHIFT        2
#define I40E_WAIT_CMD_MNG_MEM_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_STATUS_INIT_DONE_SHIFT)
#define I40E_WAIT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_WAIT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_WAIT_CMD_MNG_MEM_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_WUC_ECC_COR_ERR           0x0006E8AC /* Reset: POR */
#define I40E_WUC_ECC_COR_ERR_CNT_SHIFT 0
#define I40E_WUC_ECC_COR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_WUC_ECC_COR_ERR_CNT_SHIFT)

#define I40E_WUC_ECC_UNCOR_ERR           0x0006E8A8 /* Reset: POR */
#define I40E_WUC_ECC_UNCOR_ERR_CNT_SHIFT 0
#define I40E_WUC_ECC_UNCOR_ERR_CNT_MASK  I40E_MASK(0xFFF, I40E_WUC_ECC_UNCOR_ERR_CNT_SHIFT)

#define I40E_WUC_SP_FLEX_CFG                    0x0006E898 /* Reset: POR */
#define I40E_WUC_SP_FLEX_CFG_ECC_EN_SHIFT       0
#define I40E_WUC_SP_FLEX_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_ECC_EN_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_WUC_SP_FLEX_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_ECC_INVERT_1_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_WUC_SP_FLEX_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_ECC_INVERT_2_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_LS_FORCE_SHIFT     3
#define I40E_WUC_SP_FLEX_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_LS_FORCE_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_LS_BYPASS_SHIFT    4
#define I40E_WUC_SP_FLEX_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_LS_BYPASS_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_MASK_INT_SHIFT     5
#define I40E_WUC_SP_FLEX_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_MASK_INT_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_FIX_CNT_SHIFT      8
#define I40E_WUC_SP_FLEX_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_FIX_CNT_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_ERR_CNT_SHIFT      9
#define I40E_WUC_SP_FLEX_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_ERR_CNT_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_RME_SHIFT          12
#define I40E_WUC_SP_FLEX_CFG_RME_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_CFG_RME_SHIFT)
#define I40E_WUC_SP_FLEX_CFG_RM_SHIFT           16
#define I40E_WUC_SP_FLEX_CFG_RM_MASK            I40E_MASK(0xF, I40E_WUC_SP_FLEX_CFG_RM_SHIFT)

#define I40E_WUC_SP_FLEX_MASK_MEM_CFG                    0x0006E890 /* Reset: POR */
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_EN_SHIFT       0
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_EN_MASK        I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_EN_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_1_SHIFT 1
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_1_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_1_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_2_SHIFT 2
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_2_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_ECC_INVERT_2_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_FORCE_SHIFT     3
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_FORCE_MASK      I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_FORCE_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_BYPASS_SHIFT    4
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_BYPASS_MASK     I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_LS_BYPASS_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_MASK_INT_SHIFT     5
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_MASK_INT_MASK      I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_MASK_INT_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_FIX_CNT_SHIFT      8
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_FIX_CNT_MASK       I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_FIX_CNT_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ERR_CNT_SHIFT      9
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_ERR_CNT_MASK       I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_ERR_CNT_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_RME_SHIFT          12
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_RME_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_MEM_CFG_RME_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_RM_SHIFT           16
#define I40E_WUC_SP_FLEX_MASK_MEM_CFG_RM_MASK            I40E_MASK(0xF, I40E_WUC_SP_FLEX_MASK_MEM_CFG_RM_SHIFT)

#define I40E_WUC_SP_FLEX_MASK_STATUS                        0x0006E894 /* Reset: POR */
#define I40E_WUC_SP_FLEX_MASK_STATUS_ECC_ERR_SHIFT          0
#define I40E_WUC_SP_FLEX_MASK_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_STATUS_ECC_ERR_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_STATUS_ECC_FIX_SHIFT          1
#define I40E_WUC_SP_FLEX_MASK_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_STATUS_ECC_FIX_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_STATUS_INIT_DONE_SHIFT        2
#define I40E_WUC_SP_FLEX_MASK_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_STATUS_INIT_DONE_SHIFT)
#define I40E_WUC_SP_FLEX_MASK_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_WUC_SP_FLEX_MASK_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_MASK_STATUS_GLOBAL_INIT_DONE_SHIFT)

#define I40E_WUC_SP_FLEX_STATUS                        0x0006E89C /* Reset: POR */
#define I40E_WUC_SP_FLEX_STATUS_ECC_ERR_SHIFT          0
#define I40E_WUC_SP_FLEX_STATUS_ECC_ERR_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_STATUS_ECC_ERR_SHIFT)
#define I40E_WUC_SP_FLEX_STATUS_ECC_FIX_SHIFT          1
#define I40E_WUC_SP_FLEX_STATUS_ECC_FIX_MASK           I40E_MASK(0x1, I40E_WUC_SP_FLEX_STATUS_ECC_FIX_SHIFT)
#define I40E_WUC_SP_FLEX_STATUS_INIT_DONE_SHIFT        2
#define I40E_WUC_SP_FLEX_STATUS_INIT_DONE_MASK         I40E_MASK(0x1, I40E_WUC_SP_FLEX_STATUS_INIT_DONE_SHIFT)
#define I40E_WUC_SP_FLEX_STATUS_GLOBAL_INIT_DONE_SHIFT 3
#define I40E_WUC_SP_FLEX_STATUS_GLOBAL_INIT_DONE_MASK  I40E_MASK(0x1, I40E_WUC_SP_FLEX_STATUS_GLOBAL_INIT_DONE_SHIFT)

/* PF - Internal Fuses  */

/* PF - Interrupt Registers */

#define I40E_GLINT_CTL                        0x0003F800 /* Reset: CORER */
#define I40E_GLINT_CTL_DIS_AUTOMASK_PF0_SHIFT 0
#define I40E_GLINT_CTL_DIS_AUTOMASK_PF0_MASK  I40E_MASK(0x1, I40E_GLINT_CTL_DIS_AUTOMASK_PF0_SHIFT)
#define I40E_GLINT_CTL_DIS_AUTOMASK_VF0_SHIFT 1
#define I40E_GLINT_CTL_DIS_AUTOMASK_VF0_MASK  I40E_MASK(0x1, I40E_GLINT_CTL_DIS_AUTOMASK_VF0_SHIFT)
#define I40E_GLINT_CTL_DIS_AUTOMASK_N_SHIFT   2
#define I40E_GLINT_CTL_DIS_AUTOMASK_N_MASK    I40E_MASK(0x1, I40E_GLINT_CTL_DIS_AUTOMASK_N_SHIFT)

#define I40E_PFINT_ITR0_STAT(_i)              (0x00038200 + ((_i) * 128)) /* _i=0...2 */ /* Reset: PFR */
#define I40E_PFINT_ITR0_STAT_MAX_INDEX        2
#define I40E_PFINT_ITR0_STAT_ITR_EXPIRE_SHIFT 0
#define I40E_PFINT_ITR0_STAT_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_PFINT_ITR0_STAT_ITR_EXPIRE_SHIFT)
#define I40E_PFINT_ITR0_STAT_EVENT_SHIFT      1
#define I40E_PFINT_ITR0_STAT_EVENT_MASK       I40E_MASK(0x1, I40E_PFINT_ITR0_STAT_EVENT_SHIFT)
#define I40E_PFINT_ITR0_STAT_ITR_TIME_SHIFT   2
#define I40E_PFINT_ITR0_STAT_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_PFINT_ITR0_STAT_ITR_TIME_SHIFT)

#define I40E_PFINT_ITRN_STAT(_i, _INTPF)       (0x00032000 + ((_i) * 2048 + (_INTPF) * 4)) /* _i=0...2, _INTPF=0...511 */ /* Reset: PFR */
#define I40E_PFINT_ITRN_STAT_MAX_INDEX        2
#define I40E_PFINT_ITRN_STAT_ITR_EXPIRE_SHIFT 0
#define I40E_PFINT_ITRN_STAT_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_PFINT_ITRN_STAT_ITR_EXPIRE_SHIFT)
#define I40E_PFINT_ITRN_STAT_EVENT_SHIFT      1
#define I40E_PFINT_ITRN_STAT_EVENT_MASK       I40E_MASK(0x1, I40E_PFINT_ITRN_STAT_EVENT_SHIFT)
#define I40E_PFINT_ITRN_STAT_ITR_TIME_SHIFT   2
#define I40E_PFINT_ITRN_STAT_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_PFINT_ITRN_STAT_ITR_TIME_SHIFT)

#define I40E_PFINT_RATE0_STAT                  0x00038600 /* Reset: PFR */
#define I40E_PFINT_RATE0_STAT_CREDIT_SHIFT     0
#define I40E_PFINT_RATE0_STAT_CREDIT_MASK      I40E_MASK(0xF, I40E_PFINT_RATE0_STAT_CREDIT_SHIFT)
#define I40E_PFINT_RATE0_STAT_INTRL_TIME_SHIFT 4
#define I40E_PFINT_RATE0_STAT_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_PFINT_RATE0_STAT_INTRL_TIME_SHIFT)

#define I40E_PFINT_RATEN_STAT(_INTPF)          (0x00036000 + ((_INTPF) * 4)) /* _i=0...511 */ /* Reset: PFR */
#define I40E_PFINT_RATEN_STAT_MAX_INDEX        511
#define I40E_PFINT_RATEN_STAT_CREDIT_SHIFT     0
#define I40E_PFINT_RATEN_STAT_CREDIT_MASK      I40E_MASK(0xF, I40E_PFINT_RATEN_STAT_CREDIT_SHIFT)
#define I40E_PFINT_RATEN_STAT_INTRL_TIME_SHIFT 4
#define I40E_PFINT_RATEN_STAT_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_PFINT_RATEN_STAT_INTRL_TIME_SHIFT)

#define I40E_VFINT_ITR0_STAT(_i, _VF)          (0x00029000 + ((_i) * 1024 + (_VF) * 4)) /* _i=0...2, _VF=0...127 */ /* Reset: VFR */
#define I40E_VFINT_ITR0_STAT_MAX_INDEX        2
#define I40E_VFINT_ITR0_STAT_ITR_EXPIRE_SHIFT 0
#define I40E_VFINT_ITR0_STAT_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_VFINT_ITR0_STAT_ITR_EXPIRE_SHIFT)
#define I40E_VFINT_ITR0_STAT_EVENT_SHIFT      1
#define I40E_VFINT_ITR0_STAT_EVENT_MASK       I40E_MASK(0x1, I40E_VFINT_ITR0_STAT_EVENT_SHIFT)
#define I40E_VFINT_ITR0_STAT_ITR_TIME_SHIFT   2
#define I40E_VFINT_ITR0_STAT_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_VFINT_ITR0_STAT_ITR_TIME_SHIFT)

#define I40E_VFINT_ITRN_STAT(_i, _INTVF)       (0x00022000 + ((_i) * 2048 + (_INTVF) * 4)) /* _i=0...2, _INTVF=0...511 */ /* Reset: VFR */
#define I40E_VFINT_ITRN_STAT_MAX_INDEX        2
#define I40E_VFINT_ITRN_STAT_ITR_EXPIRE_SHIFT 0
#define I40E_VFINT_ITRN_STAT_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_VFINT_ITRN_STAT_ITR_EXPIRE_SHIFT)
#define I40E_VFINT_ITRN_STAT_EVENT_SHIFT      1
#define I40E_VFINT_ITRN_STAT_EVENT_MASK       I40E_MASK(0x1, I40E_VFINT_ITRN_STAT_EVENT_SHIFT)
#define I40E_VFINT_ITRN_STAT_ITR_TIME_SHIFT   2
#define I40E_VFINT_ITRN_STAT_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_VFINT_ITRN_STAT_ITR_TIME_SHIFT)

#define I40E_VFINT_RATE0_STAT(_VF)             (0x0002B000 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: VFR */
#define I40E_VFINT_RATE0_STAT_MAX_INDEX        127
#define I40E_VFINT_RATE0_STAT_CREDIT_SHIFT     0
#define I40E_VFINT_RATE0_STAT_CREDIT_MASK      I40E_MASK(0xF, I40E_VFINT_RATE0_STAT_CREDIT_SHIFT)
#define I40E_VFINT_RATE0_STAT_INTRL_TIME_SHIFT 4
#define I40E_VFINT_RATE0_STAT_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_VFINT_RATE0_STAT_INTRL_TIME_SHIFT)

#define I40E_VFINT_RATEN_STAT(_INTVF)          (0x00026000 + ((_INTVF) * 4)) /* _i=0...511 */ /* Reset: VFR */
#define I40E_VFINT_RATEN_STAT_MAX_INDEX        511
#define I40E_VFINT_RATEN_STAT_CREDIT_SHIFT     0
#define I40E_VFINT_RATEN_STAT_CREDIT_MASK      I40E_MASK(0xF, I40E_VFINT_RATEN_STAT_CREDIT_SHIFT)
#define I40E_VFINT_RATEN_STAT_INTRL_TIME_SHIFT 4
#define I40E_VFINT_RATEN_STAT_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_VFINT_RATEN_STAT_INTRL_TIME_SHIFT)

/* PF - LAN Transmit Receive Registers */

#define I40E_GLLAN_PF_RECIPE(_i)          (0x0012A5E0 + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLLAN_PF_RECIPE_MAX_INDEX    15
#define I40E_GLLAN_PF_RECIPE_RECIPE_SHIFT 0
#define I40E_GLLAN_PF_RECIPE_RECIPE_MASK  I40E_MASK(0x3, I40E_GLLAN_PF_RECIPE_RECIPE_SHIFT)

#define I40E_GLLAN_RCTL_1                       0x0012A504 /* Reset: CORER */
#define I40E_GLLAN_RCTL_1_RXMAX_EXPANSION_SHIFT 12
#define I40E_GLLAN_RCTL_1_RXMAX_EXPANSION_MASK  I40E_MASK(0xF, I40E_GLLAN_RCTL_1_RXMAX_EXPANSION_SHIFT)
#define I40E_GLLAN_RCTL_1_RXDWBCTL_SHIFT        16
#define I40E_GLLAN_RCTL_1_RXDWBCTL_MASK         I40E_MASK(0x1, I40E_GLLAN_RCTL_1_RXDWBCTL_SHIFT)
#define I40E_GLLAN_RCTL_1_RXDRDCTL_SHIFT        17
#define I40E_GLLAN_RCTL_1_RXDRDCTL_MASK         I40E_MASK(0x1, I40E_GLLAN_RCTL_1_RXDRDCTL_SHIFT)
#define I40E_GLLAN_RCTL_1_RXDESCRDROEN_SHIFT    18
#define I40E_GLLAN_RCTL_1_RXDESCRDROEN_MASK     I40E_MASK(0x1, I40E_GLLAN_RCTL_1_RXDESCRDROEN_SHIFT)
#define I40E_GLLAN_RCTL_1_RXDATAWRROEN_SHIFT    19
#define I40E_GLLAN_RCTL_1_RXDATAWRROEN_MASK     I40E_MASK(0x1, I40E_GLLAN_RCTL_1_RXDATAWRROEN_SHIFT)

#define I40E_GLLAN_TCTL_0                    0x000E6488 /* Reset: CORER */
#define I40E_GLLAN_TCTL_0_TXLANTH_SHIFT      0
#define I40E_GLLAN_TCTL_0_TXLANTH_MASK       I40E_MASK(0x3F, I40E_GLLAN_TCTL_0_TXLANTH_SHIFT)
#define I40E_GLLAN_TCTL_0_TXDESCRDROEN_SHIFT 6
#define I40E_GLLAN_TCTL_0_TXDESCRDROEN_MASK  I40E_MASK(0x1, I40E_GLLAN_TCTL_0_TXDESCRDROEN_SHIFT)

#define I40E_GLLAN_TCTL_1                        0x000442F0 /* Reset: CORER */
#define I40E_GLLAN_TCTL_1_TXMAX_EXPANSION_SHIFT  0
#define I40E_GLLAN_TCTL_1_TXMAX_EXPANSION_MASK   I40E_MASK(0xF, I40E_GLLAN_TCTL_1_TXMAX_EXPANSION_SHIFT)
#define I40E_GLLAN_TCTL_1_TXDATARDROEN_SHIFT     4
#define I40E_GLLAN_TCTL_1_TXDATARDROEN_MASK      I40E_MASK(0x1, I40E_GLLAN_TCTL_1_TXDATARDROEN_SHIFT)
#define I40E_GLLAN_TCTL_1_RCU_BYPASS_SHIFT       5
#define I40E_GLLAN_TCTL_1_RCU_BYPASS_MASK        I40E_MASK(0x1, I40E_GLLAN_TCTL_1_RCU_BYPASS_SHIFT)
#define I40E_GLLAN_TCTL_1_LSO_CACHE_BYPASS_SHIFT 6
#define I40E_GLLAN_TCTL_1_LSO_CACHE_BYPASS_MASK  I40E_MASK(0x1, I40E_GLLAN_TCTL_1_LSO_CACHE_BYPASS_SHIFT)
#define I40E_GLLAN_TCTL_1_DBG_WB_SEL_SHIFT       7
#define I40E_GLLAN_TCTL_1_DBG_WB_SEL_MASK        I40E_MASK(0xF, I40E_GLLAN_TCTL_1_DBG_WB_SEL_SHIFT)
#define I40E_GLLAN_TCTL_1_DBG_FORCE_RS_SHIFT     11
#define I40E_GLLAN_TCTL_1_DBG_FORCE_RS_MASK      I40E_MASK(0x1, I40E_GLLAN_TCTL_1_DBG_FORCE_RS_SHIFT)
#define I40E_GLLAN_TCTL_1_DBG_BYPASS_SHIFT       12
#define I40E_GLLAN_TCTL_1_DBG_BYPASS_MASK        I40E_MASK(0x3FF, I40E_GLLAN_TCTL_1_DBG_BYPASS_SHIFT)
#define I40E_GLLAN_TCTL_1_PRE_L2_ENA_SHIFT       22
#define I40E_GLLAN_TCTL_1_PRE_L2_ENA_MASK        I40E_MASK(0x1, I40E_GLLAN_TCTL_1_PRE_L2_ENA_SHIFT)
#define I40E_GLLAN_TCTL_1_UR_PROT_DIS_SHIFT      23
#define I40E_GLLAN_TCTL_1_UR_PROT_DIS_MASK       I40E_MASK(0x1, I40E_GLLAN_TCTL_1_UR_PROT_DIS_SHIFT)
#define I40E_GLLAN_TCTL_1_DBG_ECO_SHIFT          24
#define I40E_GLLAN_TCTL_1_DBG_ECO_MASK           I40E_MASK(0xFF, I40E_GLLAN_TCTL_1_DBG_ECO_SHIFT)

#define I40E_GLLAN_TCTL_2                       0x000AE080 /* Reset: CORER */
#define I40E_GLLAN_TCTL_2_TXMAX_EXPANSION_SHIFT 0
#define I40E_GLLAN_TCTL_2_TXMAX_EXPANSION_MASK  I40E_MASK(0xF, I40E_GLLAN_TCTL_2_TXMAX_EXPANSION_SHIFT)
#define I40E_GLLAN_TCTL_2_STAT_DBG_ADDR_SHIFT   4
#define I40E_GLLAN_TCTL_2_STAT_DBG_ADDR_MASK    I40E_MASK(0x1F, I40E_GLLAN_TCTL_2_STAT_DBG_ADDR_SHIFT)
#define I40E_GLLAN_TCTL_2_STAT_DBG_DSEL_SHIFT   9
#define I40E_GLLAN_TCTL_2_STAT_DBG_DSEL_MASK    I40E_MASK(0x7, I40E_GLLAN_TCTL_2_STAT_DBG_DSEL_SHIFT)
#define I40E_GLLAN_TCTL_2_ECO_SHIFT             12
#define I40E_GLLAN_TCTL_2_ECO_MASK              I40E_MASK(0xFFFFF, I40E_GLLAN_TCTL_2_ECO_SHIFT)

#define I40E_GLLAN_TXEMP_EN                 0x000AE0AC /* Reset: CORER */
#define I40E_GLLAN_TXEMP_EN_TXHOST_EN_SHIFT 0
#define I40E_GLLAN_TXEMP_EN_TXHOST_EN_MASK  I40E_MASK(0x1, I40E_GLLAN_TXEMP_EN_TXHOST_EN_SHIFT)

#define I40E_GLLAN_TXHOST_EN                 0x000A2208 /* Reset: CORER */
#define I40E_GLLAN_TXHOST_EN_TXHOST_EN_SHIFT 0
#define I40E_GLLAN_TXHOST_EN_TXHOST_EN_MASK  I40E_MASK(0x1, I40E_GLLAN_TXHOST_EN_TXHOST_EN_SHIFT)

#define I40E_GLRCU_INDIRECT_ADDRESS                              0x001C0AA4 /* Reset: CORER */
#define I40E_GLRCU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT 0
#define I40E_GLRCU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLRCU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT)

#define I40E_GLRCU_INDIRECT_DATA(_i)                       (0x001C0AA8 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLRCU_INDIRECT_DATA_MAX_INDEX                 1
#define I40E_GLRCU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT 0
#define I40E_GLRCU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT)

#define I40E_GLRCU_LB_INDIRECT_ADDRESS                              0x00269BD4 /* Reset: CORER */
#define I40E_GLRCU_LB_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT 0
#define I40E_GLRCU_LB_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLRCU_LB_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT)

#define I40E_GLRCU_LB_INDIRECT_DATA(_i)                       (0x00269898 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLRCU_LB_INDIRECT_DATA_MAX_INDEX                 3
#define I40E_GLRCU_LB_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT 0
#define I40E_GLRCU_LB_INDIRECT_DATA_GLRCU_INDIRECT_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCU_LB_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT)

#define I40E_GLRCU_RX_INDIRECT_ADDRESS                              0x00269BCC /* Reset: CORER */
#define I40E_GLRCU_RX_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT 0
#define I40E_GLRCU_RX_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLRCU_RX_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT)

#define I40E_GLRCU_RX_INDIRECT_DATA(_i)                       (0x00269888 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLRCU_RX_INDIRECT_DATA_MAX_INDEX                 3
#define I40E_GLRCU_RX_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT 0
#define I40E_GLRCU_RX_INDIRECT_DATA_GLRCU_INDIRECT_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRCU_RX_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT)

#define I40E_GLRDPU_INDIRECT_ADDRESS                              0x00051040 /* Reset: CORER */
#define I40E_GLRDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT 0
#define I40E_GLRDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLRDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT)

#define I40E_GLRDPU_INDIRECT_DATA(_i)                       (0x00051044 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLRDPU_INDIRECT_DATA_MAX_INDEX                 3
#define I40E_GLRDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT 0
#define I40E_GLRDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLRDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT)

#define I40E_GLTDPU_INDIRECT_ADDRESS                              0x00044264 /* Reset: CORER */
#define I40E_GLTDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT 0
#define I40E_GLTDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLTDPU_INDIRECT_ADDRESS_GLRCU_INDIRECT_ADDRESS_SHIFT)

#define I40E_GLTDPU_INDIRECT_DATA(_i)                       (0x00044268 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLTDPU_INDIRECT_DATA_MAX_INDEX                 3
#define I40E_GLTDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT 0
#define I40E_GLTDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLTDPU_INDIRECT_DATA_GLRCU_INDIRECT_DATA_SHIFT)

#define I40E_GLTLAN_MIN_MAX_MSS             0x000E64dC /* Reset: CORER */
#define I40E_GLTLAN_MIN_MAX_MSS_MAHDL_SHIFT 0
#define I40E_GLTLAN_MIN_MAX_MSS_MAHDL_MASK  I40E_MASK(0x3FFF, I40E_GLTLAN_MIN_MAX_MSS_MAHDL_SHIFT)
#define I40E_GLTLAN_MIN_MAX_MSS_MIHDL_SHIFT 16
#define I40E_GLTLAN_MIN_MAX_MSS_MIHDL_MASK  I40E_MASK(0x3FF, I40E_GLTLAN_MIN_MAX_MSS_MIHDL_SHIFT)
#define I40E_GLTLAN_MIN_MAX_MSS_RSV_SHIFT   26
#define I40E_GLTLAN_MIN_MAX_MSS_RSV_MASK    I40E_MASK(0x3F, I40E_GLTLAN_MIN_MAX_MSS_RSV_SHIFT)

#define I40E_GLTLAN_MIN_MAX_PKT             0x000E64DC /* Reset: CORER */
#define I40E_GLTLAN_MIN_MAX_PKT_MAHDL_SHIFT 0
#define I40E_GLTLAN_MIN_MAX_PKT_MAHDL_MASK  I40E_MASK(0x3FFF, I40E_GLTLAN_MIN_MAX_PKT_MAHDL_SHIFT)
#define I40E_GLTLAN_MIN_MAX_PKT_MIHDL_SHIFT 16
#define I40E_GLTLAN_MIN_MAX_PKT_MIHDL_MASK  I40E_MASK(0x3F, I40E_GLTLAN_MIN_MAX_PKT_MIHDL_SHIFT)
#define I40E_GLTLAN_MIN_MAX_PKT_RSV_SHIFT   22
#define I40E_GLTLAN_MIN_MAX_PKT_RSV_MASK    I40E_MASK(0x3FF, I40E_GLTLAN_MIN_MAX_PKT_RSV_SHIFT)

#define I40E_PF_VT_PFALLOC_RLAN               0x0012A480 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_RLAN_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_RLAN_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_RLAN_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_RLAN_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_RLAN_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_RLAN_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_RLAN_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_RLAN_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_RLAN_VALID_SHIFT)

#define I40E_PFLAN_QALLOC_CSR              0x00078E00 /* Reset: CORER */
#define I40E_PFLAN_QALLOC_CSR_FIRSTQ_SHIFT 0
#define I40E_PFLAN_QALLOC_CSR_FIRSTQ_MASK  I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_CSR_FIRSTQ_SHIFT)
#define I40E_PFLAN_QALLOC_CSR_LASTQ_SHIFT  16
#define I40E_PFLAN_QALLOC_CSR_LASTQ_MASK   I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_CSR_LASTQ_SHIFT)
#define I40E_PFLAN_QALLOC_CSR_VALID_SHIFT  31
#define I40E_PFLAN_QALLOC_CSR_VALID_MASK   I40E_MASK(0x1, I40E_PFLAN_QALLOC_CSR_VALID_SHIFT)

#define I40E_PFLAN_QALLOC_INT              0x0003F000 /* Reset: CORER */
#define I40E_PFLAN_QALLOC_INT_FIRSTQ_SHIFT 0
#define I40E_PFLAN_QALLOC_INT_FIRSTQ_MASK  I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_INT_FIRSTQ_SHIFT)
#define I40E_PFLAN_QALLOC_INT_LASTQ_SHIFT  16
#define I40E_PFLAN_QALLOC_INT_LASTQ_MASK   I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_INT_LASTQ_SHIFT)
#define I40E_PFLAN_QALLOC_INT_VALID_SHIFT  31
#define I40E_PFLAN_QALLOC_INT_VALID_MASK   I40E_MASK(0x1, I40E_PFLAN_QALLOC_INT_VALID_SHIFT)

#define I40E_PFLAN_QALLOC_PMAT              0x000C0600 /* Reset: CORER */
#define I40E_PFLAN_QALLOC_PMAT_FIRSTQ_SHIFT 0
#define I40E_PFLAN_QALLOC_PMAT_FIRSTQ_MASK  I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_PMAT_FIRSTQ_SHIFT)
#define I40E_PFLAN_QALLOC_PMAT_LASTQ_SHIFT  16
#define I40E_PFLAN_QALLOC_PMAT_LASTQ_MASK   I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_PMAT_LASTQ_SHIFT)
#define I40E_PFLAN_QALLOC_PMAT_VALID_SHIFT  31
#define I40E_PFLAN_QALLOC_PMAT_VALID_MASK   I40E_MASK(0x1, I40E_PFLAN_QALLOC_PMAT_VALID_SHIFT)

#define I40E_PFLAN_QALLOC_RCB              0x00122080 /* Reset: CORER */
#define I40E_PFLAN_QALLOC_RCB_FIRSTQ_SHIFT 0
#define I40E_PFLAN_QALLOC_RCB_FIRSTQ_MASK  I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_RCB_FIRSTQ_SHIFT)
#define I40E_PFLAN_QALLOC_RCB_LASTQ_SHIFT  16
#define I40E_PFLAN_QALLOC_RCB_LASTQ_MASK   I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_RCB_LASTQ_SHIFT)
#define I40E_PFLAN_QALLOC_RCB_VALID_SHIFT  31
#define I40E_PFLAN_QALLOC_RCB_VALID_MASK   I40E_MASK(0x1, I40E_PFLAN_QALLOC_RCB_VALID_SHIFT)

#define I40E_PFLAN_QALLOC_RCU              0x00246780 /* Reset: CORER */
#define I40E_PFLAN_QALLOC_RCU_FIRSTQ_SHIFT 0
#define I40E_PFLAN_QALLOC_RCU_FIRSTQ_MASK  I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_RCU_FIRSTQ_SHIFT)
#define I40E_PFLAN_QALLOC_RCU_LASTQ_SHIFT  16
#define I40E_PFLAN_QALLOC_RCU_LASTQ_MASK   I40E_MASK(0x7FF, I40E_PFLAN_QALLOC_RCU_LASTQ_SHIFT)
#define I40E_PFLAN_QALLOC_RCU_VALID_SHIFT  31
#define I40E_PFLAN_QALLOC_RCU_VALID_MASK   I40E_MASK(0x1, I40E_PFLAN_QALLOC_RCU_VALID_SHIFT)

#define I40E_PRTLAN_RXEMP_EN                 0x001E4780 /* Reset: GLOBR */
#define I40E_PRTLAN_RXEMP_EN_RXHOST_EN_SHIFT 0
#define I40E_PRTLAN_RXEMP_EN_RXHOST_EN_MASK  I40E_MASK(0x1, I40E_PRTLAN_RXEMP_EN_RXHOST_EN_SHIFT)

/* PF - MAC Registers  */

#define I40E_PRTDCB_MPVCTL            0x001E2460 /* Reset: GLOBR */
#define I40E_PRTDCB_MPVCTL_PFCV_SHIFT 0
#define I40E_PRTDCB_MPVCTL_PFCV_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_MPVCTL_PFCV_SHIFT)
#define I40E_PRTDCB_MPVCTL_RFCV_SHIFT 16
#define I40E_PRTDCB_MPVCTL_RFCV_MASK  I40E_MASK(0xFFFF, I40E_PRTDCB_MPVCTL_RFCV_SHIFT)

#define I40E_PRTMAC_AN_LP_STATUS1                      0x0008C680 /* Reset: GLOBR */
#define I40E_PRTMAC_AN_LP_STATUS1_LP_AN_PAGE_LOW_SHIFT 0
#define I40E_PRTMAC_AN_LP_STATUS1_LP_AN_PAGE_LOW_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_AN_LP_STATUS1_LP_AN_PAGE_LOW_SHIFT)
#define I40E_PRTMAC_AN_LP_STATUS1_AN_ARB_STATE_SHIFT   16
#define I40E_PRTMAC_AN_LP_STATUS1_AN_ARB_STATE_MASK    I40E_MASK(0xF, I40E_PRTMAC_AN_LP_STATUS1_AN_ARB_STATE_SHIFT)
#define I40E_PRTMAC_AN_LP_STATUS1_RSVD_SHIFT           20
#define I40E_PRTMAC_AN_LP_STATUS1_RSVD_MASK            I40E_MASK(0xFFF, I40E_PRTMAC_AN_LP_STATUS1_RSVD_SHIFT)

#define I40E_PRTMAC_HLCTL                     0x001E2000 /* Reset: GLOBR */
#define I40E_PRTMAC_HLCTL_APPEND_CRC_SHIFT    0
#define I40E_PRTMAC_HLCTL_APPEND_CRC_MASK     I40E_MASK(0x1, I40E_PRTMAC_HLCTL_APPEND_CRC_SHIFT)
#define I40E_PRTMAC_HLCTL_RXCRCSTRP_SHIFT     1
#define I40E_PRTMAC_HLCTL_RXCRCSTRP_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLCTL_RXCRCSTRP_SHIFT)
#define I40E_PRTMAC_HLCTL_JUMBOEN_SHIFT       2
#define I40E_PRTMAC_HLCTL_JUMBOEN_MASK        I40E_MASK(0x1, I40E_PRTMAC_HLCTL_JUMBOEN_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD3_SHIFT  3
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD3_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD3_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD4_SHIFT  4
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD4_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD4_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD5_SHIFT  5
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD5_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD5_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD6_SHIFT  6
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD6_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD6_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD7_SHIFT  7
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD7_MASK   I40E_MASK(0x3, I40E_PRTMAC_HLCTL_LEGACY_RSVD7_SHIFT)
#define I40E_PRTMAC_HLCTL_SOFTRESET_SHIFT     9
#define I40E_PRTMAC_HLCTL_SOFTRESET_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLCTL_SOFTRESET_SHIFT)
#define I40E_PRTMAC_HLCTL_TXPADEN_SHIFT       10
#define I40E_PRTMAC_HLCTL_TXPADEN_MASK        I40E_MASK(0x1, I40E_PRTMAC_HLCTL_TXPADEN_SHIFT)
#define I40E_PRTMAC_HLCTL_TX_ENABLE_SHIFT     11
#define I40E_PRTMAC_HLCTL_TX_ENABLE_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLCTL_TX_ENABLE_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD12_SHIFT 12
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD12_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD12_SHIFT)
#define I40E_PRTMAC_HLCTL_RX_ENABLE_SHIFT     13
#define I40E_PRTMAC_HLCTL_RX_ENABLE_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLCTL_RX_ENABLE_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD14_SHIFT 14
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD14_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD14_SHIFT)
#define I40E_PRTMAC_HLCTL_LPBK_SHIFT          15
#define I40E_PRTMAC_HLCTL_LPBK_MASK           I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LPBK_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD16_SHIFT 16
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD16_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD16_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD17_SHIFT 17
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD17_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD17_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD18_SHIFT 18
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD18_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTL_LEGACY_RSVD18_SHIFT)
#define I40E_PRTMAC_HLCTL_TXLB2NET_SHIFT      19
#define I40E_PRTMAC_HLCTL_TXLB2NET_MASK       I40E_MASK(0x1, I40E_PRTMAC_HLCTL_TXLB2NET_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD20_SHIFT 20
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD20_MASK  I40E_MASK(0xF, I40E_PRTMAC_HLCTL_LEGACY_RSVD20_SHIFT)
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD24_SHIFT 24
#define I40E_PRTMAC_HLCTL_LEGACY_RSVD24_MASK  I40E_MASK(0x7, I40E_PRTMAC_HLCTL_LEGACY_RSVD24_SHIFT)
#define I40E_PRTMAC_HLCTL_RXLNGTHERREN_SHIFT  27
#define I40E_PRTMAC_HLCTL_RXLNGTHERREN_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_RXLNGTHERREN_SHIFT)
#define I40E_PRTMAC_HLCTL_RXPADSTRIPEN_SHIFT  28
#define I40E_PRTMAC_HLCTL_RXPADSTRIPEN_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTL_RXPADSTRIPEN_SHIFT)

#define I40E_PRTMAC_HLCTLA                     0x001E4760 /* Reset: GLOBR */
#define I40E_PRTMAC_HLCTLA_DROP_US_PKTS_SHIFT  0
#define I40E_PRTMAC_HLCTLA_DROP_US_PKTS_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTLA_DROP_US_PKTS_SHIFT)
#define I40E_PRTMAC_HLCTLA_RX_FWRD_CTRL_SHIFT  1
#define I40E_PRTMAC_HLCTLA_RX_FWRD_CTRL_MASK   I40E_MASK(0x1, I40E_PRTMAC_HLCTLA_RX_FWRD_CTRL_SHIFT)
#define I40E_PRTMAC_HLCTLA_CHOP_OS_PKT_SHIFT   2
#define I40E_PRTMAC_HLCTLA_CHOP_OS_PKT_MASK    I40E_MASK(0x1, I40E_PRTMAC_HLCTLA_CHOP_OS_PKT_SHIFT)
#define I40E_PRTMAC_HLCTLA_TX_HYSTERESIS_SHIFT 4
#define I40E_PRTMAC_HLCTLA_TX_HYSTERESIS_MASK  I40E_MASK(0x7, I40E_PRTMAC_HLCTLA_TX_HYSTERESIS_SHIFT)
#define I40E_PRTMAC_HLCTLA_HYS_FLUSH_PKT_SHIFT 7
#define I40E_PRTMAC_HLCTLA_HYS_FLUSH_PKT_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLCTLA_HYS_FLUSH_PKT_SHIFT)

#define I40E_PRTMAC_HLSTA                    0x001E2020 /* Reset: GLOBR */
#define I40E_PRTMAC_HLSTA_REVID_SHIFT        0
#define I40E_PRTMAC_HLSTA_REVID_MASK         I40E_MASK(0xF, I40E_PRTMAC_HLSTA_REVID_SHIFT)
#define I40E_PRTMAC_HLSTA_RESERVED_2_SHIFT   4
#define I40E_PRTMAC_HLSTA_RESERVED_2_MASK    I40E_MASK(0x1, I40E_PRTMAC_HLSTA_RESERVED_2_SHIFT)
#define I40E_PRTMAC_HLSTA_RXERRSYM_SHIFT     5
#define I40E_PRTMAC_HLSTA_RXERRSYM_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLSTA_RXERRSYM_SHIFT)
#define I40E_PRTMAC_HLSTA_RXILLSYM_SHIFT     6
#define I40E_PRTMAC_HLSTA_RXILLSYM_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLSTA_RXILLSYM_SHIFT)
#define I40E_PRTMAC_HLSTA_RXIDLERR_SHIFT     7
#define I40E_PRTMAC_HLSTA_RXIDLERR_MASK      I40E_MASK(0x1, I40E_PRTMAC_HLSTA_RXIDLERR_SHIFT)
#define I40E_PRTMAC_HLSTA_LEGACY_RSVD1_SHIFT 8
#define I40E_PRTMAC_HLSTA_LEGACY_RSVD1_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLSTA_LEGACY_RSVD1_SHIFT)
#define I40E_PRTMAC_HLSTA_LEGACY_RSVD2_SHIFT 9
#define I40E_PRTMAC_HLSTA_LEGACY_RSVD2_MASK  I40E_MASK(0x1, I40E_PRTMAC_HLSTA_LEGACY_RSVD2_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_INTERNAL                             0x001E3530 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_RX_SWZL_SHIFT          0
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_RX_SWZL_MASK           I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_RX_SWZL_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_TX_SWZL_SHIFT          1
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_TX_SWZL_MASK           I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_TX_SWZL_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_CTL_RX_CHECK_ACK_SHIFT 2
#define I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_CTL_RX_CHECK_ACK_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_INTERNAL_HSEC_CTL_RX_CHECK_ACK_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GCP                                   0x001E3160 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GCP_HSEC_CTL_RX_CHECK_ETYPE_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GCP_HSEC_CTL_RX_CHECK_ETYPE_GCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GCP_HSEC_CTL_RX_CHECK_ETYPE_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GPP                                   0x001E32A0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GPP_HSEC_CTL_RX_CHECK_ETYPE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GPP_HSEC_CTL_RX_CHECK_ETYPE_GPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_GPP_HSEC_CTL_RX_CHECK_ETYPE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PCP                                   0x001E3210 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PCP_HSEC_CTL_RX_CHECK_ETYPE_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PCP_HSEC_CTL_RX_CHECK_ETYPE_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PCP_HSEC_CTL_RX_CHECK_ETYPE_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PPP                                   0x001E3320 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PPP_HSEC_CTL_RX_CHECK_ETYPE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PPP_HSEC_CTL_RX_CHECK_ETYPE_PPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_ETYPE_PPP_HSEC_CTL_RX_CHECK_ETYPE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GCP                                   0x001E30F0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GCP_HSEC_CTL_RX_CHECK_MCAST_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GCP_HSEC_CTL_RX_CHECK_MCAST_GCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GCP_HSEC_CTL_RX_CHECK_MCAST_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GPP                                   0x001E3270 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GPP_HSEC_CTL_RX_CHECK_MCAST_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GPP_HSEC_CTL_RX_CHECK_MCAST_GPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_GPP_HSEC_CTL_RX_CHECK_MCAST_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PCP                                   0x001E31C0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PCP_HSEC_CTL_RX_CHECK_MCAST_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PCP_HSEC_CTL_RX_CHECK_MCAST_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PCP_HSEC_CTL_RX_CHECK_MCAST_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PPP                                   0x001E32F0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PPP_HSEC_CTL_RX_CHECK_MCAST_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PPP_HSEC_CTL_RX_CHECK_MCAST_PPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_MCAST_PPP_HSEC_CTL_RX_CHECK_MCAST_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GCP                                    0x001E3170 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GCP_HSEC_CTL_RX_CHECK_OPCODE_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GCP_HSEC_CTL_RX_CHECK_OPCODE_GCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GCP_HSEC_CTL_RX_CHECK_OPCODE_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GPP                                    0x001E32C0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GPP_HSEC_CTL_RX_CHECK_OPCODE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GPP_HSEC_CTL_RX_CHECK_OPCODE_GPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_GPP_HSEC_CTL_RX_CHECK_OPCODE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PCP                                    0x001E3230 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PCP_HSEC_CTL_RX_CHECK_OPCODE_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PCP_HSEC_CTL_RX_CHECK_OPCODE_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PCP_HSEC_CTL_RX_CHECK_OPCODE_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PPP                                    0x001E3340 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PPP_HSEC_CTL_RX_CHECK_OPCODE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PPP_HSEC_CTL_RX_CHECK_OPCODE_PPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_OPCODE_PPP_HSEC_CTL_RX_CHECK_OPCODE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GCP                                0x001E3130 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GCP_HSEC_CTL_RX_CHECK_SA_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GCP_HSEC_CTL_RX_CHECK_SA_GCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GCP_HSEC_CTL_RX_CHECK_SA_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GPP                                0x001E3290 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GPP_HSEC_CTL_RX_CHECK_SA_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GPP_HSEC_CTL_RX_CHECK_SA_GPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_GPP_HSEC_CTL_RX_CHECK_SA_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PCP                                0x001E3200 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PCP_HSEC_CTL_RX_CHECK_SA_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PCP_HSEC_CTL_RX_CHECK_SA_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PCP_HSEC_CTL_RX_CHECK_SA_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PPP                                0x001E3310 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PPP_HSEC_CTL_RX_CHECK_SA_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PPP_HSEC_CTL_RX_CHECK_SA_PPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_SA_PPP_HSEC_CTL_RX_CHECK_SA_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GCP                                   0x001E3100 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GCP_HSEC_CTL_RX_CHECK_UCAST_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GCP_HSEC_CTL_RX_CHECK_UCAST_GCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GCP_HSEC_CTL_RX_CHECK_UCAST_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GPP                                   0x001E3280 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GPP_HSEC_CTL_RX_CHECK_UCAST_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GPP_HSEC_CTL_RX_CHECK_UCAST_GPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_GPP_HSEC_CTL_RX_CHECK_UCAST_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PCP                                   0x001E31D0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PCP_HSEC_CTL_RX_CHECK_UCAST_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PCP_HSEC_CTL_RX_CHECK_UCAST_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PCP_HSEC_CTL_RX_CHECK_UCAST_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PPP                                   0x001E3300 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PPP_HSEC_CTL_RX_CHECK_UCAST_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PPP_HSEC_CTL_RX_CHECK_UCAST_PPP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_CHECK_UCAST_PPP_HSEC_CTL_RX_CHECK_UCAST_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_DELETE_FCS                              0x001E3080 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_DELETE_FCS_HSEC_CTL_RX_DELETE_FCS_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_DELETE_FCS_HSEC_CTL_RX_DELETE_FCS_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_DELETE_FCS_HSEC_CTL_RX_DELETE_FCS_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE                          0x001E3070 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE_HSEC_CTL_RX_ENABLE_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE_HSEC_CTL_RX_ENABLE_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_ENABLE_HSEC_CTL_RX_ENABLE_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE_PCP                              0x001E31B0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE_PCP_HSEC_CTL_RX_ENABLE_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ENABLE_PCP_HSEC_CTL_RX_ENABLE_PCP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_ENABLE_PCP_HSEC_CTL_RX_ENABLE_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GCP                             0x001E31A0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GCP_HSEC_CTL_RX_ETYPE_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GCP_HSEC_CTL_RX_ETYPE_GCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GCP_HSEC_CTL_RX_ETYPE_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GPP                             0x001E32B0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GPP_HSEC_CTL_RX_ETYPE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GPP_HSEC_CTL_RX_ETYPE_GPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_ETYPE_GPP_HSEC_CTL_RX_ETYPE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PCP                             0x001E3220 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PCP_HSEC_CTL_RX_ETYPE_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PCP_HSEC_CTL_RX_ETYPE_PCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PCP_HSEC_CTL_RX_ETYPE_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PPP                             0x001E3330 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PPP_HSEC_CTL_RX_ETYPE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PPP_HSEC_CTL_RX_ETYPE_PPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_ETYPE_PPP_HSEC_CTL_RX_ETYPE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_IGNORE_FCS                              0x001E3090 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_IGNORE_FCS_HSEC_CTL_RX_IGNORE_FCS_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_IGNORE_FCS_HSEC_CTL_RX_IGNORE_FCS_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_RX_IGNORE_FCS_HSEC_CTL_RX_IGNORE_FCS_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_MAX_PACKET_LEN                                  0x001E30A0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_MAX_PACKET_LEN_HSEC_CTL_RX_MAX_PACKET_LEN_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_MAX_PACKET_LEN_HSEC_CTL_RX_MAX_PACKET_LEN_MASK  I40E_MASK(0x7FFF, I40E_PRTMAC_HSEC_CTL_RX_MAX_PACKET_LEN_HSEC_CTL_RX_MAX_PACKET_LEN_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_MIN_PACKET_LEN                                  0x001E30B0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_MIN_PACKET_LEN_HSEC_CTL_RX_MIN_PACKET_LEN_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_MIN_PACKET_LEN_HSEC_CTL_RX_MIN_PACKET_LEN_MASK  I40E_MASK(0xFF, I40E_PRTMAC_HSEC_CTL_RX_MIN_PACKET_LEN_HSEC_CTL_RX_MIN_PACKET_LEN_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_GPP                              0x001E32D0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_GPP_HSEC_CTL_RX_OPCODE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_GPP_HSEC_CTL_RX_OPCODE_GPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_GPP_HSEC_CTL_RX_OPCODE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_GCP                                  0x001E3190 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_GCP_HSEC_CTL_RX_OPCODE_MAX_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_GCP_HSEC_CTL_RX_OPCODE_MAX_GCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_GCP_HSEC_CTL_RX_OPCODE_MAX_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_PCP                                  0x001E3250 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_PCP_HSEC_CTL_RX_OPCODE_MAX_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_PCP_HSEC_CTL_RX_OPCODE_MAX_PCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MAX_PCP_HSEC_CTL_RX_OPCODE_MAX_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_GCP                                  0x001E3180 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_GCP_HSEC_CTL_RX_OPCODE_MIN_GCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_GCP_HSEC_CTL_RX_OPCODE_MIN_GCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_GCP_HSEC_CTL_RX_OPCODE_MIN_GCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_PCP                                  0x001E3240 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_PCP_HSEC_CTL_RX_OPCODE_MIN_PCP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_PCP_HSEC_CTL_RX_OPCODE_MIN_PCP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_MIN_PCP_HSEC_CTL_RX_OPCODE_MIN_PCP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_PPP                              0x001E3350 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_PPP_HSEC_CTL_RX_OPCODE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_OPCODE_PPP_HSEC_CTL_RX_OPCODE_PPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_OPCODE_PPP_HSEC_CTL_RX_OPCODE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1                                        0x001E31E0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_HSEC_CTL_RX_PAUSE_DA_MCAST_PART1_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2                                        0x001E31F0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_HSEC_CTL_RX_PAUSE_DA_MCAST_PART2_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART1                                0x001E3490 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART1_HSEC_CTL_TX_DA_GPP_PART1_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART1_HSEC_CTL_TX_DA_GPP_PART1_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART1_HSEC_CTL_TX_DA_GPP_PART1_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART2                                0x001E34A0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART2_HSEC_CTL_TX_DA_GPP_PART2_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART2_HSEC_CTL_TX_DA_GPP_PART2_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_DA_GPP_PART2_HSEC_CTL_TX_DA_GPP_PART2_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART1                                0x001E34F0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART1_HSEC_CTL_TX_DA_PPP_PART1_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART1_HSEC_CTL_TX_DA_PPP_PART1_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART1_HSEC_CTL_TX_DA_PPP_PART1_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART2                                0x001E3500 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART2_HSEC_CTL_TX_DA_PPP_PART2_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART2_HSEC_CTL_TX_DA_PPP_PART2_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_DA_PPP_PART2_HSEC_CTL_TX_DA_PPP_PART2_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_ENABLE                          0x001E3000 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_ENABLE_HSEC_CTL_TX_ENABLE_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_ENABLE_HSEC_CTL_TX_ENABLE_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_ENABLE_HSEC_CTL_TX_ENABLE_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_ERR_PKT_MODE                                0x001E3060 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_ERR_PKT_MODE_HSEC_CTL_TX_ERR_PKT_MODE_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_ERR_PKT_MODE_HSEC_CTL_TX_ERR_PKT_MODE_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_ERR_PKT_MODE_HSEC_CTL_TX_ERR_PKT_MODE_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_GPP                                 0x001E34D0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_GPP_HSEC_CTL_TX_ETHERTYPE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_GPP_HSEC_CTL_TX_ETHERTYPE_GPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_GPP_HSEC_CTL_TX_ETHERTYPE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_PPP                                 0x001E3510 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_PPP_HSEC_CTL_TX_ETHERTYPE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_PPP_HSEC_CTL_TX_ETHERTYPE_PPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_ETHERTYPE_PPP_HSEC_CTL_TX_ETHERTYPE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_FCS_INS_ENABLE                     0x001E3020 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_FCS_INS_ENABLE_TX_FCS_INS_EN_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_FCS_INS_ENABLE_TX_FCS_INS_EN_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_FCS_INS_ENABLE_TX_FCS_INS_EN_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_FCS_STOMP                             0x001E3030 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_FCS_STOMP_HSEC_CTL_TX_FCS_STOMP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_FCS_STOMP_HSEC_CTL_TX_FCS_STOMP_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_FCS_STOMP_HSEC_CTL_TX_FCS_STOMP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_IGNORE_FCS                              0x001E3040 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_IGNORE_FCS_HSEC_CTL_TX_IGNORE_FCS_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_IGNORE_FCS_HSEC_CTL_TX_IGNORE_FCS_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_IGNORE_FCS_HSEC_CTL_TX_IGNORE_FCS_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_GPP                              0x001E34E0 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_GPP_HSEC_CTL_TX_OPCODE_GPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_GPP_HSEC_CTL_TX_OPCODE_GPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_OPCODE_GPP_HSEC_CTL_TX_OPCODE_GPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_PPP                              0x001E3520 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_PPP_HSEC_CTL_TX_OPCODE_PPP_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_OPCODE_PPP_HSEC_CTL_TX_OPCODE_PPP_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_HSEC_CTL_TX_OPCODE_PPP_HSEC_CTL_TX_OPCODE_PPP_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_RDYOUT_THRESH                                 0x001E3010 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_RDYOUT_THRESH_HSEC_CTL_TX_RDYOUT_THRESH_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_RDYOUT_THRESH_HSEC_CTL_TX_RDYOUT_THRESH_MASK  I40E_MASK(0xF, I40E_PRTMAC_HSEC_CTL_TX_RDYOUT_THRESH_HSEC_CTL_TX_RDYOUT_THRESH_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_TX_TO_RX_LOOPBACK                                  0x001E3050 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_TX_TO_RX_LOOPBACK_HSEC_CTL_TX_TO_RX_LOOPBACK_SHIFT 0
#define I40E_PRTMAC_HSEC_CTL_TX_TO_RX_LOOPBACK_HSEC_CTL_TX_TO_RX_LOOPBACK_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_TX_TO_RX_LOOPBACK_HSEC_CTL_TX_TO_RX_LOOPBACK_SHIFT)

#define I40E_PRTMAC_HSEC_CTL_XLGMII                   0x001E3550 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LB_PHY_SHIFT      0
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LB_PHY_MASK       I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_LB_PHY_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_HI_TH_SHIFT       1
#define I40E_PRTMAC_HSEC_CTL_XLGMII_HI_TH_MASK        I40E_MASK(0xF, I40E_PRTMAC_HSEC_CTL_XLGMII_HI_TH_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LO_TH_SHIFT       5
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LO_TH_MASK        I40E_MASK(0xF, I40E_PRTMAC_HSEC_CTL_XLGMII_LO_TH_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_CTL_SHIFT  9
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_CTL_MASK   I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_CTL_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_DAT_SHIFT  10
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_DAT_MASK   I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWP_DAT_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWZL_DAT_SHIFT 11
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWZL_DAT_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_RX_SWZL_DAT_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_CTL_SHIFT  12
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_CTL_MASK   I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_CTL_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_DAT_SHIFT  13
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_DAT_MASK   I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWP_DAT_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWZL_DAT_SHIFT 14
#define I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWZL_DAT_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_TX_SWZL_DAT_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_BYP_INP_SHIFT  15
#define I40E_PRTMAC_HSEC_CTL_XLGMII_RX_BYP_INP_MASK   I40E_MASK(0x3, I40E_PRTMAC_HSEC_CTL_XLGMII_RX_BYP_INP_SHIFT)
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LB2TX_SHIFT       17
#define I40E_PRTMAC_HSEC_CTL_XLGMII_LB2TX_MASK        I40E_MASK(0x1, I40E_PRTMAC_HSEC_CTL_XLGMII_LB2TX_SHIFT)

#define I40E_PRTMAC_HSEC_SINGLE_40G_PORT_SELECT                                  0x001E3540 /* Reset: GLOBR */
#define I40E_PRTMAC_HSEC_SINGLE_40G_PORT_SELECT_MAC_SINGLE_40G_PORT_SELECT_SHIFT 0
#define I40E_PRTMAC_HSEC_SINGLE_40G_PORT_SELECT_MAC_SINGLE_40G_PORT_SELECT_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSEC_SINGLE_40G_PORT_SELECT_MAC_SINGLE_40G_PORT_SELECT_SHIFT)

#define I40E_PRTMAC_HSECTL1                         0x001E3560 /* Reset: GLOBR */
#define I40E_PRTMAC_HSECTL1_DROP_US_PKTS_SHIFT      0
#define I40E_PRTMAC_HSECTL1_DROP_US_PKTS_MASK       I40E_MASK(0x1, I40E_PRTMAC_HSECTL1_DROP_US_PKTS_SHIFT)
#define I40E_PRTMAC_HSECTL1_PAD_US_PKT_SHIFT        3
#define I40E_PRTMAC_HSECTL1_PAD_US_PKT_MASK         I40E_MASK(0x1, I40E_PRTMAC_HSECTL1_PAD_US_PKT_SHIFT)
#define I40E_PRTMAC_HSECTL1_TX_HYSTERESIS_SHIFT     4
#define I40E_PRTMAC_HSECTL1_TX_HYSTERESIS_MASK      I40E_MASK(0x7, I40E_PRTMAC_HSECTL1_TX_HYSTERESIS_SHIFT)
#define I40E_PRTMAC_HSECTL1_HYS_FLUSH_PKT_SHIFT     7
#define I40E_PRTMAC_HSECTL1_HYS_FLUSH_PKT_MASK      I40E_MASK(0x1, I40E_PRTMAC_HSECTL1_HYS_FLUSH_PKT_SHIFT)
#define I40E_PRTMAC_HSECTL1_EN_SFD_CHECK_SHIFT      30
#define I40E_PRTMAC_HSECTL1_EN_SFD_CHECK_MASK       I40E_MASK(0x1, I40E_PRTMAC_HSECTL1_EN_SFD_CHECK_SHIFT)
#define I40E_PRTMAC_HSECTL1_EN_PREAMBLE_CHECK_SHIFT 31
#define I40E_PRTMAC_HSECTL1_EN_PREAMBLE_CHECK_MASK  I40E_MASK(0x1, I40E_PRTMAC_HSECTL1_EN_PREAMBLE_CHECK_SHIFT)

#define I40E_PRTMAC_LINKSTA                              0x001E2420 /* Reset: GLOBR */
#define I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_EMPTY_SHIFT 0
#define I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_EMPTY_MASK  I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_EMPTY_SHIFT)
#define I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_FULL_SHIFT  1
#define I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_FULL_MASK   I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_FIFO_MTAR_STS_RX_FULL_SHIFT)
#define I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_RF_SHIFT   2
#define I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_RF_MASK    I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_RF_SHIFT)
#define I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_LF_SHIFT   3
#define I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_LF_MASK    I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_MAC_RX_LINK_FAULT_LF_SHIFT)
#define I40E_PRTMAC_LINKSTA_MAC_LINK_UP_PREV_SHIFT       7
#define I40E_PRTMAC_LINKSTA_MAC_LINK_UP_PREV_MASK        I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_MAC_LINK_UP_PREV_SHIFT)
#define I40E_PRTMAC_LINKSTA_MAC_LINK_SPEED_SHIFT         27
#define I40E_PRTMAC_LINKSTA_MAC_LINK_SPEED_MASK          I40E_MASK(0x7, I40E_PRTMAC_LINKSTA_MAC_LINK_SPEED_SHIFT)
#define I40E_PRTMAC_LINKSTA_MAC_LINK_UP_SHIFT            30
#define I40E_PRTMAC_LINKSTA_MAC_LINK_UP_MASK             I40E_MASK(0x1, I40E_PRTMAC_LINKSTA_MAC_LINK_UP_SHIFT)

#define I40E_PRTMAC_MACC                         0x001E24E0 /* Reset: GLOBR */
#define I40E_PRTMAC_MACC_FORCE_LINK_SHIFT        0
#define I40E_PRTMAC_MACC_FORCE_LINK_MASK         I40E_MASK(0x1, I40E_PRTMAC_MACC_FORCE_LINK_SHIFT)
#define I40E_PRTMAC_MACC_PHY_LOOP_BACK_SHIFT     1
#define I40E_PRTMAC_MACC_PHY_LOOP_BACK_MASK      I40E_MASK(0x1, I40E_PRTMAC_MACC_PHY_LOOP_BACK_SHIFT)
#define I40E_PRTMAC_MACC_TX_SWIZZLE_DATA_SHIFT   2
#define I40E_PRTMAC_MACC_TX_SWIZZLE_DATA_MASK    I40E_MASK(0x1, I40E_PRTMAC_MACC_TX_SWIZZLE_DATA_SHIFT)
#define I40E_PRTMAC_MACC_TX_SWAP_DATA_SHIFT      3
#define I40E_PRTMAC_MACC_TX_SWAP_DATA_MASK       I40E_MASK(0x1, I40E_PRTMAC_MACC_TX_SWAP_DATA_SHIFT)
#define I40E_PRTMAC_MACC_TX_SWAP_CTRL_SHIFT      4
#define I40E_PRTMAC_MACC_TX_SWAP_CTRL_MASK       I40E_MASK(0x1, I40E_PRTMAC_MACC_TX_SWAP_CTRL_SHIFT)
#define I40E_PRTMAC_MACC_RX_SWIZZLE_DATA_SHIFT   5
#define I40E_PRTMAC_MACC_RX_SWIZZLE_DATA_MASK    I40E_MASK(0x1, I40E_PRTMAC_MACC_RX_SWIZZLE_DATA_SHIFT)
#define I40E_PRTMAC_MACC_RX_SWAP_DATA_SHIFT      6
#define I40E_PRTMAC_MACC_RX_SWAP_DATA_MASK       I40E_MASK(0x1, I40E_PRTMAC_MACC_RX_SWAP_DATA_SHIFT)
#define I40E_PRTMAC_MACC_RX_SWAP_CTRL_SHIFT      7
#define I40E_PRTMAC_MACC_RX_SWAP_CTRL_MASK       I40E_MASK(0x1, I40E_PRTMAC_MACC_RX_SWAP_CTRL_SHIFT)
#define I40E_PRTMAC_MACC_FIFO_THRSHLD_HI_SHIFT   8
#define I40E_PRTMAC_MACC_FIFO_THRSHLD_HI_MASK    I40E_MASK(0xF, I40E_PRTMAC_MACC_FIFO_THRSHLD_HI_SHIFT)
#define I40E_PRTMAC_MACC_FIFO_THRSHLD_LO_SHIFT   12
#define I40E_PRTMAC_MACC_FIFO_THRSHLD_LO_MASK    I40E_MASK(0xF, I40E_PRTMAC_MACC_FIFO_THRSHLD_LO_SHIFT)
#define I40E_PRTMAC_MACC_LEGACY_RSRVD_SHIFT      16
#define I40E_PRTMAC_MACC_LEGACY_RSRVD_MASK       I40E_MASK(0x7, I40E_PRTMAC_MACC_LEGACY_RSRVD_SHIFT)
#define I40E_PRTMAC_MACC_MASK_FAULT_STATE_SHIFT  19
#define I40E_PRTMAC_MACC_MASK_FAULT_STATE_MASK   I40E_MASK(0x1, I40E_PRTMAC_MACC_MASK_FAULT_STATE_SHIFT)
#define I40E_PRTMAC_MACC_MASK_XGMII_IF_SHIFT     20
#define I40E_PRTMAC_MACC_MASK_XGMII_IF_MASK      I40E_MASK(0x3, I40E_PRTMAC_MACC_MASK_XGMII_IF_SHIFT)
#define I40E_PRTMAC_MACC_MASK_LINK_SHIFT         22
#define I40E_PRTMAC_MACC_MASK_LINK_MASK          I40E_MASK(0x1, I40E_PRTMAC_MACC_MASK_LINK_SHIFT)
#define I40E_PRTMAC_MACC_FORCE_SPEED_VALUE_SHIFT 23
#define I40E_PRTMAC_MACC_FORCE_SPEED_VALUE_MASK  I40E_MASK(0x7, I40E_PRTMAC_MACC_FORCE_SPEED_VALUE_SHIFT)
#define I40E_PRTMAC_MACC_FORCE_SPEED_EN_SHIFT    26
#define I40E_PRTMAC_MACC_FORCE_SPEED_EN_MASK     I40E_MASK(0x1, I40E_PRTMAC_MACC_FORCE_SPEED_EN_SHIFT)

#define I40E_PRTMAC_PAP                  0x001E2040 /* Reset: GLOBR */
#define I40E_PRTMAC_PAP_TXPAUSECNT_SHIFT 0
#define I40E_PRTMAC_PAP_TXPAUSECNT_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_PAP_TXPAUSECNT_SHIFT)
#define I40E_PRTMAC_PAP_PACE_SHIFT       16
#define I40E_PRTMAC_PAP_PACE_MASK        I40E_MASK(0xF, I40E_PRTMAC_PAP_PACE_SHIFT)

#define I40E_PRTMAC_PCS_AN_CONTROL1              0x0008C600 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANACK2_SHIFT 1
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANACK2_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_ANACK2_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANSF_SHIFT   2
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANSF_MASK    I40E_MASK(0x1F, I40E_PRTMAC_PCS_AN_CONTROL1_ANSF_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_D10GMP_SHIFT 10
#define I40E_PRTMAC_PCS_AN_CONTROL1_D10GMP_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_D10GMP_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_RATD_SHIFT   11
#define I40E_PRTMAC_PCS_AN_CONTROL1_RATD_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_RATD_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXAT_SHIFT 19
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXAT_MASK  I40E_MASK(0xF, I40E_PRTMAC_PCS_AN_CONTROL1_ANRXAT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXDM_SHIFT 23
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXDM_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_ANRXDM_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXLM_SHIFT 24
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANRXLM_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_ANRXLM_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANPDT_SHIFT  25
#define I40E_PRTMAC_PCS_AN_CONTROL1_ANPDT_MASK   I40E_MASK(0x3, I40E_PRTMAC_PCS_AN_CONTROL1_ANPDT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_RF_SHIFT     27
#define I40E_PRTMAC_PCS_AN_CONTROL1_RF_MASK      I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL1_RF_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL1_PB_SHIFT     28
#define I40E_PRTMAC_PCS_AN_CONTROL1_PB_MASK      I40E_MASK(0x3, I40E_PRTMAC_PCS_AN_CONTROL1_PB_SHIFT)

#define I40E_PRTMAC_PCS_AN_CONTROL2                          0x0008C620 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_AN_CONTROL2_AN_PAGE_D_LOW_OVRD_SHIFT 0
#define I40E_PRTMAC_PCS_AN_CONTROL2_AN_PAGE_D_LOW_OVRD_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_PCS_AN_CONTROL2_AN_PAGE_D_LOW_OVRD_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_RSVD_SHIFT               16
#define I40E_PRTMAC_PCS_AN_CONTROL2_RSVD_MASK                I40E_MASK(0x3, I40E_PRTMAC_PCS_AN_CONTROL2_RSVD_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_DDPT_SHIFT               18
#define I40E_PRTMAC_PCS_AN_CONTROL2_DDPT_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_DDPT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_AAPLL_SHIFT              19
#define I40E_PRTMAC_PCS_AN_CONTROL2_AAPLL_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_AAPLL_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_ANAPO_SHIFT              20
#define I40E_PRTMAC_PCS_AN_CONTROL2_ANAPO_MASK               I40E_MASK(0x3, I40E_PRTMAC_PCS_AN_CONTROL2_ANAPO_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_LH1GSI_SHIFT             22
#define I40E_PRTMAC_PCS_AN_CONTROL2_LH1GSI_MASK              I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_LH1GSI_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_LH1GAI_SHIFT             23
#define I40E_PRTMAC_PCS_AN_CONTROL2_LH1GAI_MASK              I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_LH1GAI_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_FANAS_SHIFT              24
#define I40E_PRTMAC_PCS_AN_CONTROL2_FANAS_MASK               I40E_MASK(0xF, I40E_PRTMAC_PCS_AN_CONTROL2_FANAS_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_FASM_SHIFT               28
#define I40E_PRTMAC_PCS_AN_CONTROL2_FASM_MASK                I40E_MASK(0x3, I40E_PRTMAC_PCS_AN_CONTROL2_FASM_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_PDD_SHIFT                30
#define I40E_PRTMAC_PCS_AN_CONTROL2_PDD_MASK                 I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_PDD_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL2_FEC_FORCE_SHIFT          31
#define I40E_PRTMAC_PCS_AN_CONTROL2_FEC_FORCE_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL2_FEC_FORCE_SHIFT)

#define I40E_PRTMAC_PCS_AN_CONTROL4                                 0x0008C660 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED0_SHIFT                 0
#define I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED0_MASK                  I40E_MASK(0x1FFF, I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED0_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_VALUE_SHIFT     13
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_VALUE_MASK      I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_VALUE_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_RESULT_SHIFT    14
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_RESULT_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KR_EEE_AN_RESULT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_VALUE_SHIFT    15
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_VALUE_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_VALUE_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_RESULT_SHIFT   16
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_RESULT_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX4_EEE_AN_RESULT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_VALUE_SHIFT     17
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_VALUE_MASK      I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_VALUE_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_RESULT_SHIFT    18
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_RESULT_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_KX_EEE_AN_RESULT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_VALUE_SHIFT  19
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_VALUE_MASK   I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_VALUE_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_RESULT_SHIFT 20
#define I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_RESULT_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_AN_CONTROL4_FORCE_SGMII_EEE_AN_RESULT_SHIFT)
#define I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED1_SHIFT                 21
#define I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED1_MASK                  I40E_MASK(0x7FF, I40E_PRTMAC_PCS_AN_CONTROL4_RESERVED1_SHIFT)

#define I40E_PRTMAC_PCS_LINK_CTRL                                0x0008C260 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_40G_R_TYPE_SELECTION_SHIFT 0
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_40G_R_TYPE_SELECTION_MASK  I40E_MASK(0x3, I40E_PRTMAC_PCS_LINK_CTRL_PMD_40G_R_TYPE_SELECTION_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_R_TYPE_SELECTION_SHIFT 2
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_R_TYPE_SELECTION_MASK  I40E_MASK(0x3, I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_R_TYPE_SELECTION_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_X_TYPE_SELECTION_SHIFT 4
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_X_TYPE_SELECTION_MASK  I40E_MASK(0x3, I40E_PRTMAC_PCS_LINK_CTRL_PMD_10G_X_TYPE_SELECTION_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION0_SHIFT 6
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION0_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION0_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_SPEED_SELECTION_SHIFT          8
#define I40E_PRTMAC_PCS_LINK_CTRL_SPEED_SELECTION_MASK           I40E_MASK(0x7, I40E_PRTMAC_PCS_LINK_CTRL_SPEED_SELECTION_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION1_SHIFT 12
#define I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION1_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_PMD_1G_X_TYPE_SELECTION1_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_AN_CLAUSE_37_ENABLE_SHIFT      13
#define I40E_PRTMAC_PCS_LINK_CTRL_AN_CLAUSE_37_ENABLE_MASK       I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_AN_CLAUSE_37_ENABLE_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_FEC_CAPABILITY_SHIFT           14
#define I40E_PRTMAC_PCS_LINK_CTRL_FEC_CAPABILITY_MASK            I40E_MASK(0x3, I40E_PRTMAC_PCS_LINK_CTRL_FEC_CAPABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KX_ABILITY_SHIFT               16
#define I40E_PRTMAC_PCS_LINK_CTRL_KX_ABILITY_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KX_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KX4_ABILITY_SHIFT              17
#define I40E_PRTMAC_PCS_LINK_CTRL_KX4_ABILITY_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KX4_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KR_ABILITY_SHIFT               18
#define I40E_PRTMAC_PCS_LINK_CTRL_KR_ABILITY_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KR_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KR4_ABILITY_SHIFT              19
#define I40E_PRTMAC_PCS_LINK_CTRL_KR4_ABILITY_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KR4_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_CR4_ABILITY_SHIFT              20
#define I40E_PRTMAC_PCS_LINK_CTRL_CR4_ABILITY_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_CR4_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KR2_ABILITY_SHIFT              21
#define I40E_PRTMAC_PCS_LINK_CTRL_KR2_ABILITY_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KR2_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_POWER_DOWN_SHIFT               23
#define I40E_PRTMAC_PCS_LINK_CTRL_POWER_DOWN_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_POWER_DOWN_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KX_EEE_ABILITY_SHIFT           24
#define I40E_PRTMAC_PCS_LINK_CTRL_KX_EEE_ABILITY_MASK            I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KX_EEE_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KX4_EEE_ABILITY_SHIFT          25
#define I40E_PRTMAC_PCS_LINK_CTRL_KX4_EEE_ABILITY_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KX4_EEE_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_KR_EEE_ABILITY_SHIFT           26
#define I40E_PRTMAC_PCS_LINK_CTRL_KR_EEE_ABILITY_MASK            I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_KR_EEE_ABILITY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_AUTO_NEG_ENABLE_SHIFT          29
#define I40E_PRTMAC_PCS_LINK_CTRL_AUTO_NEG_ENABLE_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_AUTO_NEG_ENABLE_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_FORCE_LINK_UP_SHIFT            30
#define I40E_PRTMAC_PCS_LINK_CTRL_FORCE_LINK_UP_MASK             I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_FORCE_LINK_UP_SHIFT)
#define I40E_PRTMAC_PCS_LINK_CTRL_RESTART_AUTO_NEG_SHIFT         31
#define I40E_PRTMAC_PCS_LINK_CTRL_RESTART_AUTO_NEG_MASK          I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_CTRL_RESTART_AUTO_NEG_SHIFT)

#define I40E_PRTMAC_PCS_LINK_STATUS1                                 0x0008C200 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_1G_MODE_SHIFT   5
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_1G_MODE_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_1G_MODE_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_0_SHIFT    6
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_0_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_0_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_1_SHIFT    7
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_1_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_1_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_2_SHIFT    8
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_2_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_2_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_3_SHIFT    9
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_3_MASK     I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_LANE_3_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_COMBINED_SHIFT  10
#define I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_COMBINED_MASK   I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SIGNAL_DETECTED_COMBINED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE0_SHIFT               11
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE0_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE0_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE1_SHIFT               12
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE1_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE1_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE2_SHIFT               13
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE2_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE2_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE3_SHIFT               14
#define I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE3_MASK                I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_SYNCH_LANE3_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_AN_SHIFT       15
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_AN_MASK        I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_AN_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_SHIFT          16
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1000_BASE_X_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_X4_PARALLEL_SHIFT 17
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_X4_PARALLEL_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_X4_PARALLEL_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_FEC_10G_ENABLED_SHIFT           18
#define I40E_PRTMAC_PCS_LINK_STATUS1_FEC_10G_ENABLED_MASK            I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_FEC_10G_ENABLED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_40G_BASE_R4_SHIFT          19
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_40G_BASE_R4_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_40G_BASE_R4_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_R1_SHIFT          20
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_R1_MASK           I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_10G_BASE_R1_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1G_SGMII_SHIFT             21
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1G_SGMII_MASK              I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_1G_SGMII_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_MODE_SHIFT                 22
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_MODE_MASK                  I40E_MASK(0x3, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_MODE_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_SPEED_SHIFT                24
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_SPEED_MASK                 I40E_MASK(0x7, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_SPEED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_UP_SHIFT                   27
#define I40E_PRTMAC_PCS_LINK_STATUS1_LINK_UP_MASK                    I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_LINK_UP_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_AN_COMPLETED_SHIFT              28
#define I40E_PRTMAC_PCS_LINK_STATUS1_AN_COMPLETED_MASK               I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_AN_COMPLETED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_PCS_READY_SHIFT                 29
#define I40E_PRTMAC_PCS_LINK_STATUS1_PCS_READY_MASK                  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_PCS_READY_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS1_MAC_READY_SHIFT                 30
#define I40E_PRTMAC_PCS_LINK_STATUS1_MAC_READY_MASK                  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS1_MAC_READY_SHIFT)

#define I40E_PRTMAC_PCS_LINK_STATUS2                             0x0008C220 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_LINK_STATUS2_SIGNAL_DETECTED_FEC_SHIFT   1
#define I40E_PRTMAC_PCS_LINK_STATUS2_SIGNAL_DETECTED_FEC_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_SIGNAL_DETECTED_FEC_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_FEC_BLOCK_LOCK_SHIFT        2
#define I40E_PRTMAC_PCS_LINK_STATUS2_FEC_BLOCK_LOCK_MASK         I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_FEC_BLOCK_LOCK_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_KR_HI_BERR_SHIFT            3
#define I40E_PRTMAC_PCS_LINK_STATUS2_KR_HI_BERR_MASK             I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_KR_HI_BERR_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_KR_10G_PCS_LCOK_SHIFT       4
#define I40E_PRTMAC_PCS_LINK_STATUS2_KR_10G_PCS_LCOK_MASK        I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_KR_10G_PCS_LCOK_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_AN_NEXT_PAGE_RECEIVED_SHIFT 5
#define I40E_PRTMAC_PCS_LINK_STATUS2_AN_NEXT_PAGE_RECEIVED_MASK  I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_AN_NEXT_PAGE_RECEIVED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_AN_PAGE_RECEIVED_SHIFT      6
#define I40E_PRTMAC_PCS_LINK_STATUS2_AN_PAGE_RECEIVED_MASK       I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_AN_PAGE_RECEIVED_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_LINK_STATUS_SHIFT           7
#define I40E_PRTMAC_PCS_LINK_STATUS2_LINK_STATUS_MASK            I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_LINK_STATUS_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_10G_SHIFT  17
#define I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_10G_MASK   I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_10G_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_1G_SHIFT   18
#define I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_1G_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_ALIGNMENT_STATUS_1G_SHIFT)
#define I40E_PRTMAC_PCS_LINK_STATUS2_BP_AN_RECEIVER_IDLE_SHIFT   19
#define I40E_PRTMAC_PCS_LINK_STATUS2_BP_AN_RECEIVER_IDLE_MASK    I40E_MASK(0x1, I40E_PRTMAC_PCS_LINK_STATUS2_BP_AN_RECEIVER_IDLE_SHIFT)

#define I40E_PRTMAC_PCS_MUX_KR                  0x0008C000 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_MUX_KR_PCS_MUX_KR_SHIFT 0
#define I40E_PRTMAC_PCS_MUX_KR_PCS_MUX_KR_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_PCS_MUX_KR_PCS_MUX_KR_SHIFT)

#define I40E_PRTMAC_PCS_MUX_KX                  0x0008C008 /* Reset: GLOBR */
#define I40E_PRTMAC_PCS_MUX_KX_PCS_MUX_KX_SHIFT 0
#define I40E_PRTMAC_PCS_MUX_KX_PCS_MUX_KX_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_PCS_MUX_KX_PCS_MUX_KX_SHIFT)

#define I40E_PRTMAC_PHY_ANA_ADD               0x000A4038 /* Reset: GLOBR */
#define I40E_PRTMAC_PHY_ANA_ADD_ADDRESS_SHIFT 0
#define I40E_PRTMAC_PHY_ANA_ADD_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_PRTMAC_PHY_ANA_ADD_ADDRESS_SHIFT)
#define I40E_PRTMAC_PHY_ANA_ADD_BYTE_EN_SHIFT 28
#define I40E_PRTMAC_PHY_ANA_ADD_BYTE_EN_MASK  I40E_MASK(0xF, I40E_PRTMAC_PHY_ANA_ADD_BYTE_EN_SHIFT)

#define I40E_PRTMAC_PHY_ANA_DATA            0x000A403c /* Reset: GLOBR */
#define I40E_PRTMAC_PHY_ANA_DATA_DATA_SHIFT 0
#define I40E_PRTMAC_PHY_ANA_DATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_PHY_ANA_DATA_DATA_SHIFT)

#define I40E_PRTMAC_PMD_MUX_KR                  0x0008C004 /* Reset: GLOBR */
#define I40E_PRTMAC_PMD_MUX_KR_PMD_MUX_KR_SHIFT 0
#define I40E_PRTMAC_PMD_MUX_KR_PMD_MUX_KR_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_PMD_MUX_KR_PMD_MUX_KR_SHIFT)

#define I40E_PRTMAC_PMD_MUX_KX                  0x0008C00C /* Reset: GLOBR */
#define I40E_PRTMAC_PMD_MUX_KX_PMD_MUX_KX_SHIFT 0
#define I40E_PRTMAC_PMD_MUX_KX_PMD_MUX_KX_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTMAC_PMD_MUX_KX_PMD_MUX_KX_SHIFT)

#define I40E_PRTMAC_TREG                        0x001E2160 /* Reset: GLOBR */
#define I40E_PRTMAC_TREG_ILGLCODETXERRTST_SHIFT 0
#define I40E_PRTMAC_TREG_ILGLCODETXERRTST_MASK  I40E_MASK(0xFF, I40E_PRTMAC_TREG_ILGLCODETXERRTST_SHIFT)
#define I40E_PRTMAC_TREG_CTRLTXERRTST_SHIFT     8
#define I40E_PRTMAC_TREG_CTRLTXERRTST_MASK      I40E_MASK(0x1, I40E_PRTMAC_TREG_CTRLTXERRTST_SHIFT)
#define I40E_PRTMAC_TREG_TXXGMIITSTMODE_SHIFT   9
#define I40E_PRTMAC_TREG_TXXGMIITSTMODE_MASK    I40E_MASK(0x1, I40E_PRTMAC_TREG_TXXGMIITSTMODE_SHIFT)
#define I40E_PRTMAC_TREG_BUSYIDLCODE_SHIFT      15
#define I40E_PRTMAC_TREG_BUSYIDLCODE_MASK       I40E_MASK(0xFF, I40E_PRTMAC_TREG_BUSYIDLCODE_SHIFT)
#define I40E_PRTMAC_TREG_BUSYIDLEN_SHIFT        23
#define I40E_PRTMAC_TREG_BUSYIDLEN_MASK         I40E_MASK(0x1, I40E_PRTMAC_TREG_BUSYIDLEN_SHIFT)

/* PF - Manageability  Registers  */

#define I40E_EMP_TCO_ISOLATE                       0x00078E80 /* Reset: POR */
#define I40E_EMP_TCO_ISOLATE_EMP_TCO_ISOLATE_SHIFT 0
#define I40E_EMP_TCO_ISOLATE_EMP_TCO_ISOLATE_MASK  I40E_MASK(0xFFFF, I40E_EMP_TCO_ISOLATE_EMP_TCO_ISOLATE_SHIFT)

#define I40E_GL_MNG_FRIACR            0x00083240 /* Reset: EMPR */
#define I40E_GL_MNG_FRIACR_ADDR_SHIFT 0
#define I40E_GL_MNG_FRIACR_ADDR_MASK  I40E_MASK(0x1FFFFF, I40E_GL_MNG_FRIACR_ADDR_SHIFT)
#define I40E_GL_MNG_FRIACR_WR_SHIFT   24
#define I40E_GL_MNG_FRIACR_WR_MASK    I40E_MASK(0x1, I40E_GL_MNG_FRIACR_WR_SHIFT)
#define I40E_GL_MNG_FRIACR_RD_SHIFT   25
#define I40E_GL_MNG_FRIACR_RD_MASK    I40E_MASK(0x1, I40E_GL_MNG_FRIACR_RD_SHIFT)

#define I40E_GL_MNG_FRIARDR             0x00083248 /* Reset: EMPR */
#define I40E_GL_MNG_FRIARDR_RDATA_SHIFT 0
#define I40E_GL_MNG_FRIARDR_RDATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_MNG_FRIARDR_RDATA_SHIFT)

#define I40E_GL_MNG_FRIARR              0x0008324C /* Reset: EMPR */
#define I40E_GL_MNG_FRIARR_HALT_SHIFT   0
#define I40E_GL_MNG_FRIARR_HALT_MASK    I40E_MASK(0x1, I40E_GL_MNG_FRIARR_HALT_SHIFT)
#define I40E_GL_MNG_FRIARR_RST_EN_SHIFT 1
#define I40E_GL_MNG_FRIARR_RST_EN_MASK  I40E_MASK(0x1, I40E_GL_MNG_FRIARR_RST_EN_SHIFT)

#define I40E_GL_MNG_FRIAWDR             0x00083244 /* Reset: EMPR */
#define I40E_GL_MNG_FRIAWDR_WDATA_SHIFT 0
#define I40E_GL_MNG_FRIAWDR_WDATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_MNG_FRIAWDR_WDATA_SHIFT)

#define I40E_GL_MNG_RRDFM                      0x00083040 /* Reset: EMPR */
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_0_SHIFT 0
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_0_MASK  I40E_MASK(0x1, I40E_GL_MNG_RRDFM_RMII_DBG_FIL_0_SHIFT)
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_1_SHIFT 1
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_1_MASK  I40E_MASK(0x1, I40E_GL_MNG_RRDFM_RMII_DBG_FIL_1_SHIFT)
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_2_SHIFT 2
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_2_MASK  I40E_MASK(0x1, I40E_GL_MNG_RRDFM_RMII_DBG_FIL_2_SHIFT)
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_3_SHIFT 3
#define I40E_GL_MNG_RRDFM_RMII_DBG_FIL_3_MASK  I40E_MASK(0x1, I40E_GL_MNG_RRDFM_RMII_DBG_FIL_3_SHIFT)

#define I40E_GL_SWR_PL_THR                  0x00269FDC /* Reset: CORER */
#define I40E_GL_SWR_PL_THR_PIPE_LIMIT_SHIFT 0
#define I40E_GL_SWR_PL_THR_PIPE_LIMIT_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PL_THR_PIPE_LIMIT_SHIFT)

#define I40E_GL_SWR_PM_UP_THR                 0x00269FBC /* Reset: CORER */
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_0_SHIFT 0
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_0_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_UP_THR_UP_PORT_0_SHIFT)
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_1_SHIFT 8
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_1_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_UP_THR_UP_PORT_1_SHIFT)
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_2_SHIFT 16
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_2_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_UP_THR_UP_PORT_2_SHIFT)
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_3_SHIFT 24
#define I40E_GL_SWR_PM_UP_THR_UP_PORT_3_MASK  I40E_MASK(0xFF, I40E_GL_SWR_PM_UP_THR_UP_PORT_3_SHIFT)

#define I40E_PRT_MNG_FTFT_IGNORETAGS                                 0x00085280 /* Reset: POR */
#define I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_0_SHIFT 0
#define I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_0_MASK  I40E_MASK(0x1, I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_0_SHIFT)
#define I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_SHIFT   2
#define I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_MASK    I40E_MASK(0xFF, I40E_PRT_MNG_FTFT_IGNORETAGS_PRT_MNG_FTFT_IGNORETAGS_SHIFT)

/* PF - MSI-X Table Registers  */

/* PF - NVM Registers  */

#define I40E_EMPNVM_FLCNT             0x000B6128 /* Reset: POR */
#define I40E_EMPNVM_FLCNT_RDCNT_SHIFT 0
#define I40E_EMPNVM_FLCNT_RDCNT_MASK  I40E_MASK(0x1FFFFFF, I40E_EMPNVM_FLCNT_RDCNT_SHIFT)
#define I40E_EMPNVM_FLCNT_ABORT_SHIFT 31
#define I40E_EMPNVM_FLCNT_ABORT_MASK  I40E_MASK(0x1, I40E_EMPNVM_FLCNT_ABORT_SHIFT)

#define I40E_EMPNVM_FLCTL              0x000B6120 /* Reset: POR */
#define I40E_EMPNVM_FLCTL_ADDR_SHIFT   0
#define I40E_EMPNVM_FLCTL_ADDR_MASK    I40E_MASK(0xFFFFFF, I40E_EMPNVM_FLCTL_ADDR_SHIFT)
#define I40E_EMPNVM_FLCTL_CMD_SHIFT    24
#define I40E_EMPNVM_FLCTL_CMD_MASK     I40E_MASK(0x3, I40E_EMPNVM_FLCTL_CMD_SHIFT)
#define I40E_EMPNVM_FLCTL_CMDV_SHIFT   26
#define I40E_EMPNVM_FLCTL_CMDV_MASK    I40E_MASK(0x1, I40E_EMPNVM_FLCTL_CMDV_SHIFT)
#define I40E_EMPNVM_FLCTL_FLBUSY_SHIFT 27
#define I40E_EMPNVM_FLCTL_FLBUSY_MASK  I40E_MASK(0x1, I40E_EMPNVM_FLCTL_FLBUSY_SHIFT)
#define I40E_EMPNVM_FLCTL_DONE_SHIFT   30
#define I40E_EMPNVM_FLCTL_DONE_MASK    I40E_MASK(0x1, I40E_EMPNVM_FLCTL_DONE_SHIFT)
#define I40E_EMPNVM_FLCTL_GLDONE_SHIFT 31
#define I40E_EMPNVM_FLCTL_GLDONE_MASK  I40E_MASK(0x1, I40E_EMPNVM_FLCTL_GLDONE_SHIFT)

#define I40E_EMPNVM_FLDATA                 0x000B6124 /* Reset: POR */
#define I40E_EMPNVM_FLDATA_FLMNGDATA_SHIFT 0
#define I40E_EMPNVM_FLDATA_FLMNGDATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMPNVM_FLDATA_FLMNGDATA_SHIFT)

#define I40E_EMPNVM_SRCTL                     0x000B6118 /* Reset: POR */
#define I40E_EMPNVM_SRCTL_ADDR_SHIFT          0
#define I40E_EMPNVM_SRCTL_ADDR_MASK           I40E_MASK(0x7FFF, I40E_EMPNVM_SRCTL_ADDR_SHIFT)
#define I40E_EMPNVM_SRCTL_START_SHIFT         15
#define I40E_EMPNVM_SRCTL_START_MASK          I40E_MASK(0x1, I40E_EMPNVM_SRCTL_START_SHIFT)
#define I40E_EMPNVM_SRCTL_WRITE_SHIFT         16
#define I40E_EMPNVM_SRCTL_WRITE_MASK          I40E_MASK(0x1, I40E_EMPNVM_SRCTL_WRITE_SHIFT)
#define I40E_EMPNVM_SRCTL_SRBUSY_SHIFT        17
#define I40E_EMPNVM_SRCTL_SRBUSY_MASK         I40E_MASK(0x1, I40E_EMPNVM_SRCTL_SRBUSY_SHIFT)
#define I40E_EMPNVM_SRCTL_TRANS_ABORTED_SHIFT 20
#define I40E_EMPNVM_SRCTL_TRANS_ABORTED_MASK  I40E_MASK(0x1, I40E_EMPNVM_SRCTL_TRANS_ABORTED_SHIFT)
#define I40E_EMPNVM_SRCTL_DEFERAL_SHIFT       29
#define I40E_EMPNVM_SRCTL_DEFERAL_MASK        I40E_MASK(0x1, I40E_EMPNVM_SRCTL_DEFERAL_SHIFT)
#define I40E_EMPNVM_SRCTL_SR_LOAD_SHIFT       30
#define I40E_EMPNVM_SRCTL_SR_LOAD_MASK        I40E_MASK(0x1, I40E_EMPNVM_SRCTL_SR_LOAD_SHIFT)
#define I40E_EMPNVM_SRCTL_DONE_SHIFT          31
#define I40E_EMPNVM_SRCTL_DONE_MASK           I40E_MASK(0x1, I40E_EMPNVM_SRCTL_DONE_SHIFT)

#define I40E_EMPNVM_SRDATA              0x000B611C /* Reset: POR */
#define I40E_EMPNVM_SRDATA_WRDATA_SHIFT 0
#define I40E_EMPNVM_SRDATA_WRDATA_MASK  I40E_MASK(0xFFFF, I40E_EMPNVM_SRDATA_WRDATA_SHIFT)
#define I40E_EMPNVM_SRDATA_RDDATA_SHIFT 16
#define I40E_EMPNVM_SRDATA_RDDATA_MASK  I40E_MASK(0xFFFF, I40E_EMPNVM_SRDATA_RDDATA_SHIFT)

#define I40E_GLNVM_ALTIMERS                   0x000B6140 /* Reset: POR */
#define I40E_GLNVM_ALTIMERS_PCI_ALTIMER_SHIFT 0
#define I40E_GLNVM_ALTIMERS_PCI_ALTIMER_MASK  I40E_MASK(0xFFF, I40E_GLNVM_ALTIMERS_PCI_ALTIMER_SHIFT)
#define I40E_GLNVM_ALTIMERS_GEN_ALTIMER_SHIFT 12
#define I40E_GLNVM_ALTIMERS_GEN_ALTIMER_MASK  I40E_MASK(0xFFFFF, I40E_GLNVM_ALTIMERS_GEN_ALTIMER_SHIFT)

#define I40E_GLNVM_EMPLD                       0x000B610C /* Reset: POR */
#define I40E_GLNVM_EMPLD_EMP_CORE_DONE_SHIFT   3
#define I40E_GLNVM_EMPLD_EMP_CORE_DONE_MASK    I40E_MASK(0x1, I40E_GLNVM_EMPLD_EMP_CORE_DONE_SHIFT)
#define I40E_GLNVM_EMPLD_EMP_GLOBAL_DONE_SHIFT 4
#define I40E_GLNVM_EMPLD_EMP_GLOBAL_DONE_MASK  I40E_MASK(0x1, I40E_GLNVM_EMPLD_EMP_GLOBAL_DONE_SHIFT)

#define I40E_GLNVM_EMPRQ                       0x000B613C /* Reset: POR */
#define I40E_GLNVM_EMPRQ_EMP_CORE_REQD_SHIFT   3
#define I40E_GLNVM_EMPRQ_EMP_CORE_REQD_MASK    I40E_MASK(0x1, I40E_GLNVM_EMPRQ_EMP_CORE_REQD_SHIFT)
#define I40E_GLNVM_EMPRQ_EMP_GLOBAL_REQD_SHIFT 4
#define I40E_GLNVM_EMPRQ_EMP_GLOBAL_REQD_MASK  I40E_MASK(0x1, I40E_GLNVM_EMPRQ_EMP_GLOBAL_REQD_SHIFT)

#define I40E_GLNVM_SRLD                        0x000B600C /* Reset: POR */
#define I40E_GLNVM_SRLD_HW_PCIR_DONE_SHIFT     0
#define I40E_GLNVM_SRLD_HW_PCIR_DONE_MASK      I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_PCIR_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_PCIRTL_DONE_SHIFT   1
#define I40E_GLNVM_SRLD_HW_PCIRTL_DONE_MASK    I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_PCIRTL_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_LCB_DONE_SHIFT      2
#define I40E_GLNVM_SRLD_HW_LCB_DONE_MASK       I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_LCB_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_CORE_DONE_SHIFT     3
#define I40E_GLNVM_SRLD_HW_CORE_DONE_MASK      I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_CORE_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_GLOBAL_DONE_SHIFT   4
#define I40E_GLNVM_SRLD_HW_GLOBAL_DONE_MASK    I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_GLOBAL_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_POR_DONE_SHIFT      5
#define I40E_GLNVM_SRLD_HW_POR_DONE_MASK       I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_POR_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_PCIE_ANA_DONE_SHIFT 6
#define I40E_GLNVM_SRLD_HW_PCIE_ANA_DONE_MASK  I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_PCIE_ANA_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_PHY_ANA_DONE_SHIFT  7
#define I40E_GLNVM_SRLD_HW_PHY_ANA_DONE_MASK   I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_PHY_ANA_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_EMP_DONE_SHIFT      8
#define I40E_GLNVM_SRLD_HW_EMP_DONE_MASK       I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_EMP_DONE_SHIFT)
#define I40E_GLNVM_SRLD_HW_PCIALT_DONE_SHIFT   9
#define I40E_GLNVM_SRLD_HW_PCIALT_DONE_MASK    I40E_MASK(0x1, I40E_GLNVM_SRLD_HW_PCIALT_DONE_SHIFT)

#define I40E_GLNVM_ULT                      0x000B6154 /* Reset: POR */
#define I40E_GLNVM_ULT_CONF_PCIR_AE_SHIFT   0
#define I40E_GLNVM_ULT_CONF_PCIR_AE_MASK    I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_PCIR_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_PCIRTL_AE_SHIFT 1
#define I40E_GLNVM_ULT_CONF_PCIRTL_AE_MASK  I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_PCIRTL_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_LCB_AE_SHIFT    2
#define I40E_GLNVM_ULT_CONF_LCB_AE_MASK     I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_LCB_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_CORE_AE_SHIFT   3
#define I40E_GLNVM_ULT_CONF_CORE_AE_MASK    I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_CORE_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_GLOBAL_AE_SHIFT 4
#define I40E_GLNVM_ULT_CONF_GLOBAL_AE_MASK  I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_GLOBAL_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_POR_AE_SHIFT    5
#define I40E_GLNVM_ULT_CONF_POR_AE_MASK     I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_POR_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_EMP_AE_SHIFT    8
#define I40E_GLNVM_ULT_CONF_EMP_AE_MASK     I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_EMP_AE_SHIFT)
#define I40E_GLNVM_ULT_CONF_PCIALT_AE_SHIFT 9
#define I40E_GLNVM_ULT_CONF_PCIALT_AE_MASK  I40E_MASK(0x1, I40E_GLNVM_ULT_CONF_PCIALT_AE_SHIFT)

#define I40E_MEM_INIT_GATE_AL_DONE                                    0x000B6004 /* Reset: POR */
#define I40E_MEM_INIT_GATE_AL_DONE_CMLAN_INIT_DONE_GATE_AL_DONE_SHIFT 0
#define I40E_MEM_INIT_GATE_AL_DONE_CMLAN_INIT_DONE_GATE_AL_DONE_MASK  I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_CMLAN_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_PMAT_INIT_DONE_GATE_AL_DONE_SHIFT  1
#define I40E_MEM_INIT_GATE_AL_DONE_PMAT_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_PMAT_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_RCU_INIT_DONE_GATE_AL_DONE_SHIFT   2
#define I40E_MEM_INIT_GATE_AL_DONE_RCU_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_RCU_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_TDPU_INIT_DONE_GATE_AL_DONE_SHIFT  3
#define I40E_MEM_INIT_GATE_AL_DONE_TDPU_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_TDPU_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_TLAN_INIT_DONE_GATE_AL_DONE_SHIFT  4
#define I40E_MEM_INIT_GATE_AL_DONE_TLAN_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_TLAN_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_RLAN_INIT_DONE_GATE_AL_DONE_SHIFT  5
#define I40E_MEM_INIT_GATE_AL_DONE_RLAN_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_RLAN_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_RDPU_INIT_DONE_GATE_AL_DONE_SHIFT  6
#define I40E_MEM_INIT_GATE_AL_DONE_RDPU_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_RDPU_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_PPRS_INIT_DONE_GATE_AL_DONE_SHIFT  7
#define I40E_MEM_INIT_GATE_AL_DONE_PPRS_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_PPRS_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_RPB_INIT_DONE_GATE_AL_DONE_SHIFT   8
#define I40E_MEM_INIT_GATE_AL_DONE_RPB_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_RPB_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_TPB_INIT_DONE_GATE_AL_DONE_SHIFT   9
#define I40E_MEM_INIT_GATE_AL_DONE_TPB_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_TPB_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_FOC_INIT_DONE_GATE_AL_DONE_SHIFT   10
#define I40E_MEM_INIT_GATE_AL_DONE_FOC_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_FOC_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_TSCD_INIT_DONE_GATE_AL_DONE_SHIFT  11
#define I40E_MEM_INIT_GATE_AL_DONE_TSCD_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_TSCD_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_TCB_INIT_DONE_GATE_AL_DONE_SHIFT   12
#define I40E_MEM_INIT_GATE_AL_DONE_TCB_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_TCB_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_RCB_INIT_DONE_GATE_AL_DONE_SHIFT   13
#define I40E_MEM_INIT_GATE_AL_DONE_RCB_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_RCB_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_WUC_INIT_DONE_GATE_AL_DONE_SHIFT   14
#define I40E_MEM_INIT_GATE_AL_DONE_WUC_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_WUC_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_STAT_INIT_DONE_GATE_AL_DONE_SHIFT  15
#define I40E_MEM_INIT_GATE_AL_DONE_STAT_INIT_DONE_GATE_AL_DONE_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_STAT_INIT_DONE_GATE_AL_DONE_SHIFT)
#define I40E_MEM_INIT_GATE_AL_DONE_ITR_INIT_DONE_GATE_AL_DONE_SHIFT   16
#define I40E_MEM_INIT_GATE_AL_DONE_ITR_INIT_DONE_GATE_AL_DONE_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_DONE_ITR_INIT_DONE_GATE_AL_DONE_SHIFT)

#define I40E_MEM_INIT_GATE_AL_STR                                    0x000B6000 /* Reset: POR */
#define I40E_MEM_INIT_GATE_AL_STR_CMLAN_INIT_DONE_GATE_AL_STRT_SHIFT 0
#define I40E_MEM_INIT_GATE_AL_STR_CMLAN_INIT_DONE_GATE_AL_STRT_MASK  I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_CMLAN_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_PMAT_INIT_DONE_GATE_AL_STRT_SHIFT  1
#define I40E_MEM_INIT_GATE_AL_STR_PMAT_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_PMAT_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_RCU_INIT_DONE_GATE_AL_STRT_SHIFT   2
#define I40E_MEM_INIT_GATE_AL_STR_RCU_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_RCU_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_TDPU_INIT_DONE_GATE_AL_STRT_SHIFT  3
#define I40E_MEM_INIT_GATE_AL_STR_TDPU_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_TDPU_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_TLAN_INIT_DONE_GATE_AL_STRT_SHIFT  4
#define I40E_MEM_INIT_GATE_AL_STR_TLAN_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_TLAN_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_RLAN_INIT_DONE_GATE_AL_STRT_SHIFT  5
#define I40E_MEM_INIT_GATE_AL_STR_RLAN_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_RLAN_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_RDPU_INIT_DONE_GATE_AL_STRT_SHIFT  6
#define I40E_MEM_INIT_GATE_AL_STR_RDPU_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_RDPU_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_PPRS_INIT_DONE_GATE_AL_STRT_SHIFT  7
#define I40E_MEM_INIT_GATE_AL_STR_PPRS_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_PPRS_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_RPB_INIT_DONE_GATE_AL_STRT_SHIFT   8
#define I40E_MEM_INIT_GATE_AL_STR_RPB_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_RPB_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_TPB_INIT_DONE_GATE_AL_STRT_SHIFT   9
#define I40E_MEM_INIT_GATE_AL_STR_TPB_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_TPB_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_FOC_INIT_DONE_GATE_AL_STRT_SHIFT   10
#define I40E_MEM_INIT_GATE_AL_STR_FOC_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_FOC_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_TSCD_INIT_DONE_GATE_AL_STRT_SHIFT  11
#define I40E_MEM_INIT_GATE_AL_STR_TSCD_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_TSCD_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_TCB_INIT_DONE_GATE_AL_STRT_SHIFT   12
#define I40E_MEM_INIT_GATE_AL_STR_TCB_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_TCB_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_RCB_INIT_DONE_GATE_AL_STRT_SHIFT   13
#define I40E_MEM_INIT_GATE_AL_STR_RCB_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_RCB_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_WUC_INIT_DONE_GATE_AL_STRT_SHIFT   14
#define I40E_MEM_INIT_GATE_AL_STR_WUC_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_WUC_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_STAT_INIT_DONE_GATE_AL_STRT_SHIFT  15
#define I40E_MEM_INIT_GATE_AL_STR_STAT_INIT_DONE_GATE_AL_STRT_MASK   I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_STAT_INIT_DONE_GATE_AL_STRT_SHIFT)
#define I40E_MEM_INIT_GATE_AL_STR_ITR_INIT_DONE_GATE_AL_STRT_SHIFT   16
#define I40E_MEM_INIT_GATE_AL_STR_ITR_INIT_DONE_GATE_AL_STRT_MASK    I40E_MASK(0x1, I40E_MEM_INIT_GATE_AL_STR_ITR_INIT_DONE_GATE_AL_STRT_SHIFT)

/* PF - PCIe Registers  */

#define I40E_EMP_PCI_CIAA               0x0009C4D0 /* Reset: PCIR */
#define I40E_EMP_PCI_CIAA_ADDRESS_SHIFT 0
#define I40E_EMP_PCI_CIAA_ADDRESS_MASK  I40E_MASK(0xFFF, I40E_EMP_PCI_CIAA_ADDRESS_SHIFT)
#define I40E_EMP_PCI_CIAA_FNUM_SHIFT    12
#define I40E_EMP_PCI_CIAA_FNUM_MASK     I40E_MASK(0x7F, I40E_EMP_PCI_CIAA_FNUM_SHIFT)
#define I40E_EMP_PCI_CIAA_PF_SHIFT      19
#define I40E_EMP_PCI_CIAA_PF_MASK       I40E_MASK(0x1, I40E_EMP_PCI_CIAA_PF_SHIFT)

#define I40E_EMP_PCI_CIAD            0x0009C4D4 /* Reset: PCIR */
#define I40E_EMP_PCI_CIAD_DATA_SHIFT 0
#define I40E_EMP_PCI_CIAD_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_PCI_CIAD_DATA_SHIFT)

#define I40E_GL_PCI_DBGCTL                            0x000BE4F4 /* Reset: PCIR */
#define I40E_GL_PCI_DBGCTL_CONFIG_ACCESS_ENABLE_SHIFT 0
#define I40E_GL_PCI_DBGCTL_CONFIG_ACCESS_ENABLE_MASK  I40E_MASK(0x1, I40E_GL_PCI_DBGCTL_CONFIG_ACCESS_ENABLE_SHIFT)

#define I40E_GLGEN_FWPFRSTAT              0x0009C4E8 /* Reset: PCIR */
#define I40E_GLGEN_FWPFRSTAT_PF_FLR_SHIFT 0
#define I40E_GLGEN_FWPFRSTAT_PF_FLR_MASK  I40E_MASK(0xFFFF, I40E_GLGEN_FWPFRSTAT_PF_FLR_SHIFT)

#define I40E_GLGEN_FWVFRSTAT(_i)          (0x0009C4D8 + ((_i) * 4)) /* _i=0...3 */ /* Reset: PCIR */
#define I40E_GLGEN_FWVFRSTAT_MAX_INDEX    3
#define I40E_GLGEN_FWVFRSTAT_VF_FLR_SHIFT 0
#define I40E_GLGEN_FWVFRSTAT_VF_FLR_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLGEN_FWVFRSTAT_VF_FLR_SHIFT)

#define I40E_GLGEN_PCIFCNCNT_PCI                0x000BE4A0 /* Reset: PCIR */
#define I40E_GLGEN_PCIFCNCNT_PCI_PCIPFCNT_SHIFT 0
#define I40E_GLGEN_PCIFCNCNT_PCI_PCIPFCNT_MASK  I40E_MASK(0x1F, I40E_GLGEN_PCIFCNCNT_PCI_PCIPFCNT_SHIFT)
#define I40E_GLGEN_PCIFCNCNT_PCI_PCIVFCNT_SHIFT 16
#define I40E_GLGEN_PCIFCNCNT_PCI_PCIVFCNT_MASK  I40E_MASK(0xFF, I40E_GLGEN_PCIFCNCNT_PCI_PCIVFCNT_SHIFT)

#define I40E_GLPCI_ANA_ADD               0x000BA000 /* Reset: POR */
#define I40E_GLPCI_ANA_ADD_ADDRESS_SHIFT 0
#define I40E_GLPCI_ANA_ADD_ADDRESS_MASK  I40E_MASK(0xFFFF, I40E_GLPCI_ANA_ADD_ADDRESS_SHIFT)
#define I40E_GLPCI_ANA_ADD_BYTE_EN_SHIFT 28
#define I40E_GLPCI_ANA_ADD_BYTE_EN_MASK  I40E_MASK(0xF, I40E_GLPCI_ANA_ADD_BYTE_EN_SHIFT)

#define I40E_GLPCI_ANA_DATA            0x000BA004 /* Reset: POR */
#define I40E_GLPCI_ANA_DATA_DATA_SHIFT 0
#define I40E_GLPCI_ANA_DATA_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_ANA_DATA_DATA_SHIFT)

#define I40E_GLPCI_LCBADD                0x0009C4C0 /* Reset: PCIR */
#define I40E_GLPCI_LCBADD_ADDRESS_SHIFT  0
#define I40E_GLPCI_LCBADD_ADDRESS_MASK   I40E_MASK(0x3FFFF, I40E_GLPCI_LCBADD_ADDRESS_SHIFT)
#define I40E_GLPCI_LCBADD_BLOCK_ID_SHIFT 20
#define I40E_GLPCI_LCBADD_BLOCK_ID_MASK  I40E_MASK(0x7FF, I40E_GLPCI_LCBADD_BLOCK_ID_SHIFT)
#define I40E_GLPCI_LCBADD_LOCK_SHIFT     31
#define I40E_GLPCI_LCBADD_LOCK_MASK      I40E_MASK(0x1, I40E_GLPCI_LCBADD_LOCK_SHIFT)

#define I40E_GLPCI_LCBDATA                0x0009C4C4 /* Reset: PCIR */
#define I40E_GLPCI_LCBDATA_LCB_DATA_SHIFT 0
#define I40E_GLPCI_LCBDATA_LCB_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPCI_LCBDATA_LCB_DATA_SHIFT)

#define I40E_GLPCI_PCITEST1                  0x000BE488 /* Reset: PCIR */
#define I40E_GLPCI_PCITEST1_IGNORE_RID_SHIFT 0
#define I40E_GLPCI_PCITEST1_IGNORE_RID_MASK  I40E_MASK(0x1, I40E_GLPCI_PCITEST1_IGNORE_RID_SHIFT)
#define I40E_GLPCI_PCITEST1_V_MSIX_EN_SHIFT  2
#define I40E_GLPCI_PCITEST1_V_MSIX_EN_MASK   I40E_MASK(0x1, I40E_GLPCI_PCITEST1_V_MSIX_EN_SHIFT)

#define I40E_GLPCI_PCITEST2                     0x000BE4BC /* Reset: PCIR */
#define I40E_GLPCI_PCITEST2_IOV_TEST_MODE_SHIFT 0
#define I40E_GLPCI_PCITEST2_IOV_TEST_MODE_MASK  I40E_MASK(0x1, I40E_GLPCI_PCITEST2_IOV_TEST_MODE_SHIFT)
#define I40E_GLPCI_PCITEST2_TAG_ALLOC_SHIFT     1
#define I40E_GLPCI_PCITEST2_TAG_ALLOC_MASK      I40E_MASK(0x1, I40E_GLPCI_PCITEST2_TAG_ALLOC_SHIFT)

#define I40E_GLTPH_CTRL                         0x000BE480 /* Reset: PCIR */
#define I40E_GLTPH_CTRL_DISABLE_READ_HINT_SHIFT 8
#define I40E_GLTPH_CTRL_DISABLE_READ_HINT_MASK  I40E_MASK(0x1, I40E_GLTPH_CTRL_DISABLE_READ_HINT_SHIFT)
#define I40E_GLTPH_CTRL_DESC_PH_SHIFT           9
#define I40E_GLTPH_CTRL_DESC_PH_MASK            I40E_MASK(0x3, I40E_GLTPH_CTRL_DESC_PH_SHIFT)
#define I40E_GLTPH_CTRL_DATA_PH_SHIFT           11
#define I40E_GLTPH_CTRL_DATA_PH_MASK            I40E_MASK(0x3, I40E_GLTPH_CTRL_DATA_PH_SHIFT)
#define I40E_GLTPH_CTRL_TPH_AUTOLEARN_SHIFT     13
#define I40E_GLTPH_CTRL_TPH_AUTOLEARN_MASK      I40E_MASK(0x1, I40E_GLTPH_CTRL_TPH_AUTOLEARN_SHIFT)

#define I40E_PF_VT_PFALLOC_PCIE               0x000BE380 /* Reset: PCIR */
#define I40E_PF_VT_PFALLOC_PCIE_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_PCIE_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_PCIE_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_PCIE_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_PCIE_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_PCIE_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_PCIE_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_PCIE_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_PCIE_VALID_SHIFT)

/* PF - Power Management Registers */

#define I40E_GLPCI_PM_EN_STAT                        0x000BE4E4 /* Reset: POR */
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF0_SHIFT  0
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF0_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF0_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF1_SHIFT  1
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF1_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF1_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF2_SHIFT  2
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF2_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF2_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF3_SHIFT  3
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF3_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF3_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF4_SHIFT  4
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF4_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF4_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF5_SHIFT  5
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF5_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF5_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF6_SHIFT  6
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF6_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF6_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF7_SHIFT  7
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF7_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF7_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF8_SHIFT  8
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF8_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF8_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF9_SHIFT  9
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF9_MASK   I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF9_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF10_SHIFT 10
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF10_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF10_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF11_SHIFT 11
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF11_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF11_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF12_SHIFT 12
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF12_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF12_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF13_SHIFT 13
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF13_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF13_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF14_SHIFT 14
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF14_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF14_SHIFT)
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF15_SHIFT 15
#define I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF15_MASK  I40E_MASK(0x1, I40E_GLPCI_PM_EN_STAT_PCIE_PME_EN_PF15_SHIFT)

#define I40E_GLPM_DMAC_ENC                 0x000881F0 /* Reset: CORER */
#define I40E_GLPM_DMAC_ENC_DMACENTRY_SHIFT 0
#define I40E_GLPM_DMAC_ENC_DMACENTRY_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPM_DMAC_ENC_DMACENTRY_SHIFT)

#define I40E_GLPM_DMAC_EXC                     0x000881FC /* Reset: CORER */
#define I40E_GLPM_DMAC_EXC_DMACTIMEREXIT_SHIFT 0
#define I40E_GLPM_DMAC_EXC_DMACTIMEREXIT_MASK  I40E_MASK(0xFFFF, I40E_GLPM_DMAC_EXC_DMACTIMEREXIT_SHIFT)
#define I40E_GLPM_DMAC_EXC_DMAIMMEXIT_SHIFT    16
#define I40E_GLPM_DMAC_EXC_DMAIMMEXIT_MASK     I40E_MASK(0xFFFF, I40E_GLPM_DMAC_EXC_DMAIMMEXIT_SHIFT)

#define I40E_GLPM_DMACR                                0x000881F4 /* Reset: CORER */
#define I40E_GLPM_DMACR_DMACWT_SHIFT                   0
#define I40E_GLPM_DMACR_DMACWT_MASK                    I40E_MASK(0xFFFF, I40E_GLPM_DMACR_DMACWT_SHIFT)
#define I40E_GLPM_DMACR_EXIT_DC_SHIFT                  29
#define I40E_GLPM_DMACR_EXIT_DC_MASK                   I40E_MASK(0x1, I40E_GLPM_DMACR_EXIT_DC_SHIFT)
#define I40E_GLPM_DMACR_LX_COALESCING_INDICATION_SHIFT 30
#define I40E_GLPM_DMACR_LX_COALESCING_INDICATION_MASK  I40E_MASK(0x1, I40E_GLPM_DMACR_LX_COALESCING_INDICATION_SHIFT)
#define I40E_GLPM_DMACR_DMAC_EN_SHIFT                  31
#define I40E_GLPM_DMACR_DMAC_EN_MASK                   I40E_MASK(0x1, I40E_GLPM_DMACR_DMAC_EN_SHIFT)

#define I40E_GLPM_DMCTH               0x000AC7E4 /* Reset: CORER */
#define I40E_GLPM_DMCTH_DMACRXT_SHIFT 0
#define I40E_GLPM_DMCTH_DMACRXT_MASK  I40E_MASK(0x3FF, I40E_GLPM_DMCTH_DMACRXT_SHIFT)

#define I40E_GLPM_DMCTLX            0x000881F8 /* Reset: CORER */
#define I40E_GLPM_DMCTLX_TTLX_SHIFT 0
#define I40E_GLPM_DMCTLX_TTLX_MASK  I40E_MASK(0xFFF, I40E_GLPM_DMCTLX_TTLX_SHIFT)

#define I40E_GLPM_EEE_SU                           0x001E4340 /* Reset: GLOBR */
#define I40E_GLPM_EEE_SU_DTW_MIN_1000_BASE_T_SHIFT 0
#define I40E_GLPM_EEE_SU_DTW_MIN_1000_BASE_T_MASK  I40E_MASK(0xFF, I40E_GLPM_EEE_SU_DTW_MIN_1000_BASE_T_SHIFT)
#define I40E_GLPM_EEE_SU_DTW_MIN_100_BASE_TX_SHIFT 8
#define I40E_GLPM_EEE_SU_DTW_MIN_100_BASE_TX_MASK  I40E_MASK(0xFF, I40E_GLPM_EEE_SU_DTW_MIN_100_BASE_TX_SHIFT)

#define I40E_GLPM_EEE_SU_EXT                            0x001E4344 /* Reset: GLOBR */
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_1000_BASE_KX_SHIFT 0
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_1000_BASE_KX_MASK  I40E_MASK(0xFF, I40E_GLPM_EEE_SU_EXT_DTW_MIN_1000_BASE_KX_SHIFT)
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KX4_SHIFT  8
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KX4_MASK   I40E_MASK(0xFF, I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KX4_SHIFT)
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KR_SHIFT   16
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KR_MASK    I40E_MASK(0xFF, I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_KR_SHIFT)
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_T_SHIFT    24
#define I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_T_MASK     I40E_MASK(0xFF, I40E_GLPM_EEE_SU_EXT_DTW_MIN_10GBASE_T_SHIFT)

#define I40E_GLPM_LTRC                         0x000BE500 /* Reset: PCIR */
#define I40E_GLPM_LTRC_SLTRV_SHIFT             0
#define I40E_GLPM_LTRC_SLTRV_MASK              I40E_MASK(0x3FF, I40E_GLPM_LTRC_SLTRV_SHIFT)
#define I40E_GLPM_LTRC_SSCALE_SHIFT            10
#define I40E_GLPM_LTRC_SSCALE_MASK             I40E_MASK(0x7, I40E_GLPM_LTRC_SSCALE_SHIFT)
#define I40E_GLPM_LTRC_LTRS_REQUIREMENT_SHIFT  15
#define I40E_GLPM_LTRC_LTRS_REQUIREMENT_MASK   I40E_MASK(0x1, I40E_GLPM_LTRC_LTRS_REQUIREMENT_SHIFT)
#define I40E_GLPM_LTRC_NSLTRV_SHIFT            16
#define I40E_GLPM_LTRC_NSLTRV_MASK             I40E_MASK(0x3FF, I40E_GLPM_LTRC_NSLTRV_SHIFT)
#define I40E_GLPM_LTRC_NSSCALE_SHIFT           26
#define I40E_GLPM_LTRC_NSSCALE_MASK            I40E_MASK(0x7, I40E_GLPM_LTRC_NSSCALE_SHIFT)
#define I40E_GLPM_LTRC_LTR_SEND_SHIFT          30
#define I40E_GLPM_LTRC_LTR_SEND_MASK           I40E_MASK(0x1, I40E_GLPM_LTRC_LTR_SEND_SHIFT)
#define I40E_GLPM_LTRC_LTRNS_REQUIREMENT_SHIFT 31
#define I40E_GLPM_LTRC_LTRNS_REQUIREMENT_MASK  I40E_MASK(0x1, I40E_GLPM_LTRC_LTRNS_REQUIREMENT_SHIFT)

#define I40E_PRTPM_EEEDBG                  0x001E4420 /* Reset: GLOBR */
#define I40E_PRTPM_EEEDBG_FORCE_TLPI_SHIFT 0
#define I40E_PRTPM_EEEDBG_FORCE_TLPI_MASK  I40E_MASK(0x1, I40E_PRTPM_EEEDBG_FORCE_TLPI_SHIFT)

#define I40E_PRTPM_HPTC                   0x000AC800 /* Reset: CORER */
#define I40E_PRTPM_HPTC_HIGH_PRI_TC_SHIFT 0
#define I40E_PRTPM_HPTC_HIGH_PRI_TC_MASK  I40E_MASK(0xFF, I40E_PRTPM_HPTC_HIGH_PRI_TC_SHIFT)

/* PF - Receive Packet Buffer Registers */

#define I40E_GLRPB_DHWS               0x000AC820 /* Reset: CORER */
#define I40E_GLRPB_DHWS_DHW_TCN_SHIFT 0
#define I40E_GLRPB_DHWS_DHW_TCN_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_DHWS_DHW_TCN_SHIFT)

#define I40E_GLRPB_DLWS               0x000AC824 /* Reset: CORER */
#define I40E_GLRPB_DLWS_DLW_TCN_SHIFT 0
#define I40E_GLRPB_DLWS_DLW_TCN_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_DLWS_DLW_TCN_SHIFT)

#define I40E_GLRPB_GFC           0x000AC82C /* Reset: CORER */
#define I40E_GLRPB_GFC_GFC_SHIFT 0
#define I40E_GLRPB_GFC_GFC_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_GFC_GFC_SHIFT)

#define I40E_GLRPB_GPC           0x000AC838 /* Reset: CORER */
#define I40E_GLRPB_GPC_GPC_SHIFT 0
#define I40E_GLRPB_GPC_GPC_MASK  I40E_MASK(0x3FFF, I40E_GLRPB_GPC_GPC_SHIFT)

#define I40E_GLRPB_LTRTL             0x000AC83C /* Reset: CORER */
#define I40E_GLRPB_LTRTL_LTRTL_SHIFT 0
#define I40E_GLRPB_LTRTL_LTRTL_MASK  I40E_MASK(0x3FF, I40E_GLRPB_LTRTL_LTRTL_SHIFT)

#define I40E_GLRPB_LTRTV             0x000AC840 /* Reset: CORER */
#define I40E_GLRPB_LTRTV_LTRTV_SHIFT 0
#define I40E_GLRPB_LTRTV_LTRTV_MASK  I40E_MASK(0x3FF, I40E_GLRPB_LTRTV_LTRTV_SHIFT)

#define I40E_GLRPB_SHTS               0x000AC84C /* Reset: CORER */
#define I40E_GLRPB_SHTS_SHT_TCN_SHIFT 0
#define I40E_GLRPB_SHTS_SHT_TCN_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_SHTS_SHT_TCN_SHIFT)

#define I40E_GLRPB_SHWS           0x000AC850 /* Reset: CORER */
#define I40E_GLRPB_SHWS_SHW_SHIFT 0
#define I40E_GLRPB_SHWS_SHW_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_SHWS_SHW_SHIFT)

#define I40E_GLRPB_SLTS               0x000AC854 /* Reset: CORER */
#define I40E_GLRPB_SLTS_SLT_TCN_SHIFT 0
#define I40E_GLRPB_SLTS_SLT_TCN_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_SLTS_SLT_TCN_SHIFT)

#define I40E_GLRPB_SLWS           0x000AC858 /* Reset: CORER */
#define I40E_GLRPB_SLWS_SLW_SHIFT 0
#define I40E_GLRPB_SLWS_SLW_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_SLWS_SLW_SHIFT)

#define I40E_GLRPB_SPSS           0x000AC85C /* Reset: CORER */
#define I40E_GLRPB_SPSS_SPS_SHIFT 0
#define I40E_GLRPB_SPSS_SPS_MASK  I40E_MASK(0xFFFFF, I40E_GLRPB_SPSS_SPS_SHIFT)

#define I40E_PRTRPB_DFC(_i)           (0x000AC000 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTRPB_DFC_MAX_INDEX     7
#define I40E_PRTRPB_DFC_DFC_TCN_SHIFT 0
#define I40E_PRTRPB_DFC_DFC_TCN_MASK  I40E_MASK(0xFFFFF, I40E_PRTRPB_DFC_DFC_TCN_SHIFT)

#define I40E_PRTRPB_PFC           0x000AC420 /* Reset: CORER */
#define I40E_PRTRPB_PFC_PFC_SHIFT 0
#define I40E_PRTRPB_PFC_PFC_MASK  I40E_MASK(0xFFFFF, I40E_PRTRPB_PFC_PFC_SHIFT)

#define I40E_PRTRPB_RUP2TC             0x000AC440 /* Reset: CORER */
#define I40E_PRTRPB_RUP2TC_UP0TC_SHIFT 0
#define I40E_PRTRPB_RUP2TC_UP0TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP0TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP1TC_SHIFT 3
#define I40E_PRTRPB_RUP2TC_UP1TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP1TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP2TC_SHIFT 6
#define I40E_PRTRPB_RUP2TC_UP2TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP2TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP3TC_SHIFT 9
#define I40E_PRTRPB_RUP2TC_UP3TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP3TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP4TC_SHIFT 12
#define I40E_PRTRPB_RUP2TC_UP4TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP4TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP5TC_SHIFT 15
#define I40E_PRTRPB_RUP2TC_UP5TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP5TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP6TC_SHIFT 18
#define I40E_PRTRPB_RUP2TC_UP6TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP6TC_SHIFT)
#define I40E_PRTRPB_RUP2TC_UP7TC_SHIFT 21
#define I40E_PRTRPB_RUP2TC_UP7TC_MASK  I40E_MASK(0x7, I40E_PRTRPB_RUP2TC_UP7TC_SHIFT)

#define I40E_PRTRPB_SFC           0x000AC460 /* Reset: CORER */
#define I40E_PRTRPB_SFC_SFC_SHIFT 0
#define I40E_PRTRPB_SFC_SFC_MASK  I40E_MASK(0xFFFFF, I40E_PRTRPB_SFC_SFC_SHIFT)

#define I40E_PRTRPB_SOC(_i)           (0x000AC6C0 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRTRPB_SOC_MAX_INDEX     7
#define I40E_PRTRPB_SOC_SOC_TCN_SHIFT 0
#define I40E_PRTRPB_SOC_SOC_TCN_MASK  I40E_MASK(0xFFFFF, I40E_PRTRPB_SOC_SOC_TCN_SHIFT)

#define I40E_PRTRPB_TC2PFC              0x000AC200 /* Reset: CORER */
#define I40E_PRTRPB_TC2PFC_TC2PFC_SHIFT 0
#define I40E_PRTRPB_TC2PFC_TC2PFC_MASK  I40E_MASK(0xFF, I40E_PRTRPB_TC2PFC_TC2PFC_SHIFT)

/* PF - Rx Filters Registers */

#define I40E_GL_PRS_FVBM(_i)                 (0x00269760 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GL_PRS_FVBM_MAX_INDEX           3
#define I40E_GL_PRS_FVBM_FV_BYTE_INDX_SHIFT  0
#define I40E_GL_PRS_FVBM_FV_BYTE_INDX_MASK   I40E_MASK(0x7F, I40E_GL_PRS_FVBM_FV_BYTE_INDX_SHIFT)
#define I40E_GL_PRS_FVBM_RULE_BUS_INDX_SHIFT 8
#define I40E_GL_PRS_FVBM_RULE_BUS_INDX_MASK  I40E_MASK(0x3F, I40E_GL_PRS_FVBM_RULE_BUS_INDX_SHIFT)
#define I40E_GL_PRS_FVBM_MSK_ENA_SHIFT       31
#define I40E_GL_PRS_FVBM_MSK_ENA_MASK        I40E_MASK(0x1, I40E_GL_PRS_FVBM_MSK_ENA_SHIFT)

#define I40E_GLCM_LAN_FCOEQCNT                    0x0010C438 /* Reset: CORER */
#define I40E_GLCM_LAN_FCOEQCNT_FCOE_DDP_CNT_SHIFT 10
#define I40E_GLCM_LAN_FCOEQCNT_FCOE_DDP_CNT_MASK  I40E_MASK(0x3FF, I40E_GLCM_LAN_FCOEQCNT_FCOE_DDP_CNT_SHIFT)

#define I40E_GLCM_LAN_LANQCNT                 0x0010C434 /* Reset: CORER */
#define I40E_GLCM_LAN_LANQCNT_LANTX_CNT_SHIFT 0
#define I40E_GLCM_LAN_LANQCNT_LANTX_CNT_MASK  I40E_MASK(0x3FF, I40E_GLCM_LAN_LANQCNT_LANTX_CNT_SHIFT)
#define I40E_GLCM_LAN_LANQCNT_LANRX_CNT_SHIFT 10
#define I40E_GLCM_LAN_LANQCNT_LANRX_CNT_MASK  I40E_MASK(0x3FF, I40E_GLCM_LAN_LANQCNT_LANRX_CNT_SHIFT)

#define I40E_GLFOC_CACHE_CTL                     0x000AA000 /* Reset: CORER */
#define I40E_GLFOC_CACHE_CTL_FD_ALLOCATION_SHIFT 0
#define I40E_GLFOC_CACHE_CTL_FD_ALLOCATION_MASK  I40E_MASK(0x3, I40E_GLFOC_CACHE_CTL_FD_ALLOCATION_SHIFT)
#define I40E_GLFOC_CACHE_CTL_SCALE_FACTOR_SHIFT  2
#define I40E_GLFOC_CACHE_CTL_SCALE_FACTOR_MASK   I40E_MASK(0x3, I40E_GLFOC_CACHE_CTL_SCALE_FACTOR_SHIFT)
#define I40E_GLFOC_CACHE_CTL_DBGMUX_EN_SHIFT     4
#define I40E_GLFOC_CACHE_CTL_DBGMUX_EN_MASK      I40E_MASK(0x1, I40E_GLFOC_CACHE_CTL_DBGMUX_EN_SHIFT)
#define I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_LO_SHIFT 8
#define I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_LO_MASK  I40E_MASK(0x1F, I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_LO_SHIFT)
#define I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_HI_SHIFT 16
#define I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_HI_MASK  I40E_MASK(0x1F, I40E_GLFOC_CACHE_CTL_DBGMUX_SEL_HI_SHIFT)

#define I40E_GLFOC_FSTAT              0x000AA004 /* Reset: CORER */
#define I40E_GLFOC_FSTAT_PE_CNT_SHIFT 0
#define I40E_GLFOC_FSTAT_PE_CNT_MASK  I40E_MASK(0x7FF, I40E_GLFOC_FSTAT_PE_CNT_SHIFT)
#define I40E_GLFOC_FSTAT_FC_CNT_SHIFT 16
#define I40E_GLFOC_FSTAT_FC_CNT_MASK  I40E_MASK(0x7FF, I40E_GLFOC_FSTAT_FC_CNT_SHIFT)

#define I40E_GLQF_FC_INSET(_i, _j)      (0x002695A0 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...3 */ /* Reset: CORER */
#define I40E_GLQF_FC_INSET_MAX_INDEX   1
#define I40E_GLQF_FC_INSET_INSET_SHIFT 0
#define I40E_GLQF_FC_INSET_INSET_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_FC_INSET_INSET_SHIFT)

#define I40E_GLQF_FC_MSK(_i, _j)       (0x002690C0 + ((_i) * 4 + (_j) * 16)) /* _i=0...3, _j=0...3 */ /* Reset: CORER */
#define I40E_GLQF_FC_MSK_MAX_INDEX    3
#define I40E_GLQF_FC_MSK_MASK_SHIFT   0
#define I40E_GLQF_FC_MSK_MASK_MASK    I40E_MASK(0xFFFF, I40E_GLQF_FC_MSK_MASK_SHIFT)
#define I40E_GLQF_FC_MSK_OFFSET_SHIFT 16
#define I40E_GLQF_FC_MSK_OFFSET_MASK  I40E_MASK(0x3F, I40E_GLQF_FC_MSK_OFFSET_SHIFT)

#define I40E_GLQF_FCTYPE(_i)                (0x00269520 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLQF_FCTYPE_MAX_INDEX          3
#define I40E_GLQF_FCTYPE_PCTYPE_INDEX_SHIFT 0
#define I40E_GLQF_FCTYPE_PCTYPE_INDEX_MASK  I40E_MASK(0x3F, I40E_GLQF_FCTYPE_PCTYPE_INDEX_SHIFT)
#define I40E_GLQF_FCTYPE_PCTYPE_ENA_SHIFT   7
#define I40E_GLQF_FCTYPE_PCTYPE_ENA_MASK    I40E_MASK(0x1, I40E_GLQF_FCTYPE_PCTYPE_ENA_SHIFT)

#define I40E_GLQF_FD_MSK(_i, _j)       (0x00267200 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...63 */ /* Reset: CORER */
#define I40E_GLQF_FD_MSK_MAX_INDEX    1
#define I40E_GLQF_FD_MSK_MASK_SHIFT   0
#define I40E_GLQF_FD_MSK_MASK_MASK    I40E_MASK(0xFFFF, I40E_GLQF_FD_MSK_MASK_SHIFT)
#define I40E_GLQF_FD_MSK_OFFSET_SHIFT 16
#define I40E_GLQF_FD_MSK_OFFSET_MASK  I40E_MASK(0x3F, I40E_GLQF_FD_MSK_OFFSET_SHIFT)

#define I40E_GLQF_FDCNT_1                 0x00269BB4 /* Reset: CORER */
#define I40E_GLQF_FDCNT_1_BUCKETCNT_SHIFT 0
#define I40E_GLQF_FDCNT_1_BUCKETCNT_MASK  I40E_MASK(0x3FFF, I40E_GLQF_FDCNT_1_BUCKETCNT_SHIFT)

#define I40E_GLQF_FDCNT_2                0x00269BBC /* Reset: CORER */
#define I40E_GLQF_FDCNT_2_HITSBCNT_SHIFT 0
#define I40E_GLQF_FDCNT_2_HITSBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_FDCNT_2_HITSBCNT_SHIFT)

#define I40E_GLQF_FDCNT_3                0x00269BC4 /* Reset: CORER */
#define I40E_GLQF_FDCNT_3_HITLBCNT_SHIFT 0
#define I40E_GLQF_FDCNT_3_HITLBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_FDCNT_3_HITLBCNT_SHIFT)

#define I40E_GLQF_FDENA(_i)          (0x002698A8 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GLQF_FDENA_MAX_INDEX    1
#define I40E_GLQF_FDENA_FD_ENA_SHIFT 0
#define I40E_GLQF_FDENA_FD_ENA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_FDENA_FD_ENA_SHIFT)

#define I40E_GLQF_HASH_INSET(_i, _j)      (0x00267600 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...63 */ /* Reset: CORER */
#define I40E_GLQF_HASH_INSET_MAX_INDEX   1
#define I40E_GLQF_HASH_INSET_INSET_SHIFT 0
#define I40E_GLQF_HASH_INSET_INSET_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_HASH_INSET_INSET_SHIFT)

#define I40E_GLQF_HASH_MSK(_i, _j)       (0x00267A00 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...63 */ /* Reset: CORER */
#define I40E_GLQF_HASH_MSK_MAX_INDEX    1
#define I40E_GLQF_HASH_MSK_MASK_SHIFT   0
#define I40E_GLQF_HASH_MSK_MASK_MASK    I40E_MASK(0xFFFF, I40E_GLQF_HASH_MSK_MASK_SHIFT)
#define I40E_GLQF_HASH_MSK_OFFSET_SHIFT 16
#define I40E_GLQF_HASH_MSK_OFFSET_MASK  I40E_MASK(0x3F, I40E_GLQF_HASH_MSK_OFFSET_SHIFT)

#define I40E_GLQF_ORT(_i)               (0x00268900 + ((_i) * 4)) /* _i=0...63 */ /* Reset: CORER */
#define I40E_GLQF_ORT_MAX_INDEX         63
#define I40E_GLQF_ORT_PIT_INDX_SHIFT    0
#define I40E_GLQF_ORT_PIT_INDX_MASK     I40E_MASK(0x1F, I40E_GLQF_ORT_PIT_INDX_SHIFT)
#define I40E_GLQF_ORT_FIELD_CNT_SHIFT   5
#define I40E_GLQF_ORT_FIELD_CNT_MASK    I40E_MASK(0x3, I40E_GLQF_ORT_FIELD_CNT_SHIFT)
#define I40E_GLQF_ORT_FLX_PAYLOAD_SHIFT 7
#define I40E_GLQF_ORT_FLX_PAYLOAD_MASK  I40E_MASK(0x1, I40E_GLQF_ORT_FLX_PAYLOAD_SHIFT)

#define I40E_GLQF_PE_INSET(_i, _j)      (0x00269140 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...7 */ /* Reset: CORER */
#define I40E_GLQF_PE_INSET_MAX_INDEX   1
#define I40E_GLQF_PE_INSET_INSET_SHIFT 0
#define I40E_GLQF_PE_INSET_INSET_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_PE_INSET_INSET_SHIFT)

#define I40E_GLQF_PE_MSK(_i, _j)       (0x002691C0 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...7 */ /* Reset: CORER */
#define I40E_GLQF_PE_MSK_MAX_INDEX    1
#define I40E_GLQF_PE_MSK_MASK_SHIFT   0
#define I40E_GLQF_PE_MSK_MASK_MASK    I40E_MASK(0xFFFF, I40E_GLQF_PE_MSK_MASK_SHIFT)
#define I40E_GLQF_PE_MSK_OFFSET_SHIFT 16
#define I40E_GLQF_PE_MSK_OFFSET_MASK  I40E_MASK(0x3F, I40E_GLQF_PE_MSK_OFFSET_SHIFT)

#define I40E_GLQF_PECNT_0                0x00269FA4 /* Reset: CORER */
#define I40E_GLQF_PECNT_0_PROG_CNT_SHIFT 0
#define I40E_GLQF_PECNT_0_PROG_CNT_MASK  I40E_MASK(0x1F, I40E_GLQF_PECNT_0_PROG_CNT_SHIFT)

#define I40E_GLQF_PECNT_1                   0x00269FAC /* Reset: CORER */
#define I40E_GLQF_PECNT_1_ADD_OK_SHIFT      0
#define I40E_GLQF_PECNT_1_ADD_OK_MASK       I40E_MASK(0x1F, I40E_GLQF_PECNT_1_ADD_OK_SHIFT)
#define I40E_GLQF_PECNT_1_ADD_FAIL_SHIFT    8
#define I40E_GLQF_PECNT_1_ADD_FAIL_MASK     I40E_MASK(0x1F, I40E_GLQF_PECNT_1_ADD_FAIL_SHIFT)
#define I40E_GLQF_PECNT_1_REMOVE_OK_SHIFT   16
#define I40E_GLQF_PECNT_1_REMOVE_OK_MASK    I40E_MASK(0x1F, I40E_GLQF_PECNT_1_REMOVE_OK_SHIFT)
#define I40E_GLQF_PECNT_1_REMOVE_FAIL_SHIFT 24
#define I40E_GLQF_PECNT_1_REMOVE_FAIL_MASK  I40E_MASK(0x1F, I40E_GLQF_PECNT_1_REMOVE_FAIL_SHIFT)

#define I40E_GLQF_PETYPE(_i)                (0x00269560 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GLQF_PETYPE_MAX_INDEX          7
#define I40E_GLQF_PETYPE_PCTYPE_INDEX_SHIFT 0
#define I40E_GLQF_PETYPE_PCTYPE_INDEX_MASK  I40E_MASK(0x3F, I40E_GLQF_PETYPE_PCTYPE_INDEX_SHIFT)
#define I40E_GLQF_PETYPE_PCTYPE_ENA_SHIFT   7
#define I40E_GLQF_PETYPE_PCTYPE_ENA_MASK    I40E_MASK(0x1, I40E_GLQF_PETYPE_PCTYPE_ENA_SHIFT)

#define I40E_GLQF_PIT(_i)              (0x00268C80 + ((_i) * 4)) /* _i=0...23 */ /* Reset: CORER */
#define I40E_GLQF_PIT_MAX_INDEX        23
#define I40E_GLQF_PIT_SOURCE_OFF_SHIFT 0
#define I40E_GLQF_PIT_SOURCE_OFF_MASK  I40E_MASK(0x1F, I40E_GLQF_PIT_SOURCE_OFF_SHIFT)
#define I40E_GLQF_PIT_FSIZE_SHIFT      5
#define I40E_GLQF_PIT_FSIZE_MASK       I40E_MASK(0x1F, I40E_GLQF_PIT_FSIZE_SHIFT)
#define I40E_GLQF_PIT_DEST_OFF_SHIFT   10
#define I40E_GLQF_PIT_DEST_OFF_MASK    I40E_MASK(0x3F, I40E_GLQF_PIT_DEST_OFF_SHIFT)

#define I40E_GLQF_PTYPE(_i, _j)           (0x00268200 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...63 */ /* Reset: CORER */
#define I40E_GLQF_PTYPE_MAX_INDEX        1
#define I40E_GLQF_PTYPE_PROT_LAYER_SHIFT 0
#define I40E_GLQF_PTYPE_PROT_LAYER_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_PTYPE_PROT_LAYER_SHIFT)

#define I40E_GLQF_PTYPE_ENA(_i, _j)           (0x00268600 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...63 */ /* Reset: CORER */
#define I40E_GLQF_PTYPE_ENA_MAX_INDEX        1
#define I40E_GLQF_PTYPE_ENA_PROT_LAYER_SHIFT 0
#define I40E_GLQF_PTYPE_ENA_PROT_LAYER_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLQF_PTYPE_ENA_PROT_LAYER_SHIFT)

#define I40E_PFQF_CTL_0_PMAT                   0x000C0700 /* Reset: CORER */
#define I40E_PFQF_CTL_0_PMAT_PEHSIZE_SHIFT     0
#define I40E_PFQF_CTL_0_PMAT_PEHSIZE_MASK      I40E_MASK(0x1F, I40E_PFQF_CTL_0_PMAT_PEHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_PEDSIZE_SHIFT     5
#define I40E_PFQF_CTL_0_PMAT_PEDSIZE_MASK      I40E_MASK(0x1F, I40E_PFQF_CTL_0_PMAT_PEDSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_PFFCHSIZE_SHIFT   10
#define I40E_PFQF_CTL_0_PMAT_PFFCHSIZE_MASK    I40E_MASK(0xF, I40E_PFQF_CTL_0_PMAT_PFFCHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_PFFCDSIZE_SHIFT   14
#define I40E_PFQF_CTL_0_PMAT_PFFCDSIZE_MASK    I40E_MASK(0x3, I40E_PFQF_CTL_0_PMAT_PFFCDSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_HASHLUTSIZE_SHIFT 16
#define I40E_PFQF_CTL_0_PMAT_HASHLUTSIZE_MASK  I40E_MASK(0x1, I40E_PFQF_CTL_0_PMAT_HASHLUTSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_FD_ENA_SHIFT      17
#define I40E_PFQF_CTL_0_PMAT_FD_ENA_MASK       I40E_MASK(0x1, I40E_PFQF_CTL_0_PMAT_FD_ENA_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_ETYPE_ENA_SHIFT   18
#define I40E_PFQF_CTL_0_PMAT_ETYPE_ENA_MASK    I40E_MASK(0x1, I40E_PFQF_CTL_0_PMAT_ETYPE_ENA_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_MACVLAN_ENA_SHIFT 19
#define I40E_PFQF_CTL_0_PMAT_MACVLAN_ENA_MASK  I40E_MASK(0x1, I40E_PFQF_CTL_0_PMAT_MACVLAN_ENA_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_VFFCHSIZE_SHIFT   20
#define I40E_PFQF_CTL_0_PMAT_VFFCHSIZE_MASK    I40E_MASK(0xF, I40E_PFQF_CTL_0_PMAT_VFFCHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_PMAT_VFFCDSIZE_SHIFT   24
#define I40E_PFQF_CTL_0_PMAT_VFFCDSIZE_MASK    I40E_MASK(0x3, I40E_PFQF_CTL_0_PMAT_VFFCDSIZE_SHIFT)

#define I40E_PFQF_CTL_0_RCU                   0x00245C80 /* Reset: CORER */
#define I40E_PFQF_CTL_0_RCU_PEHSIZE_SHIFT     0
#define I40E_PFQF_CTL_0_RCU_PEHSIZE_MASK      I40E_MASK(0x1F, I40E_PFQF_CTL_0_RCU_PEHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_PEDSIZE_SHIFT     5
#define I40E_PFQF_CTL_0_RCU_PEDSIZE_MASK      I40E_MASK(0x1F, I40E_PFQF_CTL_0_RCU_PEDSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_PFFCHSIZE_SHIFT   10
#define I40E_PFQF_CTL_0_RCU_PFFCHSIZE_MASK    I40E_MASK(0xF, I40E_PFQF_CTL_0_RCU_PFFCHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_PFFCDSIZE_SHIFT   14
#define I40E_PFQF_CTL_0_RCU_PFFCDSIZE_MASK    I40E_MASK(0x3, I40E_PFQF_CTL_0_RCU_PFFCDSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_HASHLUTSIZE_SHIFT 16
#define I40E_PFQF_CTL_0_RCU_HASHLUTSIZE_MASK  I40E_MASK(0x1, I40E_PFQF_CTL_0_RCU_HASHLUTSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_FD_ENA_SHIFT      17
#define I40E_PFQF_CTL_0_RCU_FD_ENA_MASK       I40E_MASK(0x1, I40E_PFQF_CTL_0_RCU_FD_ENA_SHIFT)
#define I40E_PFQF_CTL_0_RCU_ETYPE_ENA_SHIFT   18
#define I40E_PFQF_CTL_0_RCU_ETYPE_ENA_MASK    I40E_MASK(0x1, I40E_PFQF_CTL_0_RCU_ETYPE_ENA_SHIFT)
#define I40E_PFQF_CTL_0_RCU_MACVLAN_ENA_SHIFT 19
#define I40E_PFQF_CTL_0_RCU_MACVLAN_ENA_MASK  I40E_MASK(0x1, I40E_PFQF_CTL_0_RCU_MACVLAN_ENA_SHIFT)
#define I40E_PFQF_CTL_0_RCU_VFFCHSIZE_SHIFT   20
#define I40E_PFQF_CTL_0_RCU_VFFCHSIZE_MASK    I40E_MASK(0xF, I40E_PFQF_CTL_0_RCU_VFFCHSIZE_SHIFT)
#define I40E_PFQF_CTL_0_RCU_VFFCDSIZE_SHIFT   24
#define I40E_PFQF_CTL_0_RCU_VFFCDSIZE_MASK    I40E_MASK(0x3, I40E_PFQF_CTL_0_RCU_VFFCDSIZE_SHIFT)

#define I40E_PFQF_DDPCNT               0x00246180 /* Reset: CORER */
#define I40E_PFQF_DDPCNT_DDP_CNT_SHIFT 0
#define I40E_PFQF_DDPCNT_DDP_CNT_MASK  I40E_MASK(0x1FFF, I40E_PFQF_DDPCNT_DDP_CNT_SHIFT)

#define I40E_PFQF_FCCNT_0                 0x00245E80 /* Reset: CORER */
#define I40E_PFQF_FCCNT_0_BUCKETCNT_SHIFT 0
#define I40E_PFQF_FCCNT_0_BUCKETCNT_MASK  I40E_MASK(0x1FFF, I40E_PFQF_FCCNT_0_BUCKETCNT_SHIFT)

#define I40E_PFQF_FCCNT_1                0x00245F80 /* Reset: PFR */
#define I40E_PFQF_FCCNT_1_HITSBCNT_SHIFT 0
#define I40E_PFQF_FCCNT_1_HITSBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_PFQF_FCCNT_1_HITSBCNT_SHIFT)

#define I40E_PFQF_FCCNT_2                0x00246080 /* Reset: PFR */
#define I40E_PFQF_FCCNT_2_HITLBCNT_SHIFT 0
#define I40E_PFQF_FCCNT_2_HITLBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_PFQF_FCCNT_2_HITLBCNT_SHIFT)

#define I40E_PFQF_HREGION(_i)                  (0x00245400 + ((_i) * 128)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PFQF_HREGION_MAX_INDEX            7
#define I40E_PFQF_HREGION_OVERRIDE_ENA_0_SHIFT 0
#define I40E_PFQF_HREGION_OVERRIDE_ENA_0_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_0_SHIFT)
#define I40E_PFQF_HREGION_REGION_0_SHIFT       1
#define I40E_PFQF_HREGION_REGION_0_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_0_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_1_SHIFT 4
#define I40E_PFQF_HREGION_OVERRIDE_ENA_1_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_1_SHIFT)
#define I40E_PFQF_HREGION_REGION_1_SHIFT       5
#define I40E_PFQF_HREGION_REGION_1_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_1_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_2_SHIFT 8
#define I40E_PFQF_HREGION_OVERRIDE_ENA_2_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_2_SHIFT)
#define I40E_PFQF_HREGION_REGION_2_SHIFT       9
#define I40E_PFQF_HREGION_REGION_2_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_2_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_3_SHIFT 12
#define I40E_PFQF_HREGION_OVERRIDE_ENA_3_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_3_SHIFT)
#define I40E_PFQF_HREGION_REGION_3_SHIFT       13
#define I40E_PFQF_HREGION_REGION_3_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_3_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_4_SHIFT 16
#define I40E_PFQF_HREGION_OVERRIDE_ENA_4_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_4_SHIFT)
#define I40E_PFQF_HREGION_REGION_4_SHIFT       17
#define I40E_PFQF_HREGION_REGION_4_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_4_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_5_SHIFT 20
#define I40E_PFQF_HREGION_OVERRIDE_ENA_5_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_5_SHIFT)
#define I40E_PFQF_HREGION_REGION_5_SHIFT       21
#define I40E_PFQF_HREGION_REGION_5_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_5_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_6_SHIFT 24
#define I40E_PFQF_HREGION_OVERRIDE_ENA_6_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_6_SHIFT)
#define I40E_PFQF_HREGION_REGION_6_SHIFT       25
#define I40E_PFQF_HREGION_REGION_6_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_6_SHIFT)
#define I40E_PFQF_HREGION_OVERRIDE_ENA_7_SHIFT 28
#define I40E_PFQF_HREGION_OVERRIDE_ENA_7_MASK  I40E_MASK(0x1, I40E_PFQF_HREGION_OVERRIDE_ENA_7_SHIFT)
#define I40E_PFQF_HREGION_REGION_7_SHIFT       29
#define I40E_PFQF_HREGION_REGION_7_MASK        I40E_MASK(0x7, I40E_PFQF_HREGION_REGION_7_SHIFT)

#define I40E_PFQF_PECNT_0                 0x00246480 /* Reset: CORER */
#define I40E_PFQF_PECNT_0_BUCKETCNT_SHIFT 0
#define I40E_PFQF_PECNT_0_BUCKETCNT_MASK  I40E_MASK(0x7FFFF, I40E_PFQF_PECNT_0_BUCKETCNT_SHIFT)

#define I40E_PFQF_PECNT_1                0x00246580 /* Reset: PFR */
#define I40E_PFQF_PECNT_1_HITSBCNT_SHIFT 0
#define I40E_PFQF_PECNT_1_HITSBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_PFQF_PECNT_1_HITSBCNT_SHIFT)

#define I40E_PFQF_PECNT_2                0x00246680 /* Reset: PFR */
#define I40E_PFQF_PECNT_2_HITLBCNT_SHIFT 0
#define I40E_PFQF_PECNT_2_HITLBCNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_PFQF_PECNT_2_HITLBCNT_SHIFT)

#define I40E_PFQF_PECNT_CNTX              0x0026CA80 /* Reset: CORER */
#define I40E_PFQF_PECNT_CNTX_FLTCNT_SHIFT 0
#define I40E_PFQF_PECNT_CNTX_FLTCNT_MASK  I40E_MASK(0x7FFFF, I40E_PFQF_PECNT_CNTX_FLTCNT_SHIFT)

#define I40E_PRTQF_FD_INSET(_i, _j)      (0x00250000 + ((_i) * 64 + (_j) * 32)) /* _i=0...63, _j=0...1 */ /* Reset: CORER */
#define I40E_PRTQF_FD_INSET_MAX_INDEX   63
#define I40E_PRTQF_FD_INSET_INSET_SHIFT 0
#define I40E_PRTQF_FD_INSET_INSET_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTQF_FD_INSET_INSET_SHIFT)

#define I40E_VPQF_CTL_RCU(_VF)          (0x00231C00 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPQF_CTL_RCU_MAX_INDEX     127
#define I40E_VPQF_CTL_RCU_PEHSIZE_SHIFT 0
#define I40E_VPQF_CTL_RCU_PEHSIZE_MASK  I40E_MASK(0x1F, I40E_VPQF_CTL_RCU_PEHSIZE_SHIFT)
#define I40E_VPQF_CTL_RCU_PEDSIZE_SHIFT 5
#define I40E_VPQF_CTL_RCU_PEDSIZE_MASK  I40E_MASK(0x1F, I40E_VPQF_CTL_RCU_PEDSIZE_SHIFT)
#define I40E_VPQF_CTL_RCU_FCHSIZE_SHIFT 10
#define I40E_VPQF_CTL_RCU_FCHSIZE_MASK  I40E_MASK(0xF, I40E_VPQF_CTL_RCU_FCHSIZE_SHIFT)
#define I40E_VPQF_CTL_RCU_FCDSIZE_SHIFT 14
#define I40E_VPQF_CTL_RCU_FCDSIZE_MASK  I40E_MASK(0x3, I40E_VPQF_CTL_RCU_FCDSIZE_SHIFT)

#define I40E_VPQF_DDPCNT1(_VF)          (0x00231400 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPQF_DDPCNT1_MAX_INDEX     127
#define I40E_VPQF_DDPCNT1_DDP_CNT_SHIFT 0
#define I40E_VPQF_DDPCNT1_DDP_CNT_MASK  I40E_MASK(0x1FFF, I40E_VPQF_DDPCNT1_DDP_CNT_SHIFT)

#define I40E_VPQF_FCCNT_0(_VF)            (0x0026A400 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPQF_FCCNT_0_MAX_INDEX       127
#define I40E_VPQF_FCCNT_0_BUCKETCNT_SHIFT 0
#define I40E_VPQF_FCCNT_0_BUCKETCNT_MASK  I40E_MASK(0x1FFF, I40E_VPQF_FCCNT_0_BUCKETCNT_SHIFT)

#define I40E_VPQF_PECNT_0(_VF)            (0x0026B400 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPQF_PECNT_0_MAX_INDEX       127
#define I40E_VPQF_PECNT_0_BUCKETCNT_SHIFT 0
#define I40E_VPQF_PECNT_0_BUCKETCNT_MASK  I40E_MASK(0x7FFFF, I40E_VPQF_PECNT_0_BUCKETCNT_SHIFT)

#define I40E_VPQF_PECNT_1(_VF)         (0x0026BC00 + ((_VF) * 4)) /* _i=0...127 */ /* Reset: CORER */
#define I40E_VPQF_PECNT_1_MAX_INDEX    127
#define I40E_VPQF_PECNT_1_FLTCNT_SHIFT 0
#define I40E_VPQF_PECNT_1_FLTCNT_MASK  I40E_MASK(0x7FFFF, I40E_VPQF_PECNT_1_FLTCNT_SHIFT)

/* PF - Statistics Registers  */

#define I40E_GLPRT_AORCH(_i)         (0x00300A44 + ((_i) * 8)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPRT_AORCH_MAX_INDEX   3
#define I40E_GLPRT_AORCH_AORCH_SHIFT 0
#define I40E_GLPRT_AORCH_AORCH_MASK  I40E_MASK(0xFFFF, I40E_GLPRT_AORCH_AORCH_SHIFT)

#define I40E_GLPRT_AORCL(_i)         (0x00300A40 + ((_i) * 8)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPRT_AORCL_MAX_INDEX   3
#define I40E_GLPRT_AORCL_VGORC_SHIFT 0
#define I40E_GLPRT_AORCL_VGORC_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPRT_AORCL_VGORC_SHIFT)

#define I40E_GLPRT_ERRBC(_i)         (0x003000C0 + ((_i) * 8)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPRT_ERRBC_MAX_INDEX   3
#define I40E_GLPRT_ERRBC_ERRBC_SHIFT 0
#define I40E_GLPRT_ERRBC_ERRBC_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPRT_ERRBC_ERRBC_SHIFT)

#define I40E_GLPRT_MSPDC(_i)         (0x00300060 + ((_i) * 8)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPRT_MSPDC_MAX_INDEX   3
#define I40E_GLPRT_MSPDC_MSPDC_SHIFT 0
#define I40E_GLPRT_MSPDC_MSPDC_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPRT_MSPDC_MSPDC_SHIFT)

#define I40E_GLPRT_STDC(_i)        (0x00300640 + ((_i) * 8)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLPRT_STDC_MAX_INDEX  3
#define I40E_GLPRT_STDC_STDC_SHIFT 0
#define I40E_GLPRT_STDC_STDC_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLPRT_STDC_STDC_SHIFT)

/* PF - Switch Registers */

#define I40E_EMP_MTG_FLU_ICH                       0x00269BE4 /* Reset: CORER */
#define I40E_EMP_MTG_FLU_ICH_PROTOCOL_ID_SHIFT     0
#define I40E_EMP_MTG_FLU_ICH_PROTOCOL_ID_MASK      I40E_MASK(0x3F, I40E_EMP_MTG_FLU_ICH_PROTOCOL_ID_SHIFT)
#define I40E_EMP_MTG_FLU_ICH_IGNORE_PROTOCOL_SHIFT 6
#define I40E_EMP_MTG_FLU_ICH_IGNORE_PROTOCOL_MASK  I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICH_IGNORE_PROTOCOL_SHIFT)
#define I40E_EMP_MTG_FLU_ICH_USE_MAN_SHIFT         7
#define I40E_EMP_MTG_FLU_ICH_USE_MAN_MASK          I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICH_USE_MAN_SHIFT)

#define I40E_EMP_MTG_FLU_ICL                    0x00269BDC /* Reset: CORER */
#define I40E_EMP_MTG_FLU_ICL_W0_OFFSET_SHIFT    0
#define I40E_EMP_MTG_FLU_ICL_W0_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_MTG_FLU_ICL_W0_OFFSET_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_W0_STATUS_SHIFT    6
#define I40E_EMP_MTG_FLU_ICL_W0_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_W0_STATUS_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_W1_OFFSET_SHIFT    8
#define I40E_EMP_MTG_FLU_ICL_W1_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_MTG_FLU_ICL_W1_OFFSET_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_W1_STATUS_SHIFT    14
#define I40E_EMP_MTG_FLU_ICL_W1_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_W1_STATUS_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_W2_OFFSET_SHIFT    16
#define I40E_EMP_MTG_FLU_ICL_W2_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_MTG_FLU_ICL_W2_OFFSET_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_W2_STATUS_SHIFT    22
#define I40E_EMP_MTG_FLU_ICL_W2_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_W2_STATUS_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_ETYPE_ENABLE_SHIFT 28
#define I40E_EMP_MTG_FLU_ICL_ETYPE_ENABLE_MASK  I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_ETYPE_ENABLE_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_IGNORE_PHASE_SHIFT 29
#define I40E_EMP_MTG_FLU_ICL_IGNORE_PHASE_MASK  I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_IGNORE_PHASE_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_EGRESS_SHIFT       30
#define I40E_EMP_MTG_FLU_ICL_EGRESS_MASK        I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_EGRESS_SHIFT)
#define I40E_EMP_MTG_FLU_ICL_PORT_ENABLE_SHIFT  31
#define I40E_EMP_MTG_FLU_ICL_PORT_ENABLE_MASK   I40E_MASK(0x1, I40E_EMP_MTG_FLU_ICL_PORT_ENABLE_SHIFT)

#define I40E_EMP_SWT_CCTRL                0x00269770 /* Reset: POR */
#define I40E_EMP_SWT_CCTRL_LLVSI_SHIFT    10
#define I40E_EMP_SWT_CCTRL_LLVSI_MASK     I40E_MASK(0x3FF, I40E_EMP_SWT_CCTRL_LLVSI_SHIFT)
#define I40E_EMP_SWT_CCTRL_PROXYVSI_SHIFT 20
#define I40E_EMP_SWT_CCTRL_PROXYVSI_MASK  I40E_MASK(0x3FF, I40E_EMP_SWT_CCTRL_PROXYVSI_SHIFT)

#define I40E_EMP_SWT_CGEN            0x0006D000 /* Reset: POR */
#define I40E_EMP_SWT_CGEN_GLEN_SHIFT 0
#define I40E_EMP_SWT_CGEN_GLEN_MASK  I40E_MASK(0x1, I40E_EMP_SWT_CGEN_GLEN_SHIFT)

#define I40E_EMP_SWT_CLLE(_i)               (0x00269790 + ((_i) * 4)) /* _i=0...3 */ /* Reset: POR */
#define I40E_EMP_SWT_CLLE_MAX_INDEX         3
#define I40E_EMP_SWT_CLLE_TAG_SHIFT         0
#define I40E_EMP_SWT_CLLE_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CLLE_TAG_SHIFT)
#define I40E_EMP_SWT_CLLE_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CLLE_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CLLE_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CLLE_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CLLE_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CLLE_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CLLE_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CLLE_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CLLE_ENABLE_SHIFT)

#define I40E_EMP_SWT_CMASK                        0x0006D180 /* Reset: POR */
#define I40E_EMP_SWT_CMASK_UNICASTTAGMASK_SHIFT   0
#define I40E_EMP_SWT_CMASK_UNICASTTAGMASK_MASK    I40E_MASK(0xFFFF, I40E_EMP_SWT_CMASK_UNICASTTAGMASK_SHIFT)
#define I40E_EMP_SWT_CMASK_MULTICASTTAGMASK_SHIFT 16
#define I40E_EMP_SWT_CMASK_MULTICASTTAGMASK_MASK  I40E_MASK(0xFFFF, I40E_EMP_SWT_CMASK_MULTICASTTAGMASK_SHIFT)

#define I40E_EMP_SWT_CMTTD(_i)          (0x0006E000 + ((_i) * 4)) /* _i=0...511 */ /* Reset: POR */
#define I40E_EMP_SWT_CMTTD_MAX_INDEX    511
#define I40E_EMP_SWT_CMTTD_PFLIST_SHIFT 0
#define I40E_EMP_SWT_CMTTD_PFLIST_MASK  I40E_MASK(0xFFFF, I40E_EMP_SWT_CMTTD_PFLIST_SHIFT)

#define I40E_EMP_SWT_CMTTL(_i)          (0x0006D800 + ((_i) * 4)) /* _i=0...511 */ /* Reset: POR */
#define I40E_EMP_SWT_CMTTL_MAX_INDEX    511
#define I40E_EMP_SWT_CMTTL_MTAG_SHIFT   0
#define I40E_EMP_SWT_CMTTL_MTAG_MASK    I40E_MASK(0xFFFF, I40E_EMP_SWT_CMTTL_MTAG_SHIFT)
#define I40E_EMP_SWT_CMTTL_PORT_SHIFT   16
#define I40E_EMP_SWT_CMTTL_PORT_MASK    I40E_MASK(0x3, I40E_EMP_SWT_CMTTL_PORT_SHIFT)
#define I40E_EMP_SWT_CMTTL_ENABLE_SHIFT 18
#define I40E_EMP_SWT_CMTTL_ENABLE_MASK  I40E_MASK(0x1, I40E_EMP_SWT_CMTTL_ENABLE_SHIFT)

#define I40E_EMP_SWT_COFFSET                          0x0006D200 /* Reset: POR */
#define I40E_EMP_SWT_COFFSET_UNICASTTAGOFFSET_SHIFT   0
#define I40E_EMP_SWT_COFFSET_UNICASTTAGOFFSET_MASK    I40E_MASK(0x1F, I40E_EMP_SWT_COFFSET_UNICASTTAGOFFSET_SHIFT)
#define I40E_EMP_SWT_COFFSET_RESERVED_2_SHIFT         5
#define I40E_EMP_SWT_COFFSET_RESERVED_2_MASK          I40E_MASK(0x7, I40E_EMP_SWT_COFFSET_RESERVED_2_SHIFT)
#define I40E_EMP_SWT_COFFSET_MULTICASTTAGOFFSET_SHIFT 8
#define I40E_EMP_SWT_COFFSET_MULTICASTTAGOFFSET_MASK  I40E_MASK(0x1F, I40E_EMP_SWT_COFFSET_MULTICASTTAGOFFSET_SHIFT)

#define I40E_EMP_SWT_CPFE(_i)               (0x001C09E0 + ((_i) * 4)) /* _i=0...15 */ /* Reset: POR */
#define I40E_EMP_SWT_CPFE_MAX_INDEX         15
#define I40E_EMP_SWT_CPFE_TAG_SHIFT         0
#define I40E_EMP_SWT_CPFE_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CPFE_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CPFE_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CPFE_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CPFE_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CPFE_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CPFE_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CPFE_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CPFE_ENABLE_SHIFT)

#define I40E_EMP_SWT_CPFE_RCU(_i)               (0x00269040 + ((_i) * 4)) /* _i=0...15 */ /* Reset: POR */
#define I40E_EMP_SWT_CPFE_RCU_MAX_INDEX         15
#define I40E_EMP_SWT_CPFE_RCU_TAG_SHIFT         0
#define I40E_EMP_SWT_CPFE_RCU_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CPFE_RCU_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_RCU_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CPFE_RCU_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CPFE_RCU_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_RCU_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CPFE_RCU_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CPFE_RCU_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CPFE_RCU_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CPFE_RCU_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CPFE_RCU_ENABLE_SHIFT)

#define I40E_EMP_SWT_CPFE_WUC(_i)               (0x0006D080 + ((_i) * 4)) /* _i=0...15 */ /* Reset: POR */
#define I40E_EMP_SWT_CPFE_WUC_MAX_INDEX         15
#define I40E_EMP_SWT_CPFE_WUC_TAG_SHIFT         0
#define I40E_EMP_SWT_CPFE_WUC_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CPFE_WUC_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_WUC_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CPFE_WUC_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CPFE_WUC_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CPFE_WUC_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CPFE_WUC_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CPFE_WUC_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CPFE_WUC_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CPFE_WUC_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CPFE_WUC_ENABLE_SHIFT)

#define I40E_EMP_SWT_CPTE(_i)               (0x002697B0 + ((_i) * 4)) /* _i=0...3 */ /* Reset: POR */
#define I40E_EMP_SWT_CPTE_MAX_INDEX         3
#define I40E_EMP_SWT_CPTE_TAG_SHIFT         0
#define I40E_EMP_SWT_CPTE_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CPTE_TAG_SHIFT)
#define I40E_EMP_SWT_CPTE_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CPTE_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CPTE_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CPTE_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CPTE_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CPTE_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CPTE_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CPTE_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CPTE_ENABLE_SHIFT)

#define I40E_EMP_SWT_CPTE2(_i)               (0x002697D0 + ((_i) * 4)) /* _i=0...3 */ /* Reset: POR */
#define I40E_EMP_SWT_CPTE2_MAX_INDEX         3
#define I40E_EMP_SWT_CPTE2_TAG_SHIFT         0
#define I40E_EMP_SWT_CPTE2_TAG_MASK          I40E_MASK(0xFFFF, I40E_EMP_SWT_CPTE2_TAG_SHIFT)
#define I40E_EMP_SWT_CPTE2_IGNORE_TAG_SHIFT  16
#define I40E_EMP_SWT_CPTE2_IGNORE_TAG_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CPTE2_IGNORE_TAG_SHIFT)
#define I40E_EMP_SWT_CPTE2_PORT_NUMBER_SHIFT 17
#define I40E_EMP_SWT_CPTE2_PORT_NUMBER_MASK  I40E_MASK(0x3, I40E_EMP_SWT_CPTE2_PORT_NUMBER_SHIFT)
#define I40E_EMP_SWT_CPTE2_ENABLE_SHIFT      31
#define I40E_EMP_SWT_CPTE2_ENABLE_MASK       I40E_MASK(0x1, I40E_EMP_SWT_CPTE2_ENABLE_SHIFT)

#define I40E_EMP_SWT_CTAG                 0x00269B64 /* Reset: POR */
#define I40E_EMP_SWT_CTAG_TAG_INDEX_SHIFT 0
#define I40E_EMP_SWT_CTAG_TAG_INDEX_MASK  I40E_MASK(0x3F, I40E_EMP_SWT_CTAG_TAG_INDEX_SHIFT)
#define I40E_EMP_SWT_CTAG_TAG_MASK_SHIFT  10
#define I40E_EMP_SWT_CTAG_TAG_MASK_MASK   I40E_MASK(0xFFFF, I40E_EMP_SWT_CTAG_TAG_MASK_SHIFT)

#define I40E_EMP_SWT_CUPD                            0x0006D100 /* Reset: POR */
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT0_PF_SHIFT    0
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT0_PF_MASK     I40E_MASK(0xF, I40E_EMP_SWT_CUPD_UNTAGGED_PORT0_PF_SHIFT)
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT1_PF_SHIFT    4
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT1_PF_MASK     I40E_MASK(0xF, I40E_EMP_SWT_CUPD_UNTAGGED_PORT1_PF_SHIFT)
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT2_PF_SHIFT    8
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT2_PF_MASK     I40E_MASK(0xF, I40E_EMP_SWT_CUPD_UNTAGGED_PORT2_PF_SHIFT)
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT3_PF_SHIFT    12
#define I40E_EMP_SWT_CUPD_UNTAGGED_PORT3_PF_MASK     I40E_MASK(0xF, I40E_EMP_SWT_CUPD_UNTAGGED_PORT3_PF_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT0_SHIFT  26
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT0_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT0_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT1_SHIFT  27
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT1_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT1_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT2_SHIFT  28
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT2_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT2_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT3_SHIFT  29
#define I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT3_MASK   I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNTAGGEDPORT3_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDUCTST_SHIFT 30
#define I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDUCTST_MASK  I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDUCTST_SHIFT)
#define I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDMCTST_SHIFT 31
#define I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDMCTST_MASK  I40E_MASK(0x1, I40E_EMP_SWT_CUPD_ACCEPTUNMATCHEDMCTST_SHIFT)

#define I40E_EMP_SWT_ETHMATCH                0x00269B6C /* Reset: POR */
#define I40E_EMP_SWT_ETHMATCH_ETHMATCH_SHIFT 0
#define I40E_EMP_SWT_ETHMATCH_ETHMATCH_MASK  I40E_MASK(0xFFFF, I40E_EMP_SWT_ETHMATCH_ETHMATCH_SHIFT)

#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0(_i)                   (0x002695E0 + ((_i) * 4)) /* _i=0...4 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_MAX_INDEX             4
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_PROTOCOL_ID_SHIFT     0
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_PROTOCOL_ID_MASK      I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICH_PHASE0_PROTOCOL_ID_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_IGNORE_PROTOCOL_SHIFT 6
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_IGNORE_PROTOCOL_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICH_PHASE0_IGNORE_PROTOCOL_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_USE_MAN_SHIFT         7
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE0_USE_MAN_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICH_PHASE0_USE_MAN_SHIFT)

#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1(_i)                   (0x00269660 + ((_i) * 4)) /* _i=0...4 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_MAX_INDEX             4
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_PROTOCOL_ID_SHIFT     0
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_PROTOCOL_ID_MASK      I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICH_PHASE1_PROTOCOL_ID_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_IGNORE_PROTOCOL_SHIFT 6
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_IGNORE_PROTOCOL_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICH_PHASE1_IGNORE_PROTOCOL_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_USE_MAN_SHIFT         7
#define I40E_EMP_SWT_FLU_L1_ICH_PHASE1_USE_MAN_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICH_PHASE1_USE_MAN_SHIFT)

#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0(_i)                (0x00269620 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_MAX_INDEX          6
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_OFFSET_SHIFT    0
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_STATUS_SHIFT    6
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W0_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_OFFSET_SHIFT    8
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_STATUS_SHIFT    14
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W1_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_OFFSET_SHIFT    16
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_STATUS_SHIFT    22
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_W2_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_ETYPE_ENABLE_SHIFT 28
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_ETYPE_ENABLE_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_ETYPE_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_IGNORE_PHASE_SHIFT 29
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_IGNORE_PHASE_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_IGNORE_PHASE_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_EGRESS_SHIFT       30
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_EGRESS_MASK        I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_EGRESS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_PORT_ENABLE_SHIFT  31
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE0_PORT_ENABLE_MASK   I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE0_PORT_ENABLE_SHIFT)

#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1(_i)                (0x002696A0 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_MAX_INDEX          6
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_OFFSET_SHIFT    0
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_STATUS_SHIFT    6
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W0_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_OFFSET_SHIFT    8
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_STATUS_SHIFT    14
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W1_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_OFFSET_SHIFT    16
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_OFFSET_MASK     I40E_MASK(0x3F, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_OFFSET_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_STATUS_SHIFT    22
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_STATUS_MASK     I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_W2_STATUS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_ETYPE_ENABLE_SHIFT 28
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_ETYPE_ENABLE_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_ETYPE_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_IGNORE_PHASE_SHIFT 29
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_IGNORE_PHASE_MASK  I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_IGNORE_PHASE_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_EGRESS_SHIFT       30
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_EGRESS_MASK        I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_EGRESS_SHIFT)
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_PORT_ENABLE_SHIFT  31
#define I40E_EMP_SWT_FLU_L1_ICL_PHASE1_PORT_ENABLE_MASK   I40E_MASK(0x1, I40E_EMP_SWT_FLU_L1_ICL_PHASE1_PORT_ENABLE_SHIFT)

#define I40E_EMP_SWT_FLU_L2_IC_PHASE0(_i)                         (0x002696E0 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_MAX_INDEX                   7
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_L1_OBJECT_TYPE_SHIFT 0
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_ENABLE_SHIFT         4
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD0_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_L1_OBJECT_TYPE_SHIFT 5
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_ENABLE_SHIFT         9
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD1_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_L1_OBJECT_TYPE_SHIFT 10
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_ENABLE_SHIFT         14
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_FIELD2_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_ETYPE_ENABLE_SHIFT          18
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_ETYPE_ENABLE_MASK           I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_ETYPE_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_IGNORE_PHASE_SHIFT          29
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_IGNORE_PHASE_MASK           I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_IGNORE_PHASE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_EGRESS_INGRESS_SHIFT        30
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_EGRESS_INGRESS_MASK         I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_EGRESS_INGRESS_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_PORT_ENABLE_SHIFT           31
#define I40E_EMP_SWT_FLU_L2_IC_PHASE0_PORT_ENABLE_MASK            I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE0_PORT_ENABLE_SHIFT)

#define I40E_EMP_SWT_FLU_L2_IC_PHASE1(_i)                         (0x00269720 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_MAX_INDEX                   7
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_L1_OBJECT_TYPE_SHIFT 0
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_ENABLE_SHIFT         4
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD0_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_L1_OBJECT_TYPE_SHIFT 5
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_ENABLE_SHIFT         9
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD1_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_L1_OBJECT_TYPE_SHIFT 10
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_L1_OBJECT_TYPE_MASK  I40E_MASK(0xF, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_L1_OBJECT_TYPE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_ENABLE_SHIFT         14
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_ENABLE_MASK          I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_FIELD2_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_ETYPE_ENABLE_SHIFT          18
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_ETYPE_ENABLE_MASK           I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_ETYPE_ENABLE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_IGNORE_PHASE_SHIFT          29
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_IGNORE_PHASE_MASK           I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_IGNORE_PHASE_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_EGRESS_INGRESS_SHIFT        30
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_EGRESS_INGRESS_MASK         I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_EGRESS_INGRESS_SHIFT)
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_PORT_ENABLE_SHIFT           31
#define I40E_EMP_SWT_FLU_L2_IC_PHASE1_PORT_ENABLE_MASK            I40E_MASK(0x1, I40E_EMP_SWT_FLU_L2_IC_PHASE1_PORT_ENABLE_SHIFT)

#define I40E_EMP_SWT_LOCMD(_i)           (0x00269460 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_EMP_SWT_LOCMD_MAX_INDEX     7
#define I40E_EMP_SWT_LOCMD_COMMAND_SHIFT 0
#define I40E_EMP_SWT_LOCMD_COMMAND_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_SWT_LOCMD_COMMAND_SHIFT)

#define I40E_EMP_SWT_LOFV(_i)               (0x00268D80 + ((_i) * 4)) /* _i=0...31 */ /* Reset: CORER */
#define I40E_EMP_SWT_LOFV_MAX_INDEX         31
#define I40E_EMP_SWT_LOFV_FIELDVECTOR_SHIFT 0
#define I40E_EMP_SWT_LOFV_FIELDVECTOR_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_SWT_LOFV_FIELDVECTOR_SHIFT)

#define I40E_EMP_SWT_MIREGVSI(_i, _j)             (0x00263000 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...383 */ /* Reset: CORER */
#define I40E_EMP_SWT_MIREGVSI_MAX_INDEX          1
#define I40E_EMP_SWT_MIREGVSI_ENABLEDRULES_SHIFT 0
#define I40E_EMP_SWT_MIREGVSI_ENABLEDRULES_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_SWT_MIREGVSI_ENABLEDRULES_SHIFT)

#define I40E_EMP_SWT_MIRIGVSI(_i, _j)             (0x00265000 + ((_i) * 4 + (_j) * 8)) /* _i=0...1, _j=0...383 */ /* Reset: CORER */
#define I40E_EMP_SWT_MIRIGVSI_MAX_INDEX          1
#define I40E_EMP_SWT_MIRIGVSI_ENABLEDRULES_SHIFT 0
#define I40E_EMP_SWT_MIRIGVSI_ENABLEDRULES_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_SWT_MIRIGVSI_ENABLEDRULES_SHIFT)

#define I40E_EMP_SWT_MIRTARVSI(_i)                (0x00268B00 + ((_i) * 4)) /* _i=0...63 */ /* Reset: CORER */
#define I40E_EMP_SWT_MIRTARVSI_MAX_INDEX          63
#define I40E_EMP_SWT_MIRTARVSI_TARGETVSI_SHIFT    0
#define I40E_EMP_SWT_MIRTARVSI_TARGETVSI_MASK     I40E_MASK(0x1FF, I40E_EMP_SWT_MIRTARVSI_TARGETVSI_SHIFT)
#define I40E_EMP_SWT_MIRTARVSI_VFVMNUMBER_SHIFT   9
#define I40E_EMP_SWT_MIRTARVSI_VFVMNUMBER_MASK    I40E_MASK(0x3FF, I40E_EMP_SWT_MIRTARVSI_VFVMNUMBER_SHIFT)
#define I40E_EMP_SWT_MIRTARVSI_PFNUMBER_SHIFT     19
#define I40E_EMP_SWT_MIRTARVSI_PFNUMBER_MASK      I40E_MASK(0xF, I40E_EMP_SWT_MIRTARVSI_PFNUMBER_SHIFT)
#define I40E_EMP_SWT_MIRTARVSI_FUNCTIONTYPE_SHIFT 23
#define I40E_EMP_SWT_MIRTARVSI_FUNCTIONTYPE_MASK  I40E_MASK(0x3, I40E_EMP_SWT_MIRTARVSI_FUNCTIONTYPE_SHIFT)
#define I40E_EMP_SWT_MIRTARVSI_RULEENABLE_SHIFT   31
#define I40E_EMP_SWT_MIRTARVSI_RULEENABLE_MASK    I40E_MASK(0x1, I40E_EMP_SWT_MIRTARVSI_RULEENABLE_SHIFT)

#define I40E_EMP_SWT_STS(_i)               (0x002692C0 + ((_i) * 4)) /* _i=0...9 */ /* Reset: CORER */
#define I40E_EMP_SWT_STS_MAX_INDEX         9
#define I40E_EMP_SWT_STS_EMP_SWT_STS_SHIFT 0
#define I40E_EMP_SWT_STS_EMP_SWT_STS_MASK  I40E_MASK(0xFFFFFFFF, I40E_EMP_SWT_STS_EMP_SWT_STS_SHIFT)

#define I40E_GL_MTG_FLU_MSK_L                0x00269F44 /* Reset: CORER */
#define I40E_GL_MTG_FLU_MSK_L_MASK_LOW_SHIFT 0
#define I40E_GL_MTG_FLU_MSK_L_MASK_LOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_MTG_FLU_MSK_L_MASK_LOW_SHIFT)

#define I40E_GL_PRE_FLU_MSK_PH0_H(_i)             (0x00269EA0 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_GL_PRE_FLU_MSK_PH0_H_MAX_INDEX       6
#define I40E_GL_PRE_FLU_MSK_PH0_H_MASK_HIGH_SHIFT 0
#define I40E_GL_PRE_FLU_MSK_PH0_H_MASK_HIGH_MASK  I40E_MASK(0xFFFF, I40E_GL_PRE_FLU_MSK_PH0_H_MASK_HIGH_SHIFT)

#define I40E_GL_PRE_FLU_MSK_PH0_L(_i)            (0x00269E60 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_GL_PRE_FLU_MSK_PH0_L_MAX_INDEX      6
#define I40E_GL_PRE_FLU_MSK_PH0_L_MASK_LOW_SHIFT 0
#define I40E_GL_PRE_FLU_MSK_PH0_L_MASK_LOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_FLU_MSK_PH0_L_MASK_LOW_SHIFT)

#define I40E_GL_PRE_FLU_MSK_PH1_H(_i)             (0x00269F20 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_GL_PRE_FLU_MSK_PH1_H_MAX_INDEX       6
#define I40E_GL_PRE_FLU_MSK_PH1_H_MASK_HIGH_SHIFT 0
#define I40E_GL_PRE_FLU_MSK_PH1_H_MASK_HIGH_MASK  I40E_MASK(0xFFFF, I40E_GL_PRE_FLU_MSK_PH1_H_MASK_HIGH_SHIFT)

#define I40E_GL_PRE_FLU_MSK_PH1_L(_i)            (0x00269EE0 + ((_i) * 4)) /* _i=0...6 */ /* Reset: CORER */
#define I40E_GL_PRE_FLU_MSK_PH1_L_MAX_INDEX      6
#define I40E_GL_PRE_FLU_MSK_PH1_L_MASK_LOW_SHIFT 0
#define I40E_GL_PRE_FLU_MSK_PH1_L_MASK_LOW_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_FLU_MSK_PH1_L_MASK_LOW_SHIFT)

#define I40E_GL_PRE_GEN_CFG                     0x002699A4 /* Reset: CORER */
#define I40E_GL_PRE_GEN_CFG_FILTER_ENABLE_SHIFT 0
#define I40E_GL_PRE_GEN_CFG_FILTER_ENABLE_MASK  I40E_MASK(0x1, I40E_GL_PRE_GEN_CFG_FILTER_ENABLE_SHIFT)
#define I40E_GL_PRE_GEN_CFG_HASH_MODE_SHIFT     6
#define I40E_GL_PRE_GEN_CFG_HASH_MODE_MASK      I40E_MASK(0x3, I40E_GL_PRE_GEN_CFG_HASH_MODE_SHIFT)

#define I40E_GL_PRE_PRX_BIG_ENT_D0                  0x002699C4 /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_IDX_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_SEL_SHIFT 6
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_VLD_SHIFT 7
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F0_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_IDX_SHIFT 8
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_SEL_SHIFT 14
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_VLD_SHIFT 15
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F1_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_VLD_SHIFT 16
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_SEL_SHIFT 22
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_IDX_SHIFT 23
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F2_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_VLD_SHIFT 24
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_IDX_SHIFT 31
#define I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D0_F3_SRC_IDX_SHIFT)

#define I40E_GL_PRE_PRX_BIG_ENT_D1                  0x002699D4 /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_IDX_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_SEL_SHIFT 6
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_VLD_SHIFT 7
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F4_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_IDX_SHIFT 8
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_SEL_SHIFT 14
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_VLD_SHIFT 15
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F5_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_VLD_SHIFT 16
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_SEL_SHIFT 22
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_SEL_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_IDX_SHIFT 23
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F6_SRC_IDX_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_VLD_SHIFT 24
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_VLD_SHIFT)
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_IDX_SHIFT 31
#define I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_BIG_ENT_D1_F7_SRC_IDX_SHIFT)

#define I40E_GL_PRE_PRX_BIG_ENT_D3                0x00269A0C /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_ENT_D3_BIT_MSK0_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_ENT_D3_BIT_MSK0_MASK  I40E_MASK(0xFF, I40E_GL_PRE_PRX_BIG_ENT_D3_BIT_MSK0_SHIFT)

#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D1          0x00269A34 /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D1_H1_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D1_H1_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_BIG_HSH_KEY_D1_H1_SHIFT)

#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D3          0x00269A54 /* Reset: CORER */
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D3_H3_SHIFT 0
#define I40E_GL_PRE_PRX_BIG_HSH_KEY_D3_H3_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_BIG_HSH_KEY_D3_H3_SHIFT)

#define I40E_GL_PRE_PRX_H_PHASE0                       0x00269B74 /* Reset: CORER */
#define I40E_GL_PRE_PRX_H_PHASE0_PROTOCOL_ID_SHIFT     0
#define I40E_GL_PRE_PRX_H_PHASE0_PROTOCOL_ID_MASK      I40E_MASK(0x3F, I40E_GL_PRE_PRX_H_PHASE0_PROTOCOL_ID_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE0_IGNORE_PROTOCOL_SHIFT 6
#define I40E_GL_PRE_PRX_H_PHASE0_IGNORE_PROTOCOL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_H_PHASE0_IGNORE_PROTOCOL_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE0_MASK0_INDEX_SHIFT     8
#define I40E_GL_PRE_PRX_H_PHASE0_MASK0_INDEX_MASK      I40E_MASK(0xF, I40E_GL_PRE_PRX_H_PHASE0_MASK0_INDEX_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE0_MASK1_INDEX_SHIFT     12
#define I40E_GL_PRE_PRX_H_PHASE0_MASK1_INDEX_MASK      I40E_MASK(0xF, I40E_GL_PRE_PRX_H_PHASE0_MASK1_INDEX_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE0_MASK0_BITS_SHIFT      16
#define I40E_GL_PRE_PRX_H_PHASE0_MASK0_BITS_MASK       I40E_MASK(0xFF, I40E_GL_PRE_PRX_H_PHASE0_MASK0_BITS_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE0_MASK1_BITS_SHIFT      24
#define I40E_GL_PRE_PRX_H_PHASE0_MASK1_BITS_MASK       I40E_MASK(0xFF, I40E_GL_PRE_PRX_H_PHASE0_MASK1_BITS_SHIFT)

#define I40E_GL_PRE_PRX_H_PHASE1                       0x00269B7C /* Reset: CORER */
#define I40E_GL_PRE_PRX_H_PHASE1_PROTOCOL_ID_SHIFT     0
#define I40E_GL_PRE_PRX_H_PHASE1_PROTOCOL_ID_MASK      I40E_MASK(0x3F, I40E_GL_PRE_PRX_H_PHASE1_PROTOCOL_ID_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE1_IGNORE_PROTOCOL_SHIFT 6
#define I40E_GL_PRE_PRX_H_PHASE1_IGNORE_PROTOCOL_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_H_PHASE1_IGNORE_PROTOCOL_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE1_MASK0_INDEX_SHIFT     8
#define I40E_GL_PRE_PRX_H_PHASE1_MASK0_INDEX_MASK      I40E_MASK(0xF, I40E_GL_PRE_PRX_H_PHASE1_MASK0_INDEX_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE1_MASK1_INDEX_SHIFT     12
#define I40E_GL_PRE_PRX_H_PHASE1_MASK1_INDEX_MASK      I40E_MASK(0xF, I40E_GL_PRE_PRX_H_PHASE1_MASK1_INDEX_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE1_MASK0_BITS_SHIFT      16
#define I40E_GL_PRE_PRX_H_PHASE1_MASK0_BITS_MASK       I40E_MASK(0xFF, I40E_GL_PRE_PRX_H_PHASE1_MASK0_BITS_SHIFT)
#define I40E_GL_PRE_PRX_H_PHASE1_MASK1_BITS_SHIFT      24
#define I40E_GL_PRE_PRX_H_PHASE1_MASK1_BITS_MASK       I40E_MASK(0xFF, I40E_GL_PRE_PRX_H_PHASE1_MASK1_BITS_SHIFT)

#define I40E_GL_PRE_PRX_HSH_KEY_D0          0x00269A24 /* Reset: CORER */
#define I40E_GL_PRE_PRX_HSH_KEY_D0_H0_SHIFT 0
#define I40E_GL_PRE_PRX_HSH_KEY_D0_H0_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_PRE_PRX_HSH_KEY_D0_H0_SHIFT)

#define I40E_GL_PRE_PRX_L_PHASE0                    0x00269B8C /* Reset: CORER */
#define I40E_GL_PRE_PRX_L_PHASE0_W0_OFFSET_SHIFT    0
#define I40E_GL_PRE_PRX_L_PHASE0_W0_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE0_W0_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W0_STATUS_SHIFT    6
#define I40E_GL_PRE_PRX_L_PHASE0_W0_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W0_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W0_VALID_SHIFT     7
#define I40E_GL_PRE_PRX_L_PHASE0_W0_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W0_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W1_OFFSET_SHIFT    8
#define I40E_GL_PRE_PRX_L_PHASE0_W1_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE0_W1_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W1_STATUS_SHIFT    14
#define I40E_GL_PRE_PRX_L_PHASE0_W1_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W1_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W1_VALID_SHIFT     15
#define I40E_GL_PRE_PRX_L_PHASE0_W1_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W1_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W2_OFFSET_SHIFT    16
#define I40E_GL_PRE_PRX_L_PHASE0_W2_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE0_W2_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W2_STATUS_SHIFT    22
#define I40E_GL_PRE_PRX_L_PHASE0_W2_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W2_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_W2_VALID_SHIFT     23
#define I40E_GL_PRE_PRX_L_PHASE0_W2_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_W2_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_ETYPE_ENABLE_SHIFT 28
#define I40E_GL_PRE_PRX_L_PHASE0_ETYPE_ENABLE_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_ETYPE_ENABLE_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_PRUNE_SHIFT        29
#define I40E_GL_PRE_PRX_L_PHASE0_PRUNE_MASK         I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_PRUNE_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_EGRESS_SHIFT       30
#define I40E_GL_PRE_PRX_L_PHASE0_EGRESS_MASK        I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_EGRESS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE0_PORT_ENABLE_SHIFT  31
#define I40E_GL_PRE_PRX_L_PHASE0_PORT_ENABLE_MASK   I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE0_PORT_ENABLE_SHIFT)

#define I40E_GL_PRE_PRX_L_PHASE1                    0x00269B84 /* Reset: CORER */
#define I40E_GL_PRE_PRX_L_PHASE1_W0_OFFSET_SHIFT    0
#define I40E_GL_PRE_PRX_L_PHASE1_W0_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE1_W0_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W0_STATUS_SHIFT    6
#define I40E_GL_PRE_PRX_L_PHASE1_W0_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W0_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W0_VALID_SHIFT     7
#define I40E_GL_PRE_PRX_L_PHASE1_W0_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W0_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W1_OFFSET_SHIFT    8
#define I40E_GL_PRE_PRX_L_PHASE1_W1_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE1_W1_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W1_STATUS_SHIFT    14
#define I40E_GL_PRE_PRX_L_PHASE1_W1_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W1_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W1_VALID_SHIFT     15
#define I40E_GL_PRE_PRX_L_PHASE1_W1_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W1_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W2_OFFSET_SHIFT    16
#define I40E_GL_PRE_PRX_L_PHASE1_W2_OFFSET_MASK     I40E_MASK(0x3F, I40E_GL_PRE_PRX_L_PHASE1_W2_OFFSET_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W2_STATUS_SHIFT    22
#define I40E_GL_PRE_PRX_L_PHASE1_W2_STATUS_MASK     I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W2_STATUS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_W2_VALID_SHIFT     23
#define I40E_GL_PRE_PRX_L_PHASE1_W2_VALID_MASK      I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_W2_VALID_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_ETYPE_ENABLE_SHIFT 28
#define I40E_GL_PRE_PRX_L_PHASE1_ETYPE_ENABLE_MASK  I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_ETYPE_ENABLE_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_PRUNE_SHIFT        29
#define I40E_GL_PRE_PRX_L_PHASE1_PRUNE_MASK         I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_PRUNE_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_EGRESS_SHIFT       30
#define I40E_GL_PRE_PRX_L_PHASE1_EGRESS_MASK        I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_EGRESS_SHIFT)
#define I40E_GL_PRE_PRX_L_PHASE1_PORT_ENABLE_SHIFT  31
#define I40E_GL_PRE_PRX_L_PHASE1_PORT_ENABLE_MASK   I40E_MASK(0x1, I40E_GL_PRE_PRX_L_PHASE1_PORT_ENABLE_SHIFT)

#define I40E_GL_SW_SWT_STS(_i)               (0x00269340 + ((_i) * 4)) /* _i=0...9 */ /* Reset: CORER */
#define I40E_GL_SW_SWT_STS_MAX_INDEX         9
#define I40E_GL_SW_SWT_STS_EMP_SWT_STS_SHIFT 0
#define I40E_GL_SW_SWT_STS_EMP_SWT_STS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SW_SWT_STS_EMP_SWT_STS_SHIFT)

#define I40E_GL_SWR_FILTERS_NEED_HIT(_i)                    (0x0026CF00 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GL_SWR_FILTERS_NEED_HIT_MAX_INDEX              1
#define I40E_GL_SWR_FILTERS_NEED_HIT_FILTERS_NEED_HIT_SHIFT 0
#define I40E_GL_SWR_FILTERS_NEED_HIT_FILTERS_NEED_HIT_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_FILTERS_NEED_HIT_FILTERS_NEED_HIT_SHIFT)

#define I40E_GL_SWR_FILTERS_NEED_MISS(_i)                     (0x0026CF10 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GL_SWR_FILTERS_NEED_MISS_MAX_INDEX               1
#define I40E_GL_SWR_FILTERS_NEED_MISS_FILTERS_NEED_MISS_SHIFT 0
#define I40E_GL_SWR_FILTERS_NEED_MISS_FILTERS_NEED_MISS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_FILTERS_NEED_MISS_FILTERS_NEED_MISS_SHIFT)

#define I40E_GL_SWR_HIT_FILTERS(_i)               (0x0026CF08 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GL_SWR_HIT_FILTERS_MAX_INDEX         1
#define I40E_GL_SWR_HIT_FILTERS_HIT_FILTERS_SHIFT 0
#define I40E_GL_SWR_HIT_FILTERS_HIT_FILTERS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_HIT_FILTERS_HIT_FILTERS_SHIFT)

#define I40E_GL_SWR_MISS_FILTERS(_i)                (0x0026CF18 + ((_i) * 4)) /* _i=0...1 */ /* Reset: CORER */
#define I40E_GL_SWR_MISS_FILTERS_MAX_INDEX          1
#define I40E_GL_SWR_MISS_FILTERS_MISS_FILTERS_SHIFT 0
#define I40E_GL_SWR_MISS_FILTERS_MISS_FILTERS_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_MISS_FILTERS_MISS_FILTERS_SHIFT)

#define I40E_GL_SWR_PRI_JOIN_MAP(_i)                  (0x0026CE20 + ((_i) * 4)) /* _i=0...8 */ /* Reset: CORER */
#define I40E_GL_SWR_PRI_JOIN_MAP_MAX_INDEX            8
#define I40E_GL_SWR_PRI_JOIN_MAP_GL_SWR_PRI_MAP_SHIFT 0
#define I40E_GL_SWR_PRI_JOIN_MAP_GL_SWR_PRI_MAP_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_PRI_JOIN_MAP_GL_SWR_PRI_MAP_SHIFT)

#define I40E_GL_SWR_PRI_MAP(_i)                  (0x0026CDE0 + ((_i) * 4)) /* _i=0...8 */ /* Reset: CORER */
#define I40E_GL_SWR_PRI_MAP_MAX_INDEX            8
#define I40E_GL_SWR_PRI_MAP_GL_SWR_PRI_MAP_SHIFT 0
#define I40E_GL_SWR_PRI_MAP_GL_SWR_PRI_MAP_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWR_PRI_MAP_GL_SWR_PRI_MAP_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0                  0x002699BC /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_IDX_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_SEL_SHIFT 6
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_VLD_SHIFT 7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F0_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_IDX_SHIFT 8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_SEL_SHIFT 14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_VLD_SHIFT 15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F1_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_VLD_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_SEL_SHIFT 22
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_IDX_SHIFT 23
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F2_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_VLD_SHIFT 24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_IDX_SHIFT 31
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D0_F3_SRC_IDX_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1                  0x002699CC /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_IDX_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_SEL_SHIFT 6
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_VLD_SHIFT 7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F4_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_IDX_SHIFT 8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_SEL_SHIFT 14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_VLD_SHIFT 15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F5_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_VLD_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_SEL_SHIFT 22
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_IDX_SHIFT 23
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F6_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_VLD_SHIFT 24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_IDX_SHIFT 31
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D1_F7_SRC_IDX_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2                 0x002699FC /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PHASE_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PHASE_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PHASE_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_INGR_SHIFT  1
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_INGR_MASK   I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_INGR_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PORT_SHIFT  7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PORT_MASK   I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_PORT_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_TR_INDEX_SHIFT  8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_TR_INDEX_MASK   I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_TR_INDEX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_MAN_SHIFT   14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_MAN_MASK    I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_MAN_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_TR_SHIFT    15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_TR_MASK     I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_USE_TR_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK0_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK0_MASK  I40E_MASK(0xF, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK0_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK1_SHIFT 20
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK1_MASK  I40E_MASK(0xF, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BYTE_MSK1_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BIT_MSK0_SHIFT  24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BIT_MSK0_MASK   I40E_MASK(0xFF, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D2_BIT_MSK0_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D3                0x00269A14 /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D3_BIT_MSK0_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D3_BIT_MSK0_MASK  I40E_MASK(0xFF, I40E_GL_SWT_FLU_BIG_ENT_PHASE0_D3_BIT_MSK0_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0                  0x002699DC /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_IDX_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_SEL_SHIFT 6
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_VLD_SHIFT 7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F0_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_IDX_SHIFT 8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_SEL_SHIFT 14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_VLD_SHIFT 15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F1_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_VLD_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_SEL_SHIFT 22
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_IDX_SHIFT 23
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F2_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_VLD_SHIFT 24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_IDX_SHIFT 31
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D0_F3_SRC_IDX_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1                  0x002699E4 /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_IDX_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_SEL_SHIFT 6
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_VLD_SHIFT 7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F4_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_IDX_SHIFT 8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_IDX_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_SEL_SHIFT 14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_VLD_SHIFT 15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_VLD_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F5_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_VLD_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_SEL_SHIFT 22
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_SEL_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_SEL_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_IDX_SHIFT 23
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F6_SRC_IDX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_VLD_SHIFT 24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_VLD_MASK  I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_VLD_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_IDX_SHIFT 31
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_IDX_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D1_F7_SRC_IDX_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2                 0x002699F4 /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PHASE_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PHASE_MASK  I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PHASE_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_INGR_SHIFT  1
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_INGR_MASK   I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_INGR_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PORT_SHIFT  7
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PORT_MASK   I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_PORT_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_TR_INDEX_SHIFT  8
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_TR_INDEX_MASK   I40E_MASK(0x3F, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_TR_INDEX_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_MAN_SHIFT   14
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_MAN_MASK    I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_MAN_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_TR_SHIFT    15
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_TR_MASK     I40E_MASK(0x1, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_USE_TR_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK0_SHIFT 16
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK0_MASK  I40E_MASK(0xF, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK0_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK1_SHIFT 20
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK1_MASK  I40E_MASK(0xF, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BYTE_MSK1_SHIFT)
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BIT_MSK0_SHIFT  24
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BIT_MSK0_MASK   I40E_MASK(0xFF, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D2_BIT_MSK0_SHIFT)

#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D3                0x00269A04 /* Reset: CORER */
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D3_BIT_MSK0_SHIFT 0
#define I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D3_BIT_MSK0_MASK  I40E_MASK(0xFF, I40E_GL_SWT_FLU_BIG_ENT_PHASE1_D3_BIT_MSK0_SHIFT)

#define I40E_GL_SWT_LOCMD_PE(_i)           (0x002694A0 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_LOCMD_PE_MAX_INDEX     7
#define I40E_GL_SWT_LOCMD_PE_COMMAND_SHIFT 0
#define I40E_GL_SWT_LOCMD_PE_COMMAND_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_LOCMD_PE_COMMAND_SHIFT)

#define I40E_GL_SWT_LOCMD_SW(_i)           (0x002694E0 + ((_i) * 4)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_GL_SWT_LOCMD_SW_MAX_INDEX     7
#define I40E_GL_SWT_LOCMD_SW_COMMAND_SHIFT 0
#define I40E_GL_SWT_LOCMD_SW_COMMAND_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_LOCMD_SW_COMMAND_SHIFT)

#define I40E_GL_SWT_LOFV_PE(_i)               (0x00268E80 + ((_i) * 4)) /* _i=0...31 */ /* Reset: CORER */
#define I40E_GL_SWT_LOFV_PE_MAX_INDEX         31
#define I40E_GL_SWT_LOFV_PE_FIELDVECTOR_SHIFT 0
#define I40E_GL_SWT_LOFV_PE_FIELDVECTOR_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_LOFV_PE_FIELDVECTOR_SHIFT)

#define I40E_GL_SWT_LOFV_SW(_i)               (0x00268F80 + ((_i) * 4)) /* _i=0...31 */ /* Reset: CORER */
#define I40E_GL_SWT_LOFV_SW_MAX_INDEX         31
#define I40E_GL_SWT_LOFV_SW_FIELDVECTOR_SHIFT 0
#define I40E_GL_SWT_LOFV_SW_FIELDVECTOR_MASK  I40E_MASK(0xFFFFFFFF, I40E_GL_SWT_LOFV_SW_FIELDVECTOR_SHIFT)

#define I40E_PRT_MSCCNT              0x00256BA0 /* Reset: CORER */
#define I40E_PRT_MSCCNT_CCOUNT_SHIFT 0
#define I40E_PRT_MSCCNT_CCOUNT_MASK  I40E_MASK(0x1FFFFFF, I40E_PRT_MSCCNT_CCOUNT_SHIFT)

#define I40E_PRT_SBPVSI                      0x00256BE0 /* Reset: CORER */
#define I40E_PRT_SBPVSI_BAD_FRAMES_VSI_SHIFT 0
#define I40E_PRT_SBPVSI_BAD_FRAMES_VSI_MASK  I40E_MASK(0x1FF, I40E_PRT_SBPVSI_BAD_FRAMES_VSI_SHIFT)
#define I40E_PRT_SBPVSI_SBP_SHIFT            31
#define I40E_PRT_SBPVSI_SBP_MASK             I40E_MASK(0x1, I40E_PRT_SBPVSI_SBP_SHIFT)

#define I40E_PRT_SCSTS             0x00256C20 /* Reset: CORER */
#define I40E_PRT_SCSTS_BSCA_SHIFT  0
#define I40E_PRT_SCSTS_BSCA_MASK   I40E_MASK(0x1, I40E_PRT_SCSTS_BSCA_SHIFT)
#define I40E_PRT_SCSTS_BSCAP_SHIFT 1
#define I40E_PRT_SCSTS_BSCAP_MASK  I40E_MASK(0x1, I40E_PRT_SCSTS_BSCAP_SHIFT)
#define I40E_PRT_SCSTS_MSCA_SHIFT  2
#define I40E_PRT_SCSTS_MSCA_MASK   I40E_MASK(0x1, I40E_PRT_SCSTS_MSCA_SHIFT)
#define I40E_PRT_SCSTS_MSCAP_SHIFT 3
#define I40E_PRT_SCSTS_MSCAP_MASK  I40E_MASK(0x1, I40E_PRT_SCSTS_MSCAP_SHIFT)

#define I40E_PRT_SWT_BSCCNT              0x00256C60 /* Reset: CORER */
#define I40E_PRT_SWT_BSCCNT_CCOUNT_SHIFT 0
#define I40E_PRT_SWT_BSCCNT_CCOUNT_MASK  I40E_MASK(0x1FFFFFF, I40E_PRT_SWT_BSCCNT_CCOUNT_SHIFT)

#define I40E_PRT_SWT_BSCTRH              0x00256CA0 /* Reset: CORER */
#define I40E_PRT_SWT_BSCTRH_UTRESH_SHIFT 0
#define I40E_PRT_SWT_BSCTRH_UTRESH_MASK  I40E_MASK(0x7FFFF, I40E_PRT_SWT_BSCTRH_UTRESH_SHIFT)

#define I40E_PRT_SWT_DEFPORTS                         0x00256CE0 /* Reset: CORER */
#define I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_SHIFT       0
#define I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_MASK        I40E_MASK(0x1FF, I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_SHIFT)
#define I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_VALID_SHIFT 31
#define I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_VALID_MASK  I40E_MASK(0x1, I40E_PRT_SWT_DEFPORTS_DEFAULT_VSI_VALID_SHIFT)

#define I40E_PRT_SWT_MSCTRH              0x00256D20 /* Reset: CORER */
#define I40E_PRT_SWT_MSCTRH_UTRESH_SHIFT 0
#define I40E_PRT_SWT_MSCTRH_UTRESH_MASK  I40E_MASK(0x7FFFF, I40E_PRT_SWT_MSCTRH_UTRESH_SHIFT)

#define I40E_PRT_SWT_SCBI          0x00256D60 /* Reset: CORER */
#define I40E_PRT_SWT_SCBI_BI_SHIFT 0
#define I40E_PRT_SWT_SCBI_BI_MASK  I40E_MASK(0x1FFFFFF, I40E_PRT_SWT_SCBI_BI_SHIFT)

#define I40E_PRT_SWT_SCCRL                0x00256DA0 /* Reset: CORER */
#define I40E_PRT_SWT_SCCRL_MDIPW_SHIFT    0
#define I40E_PRT_SWT_SCCRL_MDIPW_MASK     I40E_MASK(0x1, I40E_PRT_SWT_SCCRL_MDIPW_SHIFT)
#define I40E_PRT_SWT_SCCRL_MDICW_SHIFT    1
#define I40E_PRT_SWT_SCCRL_MDICW_MASK     I40E_MASK(0x1, I40E_PRT_SWT_SCCRL_MDICW_SHIFT)
#define I40E_PRT_SWT_SCCRL_BDIPW_SHIFT    2
#define I40E_PRT_SWT_SCCRL_BDIPW_MASK     I40E_MASK(0x1, I40E_PRT_SWT_SCCRL_BDIPW_SHIFT)
#define I40E_PRT_SWT_SCCRL_BDICW_SHIFT    3
#define I40E_PRT_SWT_SCCRL_BDICW_MASK     I40E_MASK(0x1, I40E_PRT_SWT_SCCRL_BDICW_SHIFT)
#define I40E_PRT_SWT_SCCRL_BIDU_SHIFT     4
#define I40E_PRT_SWT_SCCRL_BIDU_MASK      I40E_MASK(0x1, I40E_PRT_SWT_SCCRL_BIDU_SHIFT)
#define I40E_PRT_SWT_SCCRL_INTERVAL_SHIFT 8
#define I40E_PRT_SWT_SCCRL_INTERVAL_MASK  I40E_MASK(0x3FF, I40E_PRT_SWT_SCCRL_INTERVAL_SHIFT)

#define I40E_PRT_SWT_SCTC             0x00256DE0 /* Reset: CORER */
#define I40E_PRT_SWT_SCTC_COUNT_SHIFT 0
#define I40E_PRT_SWT_SCTC_COUNT_MASK  I40E_MASK(0x3FF, I40E_PRT_SWT_SCTC_COUNT_SHIFT)

#define I40E_PRT_SWT_SWITCHID                             0x00256E20 /* Reset: CORER */
#define I40E_PRT_SWT_SWITCHID_SWID_SHIFT                  0
#define I40E_PRT_SWT_SWITCHID_SWID_MASK                   I40E_MASK(0xFFF, I40E_PRT_SWT_SWITCHID_SWID_SHIFT)
#define I40E_PRT_SWT_SWITCHID_ISNSTAG_SHIFT               12
#define I40E_PRT_SWT_SWITCHID_ISNSTAG_MASK                I40E_MASK(0x1, I40E_PRT_SWT_SWITCHID_ISNSTAG_SHIFT)
#define I40E_PRT_SWT_SWITCHID_SWIDVALID_SHIFT             13
#define I40E_PRT_SWT_SWITCHID_SWIDVALID_MASK              I40E_MASK(0x1, I40E_PRT_SWT_SWITCHID_SWIDVALID_SHIFT)
#define I40E_PRT_SWT_SWITCHID_FORWARD_MUTICAST_ETAG_SHIFT 31
#define I40E_PRT_SWT_SWITCHID_FORWARD_MUTICAST_ETAG_MASK  I40E_MASK(0x1, I40E_PRT_SWT_SWITCHID_FORWARD_MUTICAST_ETAG_SHIFT)

#define I40E_PRT_TCTUPR(_i)       (0x00044000 + ((_i) * 32)) /* _i=0...7 */ /* Reset: CORER */
#define I40E_PRT_TCTUPR_MAX_INDEX 7
#define I40E_PRT_TCTUPR_UP0_SHIFT 0
#define I40E_PRT_TCTUPR_UP0_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP0_SHIFT)
#define I40E_PRT_TCTUPR_UP1_SHIFT 3
#define I40E_PRT_TCTUPR_UP1_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP1_SHIFT)
#define I40E_PRT_TCTUPR_UP2_SHIFT 6
#define I40E_PRT_TCTUPR_UP2_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP2_SHIFT)
#define I40E_PRT_TCTUPR_UP3_SHIFT 9
#define I40E_PRT_TCTUPR_UP3_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP3_SHIFT)
#define I40E_PRT_TCTUPR_UP4_SHIFT 12
#define I40E_PRT_TCTUPR_UP4_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP4_SHIFT)
#define I40E_PRT_TCTUPR_UP5_SHIFT 15
#define I40E_PRT_TCTUPR_UP5_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP5_SHIFT)
#define I40E_PRT_TCTUPR_UP6_SHIFT 18
#define I40E_PRT_TCTUPR_UP6_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP6_SHIFT)
#define I40E_PRT_TCTUPR_UP7_SHIFT 21
#define I40E_PRT_TCTUPR_UP7_MASK  I40E_MASK(0x7, I40E_PRT_TCTUPR_UP7_SHIFT)

/* PF - TimeSync (IEEE 1588) Registers  */

#define I40E_PRTTSYN_VFTIME_H                  0x001E4020 /* Reset: GLOBR */
#define I40E_PRTTSYN_VFTIME_H_TSYNTIME_H_SHIFT 0
#define I40E_PRTTSYN_VFTIME_H_TSYNTIME_H_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTTSYN_VFTIME_H_TSYNTIME_H_SHIFT)

#define I40E_PRTTSYN_VFTIME_L                  0x001E4000 /* Reset: GLOBR */
#define I40E_PRTTSYN_VFTIME_L_TSYNTIME_L_SHIFT 0
#define I40E_PRTTSYN_VFTIME_L_TSYNTIME_L_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTTSYN_VFTIME_L_TSYNTIME_L_SHIFT)

/* PF - Transmit Scheduler Registers */

#define I40E_GLSCD_BWLCREDUPDATE                     0x000B2148 /* Reset: CORER */
#define I40E_GLSCD_BWLCREDUPDATE_BWLCREDUPDATE_SHIFT 0
#define I40E_GLSCD_BWLCREDUPDATE_BWLCREDUPDATE_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_BWLCREDUPDATE_BWLCREDUPDATE_SHIFT)

#define I40E_GLSCD_BWLLINESPERARB                      0x000B214C /* Reset: CORER */
#define I40E_GLSCD_BWLLINESPERARB_BWLLINESPERARB_SHIFT 0
#define I40E_GLSCD_BWLLINESPERARB_BWLLINESPERARB_MASK  I40E_MASK(0x7FF, I40E_GLSCD_BWLLINESPERARB_BWLLINESPERARB_SHIFT)

#define I40E_GLSCD_CREDITSPERQUANTA                            0x000B2144 /* Reset: CORER */
#define I40E_GLSCD_CREDITSPERQUANTA_TSCDCREDITSPERQUANTA_SHIFT 0
#define I40E_GLSCD_CREDITSPERQUANTA_TSCDCREDITSPERQUANTA_MASK  I40E_MASK(0xFFFF, I40E_GLSCD_CREDITSPERQUANTA_TSCDCREDITSPERQUANTA_SHIFT)

#define I40E_GLSCD_ERRSTATREG                          0x000B2150 /* Reset: CORER */
#define I40E_GLSCD_ERRSTATREG_LOOP_DETECTED_SHIFT      0
#define I40E_GLSCD_ERRSTATREG_LOOP_DETECTED_MASK       I40E_MASK(0x1, I40E_GLSCD_ERRSTATREG_LOOP_DETECTED_SHIFT)
#define I40E_GLSCD_ERRSTATREG_SHRTBWLIMUPDATEPER_SHIFT 1
#define I40E_GLSCD_ERRSTATREG_SHRTBWLIMUPDATEPER_MASK  I40E_MASK(0x1, I40E_GLSCD_ERRSTATREG_SHRTBWLIMUPDATEPER_SHIFT)

#define I40E_GLSCD_IFBCMDH                       0x000B20A0 /* Reset: CORER */
#define I40E_GLSCD_IFBCMDH_FLDOFFS_NUMENTS_SHIFT 0
#define I40E_GLSCD_IFBCMDH_FLDOFFS_NUMENTS_MASK  I40E_MASK(0x7F, I40E_GLSCD_IFBCMDH_FLDOFFS_NUMENTS_SHIFT)
#define I40E_GLSCD_IFBCMDH_FLDSZ_SHIFT           7
#define I40E_GLSCD_IFBCMDH_FLDSZ_MASK            I40E_MASK(0x1F, I40E_GLSCD_IFBCMDH_FLDSZ_SHIFT)
#define I40E_GLSCD_IFBCMDH_VALUE_ENTRYIDX_SHIFT  12
#define I40E_GLSCD_IFBCMDH_VALUE_ENTRYIDX_MASK   I40E_MASK(0x7FFFF, I40E_GLSCD_IFBCMDH_VALUE_ENTRYIDX_SHIFT)
#define I40E_GLSCD_IFBCMDH_RSVD_SHIFT            31
#define I40E_GLSCD_IFBCMDH_RSVD_MASK             I40E_MASK(0x1, I40E_GLSCD_IFBCMDH_RSVD_SHIFT)

#define I40E_GLSCD_IFBCMDL                   0x000B209c /* Reset: CORER */
#define I40E_GLSCD_IFBCMDL_OPCODE_SHIFT      0
#define I40E_GLSCD_IFBCMDL_OPCODE_MASK       I40E_MASK(0xF, I40E_GLSCD_IFBCMDL_OPCODE_SHIFT)
#define I40E_GLSCD_IFBCMDL_TBLTYPE_SHIFT     4
#define I40E_GLSCD_IFBCMDL_TBLTYPE_MASK      I40E_MASK(0xF, I40E_GLSCD_IFBCMDL_TBLTYPE_SHIFT)
#define I40E_GLSCD_IFBCMDL_TBLENTRYIDX_SHIFT 8
#define I40E_GLSCD_IFBCMDL_TBLENTRYIDX_MASK  I40E_MASK(0x7FF, I40E_GLSCD_IFBCMDL_TBLENTRYIDX_SHIFT)
#define I40E_GLSCD_IFBCMDL_CTRLTYPE_SHIFT    19
#define I40E_GLSCD_IFBCMDL_CTRLTYPE_MASK     I40E_MASK(0x7, I40E_GLSCD_IFBCMDL_CTRLTYPE_SHIFT)
#define I40E_GLSCD_IFBCMDL_RSVD_SHIFT        22
#define I40E_GLSCD_IFBCMDL_RSVD_MASK         I40E_MASK(0x3FF, I40E_GLSCD_IFBCMDL_RSVD_SHIFT)

#define I40E_GLSCD_IFCTRL                          0x000B20A8 /* Reset: CORER */
#define I40E_GLSCD_IFCTRL_BCMDDB_SHIFT             0
#define I40E_GLSCD_IFCTRL_BCMDDB_MASK              I40E_MASK(0x1, I40E_GLSCD_IFCTRL_BCMDDB_SHIFT)
#define I40E_GLSCD_IFCTRL_ICMDCLRERR_SHIFT         1
#define I40E_GLSCD_IFCTRL_ICMDCLRERR_MASK          I40E_MASK(0x1, I40E_GLSCD_IFCTRL_ICMDCLRERR_SHIFT)
#define I40E_GLSCD_IFCTRL_BCMDCLRERR_SHIFT         2
#define I40E_GLSCD_IFCTRL_BCMDCLRERR_MASK          I40E_MASK(0x1, I40E_GLSCD_IFCTRL_BCMDCLRERR_SHIFT)
#define I40E_GLSCD_IFCTRL_SCH_ENA_SHIFT            3
#define I40E_GLSCD_IFCTRL_SCH_ENA_MASK             I40E_MASK(0x1, I40E_GLSCD_IFCTRL_SCH_ENA_SHIFT)
#define I40E_GLSCD_IFCTRL_SMALL_CRED_DISABLE_SHIFT 4
#define I40E_GLSCD_IFCTRL_SMALL_CRED_DISABLE_MASK  I40E_MASK(0x1, I40E_GLSCD_IFCTRL_SMALL_CRED_DISABLE_SHIFT)

#define I40E_GLSCD_IFDATA(_i)              (0x000B2084 + ((_i) * 4)) /* _i=0...3 */ /* Reset: CORER */
#define I40E_GLSCD_IFDATA_MAX_INDEX        3
#define I40E_GLSCD_IFDATA_TSCDIFDATA_SHIFT 0
#define I40E_GLSCD_IFDATA_TSCDIFDATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_IFDATA_TSCDIFDATA_SHIFT)

#define I40E_GLSCD_IFICMDH                       0x000B2098 /* Reset: CORER */
#define I40E_GLSCD_IFICMDH_FLDOFFS_NUMENTS_SHIFT 0
#define I40E_GLSCD_IFICMDH_FLDOFFS_NUMENTS_MASK  I40E_MASK(0x7F, I40E_GLSCD_IFICMDH_FLDOFFS_NUMENTS_SHIFT)
#define I40E_GLSCD_IFICMDH_FLDSZ_SHIFT           7
#define I40E_GLSCD_IFICMDH_FLDSZ_MASK            I40E_MASK(0x1F, I40E_GLSCD_IFICMDH_FLDSZ_SHIFT)
#define I40E_GLSCD_IFICMDH_VALUE_ENTRYIDX_SHIFT  12
#define I40E_GLSCD_IFICMDH_VALUE_ENTRYIDX_MASK   I40E_MASK(0x7FFFF, I40E_GLSCD_IFICMDH_VALUE_ENTRYIDX_SHIFT)
#define I40E_GLSCD_IFICMDH_RSVD_SHIFT            31
#define I40E_GLSCD_IFICMDH_RSVD_MASK             I40E_MASK(0x1, I40E_GLSCD_IFICMDH_RSVD_SHIFT)

#define I40E_GLSCD_IFICMDL                   0x000B2094 /* Reset: CORER */
#define I40E_GLSCD_IFICMDL_OPCODE_SHIFT      0
#define I40E_GLSCD_IFICMDL_OPCODE_MASK       I40E_MASK(0xF, I40E_GLSCD_IFICMDL_OPCODE_SHIFT)
#define I40E_GLSCD_IFICMDL_TBLTYPE_SHIFT     4
#define I40E_GLSCD_IFICMDL_TBLTYPE_MASK      I40E_MASK(0xF, I40E_GLSCD_IFICMDL_TBLTYPE_SHIFT)
#define I40E_GLSCD_IFICMDL_TBLENTRYIDX_SHIFT 8
#define I40E_GLSCD_IFICMDL_TBLENTRYIDX_MASK  I40E_MASK(0x7FF, I40E_GLSCD_IFICMDL_TBLENTRYIDX_SHIFT)
#define I40E_GLSCD_IFICMDL_CTRLTYPE_SHIFT    19
#define I40E_GLSCD_IFICMDL_CTRLTYPE_MASK     I40E_MASK(0x7, I40E_GLSCD_IFICMDL_CTRLTYPE_SHIFT)
#define I40E_GLSCD_IFICMDL_RSVD_SHIFT        22
#define I40E_GLSCD_IFICMDL_RSVD_MASK         I40E_MASK(0x3FF, I40E_GLSCD_IFICMDL_RSVD_SHIFT)

#define I40E_GLSCD_IFSTATUS                 0x000B20A4 /* Reset: CORER */
#define I40E_GLSCD_IFSTATUS_ENTRAVAIL_SHIFT 0
#define I40E_GLSCD_IFSTATUS_ENTRAVAIL_MASK  I40E_MASK(0x3F, I40E_GLSCD_IFSTATUS_ENTRAVAIL_SHIFT)
#define I40E_GLSCD_IFSTATUS_ICMDBZ_SHIFT    6
#define I40E_GLSCD_IFSTATUS_ICMDBZ_MASK     I40E_MASK(0x1, I40E_GLSCD_IFSTATUS_ICMDBZ_SHIFT)
#define I40E_GLSCD_IFSTATUS_ICMDERR_SHIFT   7
#define I40E_GLSCD_IFSTATUS_ICMDERR_MASK    I40E_MASK(0x1, I40E_GLSCD_IFSTATUS_ICMDERR_SHIFT)
#define I40E_GLSCD_IFSTATUS_BCMDERR_SHIFT   8
#define I40E_GLSCD_IFSTATUS_BCMDERR_MASK    I40E_MASK(0x1, I40E_GLSCD_IFSTATUS_BCMDERR_SHIFT)
#define I40E_GLSCD_IFSTATUS_SCH_ENA_SHIFT   9
#define I40E_GLSCD_IFSTATUS_SCH_ENA_MASK    I40E_MASK(0x1, I40E_GLSCD_IFSTATUS_SCH_ENA_SHIFT)
#define I40E_GLSCD_IFSTATUS_RSVD_SHIFT      10
#define I40E_GLSCD_IFSTATUS_RSVD_MASK       I40E_MASK(0x3FFFFF, I40E_GLSCD_IFSTATUS_RSVD_SHIFT)

#define I40E_GLSCD_INCSCHEDCFGCOUNT                        0x000B2140 /* Reset: CORER */
#define I40E_GLSCD_INCSCHEDCFGCOUNT_INCSCHEDCFGCOUNT_SHIFT 0
#define I40E_GLSCD_INCSCHEDCFGCOUNT_INCSCHEDCFGCOUNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_INCSCHEDCFGCOUNT_INCSCHEDCFGCOUNT_SHIFT)

#define I40E_GLSCD_LANTCBCMDS                     0x000B2154 /* Reset: CORER */
#define I40E_GLSCD_LANTCBCMDS_NUMLANTCBCMDS_SHIFT 0
#define I40E_GLSCD_LANTCBCMDS_NUMLANTCBCMDS_MASK  I40E_MASK(0x7F, I40E_GLSCD_LANTCBCMDS_NUMLANTCBCMDS_SHIFT)

#define I40E_GLSCD_LLPREALTHRESH                     0x000B213C /* Reset: CORER */
#define I40E_GLSCD_LLPREALTHRESH_LLPREALTHRESH_SHIFT 0
#define I40E_GLSCD_LLPREALTHRESH_LLPREALTHRESH_MASK  I40E_MASK(0xF, I40E_GLSCD_LLPREALTHRESH_LLPREALTHRESH_SHIFT)

#define I40E_GLSCD_PRGPERFCONTROL(_i)                  (0x000B20FC + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLSCD_PRGPERFCONTROL_MAX_INDEX            15
#define I40E_GLSCD_PRGPERFCONTROL_COUNTERTYPE_SHIFT    0
#define I40E_GLSCD_PRGPERFCONTROL_COUNTERTYPE_MASK     I40E_MASK(0x7, I40E_GLSCD_PRGPERFCONTROL_COUNTERTYPE_SHIFT)
#define I40E_GLSCD_PRGPERFCONTROL_RESOURCESELECT_SHIFT 4
#define I40E_GLSCD_PRGPERFCONTROL_RESOURCESELECT_MASK  I40E_MASK(0x3, I40E_GLSCD_PRGPERFCONTROL_RESOURCESELECT_SHIFT)
#define I40E_GLSCD_PRGPERFCONTROL_PORTINDEX_SHIFT      6
#define I40E_GLSCD_PRGPERFCONTROL_PORTINDEX_MASK       I40E_MASK(0x3, I40E_GLSCD_PRGPERFCONTROL_PORTINDEX_SHIFT)
#define I40E_GLSCD_PRGPERFCONTROL_TCINDEX_SHIFT        8
#define I40E_GLSCD_PRGPERFCONTROL_TCINDEX_MASK         I40E_MASK(0x7, I40E_GLSCD_PRGPERFCONTROL_TCINDEX_SHIFT)
#define I40E_GLSCD_PRGPERFCONTROL_QSINDEX_SHIFT        16
#define I40E_GLSCD_PRGPERFCONTROL_QSINDEX_MASK         I40E_MASK(0x3FF, I40E_GLSCD_PRGPERFCONTROL_QSINDEX_SHIFT)

#define I40E_GLSCD_PRGPERFCOUNT(_i)                (0x000B20BC + ((_i) * 4)) /* _i=0...15 */ /* Reset: CORER */
#define I40E_GLSCD_PRGPERFCOUNT_MAX_INDEX          15
#define I40E_GLSCD_PRGPERFCOUNT_PRGPERFCOUNT_SHIFT 0
#define I40E_GLSCD_PRGPERFCOUNT_PRGPERFCOUNT_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_PRGPERFCOUNT_PRGPERFCOUNT_SHIFT)

#define I40E_GLSCD_RAM_DBG_CTL(_i)          (0x000B28c0 + ((_i) * 4)) /* _i=0...9 */ /* Reset: POR */
#define I40E_GLSCD_RAM_DBG_CTL_MAX_INDEX    9
#define I40E_GLSCD_RAM_DBG_CTL_ADR_SHIFT    0
#define I40E_GLSCD_RAM_DBG_CTL_ADR_MASK     I40E_MASK(0x3FFFF, I40E_GLSCD_RAM_DBG_CTL_ADR_SHIFT)
#define I40E_GLSCD_RAM_DBG_CTL_DW_SEL_SHIFT 18
#define I40E_GLSCD_RAM_DBG_CTL_DW_SEL_MASK  I40E_MASK(0xFF, I40E_GLSCD_RAM_DBG_CTL_DW_SEL_SHIFT)
#define I40E_GLSCD_RAM_DBG_CTL_RD_EN_SHIFT  30
#define I40E_GLSCD_RAM_DBG_CTL_RD_EN_MASK   I40E_MASK(0x1, I40E_GLSCD_RAM_DBG_CTL_RD_EN_SHIFT)
#define I40E_GLSCD_RAM_DBG_CTL_DONE_SHIFT   31
#define I40E_GLSCD_RAM_DBG_CTL_DONE_MASK    I40E_MASK(0x1, I40E_GLSCD_RAM_DBG_CTL_DONE_SHIFT)

#define I40E_GLSCD_RAM_DBG_DATA(_i)                      (0x000b28e8 + ((_i) * 4)) /* _i=0...9 */ /* Reset: POR */
#define I40E_GLSCD_RAM_DBG_DATA_MAX_INDEX                9
#define I40E_GLSCD_RAM_DBG_DATA_GLSCD_RAM_DBG_DATA_SHIFT 0
#define I40E_GLSCD_RAM_DBG_DATA_GLSCD_RAM_DBG_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_RAM_DBG_DATA_GLSCD_RAM_DBG_DATA_SHIFT)

#define I40E_GLSCD_RLMTBLRD2CMD                 0x000B2158 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRD2CMD_RLMTBLIDX_SHIFT 0
#define I40E_GLSCD_RLMTBLRD2CMD_RLMTBLIDX_MASK  I40E_MASK(0x3FF, I40E_GLSCD_RLMTBLRD2CMD_RLMTBLIDX_SHIFT)

#define I40E_GLSCD_RLMTBLRD2DATAHI            0x000B2164 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRD2DATAHI_DATA_SHIFT 0
#define I40E_GLSCD_RLMTBLRD2DATAHI_DATA_MASK  I40E_MASK(0x7FFFFFF, I40E_GLSCD_RLMTBLRD2DATAHI_DATA_SHIFT)

#define I40E_GLSCD_RLMTBLRD2DATALO            0x000B2160 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRD2DATALO_DATA_SHIFT 0
#define I40E_GLSCD_RLMTBLRD2DATALO_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_RLMTBLRD2DATALO_DATA_SHIFT)

#define I40E_GLSCD_RLMTBLRD2STATUS             0x000B215C /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRD2STATUS_VALID_SHIFT 0
#define I40E_GLSCD_RLMTBLRD2STATUS_VALID_MASK  I40E_MASK(0x1, I40E_GLSCD_RLMTBLRD2STATUS_VALID_SHIFT)
#define I40E_GLSCD_RLMTBLRD2STATUS_RSVD_SHIFT  1
#define I40E_GLSCD_RLMTBLRD2STATUS_RSVD_MASK   I40E_MASK(0x7FFFFFFF, I40E_GLSCD_RLMTBLRD2STATUS_RSVD_SHIFT)

#define I40E_GLSCD_RLMTBLRDCMD                 0x000B20AC /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRDCMD_RLMTBLIDX_SHIFT 0
#define I40E_GLSCD_RLMTBLRDCMD_RLMTBLIDX_MASK  I40E_MASK(0x3FF, I40E_GLSCD_RLMTBLRDCMD_RLMTBLIDX_SHIFT)

#define I40E_GLSCD_RLMTBLRDDATAHI            0x000B20B8 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRDDATAHI_DATA_SHIFT 0
#define I40E_GLSCD_RLMTBLRDDATAHI_DATA_MASK  I40E_MASK(0x7FFFFFF, I40E_GLSCD_RLMTBLRDDATAHI_DATA_SHIFT)

#define I40E_GLSCD_RLMTBLRDDATALO            0x000B20B4 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRDDATALO_DATA_SHIFT 0
#define I40E_GLSCD_RLMTBLRDDATALO_DATA_MASK  I40E_MASK(0xFFFFFFFF, I40E_GLSCD_RLMTBLRDDATALO_DATA_SHIFT)

#define I40E_GLSCD_RLMTBLRDSTATUS             0x000B20B0 /* Reset: CORER */
#define I40E_GLSCD_RLMTBLRDSTATUS_VALID_SHIFT 0
#define I40E_GLSCD_RLMTBLRDSTATUS_VALID_MASK  I40E_MASK(0x1, I40E_GLSCD_RLMTBLRDSTATUS_VALID_SHIFT)
#define I40E_GLSCD_RLMTBLRDSTATUS_RSVD_SHIFT  1
#define I40E_GLSCD_RLMTBLRDSTATUS_RSVD_MASK   I40E_MASK(0x7FFFFFFF, I40E_GLSCD_RLMTBLRDSTATUS_RSVD_SHIFT)

#define I40E_PFSCD_DEFQSETHNDL                   0x000B2000 /* Reset: PFR */
#define I40E_PFSCD_DEFQSETHNDL_DEFQSETHNDL_SHIFT 0
#define I40E_PFSCD_DEFQSETHNDL_DEFQSETHNDL_MASK  I40E_MASK(0xFFFF, I40E_PFSCD_DEFQSETHNDL_DEFQSETHNDL_SHIFT)

/* PF - Virtualization PF Registers  */

#define I40E_GL_MDCK_RX                 0x0012A50C /* Reset: CORER */
#define I40E_GL_MDCK_RX_DESC_ADDR_SHIFT 0
#define I40E_GL_MDCK_RX_DESC_ADDR_MASK  I40E_MASK(0x1, I40E_GL_MDCK_RX_DESC_ADDR_SHIFT)

#define I40E_GL_MDCK_TCMD                         0x000E648C /* Reset: CORER */
#define I40E_GL_MDCK_TCMD_DESC_ADDR_SHIFT         0
#define I40E_GL_MDCK_TCMD_DESC_ADDR_MASK          I40E_MASK(0x1, I40E_GL_MDCK_TCMD_DESC_ADDR_SHIFT)
#define I40E_GL_MDCK_TCMD_MAX_BUFF_SHIFT          2
#define I40E_GL_MDCK_TCMD_MAX_BUFF_MASK           I40E_MASK(0x1, I40E_GL_MDCK_TCMD_MAX_BUFF_SHIFT)
#define I40E_GL_MDCK_TCMD_MAX_HEAD_SHIFT          3
#define I40E_GL_MDCK_TCMD_MAX_HEAD_MASK           I40E_MASK(0x1, I40E_GL_MDCK_TCMD_MAX_HEAD_SHIFT)
#define I40E_GL_MDCK_TCMD_NO_HEAD_SHIFT           4
#define I40E_GL_MDCK_TCMD_NO_HEAD_MASK            I40E_MASK(0x1, I40E_GL_MDCK_TCMD_NO_HEAD_SHIFT)
#define I40E_GL_MDCK_TCMD_TOO_LONG_SHIFT          5
#define I40E_GL_MDCK_TCMD_TOO_LONG_MASK           I40E_MASK(0x1, I40E_GL_MDCK_TCMD_TOO_LONG_SHIFT)
#define I40E_GL_MDCK_TCMD_SINGLE_TX_SIZE_SHIFT    6
#define I40E_GL_MDCK_TCMD_SINGLE_TX_SIZE_MASK     I40E_MASK(0x1, I40E_GL_MDCK_TCMD_SINGLE_TX_SIZE_SHIFT)
#define I40E_GL_MDCK_TCMD_ENDLESS_TX_SHIFT        7
#define I40E_GL_MDCK_TCMD_ENDLESS_TX_MASK         I40E_MASK(0x1, I40E_GL_MDCK_TCMD_ENDLESS_TX_SHIFT)
#define I40E_GL_MDCK_TCMD_BAD_LSO_LEN_SHIFT       8
#define I40E_GL_MDCK_TCMD_BAD_LSO_LEN_MASK        I40E_MASK(0x1, I40E_GL_MDCK_TCMD_BAD_LSO_LEN_SHIFT)
#define I40E_GL_MDCK_TCMD_BAD_LSO_MSS_SHIFT       9
#define I40E_GL_MDCK_TCMD_BAD_LSO_MSS_MASK        I40E_MASK(0x1, I40E_GL_MDCK_TCMD_BAD_LSO_MSS_SHIFT)
#define I40E_GL_MDCK_TCMD_M_CONTEXTS_SHIFT        12
#define I40E_GL_MDCK_TCMD_M_CONTEXTS_MASK         I40E_MASK(0x1, I40E_GL_MDCK_TCMD_M_CONTEXTS_SHIFT)
#define I40E_GL_MDCK_TCMD_BAD_DESC_SEQUENCE_SHIFT 13
#define I40E_GL_MDCK_TCMD_BAD_DESC_SEQUENCE_MASK  I40E_MASK(0x1, I40E_GL_MDCK_TCMD_BAD_DESC_SEQUENCE_SHIFT)
#define I40E_GL_MDCK_TCMD_BAD_FC_FD_DESC_SHIFT    14
#define I40E_GL_MDCK_TCMD_BAD_FC_FD_DESC_MASK     I40E_MASK(0x1, I40E_GL_MDCK_TCMD_BAD_FC_FD_DESC_SHIFT)
#define I40E_GL_MDCK_TCMD_NO_PACKET_SHIFT         15
#define I40E_GL_MDCK_TCMD_NO_PACKET_MASK          I40E_MASK(0x1, I40E_GL_MDCK_TCMD_NO_PACKET_SHIFT)
#define I40E_GL_MDCK_TCMD_DIS_DIF_DIX_SHIFT       16
#define I40E_GL_MDCK_TCMD_DIS_DIF_DIX_MASK        I40E_MASK(0x1, I40E_GL_MDCK_TCMD_DIS_DIF_DIX_SHIFT)
#define I40E_GL_MDCK_TCMD_DIS_FLEX_SHIFT          17
#define I40E_GL_MDCK_TCMD_DIS_FLEX_MASK           I40E_MASK(0x1, I40E_GL_MDCK_TCMD_DIS_FLEX_SHIFT)
#define I40E_GL_MDCK_TCMD_ZERO_BSIZE_SHIFT        18
#define I40E_GL_MDCK_TCMD_ZERO_BSIZE_MASK         I40E_MASK(0x1, I40E_GL_MDCK_TCMD_ZERO_BSIZE_SHIFT)

#define I40E_GL_MDCK_TDAT                      0x000442F4 /* Reset: CORER */
#define I40E_GL_MDCK_TDAT_BIG_OFFSET_SHIFT     0
#define I40E_GL_MDCK_TDAT_BIG_OFFSET_MASK      I40E_MASK(0x1, I40E_GL_MDCK_TDAT_BIG_OFFSET_SHIFT)
#define I40E_GL_MDCK_TDAT_BUFF_ADDR_SHIFT      1
#define I40E_GL_MDCK_TDAT_BUFF_ADDR_MASK       I40E_MASK(0x1, I40E_GL_MDCK_TDAT_BUFF_ADDR_SHIFT)
#define I40E_GL_MDCK_TDAT_MAL_LENGTH_DIS_SHIFT 2
#define I40E_GL_MDCK_TDAT_MAL_LENGTH_DIS_MASK  I40E_MASK(0x1, I40E_GL_MDCK_TDAT_MAL_LENGTH_DIS_SHIFT)
#define I40E_GL_MDCK_TDAT_MAL_CMD_DIS_SHIFT    3
#define I40E_GL_MDCK_TDAT_MAL_CMD_DIS_MASK     I40E_MASK(0x1, I40E_GL_MDCK_TDAT_MAL_CMD_DIS_SHIFT)

#define I40E_PF_VIRT_VSTATUS                  0x0009C400 /* Reset: PFR */
#define I40E_PF_VIRT_VSTATUS_NUM_VFS_SHIFT    0
#define I40E_PF_VIRT_VSTATUS_NUM_VFS_MASK     I40E_MASK(0xFF, I40E_PF_VIRT_VSTATUS_NUM_VFS_SHIFT)
#define I40E_PF_VIRT_VSTATUS_TOTAL_VFS_SHIFT  8
#define I40E_PF_VIRT_VSTATUS_TOTAL_VFS_MASK   I40E_MASK(0xFF, I40E_PF_VIRT_VSTATUS_TOTAL_VFS_SHIFT)
#define I40E_PF_VIRT_VSTATUS_IOV_ACTIVE_SHIFT 16
#define I40E_PF_VIRT_VSTATUS_IOV_ACTIVE_MASK  I40E_MASK(0x1, I40E_PF_VIRT_VSTATUS_IOV_ACTIVE_SHIFT)

#define I40E_PF_VT_PFALLOC_CSR               0x00078D80 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_CSR_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_CSR_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_CSR_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_CSR_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_CSR_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_CSR_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_CSR_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_CSR_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_CSR_VALID_SHIFT)

#define I40E_PF_VT_PFALLOC_INT               0x0003F080 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_INT_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_INT_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_INT_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_INT_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_INT_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_INT_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_INT_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_INT_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_INT_VALID_SHIFT)

#define I40E_PF_VT_PFALLOC_PMAT               0x000C0680 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_PMAT_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_PMAT_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_PMAT_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_PMAT_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_PMAT_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_PMAT_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_PMAT_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_PMAT_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_PMAT_VALID_SHIFT)

#define I40E_PF_VT_PFALLOC_TSCD               0x000B2280 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_TSCD_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_TSCD_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_TSCD_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_TSCD_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_TSCD_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_TSCD_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_TSCD_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_TSCD_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_TSCD_VALID_SHIFT)

#define I40E_PF_VT_PFALLOC_VMLR               0x00092580 /* Reset: CORER */
#define I40E_PF_VT_PFALLOC_VMLR_FIRSTVF_SHIFT 0
#define I40E_PF_VT_PFALLOC_VMLR_FIRSTVF_MASK  I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_VMLR_FIRSTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_VMLR_LASTVF_SHIFT  8
#define I40E_PF_VT_PFALLOC_VMLR_LASTVF_MASK   I40E_MASK(0xFF, I40E_PF_VT_PFALLOC_VMLR_LASTVF_SHIFT)
#define I40E_PF_VT_PFALLOC_VMLR_VALID_SHIFT   31
#define I40E_PF_VT_PFALLOC_VMLR_VALID_MASK    I40E_MASK(0x1, I40E_PF_VT_PFALLOC_VMLR_VALID_SHIFT)

/* PF - VSI Context */

#define I40E_VSI_L2TAGSTXVALID(_VSI)                      (0x00042800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_L2TAGSTXVALID_MAX_INDEX                  383
#define I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_SHIFT       0
#define I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_MASK        I40E_MASK(0x7, I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_VALID_SHIFT 3
#define I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_VALID_MASK  I40E_MASK(0x1, I40E_VSI_L2TAGSTXVALID_L2TAG1INSERTID_VALID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_SHIFT       4
#define I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_MASK        I40E_MASK(0x7, I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_VALID_SHIFT 7
#define I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_VALID_MASK  I40E_MASK(0x1, I40E_VSI_L2TAGSTXVALID_L2TAG2INSERTID_VALID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR0INSERTID_SHIFT         16
#define I40E_VSI_L2TAGSTXVALID_TIR0INSERTID_MASK          I40E_MASK(0x7, I40E_VSI_L2TAGSTXVALID_TIR0INSERTID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR0_INSERT_SHIFT          19
#define I40E_VSI_L2TAGSTXVALID_TIR0_INSERT_MASK           I40E_MASK(0x1, I40E_VSI_L2TAGSTXVALID_TIR0_INSERT_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR1INSERTID_SHIFT         20
#define I40E_VSI_L2TAGSTXVALID_TIR1INSERTID_MASK          I40E_MASK(0x7, I40E_VSI_L2TAGSTXVALID_TIR1INSERTID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR1_INSERT_SHIFT          23
#define I40E_VSI_L2TAGSTXVALID_TIR1_INSERT_MASK           I40E_MASK(0x1, I40E_VSI_L2TAGSTXVALID_TIR1_INSERT_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR2INSERTID_SHIFT         24
#define I40E_VSI_L2TAGSTXVALID_TIR2INSERTID_MASK          I40E_MASK(0x7, I40E_VSI_L2TAGSTXVALID_TIR2INSERTID_SHIFT)
#define I40E_VSI_L2TAGSTXVALID_TIR2_INSERT_SHIFT          27
#define I40E_VSI_L2TAGSTXVALID_TIR2_INSERT_MASK           I40E_MASK(0x1, I40E_VSI_L2TAGSTXVALID_TIR2_INSERT_SHIFT)

#define I40E_VSI_PORT(_VSI)          (0x000B22C0 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_PORT_MAX_INDEX      383
#define I40E_VSI_PORT_PORT_NUM_SHIFT 0
#define I40E_VSI_PORT_PORT_NUM_MASK  I40E_MASK(0x3, I40E_VSI_PORT_PORT_NUM_SHIFT)

#define I40E_VSI_RUPR(_VSI)     (0x00050000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_RUPR_MAX_INDEX 383
#define I40E_VSI_RUPR_UP0_SHIFT 0
#define I40E_VSI_RUPR_UP0_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP0_SHIFT)
#define I40E_VSI_RUPR_UP1_SHIFT 3
#define I40E_VSI_RUPR_UP1_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP1_SHIFT)
#define I40E_VSI_RUPR_UP2_SHIFT 6
#define I40E_VSI_RUPR_UP2_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP2_SHIFT)
#define I40E_VSI_RUPR_UP3_SHIFT 9
#define I40E_VSI_RUPR_UP3_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP3_SHIFT)
#define I40E_VSI_RUPR_UP4_SHIFT 12
#define I40E_VSI_RUPR_UP4_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP4_SHIFT)
#define I40E_VSI_RUPR_UP5_SHIFT 15
#define I40E_VSI_RUPR_UP5_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP5_SHIFT)
#define I40E_VSI_RUPR_UP6_SHIFT 18
#define I40E_VSI_RUPR_UP6_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP6_SHIFT)
#define I40E_VSI_RUPR_UP7_SHIFT 21
#define I40E_VSI_RUPR_UP7_MASK  I40E_MASK(0x7, I40E_VSI_RUPR_UP7_SHIFT)

#define I40E_VSI_RXSWCTRL(_VSI)                   (0x00208800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_RXSWCTRL_MAX_INDEX               383
#define I40E_VSI_RXSWCTRL_MACVSIPRUNEENABLE_SHIFT 0
#define I40E_VSI_RXSWCTRL_MACVSIPRUNEENABLE_MASK  I40E_MASK(0x1, I40E_VSI_RXSWCTRL_MACVSIPRUNEENABLE_SHIFT)
#define I40E_VSI_RXSWCTRL_VLANPRUNEENABLE_SHIFT   1
#define I40E_VSI_RXSWCTRL_VLANPRUNEENABLE_MASK    I40E_MASK(0x1, I40E_VSI_RXSWCTRL_VLANPRUNEENABLE_SHIFT)

#define I40E_VSI_SRCSWCTRL(_VSI)                   (0x00209800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_SRCSWCTRL_MAX_INDEX               383
#define I40E_VSI_SRCSWCTRL_SWID_SHIFT              0
#define I40E_VSI_SRCSWCTRL_SWID_MASK               I40E_MASK(0xFFF, I40E_VSI_SRCSWCTRL_SWID_SHIFT)
#define I40E_VSI_SRCSWCTRL_ISNSTAG_SHIFT           12
#define I40E_VSI_SRCSWCTRL_ISNSTAG_MASK            I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_ISNSTAG_SHIFT)
#define I40E_VSI_SRCSWCTRL_SWIDVALID_SHIFT         17
#define I40E_VSI_SRCSWCTRL_SWIDVALID_MASK          I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_SWIDVALID_SHIFT)
#define I40E_VSI_SRCSWCTRL_ALLOWDESTOVERRIDE_SHIFT 19
#define I40E_VSI_SRCSWCTRL_ALLOWDESTOVERRIDE_MASK  I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_ALLOWDESTOVERRIDE_SHIFT)
#define I40E_VSI_SRCSWCTRL_ALLOWLOOPBACK_SHIFT     20
#define I40E_VSI_SRCSWCTRL_ALLOWLOOPBACK_MASK      I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_ALLOWLOOPBACK_SHIFT)
#define I40E_VSI_SRCSWCTRL_LANENABLE_SHIFT         21
#define I40E_VSI_SRCSWCTRL_LANENABLE_MASK          I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_LANENABLE_SHIFT)
#define I40E_VSI_SRCSWCTRL_VLANAS_SHIFT            22
#define I40E_VSI_SRCSWCTRL_VLANAS_MASK             I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_VLANAS_SHIFT)
#define I40E_VSI_SRCSWCTRL_MACAS_SHIFT             23
#define I40E_VSI_SRCSWCTRL_MACAS_MASK              I40E_MASK(0x1, I40E_VSI_SRCSWCTRL_MACAS_SHIFT)

#define I40E_VSI_TAIR(_VSI)             (0x00041800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TAIR_MAX_INDEX         383
#define I40E_VSI_TAIR_PORT_TAG_ID_SHIFT 0
#define I40E_VSI_TAIR_PORT_TAG_ID_MASK  I40E_MASK(0xFFFF, I40E_VSI_TAIR_PORT_TAG_ID_SHIFT)

#define I40E_VSI_TAR(_VSI)                (0x00042000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TAR_MAX_INDEX            383
#define I40E_VSI_TAR_ACCEPTTAGGED_SHIFT   0
#define I40E_VSI_TAR_ACCEPTTAGGED_MASK    I40E_MASK(0x3FF, I40E_VSI_TAR_ACCEPTTAGGED_SHIFT)
#define I40E_VSI_TAR_ACCEPTUNTAGGED_SHIFT 16
#define I40E_VSI_TAR_ACCEPTUNTAGGED_MASK  I40E_MASK(0x3FF, I40E_VSI_TAR_ACCEPTUNTAGGED_SHIFT)

#define I40E_VSI_TIR_0(_VSI)             (0x00040000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TIR_0_MAX_INDEX         383
#define I40E_VSI_TIR_0_PORT_TAG_ID_SHIFT 0
#define I40E_VSI_TIR_0_PORT_TAG_ID_MASK  I40E_MASK(0xFFFF, I40E_VSI_TIR_0_PORT_TAG_ID_SHIFT)

#define I40E_VSI_TIR_1(_VSI)             (0x00040800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TIR_1_MAX_INDEX         383
#define I40E_VSI_TIR_1_PORT_TAG_ID_SHIFT 0
#define I40E_VSI_TIR_1_PORT_TAG_ID_MASK  I40E_MASK(0xFFFFFFFF, I40E_VSI_TIR_1_PORT_TAG_ID_SHIFT)

#define I40E_VSI_TIR_2(_VSI)             (0x00041000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TIR_2_MAX_INDEX         383
#define I40E_VSI_TIR_2_PORT_TAG_ID_SHIFT 0
#define I40E_VSI_TIR_2_PORT_TAG_ID_MASK  I40E_MASK(0xFFFF, I40E_VSI_TIR_2_PORT_TAG_ID_SHIFT)

#define I40E_VSI_TSR(_VSI)             (0x00050800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TSR_MAX_INDEX         383
#define I40E_VSI_TSR_STRIPTAG_SHIFT    0
#define I40E_VSI_TSR_STRIPTAG_MASK     I40E_MASK(0x3FF, I40E_VSI_TSR_STRIPTAG_SHIFT)
#define I40E_VSI_TSR_SHOWTAG_SHIFT     10
#define I40E_VSI_TSR_SHOWTAG_MASK      I40E_MASK(0x3FF, I40E_VSI_TSR_SHOWTAG_SHIFT)
#define I40E_VSI_TSR_SHOWPRIONLY_SHIFT 20
#define I40E_VSI_TSR_SHOWPRIONLY_MASK  I40E_MASK(0x3FF, I40E_VSI_TSR_SHOWPRIONLY_SHIFT)

#define I40E_VSI_TUPIOM(_VSI)     (0x00043800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TUPIOM_MAX_INDEX 383
#define I40E_VSI_TUPIOM_UP0_SHIFT 0
#define I40E_VSI_TUPIOM_UP0_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP0_SHIFT)
#define I40E_VSI_TUPIOM_UP1_SHIFT 3
#define I40E_VSI_TUPIOM_UP1_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP1_SHIFT)
#define I40E_VSI_TUPIOM_UP2_SHIFT 6
#define I40E_VSI_TUPIOM_UP2_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP2_SHIFT)
#define I40E_VSI_TUPIOM_UP3_SHIFT 9
#define I40E_VSI_TUPIOM_UP3_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP3_SHIFT)
#define I40E_VSI_TUPIOM_UP4_SHIFT 12
#define I40E_VSI_TUPIOM_UP4_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP4_SHIFT)
#define I40E_VSI_TUPIOM_UP5_SHIFT 15
#define I40E_VSI_TUPIOM_UP5_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP5_SHIFT)
#define I40E_VSI_TUPIOM_UP6_SHIFT 18
#define I40E_VSI_TUPIOM_UP6_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP6_SHIFT)
#define I40E_VSI_TUPIOM_UP7_SHIFT 21
#define I40E_VSI_TUPIOM_UP7_MASK  I40E_MASK(0x7, I40E_VSI_TUPIOM_UP7_SHIFT)

#define I40E_VSI_TUPR(_VSI)     (0x00043000 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_TUPR_MAX_INDEX 383
#define I40E_VSI_TUPR_UP0_SHIFT 0
#define I40E_VSI_TUPR_UP0_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP0_SHIFT)
#define I40E_VSI_TUPR_UP1_SHIFT 3
#define I40E_VSI_TUPR_UP1_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP1_SHIFT)
#define I40E_VSI_TUPR_UP2_SHIFT 6
#define I40E_VSI_TUPR_UP2_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP2_SHIFT)
#define I40E_VSI_TUPR_UP3_SHIFT 9
#define I40E_VSI_TUPR_UP3_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP3_SHIFT)
#define I40E_VSI_TUPR_UP4_SHIFT 12
#define I40E_VSI_TUPR_UP4_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP4_SHIFT)
#define I40E_VSI_TUPR_UP5_SHIFT 15
#define I40E_VSI_TUPR_UP5_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP5_SHIFT)
#define I40E_VSI_TUPR_UP6_SHIFT 18
#define I40E_VSI_TUPR_UP6_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP6_SHIFT)
#define I40E_VSI_TUPR_UP7_SHIFT 21
#define I40E_VSI_TUPR_UP7_MASK  I40E_MASK(0x7, I40E_VSI_TUPR_UP7_SHIFT)

#define I40E_VSI_VSI2F(_VSI)              (0x0020B800 + ((_VSI) * 4)) /* _i=0...383 */ /* Reset: PFR */
#define I40E_VSI_VSI2F_MAX_INDEX          383
#define I40E_VSI_VSI2F_VFVMNUMBER_SHIFT   0
#define I40E_VSI_VSI2F_VFVMNUMBER_MASK    I40E_MASK(0x3FF, I40E_VSI_VSI2F_VFVMNUMBER_SHIFT)
#define I40E_VSI_VSI2F_PFNUMBER_SHIFT     10
#define I40E_VSI_VSI2F_PFNUMBER_MASK      I40E_MASK(0xF, I40E_VSI_VSI2F_PFNUMBER_SHIFT)
#define I40E_VSI_VSI2F_FUNCTIONTYPE_SHIFT 14
#define I40E_VSI_VSI2F_FUNCTIONTYPE_MASK  I40E_MASK(0x3, I40E_VSI_VSI2F_FUNCTIONTYPE_SHIFT)
#define I40E_VSI_VSI2F_BUFFERNUMBER_SHIFT 16
#define I40E_VSI_VSI2F_BUFFERNUMBER_MASK  I40E_MASK(0x7, I40E_VSI_VSI2F_BUFFERNUMBER_SHIFT)
#define I40E_VSI_VSI2F_RESERVED_5_SHIFT   19
#define I40E_VSI_VSI2F_RESERVED_5_MASK    I40E_MASK(0x7, I40E_VSI_VSI2F_RESERVED_5_SHIFT)
#define I40E_VSI_VSI2F_VSI_ENABLE_SHIFT   22
#define I40E_VSI_VSI2F_VSI_ENABLE_MASK    I40E_MASK(0x1, I40E_VSI_VSI2F_VSI_ENABLE_SHIFT)
#define I40E_VSI_VSI2F_VSI_NUMBER_SHIFT   23
#define I40E_VSI_VSI2F_VSI_NUMBER_MASK    I40E_MASK(0x1FF, I40E_VSI_VSI2F_VSI_NUMBER_SHIFT)

/* PF - Wake-Up and Proxying Registers  */

#define I40E_PFPM_FHFT_DATA(_i, _j)      (0x00060000 + ((_i) * 4096 + (_j) * 128)) /* _i=0...7, _j=0...31 */ /* Reset: POR */
#define I40E_PFPM_FHFT_DATA_MAX_INDEX   7
#define I40E_PFPM_FHFT_DATA_DWORD_SHIFT 0
#define I40E_PFPM_FHFT_DATA_DWORD_MASK  I40E_MASK(0xFFFFFFFF, I40E_PFPM_FHFT_DATA_DWORD_SHIFT)

#define I40E_PFPM_FHFT_MASK(_i, _j)     (0x00068000 + ((_i) * 1024 + (_j) * 128)) /* _i=0...7, _j=0...7 */ /* Reset: POR */
#define I40E_PFPM_FHFT_MASK_MAX_INDEX  7
#define I40E_PFPM_FHFT_MASK_MASK_SHIFT 0
#define I40E_PFPM_FHFT_MASK_MASK_MASK  I40E_MASK(0xFFFF, I40E_PFPM_FHFT_MASK_MASK_SHIFT)

#define I40E_PFPM_PROXYFC                    0x00245A80 /* Reset: POR */
#define I40E_PFPM_PROXYFC_PPROXYE_SHIFT      0
#define I40E_PFPM_PROXYFC_PPROXYE_MASK       I40E_MASK(0x1, I40E_PFPM_PROXYFC_PPROXYE_SHIFT)
#define I40E_PFPM_PROXYFC_EX_SHIFT           1
#define I40E_PFPM_PROXYFC_EX_MASK            I40E_MASK(0x1, I40E_PFPM_PROXYFC_EX_SHIFT)
#define I40E_PFPM_PROXYFC_ARP_SHIFT          4
#define I40E_PFPM_PROXYFC_ARP_MASK           I40E_MASK(0x1, I40E_PFPM_PROXYFC_ARP_SHIFT)
#define I40E_PFPM_PROXYFC_ARP_DIRECTED_SHIFT 5
#define I40E_PFPM_PROXYFC_ARP_DIRECTED_MASK  I40E_MASK(0x1, I40E_PFPM_PROXYFC_ARP_DIRECTED_SHIFT)
#define I40E_PFPM_PROXYFC_NS_SHIFT           9
#define I40E_PFPM_PROXYFC_NS_MASK            I40E_MASK(0x1, I40E_PFPM_PROXYFC_NS_SHIFT)
#define I40E_PFPM_PROXYFC_NS_DIRECTED_SHIFT  10
#define I40E_PFPM_PROXYFC_NS_DIRECTED_MASK   I40E_MASK(0x1, I40E_PFPM_PROXYFC_NS_DIRECTED_SHIFT)
#define I40E_PFPM_PROXYFC_MLD_SHIFT          12
#define I40E_PFPM_PROXYFC_MLD_MASK           I40E_MASK(0x1, I40E_PFPM_PROXYFC_MLD_SHIFT)

#define I40E_PFPM_PROXYS                    0x00245B80 /* Reset: POR */
#define I40E_PFPM_PROXYS_EX_SHIFT           1
#define I40E_PFPM_PROXYS_EX_MASK            I40E_MASK(0x1, I40E_PFPM_PROXYS_EX_SHIFT)
#define I40E_PFPM_PROXYS_ARP_SHIFT          4
#define I40E_PFPM_PROXYS_ARP_MASK           I40E_MASK(0x1, I40E_PFPM_PROXYS_ARP_SHIFT)
#define I40E_PFPM_PROXYS_ARP_DIRECTED_SHIFT 5
#define I40E_PFPM_PROXYS_ARP_DIRECTED_MASK  I40E_MASK(0x1, I40E_PFPM_PROXYS_ARP_DIRECTED_SHIFT)
#define I40E_PFPM_PROXYS_NS_SHIFT           9
#define I40E_PFPM_PROXYS_NS_MASK            I40E_MASK(0x1, I40E_PFPM_PROXYS_NS_SHIFT)
#define I40E_PFPM_PROXYS_NS_DIRECTED_SHIFT  10
#define I40E_PFPM_PROXYS_NS_DIRECTED_MASK   I40E_MASK(0x1, I40E_PFPM_PROXYS_NS_DIRECTED_SHIFT)
#define I40E_PFPM_PROXYS_MLD_SHIFT          12
#define I40E_PFPM_PROXYS_MLD_MASK           I40E_MASK(0x1, I40E_PFPM_PROXYS_MLD_SHIFT)

/* VF - Admin Queue */

/* VF - General Registers  */

/* VF - Interrupts */

#define I40E_VFINT_ITR0_STAT1(_i)              (0x00004400 + ((_i) * 4)) /* _i=0...2 */ /* Reset: VFR */
#define I40E_VFINT_ITR0_STAT1_MAX_INDEX        2
#define I40E_VFINT_ITR0_STAT1_ITR_EXPIRE_SHIFT 0
#define I40E_VFINT_ITR0_STAT1_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_VFINT_ITR0_STAT1_ITR_EXPIRE_SHIFT)
#define I40E_VFINT_ITR0_STAT1_EVENT_SHIFT      1
#define I40E_VFINT_ITR0_STAT1_EVENT_MASK       I40E_MASK(0x1, I40E_VFINT_ITR0_STAT1_EVENT_SHIFT)
#define I40E_VFINT_ITR0_STAT1_ITR_TIME_SHIFT   2
#define I40E_VFINT_ITR0_STAT1_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_VFINT_ITR0_STAT1_ITR_TIME_SHIFT)

#define I40E_VFINT_ITRN_STAT1(_i, _INTVF)       (0x00003000 + ((_i) * 64 + (_INTVF) * 4)) /* _i=0...2, _INTVF=0...15 */ /* Reset: VFR */
#define I40E_VFINT_ITRN_STAT1_MAX_INDEX        2
#define I40E_VFINT_ITRN_STAT1_ITR_EXPIRE_SHIFT 0
#define I40E_VFINT_ITRN_STAT1_ITR_EXPIRE_MASK  I40E_MASK(0x1, I40E_VFINT_ITRN_STAT1_ITR_EXPIRE_SHIFT)
#define I40E_VFINT_ITRN_STAT1_EVENT_SHIFT      1
#define I40E_VFINT_ITRN_STAT1_EVENT_MASK       I40E_MASK(0x1, I40E_VFINT_ITRN_STAT1_EVENT_SHIFT)
#define I40E_VFINT_ITRN_STAT1_ITR_TIME_SHIFT   2
#define I40E_VFINT_ITRN_STAT1_ITR_TIME_MASK    I40E_MASK(0xFFF, I40E_VFINT_ITRN_STAT1_ITR_TIME_SHIFT)

#define I40E_VFINT_RATE0_STAT1                  0x00005800 /* Reset: VFR */
#define I40E_VFINT_RATE0_STAT1_CREDIT_SHIFT     0
#define I40E_VFINT_RATE0_STAT1_CREDIT_MASK      I40E_MASK(0xF, I40E_VFINT_RATE0_STAT1_CREDIT_SHIFT)
#define I40E_VFINT_RATE0_STAT1_INTRL_TIME_SHIFT 4
#define I40E_VFINT_RATE0_STAT1_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_VFINT_RATE0_STAT1_INTRL_TIME_SHIFT)

#define I40E_VFINT_RATEN_STAT1(_INTVF)          (0x00004000 + ((_INTVF) * 4)) /* _i=0...15 */ /* Reset: VFR */
#define I40E_VFINT_RATEN_STAT1_MAX_INDEX        15
#define I40E_VFINT_RATEN_STAT1_CREDIT_SHIFT     0
#define I40E_VFINT_RATEN_STAT1_CREDIT_MASK      I40E_MASK(0xF, I40E_VFINT_RATEN_STAT1_CREDIT_SHIFT)
#define I40E_VFINT_RATEN_STAT1_INTRL_TIME_SHIFT 4
#define I40E_VFINT_RATEN_STAT1_INTRL_TIME_MASK  I40E_MASK(0x3F, I40E_VFINT_RATEN_STAT1_INTRL_TIME_SHIFT)

/* VF - LAN Transmit Receive Registers */

/* VF - MSI-X Table Registers */

/* VF - PE Registers */

/* VF - Rx Filters Registers */

#define I40E_VPQF_DDPCNT               0x0000C800 /* Reset: CORER */
#define I40E_VPQF_DDPCNT_DDP_CNT_SHIFT 0
#define I40E_VPQF_DDPCNT_DDP_CNT_MASK  I40E_MASK(0x1FFF, I40E_VPQF_DDPCNT_DDP_CNT_SHIFT)

/* VF - Time Sync Registers */

#define I40E_PRTTSYN_VFTIME_H1                  0x0000E020 /* Reset: GLOBR */
#define I40E_PRTTSYN_VFTIME_H1_TSYNTIME_H_SHIFT 0
#define I40E_PRTTSYN_VFTIME_H1_TSYNTIME_H_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTTSYN_VFTIME_H1_TSYNTIME_H_SHIFT)

#define I40E_PRTTSYN_VFTIME_L1                  0x0000E000 /* Reset: GLOBR */
#define I40E_PRTTSYN_VFTIME_L1_TSYNTIME_L_SHIFT 0
#define I40E_PRTTSYN_VFTIME_L1_TSYNTIME_L_MASK  I40E_MASK(0xFFFFFFFF, I40E_PRTTSYN_VFTIME_L1_TSYNTIME_L_SHIFT)

#endif
