#!/bin/bash
. ./testslib.sh

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2013 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "CUPS parameter test" 4 34
Print " " 4

scriptError=0
suppressCmdError=1 # compCode from response will be located in 'errorCode' variable

GetCUPSData "0x03"

if [ "$errorCode" != "00" ]; then
  scriptError=1
  Print "Wrong status 0x$errorCode of Get CUPS data command." 4
  Print " " 0
fi
arr=(`echo ${cupsData}`);
if [ "${#arr[@]}" -lt "24" ]; then
  scriptError=1
  Print "Response for Get Cups Data command is too short." 4
  Print " " 0
else
  if [ "${arr[0]}${arr[1]}${arr[2]}${arr[3]}${arr[4]}${arr[5]}${arr[6]}${arr[7]}" != "0000000000000000" ]; then
    scriptError=1
    Print "Bytes from 5 to 12 are not equal to 0 but they should be." 4
    Print " " 0
  fi
  if [ "${arr[8]}${arr[9]}${arr[10]}${arr[11]}${arr[12]}${arr[13]}${arr[14]}${arr[15]}" != "0000000000000000" ]; then
    scriptError=1
    Print "Bytes from 13 to 20 are not equal to 0 but they should be." 4
    Print " " 0
  fi
  if [ "${arr[16]}${arr[17]}${arr[18]}${arr[19]}${arr[20]}${arr[21]}${arr[22]}${arr[23]}" != "0000000000000000" ]; then
    scriptError=1
    Print "Bytes from 21 to 28 are not equal  to 0 but they should be." 4
    Print " " 0
  fi
fi


if [ $scriptError -eq 1 ]; then
  Print " " 0
  Print "TEST FAILED " 0 31
  Print " " 0
  exit 1
else
  Print " " 4
  Print "TEST PASSED " 4 32
  Print " " 4
fi