#!/bin/bash
. ./testslib.sh

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2014 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "MIC proxy test" 4 34
Print " " 4

scriptError=0
suppressCmdError=1
Print "Send Get PCIe SMBus Slot Card Info command." 4
SetTargetAddr $BMCAddr
GetPCIeSlotCardInfo "0x00"
if [ "$errorCode" == "" ]; then
    Print "Send Get PCIe SMBus Slot Card Info command failed." 4
    scriptError=1
elif [ "$errorCode" != "00" ]; then
    Print "Get PCIe SMBus Slot Card Info completion code: 0x$errorCode" 4
    scriptError=1
elif [ $TotNumOfCardsDetected == "00" ]; then
    Print "MIC cards not detected" 4
    scriptError=1
fi


if [ "$scriptError" != "1" ]; then
  cardsDetected=$TotNumOfCardsDetected
  numPassed=0;
  for number in 0x01 0x02 0x03 0x04 0x05 0x06 0x07 0x08 # numbers of MIC cards
  do
    GetPCIeSlotCardInfo $number
    if [ "$errorCode" == "" ]; then
    Print "Send Get PCIe SMBus Slot Card Infocommand failed." 4
    scriptError=1
    elif [ "$errorCode" == "cb" ]; then
      continue
    elif [ "$errorCode" != "00" ]; then
    Print "Get PCIe SMBus Slot Card Info completion code: 0x$errorCode" 4
    else
    SlotIPMB "0x$AddProtBus 0x$SlotNumber 0x$IdSlaveAddres 0x30 0x06 0x01"
        if [ "$errorCode" != "00" ]; then
            Print "Slot IPMB completion code: 0x$errorCode" 4
        else
        ((numPassed++))
        fi
    fi
  done
  
  printf -v numPassed '%02X' $numPassed
  if [ $numPassed == 0 ]; then
    Print "All MIC cards failed" 4
    scriptError=1
  elif [ $numPassed != $cardsDetected ]; then
    Print "Some MIC cards failed" 4
  scriptError=1
  else
    Print "All MIC cards passed" 4
  fi
fi

if [ $scriptError -eq 1 ]; then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi