#!/bin/bash
#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2014 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

. ./testslib.sh
ParseTestArguments $@

Print " " 4
Print "NM platform power reading test" 4 34
Print " " 4

scriptError=0
suppressCmdError=0 # compCode from response will be located in 'errorCode' variable

# input parameters for command
manufId=0x157
mode=1
domainId=0
policyId=0

GetNMStatistics "$mode $domainId $policyId"
if [ "$error" != "0" ]; then
  Print "GetNMStatistics command failed! Response: $rsp" 0 31
  Print "TEST FAILED " 0 31
  exit 1
fi
nmCurrentPowerRead=$(( 0x$b6$b5 ))
Print "GetNMStatistics current power read [W]: $nmCurrentPowerRead" 4

Print "Retreiving current power reading from external source." 4

#the script has to set the externalCurrentPowerRead variable
#this is to be set in the config file
externalCurrentPowerRead=-1
. ./${externalCurrentPowerReadScript}

if [ $externalCurrentPowerRead == -1 ]; then
  Print "ERROR: Failed to get current power read from external source!" 0 31
  scriptError=1   
else
  Print "External current power read [W]: $externalCurrentPowerRead" 4
  tolerance=`expr $externalCurrentPowerRead / 100`
  if [ `expr $externalCurrentPowerRead + $tolerance` -lt $nmCurrentPowerRead ] || [ `expr $externalCurrentPowerRead - $tolerance` -gt $nmCurrentPowerRead ]; then
    scriptError=1
    Print "ERROR: Mismatch between power read using getNMStatistics ($nmCurrentPowerRead W) and external source($externalCurrentPowerRead W)!" 0 31
  else
    Print "getNMStatistics and external current power measurements match." 4 34
  fi
fi

#apply load on the DUT cpu and memory
Print "Generating CPU and Memory load on target DUT." 4
. ${applyPlatformLoadScript}
sleep 5
GetNMStatistics "$mode $domainId $policyId"
if [ "$error" != "0" ]; then
  Print "GetNMStatistics command failed! Response: $rsp" 0 31
  Print "TEST FAILED " 0 31
  exit 1
fi
nmCurrentPowerRead=$(( 0x$b6$b5 ))
Print "GetNMStatistics current power read [W]: $nmCurrentPowerRead" 4

Print "Retreiving current power reading from external source." 4
#the script has to set the externalCurrentPowerRead variable
externalCurrentPowerRead=-1
. ./${externalCurrentPowerReadScript}

if [ $externalCurrentPowerRead == -1 ]; then
  Print "ERROR: Failed to get current power read from external source!" 0 31
  scriptError=1   
else
  Print "External current power read [W]: $externalCurrentPowerRead" 4

  tolerance=`expr $externalCurrentPowerRead / 100`
  if [ `expr $externalCurrentPowerRead + $tolerance` -lt $nmCurrentPowerRead ] || [ `expr $externalCurrentPowerRead - $tolerance` -gt $nmCurrentPowerRead ]; then
    scriptError=1
    Print "ERROR: Mismatch between power read using getNMStatistics ($nmCurrentPowerRead W) and external source($externalCurrentPowerRead W)!" 0 31
  else
    Print "getNMStatistics and external current power measurements match." 4 34
  fi
fi

# just in case kill the power load tools
Print "Killing cpu and mem load processes on target DUT." 4
. ${stopLoadScript}

if [ $scriptError -eq 1 ]; then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
    exit 0
fi
