#!/bin/bash
. ./testslib.sh

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008-2013 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "BMC sensor reading test" 4 34
Print " " 4

scriptError=0
suppressCmdError=1 # compCode from response will be located in 'errorCode' variable

for domain in 0xa3 0xbd 0xa2 # sensor domains to check
  do
    Print "Sensor domain: $domain" 5
    GetSensorReading "$domain"
    if [ "$errorCode" != "00" ]; then
      scriptError=1
      Print "Invalid status $errorCode for $domain domain." 4
      Print " " 0
    elif [ $sensReadSet != "c0" ]; then
    scriptError=1
    Print "Sensor data is unavailable on $domain domain,  Status: 0x$errorCode, Response: 0x$sensRead 0x$sensReadSet 0x$sensReadB1." 4
    Print " " 0
    fi
  done

if [ $scriptError -eq 1 ]; then
  Print " " 0
  Print "TEST FAILED " 0 31
  Print " " 0
  exit 1
else
  Print " " 4
  Print "TEST PASSED " 4 32
  Print " " 4
fi