#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

Print " " 4
Print " Loop test execution" 4 34
Print " " 4

numOfTests=$1         # Number of tests 

logFile=$2            # Name of output log file 

touch $logFile
> $logFile            # Erasing file content if already exists  

i=0
numOfPassed=0
numOfFailed=0
while [ $i -lt $numOfTests ];do
    Print "Test number:  $(( $i + 1 )) " 4 33    
    $3 $4 >> $logFile # send output of command $3 with debug level $4 to a file  
    if [ $? = 1 ];then 
    	let " numOfFailed = numOfFailed + 1 "
    else 
    	let " numOfPassed = numOfPassed + 1 "
    fi 
    let " i = i + 1"
done

Print " Number of tests: $numOfTests " 4
Print " Number of passed tests: $numOfPassed " 4 33
Print " Number of failed tests: $numOfFailed " 4 33

