#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "Max Allowed CPU States " 4 34
Print " " 4

scriptError=0 # error flag initialization

for domainId in 0 
do
   policyId=0 # Id=0
	#### Disable Node Manager Policy Control ##
	# Byte 4 - Flags 
	b4=0 #  Global Disable Node Manager policy control
	#  Byte 6 - Policy Id
	policyId=0 # Id=0
	EnDisNMPolicyControl "$b4 $domainId $policyId" 
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		scriptError=1
		continue
	fi
	###########################################

	##### Set Total Power Budget #####
	#  Bytes 5:6  - Target power budget in Watts that should be maintained by the Power Budget control Service
	PowerBudget_b5=0 #  Issuing Set Total Power Budget command with target budget set to 0 allows the BMC to control P-States directly
	PowerBudget_b6=0 
	#   
	SetTotalPowerBudget "$domainId $PowerBudget_b5 $PowerBudget_b6"
	if [ $error -eq 0 ];then
		Print " Power Budget Control has been disabled" 5
		Print " " 5
	else 
		continue
	fi	
	#### saving P-State, T-State values to restore #####
	GetMaxAllowedCPUPStateTState "$domainId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		scriptError=1
		continue
	fi 
	Print " Setting values to restore" 10 
	Old_PState=0x$b5
	Print " PState to restore: $Old_PState" 10 
	Old_TState=0x$b6
	Print " TState to restore: $Old_TState\n" 10
	#################################
GetNumberOfPStatesTStates "0x$domainId"
	if [ $error -ne 0 ];then
		continue
	fi
	##### Set Max Allowed CPU P-State/T-State #####
	#  Byte 5 - P-State number to be set
	if [ $((0x$b5)) -ge 2 ];then
		PStateNum=$(( 0x$b5 - 2 )) 
	else
		Print " P-States control is not available on the platform " 0 31
		Print " " 0
		scriptError=1
		continue
	fi
	#  Byte 6 - T-State number to be set
	if [ $((0x$b6)) -ge 2 ];then
		TStateNum=$(( 0x$b6 - 2 ))
	else
		TStateNum=0
	fi
	#
	SetMaxAllowedCPUPStateTState "$domainId $PStateNum $TStateNum"
	if [ $error -ne 0 ];then
		continue
	fi
	GetMaxAllowedCPUPStateTState "$domainId"
	if [ $error -ne 0 ];then
		continue
	fi
	if [ $(( $PStateNum )) -eq $((0x$b5)) ] && [ $(( $TStateNum )) -eq $((0x$b6)) ];then 
		Print " Max Allowed CPU P-State/T-State has been set " 5
		Print " " 5
	else 
		Print " Unable to set Max Allowed CPU P-State/T-State " 0 31
		Print " " 0
		scriptError=1
	fi
	# Restoring  P-State, T-State values 
	#  Byte 5 - P-State number to be set
	PStateNum=$(( $Old_PState )) 
	#  Byte 6 - T-State number to be set
	TStateNum=$(( $Old_TState )) 
	#
	SetMaxAllowedCPUPStateTState "$domainId $PStateNum $TStateNum"
	if [ $error -ne 0 ];then
		continue
	fi
	GetMaxAllowedCPUPStateTState "$domainId"
	if [ $error -ne 0 ];then
		continue
	fi
	if [ $(( $PStateNum )) -eq $((0x$b5)) ] && [ $(( $TStateNum )) -eq $((0x$b6)) ];then 
		Print " Max Allowed CPU P-State/T-State has been set " 5
		Print " " 5
	else 
		Print " Unable to set Max Allowed CPU P-State/T-State " 0 31
		Print " " 0
		scriptError=1
	fi
done

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi
