#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#


ParseTestArguments $@

Print " " 4
Print "Node Manager Alert Destination" 4 34
Print " " 4

scriptError=0 # error flag initialization

##### Set Node Manager Alert Destination ####
#
#  Channel number: BMC channel number over which to send the alert from BMC to management console | Destination information operation: 
   sb4=1 # BMC channel number:1 | Destination infomration operation: register alert receiver
#  Destination information: 
#    for channel medium IPMB /  for channel medium 802.3 LAN
   sb5=0 # destiantion selector: use volatile destination info	
#  Alert String Selector
   sb6=0 # use volatile Alert String | don't send Alert String
#
SetNMAlertDestination " 0x$sb4 0x$sb5 0x$sb6 "
GetNMAlertDestination 
if [ $error -eq 0 ]; then 
    if [ $sb4 -eq $b5 ] && [ $sb5 -eq $b6 ] && [ $sb6 -eq $b7 ];then 
	Print " Node Manager Alert Destination has been set" 5
	Print " " 5
    else
	Print " Unable to set Node Manager Alert Destination " 0 31
	Print " " 0
	scriptError=1
    fi
fi
###########################################

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi
