#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#


ParseTestArguments $@

Print " " 4
Print "Node Manager Policy Suspend Periods " 4 34
Print " " 4

scriptError=0

#  Domain Id | Policy Enable
   domainId=0 # Id=0
#  Policy Id
   policyId=1 # Id=1

##### Get Node Manager Capabilities #####
#
#  Policy Type | Policy Trigger Type
   b5=10 # Power Control Policy | No Policy Trigger
GetNmCapabilities "0x$domainId 0x$b5"
########################################

##### Disable Node Manager Policy Control #####
b4=0 # Global Disable Node Manager Policy control
EnDisNMPolicyControl "0x$b4 0x$domainId 0x$policyId"
if [ $error -eq 0 ];then
    Print " Global Disable Node Manager policy control" 5
    Print " " 5
fi
##############################################

##### Set Node Manager Policy		#####
#
#  Domain Id | Policy Enabled
   sb4=$(( $domainId | $(( 0x10 ))  )) # policy is enabled by default during policy creation/modification
#  Policy Type | Policy Trigger Type
   sb6=10 # Power Control Policy| No Policy Trigger
#  Policy Exception Actions
   sb7=00 # no action
#  Power Limit[Watts]:
   sb8=$c8
   sb9=$c9
#  Correction time Limit[ms]:
   sb10=$c10
   sb11=$c11
   sb12=$c12
   sb13=$c13
#  Policy Trigger Limit[Celsius]
   sb14=a0
   sb15=00 # Policy trigger Value will be ignored
#  Statistics Reporting Period: $c18$c17 [s]
   sb16=$c18
   sb17=$c19
SetNMPolicy "$sb4 0x$policyId 0x$sb6 0x$sb7 0x$sb8 0x$sb9 0x$sb10 0x$sb11 0x$sb12 0x$sb13 0x$sb14 0x$sb15 0x$sb16 0x$sb17 "
GetNMPolicy "0x$domainId 0x$policyId"
stab=($sb6 $sb7 $sb8 $sb9 $sb10 $sb11 $sb12 $sb13 $sb16 $sb17)
tab=($b6 $b7 $b8 $b9 $b10 $b11 $b12 $b13 $b16 $b17)
num=10 # number of tab elements
tabError=0
if [ $error -eq 0 ];then
    if [ $(( $sb4 & 0x10 )) -ne $(( 0x$b5 & 0x10 )) ]; then
	tabError=1
    fi
    if [ $(( $sb6 & 0x01 )) -eq 1 ]; then # if Inlet temperature Limit is Enabled
	if [ $(( 0x$sb15$sb14 )) -ne $(( 0x$b15$b14)) ];then # check if Trigger Limit is set correct
	    tabError=1
	fi
    fi
    index=0
    while [ $index -lt $num ];do
	if [ $(( 0x${tab[$index] } )) -ne $(( 0x${stab[$index] } )) ];then
	    tabError=1
	fi
	let "index = index + 1"
    done
fi
if [ $tabError -eq 0  ];then
    Print " Policy $policyId for domain $domainId has been set" 5
    Print " " 5
else
    Print " Unable to set policy $policyId for domain $domainId" 0 31
    Print " " 0
    scriptError=1
fi
##############################################

##### Set Node Manager Policy suspend Periods ####
#
#  Number of policy suspend periods(max 5):
   num=5 #  1 policy suspend periods
#  Array of policy suspend periods
# 	Policy suspend period number 1:
#		Policy suspend start time:
		sb7=2
#		Polic suspend stop time:
		sb8=8
#		Suspend period recurrence pattern:
		sb9=3 # Monday | tuesday
#	Policy suspend period number2:
#		Policy suspend start time:
		sb10=3
#		Polic suspend stop time:
		sb11=8
#		Suspend period recurrence pattern:
		sb12=7 # Monday | Tuesday | Wednesday
#	Policy suspend period number 3:
#		Policy suspend start time:
		sb13=4
#		Polic suspend stop time:
		sb14=12
#		Suspend period recurrence pattern:
		sb15=40  #Sunday
#	Policy suspend period number 4:
#		Policy suspend start time:
		sb16=15
#		Polic suspend stop time:
		sb17=19
#		Suspend period recurrence pattern:
		sb18=9  # Thursday | Monday
#	Policy suspend period number 5:
#		Policy suspend start time:
		sb19=2
#		Polic suspend stop time:
		sb20=8
#		Suspend period recurrence pattern:
		sb21=8 # Thursday
#
SetNMPolicySuspendPeriods "0x$domainId 0x$policyId 0x$num 0x$sb7 0x$sb8 0x$sb9 0x$sb10 0x$sb11 0x$sb12 0x$sb13 0x$sb14 0x$sb15 0x$sb16 0x$sb17 0x$sb18 0x$sb19 0x$sb20 0x$sb21"
GetNMPolicySuspendPeriods " 0x$domainId 0x$policyId"
stab=($sb7 $sb8 $sb9 $sb10 $sb11 $sb12 $sb13 $sb14 $sb15 $sb16 $sb17 $sb18 $sb19 $sb20 $sb21)
tab=($b6 $b7 $b8 $b9 $b10 $b11 $b12 $b13 $b14 $b15 $b16 $b17 $b18 $b19 $b20)
if [ $error -eq 0 ]; then
    if [ $num -eq $b5 ] ;then
	if [ $num -gt 0 ] ;then
	    temp=$(( 3 * $num))
	    index=0
	    tabError=0
	    while [ $index -lt $temp ];do
		if [ $(( 0x${tab[$index]} )) -ne  $(( 0x${stab[$index]} )) ];then
		    tabError=1
		fi
		let " index = index + 1"
	    done
	    if [ $tabError -eq 0 ];then
		Print " Node Manager Policy Suspend Periods for policy $policyId domain $domainId have been set" 5
		Print " " 5
	    else
		Print " Unable to set Node Manager Policy Suspend Periods" 0 31
		Print " " 0
		scriptError=1
	    fi    
	else
	    Print " Node Manager Policy Suspend Periods for policy $policyId domain $domainId have been set" 5
	    Print " " 5
	fi
    else 
	Print " Unable to set Node Manager Policy Suspend Periods" 0 31
	Print " " 0
	scriptError=1
    fi
fi
#################################################

num=0
SetNMPolicySuspendPeriods "0x$domainId 0x$policyId 0x$num"
if [ $error -eq 0 ]; then
    Print "Suspend Periods for policy $policyId and domain $domainId has been removed" 5
    Print " " 5
fi

SetNMPolicy "0x$domainId 0x$policyId 0x00 0x00 0x$c7 0x$c8 0x$c9 0x$c10 0x$c11 0x$c12 0x00 0x00 0x$c17 0x$c18 "
if [ $error -eq 0 ]; then
    Print "Policy $policyId for domain $domainId has been removed" 5
    Print " " 5
fi

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi


unset domainId; unset policyId; unset num;
