#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#


ParseTestArguments $@

Print " " 4
Print "Node Manager Draw Range " 4 34
Print " " 4

scriptError=0

#  Domain Id
   domainId=0 # Id=0

##### get Node Manager Capabilities #####
#
#  Policy Type | Policy Trigger Type
   b5=10  # Power Control | No Policy Trigger
GetNmCapabilities "0x$domainId 0x$b5"
#########################################

##### Set Node Manager Power Draw Range #####################
#
#  Minimum power Draw: b6b5  [Watts]
   b5=$c8
   b6=$c9
#  Maximum power Draw: b8b7[Watts]
   b7=$c6
   b8=$c7
#
###########################################################

SetNMPowerDrawRange " 0x$domainId 0x$b5 0x$b6 0x$b7 0x$b8 "

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print "TEST PASSED " 4 34
fi

unset domainId;