#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#

ParseTestArguments $@

Print " " 4
Print "Power Budget " 4 34
Print " " 4

scriptError=0

#  Domain Id | Policy Enable
   domainId=0 # Id=0
   policyId=0 
##### Disable Node Manager Policy Control #####
b4=0 # Global Disable Node Manager Policy control
EnDisNMPolicyControl "0x$b4 0x$domainId 0x$policyId"
if [ $error -eq 0 ];then
    Print " Global Disable Node Manager policy control" 5
    Print " " 5
fi

##### GetNMCapabilities #####
#
#  Policy type | Policy Trigger Type
   b5=10 # Power Control Policy | No Policy Trigger

GetNmCapabilities " 0x$domainId 0x$b5"
#############################

##### Set Total Power Budget #####
#
#  Target power budget in Watts that should be maintained by the Power Budget control Service
   PowerBudget_b5=$c8 
   PowerBudget_b6=$c9
#
SetTotalPowerBudget " 0x$domainId 0x$PowerBudget_b5 0x$PowerBudget_b6 "
GetTotalPowerBudget " 0x$domainId "
if [ $((0x$PowerBudget_b5)) -eq $((0x$b5)) ] && [ $((0x$PowerBudget_b6)) -eq $((0x$b6 )) ];then
    Print " Total Power Budget has been set" 5
    Print " " 5
else 
    Print " Unable to set Power Budget" 0 31
    Print " " 0
    scriptError=1
fi 
#################################

SetTotalPowerBudget " 0x$domainId 0x00 0x00 " # Removing Power Budget
GetTotalPowerBudget " 0x$domainId "
if [ 0 -eq $((0x$b5)) ] && [ 0 -eq $((0x$b6)) ];then
    Print " Total Power Budget has been removed" 5
    Print " " 5
else 
    Print " Unable to remove Total Power Budget" 0 31
    Print " " 0
    scriptError=1
fi

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi


unset domianId; unset PowerBudget;