#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#


ParseTestArguments $@

Print " " 4
Print "PSU Configuration" 4 34
Print " " 4

scriptError=0

#  Domain Id
   domainId=0 # Id=0

##### Set PSU Configuration #####
#
# PMBUS PSU address 1 | Mode
  sb5=b0 # the PSU is installed or may be attached in the future; address is not used
# PMBUS PSU address 2 | Mode
  sb6=b2
# PMBUS PSU address 3 | Mode
  sb7=4
# PMBUS PSU address 4 | Mode
  sb8=3
# PMBUS PSU address 5 | Mode
  sb9=8
# PMBUS PSU address 6 | Mode
  sb10=10
# PMBUS PSU address 7 | Mode
  sb11=14
# PMBUS PSU address 8 | Mode
  sb12=0
SetPSUConfiguration "0x$domainId 0x$sb5 0x$sb6 0x$sb7 0x$sb8 0x$sb9 0x$sb10 0x$sb11 0x$sb12"
GetPSUConfiguration "0x$domainId"
if [ $error -eq 0 ];then
    if [ $((0x$sb5)) -eq $((0x$b6)) ] && [ $((0x$sb6)) -eq $((0x$b7)) ] && [ $((0x$sb7)) -eq $((0x$b8)) ] && [ $((0x$sb8)) -eq $((0x$b9)) ] && [ $((0x$sb9)) -eq $((0x$b10)) ] && [ $((0x$sb10)) -eq $((0x$b11)) ] && [ $((0x$sb11)) -eq $((0x$b12)) ] && [ $((0x$sb12)) -eq $((0x$b13)) ];then
	Print " PSU configuration has been set" 5
	Print " " 5
    else
	Print " Unable to set PSU configuration" 0 31
	Print " " 0
	scriptError=1
    fi
fi
#################################

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi

