#!/bin/bash
. ./SPSLib

#
#  INTEL CONFIDENTIAL
#
#  Copyright 2008 Intel Corporation All Rights Reserved.
#
#  The source code contained or described herein and all documents related to
#  the source code ("Material") are owned by Intel Corporation or its
#  suppliers or licensors.
#
#  Title to the Material remains with Intel Corporation or its suppliers and
#  licensors. The Material contains trade secrets and proprietary and
#  confidential information of Intel or its suppliers and licensors.
#  The Material is protected by worldwide copyright and trade secret laws and
#  treaty provisions. No part of the Material may be used, copied, reproduced,
#  modified, published, uploaded, posted, transmitted, distributed,
#  or disclosed in any way without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure
#  or delivery of the Materials, either expressly, by implication, inducement,
#  estoppel or otherwise. Any license under such intellectual property rights
#  must be express and approved by Intel in writing.
#


ParseTestArguments $@

Print " " 4
Print "Test scenario: Limiting power in Domain ID 0 (Entire platform)" 4 34
Print " " 4

scriptError=0


#  Test scenario for domain 0 (Entire platform)
for domainId in 0
do 
	##### Disable Node Manager Policy Control #####
	# Byte 4 - Flags 
	b4=0 # Global Disable Node Manager Policy control
	#  Byte 6 - Policy Id
	policyId=1 # Id=1
	EnDisNMPolicyControl "$b4 $domainId $policyId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	################################
	
	SetTotalPowerBudget " 0x$domainId 0 0 "
   if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
   
   SetMaxAllowedCPUPStateTState "$domainId 0 0"
   if [ $error -ne 0 ];then
      # if any error occurs the test execution for the current domain will be break 
      continue
	fi
   
   Print "    Start load and press enter" 0 33
	read enter

	##### Reset Node Manager Statistics #####
	#  Byte 4 - Mode
	mode=0 # Reset global statistics including power statistics and inlet temperature statistics
	ResetNMStatistics "$mode $domainId $policyId "
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	#############################

	Print "    Pause fo 10 s" 4
	Print " " 4 
	sleep 10 # sleep for 10 seconds

	##### Get Node Manager Statistics ####
	#
	#  Byte 4 - Mode
	mode=1 # Global power statistics in [Watts]
	GetNMStatistics "$mode $domainId $policyId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	AveragePower1=0x$b12$b11
	#####################################

	##### Get Node Manager Capabilities #####
	#
	#  Byte5 - Policy Type | Policy Trigger Type
	b5=0x10 # Power Control Policy | No Policy Trigger
	GetNmCapabilities "$domainId $b5"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	##############################

	temp=$(( $(( $AveragePower1 )) - 15 ))

	if [ $temp -lt $(( 0x$c9$c8)) ]; then
		PowerLimit_LSB=$(( 0x$c8 )) # decimal value
		PowerLimit_MSB=$(( 0x$c9 )) # decimal value
	else 
		PowerLimit_LSB=$(( $temp % 256  )) # decimal value
		PowerLimit_MSB=$(( $temp / 256  )) # deciaml value
	fi

	PowerLimit=$(( $(($PowerLimit_MSB<< 8)) + $PowerLimit_LSB))
	Print "Power limit: $PowerLimit" 10
	##### Set Node Manager Policy		#####
	#
	#  Byte 4 - Domain Id | Policy Enabled
	sb4=$(( $domainId | $(( 0x10 )) )) #  policy is enabled by default during policy creation/modification #decimal value
	#  Byte 6 - Policy Type | Policy Trigger Type
	sb6=0x10 # Power Control Policy| No Policy Trigger
	#  Byte 7 - Policy Exception Actions
	sb7=0x00 # no action
	#  Bytes 8:9 - Power Limit[Watts]:
	sb8=$PowerLimit_LSB 
	sb9=$PowerLimit_MSB 
	#  Correction time Limit[ms]:
	sb10=0x$c10 # Byte 10 of the Set NM Policy request is acquired from byte 10 of the Get Node Manager Capabilities response  
	sb11=0x$c11 # Byte 11 of the Set NM Policy request is acquired from byte 11 of the Get Node Manager Capabilities response 
	sb12=0x$c12 # Byte 12 of the Set NM Policy request is acquired from byte 12 of the Get Node Manager Capabilities response 
	sb13=0x$c13 # Byte 13 of the Set NM Policy request is acquired from byte 13 of the Get Node Manager Capabilities response 
	#  Bytes 14:15 - Policy Trigger Limit
	sb14=0x00
	sb15=0x00 # Policy trigger Value will be ignored
	#  Bytes 16:17 - Statistics Reporting Period[s]:
	sb16=0x$c18 # Byte 16 of the Set NM Policy request is acquired from byte 18 of the Get Node Manager Capabilities response  
	sb17=0x$c19 # Byte 17 of the Set NM Policy request is acquired from byte 19 of the Get Node Manager Capabilities response  
	SetNMPolicy "$sb4 $policyId $sb6 $sb7 $sb8 $sb9 $sb10 $sb11 $sb12 $sb13 $sb14 $sb15 $sb16 $sb17 "
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	GetNMPolicy "$domainId $policyId "
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	# Preparing the comparison table 
	sb4=$(( $sb4 & 0x10))
	stab=($sb4 $sb6 $sb7 $sb8 $sb9 $sb10 $sb11 $sb12 $sb13 $sb16 $sb17)
	b5=$(( 0x$b5 & 0x10))
	tab=($b5 0x$b6 0x$b7 0x$b8 0x$b9 0x$b10 0x$b11 0x$b12 0x$b13 0x$b16 0x$b17)
	
	if [ $(( $sb6 & 0x01 )) -eq 1 ]; then # if Inlet temperature Limit is Enabled
		if [ $(( 0x$sb15$sb14 )) -ne $(( 0x$b15$b14)) ];then # check if Trigger Limit is set correct
			error=1 # Global error  flag; Cleared automatically in function Command after successful execution of any IPMI command 
		fi
	fi
	checkArguments "$(echo ${stab[@]})" "$(echo ${tab[@]})"
	if [ $isEqual -ne 1 ];then 
		error=1 # Global error  flag; Cleared automatically in function Command after successful execution of any IPMI command 
	fi
	if [ $error -eq 0 ];then
		Print " Policy $policyId for domain $domainId has been set" 5
		Print " " 5
	else
		# if any error occurs the test execution for the current domain will be break 
		Print " Policy for $policyId domain $domainId has not been set properly" 0 31
		Print " " 0
		continue
	fi
	##############################################

	##### Enable Node Manager Policy Control #####
	# Byte 4 - Flags 
	b4=3 # Per Domain Enable Node Manager Policy control
	EnDisNMPolicyControl "$b4 $domainId $policyId"
	if [ $error -eq 0 ];then
		Print " Policy for domain $domainId has been enabled" 5
		Print " " 5
	fi
	# Byte 4 - Flags 
	b4=1 # Global Enable Node Manager Policy control
	EnDisNMPolicyControl "$b4 $domainId $policyId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	################################

	time=$(( $(( 0x$c13$c12$c11$c10 )) / 1000 ))
	Print "    Pause for $time s (Min Correction Time)" 5
	Print " " 5
	sleep $time  # sleep for Min Correction time

	##### Reset Node Manager Statistics #####
	#  Byte 4 - Mode
	mode=0 # Reset global statistics including power statistics and inlet temperature statistics
	ResetNMStatistics "$mode $domainId $policyId "
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	########################################

	Print "    Pause for 10 s" 5
	sleep 10

	##### Get Node Manager Statistics ####
	#  Byte 4 - Mode
	mode=1 # Global power statistics
	GetNMStatistics "$mode $domainId $policyId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	#####################################
	
	#AveragePower2=0x$b12$b11
	CurrentPower=0x$b6$b5
	Print "    Average power consumption before Policy control=$(( $AveragePower1 )) [Watts]" 4 33
	Print "    Current Power consumption=$(( $CurrentPower )) [Watts]" 4 33
	Print "    Power limit: $(( $PowerLimit )) " 4 33
	Print " " 4

	Test3=`echo "scale=2; $(( $CurrentPower )) - $(( $PowerLimit )) <= 1" | bc` 
	Test4=`echo "scale=2; $(( $CurrentPower )) - $(( $PowerLimit )) >= -1" | bc` 
	
	if [ $Test3 -eq 1 ] && [ $Test4 -eq 1 ]; then 
		Print "    Difference between power limit and current power consumption is below 1 Watt" 4 33
	else 
		Tolerance=0.05
		MaxPower=`echo "scale=2; $(( $PowerLimit)) + ($Tolerance * $(( $PowerLimit)) ) " | bc`
		Print "      Max acceptable Power: $MaxPower " 10
		Test1=`echo "scale=2; $(( $CurrentPower )) > $MaxPower" | bc` 
		if [ "$Test1" -eq 1 ]; then 
			Print "        Max acceptable Power has been exceed\n" 0 31
         scriptError=1
		fi
	
		MinPower=`echo "scale=2; $(( $PowerLimit)) - ($Tolerance * $(( $PowerLimit)) ) " | bc`
		Print "      Min acceptable Power: $MinPower " 10
		Test2=`echo "scale=2; $(( $CurrentPower )) < $MinPower" | bc`
		if [ "$Test2" -eq 1 ]; then 
			Print "        Min acceptable Power has been exceed\n" 0 31
         scriptError=1
		fi
      Print "" 0
	fi
	#### Disable Node Manager Policy Control ##
	# Byte 4 - Flags 
	b4=0 #  Global Disable Node Manager policy control
	EnDisNMPolicyControl "0x$b4 0x$domainId 0x$policyId"
	if [ $error -ne 0 ];then
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi
	###########################################

	# Removing the policy 
	SetNMPolicy "$domainId $policyId 0 0 0 0 0 0 0 0 0 0 0 0 "
	if [ $error -eq 0 ]; then
		Print "Policy $policyId for domain $domainId has been removed" 5
		Print " " 5
	else 
		# if any error occurs the test execution for the current domain will be break 
		continue
	fi		
done

if [ $scriptError -eq 1 ];then
    Print " " 0
    Print "TEST FAILED " 0 31
    Print " " 0
    exit 1
else 
    Print " " 4
    Print "TEST PASSED " 4 34
    Print " " 4
fi

