/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $console.cpp
//  Contents:   Sample code for an Intel SPS Firmware update application
//
//----------------------------------------------------------------------------

#include "stdafx.h"


/*++
 *****************************************************************************

 Routine Description:
				Just a cover for standard system printf() function
  
 Arguments:
				Same as printf()
 Returns:
				Same as printf()

 *****************************************************************************
 --*/ 
int SpsPrintf(const char * fmt,...)
{
   va_list argptr;

   va_start(argptr, fmt);

   return vprintf(fmt,argptr);
}


/*++
 *****************************************************************************

 Routine Description:
			Just a cover for standard system wprintf() function
  
 Arguments:
			Same as wprintf()
 Returns:
			Same as wprintf()

 *****************************************************************************
 --*/ 

int SpsPrintfW(const wchar_t * fmt,...)
{
   va_list argptr;

   va_start(argptr, fmt);

   return vwprintf(fmt,argptr);
}

