/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $me_region.cpp
//  Contents:   Sample code for an Intel SPS Firmware update application
//
//----------------------------------------------------------------------------

#include "stdafx.h"
#include "me_region.h"
#include "spsloader.h"


/*++
 *****************************************************************************

 Routine Description:
				Function that checks if there is no violation of ranges for 
				given pair of pointer/length
 Arguments:
			inner_ptr  - pointer of inner area
			inner_len  - length of inner area
			outer_ptr  - pointer of outer area
			outer_len  - length of outer
 Returns:	0   - OK, inner area within outer area
			-1	- Error	

 *****************************************************************************
 --*/ 

int CheckPtr(const char * inner_ptr, size_t inner_len,const char * outer_ptr, size_t outer_len)
{
	if ((inner_ptr >= outer_ptr) && (inner_ptr + inner_len <= outer_ptr + outer_len))
	{
		return 0;
	}
	else
	{
		return -1;
	}
}

/*++
 *****************************************************************************

 Routine Description:
			Compares ME image file version number with given version number
 Arguments:
			module                                  - pointer to buffer with ME image
			length                                  - ME image length
         majorVer, minorVer, hotfixVer, buildVer - version number to compare
 Returns:
         false - given version number is greater than ME image file version number
         true  - given version number is lower than (or equal to) ME image file version number

 *****************************************************************************
 --*/ 
bool ValidateMeVersionWithFile(void * module, unsigned long length, unsigned char majorVer, unsigned char minorVer, unsigned char hotfixVer, unsigned short buildVer)
{
	ManifestTypePtr manifest_ptr = (ManifestTypePtr)module;

   if (length < sizeof(ManifestType))
   {
		SpsPrintf( "[Error] Wrong file size - too short\n");		
		return false;
   }

   if (manifest_ptr->ManifestHeader.majorVersion > majorVer)
   {
      return true;
   }
   if (manifest_ptr->ManifestHeader.majorVersion < majorVer)
   {
      return false;
   }

   if (manifest_ptr->ManifestHeader.minorVersion > minorVer)
   {
      return true;
   }
   if (manifest_ptr->ManifestHeader.minorVersion < minorVer)
   {
      return false;
   }

   if (manifest_ptr->ManifestHeader.hotfixVersion > hotfixVer)
   {
      return true;
   }
   if (manifest_ptr->ManifestHeader.hotfixVersion < hotfixVer)
   {
      return false;
   }

   if (manifest_ptr->ManifestHeader.buildVersion >= buildVer)
   {
      return true;
   }

   return false;  
}

/*++
 *****************************************************************************

 Routine Description:
				Function that validates ME image file
 Arguments:
			module      - pointer to buffer with ME image
			length      - ME image length
         platform_id - pointer for Platform ID to be returned

 Returns:

 *****************************************************************************
 --*/ 
int ValidateMeModule(void * module, unsigned long length, PlatformIdType * const platform_id)
{
	ManifestTypePtr		manifest_ptr  = NULL; 
	ModuleEntryTypePtr	mod_entry_ptr = NULL;
	ModuleHeaderPtr		mod_hdr_ptr   = NULL;
	int                  ii;

	
   if (length < sizeof(ManifestType))
   {
		SpsPrintf( "[Error] Wrong file size - too short\n");		
		return -1;	 
   }

   manifest_ptr = (ManifestTypePtr)module;

   if ((manifest_ptr->ManifestHeader.headerID          != MANIFEST_HDR_ID    ) 
       || (manifest_ptr->ManifestHeader.manifestVendor != DEFAULT_VENDOR     ) 
       || (manifest_ptr->ManifestHeader.headerType     != DEFAULT_HEADER_TYPE) 
       || (manifest_ptr->ManifestHeader.headerVersion  != MANIFEST_VER_1_0   )
       )
   {
		SpsPrintf( "[Error] Wrong file manifest header\n");		
		return -1;	
   }


   if(CheckPtr((char *)manifest_ptr,sizeof(*manifest_ptr) + sizeof(ModuleEntryType)*manifest_ptr->ManifestHeader.numModuleEntries,(char*)module,length)!= 0)
   {
		SpsPrintf( "[Error] Image corrupted\n");		
		return -1;	
   }

   // Create a pointer to the header of first module (not sure if something like module header exists in 2.0, values under debugger were wrong)
   mod_hdr_ptr = (ModuleHeaderPtr)( (U8 *)manifest_ptr + manifest_ptr->ManifestHeader.size * sizeof(U32) );

   //SpsPrintf("[TODO] Validate hashes of modules.\n");		
   // Search through the manifest objects for modules
   for (ii = 0; ii < (int)manifest_ptr->ManifestHeader.numModuleEntries; ii++)
   {
      mod_entry_ptr = &manifest_ptr->ModuleEntries[ii];

	  // Check module header ranges
	  if(CheckPtr((char*)mod_hdr_ptr,sizeof(ModuleHeader),(char*)module,length)!= 0)
	  {
			SpsPrintf("[Error] Image corrupted\n");		
			return -1;	
	  }

     // Check the module type to determine if it is a module object
	  if (mod_entry_ptr->StructId == MANIFEST_MODULE_HDR)
	  {
        // TODO: check for changes between NM 1.5 and 2.0
//		  if((mod_hdr_ptr->StructId == MODULE_STRUCT_ID) && (mod_hdr_ptr->StructVer == MODULE_STRUCT_VER))
        if (1)
		  {			  

			  // Check module data ranges
			  if(CheckPtr((char *)mod_hdr_ptr,mod_entry_ptr->ModuleLength,(char*)module,length)!= 0)
			  {
				SpsPrintf( "[Error] Image corrupted\n");		
				return -1;	
			  }


//			  SpsPrintf( "[OK] Module found Ver: %d.%d.%d.%d Name: \"%s\" \n",mod_hdr_ptr->MajorVersion,mod_hdr_ptr->MinorVersion,mod_hdr_ptr->Hotfix,mod_hdr_ptr->Build,mod_hdr_ptr->Name);
           // modules (like BUP, KERNEL, NM) in 2.0 seem to not have idividual versions like in 1.5 - maybe print version once?
           // printing name like this is not safe - may be not terminated with nul
           // SpsPrintf( "[OK] Module found Ver: %d.%d.%d.%d Name: \"%s\" Addr: 0x%X\n",manifest_ptr->ManifestHeader.majorVersion,manifest_ptr->ManifestHeader.minorVersion,manifest_ptr->ManifestHeader.hotfixVersion,manifest_ptr->ManifestHeader.buildVersion,mod_entry_ptr->Name,mod_entry_ptr->Module);

			  // use SHA256 there
			  if(strstr((char *)mod_entry_ptr->Name,"BUP")!=0)
				 
				 switch(CheckModuleHash(&(((char *)module)[((int)mod_entry_ptr->Module)]),mod_entry_ptr->ModuleLength,(U8 *)mod_entry_ptr->Hash))
			     {
				   case 0:
				   	   {
						   SpsPrintf( "[OK] Module hash SHA256 check OK\n");		
					   }break;
				   case -1:
					   {
					       SpsPrintf( "[Error] Module hash SHA256 check failure\n");		
						   return -1;
					   }break;
				   default:
					   {
						   // Unsupported, ignore
					   }break;
			     }

           // advance pointer to the next module
//			  mod_hdr_ptr = (ModuleHeaderPtr)((U8 *)mod_hdr_ptr + mod_hdr_ptr->Size + sizeof(ModuleHeader));
			  mod_hdr_ptr = (ModuleHeaderPtr)((U8 *)mod_hdr_ptr + mod_entry_ptr->ModuleLength);
		  }
		  else
		  {
			  SpsPrintf( "[Error] Image corrupted\n");		
			  return -1;	
		  }
	  }
	  else
	  {
		  // Ignore the rest
		  break;
	  }
   }

   SpsPrintf("[OK] ME file image version: %d.%d.%d.%d\n",manifest_ptr->ManifestHeader.majorVersion,manifest_ptr->ManifestHeader.minorVersion,manifest_ptr->ManifestHeader.hotfixVersion,manifest_ptr->ManifestHeader.buildVersion);
   *platform_id = *(PlatformIdType *)(manifest_ptr->Name);
   
	return 0;
}
