/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $me_region.h
//  Contents:   Sample code for an Intel SPS Firmware update application
//
//----------------------------------------------------------------------------

/** Defines */

/** A unique text readable identifier that can be used to identify the base of the Module Header. $MOD */
#define MODULE_STRUCT_ID  0x444F4D24  
/** Identifies the version of the Module Header. Currenlty there is only this one version. */
#define MODULE_STRUCT_VER 0x00000000
/** Defines the MAX Name length of this current module header version */
#define MAX_NAME_STR      16


/** Defines the length in bytes of a SHA256 Hash */
#define DEFAULT_HASH_SHA256_LEN 32
/** Max length for Module Name */
#define DEFAULT_MAX_MODULE_NAME_LEN 16
/** Default Vendor Id for Manifest */
#define DEFAULT_VENDOR 0x00008086
/** value assigned by CSS team to represent ME Manifest */
#define DEFAULT_HEADER_TYPE 4
/** Definition of the "$MME" Manifest Module Entry */
#define MANIFEST_MODULE_HDR 0x454D4D24 
/** Definition of the "$MN2" Manifest Header Id */
#define MANIFEST_HDR_ID 0x324E4D24
/** Structure version of the Manifest */
#define MANIFEST_VER_1_0 0x00010000

#define C_ASSERT(e) typedef char __C_ASSERT__[(e)?1:-1]

typedef enum _PlatformIdType
{
   PLATFORM_ID_IN_MANIFEST_NAME_BROMOLOW = 0x5242504F,
   PLATFORM_ID_IN_MANIFEST_NAME_ROMLEY   = 0x4F52504F,
   PLATFORM_ID_IN_MANIFEST_NAME_DENLOW   = 0x4544504F,
   PLATFORM_ID_IN_MANIFEST_NAME_GRANTLEY = 0x5247504F
} PlatformIdType;

#pragma pack(1)

/** Data types */

typedef   signed char        S8;      /* 8-bit  signed integer */
typedef   signed short       S16;     /* 16-bit signed integer */
typedef   signed long        S32;     /* 32-bit signed integer */
typedef   unsigned char      U8;      /* 8-bit  unsigned integer */
typedef   unsigned short     U16;     /* 16-bit unsigned integer */
typedef   unsigned long      U32;     /* 32-bit unsigned integer */


typedef struct _ModuleHeader
{
    U32 StructId;          
    U32 StructVer;         
    U32 Flags;			
    U16 MajorVersion;   
    U16 MinorVersion;   
    U16 Hotfix;         
    U16 Build;          
    U32 Reserved;       
    U32 Size;           
    U32 Reserved2[5];
    U8  Name[MAX_NAME_STR];
    U8  Reserved3[16];           
} ModuleHeader, * ModuleHeaderPtr;
/** At compile time, validate that the structure is sized as expected */
C_ASSERT(sizeof(ModuleHeader) == 5 * 16);


typedef struct _ModuleEntryType
{
   U32    StructId;
   U8     Name[DEFAULT_MAX_MODULE_NAME_LEN];
   U8     Hash[DEFAULT_HASH_SHA256_LEN];
   void * LoadAddress;
   void * Module;
   U32    LoadLength;
   U32    ModuleLength;
   U32    MemorySize;
   U32    PreUmaSize;
   void  (*Entrypoint)();
   U32    Reserved1;
   U32    Reserved2[3];
} ModuleEntryType, * ModuleEntryTypePtr;

/** Compile time assert that validates the Manifest is correct size */
C_ASSERT(sizeof(ModuleEntryType) == 96);
/** Compile time assert that validates the Manifest aligned to a DWORD */
C_ASSERT(sizeof(ModuleEntryType) % 4 == 0);


typedef struct _MfmHeader {
   U32 headerType;
   U32 reserved1;               
   U32 headerVersion;
   U32 reserved2;
   U32 manifestVendor; 
   U32 reserved3;
   U32 size;
   U32 headerID;
   U32 numModuleEntries;
   U16 majorVersion;
   U16 minorVersion;
   U16 hotfixVersion;
   U16 buildVersion;
   U8  reserved4[84];
} MfmHeader, * MfmHeaderPtr;
/** Compile time assert that validates the Manifest Header is correct size */
C_ASSERT(sizeof(MfmHeader) == 128);


#pragma warning( disable : 4200 )

typedef struct _ManifestType
{
   MfmHeader        ManifestHeader;      
   U8               Reserved1[516];
   U8               Name[8];
   U32              Reserved2;
   ModuleEntryType  ModuleEntries[0];    
} ManifestType, * ManifestTypePtr;


/** Compile time assert that validates the Manifest is correct size */
C_ASSERT(sizeof(ManifestType) == 656);
/** Compile time assert that validates the Manifest aligned to a DWORD */
C_ASSERT(sizeof(ManifestType) % 4 == 0);


bool ValidateMeVersionWithFile(void * module, unsigned long length, unsigned char majorVer, unsigned char minorVer, unsigned char hotfixVer, unsigned short buildVer);
int ValidateMeModule(void * module, unsigned long length, PlatformIdType * const platform_id);
int CheckModuleHash(const char * module,U32 length, const U8 * hash);