/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $spsloader.h 
//  Contents:   Sample code for an Intel SPS Firmware update application
//
//----------------------------------------------------------------------------

#ifndef _SPSLOADER_H_
#define _SPSLOADER_H_

/* Don't use it - it is now defined in project's preprocessor defines. */
/*#define INTEL_DRIVER*/

/* Default source and destination LUN */
#define DEFAULT_SRC_LUN 0x00
#define DEFAULT_DST_LUN 0x00

/*
 * Standard IPMI application commands
 */
#define IPMI_NETFN_APPL                0x06

#define IPMI_CMD_GET_DEVICE_ID         0x01
#define IPMI_CMD_COLD_RESET            0x02
#define IPMI_CMD_GET_MESSAGE           0x33
#define IPMI_CMD_SEND_MESSAGE          0x34

/*
 * OEM IPMI commands
 */
#define IPMI_NETFN_OEMSPEC             0x30
#define IPMI_NETFN_NONIPMI             0x2E

#define IPMI_CMD_UPDATE_PREPARE        0xA0
#define IPMI_CMD_UPDATE_OPEN           0xA1
#define IPMI_CMD_UPDATE_WRITE          0xA2
#define IPMI_CMD_UPDATE_CLOSE          0xA3
#define IPMI_CMD_UPDATE_REGISTER       0xA4
#define IPMI_CMD_UPDATE_UPDATE_STATUS  0xA6
#define IPMI_CMD_UPDATE_CAPABILITIES   0xA7
#define IPMI_CMD_ME_RESET              0xDF

/*
 * IPMI completion codes
 */
#define IPMI_CC_ACK                    0x00
#define IPMI_CC_NODE_BUSY              0xC0
#define IPMI_CC_INVALID_CMD            0xC1
#define IPMI_CC_NOT_IN_PRESENT_STATE   0xD5

/*
 * IPMI frame interface buffers
 */
#define IPMI_BUFFER_LEN  (76+16) // (76+16) for Write frames with up to 68 bytes of data (of image to send)
#define DATAINDEX (IPMI_BUFFER_LEN-7)

#define FRAME_DECODED    0x01
#define FRAME_NOCHCKSUM  0x02


/* IPMI interface specification */
// TODO: previously "ME Interface Specification, BCD encoding" was here, check it
#define IPMI_IFACE_SPEC  0x02   // IPMI Specification, BCD encoding, reversed digit order

/* Default value of Channel for ME - System communication */
#define DEFAULT_CHANNEL_ID 6

#define DEFAULT_WINDOW_SIZE 0

#define MAX_WINDOW_SIZE  19 //Must be lower than IPMI_TRANSACTION_SLOTS

/*
 * IPMI frame structure
 */
typedef struct
{
   // Logical format	
   unsigned char DestAddress;
   unsigned char NetFn_DestLun;
   unsigned char HdrChksum;
   unsigned char SourceAddress;
   unsigned char SeqNumber_SourceLun;
   unsigned char Command;
   unsigned char Data[DATAINDEX];
   unsigned int  DataLength;        
   unsigned char Chksum;   

   // Raw format
   unsigned char RawFrame[IPMI_BUFFER_LEN];
   unsigned char RawFrameLength;


   // Status flags
   unsigned char RawFormatDecoded;

} IpmiDataType;


/* Program settings */
typedef struct
{
	int			 BridgeEnabled;

	unsigned int DestAddr;
	unsigned int SourceAddr;
	unsigned int BridgeAddr;
	unsigned int BrigdeChannelId;

/* 
	IPMI window parameters 

	The UPDATE process uses 'sliding window' while sending UPDATE frames.
	Basically it means it sends up to IPMI_WINDOW_SIZE + 1 request frames without waiting for response.
	When response comes, next request is being send ( so ME always has some requests in its internal queues ).
	This shortens UPDATE process as no time is wasted for message transport delays.
*/
	unsigned int WindowSize;

	char		 InputFile[256];
} SpsUpdateParametersType;

#pragma pack(1)
typedef struct _IPMI_GET_DEVICE_ID_RESP
{
	unsigned char CCode;
	unsigned char DeviceId;
	unsigned char DeviceRev_SdlPresent;
	unsigned char FwMajorRev_InUPDATE;	// binary encoded
	unsigned char FwMinorRev; 	// BCD encoded
	unsigned char IpmiVersion;	// BCD encoded, reverced digit order
	unsigned char FeatureMask;	// bitmask of supported features
	unsigned char ManufId[3];
	unsigned short ProdId;
	unsigned char FwIfaceVer;	// BCD encoded two digits
	unsigned short BuildNo;    // BCD encoded build
	unsigned char ImageNo;  	// 0-Recovery, 1-Operational1, 2-Operational2
} IPMI_GET_DEVICE_ID_RESP;
C_ASSERT(sizeof(IPMI_GET_DEVICE_ID_RESP) == 0x10);
#pragma pack()

typedef enum _ProdIdType
{
   PROD_ID_BROMOLOW = 0x0B01,
   PROD_ID_ROMLEY   = 0x0B02,
   PROD_ID_DENLOW   = 0x0B03,
   PROD_ID_GRANTLEY = 0x0B05

} ProdIdType;

/* Transport layer interface */
typedef struct
{
	int (*ConfigureInterface)(SpsUpdateParametersType * pParameters);
	int (*StartInterface)(unsigned int SlaveAddres);
	int (*StopInterface)(void);
	int (*SendRequest)(const IpmiDataType * pReqFrame);
	int (*GetResponse)(IpmiDataType * pRespFrame,unsigned int TimeoutMs);
	int (*IsResponse)(bool * isResp);
	int (*GetBridgedResponse)(IpmiDataType * pRespFrame,unsigned int TimeoutMs);
} HalCommunicationInterfaceType;


/* IPMI stack interface */
void  IpmiSetupTransaction(int WindowSize,int DestAddress,int SourceAddress,int BridgeAddress,int BridgeEnable = 0,int BridgeChannelId = 6);
int   IpmiCleanResponses(int * msgNum);
int   IpmiSendSimpleRequest(int NetFn,int Command,char * pSendData,unsigned int DataLength,unsigned int SrcLun = DEFAULT_SRC_LUN,unsigned int DestLun = DEFAULT_DST_LUN);
int   IpmiSendRequest(int NetFn,int Command,char * pSendData,unsigned int DataLength,long long handle,unsigned int SrcLun = DEFAULT_SRC_LUN,unsigned int DestLun = DEFAULT_DST_LUN);
int   IpmiGetResponse(long long *handle, int *dataLength, unsigned char** data);
int   IpmiRemoveAcknowledgeRequest(long long *handle);
int   IpmiDropRequest(long long *handle);

/* Console interface */
int  SpsPrintf(const char * fmt,...);
int  SpsPrintfW(const wchar_t * fmt,...);

/* Generic functions */
unsigned char Crc8(unsigned char crc,const unsigned char * buf, const int  len);


/*
	Public common structures
*/
extern SpsUpdateParametersType       SpsUpdateParameters;
extern HalCommunicationInterfaceType transport;


#endif // _SPSLOADER_H_
