/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $hal_intel.cpp
//  Contents:   Sample code for an Intel SPS Firmware update application.
//
//----------------------------------------------------------------------------

#include "stdafx.h"
#include "hal_intel.h"

// Set to 1 for additional debugging info - for development only
#if 0
#define VERBOSE
#define D(x_) x_
#else
#define D(x_)
#endif


#define ASYNC_SEQ_START			0	// starting sequence number

#define FILE_DEVICE_IMB			0x00008010
#define IOCTL_IMB_BASE			0x00000880

#define GET_MESSAGE_CHNUM_OFFSET    4           // Channel number offset in GetMessage Response frame
#define GET_MESSAGE_IPMB_OFFSET     5           // 5 bytes (GetMessage REsponse frame + Channel Number)

#define IOCTL_IMB_GET_ASYNC_MSG		CTL_CODE(FILE_DEVICE_IMB, IOCTL_IMB_BASE + 8, METHOD_BUFFERED, FILE_ANY_ACCESS)


typedef DWORD	ImbAsyncSeq;

typedef struct {
	DWORD			timeOut;	// how long to wait for a message to come in
	ImbAsyncSeq		lastSeq;	// last message seen or ASYNC_SEQ_START
} ImbAsyncRequest;


typedef struct {
	ImbAsyncSeq		thisSeq;	// tag for returned message
	BYTE data[1];
} ImbAsyncResponse;


static HANDLE Driver;
static ImbAsyncSeq   lastSeq = ASYNC_SEQ_START;


int intel_OpenDriver()
{
	IpmiDataType RespFrame;
	ImbAsyncSeq	 oldSeq;

    Driver = CreateFile(L"\\\\.\\Imb", 
						GENERIC_READ | GENERIC_WRITE,
                        0,
						NULL, 
						OPEN_EXISTING, 
						FILE_ATTRIBUTE_NORMAL,
                        NULL);

    if (Driver == INVALID_HANDLE_VALUE) 
	{

        SpsPrintf("Error Intel IPMI Driver (imbdrv.sys) (%d)\n", GetLastError());
        return -1;
    }
	else
	{
		D(SpsPrintf("Intel IPMI Driver opened(imbdrv.sys) (%d)\n", GetLastError()); );
	}


	// Set pointer to last message

	D(SpsPrintf("Queue sync start\n"); );

	oldSeq = lastSeq ;
	
	while(1)	
	{
		
		if(intel_GetQueueMessage(&RespFrame,0) != 0)
		{
			break;
		}
	
		if(oldSeq == lastSeq )
		{
			break;
		}
		oldSeq = lastSeq ;
		D(SpsPrintf("Queue sync\n"); );
	}
	D(SpsPrintf("Queue sync stop\n"); );

	return 0;
}

void  intel_CloseDriver()
{
	CloseHandle(Driver);
}


int intel_GetQueueMessage(IpmiDataType * pRespFrame,unsigned int TimeoutMs)
{
	ULONG				size;
	ULONG				result;
	ImbAsyncRequest		request;
	unsigned char		buffer[64];
	int					ii;
	int					messageCount = 0;
	int					finalResult = -1;
	ImbAsyncSeq			oldSeq;


	request.timeOut = 1000 * TimeoutMs; // convert us to ms
	request.lastSeq = lastSeq;  // we accept all sequence numbers


	while(1)
	{
		result = DeviceIoControl(Driver, (ULONG)IOCTL_IMB_GET_ASYNC_MSG,&request,sizeof(request),buffer,sizeof(buffer),&size, NULL);
		if ( result != 0) 
		{
			oldSeq  = lastSeq;
			lastSeq = ((ImbAsyncResponse * )buffer)->thisSeq;

			if(oldSeq == lastSeq)
			{
				D(SpsPrintf("No more!!(%d)\n",lastSeq); );		
				break;
			}

#ifdef VERBOSE
			SpsPrintf("Intel IPMI Driver - raw data received (%d seq=%d attempt %d)\n", size,lastSeq,messageCount++);

			SpsPrintf("Raw: ");
			for(ii =0; ii < (int)size;ii++)
			{
				SpsPrintf("0x%02x ",(unsigned int)((unsigned char)buffer[ii]));
			}
			SpsPrintf("\n");
#endif
	 
         if( (size > GET_MESSAGE_IPMB_OFFSET) && ( (size - (GET_MESSAGE_IPMB_OFFSET + 1)) <= sizeof(pRespFrame->RawFrame)) )
			{
				// We skip first GET_MESSAGE_IPMB_OFFSET bytes
				pRespFrame->RawFrameLength = (unsigned char)(size - GET_MESSAGE_IPMB_OFFSET) + 1;
            
				D( SpsPrintf("Bridged response (%d): ",pRespFrame->RawFrameLength ););
				pRespFrame->RawFrame[0] = 0;/* left for address */
				for(ii = 0; ii < (int)size - GET_MESSAGE_IPMB_OFFSET && ii < (sizeof(buffer) / sizeof(buffer[0]) - GET_MESSAGE_IPMB_OFFSET); ii++)
				{
					pRespFrame->RawFrame[ii+1] = buffer[GET_MESSAGE_IPMB_OFFSET + ii];
					D(SpsPrintf("0x%02x ",(unsigned int)((unsigned char)pRespFrame->RawFrame[ii])););
				}
				D( SpsPrintf("\n"););
				pRespFrame->RawFormatDecoded = 0;
			}
			else
			{
				D(SpsPrintf("Intel IPMI Driver - wrong data length(only %d characters)\n", size); );
				continue;
			}
			finalResult = 0;
			D(SpsPrintf("OK - some more ??\n", size); );
		
		}
		else
		{
			D(SpsPrintf("Intel IPMI Driver - empty  (%d) (%lx)\n", GetLastError(),result); );
			break;
		}
	}

	return finalResult;
}
