/**********        Intel Confidential       ***********/
//----------------------------------------------------------------------------
//                    INTEL CORPORATION PROPRIETARY INFORMATION
//      This software is supplied under the terms of a license agreement or
//      nondisclosure agreement with Intel Corporation and may not be copied
//      or disclosed except in accordance with the terms of that agreement.
//        Copyright (c) 2008-2010 Intel Corporation.  All Rights Reserved.
//
//  File:       $hal_wmi.cpp
//  Contents:   Sample code for an Intel SPS Firmware update application.
//
//----------------------------------------------------------------------------

#include "stdafx.h"


using namespace std;

#ifdef INTEL_DRIVER
#include "hal_intel.h"
#endif

// Set to 1 for additional debugging info - for development only
#if 0
#define VERBOSE
#define D(x_) x_
#else
#define D(x_)
#endif


/*++
******************************************************
***      Private variables & declarations
******************************************************
--*/ 

static IWbemLocator      *pLoc = NULL;
static IWbemServices     *pSvc = NULL;
static IWbemClassObject  *pClass = NULL;
static IWbemClassObject  *pInParamsDefinition;
static BSTR              ClassName;
static BSTR              MethodName;
static BSTR              ipmiInstancePath;
static int               LastResult = -1;
static HANDLE            Driver;

static  IpmiDataType		  retFrame;	
static  bool				  MessageReady = false;

#pragma comment(lib, "Wbemuuid")

static int ConfigureInterface(SpsUpdateParametersType* pParameters);
static int StartInterface(unsigned int SlaveAddres);
static int StopInterface(void);
static int SendRequest(const IpmiDataType * pReqFrame);
static int GetResponse(IpmiDataType * pRespFrame,unsigned int TimeoutMs);
static int IsResponse(bool * isResp);
static int GetBridgedResponse(IpmiDataType * pRespFrame,unsigned int TimeoutMs);


/*++
******************************************************
***      Public variables & declarations
******************************************************
--*/ 

HalCommunicationInterfaceType	transport =	
{
	ConfigureInterface,
	StartInterface,
	StopInterface,
	SendRequest,
	GetResponse,
#ifndef INTEL_DRIVER
	IsResponse,
	NULL
#else
	NULL,
	GetBridgedResponse
#endif
};


/*++
 *****************************************************************************

 Routine Description:
				Configures communication channel (generic high level settings )
  
 Arguments:
				pParameters - Pointer to structure with configuration data.
							  Some data is already filled, some has to be added.
 Returns:
				Always 0
  

 *****************************************************************************
 --*/ 
static int ConfigureInterface(SpsUpdateParametersType * pParameters)
{
	pParameters->BridgeEnabled = 1;				
	pParameters->SourceAddr    = 0x20;
	pParameters->BridgeAddr    = 0x20;
		
	SpsPrintf( "[OK] Starting update process (BMC bridge  ME: 0x%02x BMC: 0x%02x)\n",
				SpsUpdateParameters.DestAddr,
				SpsUpdateParameters.BridgeAddr);	

	return 0;
}


/*++
 *****************************************************************************

 Routine Description:
				Starts physical transport interface
  
 Arguments:
				SlaveAddres - device slave address to listen to
 Returns:
				0 - Success
				All other values - failure

 *****************************************************************************
 --*/ 
static int StartInterface(unsigned int SlaveAddres)
{
	HRESULT		   hres;

#ifdef INTEL_DRIVER
    if (intel_OpenDriver() != 0) 
	{
        return -1;
    }
#endif
	//
	// Initializes the COM library for use by the calling thread, sets the thread's concurrency model, 
	// and creates a new apartment for the thread if one is required. 
	//
	hres = CoInitializeEx(
		/*	void * pvReserved	*/	0,
		/*	DWORD dwCoInit		*/	COINIT_MULTITHREADED
		);

	if (FAILED(hres))
	{
		SpsPrintf("[Error] Failed to initialize COM library (0x%x)\n",hres);
		return -1;
	}

	// Registers security and sets the default security values for the process
	hres = CoInitializeSecurity(
		/*	PSECURITY_DESCRIPTOR pVoid					*/	NULL,
		/*	LONG cAuthSvc								*/	-1,
		/*  SOLE_AUTHENTICATION_SERVICE * asAuthSvc		*/	NULL, 
		/*	void * pReserved1							*/  NULL,
		/*  DWORD dwAuthnLevel							*/  RPC_C_AUTHN_LEVEL_DEFAULT,
		/*	DWORD dwImpLevel							*/	RPC_C_IMP_LEVEL_IMPERSONATE,
		/*	SOLE_AUTHENTICATION_LIST * pAuthList		*/	NULL,
		/*	DWORD dwCapabilities						*/	EOAC_NONE,
		/*	void * pReserved3							*/	NULL
		);

	if (FAILED(hres))
	{
		CoUninitialize();
		SpsPrintf("[Error] Failed to initialize COM library (0x%x)\n",hres);
		return -1;
	}


	// Call this method to create an object of the class associated with a specified Class ID or Program ID.
	hres = CoCreateInstance(
		CLSID_WbemLocator,
		0,
		CLSCTX_INPROC_SERVER,
		IID_IWbemLocator, 
		(LPVOID *) &pLoc
		);

	if (FAILED(hres))
	{
		CoUninitialize();
		SpsPrintf("[Error] Failed get initial locator to WMI (0x%x)\n",hres);
		return -1;
	}


	// The IWbemLocator::ConnectServer method connects to Windows Management Instrumentation (WMI) on the computer 
	//	specified in the strNetworkResource parameter.
	hres = pLoc->ConnectServer(
		_bstr_t(L"ROOT\\WMI"),
		NULL,
		NULL,
		0,
		NULL,
		0,
		0,
		&pSvc
		);

	if (FAILED(hres))
	{
		pLoc->Release();
		pLoc = NULL;
		CoUninitialize();
		SpsPrintf("[Error] Failed to connect to WMI (0x%x)\n",hres);
		return -1;
	}

	//Sets the authentication information that will be used to make calls on the specified proxy
	hres = CoSetProxyBlanket(
		/* IUnknown * pProxy					*/	pSvc,
		/* DWORD dwAuthnSvc						*/	RPC_C_AUTHN_WINNT,
		/* DWORD dwAuthzSvc						*/	RPC_C_AUTHZ_NONE,
		/* WCHAR * pServerPrincName				*/	NULL,
		/* DWORD dwAuthnLevel					*/	RPC_C_AUTHN_LEVEL_CALL,
		/* DWORD dwImpLevel						*/	RPC_C_IMP_LEVEL_IMPERSONATE,
		/* RPC_AUTH_IDENTITY_HANDLE pAuthInfo	*/	NULL,
		/* DWORD dwCapabilities					*/	EOAC_NONE
		);


	if (FAILED(hres))
	{
		SpsPrintf("[Error] Failed get initial locator to WMI (0x%x)\n",hres);
		goto cfgError;
	}

	ClassName = SysAllocString(L"Microsoft_IPMI");
	MethodName = SysAllocString(L"RequestResponse");


	// Enumerate the Microsoft_IPMI instances available locally
	// (only one is expected)
	IEnumWbemClassObject * ipmiInstanceEnum;
	hres = pSvc->CreateInstanceEnum(ClassName, WBEM_FLAG_SHALLOW | WBEM_FLAG_FORWARD_ONLY, NULL, &ipmiInstanceEnum);

	if (FAILED(hres))
	{
		SpsPrintf("[Error] Failed to enumerate Microsoft_IPMI instances available locally (0x%x)\n",hres);
		goto cfgError;
	}

	ULONG retObjectCount = 0;
	IWbemClassObject	* ipmiInstance;
	hres = ipmiInstanceEnum->Next(WBEM_NO_WAIT, 1, &ipmiInstance, &retObjectCount); 
	if (FAILED(hres))
	{
		ipmiInstanceEnum->Release();
		SpsPrintf("[Error] Enumerating Microsoft_IPMI instances(0x%x)\n",hres);
		goto cfgError;
	}

	if (1 != retObjectCount)
	{
		ipmiInstance->Release();
		ipmiInstanceEnum->Release();
		if(retObjectCount == 0)
		{
			SpsPrintf("[Error] No Microsoft_IPMI object found(0x%x)\n",hres);
		}
		else
		{
			SpsPrintf("[Error] Unexpected count of  Microsoft_IPMI objects(%d)\n",retObjectCount);
		}
		goto cfgError;

	}

	// Get the path of the first object
	VARIANT comVar;
	VariantInit(&comVar);
	hres = ipmiInstance->Get(L"__PATH", 0, &comVar, NULL, NULL);
	if (FAILED(hres))
	{
		ipmiInstance->Release();
		ipmiInstanceEnum->Release();
		SpsPrintf("[Error] Getting Microsoft_IPMI object path(0x%x)\n",hres);
		goto cfgError;
	}

	ipmiInstancePath = comVar.bstrVal;
	ipmiInstance->Release();
	ipmiInstanceEnum->Release();


	hres = pSvc->GetObject(ClassName, 0, NULL, &pClass, NULL);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed GetObject (0x%x)\n",hres);
		goto cfgError;
	}

	hres = pClass->GetMethod(MethodName, 0, &pInParamsDefinition, NULL);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed GetMethod (0x%x)\n",hres);
		pClass->Release();
		goto cfgError;
	}


	D( SpsPrintf("[Log] WMI interface started \n"); );

	return 0;

cfgError:

	pLoc->Release();
	pSvc->Release();

	pLoc = NULL;
	pSvc = NULL;

	CoUninitialize();

	return -1;
}

/*++
 *****************************************************************************

 Routine Description:
				Stops physical transport interface
 Arguments:
				-
 Returns:
				-

 *****************************************************************************
 --*/ 

static int StopInterface(void)
{
	assert(pLoc!=NULL);
	assert(pSvc!=NULL);

#ifdef INTEL_DRIVER
	intel_CloseDriver();
#endif

    pClass->Release();
    pInParamsDefinition->Release();

	SysFreeString(ClassName);
	SysFreeString(MethodName);

	pLoc->Release();
	pSvc->Release(); 
	CoUninitialize(); 


	D( SpsPrintf("[Log] WMI interface stopped \n"); );

	return 0;
}



/*++
 *****************************************************************************

 Routine Description:
				Sends IPMI message frame
 Arguments:
				pReqFrame - Pointer to IPMI frame structure. Must be in logical format
 Returns:
  				0 - Success
				All other values - failure

 *****************************************************************************
 --*/ 

static int SendRequest(const IpmiDataType * pReqFrame)
{
	BSTR				  NetworkFunction; 
	BSTR				  Lun; 
	BSTR				  ResponderAddress; 
	BSTR				  Command;
	BSTR				  RequestDataSize;
	BSTR				  RequestData;
	IWbemClassObject	* pInParams = NULL;
	IWbemClassObject	* pOutParams = NULL;
	SAFEARRAY			* pSafeArray = NULL;
	VARIANT				  Argument;
	VARIANT				  ReturnValue;
	HRESULT				  hres;
	int					  result = -1;
	

	
//  !! Does ont work properly - Clone must be used instead
//	hres = pInParamsDefinition->SpawnInstance(0,&pInParams);

    hres = pInParamsDefinition->Clone(&pInParams);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Clone (0x%x)\n",hres);
		pClass->Release();
		pInParamsDefinition->Release();
		goto ArgumentError;
	}


	// Prepare IPMI call arguments
	VariantInit(&Argument);
	VariantInit(&ReturnValue);

    VariantClear(&Argument);
    NetworkFunction = SysAllocString(L"NetworkFunction");
    Argument.vt = VT_UI1;
	Argument.bVal = (pReqFrame->NetFn_DestLun>>2);

	hres = pInParams->Put(NetworkFunction, 0, &Argument, 0);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Put (Network Function) (0x%x)\n",hres);
		goto ArgumentError;
	}

    VariantClear(&Argument);
    Lun = SysAllocString(L"Lun");
    Argument.vt = VT_UI1;
    Argument.bVal = pReqFrame->NetFn_DestLun & 0x03;
    hres = pInParams->Put(Lun, 0, &Argument, 0);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Put (Lun) (0x%x)\n",hres);
		goto ArgumentError;
	}



    VariantClear(&Argument);
    ResponderAddress = SysAllocString(L"ResponderAddress");
    Argument.vt = VT_UI1;
	Argument.bVal = (pReqFrame->DestAddress);
    hres = pInParams->Put(ResponderAddress, 0, &Argument, 0);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Put (ResponderAddress) (0x%x)\n",hres);
		goto ArgumentError;
	}


    VariantClear(&Argument);
    Command = SysAllocString(L"Command");
    Argument.vt = VT_UI1;
	Argument.bVal = pReqFrame->Command;
    hres = pInParams->Put(Command, 0, &Argument, 0);
	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Put (Command) (0x%x)\n",hres);
		goto ArgumentError;
	}
	else
	{
		D( SpsPrintfW(L"[Log] %s = 0x%02x\n",Command,Argument.bVal); );
	}


    VariantClear(&Argument);
    RequestDataSize = SysAllocString(L"RequestDataSize");
    Argument.vt = VT_I4;
	Argument.intVal = pReqFrame->DataLength;
    hres = pInParams->Put(RequestDataSize, 0, &Argument, 0);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] Failed Put (RequestDataSize) (0x%x)\n",hres);
		goto ArgumentError;
	}
	else
	{
		D( SpsPrintfW(L"[Log] %s = 0x%02x\n",RequestDataSize,Argument.intVal); );
	}


	VariantClear(&Argument);
	pSafeArray = SafeArrayCreateVector(VT_UI1,0,pReqFrame->DataLength);

	if (!pSafeArray )
	{
	   SpsPrintf("[Error] CreateArray (0x%x %p for %d)\n",hres,pSafeArray,pReqFrame->DataLength);
	   goto ArgumentError;
	}

	    
	if(pReqFrame->DataLength > 0)
	{
		for(long jj = 0; jj <(int)pReqFrame->DataLength;jj++)
		{
			hres = SafeArrayPutElement(pSafeArray, &jj, (void*)&pReqFrame->Data[jj]);
			if (FAILED(hres))
			{
				SpsPrintf("[Error] Put Array Elements (0x%x)\n",hres);
				return 1;
			}	
			D( printf("0x%02x ",pReqFrame->Data[jj]); );
		}
		D( printf("\n"); )
	}


	RequestData = SysAllocString(L"RequestData");
    Argument.vt = VT_ARRAY | VT_UI1;
	Argument.parray = pSafeArray;
    hres = pInParams->Put(RequestData, 0, &Argument, 0);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] Put Array Elements (0x%x)\n",hres);
		SafeArrayDestroy(pSafeArray);
		goto ArgumentError;
	}


	D(SpsPrintf("[Log] IPMI executing	net_fn: 0x%02x lun: 0x%02x resp addr: 0x%02x cmd:0x%02x datasize: %d \n",(pReqFrame->NetFn_DestLun>>2),(pReqFrame->NetFn_DestLun & 0x03),pReqFrame->DestAddress,pReqFrame->Command,pReqFrame->DataLength););
	//D(SpsPrintfW(L"Path= %s \n",ipmiInstancePath););


    // Execute Method ( send IPMI message using Microsoft_IPMI RequestResponse method )
	hres = pSvc->ExecMethod(ipmiInstancePath, MethodName, 0, NULL,pInParams, &pOutParams, NULL);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] ExecMethod failed (0x%x)\n",hres);
		goto CallError;
	}


	// Retrive result of the call
	hres = pOutParams->Get(L"CompletionCode", 0,&ReturnValue, NULL, 0);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] Get(CompletionCode) (0x%x)\n",hres);
		goto CallError;
	}
	
	result     = ReturnValue.bVal;
	LastResult = ReturnValue.bVal;
	D(SpsPrintf("[Log] IPMI request executed( CompletitionCode=0x%x)\n",result););


	
	VariantClear(&ReturnValue);
	hres = pOutParams->Get(L"ResponseDataSize", 0,&ReturnValue, NULL, 0);

	if(FAILED(hres))
	{
		SpsPrintf("[Error] Get(ResponseDataSize) (0x%x)\n",hres);
		goto CallError;
	}


	//Retrive response data 
	if(ReturnValue.iVal > 0)
	{
		SAFEARRAY	  * retArray;
		int				count;
		long			uBound;
		long			lBound;



		retFrame.DataLength = ReturnValue.iVal;

		VariantClear(&ReturnValue);
		hres = pOutParams->Get(L"ResponseData", 0,&ReturnValue, NULL, 0);

		if(FAILED(hres))
		{
			SpsPrintf("[Error] Get(ResponseData) (0x%x)\n",hres);
			goto CallError;
		}

		if (V_VT(&ReturnValue) != (VT_ARRAY | VT_UI1))
		{
			SpsPrintf("[Error] Get(ResponseData) - wrong type (0x%x)\n",V_VT(&ReturnValue) );
			goto CallError;
		}
		retArray = V_ARRAY(&ReturnValue);

	    hres = SafeArrayGetUBound(retArray, 1, &uBound);
		if(FAILED(hres))
		{
			SpsPrintf("[Error] Get(ResponseData - UBound) (0x%x)\n",hres);
			goto CallError;
		}

	    hres = SafeArrayGetLBound(retArray, 1, &lBound);
		if(FAILED(hres))
		{
			SpsPrintf("[Error] Get(ResponseData - UBound) (0x%x)\n",hres);
			goto CallError;
		}

		count = uBound - lBound + 1;

		if ((count > sizeof(retFrame.Data)) || (count != (int)retFrame.DataLength /*must match*/))
		{
			SpsPrintf("[Error] Get(ResponseData) - wrong data count\n");
			goto CallError;		
		}


		for(long jj = 0; jj <(int)retFrame.DataLength;jj++)
		{
			SafeArrayGetElement(retArray,&jj,&retFrame.Data[jj]);
			D( printf("0x%02x ",retFrame.Data[jj]););
		}
		D( printf("\n"); );

	}
	else
	{
		retFrame.DataLength = 0;
	}

	
	retFrame.SeqNumber_SourceLun	= pReqFrame->SeqNumber_SourceLun;
	retFrame.NetFn_DestLun			= pReqFrame->NetFn_DestLun + 4;


	retFrame.RawFormatDecoded	 = FRAME_DECODED | FRAME_NOCHCKSUM;
	MessageReady = true;

	return result;


CallError:

	SafeArrayDestroy(pSafeArray);
    pOutParams->Release();


ArgumentError:
	pInParams->Release();

	return result;

}


/*++
 *****************************************************************************

 Routine Description:
				Retrives IPMI response to last IPMI request
				For WMI this is was already done during sending process, so 
				we just check the ouptut buffer.
  
 Arguments:
				pRespFrame - pointer for response IPMI frame
				TimeoutMs  - timeout ( not used for WMI )
 Returns:
				-1 - no response available
				All other values - response result code

 *****************************************************************************
 --*/ 

static int GetResponse(IpmiDataType * pRespFrame,unsigned int TimeoutMs)
{
	if(MessageReady == true)
	{
		MessageReady = false;
		memcpy(pRespFrame,&retFrame,sizeof(*pRespFrame));
		return LastResult;
	}
	else
	{
		return -1;
	}
}


/*++
 *****************************************************************************

 Routine Description:
				Retrives IPMI response to last IPMI request
				For WMI this is was already done during sending process, so 
				we just check the ouptut buffer.
  
 Arguments:
				pRespFrame - pointer for response IPMI frame
				TimeoutMs  - timeout ( not used for WMI )
 Returns:
				-1 - no response available
				All other values - response result code

 *****************************************************************************
 --*/ 
#ifndef INTEL_DRIVER
static int IsResponse(bool * isResp)
{
	int bRet = -1;
	HRESULT hres;
	VARIANT varAttSet;
	bool attSet;

	VariantInit(&varAttSet);

	IWbemClassObject* pOutSms = NULL;
	D(printf("send_wmi: calling SMS_Attention(%ls)\n", ipmiInstancePath)); 
	hres = pSvc->ExecMethod(ipmiInstancePath, _bstr_t(L"SMS_Attention"), 
							0, NULL, NULL, &pOutSms, NULL);
	if (FAILED(hres)) {
		printf("send_wmi: SMS_Attention method error %x\n",hres);
		return bRet;
	}

	hres = pOutSms->Get(_bstr_t(L"AttentionSet"),0, &varAttSet, NULL, 0);
	if (FAILED(hres)) {
		printf("send_wmi: AttentionSet method error %x\n",hres);
		return(bRet);
	}
	D(printf("send_wmi: AttentionSet %x returned\n",	V_BOOL(&varAttSet) ));
	attSet = V_BOOL(&varAttSet);

	pOutSms->Release();
	*isResp = (attSet == 0) ? 0 : 1;
	bRet = 0;

	return bRet;
}
#endif


/*++
 *****************************************************************************

 Routine Description:
				Retrives IPMI response from Intel driver message queue.  
 Arguments:
				pRespFrame - pointer for response IPMI frame
				TimeoutMs  - timeout ( not used for WMI )
 Returns:
				-1 - no response available
				All other values - response result code

 *****************************************************************************
 --*/ 
#ifdef INTEL_DRIVER
static int GetBridgedResponse(IpmiDataType * pRespFrame,unsigned int TimeoutMs)
{
	return intel_GetQueueMessage(pRespFrame,TimeoutMs);
}
#endif
