/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.impl;

import com.vmware.vim.vmomi.core.util.Validate;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class SslUtil {
    private static final String HEX = "0123456789ABCDEF";
    public static final String DEFAULT_DIGEST_ALGORITHM = "SHA-1";

    public static String computeCertificateThumbprint(X509Certificate cert, String digestAlgorithm, boolean skipColons) throws NoSuchAlgorithmException, CertificateEncodingException {
        Validate.notNull("digestAlgorithm parameter is required", digestAlgorithm);
        Validate.notNull("cert parameter is required", cert);
        MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
        byte[] digest = md.digest(cert.getEncoded());
        StringBuilder thumbprint = new StringBuilder();
        int len = digest.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0 && !skipColons) {
                thumbprint.append(':');
            }
            byte b = digest[i];
            thumbprint.append(HEX.charAt((b & 0xF0) >> 4));
            thumbprint.append(HEX.charAt(b & 0xF));
        }
        return thumbprint.toString();
    }

    public static String computeCertificateThumbprint(X509Certificate cert, String digestAlgorithm) throws NoSuchAlgorithmException, CertificateEncodingException {
        return SslUtil.computeCertificateThumbprint(cert, digestAlgorithm, false);
    }

    public static String computeCertificateThumbprint(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        return SslUtil.computeCertificateThumbprint(cert, DEFAULT_DIGEST_ALGORITHM);
    }
}

