/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.binding.vmodl.fullyQualifiedVmodlName;
import com.vmware.vim.vmomi.core.tracing.NoopTracer;
import com.vmware.vim.vmomi.core.tracing.OtelTracer;
import com.vmware.vim.vmomi.core.tracing.OtracTracer;
import com.vmware.vim.vmomi.core.tracing.Tracer;
import com.vmware.vim.vmomi.core.tracing.TracingFeature;
import java.util.Optional;

public final class GlobalTelemetry {
    private static final Object mutex = new Object();
    private static volatile Tracer _tracer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracer getTracer() {
        if (!TracingFeature.ON) {
            return NoopTracer.INSTANCE;
        }
        if (_tracer == null) {
            Object object = mutex;
            synchronized (object) {
                if (_tracer != null) {
                    return _tracer;
                }
                _tracer = TracingFeature.OTEL_ON ? OtelTracer.createFromGlobalOtel() : OtracTracer.createFromGlobalTracer();
            }
        }
        return _tracer;
    }

    static Optional<String> getErrorType(Exception ex) {
        Throwable cause = ex.getCause();
        if (cause == null) {
            return Optional.empty();
        }
        fullyQualifiedVmodlName vmodlName = cause.getClass().getAnnotation(fullyQualifiedVmodlName.class);
        if (vmodlName == null) {
            return Optional.empty();
        }
        return Optional.of(vmodlName.value());
    }
}

