/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.tracing;

import com.vmware.vim.vmomi.core.tracing.OtelTracer;
import com.vmware.vim.vmomi.core.tracing.OtracTracer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TracingFeature {
    public static final boolean ON;
    static final boolean OTEL_ON;
    private static final Log _logger;

    private TracingFeature() {
    }

    private static boolean isTracingOn() {
        if (!_logger.isTraceEnabled()) {
            _logger.info((Object)"Tracing logger (com.vmware.vim.vmomi.core.tracing) is not enabled at TRACE level. Tracing data will not be reported.");
            return false;
        }
        if (TracingFeature.isOpenTelemetryAvailable() || TracingFeature.isOpenTracingAvailable()) {
            _logger.info((Object)"VLSI tracing is on.");
            return true;
        }
        _logger.info((Object)"VLSI tracing is off.");
        return false;
    }

    private static boolean isOpenTracingAvailable() {
        try {
            OtracTracer.createFromGlobalTracer();
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            _logger.debug((Object)"Failed to initialize open tracing", e);
            return false;
        }
    }

    private static boolean isOpenTelemetryAvailable() {
        try {
            OtelTracer.createFromGlobalOtel();
            return true;
        }
        catch (Exception | NoClassDefFoundError e) {
            _logger.debug((Object)"Failed to initialize open telemetry", e);
            return false;
        }
    }

    static {
        _logger = LogFactory.getLog(TracingFeature.class);
        ON = TracingFeature.isTracingOn();
        OTEL_ON = ON && TracingFeature.isOpenTelemetryAvailable();
    }
}

