/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.versionKind;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import com.vmware.vim.vmomi.core.types.impl.VmodlVersionImpl;
import com.vmware.vim.vmomi.core.util.Validate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class VmodlVersionMapImpl
implements VmodlVersionMap {
    private Map<String, VmodlVersion> _versionIdMap = new ConcurrentHashMap<String, VmodlVersion>();
    private Map<String, VmodlVersion> _wsdlNamespaceMap = new ConcurrentHashMap<String, VmodlVersion>();
    private Map<Class<?>, VmodlVersion> _versionClassMap = new ConcurrentHashMap();
    private Map<String, Map<versionKind.Value, List<VmodlVersion>>> _versionsByNamespace = new ConcurrentHashMap<String, Map<versionKind.Value, List<VmodlVersion>>>();

    public void init() {
    }

    @Override
    public VmodlVersion getVersion(Class<?> version) {
        return this._versionClassMap.get(version);
    }

    @Override
    public VmodlVersion findVersion(String wsdlNamespace, String versionId2) {
        for (VmodlVersion version : this._versionClassMap.values()) {
            if (!wsdlNamespace.equals(version.getNamespace()) || !versionId2.equals(version.getVersionId())) continue;
            return version;
        }
        return null;
    }

    @Override
    public VmodlVersion getVersionByWsdlNamespace(String wsdlNamespace) {
        return this._wsdlNamespaceMap.get(wsdlNamespace);
    }

    @Override
    public void addVersion(Class<?> version) {
        if (this._versionClassMap.containsKey(version)) {
            return;
        }
        VmodlVersionImpl newVersion = VmodlVersionImpl.getOrRegister(version);
        String versionId2 = newVersion.getVersionId();
        if (versionId2 != null && versionId2.length() > 0) {
            this._versionIdMap.put(versionId2, newVersion);
        } else {
            String wsdlNamespace = newVersion.getNamespace();
            if (wsdlNamespace != null && wsdlNamespace.length() > 0) {
                this._wsdlNamespaceMap.put(wsdlNamespace, newVersion);
            }
        }
        this._versionClassMap.put(version, newVersion);
    }

    @Override
    public VmodlVersion findVersion(String wsdlNamespace, String versionId2, boolean internal2) {
        Validate.notNull("wsdlNamespace is required", wsdlNamespace);
        Validate.notNull("versionId is required", versionId2);
        if (internal2 && !wsdlNamespace.startsWith("internal")) {
            wsdlNamespace = "internal" + wsdlNamespace;
        } else if (!internal2 && wsdlNamespace.startsWith("internal")) {
            wsdlNamespace = wsdlNamespace.substring("internal".length());
        }
        return this.findVersion(wsdlNamespace, versionId2);
    }

    @Override
    public void associateVersionsWithNamespace(String namespace, Map<versionKind.Value, List<Class<?>>> versionsByKind) {
        if (namespace == null || namespace.length() == 0) {
            throw new IllegalArgumentException("\"namespace\" cannot be null or empty");
        }
        this._versionsByNamespace.computeIfAbsent(namespace, k -> Collections.unmodifiableMap(versionsByKind.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getVersions((List)e.getValue())))));
    }

    private List<VmodlVersion> getVersions(List<Class<?>> classes) {
        return classes.stream().map(this::getAddedVersion).collect(Collectors.toList());
    }

    private VmodlVersion getAddedVersion(Class<?> version) {
        if (version == null) {
            throw new IllegalArgumentException("\"version\" cannot be null");
        }
        VmodlVersion namespaceVersion = this.getVersion(version);
        if (namespaceVersion == null) {
            throw new IllegalStateException(String.format("Version \"%s\" must be added to the map prior to this operation", version));
        }
        return namespaceVersion;
    }

    @Override
    public Map<versionKind.Value, List<VmodlVersion>> getVersionsByNamespace(String namespace) {
        return this._versionsByNamespace.get(namespace);
    }
}

