/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.client.common.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.client.common.Request;
import com.vmware.vim.vmomi.client.common.RequestConfiguration;
import com.vmware.vim.vmomi.client.common.impl.LoggingFilterOutputStream;
import com.vmware.vim.vmomi.client.common.impl.ThisField;
import com.vmware.vim.vmomi.client.exception.InternalException;
import com.vmware.vim.vmomi.client.security.MessageSigner;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.impl.XMLFactories;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.soap.Marshaller;
import com.vmware.vim.vmomi.core.soap.impl.SoapHelper;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseRequestImpl
implements Request {
    public static final String LOG_PROPERTY = "vlsi.debug.client.requestLog";
    private static Log LOGGER = LogFactory.getLog(BaseRequestImpl.class);
    protected final RequestContext _requestContext;
    protected final VmodlVersion _version;
    protected final ManagedObjectReference _moRef;
    private final String _debugFile;
    private SignInfo _signInfo;
    private final VmodlContext _context;
    private final RequestConfiguration _configuration;

    public BaseRequestImpl(ManagedObjectReference moRef, VmodlVersion version, RequestContext requestContext, RequestConfiguration requestConfiguration, VmodlContext context) {
        this._requestContext = requestContext;
        this._version = version;
        this._moRef = moRef;
        this._debugFile = System.getProperty(LOG_PROPERTY);
        this._context = context;
        this._configuration = requestConfiguration;
    }

    @Override
    public VmodlVersion getVersion() {
        return this._version;
    }

    @Override
    public RequestConfiguration getConfiguration() {
        return this._configuration;
    }

    @Override
    public URI getDownloadLocation() {
        return null;
    }

    @Override
    public void writeBody(OutputStream stream) throws IOException, MarshallException {
        XMLStreamWriter xmlOut = null;
        boolean loggingSplitter = false;
        try {
            if (this._debugFile != null) {
                try {
                    stream = new LoggingFilterOutputStream(stream, this._debugFile);
                    loggingSplitter = true;
                }
                catch (IOException ex) {
                    LOGGER.debug((Object)"Failed to open file for request/response logging", (Throwable)ex);
                }
            }
            Writer writer = this.createRequestWriter(stream);
            Marshaller marshaller = this._context.createMarshaller(this._version);
            xmlOut = XMLFactories.getOutputFactory().createXMLStreamWriter(writer);
            SoapHelper.outputEnvelopeStart((XMLStreamWriter)xmlOut);
            SoapHelper.outputHeader((Marshaller)marshaller, (XMLStreamWriter)xmlOut, (Map)this._requestContext, (VmodlVersion)this._version, (VmodlContext)this._context);
            SoapHelper.outputBodyStart((XMLStreamWriter)xmlOut);
            this.writeRequestBody(marshaller, xmlOut);
            xmlOut.writeEndElement();
            xmlOut.writeEndElement();
            xmlOut.writeEndDocument();
            this.completeRequestWriter(writer, stream);
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException("Unsupported encoding completing request. UTF-8 support expected", e);
        }
        catch (XMLStreamException e) {
            throw new InternalException("Error writing request body", e);
        }
        finally {
            if (xmlOut != null) {
                try {
                    xmlOut.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
            if (loggingSplitter) {
                ((LoggingFilterOutputStream)stream).closeLog();
            }
        }
    }

    private void completeRequestWriter(Writer writer, OutputStream stream) throws UnsupportedEncodingException, IOException {
        if (this._signInfo != null) {
            MessageSigner.Factory.getInstance().signMessage(((StringWriter)writer).getBuffer(), this._signInfo, stream);
        }
    }

    private Writer createRequestWriter(OutputStream stream) throws UnsupportedEncodingException {
        if (this._requestContext != null) {
            this._signInfo = this._requestContext.getSignInfo();
        }
        if (this._signInfo == null) {
            return new OutputStreamWriter(stream, "utf-8");
        }
        return new StringWriter(5180);
    }

    protected abstract void writeRequestBody(Marshaller var1, XMLStreamWriter var2) throws XMLStreamException, MarshallException;

    protected ThisField createThisField() {
        return new ThisField(this._version);
    }
}

