/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.ApiFilter;
import emitters.Versions;
import emitters.model.MetaVersion;
import emitters.model.Version;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class PreviousReleaseAPIsFilter
extends ApiFilter {
    private Map<String, Set<Version>> _releasedVersions = new HashMap<String, Set<Version>>();

    @Override
    public boolean shouldEmit(Version version) {
        String serviceName = version.getService().name();
        Set<Version> prevReleased = this._releasedVersions.get(serviceName);
        if (prevReleased != null) {
            return prevReleased.contains(version);
        }
        Version.Kind kind = version.getKind();
        assert (kind == Version.Kind.LTS);
        return true;
    }

    PreviousReleaseAPIsFilter() {
        for (MetaVersion metaVersion2 : Versions.getMetaVersions()) {
            String serviceName = metaVersion2.getService().name();
            Version ltsVersion = metaVersion2.getReleaseVersions().get(0).ltsVersion();
            HashSet<Version> prevReleased = new HashSet<Version>(ltsVersion.getAllParents());
            this._releasedVersions.put(serviceName, prevReleased);
        }
    }
}

