/*
 * Decompiled with CFR 0.152.
 */
package emitters;

import emitters.model.VmodlObject;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import vmodl.Any;
import vmodl.DataObject;
import vmodl.DynamicArray;
import vmodl.DynamicData;
import vmodl.DynamicProperty;
import vmodl.ManagedObject;
import vmodl.ManagedObjectReference;
import vmodl.MethodFault;
import vmodl.RuntimeFault;
import vmodl.fault.ManagedObjectNotFound;

public class Utils {
    private static final String VERSION_DIGEST = "SHA-256";
    private static final String VMODL_CHARSET = "UTF-8";
    public static final String ObjectClassName = Object.class.getName();
    public static final String DataObjectClassName = DataObject.class.getName();
    public static final String DynamicDataClassName = DynamicData.class.getName();
    public static final String DynamicArrayClassName = DynamicArray.class.getName();
    public static final String DynamicPropertyClassName = DynamicProperty.class.getName();
    public static final String ManagedObjectClassName = ManagedObject.class.getName();
    public static final String ManagedObjectReferenceClassName = ManagedObjectReference.class.getName();
    public static final String MethodFaultClassName = MethodFault.class.getName();
    public static final String RuntimeFaultClassName = RuntimeFault.class.getName();
    public static final String ManagedObjectNotFoundClassName = ManagedObjectNotFound.class.getName();
    public static final String AnyClassName = Any.class.getName();

    public static StringBuilder capitalizeB(String s) {
        StringBuilder b = new StringBuilder(s);
        if (!Character.isUpperCase(s.charAt(0))) {
            b.setCharAt(0, Character.toUpperCase(b.charAt(0)));
        }
        return b;
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    public static String uncapitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static List<VmodlObject> sortObjects(Collection<VmodlObject> objects) {
        int i;
        int numObjects = objects.size();
        ArrayList<VmodlObject> sortedObjects = new ArrayList<VmodlObject>();
        int k = 0;
        ArrayList<VmodlObject> objList = new ArrayList<VmodlObject>();
        HashMap<String, Integer> objMap = new HashMap<String, Integer>();
        for (VmodlObject obj : objects) {
            objList.add(obj);
            objMap.put(obj.getQualifiedVmodlType(), k);
            ++k;
        }
        boolean[][] edges = new boolean[numObjects][];
        for (i = 0; i < numObjects; ++i) {
            edges[i] = new boolean[numObjects];
            for (int j = 0; j < numObjects; ++j) {
                edges[i][j] = false;
            }
        }
        for (i = 0; i < numObjects; ++i) {
            for (VmodlObject targetObj : ((VmodlObject)objList.get(i)).getHardDependencies()) {
                String targetName = targetObj.getQualifiedVmodlType();
                Integer target = (Integer)objMap.get(targetName);
                if (target == null) continue;
                int j = target;
                if (edges[j][i]) {
                    throw new RuntimeException("Circular dependency between " + targetName + " and " + ((VmodlObject)objList.get(i)).getClassName());
                }
                edges[i][j] = true;
            }
        }
        int count = 0;
        while (count < numObjects) {
            boolean found = false;
            for (int i2 = 0; i2 < numObjects; ++i2) {
                int j;
                if (objList.get(i2) == null) continue;
                boolean hasDependencies = false;
                for (j = 0; j < numObjects; ++j) {
                    if (!edges[i2][j]) continue;
                    hasDependencies = true;
                    break;
                }
                if (hasDependencies) continue;
                sortedObjects.add((VmodlObject)objList.get(i2));
                objList.set(i2, null);
                ++count;
                found = true;
                for (j = 0; j < numObjects; ++j) {
                    edges[j][i2] = false;
                }
            }
            if (found) continue;
            String errMsg = "Error: Circular dependency exists:";
            for (int i3 = 0; i3 < numObjects; ++i3) {
                if (objList.get(i3) == null) continue;
                errMsg = errMsg + " " + ((VmodlObject)objList.get(i3)).getClassName();
            }
            throw new RuntimeException(errMsg);
        }
        return sortedObjects;
    }

    public static Set<String> resolve(Set<String> src, String base) {
        if (base != null && base.length() > 0) {
            new File(base);
        }
        HashSet<String> dst = new HashSet<String>();
        for (String filename : src) {
            File file = new File(base, filename);
            try {
                filename = file.getCanonicalPath();
            }
            catch (IOException e) {
                filename = file.getAbsolutePath();
                System.err.println("Can't determine canonical path for '" + filename + "': " + e);
            }
            dst.add(filename);
        }
        return dst;
    }

    public static Set<String> discoverEmitFiles(String path) {
        final HashSet<String> result = new HashSet<String>();
        try {
            Files.walkFileTree(Paths.get(path, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String filePath = file.toString();
                    if (filePath.endsWith("java")) {
                        result.add(filePath);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public static MessageDigest initDigest() {
        try {
            return MessageDigest.getInstance(VERSION_DIGEST);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Message digest SHA-256 is not supported");
        }
    }

    public static void updateDigest(MessageDigest digest, String s) {
        try {
            digest.update(s.getBytes(VMODL_CHARSET));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported");
        }
    }
}

