/*
 * Decompiled with CFR 0.152.
 */
package emitters.bindings.csharp;

import emitters.Utils;
import emitters.Versions;
import emitters.VmodlEmitter;
import emitters.bindings.csharp.Common;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.ManagedProperty;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CsStubEmitter
extends VmodlEmitter {
    public static final String ROOT_NAMESAPCE = "VirtualInfrastructure";
    public static final String MANAGED_OBJECT_ROOT_TYPENAME = "ManagedObject";
    public static final String DATA_OBJECT_ROOT_TYPENAME = "DataObject";
    public static final String ARRAY_OBJECT_ROOT_TYPENAME = "ArrayObject";
    private static final String ASYNC_METHOD_RETURN_TYPENAME = "MethodInvocation";
    private static final String ASYNC_PROPERTY_RETURN_TYPENAME = "PropertyInvocation";
    public static final String ARRAY_TYPENAME_SUFFIX = "Array";
    public static final String CS_BINARY_TYPENAME = "Binary";
    private static final String ASYNC_METHOD_CALLBACK_TYPENAME = "MethodInvocationReturnHandler";
    private static final String ASYNC_PROPERTY_CALLBACK_TYPENAME = "PropertyInvocationReturnHandler";
    private static final String FILENAME_SEPARATOR = System.getProperty("file.separator");
    private LinkedList<VmodlObject> mClassesBeingEmitted;
    private Map<VmodlObject, String> mTypesEmitted;
    private List<VmodlObject> mEmittedList;
    private String _namemapDirPath = "";
    private String _mapClassName;
    private final String _filename;
    private String mCurrentNamespace;
    private String _configFile;
    private ClientConfig _clientConfig = new ClientConfig();
    private final List<CsSubEmitter> _subEmitter = new ArrayList<CsSubEmitter>();

    CsStubEmitter(Map<String, String> options, String filename) {
        String versionInfo;
        this._filename = filename;
        this._subEmitter.add(new CsNameMapEmitter(this, "NameMap"));
        this._subEmitter.add(new CsSoapMapEmitter(this, "SoapMap"));
        this._subEmitter.add(new CsReflectorEmitter(this, "ReflectorMap"));
        for (Map.Entry<String, String> entry : options.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!key.equals("type.support.dir")) continue;
            this._namemapDirPath = value;
            if (this._namemapDirPath.length() <= 0) continue;
            this._namemapDirPath = this._namemapDirPath + FILENAME_SEPARATOR;
        }
        this._configFile = options.get("configfile");
        if (this._configFile != null) {
            this._clientConfig = ClientConfig.fromFile(this._configFile);
        }
        if ((versionInfo = options.get("emit.versioninfo")) != null) {
            try {
                CsVersionEmitter ver = new CsVersionEmitter(this, versionInfo);
                this._subEmitter.add(ver);
            }
            catch (IOException ex) {
                System.err.print(ex.toString());
            }
        }
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        this.mEmittedList = new ArrayList<VmodlObject>();
        this.beginFile(this._filename);
        this.initSupportFileName();
        this.emitFileHeader();
        for (VmodlObject obj : objects) {
            this.emitBeginNamespace(obj);
            this.emitObject(obj);
            this.emitEndNamespace();
        }
        this.emitLine();
        this.endFile();
        for (CsSubEmitter emitter : this._subEmitter) {
            emitter.setMapClassName(this._mapClassName);
            emitter.emitObjects(this.mEmittedList);
        }
    }

    private void initSupportFileName() {
        String[] filenameSeparators = new String[]{FILENAME_SEPARATOR, "/"};
        String unqualifiedFilename = Common.lastWord(this._filename, filenameSeparators);
        this._mapClassName = Common.removeLastWord(unqualifiedFilename, ".").replaceAll("[^a-zA-Z_0-9]", "");
    }

    private String GetSupportFileName(String suffix) {
        return this._namemapDirPath + this._mapClassName + "." + suffix + ".cs";
    }

    void emitBeginNamespace(VmodlObject obj) {
        this.mCurrentNamespace = CsStubEmitter.csharpNamespaced(obj.getNamespace());
        this.emitLine("namespace ", this.mCurrentNamespace);
        this.emitLine("{");
        this.indent();
    }

    void emitEndNamespace() {
        this.unindent();
        this.emitLine("} // namespace ", this.mCurrentNamespace);
        this.emitLine();
        this.mCurrentNamespace = "";
    }

    public static String csharpNamespaced(String name) {
        if (name == null) {
            return null;
        }
        char[] chars = name.toCharArray();
        if (chars.length > 0) {
            chars[0] = Character.toUpperCase(chars[0]);
        }
        for (int i = 1; i < chars.length - 1; ++i) {
            if (chars[i] != '.' && chars[i] != '+') continue;
            chars[i + 1] = Character.toUpperCase(chars[i + 1]);
        }
        name = String.valueOf(chars);
        return name;
    }

    private void emitObject(VmodlObject obj) {
        String csName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.False, ReflectedTypenameFlag.True);
        this.mTypesEmitted.put(obj, csName);
        this.mEmittedList.add(obj);
        if (obj instanceof ManagedObject) {
            this.emitManagedObject((ManagedObject)obj);
        } else if (obj instanceof DataObject) {
            this.emitDataObject((DataObject)obj);
        } else if (obj instanceof Enum) {
            this.emitEnum((Enum)obj);
        } else {
            throw new RuntimeException("Unexpected object type");
        }
        this.emitArrayObject(obj);
    }

    private void emitArrayObject(VmodlObject obj) {
        String csTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Unqualified);
        String csArrTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Unqualified, ArrayTypenameFlag.True);
        String classDefnModifier = CsStubEmitter.csharpClassDefnModifier(obj);
        this.emitLine("[Serializable]");
        this.emitLine("public ", classDefnModifier, "class ", csArrTypeName, " : ", ARRAY_OBJECT_ROOT_TYPENAME);
        this.emitLine("{");
        this.indent();
        this.emitLine("public ", csArrTypeName, "() {}");
        this.emitLine("public ", csArrTypeName, "(int capacity): base(capacity) {}");
        this.emitLine("public ", csArrTypeName, "(", csTypeName, "[] c): base(c) {}");
        this.emitLine("public static implicit operator ", csArrTypeName, "(", csTypeName, "[] rhs) { ", "return new ", csArrTypeName, "(rhs); }");
        this.emitLine("public ", csTypeName, " this[int index] {");
        this.indent();
        this.emitLine("get { return (", csTypeName, ")GetElement(index); }");
        this.unindent();
        this.emitLine("}");
        this.emitLine("public void Append(", csTypeName, " item) {");
        this.indent();
        this.emitLine("base.Append(item);");
        this.unindent();
        this.emitLine("}");
        this.emitLine("public void Insert(int index, ", csTypeName, " val) {");
        this.indent();
        this.emitLine("base.Insert(index, val);");
        this.unindent();
        this.emitLine("}");
        this.emitLine("public void Remove(", csTypeName, " item) {");
        this.indent();
        this.emitLine("base.Remove(item);");
        this.unindent();
        this.emitLine("}");
        this.unindent();
        this.emitLine("} // class ", csArrTypeName);
    }

    private void emitFileHeader() {
        this.mClassesBeingEmitted = new LinkedList();
        this.mTypesEmitted = new HashMap<VmodlObject, String>();
        this.emitLine();
        this.emitLine("/******* WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
        this.emitLine();
        this.emitLine("using System;");
        this.emitLine("using System.Collections;");
        this.emitLine("using VirtualInfrastructure;");
        this.emitLine("using System.Xml.Serialization;");
        this.emitLine("using System.Runtime.Serialization;");
        this.emitLine();
    }

    private void emitClassHeader(VmodlObject obj, String interfaces) {
        this.mClassesBeingEmitted.addLast(obj);
        String name = CsStubEmitter.csharpTypeName(obj, NameQualification.Unqualified);
        VmodlObject baseObj = obj.getBaseObject();
        String factoryMethodModifier = "";
        String classDefnModifier = CsStubEmitter.csharpClassDefnModifier(obj);
        String baseName = this.csharpTypeName(baseObj);
        if (!CsStubEmitter.isBuiltin(baseObj)) {
            factoryMethodModifier = "new ";
        }
        this.emitLine("[Serializable, VmodlVersion(", CsStubEmitter.qq(obj.getVersion().getVmodlName()), ")]");
        this.emitPartial("public ", classDefnModifier, "partial class ", name, " : ", baseName);
        if (interfaces != null) {
            this.emitPartial(", ", interfaces);
        }
        this.emitLine(" {");
        this.indent();
        if (obj instanceof DataObject && !obj.isFault()) {
            this.emitLine("public static ", factoryMethodModifier, name, " NewInstance() {");
            this.indent();
            this.emitLine("return (", name, ")New(typeof(", name, "));");
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
    }

    private void emitClassFooter(VmodlObject obj) {
        String name = CsStubEmitter.csharpTypeName(obj, NameQualification.Unqualified);
        if (obj instanceof ManagedObject) {
            this.emitLine("protected internal ", name, "() {}");
        } else if (obj.isFault()) {
            this.emitLine("protected internal ", name, "() {}");
            this.emitLine("/// <remarks>");
            this.emitLine("/// Warning, this contructor is for prototyping only.");
            this.emitLine("/// </remarks>");
            this.emitLine("public ", name, "(string message) : base(message) {}");
            this.emitLine("protected ", name, "(string message, Exception inner) : base(message, inner) {}");
            this.emitLine("protected ", name, "(SerializationInfo info, StreamingContext context): base(info, context) {}");
        }
        this.unindent();
        this.emitLine("} // class ", name);
        this.emitLine();
        this.mClassesBeingEmitted.removeLast();
    }

    private void emitManagedObject(ManagedObject obj) {
        this.emitClassHeader(obj, null);
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
        }
        for (Property property : obj.getPropertyList()) {
            this.emitManagedPropertyAccessors((ManagedProperty)property, obj, InvocationMode.Blocking);
            this.emitManagedPropertyAccessors((ManagedProperty)property, obj, InvocationMode.Async);
        }
        for (Method method : obj.getMethodList()) {
            this.emitMethod(method, obj, InvocationMode.Blocking);
            this.emitMethod(method, obj, InvocationMode.Async);
        }
        this.emitClassFooter(obj);
    }

    private void emitManagedPropertyAccessors(ManagedProperty prop, VmodlObject obj, InvocationMode mode) {
        String csOwnerTypeName = this.mTypesEmitted.get(obj);
        VmodlDecl propDecl = prop.getDecl();
        String typeName = this.csharpTypeName(propDecl);
        boolean isReadonly = prop.isReadonly();
        String privId = prop.getPrivilegeId();
        boolean async = mode == InvocationMode.Async;
        String asyncDeclParam = async ? "PropertyInvocationReturnHandler h" : "";
        String asyncCallParam = async ? "h, " : "";
        String invokeReturn = async ? "return " : "object ret = ";
        String returnTypeName = async ? ASYNC_PROPERTY_RETURN_TYPENAME : typeName;
        String annotation = "[PropertyAccessor(" + CsStubEmitter.qq(prop.getName()) + ")" + (privId != null ? ", RequiresPrivilege(" + CsStubEmitter.qq(privId) + ")" : "") + (propDecl.isOptional() ? ", Optional" : "") + (async ? ", Async" : "") + "]";
        String vmodlMethodName = prop.getAccessor().getName();
        String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
        this.emitLine(annotation);
        this.emitLine("public ", returnTypeName, " ", csMethodName, "(", asyncDeclParam, ") {");
        this.indent();
        String csPropName = CsStubEmitter.propertyIdentifier(obj, prop);
        this.emitLine(invokeReturn, "InvokePropertyGet(", asyncCallParam, "VmomiSupport.MetaTypes." + csOwnerTypeName.replace('+', '.') + ".PropertyPath." + csPropName, ");");
        if (!async) {
            this.emitLine("return (", typeName, ")ret;");
        }
        this.unindent();
        this.emitLine("}");
        this.emitLine();
        if (!isReadonly) {
            vmodlMethodName = prop.getMutator().getName();
            csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
            if (async) {
                asyncDeclParam = ", " + asyncDeclParam;
            } else {
                invokeReturn = "";
                returnTypeName = "void";
            }
            this.emitLine(annotation);
            this.emitLine("public ", returnTypeName, " ", csMethodName, "(", typeName, " ", prop.getName(), asyncDeclParam, ") {");
            this.indent();
            this.emitLine("object[] parameters = new object[] { ", prop.getName(), " };");
            this.emitLine(invokeReturn, "InvokeMethod(", asyncCallParam, CsStubEmitter.qq(csMethodName), ", parameters);");
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
    }

    private void validateMethodParamVersions(Method method) {
        if (method.getQualifiedName().equals("vim.Folder.addStandaloneHost")) {
            return;
        }
        List<Parameter> params = method.getParameterList();
        Version lastVersion = method.getVersion();
        for (Parameter param : params) {
            Version version = param.getVersion();
            if (version != lastVersion && !Versions.isAncestor(version, lastVersion)) {
                String errorMessage = "Invalid Parameter ordering for method " + method.getQualifiedName() + " on parameter " + param.getName() + " its version is " + version.getVmodlName() + " its predecessor's version is " + lastVersion.getVmodlName();
                throw new RuntimeException(errorMessage);
            }
            lastVersion = version;
        }
    }

    private void emitMethod(Method method, VmodlObject obj, InvocationMode mode) {
        boolean async = mode == InvocationMode.Async;
        boolean task = method.isTask();
        String vmodlMethodName = method.getName();
        String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
        String csOwnerTypeName = this.mTypesEmitted.get(obj);
        VmodlDecl returnDecl = task ? Method.taskReturnDecl() : method.getReturnDecl();
        String returnTypeName = async ? ASYNC_METHOD_RETURN_TYPENAME : this.csharpTypeName(returnDecl);
        boolean returnIsVoid = returnDecl.isVoid();
        if (!async) {
            this.validateMethodParamVersions(method);
        }
        String asyncHandlerParamName = "h";
        ArrayList oParams = new ArrayList();
        ArrayList oParamNames = new ArrayList();
        ArrayList<String> annotations = new ArrayList<String>();
        ArrayList<Version> oVersions = new ArrayList<Version>();
        oVersions.add(method.getVersion());
        for (Parameter param : method.getParameterList()) {
            Version version = param.getVersion();
            CsStubEmitter.insertVersion(oVersions, version);
        }
        for (int i = 0; i < oVersions.size(); ++i) {
            oParamNames.add(new ArrayList());
            oParams.add(new ArrayList());
        }
        List<Parameter> paramList = method.getParameterList();
        for (int pIndex = 0; pIndex < paramList.size(); ++pIndex) {
            Parameter param = paramList.get(pIndex);
            Version version = param.getVersion();
            VmodlDecl paramDecl = param.getDecl();
            String privId = param.getPrivilegeId();
            String annotation = "";
            String paramName = CsStubEmitter.csharpParamIdentifier(param);
            if (paramDecl.isOptional()) {
                annotations.add("Optional");
            }
            if (privId != null) {
                annotations.add("RequiresPrivilege(" + CsStubEmitter.qq(privId) + ")");
            }
            if (annotations.size() > 0) {
                annotation = "[" + CsStubEmitter.join(annotations, ", ") + "] ";
            }
            annotations.clear();
            String sParam = annotation + this.csharpTypeName(paramDecl) + " " + paramName;
            for (int i = 0; i < oVersions.size(); ++i) {
                Version vPos = (Version)oVersions.get(i);
                if (vPos == version || Versions.isAncestor(vPos, version)) {
                    ((List)oParamNames.get(i)).add(paramName);
                    ((List)oParams.get(i)).add(sParam);
                    continue;
                }
                if (!async && pIndex == paramList.size() - 1) {
                    ((List)oParamNames.get(i)).add("(" + this.csharpTypeName(paramDecl) + ")null");
                    continue;
                }
                ((List)oParamNames.get(i)).add("null");
            }
        }
        Version methodVersion = method.getVersion();
        String privId = method.getPrivilegeId();
        boolean differentVersion = false;
        if (obj.getVersion() != methodVersion) {
            differentVersion = true;
        }
        for (int overload = 0; overload < oVersions.size(); ++overload) {
            Version version = (Version)oVersions.get(overload);
            List params = (List)oParams.get(overload);
            List paramNames = (List)oParamNames.get(overload);
            int paramCount = params.size();
            if (async) {
                params.add("MethodInvocationReturnHandler " + asyncHandlerParamName);
            }
            if (privId != null) {
                annotations.add("RequiresPrivilege(" + CsStubEmitter.qq(privId) + ")");
            }
            if (async) {
                annotations.add("Async");
            }
            if (oVersions.size() > 1) {
                this.emitLine("// Overloaded: " + version.getVmodlName());
            }
            if (differentVersion && paramCount == paramList.size()) {
                annotations.add("VmodlVersion(" + CsStubEmitter.qq(methodVersion.getVmodlName()) + ")");
            }
            if (annotations.size() > 0) {
                this.emitLine("[", CsStubEmitter.join(annotations, ", "), "]");
            }
            this.emitLine("public ", returnTypeName, " ", csMethodName, "(", CsStubEmitter.join(params, ", "), ") {");
            this.indent();
            if (paramCount == paramList.size()) {
                String asyncCallParam = async ? asyncHandlerParamName + ", " : "";
                this.emitLine("object[] parameters = new object[] { ", CsStubEmitter.join(paramNames, ", "), " };");
                String methodReturn = "";
                if (async) {
                    methodReturn = "return ";
                } else if (!returnIsVoid) {
                    methodReturn = "object ret = ";
                }
                this.emitLine(methodReturn, "InvokeMethod(", asyncCallParam, "VmomiSupport.MetaTypes." + csOwnerTypeName.replace('+', '.') + "." + csMethodName, ", parameters);");
                if (!returnIsVoid && !async) {
                    this.emitLine("return (", returnTypeName, ")ret;");
                }
            } else {
                String methodReturn = "";
                if (async) {
                    methodReturn = "return ";
                    paramNames.add(asyncHandlerParamName);
                } else if (!returnIsVoid) {
                    methodReturn = "return ";
                }
                this.emitLine(methodReturn, csMethodName + "(", CsStubEmitter.join(paramNames, ", "), ");");
            }
            this.unindent();
            this.emitLine("}");
            this.emitLine();
            annotations.clear();
        }
    }

    private void emitDataObject(DataObject obj) {
        String interfaces = null;
        if (obj.hasKey()) {
            interfaces = "Identifiable";
        }
        this.emitClassHeader(obj, interfaces);
        for (VmodlObject nestedObj : obj.getNestedList()) {
            this.emitObject(nestedObj);
        }
        this.emitDataProperties(obj);
        this.emitClassFooter(obj);
    }

    private void emitDataProperties(DataObject obj) {
        VmodlDecl propDecl;
        Version objVersion = obj.getVersion();
        for (Property prop : obj.getPropertyList()) {
            propDecl = prop.getDecl();
            String name = CsStubEmitter.propertyIdentifier(obj, prop);
            String fieldName = "m" + name;
            String typeName = this.csharpTypeName(propDecl);
            ArrayList<String> annotations = new ArrayList<String>();
            Version version = prop.getVersion();
            annotations.add("FilteredAs(" + CsStubEmitter.qq(prop.getName()) + ")");
            if (propDecl.isOptional()) {
                annotations.add("Optional");
            }
            if (propDecl.isLink()) {
                annotations.add("Link");
            }
            if (propDecl.isLinkable()) {
                annotations.add("Linkable");
            }
            if (version != objVersion) {
                annotations.add("VmodlVersion(" + CsStubEmitter.qq(version.getVmodlName()) + ")");
            }
            this.emitLine("[", CsStubEmitter.join(annotations, ", "), "]");
            if (prop.isReadonly()) {
                this.emitLine("/// <remarks>");
                this.emitLine("/// Warning, this property is a readonly property in vmodl.");
                this.emitLine("/// </remarks>");
            }
            this.emitLine("public ", typeName, " ", name, " {");
            this.indent();
            this.emitLine("get { return ", fieldName, "; }");
            this.emitLine("set { ", fieldName, " = value; }");
            this.unindent();
            this.emitLine("}");
            this.emitLine();
        }
        for (Property prop : obj.getPropertyList()) {
            propDecl = prop.getDecl();
            String typeName = this.csharpTypeName(propDecl);
            String defaultAssgn = CsStubEmitter.csharpDefaultValue(propDecl);
            String fieldName = "m" + CsStubEmitter.propertyIdentifier(obj, prop);
            if (defaultAssgn.length() > 0) {
                defaultAssgn = " = " + defaultAssgn;
            }
            this.emitLine("protected ", typeName, " ", fieldName, defaultAssgn, ";");
        }
    }

    private List<String> getSortedEnumValues(Enum obj) {
        String qualifiedTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified);
        List<String> values = obj.getValueList();
        List<Version> versions = obj.getValueVersionList();
        ArrayList<Version> vSorted = new ArrayList<Version>();
        Version ver5 = Versions.getVersion("vim.version.version5");
        Version target = Versions.getTargetVersion();
        int n = values.size();
        for (int i = 0; i < n; ++i) {
            Version ver = versions.get(i);
            if (Versions.isAncestor(ver, ver5) && ver != ver5) continue;
            versions.set(i, null);
        }
        for (Version v : versions) {
            CsStubEmitter.insertVersion(vSorted, v);
        }
        ClientConfig.EnumInsert insertSet = this._clientConfig.getEnumInsert(qualifiedTypeName);
        ArrayList<String> sortedValues = new ArrayList<String>();
        for (Version v : vSorted) {
            for (int i = 0; i < n; ++i) {
                if (v != versions.get(i) || v != null && !target.isAncestor(v)) continue;
                String val = values.get(i);
                if (insertSet != null && insertSet.hasValue(val).booleanValue()) continue;
                sortedValues.add(val);
                if (insertSet == null) continue;
                while (val != null) {
                    String valAfter = insertSet.get(val);
                    if (valAfter != null) {
                        sortedValues.add(valAfter);
                    }
                    val = valAfter;
                }
            }
        }
        return sortedValues;
    }

    protected void emitList(List<String> list, String sep, boolean endLine) {
        boolean first = true;
        for (String elt : list) {
            if (!first) {
                this.emitPartial(sep);
            }
            this.emitPartial(elt);
            if (endLine) {
                this.emitLine();
            }
            first = false;
        }
    }

    private void emitEnum(Enum obj) {
        String typeName = this.csharpTypeName(obj);
        this.emitLine("public enum ", typeName, " {");
        this.indent();
        List<String> sortedValues = this.getSortedEnumValues(obj);
        for (int i = 0; i < sortedValues.size(); ++i) {
            sortedValues.set(i, CsStubEmitter.capitalize(sortedValues.get(i)));
        }
        this.emitList(sortedValues, ", ", true);
        this.emitLine();
        this.unindent();
        this.emitLine("}");
        this.emitLine();
    }

    public static String csharpDefaultValue(VmodlDecl d) {
        if (d.isArray() || d.isOptional()) {
            return "null";
        }
        switch (d.getTypeId()) {
            case BOOLEAN: {
                return "false";
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                return "-1";
            }
            case FLOAT: {
                return "0.0F";
            }
            case DOUBLE: {
                return "0.0";
            }
            case STRING: {
                return CsStubEmitter.qq("");
            }
            case TYPENAME: 
            case METHODNAME: 
            case PROPPATH: 
            case ANY: 
            case DATA: 
            case MANAGED: {
                return "null";
            }
            case ENUM: {
                return "0";
            }
            case DATETIME: {
                return "DateTime.Now";
            }
        }
        return "";
    }

    public static String propertyIdentifier(VmodlObject propProvider, Property prop) {
        String name = CsStubEmitter.capitalize(prop.getName());
        boolean adornTheName = false;
        if (propProvider.isFault() && (name.equals("HelpLink") || name.equals("InnerException") || name.equals("Message") || name.equals("Source") || name.equals("StackTrace") || name.equals("TargetSite") || name.equals("Data"))) {
            adornTheName = true;
        } else if (Common.containsNestedTypeOfName(propProvider, name)) {
            adornTheName = true;
        } else if (name.equals(CsStubEmitter.csharpTypeName(propProvider, NameQualification.Unqualified))) {
            adornTheName = true;
        } else if (name.equals("PropertyPath")) {
            adornTheName = true;
        }
        if (adornTheName) {
            name = name + "_";
        }
        return name;
    }

    private static String csharpParamIdentifier(Parameter param) {
        String name = param.getName();
        if (name.equals("params") || name.equals("in")) {
            name = name + "_";
        }
        return name;
    }

    public static String csharpMethodIdentifier(String name) {
        if ((name = CsStubEmitter.capitalize(name)).equals("GetType") || name.equals("ToString") || name.equals("Equals") || name.equals("GetHashCode")) {
            name = name + "_";
        }
        return name;
    }

    private static String csharpClassDefnModifier(VmodlObject obj) {
        String classDefnModifier = "";
        if (Common.conflictingContainerNestedType(obj) != null) {
            classDefnModifier = classDefnModifier + "new ";
        }
        return classDefnModifier;
    }

    private static boolean containsPropertyOfName(VmodlObject obj, String name) {
        if (obj == null) {
            return false;
        }
        for (Property prop : obj.getPropertyList()) {
            if (!name.equals(CsStubEmitter.propertyIdentifier(obj, prop))) continue;
            return true;
        }
        return CsStubEmitter.containsPropertyOfName(obj.getBaseObject(), name);
    }

    private static boolean classNameConflictsWithSomeInheritedContainerMember(VmodlObject obj) {
        VmodlObject container = obj.getContainer();
        VmodlObject containerBase = container == null ? null : container.getBaseObject();
        return CsStubEmitter.containsPropertyOfName(containerBase, obj.getClassName());
    }

    public static String qualifyOnlyAsNecessary(String typeName, VmodlObject obj, String enclosingNamespace, VmodlObject enclosingClass) {
        typeName = enclosingClass != null && obj.getContainer() == enclosingClass ? Common.lastWord(typeName, ".") : Common.relativePath(enclosingNamespace, typeName, ".");
        return typeName;
    }

    public static String csharpTypeName(VmodlObject obj, NameQualification qualType, ArrayTypenameFlag arrayNameFlag, ReflectedTypenameFlag reflectedNameFlag) {
        String typeName = "";
        String vmodlTypeName = obj.getQualifiedVmodlType();
        if (vmodlTypeName.equals(Utils.ManagedObjectClassName)) {
            typeName = MANAGED_OBJECT_ROOT_TYPENAME;
        } else if (vmodlTypeName.equals(Utils.DataObjectClassName)) {
            typeName = DATA_OBJECT_ROOT_TYPENAME;
        } else if (CsStubEmitter.isBuiltin(obj)) {
            typeName = obj.getClassName();
        } else {
            switch (qualType) {
                case Unqualified: {
                    typeName = CsStubEmitter.capitalize(obj.getClassName());
                    break;
                }
                case Qualified: {
                    String targetNamespace = obj.getNamespace();
                    typeName = typeName + (targetNamespace.length() > 0 ? targetNamespace + "." : "");
                    String nestedClassResolver = reflectedNameFlag == ReflectedTypenameFlag.True ? "+" : ".";
                    typeName = typeName + (obj.getContainer() != null ? CsStubEmitter.join(obj.getContainerNameList(), nestedClassResolver) + nestedClassResolver : "");
                    typeName = CsStubEmitter.csharpNamespaced(typeName + obj.getClassName());
                }
            }
        }
        if (CsStubEmitter.classNameConflictsWithSomeInheritedContainerMember(obj)) {
            typeName = typeName + "_";
        }
        if (arrayNameFlag == ArrayTypenameFlag.True) {
            typeName = typeName + ARRAY_TYPENAME_SUFFIX;
        }
        return typeName;
    }

    public static String systemTypeName(VmodlDecl d, boolean optionalFlag) {
        String typeName;
        if (d.isEnum()) {
            return null;
        }
        boolean isValueType = false;
        switch (d.getTypeId()) {
            case BOOLEAN: {
                typeName = "bool";
                isValueType = true;
                break;
            }
            case BYTE: {
                typeName = "sbyte";
                isValueType = true;
                break;
            }
            case SHORT: {
                typeName = "short";
                isValueType = true;
                break;
            }
            case INT: {
                typeName = "int";
                isValueType = true;
                break;
            }
            case LONG: {
                typeName = "long";
                isValueType = true;
                break;
            }
            case FLOAT: {
                typeName = "float";
                isValueType = true;
                break;
            }
            case DOUBLE: {
                typeName = "double";
                isValueType = true;
                break;
            }
            case DATETIME: {
                typeName = "DateTime";
                isValueType = true;
                break;
            }
            case STRING: {
                typeName = "string";
                break;
            }
            case TYPENAME: {
                typeName = "Type";
                break;
            }
            case METHODNAME: {
                typeName = "MethodName";
                break;
            }
            case PROPPATH: {
                typeName = "PropertyPath";
                break;
            }
            case URI: {
                typeName = "Uri";
                break;
            }
            case BINARY: {
                typeName = CS_BINARY_TYPENAME;
                break;
            }
            case ANY: {
                typeName = "object";
                break;
            }
            case VOID: {
                typeName = "void";
                break;
            }
            case MANAGED: {
                if (d.getObject() == null) {
                    return MANAGED_OBJECT_ROOT_TYPENAME;
                }
            }
            default: {
                return null;
            }
        }
        if (isValueType && d.isOptional() && !d.isArray() && optionalFlag) {
            typeName = typeName + "?";
        }
        return typeName;
    }

    private String csharpTypeName(VmodlDecl d, ArrayTypenameFlag arrayNameFlag) {
        String typeName = null;
        if (d.isArray() && arrayNameFlag == ArrayTypenameFlag.True) {
            typeName = CsStubEmitter.capitalize(this.csharpTypeName(d, ArrayTypenameFlag.False));
            typeName = typeName + ARRAY_TYPENAME_SUFFIX;
            return typeName;
        }
        typeName = CsStubEmitter.systemTypeName(d, true);
        if (typeName == null) {
            typeName = this.csharpTypeName(d.getObject());
            if (d.isEnum() && d.isOptional() && !d.isArray()) {
                typeName = typeName + "?";
            }
        }
        return typeName;
    }

    private String csharpTypeName(VmodlObject obj) {
        String typeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.False);
        VmodlObject enclosingClass = this.mClassesBeingEmitted.size() > 0 ? this.mClassesBeingEmitted.getLast() : null;
        return CsStubEmitter.qualifyOnlyAsNecessary(typeName, obj, this.mCurrentNamespace, enclosingClass);
    }

    public static String csharpTypeName(VmodlObject obj, NameQualification qualType, ArrayTypenameFlag arrayNameFlag) {
        return CsStubEmitter.csharpTypeName(obj, qualType, arrayNameFlag, ReflectedTypenameFlag.False);
    }

    public static String csharpTypeName(VmodlObject obj, NameQualification qualType) {
        return CsStubEmitter.csharpTypeName(obj, qualType, ArrayTypenameFlag.False, ReflectedTypenameFlag.False);
    }

    static String arrayTypeName(String typeName) {
        typeName = CsStubEmitter.capitalize(typeName);
        typeName = typeName + ARRAY_TYPENAME_SUFFIX;
        return typeName;
    }

    public static String getCsharpTypeName(VmodlDecl d, ArrayTypenameFlag arrayNameFlag, ReflectedTypenameFlag reflectedNameFlag) {
        VmodlObject obj = d.getObject();
        String typeName = null;
        if (!d.isArray()) {
            arrayNameFlag = ArrayTypenameFlag.False;
        }
        if (obj != null) {
            typeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, arrayNameFlag, reflectedNameFlag);
        } else {
            typeName = CsStubEmitter.systemTypeName(d, !d.isArray());
            if (arrayNameFlag == ArrayTypenameFlag.True) {
                typeName = "VirtualInfrastructure." + CsStubEmitter.capitalize(typeName) + ARRAY_TYPENAME_SUFFIX;
            }
        }
        return typeName;
    }

    private String csharpTypeName(VmodlDecl d) {
        return this.csharpTypeName(d, ArrayTypenameFlag.True);
    }

    public static class ClientConfig {
        private Map<String, EnumInsert> _enumInsert = new HashMap<String, EnumInsert>();

        private Element serialize(Document doc) {
            Element config = doc.createElement("ClientConfig");
            for (Map.Entry<String, EnumInsert> insert : this._enumInsert.entrySet()) {
                Element enumItem = doc.createElement("EnumInsert");
                enumItem.setAttribute("enumName", insert.getKey());
                config.appendChild(enumItem);
                insert.getValue().serialize(doc, enumItem);
            }
            return config;
        }

        static ClientConfig fromNode(Node root) {
            ClientConfig config = new ClientConfig();
            NodeList nodes = root.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (!"EnumInsert".equals(nodeName)) continue;
                Element elm = (Element)node;
                String enumName = elm.getAttribute("enumName");
                EnumInsert enumInsert = EnumInsert.fromNode(elm);
                config._enumInsert.put(enumName, enumInsert);
            }
            return config;
        }

        public void toXmlFile(String xmlFile) {
            try {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = fact.newDocumentBuilder();
                Document doc = builder.newDocument();
                doc.appendChild(this.serialize(doc));
                DOMSource source = new DOMSource(doc);
                FileWriter stringWriter = new FileWriter(xmlFile);
                StreamResult result = new StreamResult(stringWriter);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(source, result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }

        public static ClientConfig fromFile(String xmlFile) {
            try {
                DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = fact.newDocumentBuilder();
                Document doc = builder.parse(xmlFile);
                Element root = doc.getDocumentElement();
                return ClientConfig.fromNode(root);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new ClientConfig();
        }

        public void addEnumValue(String enumName, String insertAfter, String value) {
            EnumInsert enumInsert = this._enumInsert.get(enumName);
            if (enumInsert == null) {
                enumInsert = new EnumInsert();
                this._enumInsert.put(enumName, enumInsert);
            }
            enumInsert.add(insertAfter, value);
        }

        public EnumInsert getEnumInsert(String enumName) {
            EnumInsert ret = this._enumInsert.get(enumName);
            return ret;
        }

        public static class EnumInsert {
            private Map<String, String> _insertValueAfter = new HashMap<String, String>();
            private Set<String> _values = new HashSet<String>();

            public void add(String insertAfter, String value) {
                this._insertValueAfter.put(insertAfter, value);
                this._values.add(value);
            }

            public String get(String insertAfter) {
                return this._insertValueAfter.get(insertAfter);
            }

            public Boolean hasValue(String value) {
                return this._values.contains(value);
            }

            void serialize(Document doc, Element node) {
                for (Map.Entry<String, String> insert : this._insertValueAfter.entrySet()) {
                    Element enumValue = doc.createElement("EnumValue");
                    enumValue.setAttribute("insertAfter", insert.getKey());
                    enumValue.setAttribute("value", insert.getValue());
                    node.appendChild(enumValue);
                }
            }

            static EnumInsert fromNode(Node node) {
                EnumInsert insert = new EnumInsert();
                NodeList nodes = node.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node childNode = nodes.item(i);
                    if (!"EnumValue".equals(childNode.getNodeName())) continue;
                    Element elm = (Element)childNode;
                    String insertAfter = elm.getAttribute("insertAfter");
                    String value = elm.getAttribute("value");
                    insert.add(insertAfter, value);
                }
                return insert;
            }
        }
    }

    static class CsVersionEmitter
    extends CsSubEmitter {
        private static final String MAP_NAMESPACE_NAME = "VISoap.Support";

        CsVersionEmitter(CsStubEmitter csEmitter, String fileName) throws IOException {
            super(csEmitter, fileName);
        }

        @Override
        public void emitObjects(List<VmodlObject> allObjects) {
            String fileName = this.getNamemapDirPath();
            fileName = fileName + this._suffix + ".cs";
            this.beginFile(fileName);
            this.emitLine();
            this.emitLine("/******* WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
            this.emitLine();
            this.emitLine("using System;");
            this.emitLine();
            this.emitLine("namespace VISoap.Support {");
            this.indent();
            String className = this._suffix;
            Version targetVersion = Versions.getTargetVersion();
            String serviceId = targetVersion.getWireNs();
            String versionId = targetVersion.getWireId();
            this.emitLine("public class ", className, " {");
            this.indent();
            this.emitLine("public const string SoapServiceId = \"", serviceId, "\";");
            this.emitLine("public const string SoapVersionId = \"", versionId, "\";");
            this.unindent();
            this.emitLine("} // ", className);
            this.unindent();
            this.emitLine("} // VISoap.Support");
            this.endFile();
        }
    }

    static class CsReflectorEmitter
    extends CsSubEmitter {
        private static final String MAP_NAMESPACE_NAME = "VmomiSupport.Reflection";

        CsReflectorEmitter(CsStubEmitter csEmitter, String suffix) {
            super(csEmitter, suffix);
        }

        @Override
        public void emitObjects(List<VmodlObject> allObjects) {
            int objId;
            this.beginFile(this.getFileName());
            this.emitFileHeader();
            this.emitLine("public class ReflectorMap" + this._mapClassName + " : IReflectorDefinition {");
            this.indent();
            this.emitLine("private ReflectorMap" + this._mapClassName + "() {}");
            this.emitLine();
            this.emitLine("public static readonly IReflectorDefinition Instance = new ReflectorMap" + this._mapClassName + "();");
            this.emitLine();
            this.emitLine("public void Define(IReflector r) {");
            this.indent();
            for (objId = 1; objId <= allObjects.size(); ++objId) {
                String typeId = Integer.toString(objId);
                this.emitLine("Define", typeId, "(r);");
            }
            this.unindent();
            this.emitLine("}");
            objId = 0;
            for (VmodlObject obj : allObjects) {
                String typeId = Integer.toString(++objId);
                String objTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.False);
                this.emitLine("#region Define " + objTypeName);
                this.emitLine();
                this.emitLine("private static void Define", typeId, "(IReflector r) {");
                this.indent();
                this.reflectorEmitObject(obj, objTypeName, typeId);
                this.reflectorEmitObjectConstructor(obj, objTypeName, typeId);
                this.reflectorEmitArrayConstructor(obj, typeId);
                this.unindent();
                this.emitLine("}");
                this.emitLine();
                this.reflectorEmitObjectAccessors(obj, objTypeName, typeId);
                this.reflectorEmitObjectConstructorMethod(obj, objTypeName, typeId);
                this.reflectorEmitArrayConstructorMethod(obj, typeId);
                this.emitLine();
                this.emitLine("#endregion // Define " + objTypeName);
            }
            this.unindent();
            this.emitLine("}");
            this.emitFileFooter();
            this.endFile();
        }

        private void emitFileHeader() {
            this.emitLine();
            this.emitLine("/******* WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
            this.emitLine();
            this.emitLine("using System;");
            this.emitLine("using System.Collections;");
            this.emitLine("using System.Collections.Generic;");
            this.emitLine("using VirtualInfrastructure;");
            this.emitLine("using System.Xml.Serialization;");
            this.emitLine("using VirtualInfrastructure.Utils;");
            this.emitLine();
            this.emitLine("namespace VmomiSupport.Reflection {");
        }

        private void emitFileFooter() {
            this.unindent();
            this.emitLine("} // VmomiSupport.Reflection");
        }

        private void reflectorEmitObject(VmodlObject obj, String objTypeName, String typeId) {
            if (obj instanceof DataObject) {
                this.reflectorEmitDataProperties((DataObject)obj, objTypeName, typeId);
            }
        }

        private void reflectorEmitObjectAccessors(VmodlObject obj, String objectTypeName, String typeId) {
            if (obj instanceof DataObject) {
                this.reflectorEmitDataPropertiesAccessors((DataObject)obj, objectTypeName, typeId);
            }
        }

        private void reflectorEmitArrayConstructor(VmodlObject obj, String typeId) {
            if (obj instanceof DataObject || obj instanceof ManagedObject || obj instanceof Enum) {
                String objTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.True);
                this.emitLine("r.AddArrayConstructor(");
                this.emitLine("  typeof(", objTypeName, "), ");
                this.emitLine("  CreateArrayOf", typeId);
                this.emitLine(");");
            }
        }

        private void reflectorEmitArrayConstructorMethod(VmodlObject obj, String typeId) {
            if (obj instanceof DataObject || obj instanceof ManagedObject || obj instanceof Enum) {
                String objTypeName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.True);
                this.emitLine("private static object CreateArrayOf", typeId, "(int capacity)");
                this.emitLine("{ return new ", objTypeName, "(capacity); }");
            }
        }

        private void reflectorEmitDataProperties(DataObject obj, String objTypeName, String typeId) {
            if (!obj.hasProperties()) {
                return;
            }
            this.emitLine("ReflectorFieldInfo field = null;");
            this.emitLine("List<ReflectorFieldInfo> fields = null;");
            this.emitLine("Type type = typeof(", objTypeName, ");");
            this.emitLine("fields = new List<ReflectorFieldInfo>(", Integer.toString(obj.getPropertiesCount()), ");");
            for (Property prop : obj.getPropertyList()) {
                String wsdlName = prop.getName();
                String name = CsStubEmitter.propertyIdentifier(obj, prop);
                String methodName = typeId + "__" + name;
                this.emitLine("field = new ReflectorFieldInfo(", CsReflectorEmitter.qq(wsdlName), ", Get", methodName, ", Set", methodName, ");");
                this.emitLine("fields.Add(field);");
            }
            this.emitLine("r.AddFields(type, fields);");
        }

        private void reflectorEmitDataPropertiesAccessors(DataObject obj, String objTypeName, String typeId) {
            if (!obj.hasProperties()) {
                return;
            }
            for (Property prop : obj.getPropertyList()) {
                VmodlDecl propDecl = prop.getDecl();
                String name = CsStubEmitter.propertyIdentifier(obj, prop);
                String typeName = CsStubEmitter.getCsharpTypeName(propDecl, ArrayTypenameFlag.True, ReflectedTypenameFlag.False);
                String methodName = typeId + "__" + name;
                this.emitLine("private static object Get", methodName, "(object src)");
                this.emitLine("{ return ((", objTypeName, ")src).", name, "; }");
                this.emitLine("private static void Set", methodName, "(object dst, object fieldValue)");
                this.emitLine("{ ((", objTypeName, ")dst).", name, " = (", typeName, ")fieldValue; }");
            }
        }

        private void reflectorEmitObjectConstructor(VmodlObject obj, String objTypeName, String typeId) {
            if (obj instanceof DataObject || obj instanceof ManagedObject) {
                this.emitLine("r.AddConstructor(");
                this.emitLine("  typeof(", objTypeName, "), ");
                this.emitLine("  Create", typeId);
                this.emitLine(");");
            }
        }

        private void reflectorEmitObjectConstructorMethod(VmodlObject obj, String objTypeName, String typeId) {
            if (obj instanceof DataObject || obj instanceof ManagedObject) {
                this.emitLine("private static object Create", typeId, "()");
                this.emitLine(" { return new ", objTypeName, "(); }");
            }
        }
    }

    static class CsNameMapEmitter
    extends CsSubEmitter {
        private static final String MAP_NAMESPACE_NAME = "VmomiSupport.NamemapSetters";
        private static final String MAP_INITIALIZER_NAME = "PopulateCsToVmodlMaps";

        CsNameMapEmitter(CsStubEmitter csEmitter, String suffix) {
            super(csEmitter, suffix);
        }

        @Override
        public void emitObjects(List<VmodlObject> allObjects) {
            this.beginFile(this.getFileName());
            this.emitFileHeader();
            this.beginCsToVmodlMap();
            for (VmodlObject obj : allObjects) {
                this.emitObject(obj);
            }
            this.endCsToVmodlMap();
            this.emitFileFooter();
            this.endFile();
        }

        private void emitObject(VmodlObject obj) {
            String csName = this.getTypeName(obj);
            this.emitLine("types[", CsNameMapEmitter.qq(csName), "] = ", CsNameMapEmitter.qq(obj.getQualifiedVmodlType()), ";");
            if (obj instanceof ManagedObject) {
                this.emitManagedObject((ManagedObject)obj);
            } else if (!(obj instanceof DataObject)) {
                if (obj instanceof Enum) {
                    this.emitEnum((Enum)obj);
                } else {
                    throw new RuntimeException("Unexpected object type");
                }
            }
        }

        private void emitFileHeader() {
            this.emitLine();
            this.emitLine("/******* WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
            this.emitLine();
            this.emitLine("using VirtualInfrastructure.Utils;");
            this.emitLine();
            this.emitLine("namespace VmomiSupport.NamemapSetters {");
            this.emitLine("public class " + this._mapClassName);
            this.emitLine("{");
            this.indent();
        }

        private void beginCsToVmodlMap() {
            this.emitLine("public static void PopulateCsToVmodlMaps(String2String types, String2String methods, String2StringArray enums) {");
            this.indent();
        }

        private void endCsToVmodlMap() {
            this.unindent();
            this.emitLine("} // PopulateCsToVmodlMaps");
        }

        private void emitFileFooter() {
            this.unindent();
            this.emitLine("} // " + this._mapClassName);
            this.emitLine();
            this.unindent();
            this.emitLine("} // VmomiSupport.NamemapSetters");
        }

        private void emitManagedObject(ManagedObject obj) {
            for (Property property : obj.getPropertyList()) {
                this.emitManagedPropertyAccessors((ManagedProperty)property, obj);
            }
            for (Method method : obj.getMethodList()) {
                this.emitMethod(method, obj);
            }
        }

        private void emitManagedPropertyAccessors(ManagedProperty prop, VmodlObject obj) {
            String vmodlOwnerTypeName = obj.getQualifiedVmodlType();
            String csOwnerTypeName = this.getTypeName(obj);
            boolean isReadonly = prop.isReadonly();
            String vmodlMethodName = prop.getAccessor().getName();
            String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
            if (!csMethodName.equals(vmodlMethodName)) {
                this.emitLine("methods[" + CsNameMapEmitter.qq(csOwnerTypeName + "." + csMethodName) + "] = " + CsNameMapEmitter.qq(vmodlOwnerTypeName + "." + vmodlMethodName) + ";");
            }
            if (!isReadonly && !(csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName = prop.getMutator().getName())).equals(vmodlMethodName)) {
                this.emitLine("methods[" + CsNameMapEmitter.qq(csOwnerTypeName + "." + csMethodName) + "] = " + CsNameMapEmitter.qq(vmodlOwnerTypeName + "." + vmodlMethodName) + ";");
            }
        }

        private void emitMethod(Method method, VmodlObject obj) {
            String vmodlMethodName = method.getName();
            String csOwnerTypeName = this.getTypeName(obj);
            String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
            String vmodlOwnerTypeName = obj.getQualifiedVmodlType();
            if (!Utils.uncapitalize(csMethodName).equals(vmodlMethodName)) {
                this.emitLine("methods[" + CsNameMapEmitter.qq(csOwnerTypeName + "." + csMethodName) + "] = " + CsNameMapEmitter.qq(vmodlOwnerTypeName + "." + vmodlMethodName) + ";");
            }
        }

        private void emitEnum(Enum obj) {
            String csReflectedName = this.getTypeName(obj);
            List<String> values = this.getSortedEnumValues(obj);
            this.emitLine("enums[" + CsNameMapEmitter.qq(csReflectedName) + "] = new string[] { " + CsNameMapEmitter.qq(CsNameMapEmitter.join(values, CsNameMapEmitter.qq(", "))) + " };");
        }
    }

    static class CsSoapMapEmitter
    extends CsSubEmitter {
        private static final String MAP_NAMESPACE_NAME = "VISoap.Support";

        CsSoapMapEmitter(CsStubEmitter csEmitter, String suffix) {
            super(csEmitter, suffix);
        }

        @Override
        public void emitObjects(List<VmodlObject> allObjects) {
            this.beginFile(this.getFileName());
            this.emitFileHeader();
            this.beginSoapToCsMap();
            String className = "SoapNameMap" + this._mapClassName;
            this.emitLine("public class " + className + " : ISoapMappingInitializer {");
            this.indent();
            this.emitLine();
            this.emitLine("public static ISoapMappingInitializer Instance = new ", className, "();");
            this.emitLine();
            this.emitLine("public Assembly VmodlAssembly { get { return GetType().Assembly; } }");
            this.emitLine();
            this.emitLine("public void FillNameMap(ISoapNameMap map) {");
            this.indent();
            for (VmodlObject obj : allObjects) {
                this.emitObject(obj);
            }
            this.unindent();
            this.emitLine("} // ApplyNameMap");
            this.emitLine();
            this.emitLine("public void FillMethodMap(ISoapMethodMap map) {");
            this.indent();
            for (VmodlObject obj : allObjects) {
                this.emitMethods(obj);
            }
            this.unindent();
            this.emitLine("} // ApplyNameMap");
            this.unindent();
            this.emitLine("} // ", className);
            this.emitLine();
            this.endSoapToCsMap();
            this.emitFileFooter();
            this.endFile();
        }

        private void emitFileHeader() {
            this.emitLine();
            this.emitLine("/******* WARNING - AUTO GENERATED CODE - DO NOT EDIT ********/");
            this.emitLine();
            this.emitLine("using System;");
            this.emitLine("using VirtualInfrastructure.Utils;");
            this.emitLine("using VirtualInfrastructure.Soap.Interfaces;");
            this.emitLine("using VI = VirtualInfrastructure;");
            this.emitLine("using System.Reflection;");
            this.emitLine();
            this.emitLine("namespace VISoap.Support {");
        }

        private void beginSoapToCsMap() {
        }

        private void endSoapToCsMap() {
        }

        private void emitFileFooter() {
            this.emitLine("} // VISoap.Support");
        }

        private void emitObject(VmodlObject obj) {
            if (obj == null) {
                return;
            }
            String csName = CsStubEmitter.csharpTypeName(obj, NameQualification.Qualified, ArrayTypenameFlag.False, ReflectedTypenameFlag.False);
            String soapType = obj.getWsdlName();
            if (obj instanceof DataObject || obj instanceof Enum || obj instanceof ManagedObject) {
                this.emitLine("map.AddTypeMap(typeof(", csName, "), \"", soapType, "\");");
            }
        }

        private void emitMethods(VmodlObject obj) {
            if (obj instanceof ManagedObject) {
                ManagedObject managedObject = (ManagedObject)obj;
                for (Method method : managedObject.getMethodList()) {
                    this.emitManagedMethod(method, managedObject);
                }
            }
        }

        private void emitManagedMethod(Method method, VmodlObject obj) {
            String vmodlMethodName = method.getName();
            String csMethodName = CsStubEmitter.csharpMethodIdentifier(vmodlMethodName);
            String csOwnerTypeName = this.getTypeName(obj);
            String wsdlName = method.getWsdlName();
            this.emitLine("map.AddMethod(", CsSoapMapEmitter.qq(csOwnerTypeName + "." + csMethodName), ", ", CsSoapMapEmitter.qq(wsdlName), ");");
        }
    }

    static abstract class CsSubEmitter
    extends VmodlEmitter {
        private final CsStubEmitter _csEmitter;
        protected final String _suffix;
        protected String _mapClassName;

        CsSubEmitter(CsStubEmitter csEmitter, String suffix) {
            this._csEmitter = csEmitter;
            this._suffix = suffix;
        }

        public void setMapClassName(String name) {
            this._mapClassName = name;
        }

        protected String getFileName() {
            return this._csEmitter.GetSupportFileName(this._suffix);
        }

        protected String getTypeName(VmodlObject obj) {
            return (String)this._csEmitter.mTypesEmitted.get(obj);
        }

        protected String getNamemapDirPath() {
            return this._csEmitter._namemapDirPath;
        }

        protected List<String> getSortedEnumValues(Enum obj) {
            return this._csEmitter.getSortedEnumValues(obj);
        }
    }

    static enum ReflectedTypenameFlag {
        False,
        True;

    }

    static enum InvocationMode {
        Blocking,
        Async;

    }

    static enum NameQualification {
        Qualified,
        Unqualified;

    }

    static enum ArrayTypenameFlag {
        False,
        True;

    }
}

