/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.joap;

import emitters.doc.JavadocLinkResolver;
import emitters.generators.joap.OpenAPILinkResolver;
import emitters.model.DataProperty;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.VmodlApi;
import emitters.model.VmodlObject;

class OpenAPIEveLinkResolver
extends OpenAPILinkResolver {
    private final String _baseOperationPath;

    OpenAPIEveLinkResolver(String baseOperationPath) {
        this._baseOperationPath = baseOperationPath;
    }

    @Override
    protected String getNonOperationDestination(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (element == null) {
            return null;
        }
        if (context == JavadocLinkResolver.LinkContext.DISABLED) {
            return "";
        }
        StringBuilder relative = OpenAPIEveLinkResolver.getBasePath(context);
        if (element instanceof ManagedObject) {
            relative.append(OpenAPIEveLinkResolver.toTag(this.getId(element)));
        } else {
            if (element instanceof DataProperty) {
                element = ((DataProperty)element).getContainer();
            }
            if (!(element instanceof VmodlObject)) {
                throw new IllegalArgumentException(element.getClass().getName());
            }
            relative.append("data-structures/").append(this.getWireId(element));
            if (element instanceof Enum) {
                relative.append("/enum");
            }
            relative.append('/');
        }
        return relative.toString();
    }

    private static CharSequence toTag(CharSequence id) {
        int length = id.length();
        if (length == 0) {
            return id;
        }
        StringBuilder result = new StringBuilder().append(Character.toLowerCase(id.charAt(0)));
        for (int i = 1; i < length; ++i) {
            char c = id.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append('-').append(Character.toLowerCase(c));
                continue;
            }
            result.append(c);
        }
        return result;
    }

    @Override
    protected String getOperationDestination(VmodlApi container, VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (context == JavadocLinkResolver.LinkContext.DISABLED) {
            return "";
        }
        return OpenAPIEveLinkResolver.getBasePath(context).append(this._baseOperationPath).append(this.getId(container)).append('/').append("moId").append('/').append(this.getId(element)).append('/').append(this.getHttpMethod(element)).toString();
    }

    private static StringBuilder getBasePath(JavadocLinkResolver.LinkContext context) {
        StringBuilder result = new StringBuilder();
        switch (context) {
            case MANAGED_OBJECT: {
                result.append("../");
                break;
            }
            case METHOD_PARAMS: 
            case DATA_OBJECT: {
                result.append("../../");
                break;
            }
            case ENUM: {
                result.append("../../../");
                break;
            }
            case MANAGED_METHOD: 
            case MANAGED_PROPERTY: {
                result.append("../../../../../../../");
                break;
            }
            default: {
                throw new RuntimeException("Unexpected link context: " + (Object)((Object)context));
            }
        }
        return result;
    }

    @Override
    protected String getLabel(VmodlApi element, JavadocLinkResolver.LinkContext context) {
        if (element instanceof Enum) {
            return this.getWireId(element) + "Enum";
        }
        return super.getLabel(element, context);
    }
}

