/*
 * Decompiled with CFR 0.152.
 */
package emitters.generators.vmodl;

import emitters.ApiFilter;
import emitters.ObjectRegistry;
import emitters.Services;
import emitters.Utils;
import emitters.VmodlEmitter;
import emitters.model.DataObject;
import emitters.model.Enum;
import emitters.model.ManagedObject;
import emitters.model.Method;
import emitters.model.Parameter;
import emitters.model.Property;
import emitters.model.Version;
import emitters.model.VmodlApi;
import emitters.model.VmodlDecl;
import emitters.model.VmodlObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import vmodl.dynamic;
import vmodl.internal;
import vmodl.internalBefore;
import vmodl.link;
import vmodl.linkable;
import vmodl.localizable;
import vmodl.map;
import vmodl.optional;
import vmodl.privilege;
import vmodl.readonly;
import vmodl.secret;
import vmodl.service;
import vmodl.sessionSpecific;
import vmodl.set;
import vmodl.silent;
import vmodl.subprivilege;
import vmodl.subprivileges;
import vmodl.supportsManagedObjectsOf;
import vmodl.task;
import vmodl.undocumented;
import vmodl.versionDef;
import vmodl.versionedSupertype;
import vmodl.versionedSupertypes;
import vmodl.wsdlName;

public class SourceEmitter
extends VmodlEmitter {
    private static final String VERSION_KIND_PREFIX = versionDef.Kind.class.getCanonicalName() + ".";
    private static final String VERSION_KIND_FEATURE = VERSION_KIND_PREFIX + versionDef.Kind.FEATURE;
    private static final String VERSION_KIND_MILESTONE = VERSION_KIND_PREFIX + versionDef.Kind.MILESTONE;
    private static final String VERSION_KIND_LTS = VERSION_KIND_PREFIX + versionDef.Kind.LTS;
    private final Map<String, Config> _configMap = new HashMap<String, Config>();
    private final String _originalFolder;
    private final String _folderExt;
    private final VmodlObject _managedObject;
    private final VmodlObject _dataObject;
    private final VmodlObject _dynamicData;
    private String _folder;
    private ApiFilter _filter;
    private boolean _isBaseline;
    private Set<Version> _versionSet;
    private static final String FOLDER_EXT = "folder.ext";
    private static final String FLAVOR = "flavor";
    private static final String BASELINE = "baseline";
    private static final String RELEASED = "released";

    public SourceEmitter(Map<String, String> options, String folder) {
        this._originalFolder = folder;
        this._folderExt = options.get(FOLDER_EXT);
        String rawFlavorOption = options.get(FLAVOR);
        if (rawFlavorOption == null) {
            rawFlavorOption = RELEASED;
        }
        for (String flavor : rawFlavorOption.split(":")) {
            this._configMap.put(flavor, new Config(flavor));
        }
        this._managedObject = ObjectRegistry.getObject(Utils.ManagedObjectClassName);
        this._dataObject = ObjectRegistry.getObject(Utils.DataObjectClassName);
        this._dynamicData = ObjectRegistry.getObject(Utils.DynamicDataClassName);
    }

    @Override
    public void emitObjects(List<VmodlObject> objects) {
        for (Map.Entry<String, Config> entry : this._configMap.entrySet()) {
            this._folder = this._originalFolder + File.separator + entry.getKey();
            if (this._folderExt != null) {
                this._folder = this._folder + File.separator + this._folderExt;
            }
            Config config = entry.getValue();
            this._filter = config._apiFilter;
            this._isBaseline = config._isBaseline;
            this._versionSet = new TreeSet<Version>(new Comparator<Version>(){

                @Override
                public int compare(Version lhs, Version rhs) {
                    return lhs.getNamespace().compareTo(rhs.getNamespace());
                }
            });
            for (VmodlObject obj : objects) {
                if (!this._filter.shouldEmit(obj)) continue;
                this.beginFileForObject(obj);
                this.dispatchEmitObject(obj, true);
                this.endFile();
            }
            this.emitVersions();
        }
    }

    private void emitVersions() {
        for (Version version : this._versionSet) {
            this.emitPackageInfo(Services.getService(version), version.getNamespace());
            Set<Version> allVersionsOfNs = version.getAllParents();
            allVersionsOfNs.addAll(version.getAllChildren());
            allVersionsOfNs.add(version);
            for (Version ver : allVersionsOfNs) {
                if (!this._filter.shouldEmit(ver)) continue;
                this.beginFileForVersion(ver);
                this.emitVersion(ver);
                this.endFile();
            }
        }
    }

    private String getVersionKind(Version version) {
        switch (version.getKind()) {
            case FEATURE: {
                return VERSION_KIND_FEATURE;
            }
            case MILESTONE: {
                return VERSION_KIND_MILESTONE;
            }
            case LTS: {
                return VERSION_KIND_LTS;
            }
        }
        throw new RuntimeException("Unsupported version kind: " + version.getVmodlName());
    }

    private void emitVersion(Version version) {
        this.emitLine("package " + version.getPackage() + ";");
        this.emitGap();
        this.emitLine("@" + versionDef.class.getCanonicalName() + "(", INDENT);
        this.emitLine("id = \"" + version.getSimpleName() + "\",");
        this.emitLine("kind = " + this.getVersionKind(version) + ",");
        this.emitLine("wsdlName = \"" + version.getWireNs() + "\",");
        this.emitLine("versionId = \"" + version.getWireId() + "\",");
        this.emitLine("displayName = \"" + version.getDisplayName() + "\",");
        supportsManagedObjectsOf supportedMOs = version.getSupportedMO();
        if (supportedMOs != null) {
            String[] mos = supportedMOs.value();
            ArrayList<String> outMOs = new ArrayList<String>();
            this.emitPartial("supportedMO = ");
            this.emitPartial(this.makeAnnotation(supportsManagedObjectsOf.class) + "({");
            for (String mo : mos) {
                outMOs.add("\"" + mo + "\"");
            }
            this.emitJoin(outMOs, ",");
            this.emitLine("}),");
        }
        Set<Version> parents = version.getDirectParents();
        TreeSet<String> asStrings = new TreeSet<String>();
        for (Version parent : parents) {
            if (!this._filter.shouldEmit(parent)) continue;
            asStrings.add("\"" + parent.getVmodlName() + "\"");
        }
        if (asStrings.size() != 0) {
            String compatibleVersions = "{ " + SourceEmitter.join(asStrings, ", ") + " }";
            this.emitLine("compatible = " + compatibleVersions);
        }
        this.emitLine(UNINDENT, ")");
        this.emitLine("public @interface " + version.getSimpleName() + " {}");
    }

    private void emitMo(ManagedObject obj, boolean topLevel) {
        this.emitHeader(obj, "interface", "extends", topLevel);
        this.emitLine("{", INDENT);
        this.emitNestedObjects(obj);
        this.emitProperties(obj, true);
        this.emitMethods(obj);
        this.emitLine(UNINDENT, "}");
    }

    private void emitMethods(ManagedObject obj) {
        TreeSet<Method> methods = new TreeSet<Method>(new MethodComparator());
        methods.addAll(obj.getMethodList());
        for (Method meth : methods) {
            if (!this._filter.shouldEmit(meth)) continue;
            this.emitGap();
            this.emitAnnotations(meth);
            this.emitPartial(this.vmodlTypeName(meth.getReturnDecl()));
            List<Parameter> params = meth.getParameterList();
            String methodHeader = " " + meth.getName() + "(";
            if (params.size() != 0) {
                this.emitLine(methodHeader);
            } else {
                this.emitPartial(methodHeader);
            }
            this.indent();
            this.indent();
            boolean needComma = false;
            for (Parameter param : meth.getParameterList()) {
                if (!this._filter.shouldEmit(param)) continue;
                if (needComma) {
                    this.emitLine(",");
                }
                this.emitAnnotations(param);
                this.emitPartial(this.vmodlTypeName(param.getDecl()));
                this.emitPartial(" ");
                this.emitPartial(param.getName());
                needComma = true;
            }
            this.emitLine(")");
            ArrayList<String> faults = new ArrayList<String>();
            for (VmodlObject vmodlObject : meth.getFaultList()) {
                if (!this._filter.shouldEmit(vmodlObject)) continue;
                faults.add(vmodlObject.getQualifiedVmodlType());
            }
            if (faults.size() != 0) {
                this.emitPartial("throws ");
                this.emitJoin(faults, ", ");
            }
            this.emitLine(";");
            this.unindent();
            this.unindent();
        }
    }

    private void emitEnum(Enum obj, boolean topLevel) {
        this.emitHeader(obj, "enum", null, topLevel);
        this.emitLine("{", INDENT);
        List<Version> vers = obj.getValueVersionList();
        List<String> values = obj.getValueList();
        for (int i = 0; i < values.size(); ++i) {
            Version ver = vers.get(i);
            if (ver != null && !this._filter.shouldEmit(ver)) continue;
            if (ver != null) {
                this.emitPartial(this.makeAnnotation(ver.getVmodlName()));
                this.emitPartial(" ");
            }
            this.emitLine(values.get(i) + ",");
        }
        this.emitLine(UNINDENT, "}");
    }

    private void emitDo(DataObject obj, boolean topLevel) {
        this.emitHeader(obj, "class", "extends", topLevel);
        this.emitLine("{", INDENT);
        this.emitNestedObjects(obj);
        this.emitProperties(obj, false);
        this.emitLine(UNINDENT, "}");
    }

    private void emitNestedObjects(VmodlObject obj) {
        TreeSet<VmodlObject> nestedObjects = new TreeSet<VmodlObject>(new VmodlObjectComparator());
        nestedObjects.addAll(obj.getNestedList());
        for (VmodlObject nested : nestedObjects) {
            if (!this._filter.shouldEmit(nested)) continue;
            this.dispatchEmitObject(nested, false);
        }
    }

    private void emitProperties(VmodlObject obj, boolean isManaged) {
        for (Property prop : obj.getPropertyListWithOverrides()) {
            if (!this._filter.shouldEmit(prop)) continue;
            this.emitGap();
            this.emitAnnotations(prop);
            this.emitPartial(this.vmodlTypeName(prop.getDecl()));
            this.emitPartial(" " + prop.getName());
            if (isManaged) {
                this.emitLine("();");
                continue;
            }
            this.emitLine(";");
        }
    }

    private void emitAnnotations(Parameter param) {
        String privilege;
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this._isBaseline && (privilege = param.getPrivilegeId()) != null) {
            this.addPrivilege(annotations, privilege);
        }
        VmodlDecl decl = param.getDecl();
        this.emitAnnotationsVmodlDecl(annotations, decl);
        if (decl.isOptional()) {
            annotations.add(this.makeAnnotation(param.getVersion().getVmodlName()));
        }
        annotations.add("");
        this.emitJoin(annotations, " ");
    }

    private void emitAnnotations(Property prop) {
        String privilege;
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this._isBaseline && (privilege = prop.getPrivilegeId()) != null) {
            this.addPrivilege(annotations, privilege);
        }
        if (prop.isReadonly()) {
            annotations.add(this.makeAnnotation(readonly.class));
        }
        this.emitAnnotationsVmodlDecl(annotations, prop.getDecl());
        this.emitAnnotationsVmodlApi(annotations, prop);
        this.emitJoin(annotations, "\n");
    }

    private void emitAnnotations(Method meth) {
        Map<String, String> subPrivs;
        ArrayList<String> annotations = new ArrayList<String>();
        if (!this._isBaseline) {
            String privilege = meth.getPrivilegeId();
            if (privilege == null && meth.isDynamicPrivs()) {
                privilege = "dynamic";
            }
            if (privilege != null) {
                this.addPrivilege(annotations, privilege);
            }
        }
        if ((subPrivs = meth.getSubclassPrivileges()) != null && subPrivs.size() != 0) {
            annotations.add("@" + subprivileges.class.getCanonicalName() + "({");
            for (Map.Entry<String, String> entry : subPrivs.entrySet()) {
                String subpriv = "     @" + subprivilege.class.getCanonicalName() + "(";
                subpriv = subpriv + "className = \"" + entry.getKey() + "\", ";
                subpriv = subpriv + "privilegeId = \"" + entry.getValue() + "\"";
                subpriv = subpriv + "),";
                annotations.add(subpriv);
            }
            annotations.add("})");
        }
        String wsdl = meth.getWsdlName();
        if (meth.isTask()) {
            wsdl = wsdl.substring(0, wsdl.lastIndexOf("_Task"));
        }
        annotations.add(this.makeParametrizedAnnotation(wsdlName.class, wsdl));
        if (meth.isTask()) {
            annotations.add(this.makeAnnotation(task.class));
        }
        if (meth.isDeprecated()) {
            annotations.add(this.makeAnnotation("Deprecated"));
        }
        this.emitAnnotationsVmodlDecl(annotations, meth.getReturnDecl());
        this.emitAnnotationsVmodlApi(annotations, meth);
        this.emitJoin(annotations, "\n");
    }

    private void emitAnnotations(VmodlObject obj, boolean isDynamic) {
        List<VmodlObject.SuperTypePair> superTypes;
        ArrayList<String> annotations = new ArrayList<String>();
        if (isDynamic) {
            annotations.add(this.makeAnnotation(dynamic.class));
        }
        if ((superTypes = obj.getVersionedSuperTypes()) != null) {
            annotations.add(this.makeAnnotation(versionedSupertypes.class) + "({");
            for (VmodlObject.SuperTypePair pair : superTypes) {
                String superType = "    " + this.makeAnnotation(versionedSupertype.class) + "(";
                superType = superType + "version = " + pair.version.getVmodlName() + ".class, ";
                superType = superType + "baseClass = " + pair.object.getQualifiedVmodlType() + ".class";
                superType = superType + "),";
                annotations.add(superType);
            }
            annotations.add("})");
        }
        annotations.add(this.makeParametrizedAnnotation(wsdlName.class, obj.getWsdlName()));
        this.emitAnnotationsVmodlApi(annotations, obj);
        if (obj.getKind() == VmodlObject.Kind.ManagedObject && ((ManagedObject)obj).isSessionSpecific()) {
            annotations.add(this.makeAnnotation(sessionSpecific.class));
        }
        this.emitJoin(annotations, "\n");
    }

    private void addPrivilege(List<String> annotations, String privilege2) {
        annotations.add(this.makeParametrizedAnnotation(privilege.class, privilege2));
    }

    private void emitAnnotationsVmodlDecl(List<String> annotations, VmodlDecl decl) {
        if (decl.isSet()) {
            annotations.add(this.makeAnnotation(set.class));
        }
        if (decl.isMap()) {
            annotations.add(this.makeAnnotation(map.class));
        }
        if (decl.isSecret()) {
            annotations.add(this.makeAnnotation(secret.class));
        }
        if (decl.isOptional()) {
            annotations.add(this.makeAnnotation(optional.class));
        }
        if (decl.isSilent()) {
            annotations.add(this.makeAnnotation(silent.class));
        }
        if (decl.isLink()) {
            annotations.add(this.makeAnnotation(link.class));
        }
        if (decl.isLinkable()) {
            annotations.add(this.makeAnnotation(linkable.class));
        }
        if (decl.isLocalizable()) {
            annotations.add(this.makeAnnotation(localizable.class));
        }
    }

    private void emitAnnotationsVmodlApi(List<String> annotations, VmodlApi api) {
        Version ib;
        if (api.isInternal()) {
            annotations.add(this.makeAnnotation(internal.class));
        }
        if ((ib = api.getInternalBefore()) != null) {
            annotations.add(this.makeRawParamAnnotation(internalBefore.class, ib.getVmodlName() + ".class"));
        }
        if (api.isUndocumented()) {
            annotations.add(this.makeAnnotation(undocumented.class));
        }
        Version version = api.getVersion();
        annotations.add(this.makeAnnotation(version.getVmodlName()));
        this._versionSet.add(version);
    }

    private String makeParametrizedAnnotation(Class<?> annotation, String param) {
        return this.makeAnnotation(annotation.getCanonicalName() + "(\"" + param + "\")");
    }

    private String makeRawParamAnnotation(Class<?> annotation, String param) {
        return this.makeAnnotation(annotation.getCanonicalName() + "(" + param + ")");
    }

    private String makeAnnotation(String str) {
        return "@" + str;
    }

    private String makeAnnotation(Class<?> cls) {
        return "@" + cls.getCanonicalName();
    }

    private void emitPackageInfo(service service2, String ns) {
        this.beginFile(ns.replace('.', '/') + "/package-info");
        this.emitPartial("@" + service.class.getCanonicalName() + "(");
        this.emitPartial("name=\"" + service2.name() + "\", ");
        this.emitPartial("namespace=\"" + service2.namespace() + "\"");
        this.emitLine(")");
        this.emitLine("package " + ns + ";");
        this.endFile();
    }

    private void dispatchEmitObject(VmodlObject obj, boolean topLevel) {
        switch (obj.getKind()) {
            case DataObject: {
                this.emitDo((DataObject)obj, topLevel);
                break;
            }
            case Enum: {
                this.emitEnum((Enum)obj, topLevel);
                break;
            }
            case ManagedObject: {
                this.emitMo((ManagedObject)obj, topLevel);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected VmodlObject Kind");
            }
        }
    }

    private String vmodlTypeName(VmodlDecl decl) {
        String typeName;
        switch (decl.getTypeId()) {
            case BOOLEAN: {
                typeName = "boolean";
                break;
            }
            case BYTE: {
                typeName = "byte";
                break;
            }
            case SHORT: {
                typeName = "short";
                break;
            }
            case INT: {
                typeName = "int";
                break;
            }
            case LONG: {
                typeName = "long";
                break;
            }
            case FLOAT: {
                typeName = "float";
                break;
            }
            case DOUBLE: {
                typeName = "double";
                break;
            }
            case STRING: {
                typeName = "String";
                break;
            }
            case DATETIME: {
                typeName = "vmodl.DateTime";
                break;
            }
            case TYPENAME: {
                typeName = "vmodl.TypeName";
                break;
            }
            case METHODNAME: {
                typeName = "vmodl.MethodName";
                break;
            }
            case PROPPATH: {
                typeName = "vmodl.PropertyPath";
                break;
            }
            case URI: {
                typeName = "vmodl.URI";
                break;
            }
            case BINARY: {
                typeName = "vmodl.Binary";
                break;
            }
            case ANY: {
                typeName = "vmodl.Any";
                break;
            }
            case VOID: {
                typeName = "void";
                break;
            }
            case ENUM: {
                VmodlObject enumobj = decl.getObject();
                typeName = enumobj.getQualifiedVmodlType();
                break;
            }
            case MANAGED: {
                VmodlObject moobj = decl.getObject();
                if (moobj != null) {
                    typeName = moobj.getQualifiedVmodlType();
                    break;
                }
                typeName = vmodl.ManagedObject.class.getCanonicalName();
                break;
            }
            case DATA: {
                VmodlObject obj = decl.getObject();
                if (obj != null) {
                    typeName = obj.getQualifiedVmodlType();
                    break;
                }
                typeName = vmodl.DataObject.class.getCanonicalName();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected object type : " + (Object)((Object)decl.getTypeId()));
            }
        }
        if (decl.isArray()) {
            typeName = typeName + "[]";
        }
        return typeName;
    }

    private void emitHeader(VmodlObject obj, String decltype, String inheritance, boolean topLevel) {
        String pub = "static public ";
        if (topLevel) {
            this.emitLine("package " + obj.getPackage() + ";");
            pub = "public ";
        }
        this.emitGap();
        boolean isDynamic = false;
        if (obj.getKind() == VmodlObject.Kind.DataObject && ((DataObject)obj).hasDynamicProperties()) {
            isDynamic = true;
        }
        this.emitAnnotations(obj, isDynamic);
        this.emitLine(pub + decltype + " " + obj.getName());
        VmodlObject baseObj = obj.getBaseObject();
        if (baseObj != null && baseObj != this._managedObject && baseObj != this._dataObject && baseObj != this._dynamicData) {
            this.emitLine("        " + inheritance + " " + obj.getBaseObject().getQualifiedVmodlType());
        }
    }

    private void beginFileForObject(VmodlObject obj) {
        this.beginFile(obj.getQualifiedVmodlType().replace('.', '/'));
    }

    private void beginFileForVersion(Version ver) {
        this.beginFile(ver.getVmodlName().replace('.', '/'));
    }

    @Override
    protected void beginFile(String filename) {
        super.beginFile(this._folder + '/' + filename + ".java");
    }

    private void emitJoin(List<String> toEmit, String sep) {
        if (sep.equals("\n")) {
            for (String str : toEmit) {
                this.emitLine(str);
            }
        } else {
            String joined = SourceEmitter.join(toEmit, sep);
            this.emitPartial(joined);
        }
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method lhs, Method rhs) {
            return lhs.getWsdlName().compareTo(rhs.getWsdlName());
        }
    }

    private static class VmodlObjectComparator
    implements Comparator<VmodlObject> {
        private VmodlObjectComparator() {
        }

        @Override
        public int compare(VmodlObject lhs, VmodlObject rhs) {
            return lhs.getClassName().compareTo(rhs.getClassName());
        }
    }

    private class Config {
        ApiFilter _apiFilter;
        boolean _isBaseline;

        Config(String flavor) {
            if (flavor.equals(SourceEmitter.BASELINE)) {
                this._apiFilter = ApiFilter.getReleasedAPIsFilter();
                this._isBaseline = true;
            } else if (flavor.equals(SourceEmitter.RELEASED)) {
                this._apiFilter = ApiFilter.getReleasedAPIsFilter();
                this._isBaseline = false;
            } else {
                throw new RuntimeException("Unknown flavor: \"" + flavor + "\"");
            }
        }
    }
}

