/*
 * Decompiled with CFR 0.152.
 */
package emitters.model.raw;

import emitters.Versions;
import emitters.core.SyntaxException;
import emitters.model.MetaVersion;
import emitters.model.Version;
import emitters.model.raw.RawElement;
import emitters.model.raw.ReleaseInNamespace;
import vmodl.feature;
import vmodl.releasedFeature;

public abstract class RawVersion
extends RawElement {
    protected String _versionTag;

    public Version getVersion() {
        String versionTag = this.getVersionTag();
        ReleaseInNamespace releaseInNs = this.getReleaseInNamespace();
        feature feature2 = this.getFeature();
        releasedFeature releasedFeature2 = this.getReleasedFeature();
        boolean isLegacy = this.isLegacy();
        if (versionTag != null || releaseInNs != null) {
            if (feature2 != null || releasedFeature2 != null || isLegacy) {
                throw SyntaxException.at(this.getSourcePos(), "Mixed release-related annotations", new Object[0]);
            }
            if (releaseInNs != null && versionTag != null) {
                throw SyntaxException.at(this.getSourcePos(), "Mixed @versionX and @released tags", new Object[0]);
            }
            return releaseInNs != null ? releaseInNs.getVersion() : Versions.getVersion(versionTag);
        }
        if (feature2 == null && releasedFeature2 == null && !isLegacy) {
            return null;
        }
        if ((feature2 != null || releasedFeature2 != null) && isLegacy || feature2 != null && releasedFeature2 != null) {
            throw SyntaxException.at(this.getSourcePos(), "Tagged with multiple dev versions", new Object[0]);
        }
        String context = this.getContext();
        MetaVersion metaVersion2 = Versions.getMetaVersion(context);
        if (metaVersion2 == null) {
            throw SyntaxException.at(this.getSourcePos(), "No meta version for %s", context);
        }
        if (isLegacy) {
            return metaVersion2.getDisabledVersion();
        }
        if (releasedFeature2 != null) {
            Version syntheticBase2 = metaVersion2.getSyntheticBase();
            if (syntheticBase2 == null) {
                throw SyntaxException.at(this.getSourcePos(), "No synthetic base for %s", context);
            }
            syntheticBase2.setUsed();
            return syntheticBase2;
        }
        String featureName = feature2.value();
        Version version = metaVersion2.getFeatureVersion(featureName);
        if (version == null) {
            throw SyntaxException.at(this.getSourcePos(), "Unknown feature: %s", featureName);
        }
        version.setUsed();
        return version;
    }

    protected abstract String getVersionTag();

    protected abstract ReleaseInNamespace getReleaseInNamespace();

    protected abstract feature getFeature();

    protected abstract releasedFeature getReleasedFeature();

    protected abstract boolean isLegacy();

    protected abstract String getContext();

    protected void processAnnotation(String annotationName) {
        if (annotationName.startsWith("vmodl.") && annotationName.indexOf(46, 6) == -1) {
            return;
        }
        if (!Versions.isVersion(annotationName)) {
            return;
        }
        if (annotationName.equals("vmodl.version.version0")) {
            throw SyntaxException.at(this.getSourcePos(), "%s can only be implicit", "vmodl.version.version0");
        }
        if (this._versionTag != null) {
            throw SyntaxException.at(this.getSourcePos(), "Multiple version annotations: %s and %s", this._versionTag, annotationName);
        }
        this._versionTag = annotationName;
    }
}

